/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   constraint.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_CONSTRAINT_H
#define UHDM_CONSTRAINT_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "constraint_item_group.h"


namespace UHDM {


class constraint final : public BaseClass {
  UHDM_IMPLEMENT_RTTI(constraint, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: constraint();
  virtual ~constraint() final = default;

  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final {
    vpiParent_ = data;
    return true;
  }

  virtual bool VpiFile(std::string_view data) final;

  virtual std::string_view VpiFile() const final;

  virtual uint32_t UhdmId() const final { return uhdmId_; }

  virtual bool UhdmId(uint32_t data) final {
    uhdmId_ = data;
    return true;
  }

  virtual bool VpiName(std::string_view data) final;

  virtual std::string_view VpiName() const final;

  bool VpiFullName(std::string_view data);

  std::string_view VpiFullName() const;

  bool VpiVirtual() const { return vpiVirtual_; }

  bool VpiVirtual(bool data) {
    vpiVirtual_ = data;
    return true;
  }

  bool VpiAutomatic() const { return vpiAutomatic_; }

  bool VpiAutomatic(bool data) {
    vpiAutomatic_ = data;
    return true;
  }

  int32_t VpiAllocScheme() const { return vpiAllocScheme_; }

  bool VpiAllocScheme(int32_t data) {
    vpiAllocScheme_ = data;
    return true;
  }

  int32_t VpiAccessType() const { return vpiAccessType_; }

  bool VpiAccessType(int32_t data) {
    vpiAccessType_ = data;
    return true;
  }

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) {
    attributes_ = data;
    return true;
  }

  bool VpiIsConstraintEnabled() const { return vpiIsConstraintEnabled_; }

  bool VpiIsConstraintEnabled(bool data) {
    vpiIsConstraintEnabled_ = data;
    return true;
  }

  VectorOfany* Constraint_items() const { return constraint_items_; }

  bool Constraint_items(VectorOfany* data) {
    if (!constraint_item_groupGroupCompliant(data)) return false;
    constraint_items_ = data;
    return true;
  }

  virtual uint32_t VpiType() const final { return vpiConstraint; }

  virtual constraint* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int32_t type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int32_t property) const override;

  virtual int32_t Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmconstraint; }

protected:
  void DeepCopy(constraint* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  BaseClass* vpiParent_ = nullptr;

  SymbolId vpiFile_;

  uint32_t uhdmId_ = 0;

  SymbolId vpiName_;

  SymbolId vpiFullName_;

  bool vpiVirtual_ = false;

  bool vpiAutomatic_ = false;

  int32_t vpiAllocScheme_ = 0;

  int32_t vpiAccessType_ = 0;

  VectorOfattribute* attributes_ = nullptr;

  bool vpiIsConstraintEnabled_ = false;

  VectorOfany* constraint_items_ = nullptr;
};


typedef FactoryT<constraint> constraintFactory;


typedef FactoryT<std::vector<constraint *>> VectorOfconstraintFactory;

}  // namespace UHDM

#endif
