// This file is auto-generated by generate_ast_listener.py
// DO NOT EDIT

/*
 Copyright 2019 Alain Dargelas
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 *
 * File:   AstTraceListener.h
 * Author: hs
 *
 */

#ifndef SURELOG_ASTTRACELISTENER_H
#define SURELOG_ASTTRACELISTENER_H
#pragma once

#include <Surelog/SourceCompile/AstListener.h>

#include <filesystem>
#include <ostream>

// clang-format off
#define TRACE_INIT_CONTEXT                \
  int32_t sl = 0, sc = 0, el = 0, ec = 0; \
  std::string name;                       \
  getNodeLocation(node, sl, sc, el, ec);  \
  getNodeName(node, name)

#define TRACE_PRINT_CONTEXT \
  "[" << sl << "," << sc <<  ":" << el << "," << ec <<  "], " << name

#define TRACE_ENTER TRACE_INIT_CONTEXT;       \
  m_strm << std::string(m_indent++ * 2, ' ')  \
  << __func__ << ": " << TRACE_PRINT_CONTEXT  \
  << std::endl
#define TRACE_LEAVE TRACE_INIT_CONTEXT;       \
  m_strm << std::string(2 * --m_indent, ' ')  \
  << __func__ << ": " << TRACE_PRINT_CONTEXT  \
  << std::endl
// clang-format on

namespace SURELOG {
class AstTraceListener final : public AstListener {
 public:
  AstTraceListener(std::ostream& strm) : m_strm(strm), m_indent(0) {}
  ~AstTraceListener() final = default;

  void enterSourceFile(SURELOG::PathId fileId) final {
    m_strm << std::string(m_indent++ * 2, ' ') << __func__ << ": "
           << SURELOG::PathIdPP(fileId) << std::endl;
  }
  void leaveSourceFile(SURELOG::PathId fileId) final {
    m_strm << std::string(2 * --m_indent, ' ') << __func__ << ": "
           << SURELOG::PathIdPP(fileId) << std::endl;
  }

  // clang-format off
  void enter0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leave0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enter1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leave1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterACCEPT_ON(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveACCEPT_ON(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterALWAYS(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveALWAYS(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAND(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAND(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAccelerate_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAccelerate_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAction_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAction_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterActual_arg_expr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveActual_arg_expr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterActual_arg_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveActual_arg_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAlwaysKeywd_Always(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAlwaysKeywd_Always(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAlwaysKeywd_Comb(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAlwaysKeywd_Comb(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAlwaysKeywd_FF(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAlwaysKeywd_FF(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAlwaysKeywd_Latch(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAlwaysKeywd_Latch(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAlways_construct(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAlways_construct(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAlways_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAlways_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAnd_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAnd_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAnonymous_program(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAnonymous_program(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAnonymous_program_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAnonymous_program_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAnsi_port_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAnsi_port_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterArgument(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveArgument(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterArray_manipulation_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveArray_manipulation_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterArray_member_label(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveArray_member_label(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterArray_method_name(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveArray_method_name(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterArray_pattern_key(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveArray_pattern_key(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterArray_range_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveArray_range_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssert_property_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssert_property_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssertion_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssertion_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssertion_item_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssertion_item_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssertion_variable_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssertion_variable_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssign(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssign(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_Add(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_Add(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_ArithShiftLeft(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_ArithShiftLeft(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_ArithShiftRight(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_ArithShiftRight(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_Assign(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_Assign(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_BitwAnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_BitwAnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_BitwLeftShift(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_BitwLeftShift(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_BitwOr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_BitwOr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_BitwRightShift(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_BitwRightShift(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_BitwXor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_BitwXor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_Div(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_Div(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_Modulo(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_Modulo(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_Mult(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_Mult(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignOp_Sub(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignOp_Sub(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignment_operator(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignment_operator(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignment_pattern(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignment_pattern(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignment_pattern_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignment_pattern_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignment_pattern_expression_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignment_pattern_expression_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignment_pattern_key(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignment_pattern_key(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignment_pattern_net_lvalue(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignment_pattern_net_lvalue(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssignment_pattern_variable_lvalue(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssignment_pattern_variable_lvalue(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssociative_dimension(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssociative_dimension(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAssume_property_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAssume_property_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAttr_name(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAttr_name(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAttr_spec(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAttr_spec(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAttribute_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAttribute_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterAutoexpand_vectornets_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveAutoexpand_vectornets_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBegin_keywords_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBegin_keywords_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_BitwAnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_BitwAnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_BitwOr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_BitwOr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_BitwXor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_BitwXor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_Equiv(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_Equiv(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_LogicAnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_LogicAnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_LogicOr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_LogicOr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_NotEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_NotEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_ReductXnor1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_ReductXnor1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinModOp_ReductXnor2(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinModOp_ReductXnor2(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_ArithShiftLeft(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_ArithShiftLeft(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_ArithShiftRight(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_ArithShiftRight(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_BitwAnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_BitwAnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_BitwOr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_BitwOr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_BitwXor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_BitwXor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Div(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Div(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Equiv(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Equiv(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Equivalence(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Equivalence(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_FourStateLogicEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_FourStateLogicEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_FourStateLogicNotEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_FourStateLogicNotEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Great(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Great(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_GreatEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_GreatEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Imply(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Imply(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Less(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Less(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_LessEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_LessEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_LogicAnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_LogicAnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_LogicOr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_LogicOr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Minus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Minus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Mult(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Mult(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_MultMult(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_MultMult(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Not(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Not(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Percent(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Percent(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_Plus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_Plus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_ReductNand(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_ReductNand(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_ReductNor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_ReductNor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_ReductXnor1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_ReductXnor1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_ReductXnor2(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_ReductXnor2(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_ShiftLeft(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_ShiftLeft(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_ShiftRight(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_ShiftRight(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_WildEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_WildEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_WildNotEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_WildNotEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_WildcardEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_WildcardEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBinOp_WildcardNotEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBinOp_WildcardNotEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBind_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBind_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBind_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBind_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBins_Bins(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBins_Bins(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBins_Ignore(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBins_Ignore(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBins_Illegal(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBins_Illegal(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBins_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBins_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBins_or_empty(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBins_or_empty(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBins_or_options(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBins_or_options(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBins_selection(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBins_selection(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBins_selection_or_option(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBins_selection_or_option(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBit_select(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBit_select(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBlock_event_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBlock_event_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBlock_item_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBlock_item_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBlocking_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBlocking_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBoolean_abbrev(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBoolean_abbrev(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBreakStmt(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBreakStmt(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterBuilt_in_method_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveBuilt_in_method_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCR(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCR(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCase(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCase(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCaseX(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCaseX(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCaseZ(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCaseZ(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCase_generate_construct(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCase_generate_construct(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCase_generate_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCase_generate_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCase_inside_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCase_inside_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCase_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCase_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCase_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCase_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCase_pattern_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCase_pattern_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCase_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCase_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCast(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCast(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCasting_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCasting_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCell_clause(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCell_clause(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCelldefine_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCelldefine_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChandle_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChandle_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCharge_strength(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCharge_strength(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChecker(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChecker(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChecker_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChecker_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChecker_generate_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChecker_generate_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChecker_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChecker_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChecker_or_generate_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChecker_or_generate_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChecker_or_generate_item_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChecker_or_generate_item_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChecker_port_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChecker_port_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterChecker_port_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveChecker_port_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClassItemQualifier_Local(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClassItemQualifier_Local(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClassItemQualifier_Protected(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClassItemQualifier_Protected(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClassItemQualifier_Static(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClassItemQualifier_Static(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_constraint(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_constraint(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_constructor_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_constructor_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_constructor_prototype(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_constructor_prototype(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_method(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_method(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_new(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_new(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_property(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_property(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_scope(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_scope(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClass_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClass_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClockingDir_Inout(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClockingDir_Inout(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClockingDir_Input(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClockingDir_Input(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClockingDir_InputOutput(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClockingDir_InputOutput(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClockingDir_Output(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClockingDir_Output(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClocking_decl_assign(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClocking_decl_assign(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClocking_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClocking_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClocking_drive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClocking_drive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClocking_event(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClocking_event(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClocking_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClocking_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClocking_skew(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClocking_skew(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClockvar(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClockvar(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterClockvar_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveClockvar_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCloseParens(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCloseParens(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCmosSwitchType_Cmos(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCmosSwitchType_Cmos(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCmosSwitchType_RCmos(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCmosSwitchType_RCmos(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCmos_switch_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCmos_switch_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterColumnPartSelectOp(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveColumnPartSelectOp(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCombinational_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCombinational_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCombinational_entry(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCombinational_entry(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterComma(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveComma(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterComma_operator(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveComma_operator(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterComments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveComments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterComplex_func_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveComplex_func_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConcatenation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConcatenation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConcurrent_assertion_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConcurrent_assertion_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConcurrent_assertion_item_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConcurrent_assertion_item_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConcurrent_assertion_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConcurrent_assertion_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCond_predicate(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCond_predicate(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConditional_generate_construct(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConditional_generate_construct(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConditional_operator(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConditional_operator(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConditional_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConditional_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConfig(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConfig(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConfig_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConfig_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConfig_rule_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConfig_rule_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConsecutive_repetition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConsecutive_repetition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstSelect(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstSelect(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConst_or_range_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConst_or_range_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConst_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConst_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstantSelect(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstantSelect(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_assignment_pattern_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_assignment_pattern_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_bit_select(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_bit_select(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_cast(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_cast(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_concatenation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_concatenation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_indexed_range(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_indexed_range(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_mintypmax_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_mintypmax_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_multiple_concatenation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_multiple_concatenation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_param_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_param_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_part_select_range(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_part_select_range(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_primary(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_primary(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_range(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_range(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_range_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_range_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstant_select(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstant_select(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstraint_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstraint_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstraint_block_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstraint_block_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstraint_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstraint_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstraint_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstraint_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstraint_primary(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstraint_primary(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstraint_prototype(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstraint_prototype(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterConstraint_set(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveConstraint_set(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterContext_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveContext_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterContinueStmt(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveContinueStmt(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterContinuous_assign(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveContinuous_assign(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterControlled_timing_check_event(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveControlled_timing_check_event(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCover_cross(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCover_cross(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCover_point(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCover_point(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCover_property_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCover_property_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCover_sequence_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCover_sequence_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCoverage_event(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCoverage_event(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCoverage_option(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCoverage_option(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCoverage_spec(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCoverage_spec(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCoverage_spec_or_option(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCoverage_spec_or_option(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCovergroup_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCovergroup_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCross_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCross_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCross_body_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCross_body_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCross_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCross_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCycle_delay(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCycle_delay(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCycle_delay_const_range_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCycle_delay_const_range_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterCycle_delay_range(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveCycle_delay_range(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterData_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveData_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterData_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveData_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterData_type_or_implicit(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveData_type_or_implicit(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterData_type_or_void(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveData_type_or_void(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDeassign(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDeassign(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDecPartSelectOp(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDecPartSelectOp(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefault(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefault(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefaultSkew_Intput(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefaultSkew_Intput(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefaultSkew_IntputOutput(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefaultSkew_IntputOutput(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefaultSkew_Output(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefaultSkew_Output(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefault_clause(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefault_clause(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefault_decay_time_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefault_decay_time_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefault_nettype_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefault_nettype_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefault_trireg_strenght_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefault_trireg_strenght_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefault_value(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefault_value(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDeferred_immediate_assert_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDeferred_immediate_assert_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDeferred_immediate_assertion_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDeferred_immediate_assertion_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDeferred_immediate_assertion_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDeferred_immediate_assertion_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDeferred_immediate_assume_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDeferred_immediate_assume_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDeferred_immediate_cover_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDeferred_immediate_cover_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefine_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefine_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDefparam_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDefparam_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay2(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay2(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay3(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay3(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay_control(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay_control(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay_mode_distributed_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay_mode_distributed_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay_mode_path_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay_mode_path_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay_mode_unit_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay_mode_unit_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay_mode_zero_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay_mode_zero_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay_or_event_control(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay_or_event_control(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelay_value(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelay_value(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelayed_data(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelayed_data(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDelayed_reference(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDelayed_reference(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDescription(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDescription(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDesign_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDesign_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDirective_in_macro(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDirective_in_macro(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDisable_portfaults_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDisable_portfaults_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDisable_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDisable_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDistWeight_AssignRange(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDistWeight_AssignRange(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDistWeight_AssignValue(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDistWeight_AssignValue(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDist_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDist_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDist_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDist_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDo(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDo(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_fullskew_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_fullskew_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_hold_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_hold_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_nochange_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_nochange_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_period_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_period_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_recovery_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_recovery_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_recrem_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_recrem_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_removal_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_removal_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_root_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_root_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_setup_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_setup_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_setuphold_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_setuphold_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_skew_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_skew_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_timeskew_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_timeskew_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDollar_width_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDollar_width_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDot(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDot(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDotStar(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDotStar(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDpi_import_export(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDpi_import_export(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDrive_strength(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDrive_strength(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterDynamic_array_new(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveDynamic_array_new(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEVENTUALLY(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEVENTUALLY(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_Edge(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_Edge(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_Negedge(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_Negedge(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_Posedge(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_Posedge(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_control_specifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_control_specifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_descriptor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_descriptor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_indicator(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_indicator(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_input_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_input_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_sensitive_path_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_sensitive_path_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEdge_symbol(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEdge_symbol(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterElaboration_system_task(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveElaboration_system_task(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterElse(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveElse(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterElse_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveElse_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterElseif_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveElseif_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterElseif_directive_in_macro_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveElseif_directive_in_macro_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterElsif_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveElsif_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterElsif_directive_in_macro_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveElsif_directive_in_macro_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEmpty_queue(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEmpty_queue(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnableGateType_Bufif0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnableGateType_Bufif0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnableGateType_Bufif1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnableGateType_Bufif1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnableGateType_Notif0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnableGateType_Notif0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnableGateType_Notif1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnableGateType_Notif1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnable_gate_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnable_gate_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnable_portfaults_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnable_portfaults_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnd_edge_offset(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnd_edge_offset(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnd_keywords_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnd_keywords_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndcase(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndcase(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndcelldefine_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndcelldefine_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndchecker(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndchecker(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndclass(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndclass(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndclocking(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndclocking(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndconfig(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndconfig(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndfunction(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndfunction(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndgenerate(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndgenerate(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndgroup(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndgroup(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndif_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndif_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndinterface(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndinterface(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndmodule(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndmodule(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndpackage(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndpackage(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndprimitive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndprimitive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndprogram(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndprogram(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndproperty(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndproperty(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndprotect_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndprotect_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndprotected_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndprotected_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndsequence(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndsequence(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndspecify(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndspecify(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndtable(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndtable(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEndtask(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEndtask(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnum_base_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnum_base_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnum_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnum_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEnum_name_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEnum_name_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEscapedCR(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEscapedCR(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEscaped_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEscaped_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEscaped_macro_definition_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEscaped_macro_definition_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEscaped_macro_definition_body_alt1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEscaped_macro_definition_body_alt1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEscaped_macro_definition_body_alt2(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEscaped_macro_definition_body_alt2(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEvent_based_flag(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEvent_based_flag(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEvent_control(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEvent_control(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEvent_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEvent_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEvent_trigger(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEvent_trigger(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterEvent_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveEvent_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExpand_vectornets_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExpand_vectornets_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExpect_property_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExpect_property_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExport(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExport(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExpression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExpression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExpression_or_cond_pattern(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExpression_or_cond_pattern(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExpression_or_dist(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExpression_or_dist(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExtends(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExtends(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExtern_constraint_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExtern_constraint_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExtern_qualifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExtern_qualifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterExtern_tf_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveExtern_tf_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFile_path_spec(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFile_path_spec(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFinal_construct(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFinal_construct(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFirstMatch(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFirstMatch(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFor_initialization(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFor_initialization(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFor_step(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFor_step(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFor_step_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFor_step_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFor_variable_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFor_variable_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterForce(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveForce(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterForeach(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveForeach(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterForever(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveForever(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFull_edge_sensitive_path_description(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFull_edge_sensitive_path_description(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFull_path_description(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFull_path_description(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFunction_body_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFunction_body_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFunction_data_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFunction_data_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFunction_data_type_or_implicit(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFunction_data_type_or_implicit(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFunction_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFunction_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFunction_name_decl(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFunction_name_decl(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFunction_prototype(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFunction_prototype(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterFunction_statement_or_null(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveFunction_statement_or_null(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGate_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGate_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_interface_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_interface_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_interface_case_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_interface_case_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_interface_conditional_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_interface_conditional_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_interface_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_interface_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_interface_loop_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_interface_loop_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_interface_named_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_interface_named_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_module_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_module_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_module_case_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_module_case_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_module_conditional_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_module_conditional_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_module_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_module_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_module_loop_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_module_loop_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_module_named_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_module_named_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerate_region(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerate_region(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerated_interface_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerated_interface_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenerated_module_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenerated_module_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenericElementType(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenericElementType(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenvar_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenvar_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenvar_decl_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenvar_decl_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenvar_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenvar_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenvar_initialization(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenvar_initialization(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenvar_interface_case_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenvar_interface_case_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenvar_iteration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenvar_iteration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGenvar_module_case_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGenvar_module_case_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGlobal(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGlobal(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterGoto_repetition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveGoto_repetition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterHierarchical_btf_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveHierarchical_btf_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterHierarchical_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveHierarchical_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterHierarchical_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveHierarchical_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterHighZ0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveHighZ0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterHighZ1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveHighZ1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIF(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIF(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIFF(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIFF(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIMPLIES(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIMPLIES(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIdentifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIdentifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIdentifier_in_macro_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIdentifier_in_macro_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIdentifier_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIdentifier_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIf_generate_construct(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIf_generate_construct(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIfdef_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIfdef_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIfdef_directive_in_macro_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIfdef_directive_in_macro_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIff(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIff(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIfndef_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIfndef_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIfndef_directive_in_macro_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIfndef_directive_in_macro_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterImmediate_assertion_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveImmediate_assertion_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterImplements(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveImplements(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterImplicit_class_handle(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveImplicit_class_handle(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterImplicit_data_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveImplicit_data_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterImport(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveImport(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIncDec_MinusMinus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIncDec_MinusMinus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIncDec_PlusPlus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIncDec_PlusPlus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIncPartSelectOp(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIncPartSelectOp(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInc_or_dec_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInc_or_dec_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInc_or_dec_operator(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInc_or_dec_operator(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInclude_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInclude_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInclude_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInclude_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIndexed_range(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIndexed_range(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_1TickB0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_1TickB0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_1TickB1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_1TickB1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_1TickBX(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_1TickBX(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_1TickBx(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_1TickBx(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_1Tickb0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_1Tickb0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_1Tickb1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_1Tickb1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_1TickbX(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_1TickbX(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_1Tickbx(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_1Tickbx(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitVal_Integral(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitVal_Integral(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInitial_construct(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInitial_construct(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInout_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInout_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInput_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInput_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInsideOp(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInsideOp(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInst_clause(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInst_clause(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInst_name(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInst_name(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntConst(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntConst(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntVec_TypeBit(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntVec_TypeBit(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntVec_TypeLogic(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntVec_TypeLogic(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntVec_TypeReg(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntVec_TypeReg(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntegerAtomType_Byte(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntegerAtomType_Byte(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntegerAtomType_Int(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntegerAtomType_Int(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntegerAtomType_Integer(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntegerAtomType_Integer(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntegerAtomType_LongInt(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntegerAtomType_LongInt(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntegerAtomType_Shortint(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntegerAtomType_Shortint(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntegerAtomType_Time(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntegerAtomType_Time(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInteger_atom_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInteger_atom_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInteger_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInteger_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInteger_vector_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInteger_vector_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_ansi_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_ansi_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_class_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_class_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_class_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_class_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_class_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_class_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_class_method(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_class_method(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_class_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_class_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_nonansi_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_nonansi_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_or_generate_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_or_generate_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_port_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_port_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterInterface_port_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveInterface_port_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterIntersect(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveIntersect(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterJoin_any_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveJoin_any_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterJoin_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveJoin_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterJoin_none_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveJoin_none_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterJump_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveJump_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLarge(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLarge(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLet_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLet_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLet_formal_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLet_formal_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLet_port_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLet_port_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLet_port_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLet_port_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLevel_input_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLevel_input_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLevel_symbol(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLevel_symbol(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLiblist_clause(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLiblist_clause(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLibrary_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLibrary_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLibrary_descriptions(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLibrary_descriptions(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLibrary_text(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLibrary_text(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLifetime_Automatic(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLifetime_Automatic(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLifetime_Static(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLifetime_Static(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLine_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLine_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_arguments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_arguments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_checker_port_connections(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_checker_port_connections(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_clocking_decl_assign(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_clocking_decl_assign(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_cross_items(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_cross_items(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_defparam_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_defparam_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_interface_identifiers(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_interface_identifiers(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_net_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_net_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_net_decl_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_net_decl_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_param_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_param_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_parameter_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_parameter_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_path_delay_expressions(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_path_delay_expressions(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_path_inputs(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_path_inputs(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_path_outputs(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_path_outputs(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_port_connections(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_port_connections(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_port_declarations(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_port_declarations(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_port_identifiers(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_port_identifiers(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_ports(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_ports(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_specparam_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_specparam_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_tf_variable_identifiers(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_tf_variable_identifiers(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_type_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_type_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_variable_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_variable_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_variable_decl_assignments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_variable_decl_assignments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_variable_identifiers(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_variable_identifiers(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_variable_port_identifiers(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_variable_port_identifiers(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterList_of_virtual_interface_decl(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveList_of_virtual_interface_decl(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLocal_parameter_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLocal_parameter_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLoop_generate_construct(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLoop_generate_construct(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLoop_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLoop_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterLoop_variables(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveLoop_variables(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMacroInstanceNoArgs(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMacroInstanceNoArgs(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMacroInstanceWithArgs(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMacroInstanceWithArgs(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMacro_actual_args(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMacro_actual_args(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMacro_arg(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMacro_arg(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMacro_arguments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMacro_arguments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMacro_definition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMacro_definition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMatches(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMatches(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMedium(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMedium(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMethodQualifier_ClassItem(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMethodQualifier_ClassItem(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMethodQualifier_Virtual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMethodQualifier_Virtual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMethod_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMethod_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMethod_call_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMethod_call_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMethod_call_root(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMethod_call_root(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMethod_prototype(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMethod_prototype(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMintypmax_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMintypmax_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModport_hierarchical_ports_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModport_hierarchical_ports_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModport_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModport_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModport_ports_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModport_ports_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModport_simple_port(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModport_simple_port(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModport_simple_ports_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModport_simple_ports_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModport_tf_port(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModport_tf_port(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModport_tf_ports_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModport_tf_ports_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModuleInstance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModuleInstance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_ansi_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_ansi_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_common_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_common_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_nonansi_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_nonansi_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_or_generate_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_or_generate_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_or_generate_item_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_or_generate_item_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_path_concatenation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_path_concatenation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_path_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_path_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_path_mintypmax_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_path_mintypmax_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_path_multiple_concatenation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_path_multiple_concatenation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterModule_path_primary(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveModule_path_primary(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMosSwitchType_NMos(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMosSwitchType_NMos(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMosSwitchType_PMos(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMosSwitchType_PMos(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMosSwitchType_RNMos(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMosSwitchType_RNMos(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMosSwitchType_RPMos(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMosSwitchType_RPMos(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMos_switch_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMos_switch_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMultiline_args_macro_definition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMultiline_args_macro_definition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMultiline_no_args_macro_definition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMultiline_no_args_macro_definition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterMultiple_concatenation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveMultiple_concatenation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNInpGate_And(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNInpGate_And(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNInpGate_Nand(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNInpGate_Nand(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNInpGate_Nor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNInpGate_Nor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNInpGate_Or(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNInpGate_Or(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNInpGate_Xnor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNInpGate_Xnor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNInpGate_Xor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNInpGate_Xor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNONOVERLAPPED(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNONOVERLAPPED(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNON_OVERLAP_IMPLY(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNON_OVERLAP_IMPLY(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNOT(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNOT(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNOutGate_Buf(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNOutGate_Buf(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNOutGate_Not(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNOutGate_Not(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterN_input_gate_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveN_input_gate_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterN_output_gate_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveN_output_gate_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterName_of_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveName_of_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNamed_checker_port_connection(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNamed_checker_port_connection(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNamed_parameter_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNamed_parameter_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNamed_port_connection(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNamed_port_connection(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Supply0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Supply0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Supply1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Supply1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Tri(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Tri(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Tri0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Tri0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Tri1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Tri1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_TriAnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_TriAnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_TriOr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_TriOr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_TriReg(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_TriReg(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Uwire(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Uwire(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Wand(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Wand(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Wire(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Wire(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNetType_Wor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNetType_Wor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_alias(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_alias(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_decl_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_decl_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_lvalue(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_lvalue(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_port_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_port_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_port_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_port_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNet_type_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNet_type_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNext_state(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNext_state(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNoType(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNoType(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNoaccelerate_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNoaccelerate_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNoexpand_vectornets_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNoexpand_vectornets_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNonBlockingTriggerEvent(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNonBlockingTriggerEvent(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNonIntType_Real(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNonIntType_Real(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNonIntType_RealTime(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNonIntType_RealTime(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNonIntType_ShortReal(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNonIntType_ShortReal(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNon_consecutive_repetition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNon_consecutive_repetition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNon_integer_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNon_integer_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNon_port_interface_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNon_port_interface_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNon_port_module_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNon_port_module_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNon_port_program_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNon_port_program_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNonblocking_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNonblocking_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNonrange_select(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNonrange_select(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNonrange_variable_lvalue(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNonrange_variable_lvalue(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNoremove_gatenames_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNoremove_gatenames_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNoremove_netnames_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNoremove_netnames_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNosuppress_faults_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNosuppress_faults_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNotifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNotifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNounconnected_drive_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNounconnected_drive_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNull(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNull(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNull_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNull_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_1TickB0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_1TickB0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_1TickB1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_1TickB1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_1TickBX(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_1TickBX(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_1TickBx(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_1TickBx(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_1Tickb0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_1Tickb0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_1Tickb1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_1Tickb1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_1TickbX(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_1TickbX(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_1Tickbx(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_1Tickbx(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_Integral(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_Integral(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_Real(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_Real(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_Tick0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_Tick0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_Tick1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_Tick1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_TickB0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_TickB0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_TickB1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_TickB1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_Tickb0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_Tickb0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterNumber_Tickb1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveNumber_Tickb1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOR(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOR(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOVERLAPPED(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOVERLAPPED(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOVERLAP_IMPLY(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOVERLAP_IMPLY(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOpenParens(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOpenParens(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOpen_range_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOpen_range_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOperator_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOperator_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOr_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOr_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOr_operator(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOr_operator(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOrdered_checker_port_connection(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOrdered_checker_port_connection(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOrdered_parameter_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOrdered_parameter_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOrdered_port_connection(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOrdered_port_connection(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOutput_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOutput_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOutput_symbol(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOutput_symbol(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Div(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Div(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Equal(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Equal(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Equiv(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Equiv(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Greater(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Greater(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_GreaterEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_GreaterEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Less(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Less(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_LessEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_LessEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Minus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Minus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_MinusMinus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_MinusMinus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Mult(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Mult(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_NotEqual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_NotEqual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Percent(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Percent(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_Plus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_Plus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_PlusPlus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_PlusPlus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverloadOp_StarStar(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverloadOp_StarStar(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverload_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverload_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterOverload_proto_formals(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveOverload_proto_formals(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPackage(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePackage(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPackage_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePackage_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPackage_export_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePackage_export_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPackage_import_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePackage_import_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPackage_import_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePackage_import_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPackage_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePackage_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPackage_or_generate_item_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePackage_or_generate_item_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPackage_scope(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePackage_scope(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPacked_dimension(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePacked_dimension(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPacked_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePacked_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPaired_parens(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePaired_parens(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPar_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePar_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParallel_edge_sensitive_path_description(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParallel_edge_sensitive_path_description(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParallel_path_description(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParallel_path_description(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParam_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParam_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParam_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParam_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParameter_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParameter_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParameter_override(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParameter_override(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParameter_port_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParameter_port_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParameter_port_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParameter_port_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterParameter_value_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveParameter_value_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPart_select_op(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePart_select_op(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPart_select_op_column(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePart_select_op_column(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPart_select_range(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePart_select_range(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPassEnSwitch_RTranif0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePassEnSwitch_RTranif0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPassEnSwitch_RTranif1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePassEnSwitch_RTranif1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPassEnSwitch_Tranif0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePassEnSwitch_Tranif0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPassEnSwitch_Tranif1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePassEnSwitch_Tranif1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPassSwitch_RTran(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePassSwitch_RTran(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPassSwitch_Tran(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePassSwitch_Tran(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPass_enable_switch_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePass_enable_switch_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPass_switch_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePass_switch_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPath_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePath_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPath_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePath_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPath_delay_value(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePath_delay_value(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPattern(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePattern(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPort(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePort(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPortDir_Inout(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePortDir_Inout(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPortDir_Inp(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePortDir_Inp(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPortDir_Out(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePortDir_Out(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPortDir_Ref(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePortDir_Ref(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPortInst(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePortInst(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPort_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePort_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPort_direction(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePort_direction(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPort_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePort_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPort_reference(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePort_reference(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPound_Pound_delay(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePound_Pound_delay(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPound_delay(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePound_delay(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPound_delay_value(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePound_delay_value(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPound_pound_delay(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePound_pound_delay(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPragma_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePragma_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPragma_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePragma_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPragma_value(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePragma_value(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPrimary(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePrimary(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPrimary_literal(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePrimary_literal(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPrimitive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePrimitive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPrimitiveInstance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePrimitiveInstance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPriority(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePriority(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProcedural_assertion_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProcedural_assertion_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProcedural_continuous_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProcedural_continuous_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProcedural_timing_control(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProcedural_timing_control(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProcedural_timing_control_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProcedural_timing_control_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProduction(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProduction(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProduction_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProduction_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProgram(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProgram(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProgram_ansi_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProgram_ansi_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProgram_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProgram_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProgram_generate_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProgram_generate_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProgram_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProgram_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProgram_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProgram_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProgram_nonansi_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProgram_nonansi_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPropQualifier_ClassItem(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePropQualifier_ClassItem(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPropQualifier_Rand(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePropQualifier_Rand(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPropQualifier_Randc(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePropQualifier_Randc(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_actual_arg(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_actual_arg(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_case_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_case_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_expr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_expr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_formal_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_formal_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_lvar_port_direction(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_lvar_port_direction(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_port_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_port_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_port_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_port_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProperty_spec(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProperty_spec(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProtect_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProtect_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterProtected_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveProtected_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPs_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePs_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPs_or_hierarchical_array_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePs_or_hierarchical_array_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPs_or_hierarchical_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePs_or_hierarchical_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPs_or_hierarchical_sequence_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePs_or_hierarchical_sequence_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPs_type_identifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePs_type_identifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPull0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePull0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPull1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePull1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPull_gate_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePull_gate_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPulldown(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePulldown(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPulldown_strength(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePulldown_strength(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPullup(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePullup(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPullup_strength(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePullup_strength(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPulse_control_specparam(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePulse_control_specparam(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPulsestyle_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePulsestyle_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPure(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePure(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPure_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePure_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterPure_virtual_qualifier(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leavePure_virtual_qualifier(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterQmark(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveQmark(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterQueue_dimension(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveQueue_dimension(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterREJECT_ON(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveREJECT_ON(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRandcase_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRandcase_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRandcase_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRandcase_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRandomQualifier_Rand(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRandomQualifier_Rand(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRandomQualifier_RandC(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRandomQualifier_RandC(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRandomize_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRandomize_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRandsequence_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRandsequence_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRange_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRange_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRange_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRange_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRealConst(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRealConst(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRef_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRef_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterReference_event(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveReference_event(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRelease(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRelease(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRemain_active_flag(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRemain_active_flag(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRemove_gatename_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRemove_gatename_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRemove_netname_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRemove_netname_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRepeat(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRepeat(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRepeat_range(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRepeat_range(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterResetall_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveResetall_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRestrict_property_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRestrict_property_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterReturnStmt(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveReturnStmt(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRs_case(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRs_case(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRs_case_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRs_case_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRs_code_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRs_code_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRs_if_else(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRs_if_else(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRs_prod(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRs_prod(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRs_production_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRs_production_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRs_repeat(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRs_repeat(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterRs_rule(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveRs_rule(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSTRONG(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSTRONG(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSYNC_ACCEPT_ON(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSYNC_ACCEPT_ON(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSYNC_REJECT_ON(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSYNC_REJECT_ON(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterS_ALWAYS(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveS_ALWAYS(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterS_EVENTUALLY(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveS_EVENTUALLY(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterS_NEXTTIME(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveS_NEXTTIME(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterS_UNTIL(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveS_UNTIL(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterS_UNTIL_WITH(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveS_UNTIL_WITH(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_1TickB0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_1TickB0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_1TickB1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_1TickB1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_1Tickb0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_1Tickb0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_1Tickb1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_1Tickb1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_Integral(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_Integral(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_TickB0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_TickB0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_TickB1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_TickB1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_Tickb0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_Tickb0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_Tickb1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_Tickb1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterScalar_timing_check_condition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveScalar_timing_check_condition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSelect(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSelect(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSelect_condition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSelect_condition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSelect_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSelect_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSeqFormatType_Data(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSeqFormatType_Data(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSeqFormatType_Sequence(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSeqFormatType_Sequence(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSeqFormatType_Untyped(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSeqFormatType_Untyped(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSeqLvarPortDir_Inout(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSeqLvarPortDir_Inout(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSeqLvarPortDir_Input(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSeqLvarPortDir_Input(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSeqLvarPortDir_Output(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSeqLvarPortDir_Output(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSeq_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSeq_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSeq_input_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSeq_input_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_actual_arg(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_actual_arg(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_arg(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_arg(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_expr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_expr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_list_of_arguments(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_list_of_arguments(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_match_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_match_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_method_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_method_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_port_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_port_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequence_port_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequence_port_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequential_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequential_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSequential_entry(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSequential_entry(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterShowcancelled_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveShowcancelled_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSigned_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSigned_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSigning(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSigning(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSigning_Signed(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSigning_Signed(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSigning_Unsigned(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSigning_Unsigned(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_args_macro_definition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_args_macro_definition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_args_macro_definition_in_macro_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_args_macro_definition_in_macro_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_immediate_assert_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_immediate_assert_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_immediate_assertion_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_immediate_assertion_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_immediate_assume_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_immediate_assume_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_immediate_cover_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_immediate_cover_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_macro_definition_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_macro_definition_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_macro_definition_body_in_macro_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_macro_definition_body_in_macro_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_no_args_macro_definition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_no_args_macro_definition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_no_args_macro_definition_in_macro_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_no_args_macro_definition_in_macro_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_path_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_path_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSimple_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSimple_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSlice_size(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSlice_size(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSlline(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSlline(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSmall(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSmall(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSolve_before_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSolve_before_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSource_text(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSource_text(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSpaces(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSpaces(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSpecify_block(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSpecify_block(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSpecify_input_terminal_descriptor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSpecify_input_terminal_descriptor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSpecify_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSpecify_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSpecify_output_terminal_descriptor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSpecify_output_terminal_descriptor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSpecify_terminal_descriptor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSpecify_terminal_descriptor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSpecparam_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSpecparam_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSpecparam_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSpecparam_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStamptime_condition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStamptime_condition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStart_edge_offset(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStart_edge_offset(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterState_dependent_path_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveState_dependent_path_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStatement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStatement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStatement_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStatement_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStatement_or_null(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStatement_or_null(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStream_concatenation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStream_concatenation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStream_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStream_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStream_operator(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStream_operator(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStreaming_concatenation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStreaming_concatenation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStrength0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStrength0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStrength1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStrength1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterString(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveString(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStringConst(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStringConst(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStringLiteral(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStringLiteral(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterString_blob(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveString_blob(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterString_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveString_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterString_value(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveString_value(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStrong0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStrong0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStrong1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStrong1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStruct_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStruct_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStruct_union(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStruct_union(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStruct_union_member(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStruct_union_member(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterStructure_pattern_key(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveStructure_pattern_key(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSubroutine_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSubroutine_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSubroutine_call_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSubroutine_call_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSuper_dot_new(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSuper_dot_new(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSuper_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSuper_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSupply0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSupply0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSupply1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSupply1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSuppress_faults_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSuppress_faults_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSurelog_macro_not_defined(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSurelog_macro_not_defined(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSv_file_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSv_file_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSv_interface(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSv_interface(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSv_line_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSv_line_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSv_package(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSv_package(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSystem_task(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSystem_task(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSystem_task_names(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSystem_task_names(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterSystem_timing_check(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveSystem_timing_check(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterT01_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveT01_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterT0x_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveT0x_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterT0z_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveT0z_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterT10_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveT10_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterT1x_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveT1x_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterT1z_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveT1z_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterT_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveT_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTagged(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTagged(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTagged_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTagged_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTask_body_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTask_body_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTask_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTask_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTask_name_decl(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTask_name_decl(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTask_prototype(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTask_prototype(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterText_blob(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveText_blob(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTfPortDir_ConstRef(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTfPortDir_ConstRef(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTfPortDir_Inout(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTfPortDir_Inout(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTfPortDir_Inp(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTfPortDir_Inp(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTfPortDir_Out(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTfPortDir_Out(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTfPortDir_Ref(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTfPortDir_Ref(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTf_item_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTf_item_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTf_port_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTf_port_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTf_port_direction(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTf_port_direction(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTf_port_item(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTf_port_item(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTf_port_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTf_port_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTfall_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTfall_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterThis(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveThis(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterThis_dot_super(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveThis_dot_super(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterThis_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveThis_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterThreshold(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveThreshold(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterThroughout(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveThroughout(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimeUnitsDecl_TimePrecision(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimeUnitsDecl_TimePrecision(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimeUnitsDecl_TimePrecisionTimeUnit(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimeUnitsDecl_TimePrecisionTimeUnit(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimeUnitsDecl_TimeUnit(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimeUnitsDecl_TimeUnit(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimeUnitsDecl_TimeUnitDiv(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimeUnitsDecl_TimeUnitDiv(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimeUnitsDecl_TimeUnitTimePrecision(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimeUnitsDecl_TimeUnitTimePrecision(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTime_literal(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTime_literal(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTime_unit(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTime_unit(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimescale_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimescale_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimingCheckEventControl_Edge(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimingCheckEventControl_Edge(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimingCheckEventControl_Negedge(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimingCheckEventControl_Negedge(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTimingCheckEventControl_Posedge(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTimingCheckEventControl_Posedge(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTiming_check_condition(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTiming_check_condition(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTiming_check_event(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTiming_check_event(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTiming_check_limit(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTiming_check_limit(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTop_directives(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTop_directives(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTop_level_library_rule(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTop_level_library_rule(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTop_level_rule(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTop_level_rule(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTrans_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTrans_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTrans_range_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTrans_range_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTrans_set(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTrans_set(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTrise_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTrise_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTx0_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTx0_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTx1_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTx1_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTxz_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTxz_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterType(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveType(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterType_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveType_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterType_reference(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveType_reference(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTz0_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTz0_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTz1_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTz1_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTz_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTz_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterTzx_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveTzx_path_delay_expression(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUNTIL(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUNTIL(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUNTIL_WITH(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUNTIL_WITH(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_ansi_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_ansi_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_body(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_body(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_declaration_port_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_declaration_port_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_initial_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_initial_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_input_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_input_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_instance(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_instance(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_instantiation(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_instantiation(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_nonansi_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_nonansi_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_output_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_output_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_port_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_port_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_port_list(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_port_list(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUdp_reg_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUdp_reg_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_BitwAnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_BitwAnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_BitwOr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_BitwOr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_BitwXor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_BitwXor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_Not(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_Not(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_ReductNand(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_ReductNand(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_ReductNor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_ReductNor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_ReductXNor1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_ReductXNor1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_ReductXnor2(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_ReductXnor2(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnaryModOp_Tilda(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnaryModOp_Tilda(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_BitwAnd(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_BitwAnd(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_BitwOr(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_BitwOr(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_BitwXor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_BitwXor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_Minus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_Minus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_Not(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_Not(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_Plus(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_Plus(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_ReductNand(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_ReductNand(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_ReductNor(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_ReductNor(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_ReductXnor1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_ReductXnor1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_ReductXnor2(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_ReductXnor2(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnary_Tilda(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnary_Tilda(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnbased_unsized_literal(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnbased_unsized_literal(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnconnected_drive_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnconnected_drive_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUndef_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUndef_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUndefineall_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUndefineall_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnion_keyword(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnion_keyword(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnique(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnique(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnique0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnique0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnique_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnique_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnique_priority(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnique_priority(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUniqueness_constraint(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUniqueness_constraint(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnpacked_dimension(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnpacked_dimension(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnsigned_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnsigned_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnsized_dimension(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnsized_dimension(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUnterminated_string(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUnterminated_string(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUse_clause(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUse_clause(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUse_clause_config(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUse_clause_config(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterUselib_directive(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveUselib_directive(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterValue_range(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveValue_range(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVar_data_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVar_data_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVar_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVar_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVariable_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVariable_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVariable_decl_assignment(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVariable_decl_assignment(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVariable_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVariable_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVariable_dimension(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVariable_dimension(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVariable_impl_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVariable_impl_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVariable_lvalue(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVariable_lvalue(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVariable_port_header(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVariable_port_header(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVariable_port_type(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVariable_port_type(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVirtual(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVirtual(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterVirtual_interface_declaration(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveVirtual_interface_declaration(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterWEAK(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveWEAK(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterWait_statement(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveWait_statement(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterWeak0(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveWeak0(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterWeak1(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveWeak1(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterWhile(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveWhile(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterWith(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveWith(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterWithin(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveWithin(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterX(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveX(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterXor_call(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveXor_call(const SURELOG::AstNode& node) final { TRACE_LEAVE; }

  void enterZ(const SURELOG::AstNode& node) final { TRACE_ENTER; }
  void leaveZ(const SURELOG::AstNode& node) final { TRACE_LEAVE; }
  // clang-format on

 private:
   std::ostream& m_strm;
   size_t m_indent = 0;
};
}  // namespace SURELOG

#endif  // SURELOG_ASTTRACELISTENER_H
