/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   for_stmt.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_FOR_STMT_H
#define UHDM_FOR_STMT_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/scope.h>

#include "stmt.h"


namespace UHDM {
class expr;

class for_stmt final : public scope {
  UHDM_IMPLEMENT_RTTI(for_stmt, scope)
public:
  // Implicit constructor used to initialize all members,
  // comment: for_stmt();
  virtual ~for_stmt() final = default;

  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; uhdmParentType_ = (data != nullptr) ? data->UhdmType() : 0; return true; }

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true; }

  virtual bool VpiFile(const std::filesystem::path& data) final;

  virtual SymbolFactory::ID VpiFileId() const final { return vpiFile_; }

  virtual std::filesystem::path VpiFile() const final;

  virtual unsigned int UhdmId() const final { return uhdmId_; }

  virtual bool UhdmId(unsigned int data) final { uhdmId_ = data; return true; }

  unsigned int VpiType() const final { return vpiFor; }

  int VpiLocalVarDecls() const { return vpiLocalVarDecls_; }

  bool VpiLocalVarDecls(int data) { vpiLocalVarDecls_ = data; return true; }

  VectorOfany* VpiForInitStmts() const { return vpiForInitStmts_; }

  bool VpiForInitStmts(VectorOfany* data) { if (!stmtGroupCompliant(data)) return false; vpiForInitStmts_ = data; return true; }

  VectorOfany* VpiForIncStmts() const { return vpiForIncStmts_; }

  bool VpiForIncStmts(VectorOfany* data) { if (!stmtGroupCompliant(data)) return false; vpiForIncStmts_ = data; return true; }

  const any* VpiForInitStmt() const { return vpiForInitStmt_; }

  bool VpiForInitStmt(any* data) { if (!stmtGroupCompliant(data)) return false; vpiForInitStmt_ = data; return true; }

  const expr* VpiCondition() const { return vpiCondition_; }

  bool VpiCondition(expr* data) { vpiCondition_ = data; return true; }

  const any* VpiForIncStmt() const { return vpiForIncStmt_; }

  bool VpiForIncStmt(any* data) { if (!stmtGroupCompliant(data)) return false; vpiForIncStmt_ = data; return true; }

  const any* VpiStmt() const { return vpiStmt_; }

  bool VpiStmt(any* data) { if (!stmtGroupCompliant(data)) return false; vpiStmt_ = data; return true; }

  virtual for_stmt* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmfor_stmt; }

protected:
  void DeepCopy(for_stmt* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  int vpiLocalVarDecls_ = 0;

  VectorOfany* vpiForInitStmts_ = nullptr;

  VectorOfany* vpiForIncStmts_ = nullptr;

  any* vpiForInitStmt_ = nullptr;

  expr* vpiCondition_ = nullptr;

  any* vpiForIncStmt_ = nullptr;

  any* vpiStmt_ = nullptr;
};


typedef FactoryT<for_stmt> for_stmtFactory;


typedef FactoryT<std::vector<for_stmt *>> VectorOffor_stmtFactory;

}  // namespace UHDM

#endif
