/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   concurrent_assertions.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_CONCURRENT_ASSERTIONS_H
#define UHDM_CONCURRENT_ASSERTIONS_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "property_inst_spec_group.h"
#include "stmt.h"


namespace UHDM {
class expr;

class concurrent_assertions : public BaseClass {
  UHDM_IMPLEMENT_RTTI(concurrent_assertions, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: concurrent_assertions();
  virtual ~concurrent_assertions() = default;

  virtual bool VpiName(const std::string& data) final;

  virtual const std::string& VpiName() const final;

  bool VpiFullName(const std::string& data);

  const std::string& VpiFullName() const;

  bool VpiIsClockInferred() const { return vpiIsClockInferred_; }

  bool VpiIsClockInferred(bool data) { vpiIsClockInferred_ = data; return true; }

  const expr* Clocking_event() const { return clocking_event_; }

  bool Clocking_event(expr* data) { clocking_event_ = data; return true; }

  const any* Stmt() const { return stmt_; }

  bool Stmt(any* data) { if (!stmtGroupCompliant(data)) return false; stmt_ = data; return true; }

  const any* VpiProperty() const { return vpiProperty_; }

  bool VpiProperty(any* data) { if (!property_inst_spec_groupGroupCompliant(data)) return false; vpiProperty_ = data; return true; }

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true; }

  virtual concurrent_assertions* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override = 0;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const override { return uhdmconcurrent_assertions; }

protected:
  void DeepCopy(concurrent_assertions* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  SymbolFactory::ID vpiName_ = 0;

  SymbolFactory::ID vpiFullName_ = 0;

  bool vpiIsClockInferred_ = 0;

  expr* clocking_event_ = nullptr;

  any* stmt_ = nullptr;

  any* vpiProperty_ = nullptr;

  VectorOfattribute* attributes_ = nullptr;
};

#if 0 // This class cannot be instantiated
typedef FactoryT<concurrent_assertions> concurrent_assertionsFactory;
#endif

typedef FactoryT<std::vector<concurrent_assertions *>> VectorOfconcurrent_assertionsFactory;

}  // namespace UHDM

#endif
