/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   scope.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_SCOPE_H
#define UHDM_SCOPE_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "instance_item.h"
#include "parameters.h"


namespace UHDM {


class scope : public BaseClass {
  UHDM_IMPLEMENT_RTTI(scope, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: scope();
  virtual ~scope() = default;

  virtual bool VpiName(std::string_view data) final;

  virtual std::string_view VpiName() const final;

  bool VpiFullName(std::string_view data);

  std::string_view VpiFullName() const;

  VectorOfproperty_decl* Property_decls() const { return property_decls_; }

  bool Property_decls(VectorOfproperty_decl* data) { property_decls_ = data; return true; }

  VectorOfsequence_decl* Sequence_decls() const { return sequence_decls_; }

  bool Sequence_decls(VectorOfsequence_decl* data) { sequence_decls_ = data; return true; }

  VectorOfconcurrent_assertions* Concurrent_assertions() const { return concurrent_assertions_; }

  bool Concurrent_assertions(VectorOfconcurrent_assertions* data) { concurrent_assertions_ = data; return true; }

  VectorOfnamed_event* Named_events() const { return named_events_; }

  bool Named_events(VectorOfnamed_event* data) { named_events_ = data; return true; }

  VectorOfnamed_event_array* Named_event_arrays() const { return named_event_arrays_; }

  bool Named_event_arrays(VectorOfnamed_event_array* data) { named_event_arrays_ = data; return true; }

  VectorOfvariables* Variables() const { return variables_; }

  bool Variables(VectorOfvariables* data) { variables_ = data; return true; }

  VectorOfvirtual_interface_var* Virtual_interface_vars() const { return virtual_interface_vars_; }

  bool Virtual_interface_vars(VectorOfvirtual_interface_var* data) { virtual_interface_vars_ = data; return true; }

  VectorOflogic_var* Logic_vars() const { return logic_vars_; }

  bool Logic_vars(VectorOflogic_var* data) { logic_vars_ = data; return true; }

  VectorOfarray_var* Array_vars() const { return array_vars_; }

  bool Array_vars(VectorOfarray_var* data) { array_vars_ = data; return true; }

  VectorOfarray_var* Array_var_mems() const { return array_var_mems_; }

  bool Array_var_mems(VectorOfarray_var* data) { array_var_mems_ = data; return true; }

  VectorOfany* Parameters() const { return parameters_; }

  bool Parameters(VectorOfany* data) { if (!parametersGroupCompliant(data)) return false; parameters_ = data; return true; }

  VectorOfparam_assign* Param_assigns() const { return param_assigns_; }

  bool Param_assigns(VectorOfparam_assign* data) { param_assigns_ = data; return true; }

  VectorOfscope* Scopes() const { return scopes_; }

  bool Scopes(VectorOfscope* data) { scopes_ = data; return true; }

  VectorOftypespec* Typespecs() const { return typespecs_; }

  bool Typespecs(VectorOftypespec* data) { typespecs_ = data; return true; }

  VectorOfany* Instance_items() const { return instance_items_; }

  bool Instance_items(VectorOfany* data) { if (!instance_itemGroupCompliant(data)) return false; instance_items_ = data; return true; }

  VectorOflet_decl* Let_decls() const { return let_decls_; }

  bool Let_decls(VectorOflet_decl* data) { let_decls_ = data; return true; }

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true; }

  virtual scope* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override = 0;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const override { return uhdmscope; }

protected:
  void DeepCopy(scope* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  SymbolId vpiName_;

  SymbolId vpiFullName_;

  VectorOfproperty_decl* property_decls_ = nullptr;

  VectorOfsequence_decl* sequence_decls_ = nullptr;

  VectorOfconcurrent_assertions* concurrent_assertions_ = nullptr;

  VectorOfnamed_event* named_events_ = nullptr;

  VectorOfnamed_event_array* named_event_arrays_ = nullptr;

  VectorOfvariables* variables_ = nullptr;

  VectorOfvirtual_interface_var* virtual_interface_vars_ = nullptr;

  VectorOflogic_var* logic_vars_ = nullptr;

  VectorOfarray_var* array_vars_ = nullptr;

  VectorOfarray_var* array_var_mems_ = nullptr;

  VectorOfany* parameters_ = nullptr;

  VectorOfparam_assign* param_assigns_ = nullptr;

  VectorOfscope* scopes_ = nullptr;

  VectorOftypespec* typespecs_ = nullptr;

  VectorOfany* instance_items_ = nullptr;

  VectorOflet_decl* let_decls_ = nullptr;

  VectorOfattribute* attributes_ = nullptr;
};

#if 0 // This class cannot be instantiated
typedef FactoryT<scope> scopeFactory;
#endif

typedef FactoryT<std::vector<scope *>> VectorOfscopeFactory;

}  // namespace UHDM

#endif
