/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   io_decl.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_IO_DECL_H
#define UHDM_IO_DECL_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "ref_obj_interf_net_var_group.h"


namespace UHDM {
class expr;
class typespec;

class io_decl final : public BaseClass {
  UHDM_IMPLEMENT_RTTI(io_decl, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: io_decl();
  virtual ~io_decl() final = default;

  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; return true; }

  virtual bool VpiFile(std::string_view data) final;

  virtual std::string_view VpiFile() const final;

  virtual unsigned int UhdmId() const final { return uhdmId_; }

  virtual bool UhdmId(unsigned int data) final { uhdmId_ = data; return true; }

  unsigned int VpiType() const final { return vpiIODecl; }

  int VpiDirection() const { return vpiDirection_; }

  bool VpiDirection(int data) { vpiDirection_ = data; return true; }

  virtual bool VpiName(std::string_view data) final;

  virtual std::string_view VpiName() const final;

  bool VpiScalar() const { return vpiScalar_; }

  bool VpiScalar(bool data) { vpiScalar_ = data; return true; }

  bool VpiSigned() const { return vpiSigned_; }

  bool VpiSigned(bool data) { vpiSigned_ = data; return true; }

  int VpiSize() const { return vpiSize_; }

  bool VpiSize(int data) { vpiSize_ = data; return true; }

  bool VpiVector() const { return vpiVector_; }

  bool VpiVector(bool data) { vpiVector_ = data; return true; }

  const any* Expr() const { return expr_; }

  bool Expr(any* data) { if (!ref_obj_interf_net_var_groupGroupCompliant(data)) return false; expr_ = data; return true; }

  const expr* Left_expr() const { return left_expr_; }

  bool Left_expr(expr* data) { left_expr_ = data; return true; }

  const expr* Right_expr() const { return right_expr_; }

  bool Right_expr(expr* data) { right_expr_ = data; return true; }

  VectorOfrange* Ranges() const { return ranges_; }

  bool Ranges(VectorOfrange* data) { ranges_ = data; return true; }

  const typespec* Typespec() const { return typespec_; }

  bool Typespec(typespec* data) { typespec_ = data; return true; }

  virtual io_decl* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmio_decl; }

protected:
  void DeepCopy(io_decl* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  BaseClass* vpiParent_ = nullptr;

  SymbolId vpiFile_;

  unsigned int uhdmId_ = 0;

  int vpiDirection_ = 0;

  SymbolId vpiName_;

  bool vpiScalar_ = false;

  bool vpiSigned_ = false;

  int vpiSize_ = 0;

  bool vpiVector_ = false;

  any* expr_ = nullptr;

  expr* left_expr_ = nullptr;

  expr* right_expr_ = nullptr;

  VectorOfrange* ranges_ = nullptr;

  typespec* typespec_ = nullptr;
};


typedef FactoryT<io_decl> io_declFactory;


typedef FactoryT<std::vector<io_decl *>> VectorOfio_declFactory;

}  // namespace UHDM

#endif
