/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   class_typespec.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_CLASS_TYPESPEC_H
#define UHDM_CLASS_TYPESPEC_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/typespec.h>

#include "parameters.h"


namespace UHDM {
class class_defn;
class class_typespec;

class class_typespec final : public typespec {
  UHDM_IMPLEMENT_RTTI(class_typespec, typespec)
public:
  // Implicit constructor used to initialize all members,
  // comment: class_typespec();
  virtual ~class_typespec() final = default;

  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; return true; }

  virtual bool VpiFile(std::string_view data) final;

  virtual std::string_view VpiFile() const final;

  virtual unsigned int UhdmId() const final { return uhdmId_; }

  virtual bool UhdmId(unsigned int data) final { uhdmId_ = data; return true; }

  int VpiClassType() const { return vpiClassType_; }

  bool VpiClassType(int data) { vpiClassType_ = data; return true; }

  bool VpiAutomatic() const { return vpiAutomatic_; }

  bool VpiAutomatic(bool data) { vpiAutomatic_ = data; return true; }

  const class_typespec* Class_typespec() const { return class_typespec_; }

  bool Class_typespec(class_typespec* data) { class_typespec_ = data; return true; }

  VectorOfvariables* Variables() const { return variables_; }

  bool Variables(VectorOfvariables* data) { variables_ = data; return true; }

  VectorOftask_func* Task_funcs() const { return task_funcs_; }

  bool Task_funcs(VectorOftask_func* data) { task_funcs_ = data; return true; }

  VectorOfconstraint* Constraints() const { return constraints_; }

  bool Constraints(VectorOfconstraint* data) { constraints_ = data; return true; }

  VectorOfany* Parameters() const { return parameters_; }

  bool Parameters(VectorOfany* data) { if (!parametersGroupCompliant(data)) return false; parameters_ = data; return true; }

  VectorOfparam_assign* Param_assigns() const { return param_assigns_; }

  bool Param_assigns(VectorOfparam_assign* data) { param_assigns_ = data; return true; }

  VectorOfvirtual_interface_var* Virtual_interface_vars() const { return virtual_interface_vars_; }

  bool Virtual_interface_vars(VectorOfvirtual_interface_var* data) { virtual_interface_vars_ = data; return true; }

  VectorOfnamed_event* Named_events() const { return named_events_; }

  bool Named_events(VectorOfnamed_event* data) { named_events_ = data; return true; }

  VectorOfnamed_event_array* Named_event_arrays() const { return named_event_arrays_; }

  bool Named_event_arrays(VectorOfnamed_event_array* data) { named_event_arrays_ = data; return true; }

  VectorOfscope* Scopes() const { return scopes_; }

  bool Scopes(VectorOfscope* data) { scopes_ = data; return true; }

  const class_defn* Class_defn() const { return class_defn_; }

  bool Class_defn(class_defn* data) { class_defn_ = data; return true; }

  virtual unsigned int VpiType() const final { return vpiClassTypespec; }

  virtual class_typespec* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmclass_typespec; }

protected:
  void DeepCopy(class_typespec* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  BaseClass* vpiParent_ = nullptr;

  SymbolId vpiFile_;

  unsigned int uhdmId_ = 0;

  int vpiClassType_ = 0;

  bool vpiAutomatic_ = false;

  class_typespec* class_typespec_ = nullptr;

  VectorOfvariables* variables_ = nullptr;

  VectorOftask_func* task_funcs_ = nullptr;

  VectorOfconstraint* constraints_ = nullptr;

  VectorOfany* parameters_ = nullptr;

  VectorOfparam_assign* param_assigns_ = nullptr;

  VectorOfvirtual_interface_var* virtual_interface_vars_ = nullptr;

  VectorOfnamed_event* named_events_ = nullptr;

  VectorOfnamed_event_array* named_event_arrays_ = nullptr;

  VectorOfscope* scopes_ = nullptr;

  class_defn* class_defn_ = nullptr;
};


typedef FactoryT<class_typespec> class_typespecFactory;


typedef FactoryT<std::vector<class_typespec *>> VectorOfclass_typespecFactory;

}  // namespace UHDM

#endif
