/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   design.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_DESIGN_H
#define UHDM_DESIGN_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "parameters.h"


namespace UHDM {


class design final : public BaseClass {
  UHDM_IMPLEMENT_RTTI(design, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: design();
  virtual ~design() final = default;

  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; return true; }

  virtual bool VpiFile(std::string_view data) final;

  virtual const std::string& VpiFile() const final;

  virtual unsigned int UhdmId() const final { return uhdmId_; }

  virtual bool UhdmId(unsigned int data) final { uhdmId_ = data; return true; }

  bool VpiElaborated() const { return vpiElaborated_; }

  bool VpiElaborated(bool data) { vpiElaborated_ = data; return true; }

  virtual bool VpiName(std::string_view data) final;

  virtual const std::string& VpiName() const final;

  unsigned int VpiType() const final { return vpiDesign; }

  VectorOfinclude_file_info* Include_file_infos() const { return include_file_infos_; }

  bool Include_file_infos(VectorOfinclude_file_info* data) { include_file_infos_ = data; return true; }

  VectorOfpackage* AllPackages() const { return allPackages_; }

  bool AllPackages(VectorOfpackage* data) { allPackages_ = data; return true; }

  VectorOfpackage* TopPackages() const { return topPackages_; }

  bool TopPackages(VectorOfpackage* data) { topPackages_ = data; return true; }

  VectorOfclass_defn* AllClasses() const { return allClasses_; }

  bool AllClasses(VectorOfclass_defn* data) { allClasses_ = data; return true; }

  VectorOfinterface* AllInterfaces() const { return allInterfaces_; }

  bool AllInterfaces(VectorOfinterface* data) { allInterfaces_ = data; return true; }

  VectorOfudp_defn* AllUdps() const { return allUdps_; }

  bool AllUdps(VectorOfudp_defn* data) { allUdps_ = data; return true; }

  VectorOfprogram* AllPrograms() const { return allPrograms_; }

  bool AllPrograms(VectorOfprogram* data) { allPrograms_ = data; return true; }

  VectorOfmodule* AllModules() const { return allModules_; }

  bool AllModules(VectorOfmodule* data) { allModules_ = data; return true; }

  VectorOftypespec* Typespecs() const { return typespecs_; }

  bool Typespecs(VectorOftypespec* data) { typespecs_ = data; return true; }

  VectorOflet_decl* Let_decls() const { return let_decls_; }

  bool Let_decls(VectorOflet_decl* data) { let_decls_ = data; return true; }

  VectorOftask_func* Task_funcs() const { return task_funcs_; }

  bool Task_funcs(VectorOftask_func* data) { task_funcs_ = data; return true; }

  VectorOfany* Parameters() const { return parameters_; }

  bool Parameters(VectorOfany* data) { if (!parametersGroupCompliant(data)) return false; parameters_ = data; return true; }

  VectorOfparam_assign* Param_assigns() const { return param_assigns_; }

  bool Param_assigns(VectorOfparam_assign* data) { param_assigns_ = data; return true; }

  VectorOfmodule* TopModules() const { return topModules_; }

  bool TopModules(VectorOfmodule* data) { topModules_ = data; return true; }

  virtual design* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmdesign; }

protected:
  void DeepCopy(design* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  BaseClass* vpiParent_ = nullptr;

  SymbolId vpiFile_;

  unsigned int uhdmId_ = 0;

  bool vpiElaborated_ = false;

  SymbolId vpiName_;

  VectorOfinclude_file_info* include_file_infos_ = nullptr;

  VectorOfpackage* allPackages_ = nullptr;

  VectorOfpackage* topPackages_ = nullptr;

  VectorOfclass_defn* allClasses_ = nullptr;

  VectorOfinterface* allInterfaces_ = nullptr;

  VectorOfudp_defn* allUdps_ = nullptr;

  VectorOfprogram* allPrograms_ = nullptr;

  VectorOfmodule* allModules_ = nullptr;

  VectorOftypespec* typespecs_ = nullptr;

  VectorOflet_decl* let_decls_ = nullptr;

  VectorOftask_func* task_funcs_ = nullptr;

  VectorOfany* parameters_ = nullptr;

  VectorOfparam_assign* param_assigns_ = nullptr;

  VectorOfmodule* topModules_ = nullptr;
};


typedef FactoryT<design> designFactory;


typedef FactoryT<std::vector<design *>> VectorOfdesignFactory;

}  // namespace UHDM

#endif
