/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   tchk.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_TCHK_H
#define UHDM_TCHK_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "expr_tchk_term_group.h"


namespace UHDM {
class expr;
class module;
class reg;
class tchk_term;

class tchk final : public BaseClass {
  UHDM_IMPLEMENT_RTTI(tchk, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: tchk();
  virtual ~tchk() final = default;

  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; return true; }

  virtual bool VpiFile(std::string_view data) final;

  virtual const std::string& VpiFile() const final;

  virtual unsigned int UhdmId() const final { return uhdmId_; }

  virtual bool UhdmId(unsigned int data) final { uhdmId_ = data; return true; }

  const module* Module() const { return module_; }

  bool Module(module* data) { module_ = data; return true; }

  const expr* Expr() const { return expr_; }

  bool Expr(expr* data) { expr_ = data; return true; }

  VectorOfany* Expr_tchk_terms() const { return expr_tchk_terms_; }

  bool Expr_tchk_terms(VectorOfany* data) { if (!expr_tchk_term_groupGroupCompliant(data)) return false; expr_tchk_terms_ = data; return true; }

  const tchk_term* Tchk_ref_term() const { return tchk_ref_term_; }

  bool Tchk_ref_term(tchk_term* data) { tchk_ref_term_ = data; return true; }

  const tchk_term* Tchk_data_term() const { return tchk_data_term_; }

  bool Tchk_data_term(tchk_term* data) { tchk_data_term_ = data; return true; }

  const reg* Reg() const { return reg_; }

  bool Reg(reg* data) { reg_ = data; return true; }

  bool VpiDelay(std::string_view data);

  const std::string& VpiDelay() const;

  int VpiTchkType() const { return vpiTchkType_; }

  bool VpiTchkType(int data) { vpiTchkType_ = data; return true; }

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true; }

  virtual unsigned int VpiType() const final { return vpiTchk; }

  virtual tchk* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmtchk; }

protected:
  void DeepCopy(tchk* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  BaseClass* vpiParent_ = nullptr;

  SymbolId vpiFile_;

  unsigned int uhdmId_ = 0;

  module* module_ = nullptr;

  expr* expr_ = nullptr;

  VectorOfany* expr_tchk_terms_ = nullptr;

  tchk_term* tchk_ref_term_ = nullptr;

  tchk_term* tchk_data_term_ = nullptr;

  reg* reg_ = nullptr;

  SymbolId vpiDelay_;

  int vpiTchkType_ = 0;

  VectorOfattribute* attributes_ = nullptr;
};


typedef FactoryT<tchk> tchkFactory;


typedef FactoryT<std::vector<tchk *>> VectorOftchkFactory;

}  // namespace UHDM

#endif
