// This file is auto-generated by generate_ast_listener.py
// DO NOT EDIT

/*
 Copyright 2019 Alain Dargelas
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 *
 * File:   AstListener.h
 * Author: hs
 *
 */

#ifndef SURELOG_ASTLISTENER_H
#define SURELOG_ASTLISTENER_H
#pragma once

#include <Surelog/Common/NodeId.h>

#include <cstdint>
#include <type_traits>
#include <unordered_set>
#include <vector>

namespace SURELOG {

class AstListener;
class SymbolTable;
class VObject;
struct AstNodeEqualityComparer;
struct AstNodeHash;
struct AstNodeLessComparer;

class AstNode final {
 public:
  AstNode() : m_index(), m_object(nullptr) {}
  AstNode(const AstNode& node)
      : m_index(node.m_index), m_object(node.m_object) {}
  AstNode(const NodeId& index, const VObject* const object)
      : m_index(index), m_object(object) {}

  AstNode& operator=(const AstNode& rhs) {
    if (this != &rhs) {
      m_index = rhs.m_index;
      m_object = rhs.m_object;
    }
    return *this;
  }

 public:
  operator bool() const { return m_index && (m_object != nullptr); }

 private:
  NodeId m_index;
  const VObject* m_object = nullptr;

  friend class AstListener;
  friend struct AstNodeHash;
  friend struct AstNodeEqualityComparer;
  friend struct AstNodeLessComparer;
};

struct AstNodeEqualityComparer final {
  bool operator()(const AstNode& lhs, const AstNode& rhs) const {
    return (lhs.m_index == rhs.m_index) && (lhs.m_object == rhs.m_object);
  }
};

struct AstNodeHash final {
  size_t operator()(const AstNode& node) const {
    return std::hash<uint32_t>()(node.m_index);
  }
};

class AstListener {
 protected:
  typedef std::unordered_set<AstNode, AstNodeHash, AstNodeEqualityComparer>
      astnode_set_t;
  typedef std::vector<AstNode> astnode_stack_t;
  typedef std::vector<AstNode> astnode_vector_t;

 public:
  AstListener() = default;
  virtual ~AstListener() = default;

  virtual void enterSourceFile(const std::filesystem::path& filepath) {}
  virtual void leaveSourceFile(const std::filesystem::path& filepath) {}

  // clang-format off
  virtual void enter0(const SURELOG::AstNode& node) {}
  virtual void leave0(const SURELOG::AstNode& node) {}

  virtual void enter1(const SURELOG::AstNode& node) {}
  virtual void leave1(const SURELOG::AstNode& node) {}

  virtual void enterACCEPT_ON(const SURELOG::AstNode& node) {}
  virtual void leaveACCEPT_ON(const SURELOG::AstNode& node) {}

  virtual void enterALWAYS(const SURELOG::AstNode& node) {}
  virtual void leaveALWAYS(const SURELOG::AstNode& node) {}

  virtual void enterAND(const SURELOG::AstNode& node) {}
  virtual void leaveAND(const SURELOG::AstNode& node) {}

  virtual void enterAccelerate_directive(const SURELOG::AstNode& node) {}
  virtual void leaveAccelerate_directive(const SURELOG::AstNode& node) {}

  virtual void enterAction_block(const SURELOG::AstNode& node) {}
  virtual void leaveAction_block(const SURELOG::AstNode& node) {}

  virtual void enterActual_arg_expr(const SURELOG::AstNode& node) {}
  virtual void leaveActual_arg_expr(const SURELOG::AstNode& node) {}

  virtual void enterActual_arg_list(const SURELOG::AstNode& node) {}
  virtual void leaveActual_arg_list(const SURELOG::AstNode& node) {}

  virtual void enterAlwaysKeywd_Always(const SURELOG::AstNode& node) {}
  virtual void leaveAlwaysKeywd_Always(const SURELOG::AstNode& node) {}

  virtual void enterAlwaysKeywd_Comb(const SURELOG::AstNode& node) {}
  virtual void leaveAlwaysKeywd_Comb(const SURELOG::AstNode& node) {}

  virtual void enterAlwaysKeywd_FF(const SURELOG::AstNode& node) {}
  virtual void leaveAlwaysKeywd_FF(const SURELOG::AstNode& node) {}

  virtual void enterAlwaysKeywd_Latch(const SURELOG::AstNode& node) {}
  virtual void leaveAlwaysKeywd_Latch(const SURELOG::AstNode& node) {}

  virtual void enterAlways_construct(const SURELOG::AstNode& node) {}
  virtual void leaveAlways_construct(const SURELOG::AstNode& node) {}

  virtual void enterAlways_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveAlways_keyword(const SURELOG::AstNode& node) {}

  virtual void enterAnd_call(const SURELOG::AstNode& node) {}
  virtual void leaveAnd_call(const SURELOG::AstNode& node) {}

  virtual void enterAnonymous_program(const SURELOG::AstNode& node) {}
  virtual void leaveAnonymous_program(const SURELOG::AstNode& node) {}

  virtual void enterAnonymous_program_item(const SURELOG::AstNode& node) {}
  virtual void leaveAnonymous_program_item(const SURELOG::AstNode& node) {}

  virtual void enterAnsi_port_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveAnsi_port_declaration(const SURELOG::AstNode& node) {}

  virtual void enterArgument(const SURELOG::AstNode& node) {}
  virtual void leaveArgument(const SURELOG::AstNode& node) {}

  virtual void enterArray_manipulation_call(const SURELOG::AstNode& node) {}
  virtual void leaveArray_manipulation_call(const SURELOG::AstNode& node) {}

  virtual void enterArray_member_label(const SURELOG::AstNode& node) {}
  virtual void leaveArray_member_label(const SURELOG::AstNode& node) {}

  virtual void enterArray_method_name(const SURELOG::AstNode& node) {}
  virtual void leaveArray_method_name(const SURELOG::AstNode& node) {}

  virtual void enterArray_pattern_key(const SURELOG::AstNode& node) {}
  virtual void leaveArray_pattern_key(const SURELOG::AstNode& node) {}

  virtual void enterArray_range_expression(const SURELOG::AstNode& node) {}
  virtual void leaveArray_range_expression(const SURELOG::AstNode& node) {}

  virtual void enterAssert_property_statement(const SURELOG::AstNode& node) {}
  virtual void leaveAssert_property_statement(const SURELOG::AstNode& node) {}

  virtual void enterAssertion_item(const SURELOG::AstNode& node) {}
  virtual void leaveAssertion_item(const SURELOG::AstNode& node) {}

  virtual void enterAssertion_item_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveAssertion_item_declaration(const SURELOG::AstNode& node) {}

  virtual void enterAssertion_variable_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveAssertion_variable_declaration(const SURELOG::AstNode& node) {}

  virtual void enterAssign(const SURELOG::AstNode& node) {}
  virtual void leaveAssign(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_Add(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_Add(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_ArithShiftLeft(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_ArithShiftLeft(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_ArithShiftRight(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_ArithShiftRight(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_Assign(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_Assign(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_BitwAnd(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_BitwAnd(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_BitwLeftShift(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_BitwLeftShift(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_BitwOr(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_BitwOr(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_BitwRightShift(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_BitwRightShift(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_BitwXor(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_BitwXor(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_Div(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_Div(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_Modulo(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_Modulo(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_Mult(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_Mult(const SURELOG::AstNode& node) {}

  virtual void enterAssignOp_Sub(const SURELOG::AstNode& node) {}
  virtual void leaveAssignOp_Sub(const SURELOG::AstNode& node) {}

  virtual void enterAssignment_operator(const SURELOG::AstNode& node) {}
  virtual void leaveAssignment_operator(const SURELOG::AstNode& node) {}

  virtual void enterAssignment_pattern(const SURELOG::AstNode& node) {}
  virtual void leaveAssignment_pattern(const SURELOG::AstNode& node) {}

  virtual void enterAssignment_pattern_expression(const SURELOG::AstNode& node) {}
  virtual void leaveAssignment_pattern_expression(const SURELOG::AstNode& node) {}

  virtual void enterAssignment_pattern_expression_type(const SURELOG::AstNode& node) {}
  virtual void leaveAssignment_pattern_expression_type(const SURELOG::AstNode& node) {}

  virtual void enterAssignment_pattern_key(const SURELOG::AstNode& node) {}
  virtual void leaveAssignment_pattern_key(const SURELOG::AstNode& node) {}

  virtual void enterAssignment_pattern_net_lvalue(const SURELOG::AstNode& node) {}
  virtual void leaveAssignment_pattern_net_lvalue(const SURELOG::AstNode& node) {}

  virtual void enterAssignment_pattern_variable_lvalue(const SURELOG::AstNode& node) {}
  virtual void leaveAssignment_pattern_variable_lvalue(const SURELOG::AstNode& node) {}

  virtual void enterAssociative_dimension(const SURELOG::AstNode& node) {}
  virtual void leaveAssociative_dimension(const SURELOG::AstNode& node) {}

  virtual void enterAssume_property_statement(const SURELOG::AstNode& node) {}
  virtual void leaveAssume_property_statement(const SURELOG::AstNode& node) {}

  virtual void enterAttr_name(const SURELOG::AstNode& node) {}
  virtual void leaveAttr_name(const SURELOG::AstNode& node) {}

  virtual void enterAttr_spec(const SURELOG::AstNode& node) {}
  virtual void leaveAttr_spec(const SURELOG::AstNode& node) {}

  virtual void enterAttribute_instance(const SURELOG::AstNode& node) {}
  virtual void leaveAttribute_instance(const SURELOG::AstNode& node) {}

  virtual void enterAutoexpand_vectornets_directive(const SURELOG::AstNode& node) {}
  virtual void leaveAutoexpand_vectornets_directive(const SURELOG::AstNode& node) {}

  virtual void enterBegin_keywords_directive(const SURELOG::AstNode& node) {}
  virtual void leaveBegin_keywords_directive(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_BitwAnd(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_BitwAnd(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_BitwOr(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_BitwOr(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_BitwXor(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_BitwXor(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_Equiv(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_Equiv(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_LogicAnd(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_LogicAnd(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_LogicOr(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_LogicOr(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_NotEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_NotEqual(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_ReductXnor1(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_ReductXnor1(const SURELOG::AstNode& node) {}

  virtual void enterBinModOp_ReductXnor2(const SURELOG::AstNode& node) {}
  virtual void leaveBinModOp_ReductXnor2(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_ArithShiftLeft(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_ArithShiftLeft(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_ArithShiftRight(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_ArithShiftRight(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_BitwAnd(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_BitwAnd(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_BitwOr(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_BitwOr(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_BitwXor(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_BitwXor(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Div(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Div(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Equiv(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Equiv(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Equivalence(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Equivalence(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_FourStateLogicEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_FourStateLogicEqual(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_FourStateLogicNotEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_FourStateLogicNotEqual(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Great(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Great(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_GreatEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_GreatEqual(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Imply(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Imply(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Less(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Less(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_LessEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_LessEqual(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_LogicAnd(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_LogicAnd(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_LogicOr(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_LogicOr(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Minus(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Minus(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Mult(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Mult(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_MultMult(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_MultMult(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Not(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Not(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Percent(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Percent(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_Plus(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_Plus(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_ReductNand(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_ReductNand(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_ReductNor(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_ReductNor(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_ReductXnor1(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_ReductXnor1(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_ReductXnor2(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_ReductXnor2(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_ShiftLeft(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_ShiftLeft(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_ShiftRight(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_ShiftRight(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_WildEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_WildEqual(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_WildNotEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_WildNotEqual(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_WildcardEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_WildcardEqual(const SURELOG::AstNode& node) {}

  virtual void enterBinOp_WildcardNotEqual(const SURELOG::AstNode& node) {}
  virtual void leaveBinOp_WildcardNotEqual(const SURELOG::AstNode& node) {}

  virtual void enterBind_directive(const SURELOG::AstNode& node) {}
  virtual void leaveBind_directive(const SURELOG::AstNode& node) {}

  virtual void enterBind_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveBind_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterBins_Bins(const SURELOG::AstNode& node) {}
  virtual void leaveBins_Bins(const SURELOG::AstNode& node) {}

  virtual void enterBins_Ignore(const SURELOG::AstNode& node) {}
  virtual void leaveBins_Ignore(const SURELOG::AstNode& node) {}

  virtual void enterBins_Illegal(const SURELOG::AstNode& node) {}
  virtual void leaveBins_Illegal(const SURELOG::AstNode& node) {}

  virtual void enterBins_expression(const SURELOG::AstNode& node) {}
  virtual void leaveBins_expression(const SURELOG::AstNode& node) {}

  virtual void enterBins_or_empty(const SURELOG::AstNode& node) {}
  virtual void leaveBins_or_empty(const SURELOG::AstNode& node) {}

  virtual void enterBins_or_options(const SURELOG::AstNode& node) {}
  virtual void leaveBins_or_options(const SURELOG::AstNode& node) {}

  virtual void enterBins_selection(const SURELOG::AstNode& node) {}
  virtual void leaveBins_selection(const SURELOG::AstNode& node) {}

  virtual void enterBins_selection_or_option(const SURELOG::AstNode& node) {}
  virtual void leaveBins_selection_or_option(const SURELOG::AstNode& node) {}

  virtual void enterBit_select(const SURELOG::AstNode& node) {}
  virtual void leaveBit_select(const SURELOG::AstNode& node) {}

  virtual void enterBlock_event_expression(const SURELOG::AstNode& node) {}
  virtual void leaveBlock_event_expression(const SURELOG::AstNode& node) {}

  virtual void enterBlock_item_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveBlock_item_declaration(const SURELOG::AstNode& node) {}

  virtual void enterBlocking_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveBlocking_assignment(const SURELOG::AstNode& node) {}

  virtual void enterBoolean_abbrev(const SURELOG::AstNode& node) {}
  virtual void leaveBoolean_abbrev(const SURELOG::AstNode& node) {}

  virtual void enterBreakStmt(const SURELOG::AstNode& node) {}
  virtual void leaveBreakStmt(const SURELOG::AstNode& node) {}

  virtual void enterBuilt_in_method_call(const SURELOG::AstNode& node) {}
  virtual void leaveBuilt_in_method_call(const SURELOG::AstNode& node) {}

  virtual void enterCR(const SURELOG::AstNode& node) {}
  virtual void leaveCR(const SURELOG::AstNode& node) {}

  virtual void enterCase(const SURELOG::AstNode& node) {}
  virtual void leaveCase(const SURELOG::AstNode& node) {}

  virtual void enterCaseX(const SURELOG::AstNode& node) {}
  virtual void leaveCaseX(const SURELOG::AstNode& node) {}

  virtual void enterCaseZ(const SURELOG::AstNode& node) {}
  virtual void leaveCaseZ(const SURELOG::AstNode& node) {}

  virtual void enterCase_generate_construct(const SURELOG::AstNode& node) {}
  virtual void leaveCase_generate_construct(const SURELOG::AstNode& node) {}

  virtual void enterCase_generate_item(const SURELOG::AstNode& node) {}
  virtual void leaveCase_generate_item(const SURELOG::AstNode& node) {}

  virtual void enterCase_inside_item(const SURELOG::AstNode& node) {}
  virtual void leaveCase_inside_item(const SURELOG::AstNode& node) {}

  virtual void enterCase_item(const SURELOG::AstNode& node) {}
  virtual void leaveCase_item(const SURELOG::AstNode& node) {}

  virtual void enterCase_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveCase_keyword(const SURELOG::AstNode& node) {}

  virtual void enterCase_pattern_item(const SURELOG::AstNode& node) {}
  virtual void leaveCase_pattern_item(const SURELOG::AstNode& node) {}

  virtual void enterCase_statement(const SURELOG::AstNode& node) {}
  virtual void leaveCase_statement(const SURELOG::AstNode& node) {}

  virtual void enterCast(const SURELOG::AstNode& node) {}
  virtual void leaveCast(const SURELOG::AstNode& node) {}

  virtual void enterCasting_type(const SURELOG::AstNode& node) {}
  virtual void leaveCasting_type(const SURELOG::AstNode& node) {}

  virtual void enterCell_clause(const SURELOG::AstNode& node) {}
  virtual void leaveCell_clause(const SURELOG::AstNode& node) {}

  virtual void enterCelldefine_directive(const SURELOG::AstNode& node) {}
  virtual void leaveCelldefine_directive(const SURELOG::AstNode& node) {}

  virtual void enterChandle_type(const SURELOG::AstNode& node) {}
  virtual void leaveChandle_type(const SURELOG::AstNode& node) {}

  virtual void enterCharge_strength(const SURELOG::AstNode& node) {}
  virtual void leaveCharge_strength(const SURELOG::AstNode& node) {}

  virtual void enterChecker(const SURELOG::AstNode& node) {}
  virtual void leaveChecker(const SURELOG::AstNode& node) {}

  virtual void enterChecker_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveChecker_declaration(const SURELOG::AstNode& node) {}

  virtual void enterChecker_generate_item(const SURELOG::AstNode& node) {}
  virtual void leaveChecker_generate_item(const SURELOG::AstNode& node) {}

  virtual void enterChecker_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveChecker_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterChecker_or_generate_item(const SURELOG::AstNode& node) {}
  virtual void leaveChecker_or_generate_item(const SURELOG::AstNode& node) {}

  virtual void enterChecker_or_generate_item_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveChecker_or_generate_item_declaration(const SURELOG::AstNode& node) {}

  virtual void enterChecker_port_item(const SURELOG::AstNode& node) {}
  virtual void leaveChecker_port_item(const SURELOG::AstNode& node) {}

  virtual void enterChecker_port_list(const SURELOG::AstNode& node) {}
  virtual void leaveChecker_port_list(const SURELOG::AstNode& node) {}

  virtual void enterClass(const SURELOG::AstNode& node) {}
  virtual void leaveClass(const SURELOG::AstNode& node) {}

  virtual void enterClassItemQualifier_Local(const SURELOG::AstNode& node) {}
  virtual void leaveClassItemQualifier_Local(const SURELOG::AstNode& node) {}

  virtual void enterClassItemQualifier_Protected(const SURELOG::AstNode& node) {}
  virtual void leaveClassItemQualifier_Protected(const SURELOG::AstNode& node) {}

  virtual void enterClassItemQualifier_Static(const SURELOG::AstNode& node) {}
  virtual void leaveClassItemQualifier_Static(const SURELOG::AstNode& node) {}

  virtual void enterClass_constraint(const SURELOG::AstNode& node) {}
  virtual void leaveClass_constraint(const SURELOG::AstNode& node) {}

  virtual void enterClass_constructor_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveClass_constructor_declaration(const SURELOG::AstNode& node) {}

  virtual void enterClass_constructor_prototype(const SURELOG::AstNode& node) {}
  virtual void leaveClass_constructor_prototype(const SURELOG::AstNode& node) {}

  virtual void enterClass_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveClass_declaration(const SURELOG::AstNode& node) {}

  virtual void enterClass_item(const SURELOG::AstNode& node) {}
  virtual void leaveClass_item(const SURELOG::AstNode& node) {}

  virtual void enterClass_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveClass_keyword(const SURELOG::AstNode& node) {}

  virtual void enterClass_method(const SURELOG::AstNode& node) {}
  virtual void leaveClass_method(const SURELOG::AstNode& node) {}

  virtual void enterClass_new(const SURELOG::AstNode& node) {}
  virtual void leaveClass_new(const SURELOG::AstNode& node) {}

  virtual void enterClass_property(const SURELOG::AstNode& node) {}
  virtual void leaveClass_property(const SURELOG::AstNode& node) {}

  virtual void enterClass_scope(const SURELOG::AstNode& node) {}
  virtual void leaveClass_scope(const SURELOG::AstNode& node) {}

  virtual void enterClass_type(const SURELOG::AstNode& node) {}
  virtual void leaveClass_type(const SURELOG::AstNode& node) {}

  virtual void enterClockingDir_Inout(const SURELOG::AstNode& node) {}
  virtual void leaveClockingDir_Inout(const SURELOG::AstNode& node) {}

  virtual void enterClockingDir_Input(const SURELOG::AstNode& node) {}
  virtual void leaveClockingDir_Input(const SURELOG::AstNode& node) {}

  virtual void enterClockingDir_InputOutput(const SURELOG::AstNode& node) {}
  virtual void leaveClockingDir_InputOutput(const SURELOG::AstNode& node) {}

  virtual void enterClockingDir_Output(const SURELOG::AstNode& node) {}
  virtual void leaveClockingDir_Output(const SURELOG::AstNode& node) {}

  virtual void enterClocking_decl_assign(const SURELOG::AstNode& node) {}
  virtual void leaveClocking_decl_assign(const SURELOG::AstNode& node) {}

  virtual void enterClocking_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveClocking_declaration(const SURELOG::AstNode& node) {}

  virtual void enterClocking_drive(const SURELOG::AstNode& node) {}
  virtual void leaveClocking_drive(const SURELOG::AstNode& node) {}

  virtual void enterClocking_event(const SURELOG::AstNode& node) {}
  virtual void leaveClocking_event(const SURELOG::AstNode& node) {}

  virtual void enterClocking_item(const SURELOG::AstNode& node) {}
  virtual void leaveClocking_item(const SURELOG::AstNode& node) {}

  virtual void enterClocking_skew(const SURELOG::AstNode& node) {}
  virtual void leaveClocking_skew(const SURELOG::AstNode& node) {}

  virtual void enterClockvar(const SURELOG::AstNode& node) {}
  virtual void leaveClockvar(const SURELOG::AstNode& node) {}

  virtual void enterClockvar_expression(const SURELOG::AstNode& node) {}
  virtual void leaveClockvar_expression(const SURELOG::AstNode& node) {}

  virtual void enterCloseParens(const SURELOG::AstNode& node) {}
  virtual void leaveCloseParens(const SURELOG::AstNode& node) {}

  virtual void enterCmosSwitchType_Cmos(const SURELOG::AstNode& node) {}
  virtual void leaveCmosSwitchType_Cmos(const SURELOG::AstNode& node) {}

  virtual void enterCmosSwitchType_RCmos(const SURELOG::AstNode& node) {}
  virtual void leaveCmosSwitchType_RCmos(const SURELOG::AstNode& node) {}

  virtual void enterCmos_switch_instance(const SURELOG::AstNode& node) {}
  virtual void leaveCmos_switch_instance(const SURELOG::AstNode& node) {}

  virtual void enterColumnPartSelectOp(const SURELOG::AstNode& node) {}
  virtual void leaveColumnPartSelectOp(const SURELOG::AstNode& node) {}

  virtual void enterCombinational_body(const SURELOG::AstNode& node) {}
  virtual void leaveCombinational_body(const SURELOG::AstNode& node) {}

  virtual void enterCombinational_entry(const SURELOG::AstNode& node) {}
  virtual void leaveCombinational_entry(const SURELOG::AstNode& node) {}

  virtual void enterComma(const SURELOG::AstNode& node) {}
  virtual void leaveComma(const SURELOG::AstNode& node) {}

  virtual void enterComma_operator(const SURELOG::AstNode& node) {}
  virtual void leaveComma_operator(const SURELOG::AstNode& node) {}

  virtual void enterComments(const SURELOG::AstNode& node) {}
  virtual void leaveComments(const SURELOG::AstNode& node) {}

  virtual void enterComplex_func_call(const SURELOG::AstNode& node) {}
  virtual void leaveComplex_func_call(const SURELOG::AstNode& node) {}

  virtual void enterConcatenation(const SURELOG::AstNode& node) {}
  virtual void leaveConcatenation(const SURELOG::AstNode& node) {}

  virtual void enterConcurrent_assertion_item(const SURELOG::AstNode& node) {}
  virtual void leaveConcurrent_assertion_item(const SURELOG::AstNode& node) {}

  virtual void enterConcurrent_assertion_item_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveConcurrent_assertion_item_declaration(const SURELOG::AstNode& node) {}

  virtual void enterConcurrent_assertion_statement(const SURELOG::AstNode& node) {}
  virtual void leaveConcurrent_assertion_statement(const SURELOG::AstNode& node) {}

  virtual void enterCond_predicate(const SURELOG::AstNode& node) {}
  virtual void leaveCond_predicate(const SURELOG::AstNode& node) {}

  virtual void enterConditional_generate_construct(const SURELOG::AstNode& node) {}
  virtual void leaveConditional_generate_construct(const SURELOG::AstNode& node) {}

  virtual void enterConditional_operator(const SURELOG::AstNode& node) {}
  virtual void leaveConditional_operator(const SURELOG::AstNode& node) {}

  virtual void enterConditional_statement(const SURELOG::AstNode& node) {}
  virtual void leaveConditional_statement(const SURELOG::AstNode& node) {}

  virtual void enterConfig(const SURELOG::AstNode& node) {}
  virtual void leaveConfig(const SURELOG::AstNode& node) {}

  virtual void enterConfig_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveConfig_declaration(const SURELOG::AstNode& node) {}

  virtual void enterConfig_rule_statement(const SURELOG::AstNode& node) {}
  virtual void leaveConfig_rule_statement(const SURELOG::AstNode& node) {}

  virtual void enterConsecutive_repetition(const SURELOG::AstNode& node) {}
  virtual void leaveConsecutive_repetition(const SURELOG::AstNode& node) {}

  virtual void enterConstSelect(const SURELOG::AstNode& node) {}
  virtual void leaveConstSelect(const SURELOG::AstNode& node) {}

  virtual void enterConst_or_range_expression(const SURELOG::AstNode& node) {}
  virtual void leaveConst_or_range_expression(const SURELOG::AstNode& node) {}

  virtual void enterConst_type(const SURELOG::AstNode& node) {}
  virtual void leaveConst_type(const SURELOG::AstNode& node) {}

  virtual void enterConstantSelect(const SURELOG::AstNode& node) {}
  virtual void leaveConstantSelect(const SURELOG::AstNode& node) {}

  virtual void enterConstant_assignment_pattern_expression(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_assignment_pattern_expression(const SURELOG::AstNode& node) {}

  virtual void enterConstant_bit_select(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_bit_select(const SURELOG::AstNode& node) {}

  virtual void enterConstant_cast(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_cast(const SURELOG::AstNode& node) {}

  virtual void enterConstant_concatenation(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_concatenation(const SURELOG::AstNode& node) {}

  virtual void enterConstant_expression(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_expression(const SURELOG::AstNode& node) {}

  virtual void enterConstant_indexed_range(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_indexed_range(const SURELOG::AstNode& node) {}

  virtual void enterConstant_mintypmax_expression(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_mintypmax_expression(const SURELOG::AstNode& node) {}

  virtual void enterConstant_multiple_concatenation(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_multiple_concatenation(const SURELOG::AstNode& node) {}

  virtual void enterConstant_param_expression(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_param_expression(const SURELOG::AstNode& node) {}

  virtual void enterConstant_part_select_range(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_part_select_range(const SURELOG::AstNode& node) {}

  virtual void enterConstant_primary(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_primary(const SURELOG::AstNode& node) {}

  virtual void enterConstant_range(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_range(const SURELOG::AstNode& node) {}

  virtual void enterConstant_range_expression(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_range_expression(const SURELOG::AstNode& node) {}

  virtual void enterConstant_select(const SURELOG::AstNode& node) {}
  virtual void leaveConstant_select(const SURELOG::AstNode& node) {}

  virtual void enterConstraint_block(const SURELOG::AstNode& node) {}
  virtual void leaveConstraint_block(const SURELOG::AstNode& node) {}

  virtual void enterConstraint_block_item(const SURELOG::AstNode& node) {}
  virtual void leaveConstraint_block_item(const SURELOG::AstNode& node) {}

  virtual void enterConstraint_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveConstraint_declaration(const SURELOG::AstNode& node) {}

  virtual void enterConstraint_expression(const SURELOG::AstNode& node) {}
  virtual void leaveConstraint_expression(const SURELOG::AstNode& node) {}

  virtual void enterConstraint_primary(const SURELOG::AstNode& node) {}
  virtual void leaveConstraint_primary(const SURELOG::AstNode& node) {}

  virtual void enterConstraint_prototype(const SURELOG::AstNode& node) {}
  virtual void leaveConstraint_prototype(const SURELOG::AstNode& node) {}

  virtual void enterConstraint_set(const SURELOG::AstNode& node) {}
  virtual void leaveConstraint_set(const SURELOG::AstNode& node) {}

  virtual void enterContext_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveContext_keyword(const SURELOG::AstNode& node) {}

  virtual void enterContinueStmt(const SURELOG::AstNode& node) {}
  virtual void leaveContinueStmt(const SURELOG::AstNode& node) {}

  virtual void enterContinuous_assign(const SURELOG::AstNode& node) {}
  virtual void leaveContinuous_assign(const SURELOG::AstNode& node) {}

  virtual void enterControlled_timing_check_event(const SURELOG::AstNode& node) {}
  virtual void leaveControlled_timing_check_event(const SURELOG::AstNode& node) {}

  virtual void enterCover_cross(const SURELOG::AstNode& node) {}
  virtual void leaveCover_cross(const SURELOG::AstNode& node) {}

  virtual void enterCover_point(const SURELOG::AstNode& node) {}
  virtual void leaveCover_point(const SURELOG::AstNode& node) {}

  virtual void enterCover_property_statement(const SURELOG::AstNode& node) {}
  virtual void leaveCover_property_statement(const SURELOG::AstNode& node) {}

  virtual void enterCover_sequence_statement(const SURELOG::AstNode& node) {}
  virtual void leaveCover_sequence_statement(const SURELOG::AstNode& node) {}

  virtual void enterCoverage_event(const SURELOG::AstNode& node) {}
  virtual void leaveCoverage_event(const SURELOG::AstNode& node) {}

  virtual void enterCoverage_option(const SURELOG::AstNode& node) {}
  virtual void leaveCoverage_option(const SURELOG::AstNode& node) {}

  virtual void enterCoverage_spec(const SURELOG::AstNode& node) {}
  virtual void leaveCoverage_spec(const SURELOG::AstNode& node) {}

  virtual void enterCoverage_spec_or_option(const SURELOG::AstNode& node) {}
  virtual void leaveCoverage_spec_or_option(const SURELOG::AstNode& node) {}

  virtual void enterCovergroup_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveCovergroup_declaration(const SURELOG::AstNode& node) {}

  virtual void enterCross_body(const SURELOG::AstNode& node) {}
  virtual void leaveCross_body(const SURELOG::AstNode& node) {}

  virtual void enterCross_body_item(const SURELOG::AstNode& node) {}
  virtual void leaveCross_body_item(const SURELOG::AstNode& node) {}

  virtual void enterCross_item(const SURELOG::AstNode& node) {}
  virtual void leaveCross_item(const SURELOG::AstNode& node) {}

  virtual void enterCycle_delay(const SURELOG::AstNode& node) {}
  virtual void leaveCycle_delay(const SURELOG::AstNode& node) {}

  virtual void enterCycle_delay_const_range_expression(const SURELOG::AstNode& node) {}
  virtual void leaveCycle_delay_const_range_expression(const SURELOG::AstNode& node) {}

  virtual void enterCycle_delay_range(const SURELOG::AstNode& node) {}
  virtual void leaveCycle_delay_range(const SURELOG::AstNode& node) {}

  virtual void enterData_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveData_declaration(const SURELOG::AstNode& node) {}

  virtual void enterData_type(const SURELOG::AstNode& node) {}
  virtual void leaveData_type(const SURELOG::AstNode& node) {}

  virtual void enterData_type_or_implicit(const SURELOG::AstNode& node) {}
  virtual void leaveData_type_or_implicit(const SURELOG::AstNode& node) {}

  virtual void enterData_type_or_void(const SURELOG::AstNode& node) {}
  virtual void leaveData_type_or_void(const SURELOG::AstNode& node) {}

  virtual void enterDeassign(const SURELOG::AstNode& node) {}
  virtual void leaveDeassign(const SURELOG::AstNode& node) {}

  virtual void enterDecPartSelectOp(const SURELOG::AstNode& node) {}
  virtual void leaveDecPartSelectOp(const SURELOG::AstNode& node) {}

  virtual void enterDefault(const SURELOG::AstNode& node) {}
  virtual void leaveDefault(const SURELOG::AstNode& node) {}

  virtual void enterDefaultSkew_Intput(const SURELOG::AstNode& node) {}
  virtual void leaveDefaultSkew_Intput(const SURELOG::AstNode& node) {}

  virtual void enterDefaultSkew_IntputOutput(const SURELOG::AstNode& node) {}
  virtual void leaveDefaultSkew_IntputOutput(const SURELOG::AstNode& node) {}

  virtual void enterDefaultSkew_Output(const SURELOG::AstNode& node) {}
  virtual void leaveDefaultSkew_Output(const SURELOG::AstNode& node) {}

  virtual void enterDefault_clause(const SURELOG::AstNode& node) {}
  virtual void leaveDefault_clause(const SURELOG::AstNode& node) {}

  virtual void enterDefault_decay_time_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDefault_decay_time_directive(const SURELOG::AstNode& node) {}

  virtual void enterDefault_nettype_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDefault_nettype_directive(const SURELOG::AstNode& node) {}

  virtual void enterDefault_trireg_strenght_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDefault_trireg_strenght_directive(const SURELOG::AstNode& node) {}

  virtual void enterDefault_value(const SURELOG::AstNode& node) {}
  virtual void leaveDefault_value(const SURELOG::AstNode& node) {}

  virtual void enterDeferred_immediate_assert_statement(const SURELOG::AstNode& node) {}
  virtual void leaveDeferred_immediate_assert_statement(const SURELOG::AstNode& node) {}

  virtual void enterDeferred_immediate_assertion_item(const SURELOG::AstNode& node) {}
  virtual void leaveDeferred_immediate_assertion_item(const SURELOG::AstNode& node) {}

  virtual void enterDeferred_immediate_assertion_statement(const SURELOG::AstNode& node) {}
  virtual void leaveDeferred_immediate_assertion_statement(const SURELOG::AstNode& node) {}

  virtual void enterDeferred_immediate_assume_statement(const SURELOG::AstNode& node) {}
  virtual void leaveDeferred_immediate_assume_statement(const SURELOG::AstNode& node) {}

  virtual void enterDeferred_immediate_cover_statement(const SURELOG::AstNode& node) {}
  virtual void leaveDeferred_immediate_cover_statement(const SURELOG::AstNode& node) {}

  virtual void enterDefine_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDefine_directive(const SURELOG::AstNode& node) {}

  virtual void enterDefparam_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveDefparam_assignment(const SURELOG::AstNode& node) {}

  virtual void enterDelay2(const SURELOG::AstNode& node) {}
  virtual void leaveDelay2(const SURELOG::AstNode& node) {}

  virtual void enterDelay3(const SURELOG::AstNode& node) {}
  virtual void leaveDelay3(const SURELOG::AstNode& node) {}

  virtual void enterDelay_control(const SURELOG::AstNode& node) {}
  virtual void leaveDelay_control(const SURELOG::AstNode& node) {}

  virtual void enterDelay_mode_distributed_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDelay_mode_distributed_directive(const SURELOG::AstNode& node) {}

  virtual void enterDelay_mode_path_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDelay_mode_path_directive(const SURELOG::AstNode& node) {}

  virtual void enterDelay_mode_unit_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDelay_mode_unit_directive(const SURELOG::AstNode& node) {}

  virtual void enterDelay_mode_zero_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDelay_mode_zero_directive(const SURELOG::AstNode& node) {}

  virtual void enterDelay_or_event_control(const SURELOG::AstNode& node) {}
  virtual void leaveDelay_or_event_control(const SURELOG::AstNode& node) {}

  virtual void enterDelay_value(const SURELOG::AstNode& node) {}
  virtual void leaveDelay_value(const SURELOG::AstNode& node) {}

  virtual void enterDelayed_data(const SURELOG::AstNode& node) {}
  virtual void leaveDelayed_data(const SURELOG::AstNode& node) {}

  virtual void enterDelayed_reference(const SURELOG::AstNode& node) {}
  virtual void leaveDelayed_reference(const SURELOG::AstNode& node) {}

  virtual void enterDescription(const SURELOG::AstNode& node) {}
  virtual void leaveDescription(const SURELOG::AstNode& node) {}

  virtual void enterDesign_statement(const SURELOG::AstNode& node) {}
  virtual void leaveDesign_statement(const SURELOG::AstNode& node) {}

  virtual void enterDirective_in_macro(const SURELOG::AstNode& node) {}
  virtual void leaveDirective_in_macro(const SURELOG::AstNode& node) {}

  virtual void enterDisable_portfaults_directive(const SURELOG::AstNode& node) {}
  virtual void leaveDisable_portfaults_directive(const SURELOG::AstNode& node) {}

  virtual void enterDisable_statement(const SURELOG::AstNode& node) {}
  virtual void leaveDisable_statement(const SURELOG::AstNode& node) {}

  virtual void enterDistWeight_AssignRange(const SURELOG::AstNode& node) {}
  virtual void leaveDistWeight_AssignRange(const SURELOG::AstNode& node) {}

  virtual void enterDistWeight_AssignValue(const SURELOG::AstNode& node) {}
  virtual void leaveDistWeight_AssignValue(const SURELOG::AstNode& node) {}

  virtual void enterDist_item(const SURELOG::AstNode& node) {}
  virtual void leaveDist_item(const SURELOG::AstNode& node) {}

  virtual void enterDist_list(const SURELOG::AstNode& node) {}
  virtual void leaveDist_list(const SURELOG::AstNode& node) {}

  virtual void enterDo(const SURELOG::AstNode& node) {}
  virtual void leaveDo(const SURELOG::AstNode& node) {}

  virtual void enterDollar_fullskew_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_fullskew_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_hold_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_hold_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_keyword(const SURELOG::AstNode& node) {}

  virtual void enterDollar_nochange_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_nochange_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_period_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_period_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_recovery_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_recovery_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_recrem_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_recrem_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_removal_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_removal_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_root_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_root_keyword(const SURELOG::AstNode& node) {}

  virtual void enterDollar_setup_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_setup_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_setuphold_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_setuphold_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_skew_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_skew_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_timeskew_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_timeskew_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDollar_width_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveDollar_width_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterDot(const SURELOG::AstNode& node) {}
  virtual void leaveDot(const SURELOG::AstNode& node) {}

  virtual void enterDotStar(const SURELOG::AstNode& node) {}
  virtual void leaveDotStar(const SURELOG::AstNode& node) {}

  virtual void enterDpi_import_export(const SURELOG::AstNode& node) {}
  virtual void leaveDpi_import_export(const SURELOG::AstNode& node) {}

  virtual void enterDrive_strength(const SURELOG::AstNode& node) {}
  virtual void leaveDrive_strength(const SURELOG::AstNode& node) {}

  virtual void enterDynamic_array_new(const SURELOG::AstNode& node) {}
  virtual void leaveDynamic_array_new(const SURELOG::AstNode& node) {}

  virtual void enterEVENTUALLY(const SURELOG::AstNode& node) {}
  virtual void leaveEVENTUALLY(const SURELOG::AstNode& node) {}

  virtual void enterEdge_Edge(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_Edge(const SURELOG::AstNode& node) {}

  virtual void enterEdge_Negedge(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_Negedge(const SURELOG::AstNode& node) {}

  virtual void enterEdge_Posedge(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_Posedge(const SURELOG::AstNode& node) {}

  virtual void enterEdge_control_specifier(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_control_specifier(const SURELOG::AstNode& node) {}

  virtual void enterEdge_descriptor(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_descriptor(const SURELOG::AstNode& node) {}

  virtual void enterEdge_identifier(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_identifier(const SURELOG::AstNode& node) {}

  virtual void enterEdge_indicator(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_indicator(const SURELOG::AstNode& node) {}

  virtual void enterEdge_input_list(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_input_list(const SURELOG::AstNode& node) {}

  virtual void enterEdge_sensitive_path_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_sensitive_path_declaration(const SURELOG::AstNode& node) {}

  virtual void enterEdge_symbol(const SURELOG::AstNode& node) {}
  virtual void leaveEdge_symbol(const SURELOG::AstNode& node) {}

  virtual void enterElaboration_system_task(const SURELOG::AstNode& node) {}
  virtual void leaveElaboration_system_task(const SURELOG::AstNode& node) {}

  virtual void enterElse(const SURELOG::AstNode& node) {}
  virtual void leaveElse(const SURELOG::AstNode& node) {}

  virtual void enterElse_directive(const SURELOG::AstNode& node) {}
  virtual void leaveElse_directive(const SURELOG::AstNode& node) {}

  virtual void enterElseif_directive(const SURELOG::AstNode& node) {}
  virtual void leaveElseif_directive(const SURELOG::AstNode& node) {}

  virtual void enterElseif_directive_in_macro_body(const SURELOG::AstNode& node) {}
  virtual void leaveElseif_directive_in_macro_body(const SURELOG::AstNode& node) {}

  virtual void enterElsif_directive(const SURELOG::AstNode& node) {}
  virtual void leaveElsif_directive(const SURELOG::AstNode& node) {}

  virtual void enterElsif_directive_in_macro_body(const SURELOG::AstNode& node) {}
  virtual void leaveElsif_directive_in_macro_body(const SURELOG::AstNode& node) {}

  virtual void enterEmpty_queue(const SURELOG::AstNode& node) {}
  virtual void leaveEmpty_queue(const SURELOG::AstNode& node) {}

  virtual void enterEnableGateType_Bufif0(const SURELOG::AstNode& node) {}
  virtual void leaveEnableGateType_Bufif0(const SURELOG::AstNode& node) {}

  virtual void enterEnableGateType_Bufif1(const SURELOG::AstNode& node) {}
  virtual void leaveEnableGateType_Bufif1(const SURELOG::AstNode& node) {}

  virtual void enterEnableGateType_Notif0(const SURELOG::AstNode& node) {}
  virtual void leaveEnableGateType_Notif0(const SURELOG::AstNode& node) {}

  virtual void enterEnableGateType_Notif1(const SURELOG::AstNode& node) {}
  virtual void leaveEnableGateType_Notif1(const SURELOG::AstNode& node) {}

  virtual void enterEnable_gate_instance(const SURELOG::AstNode& node) {}
  virtual void leaveEnable_gate_instance(const SURELOG::AstNode& node) {}

  virtual void enterEnable_portfaults_directive(const SURELOG::AstNode& node) {}
  virtual void leaveEnable_portfaults_directive(const SURELOG::AstNode& node) {}

  virtual void enterEnd(const SURELOG::AstNode& node) {}
  virtual void leaveEnd(const SURELOG::AstNode& node) {}

  virtual void enterEnd_edge_offset(const SURELOG::AstNode& node) {}
  virtual void leaveEnd_edge_offset(const SURELOG::AstNode& node) {}

  virtual void enterEnd_keywords_directive(const SURELOG::AstNode& node) {}
  virtual void leaveEnd_keywords_directive(const SURELOG::AstNode& node) {}

  virtual void enterEndcase(const SURELOG::AstNode& node) {}
  virtual void leaveEndcase(const SURELOG::AstNode& node) {}

  virtual void enterEndcelldefine_directive(const SURELOG::AstNode& node) {}
  virtual void leaveEndcelldefine_directive(const SURELOG::AstNode& node) {}

  virtual void enterEndchecker(const SURELOG::AstNode& node) {}
  virtual void leaveEndchecker(const SURELOG::AstNode& node) {}

  virtual void enterEndclass(const SURELOG::AstNode& node) {}
  virtual void leaveEndclass(const SURELOG::AstNode& node) {}

  virtual void enterEndclocking(const SURELOG::AstNode& node) {}
  virtual void leaveEndclocking(const SURELOG::AstNode& node) {}

  virtual void enterEndconfig(const SURELOG::AstNode& node) {}
  virtual void leaveEndconfig(const SURELOG::AstNode& node) {}

  virtual void enterEndfunction(const SURELOG::AstNode& node) {}
  virtual void leaveEndfunction(const SURELOG::AstNode& node) {}

  virtual void enterEndgenerate(const SURELOG::AstNode& node) {}
  virtual void leaveEndgenerate(const SURELOG::AstNode& node) {}

  virtual void enterEndgroup(const SURELOG::AstNode& node) {}
  virtual void leaveEndgroup(const SURELOG::AstNode& node) {}

  virtual void enterEndif_directive(const SURELOG::AstNode& node) {}
  virtual void leaveEndif_directive(const SURELOG::AstNode& node) {}

  virtual void enterEndinterface(const SURELOG::AstNode& node) {}
  virtual void leaveEndinterface(const SURELOG::AstNode& node) {}

  virtual void enterEndmodule(const SURELOG::AstNode& node) {}
  virtual void leaveEndmodule(const SURELOG::AstNode& node) {}

  virtual void enterEndpackage(const SURELOG::AstNode& node) {}
  virtual void leaveEndpackage(const SURELOG::AstNode& node) {}

  virtual void enterEndprimitive(const SURELOG::AstNode& node) {}
  virtual void leaveEndprimitive(const SURELOG::AstNode& node) {}

  virtual void enterEndprogram(const SURELOG::AstNode& node) {}
  virtual void leaveEndprogram(const SURELOG::AstNode& node) {}

  virtual void enterEndproperty(const SURELOG::AstNode& node) {}
  virtual void leaveEndproperty(const SURELOG::AstNode& node) {}

  virtual void enterEndprotect_directive(const SURELOG::AstNode& node) {}
  virtual void leaveEndprotect_directive(const SURELOG::AstNode& node) {}

  virtual void enterEndprotected_directive(const SURELOG::AstNode& node) {}
  virtual void leaveEndprotected_directive(const SURELOG::AstNode& node) {}

  virtual void enterEndsequence(const SURELOG::AstNode& node) {}
  virtual void leaveEndsequence(const SURELOG::AstNode& node) {}

  virtual void enterEndspecify(const SURELOG::AstNode& node) {}
  virtual void leaveEndspecify(const SURELOG::AstNode& node) {}

  virtual void enterEndtable(const SURELOG::AstNode& node) {}
  virtual void leaveEndtable(const SURELOG::AstNode& node) {}

  virtual void enterEndtask(const SURELOG::AstNode& node) {}
  virtual void leaveEndtask(const SURELOG::AstNode& node) {}

  virtual void enterEnum_base_type(const SURELOG::AstNode& node) {}
  virtual void leaveEnum_base_type(const SURELOG::AstNode& node) {}

  virtual void enterEnum_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveEnum_keyword(const SURELOG::AstNode& node) {}

  virtual void enterEnum_name_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveEnum_name_declaration(const SURELOG::AstNode& node) {}

  virtual void enterEscapedCR(const SURELOG::AstNode& node) {}
  virtual void leaveEscapedCR(const SURELOG::AstNode& node) {}

  virtual void enterEscaped_identifier(const SURELOG::AstNode& node) {}
  virtual void leaveEscaped_identifier(const SURELOG::AstNode& node) {}

  virtual void enterEscaped_macro_definition_body(const SURELOG::AstNode& node) {}
  virtual void leaveEscaped_macro_definition_body(const SURELOG::AstNode& node) {}

  virtual void enterEscaped_macro_definition_body_alt1(const SURELOG::AstNode& node) {}
  virtual void leaveEscaped_macro_definition_body_alt1(const SURELOG::AstNode& node) {}

  virtual void enterEscaped_macro_definition_body_alt2(const SURELOG::AstNode& node) {}
  virtual void leaveEscaped_macro_definition_body_alt2(const SURELOG::AstNode& node) {}

  virtual void enterEvent_based_flag(const SURELOG::AstNode& node) {}
  virtual void leaveEvent_based_flag(const SURELOG::AstNode& node) {}

  virtual void enterEvent_control(const SURELOG::AstNode& node) {}
  virtual void leaveEvent_control(const SURELOG::AstNode& node) {}

  virtual void enterEvent_expression(const SURELOG::AstNode& node) {}
  virtual void leaveEvent_expression(const SURELOG::AstNode& node) {}

  virtual void enterEvent_trigger(const SURELOG::AstNode& node) {}
  virtual void leaveEvent_trigger(const SURELOG::AstNode& node) {}

  virtual void enterEvent_type(const SURELOG::AstNode& node) {}
  virtual void leaveEvent_type(const SURELOG::AstNode& node) {}

  virtual void enterExpand_vectornets_directive(const SURELOG::AstNode& node) {}
  virtual void leaveExpand_vectornets_directive(const SURELOG::AstNode& node) {}

  virtual void enterExpect_property_statement(const SURELOG::AstNode& node) {}
  virtual void leaveExpect_property_statement(const SURELOG::AstNode& node) {}

  virtual void enterExport(const SURELOG::AstNode& node) {}
  virtual void leaveExport(const SURELOG::AstNode& node) {}

  virtual void enterExpression(const SURELOG::AstNode& node) {}
  virtual void leaveExpression(const SURELOG::AstNode& node) {}

  virtual void enterExpression_or_cond_pattern(const SURELOG::AstNode& node) {}
  virtual void leaveExpression_or_cond_pattern(const SURELOG::AstNode& node) {}

  virtual void enterExpression_or_dist(const SURELOG::AstNode& node) {}
  virtual void leaveExpression_or_dist(const SURELOG::AstNode& node) {}

  virtual void enterExtends(const SURELOG::AstNode& node) {}
  virtual void leaveExtends(const SURELOG::AstNode& node) {}

  virtual void enterExtern_constraint_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveExtern_constraint_declaration(const SURELOG::AstNode& node) {}

  virtual void enterExtern_qualifier(const SURELOG::AstNode& node) {}
  virtual void leaveExtern_qualifier(const SURELOG::AstNode& node) {}

  virtual void enterExtern_tf_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveExtern_tf_declaration(const SURELOG::AstNode& node) {}

  virtual void enterFile_path_spec(const SURELOG::AstNode& node) {}
  virtual void leaveFile_path_spec(const SURELOG::AstNode& node) {}

  virtual void enterFinal_construct(const SURELOG::AstNode& node) {}
  virtual void leaveFinal_construct(const SURELOG::AstNode& node) {}

  virtual void enterFirstMatch(const SURELOG::AstNode& node) {}
  virtual void leaveFirstMatch(const SURELOG::AstNode& node) {}

  virtual void enterFor(const SURELOG::AstNode& node) {}
  virtual void leaveFor(const SURELOG::AstNode& node) {}

  virtual void enterFor_initialization(const SURELOG::AstNode& node) {}
  virtual void leaveFor_initialization(const SURELOG::AstNode& node) {}

  virtual void enterFor_step(const SURELOG::AstNode& node) {}
  virtual void leaveFor_step(const SURELOG::AstNode& node) {}

  virtual void enterFor_step_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveFor_step_assignment(const SURELOG::AstNode& node) {}

  virtual void enterFor_variable_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveFor_variable_declaration(const SURELOG::AstNode& node) {}

  virtual void enterForce(const SURELOG::AstNode& node) {}
  virtual void leaveForce(const SURELOG::AstNode& node) {}

  virtual void enterForeach(const SURELOG::AstNode& node) {}
  virtual void leaveForeach(const SURELOG::AstNode& node) {}

  virtual void enterForever(const SURELOG::AstNode& node) {}
  virtual void leaveForever(const SURELOG::AstNode& node) {}

  virtual void enterFull_edge_sensitive_path_description(const SURELOG::AstNode& node) {}
  virtual void leaveFull_edge_sensitive_path_description(const SURELOG::AstNode& node) {}

  virtual void enterFull_path_description(const SURELOG::AstNode& node) {}
  virtual void leaveFull_path_description(const SURELOG::AstNode& node) {}

  virtual void enterFunction_body_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveFunction_body_declaration(const SURELOG::AstNode& node) {}

  virtual void enterFunction_data_type(const SURELOG::AstNode& node) {}
  virtual void leaveFunction_data_type(const SURELOG::AstNode& node) {}

  virtual void enterFunction_data_type_or_implicit(const SURELOG::AstNode& node) {}
  virtual void leaveFunction_data_type_or_implicit(const SURELOG::AstNode& node) {}

  virtual void enterFunction_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveFunction_declaration(const SURELOG::AstNode& node) {}

  virtual void enterFunction_name_decl(const SURELOG::AstNode& node) {}
  virtual void leaveFunction_name_decl(const SURELOG::AstNode& node) {}

  virtual void enterFunction_prototype(const SURELOG::AstNode& node) {}
  virtual void leaveFunction_prototype(const SURELOG::AstNode& node) {}

  virtual void enterFunction_statement_or_null(const SURELOG::AstNode& node) {}
  virtual void leaveFunction_statement_or_null(const SURELOG::AstNode& node) {}

  virtual void enterGate_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveGate_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_block(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_block(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_interface_block(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_interface_block(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_interface_case_statement(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_interface_case_statement(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_interface_conditional_statement(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_interface_conditional_statement(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_interface_item(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_interface_item(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_interface_loop_statement(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_interface_loop_statement(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_interface_named_block(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_interface_named_block(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_item(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_item(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_module_block(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_module_block(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_module_case_statement(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_module_case_statement(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_module_conditional_statement(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_module_conditional_statement(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_module_item(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_module_item(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_module_loop_statement(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_module_loop_statement(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_module_named_block(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_module_named_block(const SURELOG::AstNode& node) {}

  virtual void enterGenerate_region(const SURELOG::AstNode& node) {}
  virtual void leaveGenerate_region(const SURELOG::AstNode& node) {}

  virtual void enterGenerated_interface_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveGenerated_interface_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterGenerated_module_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveGenerated_module_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterGenericElementType(const SURELOG::AstNode& node) {}
  virtual void leaveGenericElementType(const SURELOG::AstNode& node) {}

  virtual void enterGenvar_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveGenvar_assignment(const SURELOG::AstNode& node) {}

  virtual void enterGenvar_decl_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveGenvar_decl_assignment(const SURELOG::AstNode& node) {}

  virtual void enterGenvar_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveGenvar_declaration(const SURELOG::AstNode& node) {}

  virtual void enterGenvar_initialization(const SURELOG::AstNode& node) {}
  virtual void leaveGenvar_initialization(const SURELOG::AstNode& node) {}

  virtual void enterGenvar_interface_case_item(const SURELOG::AstNode& node) {}
  virtual void leaveGenvar_interface_case_item(const SURELOG::AstNode& node) {}

  virtual void enterGenvar_iteration(const SURELOG::AstNode& node) {}
  virtual void leaveGenvar_iteration(const SURELOG::AstNode& node) {}

  virtual void enterGenvar_module_case_item(const SURELOG::AstNode& node) {}
  virtual void leaveGenvar_module_case_item(const SURELOG::AstNode& node) {}

  virtual void enterGlobal(const SURELOG::AstNode& node) {}
  virtual void leaveGlobal(const SURELOG::AstNode& node) {}

  virtual void enterGoto_repetition(const SURELOG::AstNode& node) {}
  virtual void leaveGoto_repetition(const SURELOG::AstNode& node) {}

  virtual void enterHierarchical_btf_identifier(const SURELOG::AstNode& node) {}
  virtual void leaveHierarchical_btf_identifier(const SURELOG::AstNode& node) {}

  virtual void enterHierarchical_identifier(const SURELOG::AstNode& node) {}
  virtual void leaveHierarchical_identifier(const SURELOG::AstNode& node) {}

  virtual void enterHierarchical_instance(const SURELOG::AstNode& node) {}
  virtual void leaveHierarchical_instance(const SURELOG::AstNode& node) {}

  virtual void enterHighZ0(const SURELOG::AstNode& node) {}
  virtual void leaveHighZ0(const SURELOG::AstNode& node) {}

  virtual void enterHighZ1(const SURELOG::AstNode& node) {}
  virtual void leaveHighZ1(const SURELOG::AstNode& node) {}

  virtual void enterIF(const SURELOG::AstNode& node) {}
  virtual void leaveIF(const SURELOG::AstNode& node) {}

  virtual void enterIFF(const SURELOG::AstNode& node) {}
  virtual void leaveIFF(const SURELOG::AstNode& node) {}

  virtual void enterIMPLIES(const SURELOG::AstNode& node) {}
  virtual void leaveIMPLIES(const SURELOG::AstNode& node) {}

  virtual void enterIdentifier(const SURELOG::AstNode& node) {}
  virtual void leaveIdentifier(const SURELOG::AstNode& node) {}

  virtual void enterIdentifier_in_macro_body(const SURELOG::AstNode& node) {}
  virtual void leaveIdentifier_in_macro_body(const SURELOG::AstNode& node) {}

  virtual void enterIdentifier_list(const SURELOG::AstNode& node) {}
  virtual void leaveIdentifier_list(const SURELOG::AstNode& node) {}

  virtual void enterIf_generate_construct(const SURELOG::AstNode& node) {}
  virtual void leaveIf_generate_construct(const SURELOG::AstNode& node) {}

  virtual void enterIfdef_directive(const SURELOG::AstNode& node) {}
  virtual void leaveIfdef_directive(const SURELOG::AstNode& node) {}

  virtual void enterIfdef_directive_in_macro_body(const SURELOG::AstNode& node) {}
  virtual void leaveIfdef_directive_in_macro_body(const SURELOG::AstNode& node) {}

  virtual void enterIff(const SURELOG::AstNode& node) {}
  virtual void leaveIff(const SURELOG::AstNode& node) {}

  virtual void enterIfndef_directive(const SURELOG::AstNode& node) {}
  virtual void leaveIfndef_directive(const SURELOG::AstNode& node) {}

  virtual void enterIfndef_directive_in_macro_body(const SURELOG::AstNode& node) {}
  virtual void leaveIfndef_directive_in_macro_body(const SURELOG::AstNode& node) {}

  virtual void enterImmediate_assertion_statement(const SURELOG::AstNode& node) {}
  virtual void leaveImmediate_assertion_statement(const SURELOG::AstNode& node) {}

  virtual void enterImplements(const SURELOG::AstNode& node) {}
  virtual void leaveImplements(const SURELOG::AstNode& node) {}

  virtual void enterImplicit_class_handle(const SURELOG::AstNode& node) {}
  virtual void leaveImplicit_class_handle(const SURELOG::AstNode& node) {}

  virtual void enterImplicit_data_type(const SURELOG::AstNode& node) {}
  virtual void leaveImplicit_data_type(const SURELOG::AstNode& node) {}

  virtual void enterImport(const SURELOG::AstNode& node) {}
  virtual void leaveImport(const SURELOG::AstNode& node) {}

  virtual void enterIncDec_MinusMinus(const SURELOG::AstNode& node) {}
  virtual void leaveIncDec_MinusMinus(const SURELOG::AstNode& node) {}

  virtual void enterIncDec_PlusPlus(const SURELOG::AstNode& node) {}
  virtual void leaveIncDec_PlusPlus(const SURELOG::AstNode& node) {}

  virtual void enterIncPartSelectOp(const SURELOG::AstNode& node) {}
  virtual void leaveIncPartSelectOp(const SURELOG::AstNode& node) {}

  virtual void enterInc_or_dec_expression(const SURELOG::AstNode& node) {}
  virtual void leaveInc_or_dec_expression(const SURELOG::AstNode& node) {}

  virtual void enterInc_or_dec_operator(const SURELOG::AstNode& node) {}
  virtual void leaveInc_or_dec_operator(const SURELOG::AstNode& node) {}

  virtual void enterInclude_directive(const SURELOG::AstNode& node) {}
  virtual void leaveInclude_directive(const SURELOG::AstNode& node) {}

  virtual void enterInclude_statement(const SURELOG::AstNode& node) {}
  virtual void leaveInclude_statement(const SURELOG::AstNode& node) {}

  virtual void enterIndexed_range(const SURELOG::AstNode& node) {}
  virtual void leaveIndexed_range(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_1TickB0(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_1TickB0(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_1TickB1(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_1TickB1(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_1TickBX(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_1TickBX(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_1TickBx(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_1TickBx(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_1Tickb0(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_1Tickb0(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_1Tickb1(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_1Tickb1(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_1TickbX(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_1TickbX(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_1Tickbx(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_1Tickbx(const SURELOG::AstNode& node) {}

  virtual void enterInitVal_Integral(const SURELOG::AstNode& node) {}
  virtual void leaveInitVal_Integral(const SURELOG::AstNode& node) {}

  virtual void enterInitial_construct(const SURELOG::AstNode& node) {}
  virtual void leaveInitial_construct(const SURELOG::AstNode& node) {}

  virtual void enterInout_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveInout_declaration(const SURELOG::AstNode& node) {}

  virtual void enterInput_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveInput_declaration(const SURELOG::AstNode& node) {}

  virtual void enterInsideOp(const SURELOG::AstNode& node) {}
  virtual void leaveInsideOp(const SURELOG::AstNode& node) {}

  virtual void enterInst_clause(const SURELOG::AstNode& node) {}
  virtual void leaveInst_clause(const SURELOG::AstNode& node) {}

  virtual void enterInst_name(const SURELOG::AstNode& node) {}
  virtual void leaveInst_name(const SURELOG::AstNode& node) {}

  virtual void enterIntConst(const SURELOG::AstNode& node) {}
  virtual void leaveIntConst(const SURELOG::AstNode& node) {}

  virtual void enterIntVec_TypeBit(const SURELOG::AstNode& node) {}
  virtual void leaveIntVec_TypeBit(const SURELOG::AstNode& node) {}

  virtual void enterIntVec_TypeLogic(const SURELOG::AstNode& node) {}
  virtual void leaveIntVec_TypeLogic(const SURELOG::AstNode& node) {}

  virtual void enterIntVec_TypeReg(const SURELOG::AstNode& node) {}
  virtual void leaveIntVec_TypeReg(const SURELOG::AstNode& node) {}

  virtual void enterIntegerAtomType_Byte(const SURELOG::AstNode& node) {}
  virtual void leaveIntegerAtomType_Byte(const SURELOG::AstNode& node) {}

  virtual void enterIntegerAtomType_Int(const SURELOG::AstNode& node) {}
  virtual void leaveIntegerAtomType_Int(const SURELOG::AstNode& node) {}

  virtual void enterIntegerAtomType_Integer(const SURELOG::AstNode& node) {}
  virtual void leaveIntegerAtomType_Integer(const SURELOG::AstNode& node) {}

  virtual void enterIntegerAtomType_LongInt(const SURELOG::AstNode& node) {}
  virtual void leaveIntegerAtomType_LongInt(const SURELOG::AstNode& node) {}

  virtual void enterIntegerAtomType_Shortint(const SURELOG::AstNode& node) {}
  virtual void leaveIntegerAtomType_Shortint(const SURELOG::AstNode& node) {}

  virtual void enterIntegerAtomType_Time(const SURELOG::AstNode& node) {}
  virtual void leaveIntegerAtomType_Time(const SURELOG::AstNode& node) {}

  virtual void enterInteger_atom_type(const SURELOG::AstNode& node) {}
  virtual void leaveInteger_atom_type(const SURELOG::AstNode& node) {}

  virtual void enterInteger_type(const SURELOG::AstNode& node) {}
  virtual void leaveInteger_type(const SURELOG::AstNode& node) {}

  virtual void enterInteger_vector_type(const SURELOG::AstNode& node) {}
  virtual void leaveInteger_vector_type(const SURELOG::AstNode& node) {}

  virtual void enterInterface(const SURELOG::AstNode& node) {}
  virtual void leaveInterface(const SURELOG::AstNode& node) {}

  virtual void enterInterface_ansi_header(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_ansi_header(const SURELOG::AstNode& node) {}

  virtual void enterInterface_class_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_class_declaration(const SURELOG::AstNode& node) {}

  virtual void enterInterface_class_item(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_class_item(const SURELOG::AstNode& node) {}

  virtual void enterInterface_class_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_class_keyword(const SURELOG::AstNode& node) {}

  virtual void enterInterface_class_method(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_class_method(const SURELOG::AstNode& node) {}

  virtual void enterInterface_class_type(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_class_type(const SURELOG::AstNode& node) {}

  virtual void enterInterface_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_declaration(const SURELOG::AstNode& node) {}

  virtual void enterInterface_identifier(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_identifier(const SURELOG::AstNode& node) {}

  virtual void enterInterface_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterInterface_item(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_item(const SURELOG::AstNode& node) {}

  virtual void enterInterface_nonansi_header(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_nonansi_header(const SURELOG::AstNode& node) {}

  virtual void enterInterface_or_generate_item(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_or_generate_item(const SURELOG::AstNode& node) {}

  virtual void enterInterface_port_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_port_declaration(const SURELOG::AstNode& node) {}

  virtual void enterInterface_port_header(const SURELOG::AstNode& node) {}
  virtual void leaveInterface_port_header(const SURELOG::AstNode& node) {}

  virtual void enterIntersect(const SURELOG::AstNode& node) {}
  virtual void leaveIntersect(const SURELOG::AstNode& node) {}

  virtual void enterJoin_any_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveJoin_any_keyword(const SURELOG::AstNode& node) {}

  virtual void enterJoin_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveJoin_keyword(const SURELOG::AstNode& node) {}

  virtual void enterJoin_none_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveJoin_none_keyword(const SURELOG::AstNode& node) {}

  virtual void enterJump_statement(const SURELOG::AstNode& node) {}
  virtual void leaveJump_statement(const SURELOG::AstNode& node) {}

  virtual void enterLarge(const SURELOG::AstNode& node) {}
  virtual void leaveLarge(const SURELOG::AstNode& node) {}

  virtual void enterLet_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveLet_declaration(const SURELOG::AstNode& node) {}

  virtual void enterLet_formal_type(const SURELOG::AstNode& node) {}
  virtual void leaveLet_formal_type(const SURELOG::AstNode& node) {}

  virtual void enterLet_port_item(const SURELOG::AstNode& node) {}
  virtual void leaveLet_port_item(const SURELOG::AstNode& node) {}

  virtual void enterLet_port_list(const SURELOG::AstNode& node) {}
  virtual void leaveLet_port_list(const SURELOG::AstNode& node) {}

  virtual void enterLevel_input_list(const SURELOG::AstNode& node) {}
  virtual void leaveLevel_input_list(const SURELOG::AstNode& node) {}

  virtual void enterLevel_symbol(const SURELOG::AstNode& node) {}
  virtual void leaveLevel_symbol(const SURELOG::AstNode& node) {}

  virtual void enterLiblist_clause(const SURELOG::AstNode& node) {}
  virtual void leaveLiblist_clause(const SURELOG::AstNode& node) {}

  virtual void enterLibrary_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveLibrary_declaration(const SURELOG::AstNode& node) {}

  virtual void enterLibrary_descriptions(const SURELOG::AstNode& node) {}
  virtual void leaveLibrary_descriptions(const SURELOG::AstNode& node) {}

  virtual void enterLibrary_text(const SURELOG::AstNode& node) {}
  virtual void leaveLibrary_text(const SURELOG::AstNode& node) {}

  virtual void enterLifetime_Automatic(const SURELOG::AstNode& node) {}
  virtual void leaveLifetime_Automatic(const SURELOG::AstNode& node) {}

  virtual void enterLifetime_Static(const SURELOG::AstNode& node) {}
  virtual void leaveLifetime_Static(const SURELOG::AstNode& node) {}

  virtual void enterLine_directive(const SURELOG::AstNode& node) {}
  virtual void leaveLine_directive(const SURELOG::AstNode& node) {}

  virtual void enterList_of_arguments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_arguments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_checker_port_connections(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_checker_port_connections(const SURELOG::AstNode& node) {}

  virtual void enterList_of_clocking_decl_assign(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_clocking_decl_assign(const SURELOG::AstNode& node) {}

  virtual void enterList_of_cross_items(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_cross_items(const SURELOG::AstNode& node) {}

  virtual void enterList_of_defparam_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_defparam_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_interface_identifiers(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_interface_identifiers(const SURELOG::AstNode& node) {}

  virtual void enterList_of_net_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_net_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_net_decl_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_net_decl_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_param_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_param_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_parameter_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_parameter_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_path_delay_expressions(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_path_delay_expressions(const SURELOG::AstNode& node) {}

  virtual void enterList_of_path_inputs(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_path_inputs(const SURELOG::AstNode& node) {}

  virtual void enterList_of_path_outputs(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_path_outputs(const SURELOG::AstNode& node) {}

  virtual void enterList_of_port_connections(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_port_connections(const SURELOG::AstNode& node) {}

  virtual void enterList_of_port_declarations(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_port_declarations(const SURELOG::AstNode& node) {}

  virtual void enterList_of_port_identifiers(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_port_identifiers(const SURELOG::AstNode& node) {}

  virtual void enterList_of_ports(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_ports(const SURELOG::AstNode& node) {}

  virtual void enterList_of_specparam_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_specparam_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_tf_variable_identifiers(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_tf_variable_identifiers(const SURELOG::AstNode& node) {}

  virtual void enterList_of_type_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_type_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_variable_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_variable_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_variable_decl_assignments(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_variable_decl_assignments(const SURELOG::AstNode& node) {}

  virtual void enterList_of_variable_identifiers(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_variable_identifiers(const SURELOG::AstNode& node) {}

  virtual void enterList_of_variable_port_identifiers(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_variable_port_identifiers(const SURELOG::AstNode& node) {}

  virtual void enterList_of_virtual_interface_decl(const SURELOG::AstNode& node) {}
  virtual void leaveList_of_virtual_interface_decl(const SURELOG::AstNode& node) {}

  virtual void enterLocal_parameter_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveLocal_parameter_declaration(const SURELOG::AstNode& node) {}

  virtual void enterLoop_generate_construct(const SURELOG::AstNode& node) {}
  virtual void leaveLoop_generate_construct(const SURELOG::AstNode& node) {}

  virtual void enterLoop_statement(const SURELOG::AstNode& node) {}
  virtual void leaveLoop_statement(const SURELOG::AstNode& node) {}

  virtual void enterLoop_variables(const SURELOG::AstNode& node) {}
  virtual void leaveLoop_variables(const SURELOG::AstNode& node) {}

  virtual void enterMacroInstanceNoArgs(const SURELOG::AstNode& node) {}
  virtual void leaveMacroInstanceNoArgs(const SURELOG::AstNode& node) {}

  virtual void enterMacroInstanceWithArgs(const SURELOG::AstNode& node) {}
  virtual void leaveMacroInstanceWithArgs(const SURELOG::AstNode& node) {}

  virtual void enterMacro_actual_args(const SURELOG::AstNode& node) {}
  virtual void leaveMacro_actual_args(const SURELOG::AstNode& node) {}

  virtual void enterMacro_arg(const SURELOG::AstNode& node) {}
  virtual void leaveMacro_arg(const SURELOG::AstNode& node) {}

  virtual void enterMacro_arguments(const SURELOG::AstNode& node) {}
  virtual void leaveMacro_arguments(const SURELOG::AstNode& node) {}

  virtual void enterMacro_definition(const SURELOG::AstNode& node) {}
  virtual void leaveMacro_definition(const SURELOG::AstNode& node) {}

  virtual void enterMatches(const SURELOG::AstNode& node) {}
  virtual void leaveMatches(const SURELOG::AstNode& node) {}

  virtual void enterMedium(const SURELOG::AstNode& node) {}
  virtual void leaveMedium(const SURELOG::AstNode& node) {}

  virtual void enterMethodQualifier_ClassItem(const SURELOG::AstNode& node) {}
  virtual void leaveMethodQualifier_ClassItem(const SURELOG::AstNode& node) {}

  virtual void enterMethodQualifier_Virtual(const SURELOG::AstNode& node) {}
  virtual void leaveMethodQualifier_Virtual(const SURELOG::AstNode& node) {}

  virtual void enterMethod_call(const SURELOG::AstNode& node) {}
  virtual void leaveMethod_call(const SURELOG::AstNode& node) {}

  virtual void enterMethod_call_body(const SURELOG::AstNode& node) {}
  virtual void leaveMethod_call_body(const SURELOG::AstNode& node) {}

  virtual void enterMethod_call_root(const SURELOG::AstNode& node) {}
  virtual void leaveMethod_call_root(const SURELOG::AstNode& node) {}

  virtual void enterMethod_prototype(const SURELOG::AstNode& node) {}
  virtual void leaveMethod_prototype(const SURELOG::AstNode& node) {}

  virtual void enterMintypmax_expression(const SURELOG::AstNode& node) {}
  virtual void leaveMintypmax_expression(const SURELOG::AstNode& node) {}

  virtual void enterModport_hierarchical_ports_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveModport_hierarchical_ports_declaration(const SURELOG::AstNode& node) {}

  virtual void enterModport_item(const SURELOG::AstNode& node) {}
  virtual void leaveModport_item(const SURELOG::AstNode& node) {}

  virtual void enterModport_ports_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveModport_ports_declaration(const SURELOG::AstNode& node) {}

  virtual void enterModport_simple_port(const SURELOG::AstNode& node) {}
  virtual void leaveModport_simple_port(const SURELOG::AstNode& node) {}

  virtual void enterModport_simple_ports_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveModport_simple_ports_declaration(const SURELOG::AstNode& node) {}

  virtual void enterModport_tf_port(const SURELOG::AstNode& node) {}
  virtual void leaveModport_tf_port(const SURELOG::AstNode& node) {}

  virtual void enterModport_tf_ports_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveModport_tf_ports_declaration(const SURELOG::AstNode& node) {}

  virtual void enterModule(const SURELOG::AstNode& node) {}
  virtual void leaveModule(const SURELOG::AstNode& node) {}

  virtual void enterModuleInstance(const SURELOG::AstNode& node) {}
  virtual void leaveModuleInstance(const SURELOG::AstNode& node) {}

  virtual void enterModule_ansi_header(const SURELOG::AstNode& node) {}
  virtual void leaveModule_ansi_header(const SURELOG::AstNode& node) {}

  virtual void enterModule_common_item(const SURELOG::AstNode& node) {}
  virtual void leaveModule_common_item(const SURELOG::AstNode& node) {}

  virtual void enterModule_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveModule_declaration(const SURELOG::AstNode& node) {}

  virtual void enterModule_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveModule_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterModule_item(const SURELOG::AstNode& node) {}
  virtual void leaveModule_item(const SURELOG::AstNode& node) {}

  virtual void enterModule_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveModule_keyword(const SURELOG::AstNode& node) {}

  virtual void enterModule_nonansi_header(const SURELOG::AstNode& node) {}
  virtual void leaveModule_nonansi_header(const SURELOG::AstNode& node) {}

  virtual void enterModule_or_generate_item(const SURELOG::AstNode& node) {}
  virtual void leaveModule_or_generate_item(const SURELOG::AstNode& node) {}

  virtual void enterModule_or_generate_item_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveModule_or_generate_item_declaration(const SURELOG::AstNode& node) {}

  virtual void enterModule_path_concatenation(const SURELOG::AstNode& node) {}
  virtual void leaveModule_path_concatenation(const SURELOG::AstNode& node) {}

  virtual void enterModule_path_expression(const SURELOG::AstNode& node) {}
  virtual void leaveModule_path_expression(const SURELOG::AstNode& node) {}

  virtual void enterModule_path_mintypmax_expression(const SURELOG::AstNode& node) {}
  virtual void leaveModule_path_mintypmax_expression(const SURELOG::AstNode& node) {}

  virtual void enterModule_path_multiple_concatenation(const SURELOG::AstNode& node) {}
  virtual void leaveModule_path_multiple_concatenation(const SURELOG::AstNode& node) {}

  virtual void enterModule_path_primary(const SURELOG::AstNode& node) {}
  virtual void leaveModule_path_primary(const SURELOG::AstNode& node) {}

  virtual void enterMosSwitchType_NMos(const SURELOG::AstNode& node) {}
  virtual void leaveMosSwitchType_NMos(const SURELOG::AstNode& node) {}

  virtual void enterMosSwitchType_PMos(const SURELOG::AstNode& node) {}
  virtual void leaveMosSwitchType_PMos(const SURELOG::AstNode& node) {}

  virtual void enterMosSwitchType_RNMos(const SURELOG::AstNode& node) {}
  virtual void leaveMosSwitchType_RNMos(const SURELOG::AstNode& node) {}

  virtual void enterMosSwitchType_RPMos(const SURELOG::AstNode& node) {}
  virtual void leaveMosSwitchType_RPMos(const SURELOG::AstNode& node) {}

  virtual void enterMos_switch_instance(const SURELOG::AstNode& node) {}
  virtual void leaveMos_switch_instance(const SURELOG::AstNode& node) {}

  virtual void enterMultiline_args_macro_definition(const SURELOG::AstNode& node) {}
  virtual void leaveMultiline_args_macro_definition(const SURELOG::AstNode& node) {}

  virtual void enterMultiline_no_args_macro_definition(const SURELOG::AstNode& node) {}
  virtual void leaveMultiline_no_args_macro_definition(const SURELOG::AstNode& node) {}

  virtual void enterMultiple_concatenation(const SURELOG::AstNode& node) {}
  virtual void leaveMultiple_concatenation(const SURELOG::AstNode& node) {}

  virtual void enterNInpGate_And(const SURELOG::AstNode& node) {}
  virtual void leaveNInpGate_And(const SURELOG::AstNode& node) {}

  virtual void enterNInpGate_Nand(const SURELOG::AstNode& node) {}
  virtual void leaveNInpGate_Nand(const SURELOG::AstNode& node) {}

  virtual void enterNInpGate_Nor(const SURELOG::AstNode& node) {}
  virtual void leaveNInpGate_Nor(const SURELOG::AstNode& node) {}

  virtual void enterNInpGate_Or(const SURELOG::AstNode& node) {}
  virtual void leaveNInpGate_Or(const SURELOG::AstNode& node) {}

  virtual void enterNInpGate_Xnor(const SURELOG::AstNode& node) {}
  virtual void leaveNInpGate_Xnor(const SURELOG::AstNode& node) {}

  virtual void enterNInpGate_Xor(const SURELOG::AstNode& node) {}
  virtual void leaveNInpGate_Xor(const SURELOG::AstNode& node) {}

  virtual void enterNONOVERLAPPED(const SURELOG::AstNode& node) {}
  virtual void leaveNONOVERLAPPED(const SURELOG::AstNode& node) {}

  virtual void enterNON_OVERLAP_IMPLY(const SURELOG::AstNode& node) {}
  virtual void leaveNON_OVERLAP_IMPLY(const SURELOG::AstNode& node) {}

  virtual void enterNOT(const SURELOG::AstNode& node) {}
  virtual void leaveNOT(const SURELOG::AstNode& node) {}

  virtual void enterNOutGate_Buf(const SURELOG::AstNode& node) {}
  virtual void leaveNOutGate_Buf(const SURELOG::AstNode& node) {}

  virtual void enterNOutGate_Not(const SURELOG::AstNode& node) {}
  virtual void leaveNOutGate_Not(const SURELOG::AstNode& node) {}

  virtual void enterN_input_gate_instance(const SURELOG::AstNode& node) {}
  virtual void leaveN_input_gate_instance(const SURELOG::AstNode& node) {}

  virtual void enterN_output_gate_instance(const SURELOG::AstNode& node) {}
  virtual void leaveN_output_gate_instance(const SURELOG::AstNode& node) {}

  virtual void enterName_of_instance(const SURELOG::AstNode& node) {}
  virtual void leaveName_of_instance(const SURELOG::AstNode& node) {}

  virtual void enterNamed_checker_port_connection(const SURELOG::AstNode& node) {}
  virtual void leaveNamed_checker_port_connection(const SURELOG::AstNode& node) {}

  virtual void enterNamed_parameter_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveNamed_parameter_assignment(const SURELOG::AstNode& node) {}

  virtual void enterNamed_port_connection(const SURELOG::AstNode& node) {}
  virtual void leaveNamed_port_connection(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Supply0(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Supply0(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Supply1(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Supply1(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Tri(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Tri(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Tri0(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Tri0(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Tri1(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Tri1(const SURELOG::AstNode& node) {}

  virtual void enterNetType_TriAnd(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_TriAnd(const SURELOG::AstNode& node) {}

  virtual void enterNetType_TriOr(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_TriOr(const SURELOG::AstNode& node) {}

  virtual void enterNetType_TriReg(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_TriReg(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Uwire(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Uwire(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Wand(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Wand(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Wire(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Wire(const SURELOG::AstNode& node) {}

  virtual void enterNetType_Wor(const SURELOG::AstNode& node) {}
  virtual void leaveNetType_Wor(const SURELOG::AstNode& node) {}

  virtual void enterNet_alias(const SURELOG::AstNode& node) {}
  virtual void leaveNet_alias(const SURELOG::AstNode& node) {}

  virtual void enterNet_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveNet_assignment(const SURELOG::AstNode& node) {}

  virtual void enterNet_decl_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveNet_decl_assignment(const SURELOG::AstNode& node) {}

  virtual void enterNet_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveNet_declaration(const SURELOG::AstNode& node) {}

  virtual void enterNet_lvalue(const SURELOG::AstNode& node) {}
  virtual void leaveNet_lvalue(const SURELOG::AstNode& node) {}

  virtual void enterNet_port_header(const SURELOG::AstNode& node) {}
  virtual void leaveNet_port_header(const SURELOG::AstNode& node) {}

  virtual void enterNet_port_type(const SURELOG::AstNode& node) {}
  virtual void leaveNet_port_type(const SURELOG::AstNode& node) {}

  virtual void enterNet_type(const SURELOG::AstNode& node) {}
  virtual void leaveNet_type(const SURELOG::AstNode& node) {}

  virtual void enterNet_type_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveNet_type_declaration(const SURELOG::AstNode& node) {}

  virtual void enterNext_state(const SURELOG::AstNode& node) {}
  virtual void leaveNext_state(const SURELOG::AstNode& node) {}

  virtual void enterNoType(const SURELOG::AstNode& node) {}
  virtual void leaveNoType(const SURELOG::AstNode& node) {}

  virtual void enterNoaccelerate_directive(const SURELOG::AstNode& node) {}
  virtual void leaveNoaccelerate_directive(const SURELOG::AstNode& node) {}

  virtual void enterNoexpand_vectornets_directive(const SURELOG::AstNode& node) {}
  virtual void leaveNoexpand_vectornets_directive(const SURELOG::AstNode& node) {}

  virtual void enterNonBlockingTriggerEvent(const SURELOG::AstNode& node) {}
  virtual void leaveNonBlockingTriggerEvent(const SURELOG::AstNode& node) {}

  virtual void enterNonIntType_Real(const SURELOG::AstNode& node) {}
  virtual void leaveNonIntType_Real(const SURELOG::AstNode& node) {}

  virtual void enterNonIntType_RealTime(const SURELOG::AstNode& node) {}
  virtual void leaveNonIntType_RealTime(const SURELOG::AstNode& node) {}

  virtual void enterNonIntType_ShortReal(const SURELOG::AstNode& node) {}
  virtual void leaveNonIntType_ShortReal(const SURELOG::AstNode& node) {}

  virtual void enterNon_consecutive_repetition(const SURELOG::AstNode& node) {}
  virtual void leaveNon_consecutive_repetition(const SURELOG::AstNode& node) {}

  virtual void enterNon_integer_type(const SURELOG::AstNode& node) {}
  virtual void leaveNon_integer_type(const SURELOG::AstNode& node) {}

  virtual void enterNon_port_interface_item(const SURELOG::AstNode& node) {}
  virtual void leaveNon_port_interface_item(const SURELOG::AstNode& node) {}

  virtual void enterNon_port_module_item(const SURELOG::AstNode& node) {}
  virtual void leaveNon_port_module_item(const SURELOG::AstNode& node) {}

  virtual void enterNon_port_program_item(const SURELOG::AstNode& node) {}
  virtual void leaveNon_port_program_item(const SURELOG::AstNode& node) {}

  virtual void enterNonblocking_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveNonblocking_assignment(const SURELOG::AstNode& node) {}

  virtual void enterNonrange_select(const SURELOG::AstNode& node) {}
  virtual void leaveNonrange_select(const SURELOG::AstNode& node) {}

  virtual void enterNonrange_variable_lvalue(const SURELOG::AstNode& node) {}
  virtual void leaveNonrange_variable_lvalue(const SURELOG::AstNode& node) {}

  virtual void enterNoremove_gatenames_directive(const SURELOG::AstNode& node) {}
  virtual void leaveNoremove_gatenames_directive(const SURELOG::AstNode& node) {}

  virtual void enterNoremove_netnames_directive(const SURELOG::AstNode& node) {}
  virtual void leaveNoremove_netnames_directive(const SURELOG::AstNode& node) {}

  virtual void enterNosuppress_faults_directive(const SURELOG::AstNode& node) {}
  virtual void leaveNosuppress_faults_directive(const SURELOG::AstNode& node) {}

  virtual void enterNotifier(const SURELOG::AstNode& node) {}
  virtual void leaveNotifier(const SURELOG::AstNode& node) {}

  virtual void enterNounconnected_drive_directive(const SURELOG::AstNode& node) {}
  virtual void leaveNounconnected_drive_directive(const SURELOG::AstNode& node) {}

  virtual void enterNull(const SURELOG::AstNode& node) {}
  virtual void leaveNull(const SURELOG::AstNode& node) {}

  virtual void enterNull_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveNull_keyword(const SURELOG::AstNode& node) {}

  virtual void enterNumber(const SURELOG::AstNode& node) {}
  virtual void leaveNumber(const SURELOG::AstNode& node) {}

  virtual void enterNumber_1TickB0(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_1TickB0(const SURELOG::AstNode& node) {}

  virtual void enterNumber_1TickB1(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_1TickB1(const SURELOG::AstNode& node) {}

  virtual void enterNumber_1TickBX(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_1TickBX(const SURELOG::AstNode& node) {}

  virtual void enterNumber_1TickBx(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_1TickBx(const SURELOG::AstNode& node) {}

  virtual void enterNumber_1Tickb0(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_1Tickb0(const SURELOG::AstNode& node) {}

  virtual void enterNumber_1Tickb1(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_1Tickb1(const SURELOG::AstNode& node) {}

  virtual void enterNumber_1TickbX(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_1TickbX(const SURELOG::AstNode& node) {}

  virtual void enterNumber_1Tickbx(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_1Tickbx(const SURELOG::AstNode& node) {}

  virtual void enterNumber_Integral(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_Integral(const SURELOG::AstNode& node) {}

  virtual void enterNumber_Real(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_Real(const SURELOG::AstNode& node) {}

  virtual void enterNumber_Tick0(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_Tick0(const SURELOG::AstNode& node) {}

  virtual void enterNumber_Tick1(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_Tick1(const SURELOG::AstNode& node) {}

  virtual void enterNumber_TickB0(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_TickB0(const SURELOG::AstNode& node) {}

  virtual void enterNumber_TickB1(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_TickB1(const SURELOG::AstNode& node) {}

  virtual void enterNumber_Tickb0(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_Tickb0(const SURELOG::AstNode& node) {}

  virtual void enterNumber_Tickb1(const SURELOG::AstNode& node) {}
  virtual void leaveNumber_Tickb1(const SURELOG::AstNode& node) {}

  virtual void enterOR(const SURELOG::AstNode& node) {}
  virtual void leaveOR(const SURELOG::AstNode& node) {}

  virtual void enterOVERLAPPED(const SURELOG::AstNode& node) {}
  virtual void leaveOVERLAPPED(const SURELOG::AstNode& node) {}

  virtual void enterOVERLAP_IMPLY(const SURELOG::AstNode& node) {}
  virtual void leaveOVERLAP_IMPLY(const SURELOG::AstNode& node) {}

  virtual void enterOpenParens(const SURELOG::AstNode& node) {}
  virtual void leaveOpenParens(const SURELOG::AstNode& node) {}

  virtual void enterOpen_range_list(const SURELOG::AstNode& node) {}
  virtual void leaveOpen_range_list(const SURELOG::AstNode& node) {}

  virtual void enterOperator_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveOperator_assignment(const SURELOG::AstNode& node) {}

  virtual void enterOr_call(const SURELOG::AstNode& node) {}
  virtual void leaveOr_call(const SURELOG::AstNode& node) {}

  virtual void enterOr_operator(const SURELOG::AstNode& node) {}
  virtual void leaveOr_operator(const SURELOG::AstNode& node) {}

  virtual void enterOrdered_checker_port_connection(const SURELOG::AstNode& node) {}
  virtual void leaveOrdered_checker_port_connection(const SURELOG::AstNode& node) {}

  virtual void enterOrdered_parameter_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveOrdered_parameter_assignment(const SURELOG::AstNode& node) {}

  virtual void enterOrdered_port_connection(const SURELOG::AstNode& node) {}
  virtual void leaveOrdered_port_connection(const SURELOG::AstNode& node) {}

  virtual void enterOutput_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveOutput_declaration(const SURELOG::AstNode& node) {}

  virtual void enterOutput_symbol(const SURELOG::AstNode& node) {}
  virtual void leaveOutput_symbol(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Div(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Div(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Equal(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Equal(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Equiv(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Equiv(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Greater(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Greater(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_GreaterEqual(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_GreaterEqual(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Less(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Less(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_LessEqual(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_LessEqual(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Minus(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Minus(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_MinusMinus(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_MinusMinus(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Mult(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Mult(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_NotEqual(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_NotEqual(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Percent(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Percent(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_Plus(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_Plus(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_PlusPlus(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_PlusPlus(const SURELOG::AstNode& node) {}

  virtual void enterOverloadOp_StarStar(const SURELOG::AstNode& node) {}
  virtual void leaveOverloadOp_StarStar(const SURELOG::AstNode& node) {}

  virtual void enterOverload_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveOverload_declaration(const SURELOG::AstNode& node) {}

  virtual void enterOverload_proto_formals(const SURELOG::AstNode& node) {}
  virtual void leaveOverload_proto_formals(const SURELOG::AstNode& node) {}

  virtual void enterPackage(const SURELOG::AstNode& node) {}
  virtual void leavePackage(const SURELOG::AstNode& node) {}

  virtual void enterPackage_declaration(const SURELOG::AstNode& node) {}
  virtual void leavePackage_declaration(const SURELOG::AstNode& node) {}

  virtual void enterPackage_export_declaration(const SURELOG::AstNode& node) {}
  virtual void leavePackage_export_declaration(const SURELOG::AstNode& node) {}

  virtual void enterPackage_import_declaration(const SURELOG::AstNode& node) {}
  virtual void leavePackage_import_declaration(const SURELOG::AstNode& node) {}

  virtual void enterPackage_import_item(const SURELOG::AstNode& node) {}
  virtual void leavePackage_import_item(const SURELOG::AstNode& node) {}

  virtual void enterPackage_item(const SURELOG::AstNode& node) {}
  virtual void leavePackage_item(const SURELOG::AstNode& node) {}

  virtual void enterPackage_or_generate_item_declaration(const SURELOG::AstNode& node) {}
  virtual void leavePackage_or_generate_item_declaration(const SURELOG::AstNode& node) {}

  virtual void enterPackage_scope(const SURELOG::AstNode& node) {}
  virtual void leavePackage_scope(const SURELOG::AstNode& node) {}

  virtual void enterPacked_dimension(const SURELOG::AstNode& node) {}
  virtual void leavePacked_dimension(const SURELOG::AstNode& node) {}

  virtual void enterPacked_keyword(const SURELOG::AstNode& node) {}
  virtual void leavePacked_keyword(const SURELOG::AstNode& node) {}

  virtual void enterPaired_parens(const SURELOG::AstNode& node) {}
  virtual void leavePaired_parens(const SURELOG::AstNode& node) {}

  virtual void enterPar_block(const SURELOG::AstNode& node) {}
  virtual void leavePar_block(const SURELOG::AstNode& node) {}

  virtual void enterParallel_edge_sensitive_path_description(const SURELOG::AstNode& node) {}
  virtual void leaveParallel_edge_sensitive_path_description(const SURELOG::AstNode& node) {}

  virtual void enterParallel_path_description(const SURELOG::AstNode& node) {}
  virtual void leaveParallel_path_description(const SURELOG::AstNode& node) {}

  virtual void enterParam_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveParam_assignment(const SURELOG::AstNode& node) {}

  virtual void enterParam_expression(const SURELOG::AstNode& node) {}
  virtual void leaveParam_expression(const SURELOG::AstNode& node) {}

  virtual void enterParameter_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveParameter_declaration(const SURELOG::AstNode& node) {}

  virtual void enterParameter_override(const SURELOG::AstNode& node) {}
  virtual void leaveParameter_override(const SURELOG::AstNode& node) {}

  virtual void enterParameter_port_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveParameter_port_declaration(const SURELOG::AstNode& node) {}

  virtual void enterParameter_port_list(const SURELOG::AstNode& node) {}
  virtual void leaveParameter_port_list(const SURELOG::AstNode& node) {}

  virtual void enterParameter_value_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveParameter_value_assignment(const SURELOG::AstNode& node) {}

  virtual void enterPart_select_op(const SURELOG::AstNode& node) {}
  virtual void leavePart_select_op(const SURELOG::AstNode& node) {}

  virtual void enterPart_select_op_column(const SURELOG::AstNode& node) {}
  virtual void leavePart_select_op_column(const SURELOG::AstNode& node) {}

  virtual void enterPart_select_range(const SURELOG::AstNode& node) {}
  virtual void leavePart_select_range(const SURELOG::AstNode& node) {}

  virtual void enterPassEnSwitch_RTranif0(const SURELOG::AstNode& node) {}
  virtual void leavePassEnSwitch_RTranif0(const SURELOG::AstNode& node) {}

  virtual void enterPassEnSwitch_RTranif1(const SURELOG::AstNode& node) {}
  virtual void leavePassEnSwitch_RTranif1(const SURELOG::AstNode& node) {}

  virtual void enterPassEnSwitch_Tranif0(const SURELOG::AstNode& node) {}
  virtual void leavePassEnSwitch_Tranif0(const SURELOG::AstNode& node) {}

  virtual void enterPassEnSwitch_Tranif1(const SURELOG::AstNode& node) {}
  virtual void leavePassEnSwitch_Tranif1(const SURELOG::AstNode& node) {}

  virtual void enterPassSwitch_RTran(const SURELOG::AstNode& node) {}
  virtual void leavePassSwitch_RTran(const SURELOG::AstNode& node) {}

  virtual void enterPassSwitch_Tran(const SURELOG::AstNode& node) {}
  virtual void leavePassSwitch_Tran(const SURELOG::AstNode& node) {}

  virtual void enterPass_enable_switch_instance(const SURELOG::AstNode& node) {}
  virtual void leavePass_enable_switch_instance(const SURELOG::AstNode& node) {}

  virtual void enterPass_switch_instance(const SURELOG::AstNode& node) {}
  virtual void leavePass_switch_instance(const SURELOG::AstNode& node) {}

  virtual void enterPath_declaration(const SURELOG::AstNode& node) {}
  virtual void leavePath_declaration(const SURELOG::AstNode& node) {}

  virtual void enterPath_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leavePath_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterPath_delay_value(const SURELOG::AstNode& node) {}
  virtual void leavePath_delay_value(const SURELOG::AstNode& node) {}

  virtual void enterPattern(const SURELOG::AstNode& node) {}
  virtual void leavePattern(const SURELOG::AstNode& node) {}

  virtual void enterPort(const SURELOG::AstNode& node) {}
  virtual void leavePort(const SURELOG::AstNode& node) {}

  virtual void enterPortDir_Inout(const SURELOG::AstNode& node) {}
  virtual void leavePortDir_Inout(const SURELOG::AstNode& node) {}

  virtual void enterPortDir_Inp(const SURELOG::AstNode& node) {}
  virtual void leavePortDir_Inp(const SURELOG::AstNode& node) {}

  virtual void enterPortDir_Out(const SURELOG::AstNode& node) {}
  virtual void leavePortDir_Out(const SURELOG::AstNode& node) {}

  virtual void enterPortDir_Ref(const SURELOG::AstNode& node) {}
  virtual void leavePortDir_Ref(const SURELOG::AstNode& node) {}

  virtual void enterPortInst(const SURELOG::AstNode& node) {}
  virtual void leavePortInst(const SURELOG::AstNode& node) {}

  virtual void enterPort_declaration(const SURELOG::AstNode& node) {}
  virtual void leavePort_declaration(const SURELOG::AstNode& node) {}

  virtual void enterPort_direction(const SURELOG::AstNode& node) {}
  virtual void leavePort_direction(const SURELOG::AstNode& node) {}

  virtual void enterPort_expression(const SURELOG::AstNode& node) {}
  virtual void leavePort_expression(const SURELOG::AstNode& node) {}

  virtual void enterPort_reference(const SURELOG::AstNode& node) {}
  virtual void leavePort_reference(const SURELOG::AstNode& node) {}

  virtual void enterPound_Pound_delay(const SURELOG::AstNode& node) {}
  virtual void leavePound_Pound_delay(const SURELOG::AstNode& node) {}

  virtual void enterPound_delay(const SURELOG::AstNode& node) {}
  virtual void leavePound_delay(const SURELOG::AstNode& node) {}

  virtual void enterPound_delay_value(const SURELOG::AstNode& node) {}
  virtual void leavePound_delay_value(const SURELOG::AstNode& node) {}

  virtual void enterPound_pound_delay(const SURELOG::AstNode& node) {}
  virtual void leavePound_pound_delay(const SURELOG::AstNode& node) {}

  virtual void enterPragma_directive(const SURELOG::AstNode& node) {}
  virtual void leavePragma_directive(const SURELOG::AstNode& node) {}

  virtual void enterPragma_expression(const SURELOG::AstNode& node) {}
  virtual void leavePragma_expression(const SURELOG::AstNode& node) {}

  virtual void enterPragma_value(const SURELOG::AstNode& node) {}
  virtual void leavePragma_value(const SURELOG::AstNode& node) {}

  virtual void enterPrimary(const SURELOG::AstNode& node) {}
  virtual void leavePrimary(const SURELOG::AstNode& node) {}

  virtual void enterPrimary_literal(const SURELOG::AstNode& node) {}
  virtual void leavePrimary_literal(const SURELOG::AstNode& node) {}

  virtual void enterPrimitive(const SURELOG::AstNode& node) {}
  virtual void leavePrimitive(const SURELOG::AstNode& node) {}

  virtual void enterPrimitiveInstance(const SURELOG::AstNode& node) {}
  virtual void leavePrimitiveInstance(const SURELOG::AstNode& node) {}

  virtual void enterPriority(const SURELOG::AstNode& node) {}
  virtual void leavePriority(const SURELOG::AstNode& node) {}

  virtual void enterProcedural_assertion_statement(const SURELOG::AstNode& node) {}
  virtual void leaveProcedural_assertion_statement(const SURELOG::AstNode& node) {}

  virtual void enterProcedural_continuous_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveProcedural_continuous_assignment(const SURELOG::AstNode& node) {}

  virtual void enterProcedural_timing_control(const SURELOG::AstNode& node) {}
  virtual void leaveProcedural_timing_control(const SURELOG::AstNode& node) {}

  virtual void enterProcedural_timing_control_statement(const SURELOG::AstNode& node) {}
  virtual void leaveProcedural_timing_control_statement(const SURELOG::AstNode& node) {}

  virtual void enterProduction(const SURELOG::AstNode& node) {}
  virtual void leaveProduction(const SURELOG::AstNode& node) {}

  virtual void enterProduction_item(const SURELOG::AstNode& node) {}
  virtual void leaveProduction_item(const SURELOG::AstNode& node) {}

  virtual void enterProgram(const SURELOG::AstNode& node) {}
  virtual void leaveProgram(const SURELOG::AstNode& node) {}

  virtual void enterProgram_ansi_header(const SURELOG::AstNode& node) {}
  virtual void leaveProgram_ansi_header(const SURELOG::AstNode& node) {}

  virtual void enterProgram_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveProgram_declaration(const SURELOG::AstNode& node) {}

  virtual void enterProgram_generate_item(const SURELOG::AstNode& node) {}
  virtual void leaveProgram_generate_item(const SURELOG::AstNode& node) {}

  virtual void enterProgram_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveProgram_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterProgram_item(const SURELOG::AstNode& node) {}
  virtual void leaveProgram_item(const SURELOG::AstNode& node) {}

  virtual void enterProgram_nonansi_header(const SURELOG::AstNode& node) {}
  virtual void leaveProgram_nonansi_header(const SURELOG::AstNode& node) {}

  virtual void enterPropQualifier_ClassItem(const SURELOG::AstNode& node) {}
  virtual void leavePropQualifier_ClassItem(const SURELOG::AstNode& node) {}

  virtual void enterPropQualifier_Rand(const SURELOG::AstNode& node) {}
  virtual void leavePropQualifier_Rand(const SURELOG::AstNode& node) {}

  virtual void enterPropQualifier_Randc(const SURELOG::AstNode& node) {}
  virtual void leavePropQualifier_Randc(const SURELOG::AstNode& node) {}

  virtual void enterProperty_actual_arg(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_actual_arg(const SURELOG::AstNode& node) {}

  virtual void enterProperty_case_item(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_case_item(const SURELOG::AstNode& node) {}

  virtual void enterProperty_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_declaration(const SURELOG::AstNode& node) {}

  virtual void enterProperty_expr(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_expr(const SURELOG::AstNode& node) {}

  virtual void enterProperty_formal_type(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_formal_type(const SURELOG::AstNode& node) {}

  virtual void enterProperty_instance(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_instance(const SURELOG::AstNode& node) {}

  virtual void enterProperty_lvar_port_direction(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_lvar_port_direction(const SURELOG::AstNode& node) {}

  virtual void enterProperty_port_item(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_port_item(const SURELOG::AstNode& node) {}

  virtual void enterProperty_port_list(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_port_list(const SURELOG::AstNode& node) {}

  virtual void enterProperty_spec(const SURELOG::AstNode& node) {}
  virtual void leaveProperty_spec(const SURELOG::AstNode& node) {}

  virtual void enterProtect_directive(const SURELOG::AstNode& node) {}
  virtual void leaveProtect_directive(const SURELOG::AstNode& node) {}

  virtual void enterProtected_directive(const SURELOG::AstNode& node) {}
  virtual void leaveProtected_directive(const SURELOG::AstNode& node) {}

  virtual void enterPs_identifier(const SURELOG::AstNode& node) {}
  virtual void leavePs_identifier(const SURELOG::AstNode& node) {}

  virtual void enterPs_or_hierarchical_array_identifier(const SURELOG::AstNode& node) {}
  virtual void leavePs_or_hierarchical_array_identifier(const SURELOG::AstNode& node) {}

  virtual void enterPs_or_hierarchical_identifier(const SURELOG::AstNode& node) {}
  virtual void leavePs_or_hierarchical_identifier(const SURELOG::AstNode& node) {}

  virtual void enterPs_or_hierarchical_sequence_identifier(const SURELOG::AstNode& node) {}
  virtual void leavePs_or_hierarchical_sequence_identifier(const SURELOG::AstNode& node) {}

  virtual void enterPs_type_identifier(const SURELOG::AstNode& node) {}
  virtual void leavePs_type_identifier(const SURELOG::AstNode& node) {}

  virtual void enterPull0(const SURELOG::AstNode& node) {}
  virtual void leavePull0(const SURELOG::AstNode& node) {}

  virtual void enterPull1(const SURELOG::AstNode& node) {}
  virtual void leavePull1(const SURELOG::AstNode& node) {}

  virtual void enterPull_gate_instance(const SURELOG::AstNode& node) {}
  virtual void leavePull_gate_instance(const SURELOG::AstNode& node) {}

  virtual void enterPulldown(const SURELOG::AstNode& node) {}
  virtual void leavePulldown(const SURELOG::AstNode& node) {}

  virtual void enterPulldown_strength(const SURELOG::AstNode& node) {}
  virtual void leavePulldown_strength(const SURELOG::AstNode& node) {}

  virtual void enterPullup(const SURELOG::AstNode& node) {}
  virtual void leavePullup(const SURELOG::AstNode& node) {}

  virtual void enterPullup_strength(const SURELOG::AstNode& node) {}
  virtual void leavePullup_strength(const SURELOG::AstNode& node) {}

  virtual void enterPulse_control_specparam(const SURELOG::AstNode& node) {}
  virtual void leavePulse_control_specparam(const SURELOG::AstNode& node) {}

  virtual void enterPulsestyle_declaration(const SURELOG::AstNode& node) {}
  virtual void leavePulsestyle_declaration(const SURELOG::AstNode& node) {}

  virtual void enterPure(const SURELOG::AstNode& node) {}
  virtual void leavePure(const SURELOG::AstNode& node) {}

  virtual void enterPure_keyword(const SURELOG::AstNode& node) {}
  virtual void leavePure_keyword(const SURELOG::AstNode& node) {}

  virtual void enterPure_virtual_qualifier(const SURELOG::AstNode& node) {}
  virtual void leavePure_virtual_qualifier(const SURELOG::AstNode& node) {}

  virtual void enterQmark(const SURELOG::AstNode& node) {}
  virtual void leaveQmark(const SURELOG::AstNode& node) {}

  virtual void enterQueue_dimension(const SURELOG::AstNode& node) {}
  virtual void leaveQueue_dimension(const SURELOG::AstNode& node) {}

  virtual void enterREJECT_ON(const SURELOG::AstNode& node) {}
  virtual void leaveREJECT_ON(const SURELOG::AstNode& node) {}

  virtual void enterRandcase_item(const SURELOG::AstNode& node) {}
  virtual void leaveRandcase_item(const SURELOG::AstNode& node) {}

  virtual void enterRandcase_statement(const SURELOG::AstNode& node) {}
  virtual void leaveRandcase_statement(const SURELOG::AstNode& node) {}

  virtual void enterRandomQualifier_Rand(const SURELOG::AstNode& node) {}
  virtual void leaveRandomQualifier_Rand(const SURELOG::AstNode& node) {}

  virtual void enterRandomQualifier_RandC(const SURELOG::AstNode& node) {}
  virtual void leaveRandomQualifier_RandC(const SURELOG::AstNode& node) {}

  virtual void enterRandomize_call(const SURELOG::AstNode& node) {}
  virtual void leaveRandomize_call(const SURELOG::AstNode& node) {}

  virtual void enterRandsequence_statement(const SURELOG::AstNode& node) {}
  virtual void leaveRandsequence_statement(const SURELOG::AstNode& node) {}

  virtual void enterRange_expression(const SURELOG::AstNode& node) {}
  virtual void leaveRange_expression(const SURELOG::AstNode& node) {}

  virtual void enterRange_list(const SURELOG::AstNode& node) {}
  virtual void leaveRange_list(const SURELOG::AstNode& node) {}

  virtual void enterRealConst(const SURELOG::AstNode& node) {}
  virtual void leaveRealConst(const SURELOG::AstNode& node) {}

  virtual void enterRef_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveRef_declaration(const SURELOG::AstNode& node) {}

  virtual void enterReference_event(const SURELOG::AstNode& node) {}
  virtual void leaveReference_event(const SURELOG::AstNode& node) {}

  virtual void enterRelease(const SURELOG::AstNode& node) {}
  virtual void leaveRelease(const SURELOG::AstNode& node) {}

  virtual void enterRemain_active_flag(const SURELOG::AstNode& node) {}
  virtual void leaveRemain_active_flag(const SURELOG::AstNode& node) {}

  virtual void enterRemove_gatename_directive(const SURELOG::AstNode& node) {}
  virtual void leaveRemove_gatename_directive(const SURELOG::AstNode& node) {}

  virtual void enterRemove_netname_directive(const SURELOG::AstNode& node) {}
  virtual void leaveRemove_netname_directive(const SURELOG::AstNode& node) {}

  virtual void enterRepeat(const SURELOG::AstNode& node) {}
  virtual void leaveRepeat(const SURELOG::AstNode& node) {}

  virtual void enterRepeat_range(const SURELOG::AstNode& node) {}
  virtual void leaveRepeat_range(const SURELOG::AstNode& node) {}

  virtual void enterResetall_directive(const SURELOG::AstNode& node) {}
  virtual void leaveResetall_directive(const SURELOG::AstNode& node) {}

  virtual void enterRestrict_property_statement(const SURELOG::AstNode& node) {}
  virtual void leaveRestrict_property_statement(const SURELOG::AstNode& node) {}

  virtual void enterReturnStmt(const SURELOG::AstNode& node) {}
  virtual void leaveReturnStmt(const SURELOG::AstNode& node) {}

  virtual void enterRs_case(const SURELOG::AstNode& node) {}
  virtual void leaveRs_case(const SURELOG::AstNode& node) {}

  virtual void enterRs_case_item(const SURELOG::AstNode& node) {}
  virtual void leaveRs_case_item(const SURELOG::AstNode& node) {}

  virtual void enterRs_code_block(const SURELOG::AstNode& node) {}
  virtual void leaveRs_code_block(const SURELOG::AstNode& node) {}

  virtual void enterRs_if_else(const SURELOG::AstNode& node) {}
  virtual void leaveRs_if_else(const SURELOG::AstNode& node) {}

  virtual void enterRs_prod(const SURELOG::AstNode& node) {}
  virtual void leaveRs_prod(const SURELOG::AstNode& node) {}

  virtual void enterRs_production_list(const SURELOG::AstNode& node) {}
  virtual void leaveRs_production_list(const SURELOG::AstNode& node) {}

  virtual void enterRs_repeat(const SURELOG::AstNode& node) {}
  virtual void leaveRs_repeat(const SURELOG::AstNode& node) {}

  virtual void enterRs_rule(const SURELOG::AstNode& node) {}
  virtual void leaveRs_rule(const SURELOG::AstNode& node) {}

  virtual void enterSTRONG(const SURELOG::AstNode& node) {}
  virtual void leaveSTRONG(const SURELOG::AstNode& node) {}

  virtual void enterSYNC_ACCEPT_ON(const SURELOG::AstNode& node) {}
  virtual void leaveSYNC_ACCEPT_ON(const SURELOG::AstNode& node) {}

  virtual void enterSYNC_REJECT_ON(const SURELOG::AstNode& node) {}
  virtual void leaveSYNC_REJECT_ON(const SURELOG::AstNode& node) {}

  virtual void enterS_ALWAYS(const SURELOG::AstNode& node) {}
  virtual void leaveS_ALWAYS(const SURELOG::AstNode& node) {}

  virtual void enterS_EVENTUALLY(const SURELOG::AstNode& node) {}
  virtual void leaveS_EVENTUALLY(const SURELOG::AstNode& node) {}

  virtual void enterS_NEXTTIME(const SURELOG::AstNode& node) {}
  virtual void leaveS_NEXTTIME(const SURELOG::AstNode& node) {}

  virtual void enterS_UNTIL(const SURELOG::AstNode& node) {}
  virtual void leaveS_UNTIL(const SURELOG::AstNode& node) {}

  virtual void enterS_UNTIL_WITH(const SURELOG::AstNode& node) {}
  virtual void leaveS_UNTIL_WITH(const SURELOG::AstNode& node) {}

  virtual void enterScalar_1TickB0(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_1TickB0(const SURELOG::AstNode& node) {}

  virtual void enterScalar_1TickB1(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_1TickB1(const SURELOG::AstNode& node) {}

  virtual void enterScalar_1Tickb0(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_1Tickb0(const SURELOG::AstNode& node) {}

  virtual void enterScalar_1Tickb1(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_1Tickb1(const SURELOG::AstNode& node) {}

  virtual void enterScalar_Integral(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_Integral(const SURELOG::AstNode& node) {}

  virtual void enterScalar_TickB0(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_TickB0(const SURELOG::AstNode& node) {}

  virtual void enterScalar_TickB1(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_TickB1(const SURELOG::AstNode& node) {}

  virtual void enterScalar_Tickb0(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_Tickb0(const SURELOG::AstNode& node) {}

  virtual void enterScalar_Tickb1(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_Tickb1(const SURELOG::AstNode& node) {}

  virtual void enterScalar_timing_check_condition(const SURELOG::AstNode& node) {}
  virtual void leaveScalar_timing_check_condition(const SURELOG::AstNode& node) {}

  virtual void enterSelect(const SURELOG::AstNode& node) {}
  virtual void leaveSelect(const SURELOG::AstNode& node) {}

  virtual void enterSelect_condition(const SURELOG::AstNode& node) {}
  virtual void leaveSelect_condition(const SURELOG::AstNode& node) {}

  virtual void enterSelect_expression(const SURELOG::AstNode& node) {}
  virtual void leaveSelect_expression(const SURELOG::AstNode& node) {}

  virtual void enterSeqFormatType_Data(const SURELOG::AstNode& node) {}
  virtual void leaveSeqFormatType_Data(const SURELOG::AstNode& node) {}

  virtual void enterSeqFormatType_Sequence(const SURELOG::AstNode& node) {}
  virtual void leaveSeqFormatType_Sequence(const SURELOG::AstNode& node) {}

  virtual void enterSeqFormatType_Untyped(const SURELOG::AstNode& node) {}
  virtual void leaveSeqFormatType_Untyped(const SURELOG::AstNode& node) {}

  virtual void enterSeqLvarPortDir_Inout(const SURELOG::AstNode& node) {}
  virtual void leaveSeqLvarPortDir_Inout(const SURELOG::AstNode& node) {}

  virtual void enterSeqLvarPortDir_Input(const SURELOG::AstNode& node) {}
  virtual void leaveSeqLvarPortDir_Input(const SURELOG::AstNode& node) {}

  virtual void enterSeqLvarPortDir_Output(const SURELOG::AstNode& node) {}
  virtual void leaveSeqLvarPortDir_Output(const SURELOG::AstNode& node) {}

  virtual void enterSeq_block(const SURELOG::AstNode& node) {}
  virtual void leaveSeq_block(const SURELOG::AstNode& node) {}

  virtual void enterSeq_input_list(const SURELOG::AstNode& node) {}
  virtual void leaveSeq_input_list(const SURELOG::AstNode& node) {}

  virtual void enterSequence_actual_arg(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_actual_arg(const SURELOG::AstNode& node) {}

  virtual void enterSequence_arg(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_arg(const SURELOG::AstNode& node) {}

  virtual void enterSequence_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_declaration(const SURELOG::AstNode& node) {}

  virtual void enterSequence_expr(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_expr(const SURELOG::AstNode& node) {}

  virtual void enterSequence_instance(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_instance(const SURELOG::AstNode& node) {}

  virtual void enterSequence_list_of_arguments(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_list_of_arguments(const SURELOG::AstNode& node) {}

  virtual void enterSequence_match_item(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_match_item(const SURELOG::AstNode& node) {}

  virtual void enterSequence_method_call(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_method_call(const SURELOG::AstNode& node) {}

  virtual void enterSequence_port_item(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_port_item(const SURELOG::AstNode& node) {}

  virtual void enterSequence_port_list(const SURELOG::AstNode& node) {}
  virtual void leaveSequence_port_list(const SURELOG::AstNode& node) {}

  virtual void enterSequential_body(const SURELOG::AstNode& node) {}
  virtual void leaveSequential_body(const SURELOG::AstNode& node) {}

  virtual void enterSequential_entry(const SURELOG::AstNode& node) {}
  virtual void leaveSequential_entry(const SURELOG::AstNode& node) {}

  virtual void enterShowcancelled_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveShowcancelled_declaration(const SURELOG::AstNode& node) {}

  virtual void enterSigned_directive(const SURELOG::AstNode& node) {}
  virtual void leaveSigned_directive(const SURELOG::AstNode& node) {}

  virtual void enterSigning(const SURELOG::AstNode& node) {}
  virtual void leaveSigning(const SURELOG::AstNode& node) {}

  virtual void enterSigning_Signed(const SURELOG::AstNode& node) {}
  virtual void leaveSigning_Signed(const SURELOG::AstNode& node) {}

  virtual void enterSigning_Unsigned(const SURELOG::AstNode& node) {}
  virtual void leaveSigning_Unsigned(const SURELOG::AstNode& node) {}

  virtual void enterSimple_args_macro_definition(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_args_macro_definition(const SURELOG::AstNode& node) {}

  virtual void enterSimple_args_macro_definition_in_macro_body(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_args_macro_definition_in_macro_body(const SURELOG::AstNode& node) {}

  virtual void enterSimple_immediate_assert_statement(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_immediate_assert_statement(const SURELOG::AstNode& node) {}

  virtual void enterSimple_immediate_assertion_statement(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_immediate_assertion_statement(const SURELOG::AstNode& node) {}

  virtual void enterSimple_immediate_assume_statement(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_immediate_assume_statement(const SURELOG::AstNode& node) {}

  virtual void enterSimple_immediate_cover_statement(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_immediate_cover_statement(const SURELOG::AstNode& node) {}

  virtual void enterSimple_macro_definition_body(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_macro_definition_body(const SURELOG::AstNode& node) {}

  virtual void enterSimple_macro_definition_body_in_macro_body(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_macro_definition_body_in_macro_body(const SURELOG::AstNode& node) {}

  virtual void enterSimple_no_args_macro_definition(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_no_args_macro_definition(const SURELOG::AstNode& node) {}

  virtual void enterSimple_no_args_macro_definition_in_macro_body(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_no_args_macro_definition_in_macro_body(const SURELOG::AstNode& node) {}

  virtual void enterSimple_path_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_path_declaration(const SURELOG::AstNode& node) {}

  virtual void enterSimple_type(const SURELOG::AstNode& node) {}
  virtual void leaveSimple_type(const SURELOG::AstNode& node) {}

  virtual void enterSlice_size(const SURELOG::AstNode& node) {}
  virtual void leaveSlice_size(const SURELOG::AstNode& node) {}

  virtual void enterSlline(const SURELOG::AstNode& node) {}
  virtual void leaveSlline(const SURELOG::AstNode& node) {}

  virtual void enterSmall(const SURELOG::AstNode& node) {}
  virtual void leaveSmall(const SURELOG::AstNode& node) {}

  virtual void enterSolve_before_list(const SURELOG::AstNode& node) {}
  virtual void leaveSolve_before_list(const SURELOG::AstNode& node) {}

  virtual void enterSource_text(const SURELOG::AstNode& node) {}
  virtual void leaveSource_text(const SURELOG::AstNode& node) {}

  virtual void enterSpaces(const SURELOG::AstNode& node) {}
  virtual void leaveSpaces(const SURELOG::AstNode& node) {}

  virtual void enterSpecify_block(const SURELOG::AstNode& node) {}
  virtual void leaveSpecify_block(const SURELOG::AstNode& node) {}

  virtual void enterSpecify_input_terminal_descriptor(const SURELOG::AstNode& node) {}
  virtual void leaveSpecify_input_terminal_descriptor(const SURELOG::AstNode& node) {}

  virtual void enterSpecify_item(const SURELOG::AstNode& node) {}
  virtual void leaveSpecify_item(const SURELOG::AstNode& node) {}

  virtual void enterSpecify_output_terminal_descriptor(const SURELOG::AstNode& node) {}
  virtual void leaveSpecify_output_terminal_descriptor(const SURELOG::AstNode& node) {}

  virtual void enterSpecify_terminal_descriptor(const SURELOG::AstNode& node) {}
  virtual void leaveSpecify_terminal_descriptor(const SURELOG::AstNode& node) {}

  virtual void enterSpecparam_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveSpecparam_assignment(const SURELOG::AstNode& node) {}

  virtual void enterSpecparam_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveSpecparam_declaration(const SURELOG::AstNode& node) {}

  virtual void enterStamptime_condition(const SURELOG::AstNode& node) {}
  virtual void leaveStamptime_condition(const SURELOG::AstNode& node) {}

  virtual void enterStart_edge_offset(const SURELOG::AstNode& node) {}
  virtual void leaveStart_edge_offset(const SURELOG::AstNode& node) {}

  virtual void enterState_dependent_path_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveState_dependent_path_declaration(const SURELOG::AstNode& node) {}

  virtual void enterStatement(const SURELOG::AstNode& node) {}
  virtual void leaveStatement(const SURELOG::AstNode& node) {}

  virtual void enterStatement_item(const SURELOG::AstNode& node) {}
  virtual void leaveStatement_item(const SURELOG::AstNode& node) {}

  virtual void enterStatement_or_null(const SURELOG::AstNode& node) {}
  virtual void leaveStatement_or_null(const SURELOG::AstNode& node) {}

  virtual void enterStream_concatenation(const SURELOG::AstNode& node) {}
  virtual void leaveStream_concatenation(const SURELOG::AstNode& node) {}

  virtual void enterStream_expression(const SURELOG::AstNode& node) {}
  virtual void leaveStream_expression(const SURELOG::AstNode& node) {}

  virtual void enterStream_operator(const SURELOG::AstNode& node) {}
  virtual void leaveStream_operator(const SURELOG::AstNode& node) {}

  virtual void enterStreaming_concatenation(const SURELOG::AstNode& node) {}
  virtual void leaveStreaming_concatenation(const SURELOG::AstNode& node) {}

  virtual void enterStrength0(const SURELOG::AstNode& node) {}
  virtual void leaveStrength0(const SURELOG::AstNode& node) {}

  virtual void enterStrength1(const SURELOG::AstNode& node) {}
  virtual void leaveStrength1(const SURELOG::AstNode& node) {}

  virtual void enterString(const SURELOG::AstNode& node) {}
  virtual void leaveString(const SURELOG::AstNode& node) {}

  virtual void enterStringConst(const SURELOG::AstNode& node) {}
  virtual void leaveStringConst(const SURELOG::AstNode& node) {}

  virtual void enterStringLiteral(const SURELOG::AstNode& node) {}
  virtual void leaveStringLiteral(const SURELOG::AstNode& node) {}

  virtual void enterString_blob(const SURELOG::AstNode& node) {}
  virtual void leaveString_blob(const SURELOG::AstNode& node) {}

  virtual void enterString_type(const SURELOG::AstNode& node) {}
  virtual void leaveString_type(const SURELOG::AstNode& node) {}

  virtual void enterString_value(const SURELOG::AstNode& node) {}
  virtual void leaveString_value(const SURELOG::AstNode& node) {}

  virtual void enterStrong0(const SURELOG::AstNode& node) {}
  virtual void leaveStrong0(const SURELOG::AstNode& node) {}

  virtual void enterStrong1(const SURELOG::AstNode& node) {}
  virtual void leaveStrong1(const SURELOG::AstNode& node) {}

  virtual void enterStruct_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveStruct_keyword(const SURELOG::AstNode& node) {}

  virtual void enterStruct_union(const SURELOG::AstNode& node) {}
  virtual void leaveStruct_union(const SURELOG::AstNode& node) {}

  virtual void enterStruct_union_member(const SURELOG::AstNode& node) {}
  virtual void leaveStruct_union_member(const SURELOG::AstNode& node) {}

  virtual void enterStructure_pattern_key(const SURELOG::AstNode& node) {}
  virtual void leaveStructure_pattern_key(const SURELOG::AstNode& node) {}

  virtual void enterSubroutine_call(const SURELOG::AstNode& node) {}
  virtual void leaveSubroutine_call(const SURELOG::AstNode& node) {}

  virtual void enterSubroutine_call_statement(const SURELOG::AstNode& node) {}
  virtual void leaveSubroutine_call_statement(const SURELOG::AstNode& node) {}

  virtual void enterSuper_dot_new(const SURELOG::AstNode& node) {}
  virtual void leaveSuper_dot_new(const SURELOG::AstNode& node) {}

  virtual void enterSuper_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveSuper_keyword(const SURELOG::AstNode& node) {}

  virtual void enterSupply0(const SURELOG::AstNode& node) {}
  virtual void leaveSupply0(const SURELOG::AstNode& node) {}

  virtual void enterSupply1(const SURELOG::AstNode& node) {}
  virtual void leaveSupply1(const SURELOG::AstNode& node) {}

  virtual void enterSuppress_faults_directive(const SURELOG::AstNode& node) {}
  virtual void leaveSuppress_faults_directive(const SURELOG::AstNode& node) {}

  virtual void enterSurelog_macro_not_defined(const SURELOG::AstNode& node) {}
  virtual void leaveSurelog_macro_not_defined(const SURELOG::AstNode& node) {}

  virtual void enterSv_file_directive(const SURELOG::AstNode& node) {}
  virtual void leaveSv_file_directive(const SURELOG::AstNode& node) {}

  virtual void enterSv_interface(const SURELOG::AstNode& node) {}
  virtual void leaveSv_interface(const SURELOG::AstNode& node) {}

  virtual void enterSv_line_directive(const SURELOG::AstNode& node) {}
  virtual void leaveSv_line_directive(const SURELOG::AstNode& node) {}

  virtual void enterSv_package(const SURELOG::AstNode& node) {}
  virtual void leaveSv_package(const SURELOG::AstNode& node) {}

  virtual void enterSystem_task(const SURELOG::AstNode& node) {}
  virtual void leaveSystem_task(const SURELOG::AstNode& node) {}

  virtual void enterSystem_task_names(const SURELOG::AstNode& node) {}
  virtual void leaveSystem_task_names(const SURELOG::AstNode& node) {}

  virtual void enterSystem_timing_check(const SURELOG::AstNode& node) {}
  virtual void leaveSystem_timing_check(const SURELOG::AstNode& node) {}

  virtual void enterT01_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveT01_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterT0x_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveT0x_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterT0z_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveT0z_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterT10_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveT10_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterT1x_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveT1x_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterT1z_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveT1z_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterT_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveT_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterTagged(const SURELOG::AstNode& node) {}
  virtual void leaveTagged(const SURELOG::AstNode& node) {}

  virtual void enterTagged_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveTagged_keyword(const SURELOG::AstNode& node) {}

  virtual void enterTask_body_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveTask_body_declaration(const SURELOG::AstNode& node) {}

  virtual void enterTask_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveTask_declaration(const SURELOG::AstNode& node) {}

  virtual void enterTask_name_decl(const SURELOG::AstNode& node) {}
  virtual void leaveTask_name_decl(const SURELOG::AstNode& node) {}

  virtual void enterTask_prototype(const SURELOG::AstNode& node) {}
  virtual void leaveTask_prototype(const SURELOG::AstNode& node) {}

  virtual void enterText_blob(const SURELOG::AstNode& node) {}
  virtual void leaveText_blob(const SURELOG::AstNode& node) {}

  virtual void enterTfPortDir_ConstRef(const SURELOG::AstNode& node) {}
  virtual void leaveTfPortDir_ConstRef(const SURELOG::AstNode& node) {}

  virtual void enterTfPortDir_Inout(const SURELOG::AstNode& node) {}
  virtual void leaveTfPortDir_Inout(const SURELOG::AstNode& node) {}

  virtual void enterTfPortDir_Inp(const SURELOG::AstNode& node) {}
  virtual void leaveTfPortDir_Inp(const SURELOG::AstNode& node) {}

  virtual void enterTfPortDir_Out(const SURELOG::AstNode& node) {}
  virtual void leaveTfPortDir_Out(const SURELOG::AstNode& node) {}

  virtual void enterTfPortDir_Ref(const SURELOG::AstNode& node) {}
  virtual void leaveTfPortDir_Ref(const SURELOG::AstNode& node) {}

  virtual void enterTf_item_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveTf_item_declaration(const SURELOG::AstNode& node) {}

  virtual void enterTf_port_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveTf_port_declaration(const SURELOG::AstNode& node) {}

  virtual void enterTf_port_direction(const SURELOG::AstNode& node) {}
  virtual void leaveTf_port_direction(const SURELOG::AstNode& node) {}

  virtual void enterTf_port_item(const SURELOG::AstNode& node) {}
  virtual void leaveTf_port_item(const SURELOG::AstNode& node) {}

  virtual void enterTf_port_list(const SURELOG::AstNode& node) {}
  virtual void leaveTf_port_list(const SURELOG::AstNode& node) {}

  virtual void enterTfall_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTfall_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterThis(const SURELOG::AstNode& node) {}
  virtual void leaveThis(const SURELOG::AstNode& node) {}

  virtual void enterThis_dot_super(const SURELOG::AstNode& node) {}
  virtual void leaveThis_dot_super(const SURELOG::AstNode& node) {}

  virtual void enterThis_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveThis_keyword(const SURELOG::AstNode& node) {}

  virtual void enterThreshold(const SURELOG::AstNode& node) {}
  virtual void leaveThreshold(const SURELOG::AstNode& node) {}

  virtual void enterThroughout(const SURELOG::AstNode& node) {}
  virtual void leaveThroughout(const SURELOG::AstNode& node) {}

  virtual void enterTimeUnitsDecl_TimePrecision(const SURELOG::AstNode& node) {}
  virtual void leaveTimeUnitsDecl_TimePrecision(const SURELOG::AstNode& node) {}

  virtual void enterTimeUnitsDecl_TimePrecisionTimeUnit(const SURELOG::AstNode& node) {}
  virtual void leaveTimeUnitsDecl_TimePrecisionTimeUnit(const SURELOG::AstNode& node) {}

  virtual void enterTimeUnitsDecl_TimeUnit(const SURELOG::AstNode& node) {}
  virtual void leaveTimeUnitsDecl_TimeUnit(const SURELOG::AstNode& node) {}

  virtual void enterTimeUnitsDecl_TimeUnitDiv(const SURELOG::AstNode& node) {}
  virtual void leaveTimeUnitsDecl_TimeUnitDiv(const SURELOG::AstNode& node) {}

  virtual void enterTimeUnitsDecl_TimeUnitTimePrecision(const SURELOG::AstNode& node) {}
  virtual void leaveTimeUnitsDecl_TimeUnitTimePrecision(const SURELOG::AstNode& node) {}

  virtual void enterTime_literal(const SURELOG::AstNode& node) {}
  virtual void leaveTime_literal(const SURELOG::AstNode& node) {}

  virtual void enterTime_unit(const SURELOG::AstNode& node) {}
  virtual void leaveTime_unit(const SURELOG::AstNode& node) {}

  virtual void enterTimescale_directive(const SURELOG::AstNode& node) {}
  virtual void leaveTimescale_directive(const SURELOG::AstNode& node) {}

  virtual void enterTimingCheckEventControl_Edge(const SURELOG::AstNode& node) {}
  virtual void leaveTimingCheckEventControl_Edge(const SURELOG::AstNode& node) {}

  virtual void enterTimingCheckEventControl_Negedge(const SURELOG::AstNode& node) {}
  virtual void leaveTimingCheckEventControl_Negedge(const SURELOG::AstNode& node) {}

  virtual void enterTimingCheckEventControl_Posedge(const SURELOG::AstNode& node) {}
  virtual void leaveTimingCheckEventControl_Posedge(const SURELOG::AstNode& node) {}

  virtual void enterTiming_check_condition(const SURELOG::AstNode& node) {}
  virtual void leaveTiming_check_condition(const SURELOG::AstNode& node) {}

  virtual void enterTiming_check_event(const SURELOG::AstNode& node) {}
  virtual void leaveTiming_check_event(const SURELOG::AstNode& node) {}

  virtual void enterTiming_check_limit(const SURELOG::AstNode& node) {}
  virtual void leaveTiming_check_limit(const SURELOG::AstNode& node) {}

  virtual void enterTop_directives(const SURELOG::AstNode& node) {}
  virtual void leaveTop_directives(const SURELOG::AstNode& node) {}

  virtual void enterTop_level_library_rule(const SURELOG::AstNode& node) {}
  virtual void leaveTop_level_library_rule(const SURELOG::AstNode& node) {}

  virtual void enterTop_level_rule(const SURELOG::AstNode& node) {}
  virtual void leaveTop_level_rule(const SURELOG::AstNode& node) {}

  virtual void enterTrans_list(const SURELOG::AstNode& node) {}
  virtual void leaveTrans_list(const SURELOG::AstNode& node) {}

  virtual void enterTrans_range_list(const SURELOG::AstNode& node) {}
  virtual void leaveTrans_range_list(const SURELOG::AstNode& node) {}

  virtual void enterTrans_set(const SURELOG::AstNode& node) {}
  virtual void leaveTrans_set(const SURELOG::AstNode& node) {}

  virtual void enterTrise_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTrise_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterTx0_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTx0_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterTx1_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTx1_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterTxz_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTxz_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterType(const SURELOG::AstNode& node) {}
  virtual void leaveType(const SURELOG::AstNode& node) {}

  virtual void enterType_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveType_declaration(const SURELOG::AstNode& node) {}

  virtual void enterType_reference(const SURELOG::AstNode& node) {}
  virtual void leaveType_reference(const SURELOG::AstNode& node) {}

  virtual void enterTz0_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTz0_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterTz1_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTz1_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterTz_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTz_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterTzx_path_delay_expression(const SURELOG::AstNode& node) {}
  virtual void leaveTzx_path_delay_expression(const SURELOG::AstNode& node) {}

  virtual void enterUNTIL(const SURELOG::AstNode& node) {}
  virtual void leaveUNTIL(const SURELOG::AstNode& node) {}

  virtual void enterUNTIL_WITH(const SURELOG::AstNode& node) {}
  virtual void leaveUNTIL_WITH(const SURELOG::AstNode& node) {}

  virtual void enterUdp_ansi_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_ansi_declaration(const SURELOG::AstNode& node) {}

  virtual void enterUdp_body(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_body(const SURELOG::AstNode& node) {}

  virtual void enterUdp_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_declaration(const SURELOG::AstNode& node) {}

  virtual void enterUdp_declaration_port_list(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_declaration_port_list(const SURELOG::AstNode& node) {}

  virtual void enterUdp_initial_statement(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_initial_statement(const SURELOG::AstNode& node) {}

  virtual void enterUdp_input_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_input_declaration(const SURELOG::AstNode& node) {}

  virtual void enterUdp_instance(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_instance(const SURELOG::AstNode& node) {}

  virtual void enterUdp_instantiation(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_instantiation(const SURELOG::AstNode& node) {}

  virtual void enterUdp_nonansi_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_nonansi_declaration(const SURELOG::AstNode& node) {}

  virtual void enterUdp_output_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_output_declaration(const SURELOG::AstNode& node) {}

  virtual void enterUdp_port_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_port_declaration(const SURELOG::AstNode& node) {}

  virtual void enterUdp_port_list(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_port_list(const SURELOG::AstNode& node) {}

  virtual void enterUdp_reg_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveUdp_reg_declaration(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_BitwAnd(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_BitwAnd(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_BitwOr(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_BitwOr(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_BitwXor(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_BitwXor(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_Not(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_Not(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_ReductNand(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_ReductNand(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_ReductNor(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_ReductNor(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_ReductXNor1(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_ReductXNor1(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_ReductXnor2(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_ReductXnor2(const SURELOG::AstNode& node) {}

  virtual void enterUnaryModOp_Tilda(const SURELOG::AstNode& node) {}
  virtual void leaveUnaryModOp_Tilda(const SURELOG::AstNode& node) {}

  virtual void enterUnary_BitwAnd(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_BitwAnd(const SURELOG::AstNode& node) {}

  virtual void enterUnary_BitwOr(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_BitwOr(const SURELOG::AstNode& node) {}

  virtual void enterUnary_BitwXor(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_BitwXor(const SURELOG::AstNode& node) {}

  virtual void enterUnary_Minus(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_Minus(const SURELOG::AstNode& node) {}

  virtual void enterUnary_Not(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_Not(const SURELOG::AstNode& node) {}

  virtual void enterUnary_Plus(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_Plus(const SURELOG::AstNode& node) {}

  virtual void enterUnary_ReductNand(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_ReductNand(const SURELOG::AstNode& node) {}

  virtual void enterUnary_ReductNor(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_ReductNor(const SURELOG::AstNode& node) {}

  virtual void enterUnary_ReductXnor1(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_ReductXnor1(const SURELOG::AstNode& node) {}

  virtual void enterUnary_ReductXnor2(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_ReductXnor2(const SURELOG::AstNode& node) {}

  virtual void enterUnary_Tilda(const SURELOG::AstNode& node) {}
  virtual void leaveUnary_Tilda(const SURELOG::AstNode& node) {}

  virtual void enterUnbased_unsized_literal(const SURELOG::AstNode& node) {}
  virtual void leaveUnbased_unsized_literal(const SURELOG::AstNode& node) {}

  virtual void enterUnconnected_drive_directive(const SURELOG::AstNode& node) {}
  virtual void leaveUnconnected_drive_directive(const SURELOG::AstNode& node) {}

  virtual void enterUndef_directive(const SURELOG::AstNode& node) {}
  virtual void leaveUndef_directive(const SURELOG::AstNode& node) {}

  virtual void enterUndefineall_directive(const SURELOG::AstNode& node) {}
  virtual void leaveUndefineall_directive(const SURELOG::AstNode& node) {}

  virtual void enterUnion_keyword(const SURELOG::AstNode& node) {}
  virtual void leaveUnion_keyword(const SURELOG::AstNode& node) {}

  virtual void enterUnique(const SURELOG::AstNode& node) {}
  virtual void leaveUnique(const SURELOG::AstNode& node) {}

  virtual void enterUnique0(const SURELOG::AstNode& node) {}
  virtual void leaveUnique0(const SURELOG::AstNode& node) {}

  virtual void enterUnique_call(const SURELOG::AstNode& node) {}
  virtual void leaveUnique_call(const SURELOG::AstNode& node) {}

  virtual void enterUnique_priority(const SURELOG::AstNode& node) {}
  virtual void leaveUnique_priority(const SURELOG::AstNode& node) {}

  virtual void enterUniqueness_constraint(const SURELOG::AstNode& node) {}
  virtual void leaveUniqueness_constraint(const SURELOG::AstNode& node) {}

  virtual void enterUnpacked_dimension(const SURELOG::AstNode& node) {}
  virtual void leaveUnpacked_dimension(const SURELOG::AstNode& node) {}

  virtual void enterUnsigned_directive(const SURELOG::AstNode& node) {}
  virtual void leaveUnsigned_directive(const SURELOG::AstNode& node) {}

  virtual void enterUnsized_dimension(const SURELOG::AstNode& node) {}
  virtual void leaveUnsized_dimension(const SURELOG::AstNode& node) {}

  virtual void enterUnterminated_string(const SURELOG::AstNode& node) {}
  virtual void leaveUnterminated_string(const SURELOG::AstNode& node) {}

  virtual void enterUse_clause(const SURELOG::AstNode& node) {}
  virtual void leaveUse_clause(const SURELOG::AstNode& node) {}

  virtual void enterUse_clause_config(const SURELOG::AstNode& node) {}
  virtual void leaveUse_clause_config(const SURELOG::AstNode& node) {}

  virtual void enterUselib_directive(const SURELOG::AstNode& node) {}
  virtual void leaveUselib_directive(const SURELOG::AstNode& node) {}

  virtual void enterValue_range(const SURELOG::AstNode& node) {}
  virtual void leaveValue_range(const SURELOG::AstNode& node) {}

  virtual void enterVar_data_type(const SURELOG::AstNode& node) {}
  virtual void leaveVar_data_type(const SURELOG::AstNode& node) {}

  virtual void enterVar_type(const SURELOG::AstNode& node) {}
  virtual void leaveVar_type(const SURELOG::AstNode& node) {}

  virtual void enterVariable_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveVariable_assignment(const SURELOG::AstNode& node) {}

  virtual void enterVariable_decl_assignment(const SURELOG::AstNode& node) {}
  virtual void leaveVariable_decl_assignment(const SURELOG::AstNode& node) {}

  virtual void enterVariable_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveVariable_declaration(const SURELOG::AstNode& node) {}

  virtual void enterVariable_dimension(const SURELOG::AstNode& node) {}
  virtual void leaveVariable_dimension(const SURELOG::AstNode& node) {}

  virtual void enterVariable_impl_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveVariable_impl_declaration(const SURELOG::AstNode& node) {}

  virtual void enterVariable_lvalue(const SURELOG::AstNode& node) {}
  virtual void leaveVariable_lvalue(const SURELOG::AstNode& node) {}

  virtual void enterVariable_port_header(const SURELOG::AstNode& node) {}
  virtual void leaveVariable_port_header(const SURELOG::AstNode& node) {}

  virtual void enterVariable_port_type(const SURELOG::AstNode& node) {}
  virtual void leaveVariable_port_type(const SURELOG::AstNode& node) {}

  virtual void enterVirtual(const SURELOG::AstNode& node) {}
  virtual void leaveVirtual(const SURELOG::AstNode& node) {}

  virtual void enterVirtual_interface_declaration(const SURELOG::AstNode& node) {}
  virtual void leaveVirtual_interface_declaration(const SURELOG::AstNode& node) {}

  virtual void enterWEAK(const SURELOG::AstNode& node) {}
  virtual void leaveWEAK(const SURELOG::AstNode& node) {}

  virtual void enterWait_statement(const SURELOG::AstNode& node) {}
  virtual void leaveWait_statement(const SURELOG::AstNode& node) {}

  virtual void enterWeak0(const SURELOG::AstNode& node) {}
  virtual void leaveWeak0(const SURELOG::AstNode& node) {}

  virtual void enterWeak1(const SURELOG::AstNode& node) {}
  virtual void leaveWeak1(const SURELOG::AstNode& node) {}

  virtual void enterWhile(const SURELOG::AstNode& node) {}
  virtual void leaveWhile(const SURELOG::AstNode& node) {}

  virtual void enterWith(const SURELOG::AstNode& node) {}
  virtual void leaveWith(const SURELOG::AstNode& node) {}

  virtual void enterWithin(const SURELOG::AstNode& node) {}
  virtual void leaveWithin(const SURELOG::AstNode& node) {}

  virtual void enterX(const SURELOG::AstNode& node) {}
  virtual void leaveX(const SURELOG::AstNode& node) {}

  virtual void enterXor_call(const SURELOG::AstNode& node) {}
  virtual void leaveXor_call(const SURELOG::AstNode& node) {}

  virtual void enterZ(const SURELOG::AstNode& node) {}
  virtual void leaveZ(const SURELOG::AstNode& node) {}
  // clang-format on

  void listen(const AstNode& node);
  void listenChildren(const AstNode& node);

  void listen(const std::filesystem::path& filepath, const VObject* objects,
              uint32_t count, const SymbolTable* symbolTable);

  bool getNodeName(const AstNode& node, std::string& name) const;
  bool getNodeFilePath(const AstNode& node,
                       std::filesystem::path& filepath) const;
  bool getNodeStartLine(const AstNode& node, int32_t& line) const;
  bool getNodeStartColumn(const AstNode& node, int32_t& column) const;
  bool getNodeEndLine(const AstNode& node, int32_t& line) const;
  bool getNodeEndColumn(const AstNode& node, int32_t& column) const;
  AstNode getNodeParent(const AstNode& node) const;
  void getChildren(const AstNode& node, bool ordered,
                   astnode_vector_t& children) const;
  void getSiblings(const AstNode& node, bool ordered,
                   astnode_vector_t& siblings) const;

 private:
  // clang-format off
  void listen0(const AstNode& node);
  void listen1(const AstNode& node);
  void listenACCEPT_ON(const AstNode& node);
  void listenALWAYS(const AstNode& node);
  void listenAND(const AstNode& node);
  void listenAccelerate_directive(const AstNode& node);
  void listenAction_block(const AstNode& node);
  void listenActual_arg_expr(const AstNode& node);
  void listenActual_arg_list(const AstNode& node);
  void listenAlwaysKeywd_Always(const AstNode& node);
  void listenAlwaysKeywd_Comb(const AstNode& node);
  void listenAlwaysKeywd_FF(const AstNode& node);
  void listenAlwaysKeywd_Latch(const AstNode& node);
  void listenAlways_construct(const AstNode& node);
  void listenAlways_keyword(const AstNode& node);
  void listenAnd_call(const AstNode& node);
  void listenAnonymous_program(const AstNode& node);
  void listenAnonymous_program_item(const AstNode& node);
  void listenAnsi_port_declaration(const AstNode& node);
  void listenArgument(const AstNode& node);
  void listenArray_manipulation_call(const AstNode& node);
  void listenArray_member_label(const AstNode& node);
  void listenArray_method_name(const AstNode& node);
  void listenArray_pattern_key(const AstNode& node);
  void listenArray_range_expression(const AstNode& node);
  void listenAssert_property_statement(const AstNode& node);
  void listenAssertion_item(const AstNode& node);
  void listenAssertion_item_declaration(const AstNode& node);
  void listenAssertion_variable_declaration(const AstNode& node);
  void listenAssign(const AstNode& node);
  void listenAssignOp_Add(const AstNode& node);
  void listenAssignOp_ArithShiftLeft(const AstNode& node);
  void listenAssignOp_ArithShiftRight(const AstNode& node);
  void listenAssignOp_Assign(const AstNode& node);
  void listenAssignOp_BitwAnd(const AstNode& node);
  void listenAssignOp_BitwLeftShift(const AstNode& node);
  void listenAssignOp_BitwOr(const AstNode& node);
  void listenAssignOp_BitwRightShift(const AstNode& node);
  void listenAssignOp_BitwXor(const AstNode& node);
  void listenAssignOp_Div(const AstNode& node);
  void listenAssignOp_Modulo(const AstNode& node);
  void listenAssignOp_Mult(const AstNode& node);
  void listenAssignOp_Sub(const AstNode& node);
  void listenAssignment_operator(const AstNode& node);
  void listenAssignment_pattern(const AstNode& node);
  void listenAssignment_pattern_expression(const AstNode& node);
  void listenAssignment_pattern_expression_type(const AstNode& node);
  void listenAssignment_pattern_key(const AstNode& node);
  void listenAssignment_pattern_net_lvalue(const AstNode& node);
  void listenAssignment_pattern_variable_lvalue(const AstNode& node);
  void listenAssociative_dimension(const AstNode& node);
  void listenAssume_property_statement(const AstNode& node);
  void listenAttr_name(const AstNode& node);
  void listenAttr_spec(const AstNode& node);
  void listenAttribute_instance(const AstNode& node);
  void listenAutoexpand_vectornets_directive(const AstNode& node);
  void listenBegin_keywords_directive(const AstNode& node);
  void listenBinModOp_BitwAnd(const AstNode& node);
  void listenBinModOp_BitwOr(const AstNode& node);
  void listenBinModOp_BitwXor(const AstNode& node);
  void listenBinModOp_Equiv(const AstNode& node);
  void listenBinModOp_LogicAnd(const AstNode& node);
  void listenBinModOp_LogicOr(const AstNode& node);
  void listenBinModOp_NotEqual(const AstNode& node);
  void listenBinModOp_ReductXnor1(const AstNode& node);
  void listenBinModOp_ReductXnor2(const AstNode& node);
  void listenBinOp_ArithShiftLeft(const AstNode& node);
  void listenBinOp_ArithShiftRight(const AstNode& node);
  void listenBinOp_BitwAnd(const AstNode& node);
  void listenBinOp_BitwOr(const AstNode& node);
  void listenBinOp_BitwXor(const AstNode& node);
  void listenBinOp_Div(const AstNode& node);
  void listenBinOp_Equiv(const AstNode& node);
  void listenBinOp_Equivalence(const AstNode& node);
  void listenBinOp_FourStateLogicEqual(const AstNode& node);
  void listenBinOp_FourStateLogicNotEqual(const AstNode& node);
  void listenBinOp_Great(const AstNode& node);
  void listenBinOp_GreatEqual(const AstNode& node);
  void listenBinOp_Imply(const AstNode& node);
  void listenBinOp_Less(const AstNode& node);
  void listenBinOp_LessEqual(const AstNode& node);
  void listenBinOp_LogicAnd(const AstNode& node);
  void listenBinOp_LogicOr(const AstNode& node);
  void listenBinOp_Minus(const AstNode& node);
  void listenBinOp_Mult(const AstNode& node);
  void listenBinOp_MultMult(const AstNode& node);
  void listenBinOp_Not(const AstNode& node);
  void listenBinOp_Percent(const AstNode& node);
  void listenBinOp_Plus(const AstNode& node);
  void listenBinOp_ReductNand(const AstNode& node);
  void listenBinOp_ReductNor(const AstNode& node);
  void listenBinOp_ReductXnor1(const AstNode& node);
  void listenBinOp_ReductXnor2(const AstNode& node);
  void listenBinOp_ShiftLeft(const AstNode& node);
  void listenBinOp_ShiftRight(const AstNode& node);
  void listenBinOp_WildEqual(const AstNode& node);
  void listenBinOp_WildNotEqual(const AstNode& node);
  void listenBinOp_WildcardEqual(const AstNode& node);
  void listenBinOp_WildcardNotEqual(const AstNode& node);
  void listenBind_directive(const AstNode& node);
  void listenBind_instantiation(const AstNode& node);
  void listenBins_Bins(const AstNode& node);
  void listenBins_Ignore(const AstNode& node);
  void listenBins_Illegal(const AstNode& node);
  void listenBins_expression(const AstNode& node);
  void listenBins_or_empty(const AstNode& node);
  void listenBins_or_options(const AstNode& node);
  void listenBins_selection(const AstNode& node);
  void listenBins_selection_or_option(const AstNode& node);
  void listenBit_select(const AstNode& node);
  void listenBlock_event_expression(const AstNode& node);
  void listenBlock_item_declaration(const AstNode& node);
  void listenBlocking_assignment(const AstNode& node);
  void listenBoolean_abbrev(const AstNode& node);
  void listenBreakStmt(const AstNode& node);
  void listenBuilt_in_method_call(const AstNode& node);
  void listenCR(const AstNode& node);
  void listenCase(const AstNode& node);
  void listenCaseX(const AstNode& node);
  void listenCaseZ(const AstNode& node);
  void listenCase_generate_construct(const AstNode& node);
  void listenCase_generate_item(const AstNode& node);
  void listenCase_inside_item(const AstNode& node);
  void listenCase_item(const AstNode& node);
  void listenCase_keyword(const AstNode& node);
  void listenCase_pattern_item(const AstNode& node);
  void listenCase_statement(const AstNode& node);
  void listenCast(const AstNode& node);
  void listenCasting_type(const AstNode& node);
  void listenCell_clause(const AstNode& node);
  void listenCelldefine_directive(const AstNode& node);
  void listenChandle_type(const AstNode& node);
  void listenCharge_strength(const AstNode& node);
  void listenChecker(const AstNode& node);
  void listenChecker_declaration(const AstNode& node);
  void listenChecker_generate_item(const AstNode& node);
  void listenChecker_instantiation(const AstNode& node);
  void listenChecker_or_generate_item(const AstNode& node);
  void listenChecker_or_generate_item_declaration(const AstNode& node);
  void listenChecker_port_item(const AstNode& node);
  void listenChecker_port_list(const AstNode& node);
  void listenClass(const AstNode& node);
  void listenClassItemQualifier_Local(const AstNode& node);
  void listenClassItemQualifier_Protected(const AstNode& node);
  void listenClassItemQualifier_Static(const AstNode& node);
  void listenClass_constraint(const AstNode& node);
  void listenClass_constructor_declaration(const AstNode& node);
  void listenClass_constructor_prototype(const AstNode& node);
  void listenClass_declaration(const AstNode& node);
  void listenClass_item(const AstNode& node);
  void listenClass_keyword(const AstNode& node);
  void listenClass_method(const AstNode& node);
  void listenClass_new(const AstNode& node);
  void listenClass_property(const AstNode& node);
  void listenClass_scope(const AstNode& node);
  void listenClass_type(const AstNode& node);
  void listenClockingDir_Inout(const AstNode& node);
  void listenClockingDir_Input(const AstNode& node);
  void listenClockingDir_InputOutput(const AstNode& node);
  void listenClockingDir_Output(const AstNode& node);
  void listenClocking_decl_assign(const AstNode& node);
  void listenClocking_declaration(const AstNode& node);
  void listenClocking_drive(const AstNode& node);
  void listenClocking_event(const AstNode& node);
  void listenClocking_item(const AstNode& node);
  void listenClocking_skew(const AstNode& node);
  void listenClockvar(const AstNode& node);
  void listenClockvar_expression(const AstNode& node);
  void listenCloseParens(const AstNode& node);
  void listenCmosSwitchType_Cmos(const AstNode& node);
  void listenCmosSwitchType_RCmos(const AstNode& node);
  void listenCmos_switch_instance(const AstNode& node);
  void listenColumnPartSelectOp(const AstNode& node);
  void listenCombinational_body(const AstNode& node);
  void listenCombinational_entry(const AstNode& node);
  void listenComma(const AstNode& node);
  void listenComma_operator(const AstNode& node);
  void listenComments(const AstNode& node);
  void listenComplex_func_call(const AstNode& node);
  void listenConcatenation(const AstNode& node);
  void listenConcurrent_assertion_item(const AstNode& node);
  void listenConcurrent_assertion_item_declaration(const AstNode& node);
  void listenConcurrent_assertion_statement(const AstNode& node);
  void listenCond_predicate(const AstNode& node);
  void listenConditional_generate_construct(const AstNode& node);
  void listenConditional_operator(const AstNode& node);
  void listenConditional_statement(const AstNode& node);
  void listenConfig(const AstNode& node);
  void listenConfig_declaration(const AstNode& node);
  void listenConfig_rule_statement(const AstNode& node);
  void listenConsecutive_repetition(const AstNode& node);
  void listenConstSelect(const AstNode& node);
  void listenConst_or_range_expression(const AstNode& node);
  void listenConst_type(const AstNode& node);
  void listenConstantSelect(const AstNode& node);
  void listenConstant_assignment_pattern_expression(const AstNode& node);
  void listenConstant_bit_select(const AstNode& node);
  void listenConstant_cast(const AstNode& node);
  void listenConstant_concatenation(const AstNode& node);
  void listenConstant_expression(const AstNode& node);
  void listenConstant_indexed_range(const AstNode& node);
  void listenConstant_mintypmax_expression(const AstNode& node);
  void listenConstant_multiple_concatenation(const AstNode& node);
  void listenConstant_param_expression(const AstNode& node);
  void listenConstant_part_select_range(const AstNode& node);
  void listenConstant_primary(const AstNode& node);
  void listenConstant_range(const AstNode& node);
  void listenConstant_range_expression(const AstNode& node);
  void listenConstant_select(const AstNode& node);
  void listenConstraint_block(const AstNode& node);
  void listenConstraint_block_item(const AstNode& node);
  void listenConstraint_declaration(const AstNode& node);
  void listenConstraint_expression(const AstNode& node);
  void listenConstraint_primary(const AstNode& node);
  void listenConstraint_prototype(const AstNode& node);
  void listenConstraint_set(const AstNode& node);
  void listenContext_keyword(const AstNode& node);
  void listenContinueStmt(const AstNode& node);
  void listenContinuous_assign(const AstNode& node);
  void listenControlled_timing_check_event(const AstNode& node);
  void listenCover_cross(const AstNode& node);
  void listenCover_point(const AstNode& node);
  void listenCover_property_statement(const AstNode& node);
  void listenCover_sequence_statement(const AstNode& node);
  void listenCoverage_event(const AstNode& node);
  void listenCoverage_option(const AstNode& node);
  void listenCoverage_spec(const AstNode& node);
  void listenCoverage_spec_or_option(const AstNode& node);
  void listenCovergroup_declaration(const AstNode& node);
  void listenCross_body(const AstNode& node);
  void listenCross_body_item(const AstNode& node);
  void listenCross_item(const AstNode& node);
  void listenCycle_delay(const AstNode& node);
  void listenCycle_delay_const_range_expression(const AstNode& node);
  void listenCycle_delay_range(const AstNode& node);
  void listenData_declaration(const AstNode& node);
  void listenData_type(const AstNode& node);
  void listenData_type_or_implicit(const AstNode& node);
  void listenData_type_or_void(const AstNode& node);
  void listenDeassign(const AstNode& node);
  void listenDecPartSelectOp(const AstNode& node);
  void listenDefault(const AstNode& node);
  void listenDefaultSkew_Intput(const AstNode& node);
  void listenDefaultSkew_IntputOutput(const AstNode& node);
  void listenDefaultSkew_Output(const AstNode& node);
  void listenDefault_clause(const AstNode& node);
  void listenDefault_decay_time_directive(const AstNode& node);
  void listenDefault_nettype_directive(const AstNode& node);
  void listenDefault_trireg_strenght_directive(const AstNode& node);
  void listenDefault_value(const AstNode& node);
  void listenDeferred_immediate_assert_statement(const AstNode& node);
  void listenDeferred_immediate_assertion_item(const AstNode& node);
  void listenDeferred_immediate_assertion_statement(const AstNode& node);
  void listenDeferred_immediate_assume_statement(const AstNode& node);
  void listenDeferred_immediate_cover_statement(const AstNode& node);
  void listenDefine_directive(const AstNode& node);
  void listenDefparam_assignment(const AstNode& node);
  void listenDelay2(const AstNode& node);
  void listenDelay3(const AstNode& node);
  void listenDelay_control(const AstNode& node);
  void listenDelay_mode_distributed_directive(const AstNode& node);
  void listenDelay_mode_path_directive(const AstNode& node);
  void listenDelay_mode_unit_directive(const AstNode& node);
  void listenDelay_mode_zero_directive(const AstNode& node);
  void listenDelay_or_event_control(const AstNode& node);
  void listenDelay_value(const AstNode& node);
  void listenDelayed_data(const AstNode& node);
  void listenDelayed_reference(const AstNode& node);
  void listenDescription(const AstNode& node);
  void listenDesign_statement(const AstNode& node);
  void listenDirective_in_macro(const AstNode& node);
  void listenDisable_portfaults_directive(const AstNode& node);
  void listenDisable_statement(const AstNode& node);
  void listenDistWeight_AssignRange(const AstNode& node);
  void listenDistWeight_AssignValue(const AstNode& node);
  void listenDist_item(const AstNode& node);
  void listenDist_list(const AstNode& node);
  void listenDo(const AstNode& node);
  void listenDollar_fullskew_timing_check(const AstNode& node);
  void listenDollar_hold_timing_check(const AstNode& node);
  void listenDollar_keyword(const AstNode& node);
  void listenDollar_nochange_timing_check(const AstNode& node);
  void listenDollar_period_timing_check(const AstNode& node);
  void listenDollar_recovery_timing_check(const AstNode& node);
  void listenDollar_recrem_timing_check(const AstNode& node);
  void listenDollar_removal_timing_check(const AstNode& node);
  void listenDollar_root_keyword(const AstNode& node);
  void listenDollar_setup_timing_check(const AstNode& node);
  void listenDollar_setuphold_timing_check(const AstNode& node);
  void listenDollar_skew_timing_check(const AstNode& node);
  void listenDollar_timeskew_timing_check(const AstNode& node);
  void listenDollar_width_timing_check(const AstNode& node);
  void listenDot(const AstNode& node);
  void listenDotStar(const AstNode& node);
  void listenDpi_import_export(const AstNode& node);
  void listenDrive_strength(const AstNode& node);
  void listenDynamic_array_new(const AstNode& node);
  void listenEVENTUALLY(const AstNode& node);
  void listenEdge_Edge(const AstNode& node);
  void listenEdge_Negedge(const AstNode& node);
  void listenEdge_Posedge(const AstNode& node);
  void listenEdge_control_specifier(const AstNode& node);
  void listenEdge_descriptor(const AstNode& node);
  void listenEdge_identifier(const AstNode& node);
  void listenEdge_indicator(const AstNode& node);
  void listenEdge_input_list(const AstNode& node);
  void listenEdge_sensitive_path_declaration(const AstNode& node);
  void listenEdge_symbol(const AstNode& node);
  void listenElaboration_system_task(const AstNode& node);
  void listenElse(const AstNode& node);
  void listenElse_directive(const AstNode& node);
  void listenElseif_directive(const AstNode& node);
  void listenElseif_directive_in_macro_body(const AstNode& node);
  void listenElsif_directive(const AstNode& node);
  void listenElsif_directive_in_macro_body(const AstNode& node);
  void listenEmpty_queue(const AstNode& node);
  void listenEnableGateType_Bufif0(const AstNode& node);
  void listenEnableGateType_Bufif1(const AstNode& node);
  void listenEnableGateType_Notif0(const AstNode& node);
  void listenEnableGateType_Notif1(const AstNode& node);
  void listenEnable_gate_instance(const AstNode& node);
  void listenEnable_portfaults_directive(const AstNode& node);
  void listenEnd(const AstNode& node);
  void listenEnd_edge_offset(const AstNode& node);
  void listenEnd_keywords_directive(const AstNode& node);
  void listenEndcase(const AstNode& node);
  void listenEndcelldefine_directive(const AstNode& node);
  void listenEndchecker(const AstNode& node);
  void listenEndclass(const AstNode& node);
  void listenEndclocking(const AstNode& node);
  void listenEndconfig(const AstNode& node);
  void listenEndfunction(const AstNode& node);
  void listenEndgenerate(const AstNode& node);
  void listenEndgroup(const AstNode& node);
  void listenEndif_directive(const AstNode& node);
  void listenEndinterface(const AstNode& node);
  void listenEndmodule(const AstNode& node);
  void listenEndpackage(const AstNode& node);
  void listenEndprimitive(const AstNode& node);
  void listenEndprogram(const AstNode& node);
  void listenEndproperty(const AstNode& node);
  void listenEndprotect_directive(const AstNode& node);
  void listenEndprotected_directive(const AstNode& node);
  void listenEndsequence(const AstNode& node);
  void listenEndspecify(const AstNode& node);
  void listenEndtable(const AstNode& node);
  void listenEndtask(const AstNode& node);
  void listenEnum_base_type(const AstNode& node);
  void listenEnum_keyword(const AstNode& node);
  void listenEnum_name_declaration(const AstNode& node);
  void listenEscapedCR(const AstNode& node);
  void listenEscaped_identifier(const AstNode& node);
  void listenEscaped_macro_definition_body(const AstNode& node);
  void listenEscaped_macro_definition_body_alt1(const AstNode& node);
  void listenEscaped_macro_definition_body_alt2(const AstNode& node);
  void listenEvent_based_flag(const AstNode& node);
  void listenEvent_control(const AstNode& node);
  void listenEvent_expression(const AstNode& node);
  void listenEvent_trigger(const AstNode& node);
  void listenEvent_type(const AstNode& node);
  void listenExpand_vectornets_directive(const AstNode& node);
  void listenExpect_property_statement(const AstNode& node);
  void listenExport(const AstNode& node);
  void listenExpression(const AstNode& node);
  void listenExpression_or_cond_pattern(const AstNode& node);
  void listenExpression_or_dist(const AstNode& node);
  void listenExtends(const AstNode& node);
  void listenExtern_constraint_declaration(const AstNode& node);
  void listenExtern_qualifier(const AstNode& node);
  void listenExtern_tf_declaration(const AstNode& node);
  void listenFile_path_spec(const AstNode& node);
  void listenFinal_construct(const AstNode& node);
  void listenFirstMatch(const AstNode& node);
  void listenFor(const AstNode& node);
  void listenFor_initialization(const AstNode& node);
  void listenFor_step(const AstNode& node);
  void listenFor_step_assignment(const AstNode& node);
  void listenFor_variable_declaration(const AstNode& node);
  void listenForce(const AstNode& node);
  void listenForeach(const AstNode& node);
  void listenForever(const AstNode& node);
  void listenFull_edge_sensitive_path_description(const AstNode& node);
  void listenFull_path_description(const AstNode& node);
  void listenFunction_body_declaration(const AstNode& node);
  void listenFunction_data_type(const AstNode& node);
  void listenFunction_data_type_or_implicit(const AstNode& node);
  void listenFunction_declaration(const AstNode& node);
  void listenFunction_name_decl(const AstNode& node);
  void listenFunction_prototype(const AstNode& node);
  void listenFunction_statement_or_null(const AstNode& node);
  void listenGate_instantiation(const AstNode& node);
  void listenGenerate_block(const AstNode& node);
  void listenGenerate_interface_block(const AstNode& node);
  void listenGenerate_interface_case_statement(const AstNode& node);
  void listenGenerate_interface_conditional_statement(const AstNode& node);
  void listenGenerate_interface_item(const AstNode& node);
  void listenGenerate_interface_loop_statement(const AstNode& node);
  void listenGenerate_interface_named_block(const AstNode& node);
  void listenGenerate_item(const AstNode& node);
  void listenGenerate_module_block(const AstNode& node);
  void listenGenerate_module_case_statement(const AstNode& node);
  void listenGenerate_module_conditional_statement(const AstNode& node);
  void listenGenerate_module_item(const AstNode& node);
  void listenGenerate_module_loop_statement(const AstNode& node);
  void listenGenerate_module_named_block(const AstNode& node);
  void listenGenerate_region(const AstNode& node);
  void listenGenerated_interface_instantiation(const AstNode& node);
  void listenGenerated_module_instantiation(const AstNode& node);
  void listenGenericElementType(const AstNode& node);
  void listenGenvar_assignment(const AstNode& node);
  void listenGenvar_decl_assignment(const AstNode& node);
  void listenGenvar_declaration(const AstNode& node);
  void listenGenvar_initialization(const AstNode& node);
  void listenGenvar_interface_case_item(const AstNode& node);
  void listenGenvar_iteration(const AstNode& node);
  void listenGenvar_module_case_item(const AstNode& node);
  void listenGlobal(const AstNode& node);
  void listenGoto_repetition(const AstNode& node);
  void listenHierarchical_btf_identifier(const AstNode& node);
  void listenHierarchical_identifier(const AstNode& node);
  void listenHierarchical_instance(const AstNode& node);
  void listenHighZ0(const AstNode& node);
  void listenHighZ1(const AstNode& node);
  void listenIF(const AstNode& node);
  void listenIFF(const AstNode& node);
  void listenIMPLIES(const AstNode& node);
  void listenIdentifier(const AstNode& node);
  void listenIdentifier_in_macro_body(const AstNode& node);
  void listenIdentifier_list(const AstNode& node);
  void listenIf_generate_construct(const AstNode& node);
  void listenIfdef_directive(const AstNode& node);
  void listenIfdef_directive_in_macro_body(const AstNode& node);
  void listenIff(const AstNode& node);
  void listenIfndef_directive(const AstNode& node);
  void listenIfndef_directive_in_macro_body(const AstNode& node);
  void listenImmediate_assertion_statement(const AstNode& node);
  void listenImplements(const AstNode& node);
  void listenImplicit_class_handle(const AstNode& node);
  void listenImplicit_data_type(const AstNode& node);
  void listenImport(const AstNode& node);
  void listenIncDec_MinusMinus(const AstNode& node);
  void listenIncDec_PlusPlus(const AstNode& node);
  void listenIncPartSelectOp(const AstNode& node);
  void listenInc_or_dec_expression(const AstNode& node);
  void listenInc_or_dec_operator(const AstNode& node);
  void listenInclude_directive(const AstNode& node);
  void listenInclude_statement(const AstNode& node);
  void listenIndexed_range(const AstNode& node);
  void listenInitVal_1TickB0(const AstNode& node);
  void listenInitVal_1TickB1(const AstNode& node);
  void listenInitVal_1TickBX(const AstNode& node);
  void listenInitVal_1TickBx(const AstNode& node);
  void listenInitVal_1Tickb0(const AstNode& node);
  void listenInitVal_1Tickb1(const AstNode& node);
  void listenInitVal_1TickbX(const AstNode& node);
  void listenInitVal_1Tickbx(const AstNode& node);
  void listenInitVal_Integral(const AstNode& node);
  void listenInitial_construct(const AstNode& node);
  void listenInout_declaration(const AstNode& node);
  void listenInput_declaration(const AstNode& node);
  void listenInsideOp(const AstNode& node);
  void listenInst_clause(const AstNode& node);
  void listenInst_name(const AstNode& node);
  void listenIntConst(const AstNode& node);
  void listenIntVec_TypeBit(const AstNode& node);
  void listenIntVec_TypeLogic(const AstNode& node);
  void listenIntVec_TypeReg(const AstNode& node);
  void listenIntegerAtomType_Byte(const AstNode& node);
  void listenIntegerAtomType_Int(const AstNode& node);
  void listenIntegerAtomType_Integer(const AstNode& node);
  void listenIntegerAtomType_LongInt(const AstNode& node);
  void listenIntegerAtomType_Shortint(const AstNode& node);
  void listenIntegerAtomType_Time(const AstNode& node);
  void listenInteger_atom_type(const AstNode& node);
  void listenInteger_type(const AstNode& node);
  void listenInteger_vector_type(const AstNode& node);
  void listenInterface(const AstNode& node);
  void listenInterface_ansi_header(const AstNode& node);
  void listenInterface_class_declaration(const AstNode& node);
  void listenInterface_class_item(const AstNode& node);
  void listenInterface_class_keyword(const AstNode& node);
  void listenInterface_class_method(const AstNode& node);
  void listenInterface_class_type(const AstNode& node);
  void listenInterface_declaration(const AstNode& node);
  void listenInterface_identifier(const AstNode& node);
  void listenInterface_instantiation(const AstNode& node);
  void listenInterface_item(const AstNode& node);
  void listenInterface_nonansi_header(const AstNode& node);
  void listenInterface_or_generate_item(const AstNode& node);
  void listenInterface_port_declaration(const AstNode& node);
  void listenInterface_port_header(const AstNode& node);
  void listenIntersect(const AstNode& node);
  void listenJoin_any_keyword(const AstNode& node);
  void listenJoin_keyword(const AstNode& node);
  void listenJoin_none_keyword(const AstNode& node);
  void listenJump_statement(const AstNode& node);
  void listenLarge(const AstNode& node);
  void listenLet_declaration(const AstNode& node);
  void listenLet_formal_type(const AstNode& node);
  void listenLet_port_item(const AstNode& node);
  void listenLet_port_list(const AstNode& node);
  void listenLevel_input_list(const AstNode& node);
  void listenLevel_symbol(const AstNode& node);
  void listenLiblist_clause(const AstNode& node);
  void listenLibrary_declaration(const AstNode& node);
  void listenLibrary_descriptions(const AstNode& node);
  void listenLibrary_text(const AstNode& node);
  void listenLifetime_Automatic(const AstNode& node);
  void listenLifetime_Static(const AstNode& node);
  void listenLine_directive(const AstNode& node);
  void listenList_of_arguments(const AstNode& node);
  void listenList_of_checker_port_connections(const AstNode& node);
  void listenList_of_clocking_decl_assign(const AstNode& node);
  void listenList_of_cross_items(const AstNode& node);
  void listenList_of_defparam_assignments(const AstNode& node);
  void listenList_of_interface_identifiers(const AstNode& node);
  void listenList_of_net_assignments(const AstNode& node);
  void listenList_of_net_decl_assignments(const AstNode& node);
  void listenList_of_param_assignments(const AstNode& node);
  void listenList_of_parameter_assignments(const AstNode& node);
  void listenList_of_path_delay_expressions(const AstNode& node);
  void listenList_of_path_inputs(const AstNode& node);
  void listenList_of_path_outputs(const AstNode& node);
  void listenList_of_port_connections(const AstNode& node);
  void listenList_of_port_declarations(const AstNode& node);
  void listenList_of_port_identifiers(const AstNode& node);
  void listenList_of_ports(const AstNode& node);
  void listenList_of_specparam_assignments(const AstNode& node);
  void listenList_of_tf_variable_identifiers(const AstNode& node);
  void listenList_of_type_assignments(const AstNode& node);
  void listenList_of_variable_assignments(const AstNode& node);
  void listenList_of_variable_decl_assignments(const AstNode& node);
  void listenList_of_variable_identifiers(const AstNode& node);
  void listenList_of_variable_port_identifiers(const AstNode& node);
  void listenList_of_virtual_interface_decl(const AstNode& node);
  void listenLocal_parameter_declaration(const AstNode& node);
  void listenLoop_generate_construct(const AstNode& node);
  void listenLoop_statement(const AstNode& node);
  void listenLoop_variables(const AstNode& node);
  void listenMacroInstanceNoArgs(const AstNode& node);
  void listenMacroInstanceWithArgs(const AstNode& node);
  void listenMacro_actual_args(const AstNode& node);
  void listenMacro_arg(const AstNode& node);
  void listenMacro_arguments(const AstNode& node);
  void listenMacro_definition(const AstNode& node);
  void listenMatches(const AstNode& node);
  void listenMedium(const AstNode& node);
  void listenMethodQualifier_ClassItem(const AstNode& node);
  void listenMethodQualifier_Virtual(const AstNode& node);
  void listenMethod_call(const AstNode& node);
  void listenMethod_call_body(const AstNode& node);
  void listenMethod_call_root(const AstNode& node);
  void listenMethod_prototype(const AstNode& node);
  void listenMintypmax_expression(const AstNode& node);
  void listenModport_hierarchical_ports_declaration(const AstNode& node);
  void listenModport_item(const AstNode& node);
  void listenModport_ports_declaration(const AstNode& node);
  void listenModport_simple_port(const AstNode& node);
  void listenModport_simple_ports_declaration(const AstNode& node);
  void listenModport_tf_port(const AstNode& node);
  void listenModport_tf_ports_declaration(const AstNode& node);
  void listenModule(const AstNode& node);
  void listenModuleInstance(const AstNode& node);
  void listenModule_ansi_header(const AstNode& node);
  void listenModule_common_item(const AstNode& node);
  void listenModule_declaration(const AstNode& node);
  void listenModule_instantiation(const AstNode& node);
  void listenModule_item(const AstNode& node);
  void listenModule_keyword(const AstNode& node);
  void listenModule_nonansi_header(const AstNode& node);
  void listenModule_or_generate_item(const AstNode& node);
  void listenModule_or_generate_item_declaration(const AstNode& node);
  void listenModule_path_concatenation(const AstNode& node);
  void listenModule_path_expression(const AstNode& node);
  void listenModule_path_mintypmax_expression(const AstNode& node);
  void listenModule_path_multiple_concatenation(const AstNode& node);
  void listenModule_path_primary(const AstNode& node);
  void listenMosSwitchType_NMos(const AstNode& node);
  void listenMosSwitchType_PMos(const AstNode& node);
  void listenMosSwitchType_RNMos(const AstNode& node);
  void listenMosSwitchType_RPMos(const AstNode& node);
  void listenMos_switch_instance(const AstNode& node);
  void listenMultiline_args_macro_definition(const AstNode& node);
  void listenMultiline_no_args_macro_definition(const AstNode& node);
  void listenMultiple_concatenation(const AstNode& node);
  void listenNInpGate_And(const AstNode& node);
  void listenNInpGate_Nand(const AstNode& node);
  void listenNInpGate_Nor(const AstNode& node);
  void listenNInpGate_Or(const AstNode& node);
  void listenNInpGate_Xnor(const AstNode& node);
  void listenNInpGate_Xor(const AstNode& node);
  void listenNONOVERLAPPED(const AstNode& node);
  void listenNON_OVERLAP_IMPLY(const AstNode& node);
  void listenNOT(const AstNode& node);
  void listenNOutGate_Buf(const AstNode& node);
  void listenNOutGate_Not(const AstNode& node);
  void listenN_input_gate_instance(const AstNode& node);
  void listenN_output_gate_instance(const AstNode& node);
  void listenName_of_instance(const AstNode& node);
  void listenNamed_checker_port_connection(const AstNode& node);
  void listenNamed_parameter_assignment(const AstNode& node);
  void listenNamed_port_connection(const AstNode& node);
  void listenNetType_Supply0(const AstNode& node);
  void listenNetType_Supply1(const AstNode& node);
  void listenNetType_Tri(const AstNode& node);
  void listenNetType_Tri0(const AstNode& node);
  void listenNetType_Tri1(const AstNode& node);
  void listenNetType_TriAnd(const AstNode& node);
  void listenNetType_TriOr(const AstNode& node);
  void listenNetType_TriReg(const AstNode& node);
  void listenNetType_Uwire(const AstNode& node);
  void listenNetType_Wand(const AstNode& node);
  void listenNetType_Wire(const AstNode& node);
  void listenNetType_Wor(const AstNode& node);
  void listenNet_alias(const AstNode& node);
  void listenNet_assignment(const AstNode& node);
  void listenNet_decl_assignment(const AstNode& node);
  void listenNet_declaration(const AstNode& node);
  void listenNet_lvalue(const AstNode& node);
  void listenNet_port_header(const AstNode& node);
  void listenNet_port_type(const AstNode& node);
  void listenNet_type(const AstNode& node);
  void listenNet_type_declaration(const AstNode& node);
  void listenNext_state(const AstNode& node);
  void listenNoType(const AstNode& node);
  void listenNoaccelerate_directive(const AstNode& node);
  void listenNoexpand_vectornets_directive(const AstNode& node);
  void listenNonBlockingTriggerEvent(const AstNode& node);
  void listenNonIntType_Real(const AstNode& node);
  void listenNonIntType_RealTime(const AstNode& node);
  void listenNonIntType_ShortReal(const AstNode& node);
  void listenNon_consecutive_repetition(const AstNode& node);
  void listenNon_integer_type(const AstNode& node);
  void listenNon_port_interface_item(const AstNode& node);
  void listenNon_port_module_item(const AstNode& node);
  void listenNon_port_program_item(const AstNode& node);
  void listenNonblocking_assignment(const AstNode& node);
  void listenNonrange_select(const AstNode& node);
  void listenNonrange_variable_lvalue(const AstNode& node);
  void listenNoremove_gatenames_directive(const AstNode& node);
  void listenNoremove_netnames_directive(const AstNode& node);
  void listenNosuppress_faults_directive(const AstNode& node);
  void listenNotifier(const AstNode& node);
  void listenNounconnected_drive_directive(const AstNode& node);
  void listenNull(const AstNode& node);
  void listenNull_keyword(const AstNode& node);
  void listenNumber(const AstNode& node);
  void listenNumber_1TickB0(const AstNode& node);
  void listenNumber_1TickB1(const AstNode& node);
  void listenNumber_1TickBX(const AstNode& node);
  void listenNumber_1TickBx(const AstNode& node);
  void listenNumber_1Tickb0(const AstNode& node);
  void listenNumber_1Tickb1(const AstNode& node);
  void listenNumber_1TickbX(const AstNode& node);
  void listenNumber_1Tickbx(const AstNode& node);
  void listenNumber_Integral(const AstNode& node);
  void listenNumber_Real(const AstNode& node);
  void listenNumber_Tick0(const AstNode& node);
  void listenNumber_Tick1(const AstNode& node);
  void listenNumber_TickB0(const AstNode& node);
  void listenNumber_TickB1(const AstNode& node);
  void listenNumber_Tickb0(const AstNode& node);
  void listenNumber_Tickb1(const AstNode& node);
  void listenOR(const AstNode& node);
  void listenOVERLAPPED(const AstNode& node);
  void listenOVERLAP_IMPLY(const AstNode& node);
  void listenOpenParens(const AstNode& node);
  void listenOpen_range_list(const AstNode& node);
  void listenOperator_assignment(const AstNode& node);
  void listenOr_call(const AstNode& node);
  void listenOr_operator(const AstNode& node);
  void listenOrdered_checker_port_connection(const AstNode& node);
  void listenOrdered_parameter_assignment(const AstNode& node);
  void listenOrdered_port_connection(const AstNode& node);
  void listenOutput_declaration(const AstNode& node);
  void listenOutput_symbol(const AstNode& node);
  void listenOverloadOp_Div(const AstNode& node);
  void listenOverloadOp_Equal(const AstNode& node);
  void listenOverloadOp_Equiv(const AstNode& node);
  void listenOverloadOp_Greater(const AstNode& node);
  void listenOverloadOp_GreaterEqual(const AstNode& node);
  void listenOverloadOp_Less(const AstNode& node);
  void listenOverloadOp_LessEqual(const AstNode& node);
  void listenOverloadOp_Minus(const AstNode& node);
  void listenOverloadOp_MinusMinus(const AstNode& node);
  void listenOverloadOp_Mult(const AstNode& node);
  void listenOverloadOp_NotEqual(const AstNode& node);
  void listenOverloadOp_Percent(const AstNode& node);
  void listenOverloadOp_Plus(const AstNode& node);
  void listenOverloadOp_PlusPlus(const AstNode& node);
  void listenOverloadOp_StarStar(const AstNode& node);
  void listenOverload_declaration(const AstNode& node);
  void listenOverload_proto_formals(const AstNode& node);
  void listenPackage(const AstNode& node);
  void listenPackage_declaration(const AstNode& node);
  void listenPackage_export_declaration(const AstNode& node);
  void listenPackage_import_declaration(const AstNode& node);
  void listenPackage_import_item(const AstNode& node);
  void listenPackage_item(const AstNode& node);
  void listenPackage_or_generate_item_declaration(const AstNode& node);
  void listenPackage_scope(const AstNode& node);
  void listenPacked_dimension(const AstNode& node);
  void listenPacked_keyword(const AstNode& node);
  void listenPaired_parens(const AstNode& node);
  void listenPar_block(const AstNode& node);
  void listenParallel_edge_sensitive_path_description(const AstNode& node);
  void listenParallel_path_description(const AstNode& node);
  void listenParam_assignment(const AstNode& node);
  void listenParam_expression(const AstNode& node);
  void listenParameter_declaration(const AstNode& node);
  void listenParameter_override(const AstNode& node);
  void listenParameter_port_declaration(const AstNode& node);
  void listenParameter_port_list(const AstNode& node);
  void listenParameter_value_assignment(const AstNode& node);
  void listenPart_select_op(const AstNode& node);
  void listenPart_select_op_column(const AstNode& node);
  void listenPart_select_range(const AstNode& node);
  void listenPassEnSwitch_RTranif0(const AstNode& node);
  void listenPassEnSwitch_RTranif1(const AstNode& node);
  void listenPassEnSwitch_Tranif0(const AstNode& node);
  void listenPassEnSwitch_Tranif1(const AstNode& node);
  void listenPassSwitch_RTran(const AstNode& node);
  void listenPassSwitch_Tran(const AstNode& node);
  void listenPass_enable_switch_instance(const AstNode& node);
  void listenPass_switch_instance(const AstNode& node);
  void listenPath_declaration(const AstNode& node);
  void listenPath_delay_expression(const AstNode& node);
  void listenPath_delay_value(const AstNode& node);
  void listenPattern(const AstNode& node);
  void listenPort(const AstNode& node);
  void listenPortDir_Inout(const AstNode& node);
  void listenPortDir_Inp(const AstNode& node);
  void listenPortDir_Out(const AstNode& node);
  void listenPortDir_Ref(const AstNode& node);
  void listenPortInst(const AstNode& node);
  void listenPort_declaration(const AstNode& node);
  void listenPort_direction(const AstNode& node);
  void listenPort_expression(const AstNode& node);
  void listenPort_reference(const AstNode& node);
  void listenPound_Pound_delay(const AstNode& node);
  void listenPound_delay(const AstNode& node);
  void listenPound_delay_value(const AstNode& node);
  void listenPound_pound_delay(const AstNode& node);
  void listenPragma_directive(const AstNode& node);
  void listenPragma_expression(const AstNode& node);
  void listenPragma_value(const AstNode& node);
  void listenPrimary(const AstNode& node);
  void listenPrimary_literal(const AstNode& node);
  void listenPrimitive(const AstNode& node);
  void listenPrimitiveInstance(const AstNode& node);
  void listenPriority(const AstNode& node);
  void listenProcedural_assertion_statement(const AstNode& node);
  void listenProcedural_continuous_assignment(const AstNode& node);
  void listenProcedural_timing_control(const AstNode& node);
  void listenProcedural_timing_control_statement(const AstNode& node);
  void listenProduction(const AstNode& node);
  void listenProduction_item(const AstNode& node);
  void listenProgram(const AstNode& node);
  void listenProgram_ansi_header(const AstNode& node);
  void listenProgram_declaration(const AstNode& node);
  void listenProgram_generate_item(const AstNode& node);
  void listenProgram_instantiation(const AstNode& node);
  void listenProgram_item(const AstNode& node);
  void listenProgram_nonansi_header(const AstNode& node);
  void listenPropQualifier_ClassItem(const AstNode& node);
  void listenPropQualifier_Rand(const AstNode& node);
  void listenPropQualifier_Randc(const AstNode& node);
  void listenProperty_actual_arg(const AstNode& node);
  void listenProperty_case_item(const AstNode& node);
  void listenProperty_declaration(const AstNode& node);
  void listenProperty_expr(const AstNode& node);
  void listenProperty_formal_type(const AstNode& node);
  void listenProperty_instance(const AstNode& node);
  void listenProperty_lvar_port_direction(const AstNode& node);
  void listenProperty_port_item(const AstNode& node);
  void listenProperty_port_list(const AstNode& node);
  void listenProperty_spec(const AstNode& node);
  void listenProtect_directive(const AstNode& node);
  void listenProtected_directive(const AstNode& node);
  void listenPs_identifier(const AstNode& node);
  void listenPs_or_hierarchical_array_identifier(const AstNode& node);
  void listenPs_or_hierarchical_identifier(const AstNode& node);
  void listenPs_or_hierarchical_sequence_identifier(const AstNode& node);
  void listenPs_type_identifier(const AstNode& node);
  void listenPull0(const AstNode& node);
  void listenPull1(const AstNode& node);
  void listenPull_gate_instance(const AstNode& node);
  void listenPulldown(const AstNode& node);
  void listenPulldown_strength(const AstNode& node);
  void listenPullup(const AstNode& node);
  void listenPullup_strength(const AstNode& node);
  void listenPulse_control_specparam(const AstNode& node);
  void listenPulsestyle_declaration(const AstNode& node);
  void listenPure(const AstNode& node);
  void listenPure_keyword(const AstNode& node);
  void listenPure_virtual_qualifier(const AstNode& node);
  void listenQmark(const AstNode& node);
  void listenQueue_dimension(const AstNode& node);
  void listenREJECT_ON(const AstNode& node);
  void listenRandcase_item(const AstNode& node);
  void listenRandcase_statement(const AstNode& node);
  void listenRandomQualifier_Rand(const AstNode& node);
  void listenRandomQualifier_RandC(const AstNode& node);
  void listenRandomize_call(const AstNode& node);
  void listenRandsequence_statement(const AstNode& node);
  void listenRange_expression(const AstNode& node);
  void listenRange_list(const AstNode& node);
  void listenRealConst(const AstNode& node);
  void listenRef_declaration(const AstNode& node);
  void listenReference_event(const AstNode& node);
  void listenRelease(const AstNode& node);
  void listenRemain_active_flag(const AstNode& node);
  void listenRemove_gatename_directive(const AstNode& node);
  void listenRemove_netname_directive(const AstNode& node);
  void listenRepeat(const AstNode& node);
  void listenRepeat_range(const AstNode& node);
  void listenResetall_directive(const AstNode& node);
  void listenRestrict_property_statement(const AstNode& node);
  void listenReturnStmt(const AstNode& node);
  void listenRs_case(const AstNode& node);
  void listenRs_case_item(const AstNode& node);
  void listenRs_code_block(const AstNode& node);
  void listenRs_if_else(const AstNode& node);
  void listenRs_prod(const AstNode& node);
  void listenRs_production_list(const AstNode& node);
  void listenRs_repeat(const AstNode& node);
  void listenRs_rule(const AstNode& node);
  void listenSTRONG(const AstNode& node);
  void listenSYNC_ACCEPT_ON(const AstNode& node);
  void listenSYNC_REJECT_ON(const AstNode& node);
  void listenS_ALWAYS(const AstNode& node);
  void listenS_EVENTUALLY(const AstNode& node);
  void listenS_NEXTTIME(const AstNode& node);
  void listenS_UNTIL(const AstNode& node);
  void listenS_UNTIL_WITH(const AstNode& node);
  void listenScalar_1TickB0(const AstNode& node);
  void listenScalar_1TickB1(const AstNode& node);
  void listenScalar_1Tickb0(const AstNode& node);
  void listenScalar_1Tickb1(const AstNode& node);
  void listenScalar_Integral(const AstNode& node);
  void listenScalar_TickB0(const AstNode& node);
  void listenScalar_TickB1(const AstNode& node);
  void listenScalar_Tickb0(const AstNode& node);
  void listenScalar_Tickb1(const AstNode& node);
  void listenScalar_timing_check_condition(const AstNode& node);
  void listenSelect(const AstNode& node);
  void listenSelect_condition(const AstNode& node);
  void listenSelect_expression(const AstNode& node);
  void listenSeqFormatType_Data(const AstNode& node);
  void listenSeqFormatType_Sequence(const AstNode& node);
  void listenSeqFormatType_Untyped(const AstNode& node);
  void listenSeqLvarPortDir_Inout(const AstNode& node);
  void listenSeqLvarPortDir_Input(const AstNode& node);
  void listenSeqLvarPortDir_Output(const AstNode& node);
  void listenSeq_block(const AstNode& node);
  void listenSeq_input_list(const AstNode& node);
  void listenSequence_actual_arg(const AstNode& node);
  void listenSequence_arg(const AstNode& node);
  void listenSequence_declaration(const AstNode& node);
  void listenSequence_expr(const AstNode& node);
  void listenSequence_instance(const AstNode& node);
  void listenSequence_list_of_arguments(const AstNode& node);
  void listenSequence_match_item(const AstNode& node);
  void listenSequence_method_call(const AstNode& node);
  void listenSequence_port_item(const AstNode& node);
  void listenSequence_port_list(const AstNode& node);
  void listenSequential_body(const AstNode& node);
  void listenSequential_entry(const AstNode& node);
  void listenShowcancelled_declaration(const AstNode& node);
  void listenSigned_directive(const AstNode& node);
  void listenSigning(const AstNode& node);
  void listenSigning_Signed(const AstNode& node);
  void listenSigning_Unsigned(const AstNode& node);
  void listenSimple_args_macro_definition(const AstNode& node);
  void listenSimple_args_macro_definition_in_macro_body(const AstNode& node);
  void listenSimple_immediate_assert_statement(const AstNode& node);
  void listenSimple_immediate_assertion_statement(const AstNode& node);
  void listenSimple_immediate_assume_statement(const AstNode& node);
  void listenSimple_immediate_cover_statement(const AstNode& node);
  void listenSimple_macro_definition_body(const AstNode& node);
  void listenSimple_macro_definition_body_in_macro_body(const AstNode& node);
  void listenSimple_no_args_macro_definition(const AstNode& node);
  void listenSimple_no_args_macro_definition_in_macro_body(const AstNode& node);
  void listenSimple_path_declaration(const AstNode& node);
  void listenSimple_type(const AstNode& node);
  void listenSlice_size(const AstNode& node);
  void listenSlline(const AstNode& node);
  void listenSmall(const AstNode& node);
  void listenSolve_before_list(const AstNode& node);
  void listenSource_text(const AstNode& node);
  void listenSpaces(const AstNode& node);
  void listenSpecify_block(const AstNode& node);
  void listenSpecify_input_terminal_descriptor(const AstNode& node);
  void listenSpecify_item(const AstNode& node);
  void listenSpecify_output_terminal_descriptor(const AstNode& node);
  void listenSpecify_terminal_descriptor(const AstNode& node);
  void listenSpecparam_assignment(const AstNode& node);
  void listenSpecparam_declaration(const AstNode& node);
  void listenStamptime_condition(const AstNode& node);
  void listenStart_edge_offset(const AstNode& node);
  void listenState_dependent_path_declaration(const AstNode& node);
  void listenStatement(const AstNode& node);
  void listenStatement_item(const AstNode& node);
  void listenStatement_or_null(const AstNode& node);
  void listenStream_concatenation(const AstNode& node);
  void listenStream_expression(const AstNode& node);
  void listenStream_operator(const AstNode& node);
  void listenStreaming_concatenation(const AstNode& node);
  void listenStrength0(const AstNode& node);
  void listenStrength1(const AstNode& node);
  void listenString(const AstNode& node);
  void listenStringConst(const AstNode& node);
  void listenStringLiteral(const AstNode& node);
  void listenString_blob(const AstNode& node);
  void listenString_type(const AstNode& node);
  void listenString_value(const AstNode& node);
  void listenStrong0(const AstNode& node);
  void listenStrong1(const AstNode& node);
  void listenStruct_keyword(const AstNode& node);
  void listenStruct_union(const AstNode& node);
  void listenStruct_union_member(const AstNode& node);
  void listenStructure_pattern_key(const AstNode& node);
  void listenSubroutine_call(const AstNode& node);
  void listenSubroutine_call_statement(const AstNode& node);
  void listenSuper_dot_new(const AstNode& node);
  void listenSuper_keyword(const AstNode& node);
  void listenSupply0(const AstNode& node);
  void listenSupply1(const AstNode& node);
  void listenSuppress_faults_directive(const AstNode& node);
  void listenSurelog_macro_not_defined(const AstNode& node);
  void listenSv_file_directive(const AstNode& node);
  void listenSv_interface(const AstNode& node);
  void listenSv_line_directive(const AstNode& node);
  void listenSv_package(const AstNode& node);
  void listenSystem_task(const AstNode& node);
  void listenSystem_task_names(const AstNode& node);
  void listenSystem_timing_check(const AstNode& node);
  void listenT01_path_delay_expression(const AstNode& node);
  void listenT0x_path_delay_expression(const AstNode& node);
  void listenT0z_path_delay_expression(const AstNode& node);
  void listenT10_path_delay_expression(const AstNode& node);
  void listenT1x_path_delay_expression(const AstNode& node);
  void listenT1z_path_delay_expression(const AstNode& node);
  void listenT_path_delay_expression(const AstNode& node);
  void listenTagged(const AstNode& node);
  void listenTagged_keyword(const AstNode& node);
  void listenTask_body_declaration(const AstNode& node);
  void listenTask_declaration(const AstNode& node);
  void listenTask_name_decl(const AstNode& node);
  void listenTask_prototype(const AstNode& node);
  void listenText_blob(const AstNode& node);
  void listenTfPortDir_ConstRef(const AstNode& node);
  void listenTfPortDir_Inout(const AstNode& node);
  void listenTfPortDir_Inp(const AstNode& node);
  void listenTfPortDir_Out(const AstNode& node);
  void listenTfPortDir_Ref(const AstNode& node);
  void listenTf_item_declaration(const AstNode& node);
  void listenTf_port_declaration(const AstNode& node);
  void listenTf_port_direction(const AstNode& node);
  void listenTf_port_item(const AstNode& node);
  void listenTf_port_list(const AstNode& node);
  void listenTfall_path_delay_expression(const AstNode& node);
  void listenThis(const AstNode& node);
  void listenThis_dot_super(const AstNode& node);
  void listenThis_keyword(const AstNode& node);
  void listenThreshold(const AstNode& node);
  void listenThroughout(const AstNode& node);
  void listenTimeUnitsDecl_TimePrecision(const AstNode& node);
  void listenTimeUnitsDecl_TimePrecisionTimeUnit(const AstNode& node);
  void listenTimeUnitsDecl_TimeUnit(const AstNode& node);
  void listenTimeUnitsDecl_TimeUnitDiv(const AstNode& node);
  void listenTimeUnitsDecl_TimeUnitTimePrecision(const AstNode& node);
  void listenTime_literal(const AstNode& node);
  void listenTime_unit(const AstNode& node);
  void listenTimescale_directive(const AstNode& node);
  void listenTimingCheckEventControl_Edge(const AstNode& node);
  void listenTimingCheckEventControl_Negedge(const AstNode& node);
  void listenTimingCheckEventControl_Posedge(const AstNode& node);
  void listenTiming_check_condition(const AstNode& node);
  void listenTiming_check_event(const AstNode& node);
  void listenTiming_check_limit(const AstNode& node);
  void listenTop_directives(const AstNode& node);
  void listenTop_level_library_rule(const AstNode& node);
  void listenTop_level_rule(const AstNode& node);
  void listenTrans_list(const AstNode& node);
  void listenTrans_range_list(const AstNode& node);
  void listenTrans_set(const AstNode& node);
  void listenTrise_path_delay_expression(const AstNode& node);
  void listenTx0_path_delay_expression(const AstNode& node);
  void listenTx1_path_delay_expression(const AstNode& node);
  void listenTxz_path_delay_expression(const AstNode& node);
  void listenType(const AstNode& node);
  void listenType_declaration(const AstNode& node);
  void listenType_reference(const AstNode& node);
  void listenTz0_path_delay_expression(const AstNode& node);
  void listenTz1_path_delay_expression(const AstNode& node);
  void listenTz_path_delay_expression(const AstNode& node);
  void listenTzx_path_delay_expression(const AstNode& node);
  void listenUNTIL(const AstNode& node);
  void listenUNTIL_WITH(const AstNode& node);
  void listenUdp_ansi_declaration(const AstNode& node);
  void listenUdp_body(const AstNode& node);
  void listenUdp_declaration(const AstNode& node);
  void listenUdp_declaration_port_list(const AstNode& node);
  void listenUdp_initial_statement(const AstNode& node);
  void listenUdp_input_declaration(const AstNode& node);
  void listenUdp_instance(const AstNode& node);
  void listenUdp_instantiation(const AstNode& node);
  void listenUdp_nonansi_declaration(const AstNode& node);
  void listenUdp_output_declaration(const AstNode& node);
  void listenUdp_port_declaration(const AstNode& node);
  void listenUdp_port_list(const AstNode& node);
  void listenUdp_reg_declaration(const AstNode& node);
  void listenUnaryModOp_BitwAnd(const AstNode& node);
  void listenUnaryModOp_BitwOr(const AstNode& node);
  void listenUnaryModOp_BitwXor(const AstNode& node);
  void listenUnaryModOp_Not(const AstNode& node);
  void listenUnaryModOp_ReductNand(const AstNode& node);
  void listenUnaryModOp_ReductNor(const AstNode& node);
  void listenUnaryModOp_ReductXNor1(const AstNode& node);
  void listenUnaryModOp_ReductXnor2(const AstNode& node);
  void listenUnaryModOp_Tilda(const AstNode& node);
  void listenUnary_BitwAnd(const AstNode& node);
  void listenUnary_BitwOr(const AstNode& node);
  void listenUnary_BitwXor(const AstNode& node);
  void listenUnary_Minus(const AstNode& node);
  void listenUnary_Not(const AstNode& node);
  void listenUnary_Plus(const AstNode& node);
  void listenUnary_ReductNand(const AstNode& node);
  void listenUnary_ReductNor(const AstNode& node);
  void listenUnary_ReductXnor1(const AstNode& node);
  void listenUnary_ReductXnor2(const AstNode& node);
  void listenUnary_Tilda(const AstNode& node);
  void listenUnbased_unsized_literal(const AstNode& node);
  void listenUnconnected_drive_directive(const AstNode& node);
  void listenUndef_directive(const AstNode& node);
  void listenUndefineall_directive(const AstNode& node);
  void listenUnion_keyword(const AstNode& node);
  void listenUnique(const AstNode& node);
  void listenUnique0(const AstNode& node);
  void listenUnique_call(const AstNode& node);
  void listenUnique_priority(const AstNode& node);
  void listenUniqueness_constraint(const AstNode& node);
  void listenUnpacked_dimension(const AstNode& node);
  void listenUnsigned_directive(const AstNode& node);
  void listenUnsized_dimension(const AstNode& node);
  void listenUnterminated_string(const AstNode& node);
  void listenUse_clause(const AstNode& node);
  void listenUse_clause_config(const AstNode& node);
  void listenUselib_directive(const AstNode& node);
  void listenValue_range(const AstNode& node);
  void listenVar_data_type(const AstNode& node);
  void listenVar_type(const AstNode& node);
  void listenVariable_assignment(const AstNode& node);
  void listenVariable_decl_assignment(const AstNode& node);
  void listenVariable_declaration(const AstNode& node);
  void listenVariable_dimension(const AstNode& node);
  void listenVariable_impl_declaration(const AstNode& node);
  void listenVariable_lvalue(const AstNode& node);
  void listenVariable_port_header(const AstNode& node);
  void listenVariable_port_type(const AstNode& node);
  void listenVirtual(const AstNode& node);
  void listenVirtual_interface_declaration(const AstNode& node);
  void listenWEAK(const AstNode& node);
  void listenWait_statement(const AstNode& node);
  void listenWeak0(const AstNode& node);
  void listenWeak1(const AstNode& node);
  void listenWhile(const AstNode& node);
  void listenWith(const AstNode& node);
  void listenWithin(const AstNode& node);
  void listenX(const AstNode& node);
  void listenXor_call(const AstNode& node);
  void listenZ(const AstNode& node);
  // clang-format on

 protected:
  astnode_set_t m_visited;
  astnode_stack_t m_callstack;

 private:
  const VObject* m_objects = nullptr;
  uint32_t m_count = 0;
  const SymbolTable* m_symbolTable = nullptr;
};
}  // namespace SURELOG

#endif  // SURELOG_ASTLISTENER_H
