/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   variables.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_VARIABLES_H
#define UHDM_VARIABLES_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/simple_expr.h>

#include "variable_drivers_group.h"
#include "variable_loads_group.h"


namespace UHDM {
class expr;
class instance;
class module;
class path_term;
class scope;
class tchk_term;

class variables : public simple_expr {
  UHDM_IMPLEMENT_RTTI(variables, simple_expr)
public:
  // Implicit constructor used to initialize all members,
  // comment: variables();
  virtual ~variables() = default;

  bool VpiArrayMember() const { return vpiArrayMember_; }

  bool VpiArrayMember(bool data) { vpiArrayMember_ = data; return true; }

  virtual bool VpiName(const std::string& data) final;

  virtual const std::string& VpiName() const final;

  bool VpiFullName(const std::string& data);

  const std::string& VpiFullName() const;

  bool VpiSigned() const { return vpiSigned_; }

  bool VpiSigned(bool data) { vpiSigned_ = data; return true; }

  bool VpiAutomatic() const { return vpiAutomatic_; }

  bool VpiAutomatic(bool data) { vpiAutomatic_ = data; return true; }

  int VpiAllocScheme() const { return vpiAllocScheme_; }

  bool VpiAllocScheme(int data) { vpiAllocScheme_ = data; return true; }

  bool VpiConstantVariable() const { return vpiConstantVariable_; }

  bool VpiConstantVariable(bool data) { vpiConstantVariable_ = data; return true; }

  bool VpiIsRandomized() const { return vpiIsRandomized_; }

  bool VpiIsRandomized(bool data) { vpiIsRandomized_ = data; return true; }

  int VpiRandType() const { return vpiRandType_; }

  bool VpiRandType(int data) { vpiRandType_ = data; return true; }

  bool VpiStructUnionMember() const { return vpiStructUnionMember_; }

  bool VpiStructUnionMember(bool data) { vpiStructUnionMember_ = data; return true; }

  bool VpiScalar() const { return vpiScalar_; }

  bool VpiScalar(bool data) { vpiScalar_ = data; return true; }

  int VpiVisibility() const { return vpiVisibility_; }

  bool VpiVisibility(int data) { vpiVisibility_ = data; return true; }

  bool VpiVector() const { return vpiVector_; }

  bool VpiVector(bool data) { vpiVector_ = data; return true; }

  VectorOfports* Ports() const { return ports_; }

  bool Ports(VectorOfports* data) { ports_ = data; return true; }

  VectorOfany* Variable_drivers() const { return variable_drivers_; }

  bool Variable_drivers(VectorOfany* data) { if (!variable_drivers_groupGroupCompliant(data)) return false; variable_drivers_ = data; return true; }

  VectorOfany* Variable_loads() const { return variable_loads_; }

  bool Variable_loads(VectorOfany* data) { if (!variable_loads_groupGroupCompliant(data)) return false; variable_loads_ = data; return true; }

  VectorOfprim_term* Prim_terms() const { return prim_terms_; }

  bool Prim_terms(VectorOfprim_term* data) { prim_terms_ = data; return true; }

  VectorOfcont_assign* Cont_assigns() const { return cont_assigns_; }

  bool Cont_assigns(VectorOfcont_assign* data) { cont_assigns_ = data; return true; }

  const path_term* Path_term() const { return path_term_; }

  bool Path_term(path_term* data) { path_term_ = data; return true; }

  const tchk_term* Tchk_term() const { return tchk_term_; }

  bool Tchk_term(tchk_term* data) { tchk_term_ = data; return true; }

  const module* Module() const { return module_; }

  bool Module(module* data) { module_ = data; return true; }

  const instance* Instance() const { return instance_; }

  bool Instance(instance* data) { instance_ = data; return true; }

  const scope* Scope() const { return scope_; }

  bool Scope(scope* data) { scope_ = data; return true; }

  const expr* Expr() const { return expr_; }

  bool Expr(expr* data) { expr_ = data; return true; }

  VectorOfexpr* Indexes() const { return indexes_; }

  bool Indexes(VectorOfexpr* data) { indexes_ = data; return true; }

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true; }

  virtual variables* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override = 0;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const override { return uhdmvariables; }

protected:
  void DeepCopy(variables* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  bool vpiArrayMember_ = false;

  SymbolFactory::ID vpiName_ = 0;

  SymbolFactory::ID vpiFullName_ = 0;

  bool vpiSigned_ = false;

  bool vpiAutomatic_ = false;

  int vpiAllocScheme_ = 0;

  bool vpiConstantVariable_ = false;

  bool vpiIsRandomized_ = false;

  int vpiRandType_ = 0;

  bool vpiStructUnionMember_ = false;

  bool vpiScalar_ = false;

  int vpiVisibility_ = 0;

  bool vpiVector_ = false;

  VectorOfports* ports_ = nullptr;

  VectorOfany* variable_drivers_ = nullptr;

  VectorOfany* variable_loads_ = nullptr;

  VectorOfprim_term* prim_terms_ = nullptr;

  VectorOfcont_assign* cont_assigns_ = nullptr;

  path_term* path_term_ = nullptr;

  tchk_term* tchk_term_ = nullptr;

  module* module_ = nullptr;

  instance* instance_ = nullptr;

  scope* scope_ = nullptr;

  expr* expr_ = nullptr;

  VectorOfexpr* indexes_ = nullptr;

  VectorOfattribute* attributes_ = nullptr;
};

#if 0 // This class cannot be instantiated
typedef FactoryT<variables> variablesFactory;
#endif

typedef FactoryT<std::vector<variables *>> VectorOfvariablesFactory;

}  // namespace UHDM

#endif
