/*
 Do not modify, auto-generated by script

 Copyright 2019-2020 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   vpi_visitor.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_VPI_VISITOR_H
#define UHDM_VPI_VISITOR_H

#include <uhdm/BaseClass.h>
#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_forward_decl.h>

#include <ostream>
#include <set>
#include <string>
#include <vector>

namespace UHDM {
#ifndef SWIG
class VpiVisitor;

// Visit an object, dump to given stream.
void visit_object(vpiHandle obj_h, VpiVisitor* visitor);
void visit_object(vpiHandle obj_h, std::ostream& out,
                  bool shallowVisit = false);

// Visit designs, dump to given stream.
void visit_designs(const std::vector<vpiHandle>& designs, VpiVisitor* visitor);
#endif
void visit_designs(const std::vector<vpiHandle>& designs, std::ostream& out);

#ifndef SWIG
// For debug use in GDB
std::string decompile(const UHDM::any* handle);
std::string decompileVPI(vpiHandle handle);

class VpiVisitor final {
 private:
  std::ostream& stream_indent(int32_t indent) const;

  void visit_baseclass(vpiHandle obj_h, int32_t indent, const char* relation, bool shallowVisit);
  void visit_attribute(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_virtual_interface_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_let_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_concurrent_assertions(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_process_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_always(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_final_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_initial(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_atomic_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_delay_control(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_delay_term(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_event_control(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_repeat_control(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_scope(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_begin(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_named_begin(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_named_fork(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_fork_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_for_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_if_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_event_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_thread_obj(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_forever_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_waits(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_wait_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_wait_fork(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_ordered_wait(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_disables(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_disable(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_disable_fork(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_continue_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_break_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_return_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_while_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_repeat(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_do_while(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_if_else(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_case_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_force(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_assign_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_deassign(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_release(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_null_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_expect_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_foreach_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_scope(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_scope_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_assert_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_cover(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_assume(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_restrict(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_immediate_assert(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_immediate_assume(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_immediate_cover(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_case_item(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_assignment(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_any_pattern(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_tagged_pattern(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_struct_pattern(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_unsupported_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_unsupported_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_include_file_info(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_sequence_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_seq_formal_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_sequence_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_prop_formal_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_property_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_property_spec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_property_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_clocked_property(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_case_property_item(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_case_property(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_multiclock_sequence_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_clocked_seq(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_simple_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_constant(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_let_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_operation(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_ref_obj(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_ref_module(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_ref_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_part_select(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_indexed_part_select(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_var_select(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_bit_select(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_variables(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_hier_path(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_ref_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_short_real_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_real_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_byte_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_short_int_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_int_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_long_int_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_integer_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_time_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_array_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_array_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_reg_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_reg(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_packed_array_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_bit_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_logic_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_struct_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_union_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_enum_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_string_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_chandle_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_var_bit(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_task_func(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_task(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_function(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_modport(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_interface_tf_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_cont_assign(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_cont_assign_bit(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_ports(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_port(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_port_bit(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_checker_port(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_checker_inst_port(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_primitive(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gate(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_switch_tran(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_udp(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_mod_path(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_tchk(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_range(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_udp_defn(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_table_entry(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_io_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_alias_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_clocking_block(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_clocking_io_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_param_assign(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_instance_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_interface_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_program_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_module_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_primitive_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gate_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_switch_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_udp_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_prim_term(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_path_term(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_tchk_term(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_nets(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_net_bit(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_struct_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_enum_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_integer_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_time_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_logic_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_array_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_packed_array_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_event_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_named_event(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_named_event_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_parameter(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_def_param(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_spec_param(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_class_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_extends(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_class_defn(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_class_obj(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_class_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_instance(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_interface_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_program(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_package(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_module_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_checker_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_checker_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_short_real_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_real_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_byte_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_short_int_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_int_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_long_int_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_integer_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_time_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_enum_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_string_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_chandle_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_module_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_struct_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_union_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_logic_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_packed_array_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_array_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_void_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_unsupported_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_sequence_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_property_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_interface_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_type_parameter(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_typespec_member(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_enum_const(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_bit_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_tf_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_user_systf(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_sys_func_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_sys_task_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_method_func_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_method_task_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_func_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_task_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_constraint_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_constraint_ordering(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_constraint(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_import_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_dist_item(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_distribution(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_implication(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_constr_if(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_constr_if_else(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_constr_foreach(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_soft_disable(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_if(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_if_else(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_for(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_case(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_gen_region(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);
  void visit_design(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit);

 public:
  void visit_object(vpiHandle obj_h, int32_t indent,
                    const char* relation, bool shallowVisit);
  void visit_weakly_referenced();

  bool getVisitWeaklyReferenced() const { return m_visitWeaklyReferenced; }
  void setVisitWeaklyReferenced(bool enable) {
    m_visitWeaklyReferenced = enable;
  }

  const VisitedContainer& getVisited() const { return m_visited; }
  const AnySet& getWeaklyReferenced() const { return m_weaklyReferenced2; }

  explicit VpiVisitor(std::ostream& out) : m_out(out) {}
 private:
  std::ostream& m_out;
  AnySet m_weaklyReferenced1;
  AnySet m_weaklyReferenced2;
  VisitedContainer m_visited;
  bool m_visitWeaklyReferenced = true;
};
#endif

}  // namespace UHDM

#endif  // UHDM_VPI_VISITOR_H
