/*
 Do not modify, auto-generated by classes.py

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   property_spec.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_PROPERTY_SPEC_H
#define UHDM_PROPERTY_SPEC_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "expr_dist.h"
#include "property_expr_group.h"


namespace UHDM {
class expr;

class property_spec final : public BaseClass {
  UHDM_IMPLEMENT_RTTI(property_spec, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: property_spec();
  virtual ~property_spec() final = default;

  any* VpiDisableCondition()  { return vpiDisableCondition_; }
  const any* VpiDisableCondition() const { return vpiDisableCondition_; }
  template <typename T>
  T* VpiDisableCondition() {
    return (vpiDisableCondition_ == nullptr) ? nullptr : any_cast<T*>(vpiDisableCondition_);
  }
  template <typename T>
  const T* VpiDisableCondition() const {
    return (vpiDisableCondition_ == nullptr) ? nullptr : any_cast<const T*>(vpiDisableCondition_);
  }
  bool VpiDisableCondition(any* data) {
    if (!expr_distGroupCompliant(data)) return false;
    vpiDisableCondition_ = data;
    return true;
  }

  expr* VpiClockingEvent()  { return vpiClockingEvent_; }
  const expr* VpiClockingEvent() const { return vpiClockingEvent_; }
  template <typename T>
  T* VpiClockingEvent() {
    return (vpiClockingEvent_ == nullptr) ? nullptr : any_cast<T*>(vpiClockingEvent_);
  }
  template <typename T>
  const T* VpiClockingEvent() const {
    return (vpiClockingEvent_ == nullptr) ? nullptr : any_cast<const T*>(vpiClockingEvent_);
  }
  bool VpiClockingEvent(expr* data) {
    vpiClockingEvent_ = data;
    return true;
  }

  any* VpiPropertyExpr()  { return vpiPropertyExpr_; }
  const any* VpiPropertyExpr() const { return vpiPropertyExpr_; }
  template <typename T>
  T* VpiPropertyExpr() {
    return (vpiPropertyExpr_ == nullptr) ? nullptr : any_cast<T*>(vpiPropertyExpr_);
  }
  template <typename T>
  const T* VpiPropertyExpr() const {
    return (vpiPropertyExpr_ == nullptr) ? nullptr : any_cast<const T*>(vpiPropertyExpr_);
  }
  bool VpiPropertyExpr(any* data) {
    if (!property_expr_groupGroupCompliant(data)) return false;
    vpiPropertyExpr_ = data;
    return true;
  }

  virtual uint32_t VpiType() const final { return vpiPropertySpec; }

  virtual property_spec* DeepClone(BaseClass* parent, CloneContext* context) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int32_t type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int32_t property) const override;

  virtual int32_t Compare(const BaseClass* other, CompareContext* context) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return UHDM_OBJECT_TYPE::uhdmproperty_spec; }

protected:
  void DeepCopy(property_spec* clone, BaseClass* parent, CloneContext* context) const;

private:
  any* vpiDisableCondition_ = nullptr;

  expr* vpiClockingEvent_ = nullptr;

  any* vpiPropertyExpr_ = nullptr;
};


typedef FactoryT<property_spec> property_specFactory;


typedef FactoryT<std::vector<property_spec *>> VectorOfproperty_specFactory;

}  // namespace UHDM

#endif
