/*
 Do not modify, auto-generated by classes.py

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   array_typespec.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_ARRAY_TYPESPEC_H
#define UHDM_ARRAY_TYPESPEC_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/typespec.h>




namespace UHDM {
class expr;
class function;
class ref_typespec;

class array_typespec final : public typespec {
  UHDM_IMPLEMENT_RTTI(array_typespec, typespec)
public:
  // Implicit constructor used to initialize all members,
  // comment: array_typespec();
  virtual ~array_typespec() final = default;

  int32_t VpiArrayType() const { return vpiArrayType_; }
  bool VpiArrayType(int32_t data) {
    vpiArrayType_ = data;
    return true;
  }

  VectorOfrange* Ranges() const { return ranges_; }
  bool Ranges(VectorOfrange* data) {
    ranges_ = data;
    return true;
  }

  expr* Left_expr()  { return left_expr_; }
  const expr* Left_expr() const { return left_expr_; }
  template <typename T>
  T* Left_expr() {
    return (left_expr_ == nullptr) ? nullptr : any_cast<T*>(left_expr_);
  }
  template <typename T>
  const T* Left_expr() const {
    return (left_expr_ == nullptr) ? nullptr : any_cast<const T*>(left_expr_);
  }
  bool Left_expr(expr* data) {
    left_expr_ = data;
    return true;
  }

  expr* Right_expr()  { return right_expr_; }
  const expr* Right_expr() const { return right_expr_; }
  template <typename T>
  T* Right_expr() {
    return (right_expr_ == nullptr) ? nullptr : any_cast<T*>(right_expr_);
  }
  template <typename T>
  const T* Right_expr() const {
    return (right_expr_ == nullptr) ? nullptr : any_cast<const T*>(right_expr_);
  }
  bool Right_expr(expr* data) {
    right_expr_ = data;
    return true;
  }

  ref_typespec* Index_typespec()  { return index_typespec_; }
  const ref_typespec* Index_typespec() const { return index_typespec_; }
  template <typename T>
  T* Index_typespec() {
    return (index_typespec_ == nullptr) ? nullptr : any_cast<T*>(index_typespec_);
  }
  template <typename T>
  const T* Index_typespec() const {
    return (index_typespec_ == nullptr) ? nullptr : any_cast<const T*>(index_typespec_);
  }
  bool Index_typespec(ref_typespec* data) {
    index_typespec_ = data;
    return true;
  }

  ref_typespec* Elem_typespec()  { return elem_typespec_; }
  const ref_typespec* Elem_typespec() const { return elem_typespec_; }
  template <typename T>
  T* Elem_typespec() {
    return (elem_typespec_ == nullptr) ? nullptr : any_cast<T*>(elem_typespec_);
  }
  template <typename T>
  const T* Elem_typespec() const {
    return (elem_typespec_ == nullptr) ? nullptr : any_cast<const T*>(elem_typespec_);
  }
  bool Elem_typespec(ref_typespec* data) {
    elem_typespec_ = data;
    return true;
  }

  function* Resolution_func()  { return resolution_func_; }
  const function* Resolution_func() const { return resolution_func_; }
  template <typename T>
  T* Resolution_func() {
    return (resolution_func_ == nullptr) ? nullptr : any_cast<T*>(resolution_func_);
  }
  template <typename T>
  const T* Resolution_func() const {
    return (resolution_func_ == nullptr) ? nullptr : any_cast<const T*>(resolution_func_);
  }
  bool Resolution_func(function* data) {
    resolution_func_ = data;
    return true;
  }

  virtual uint32_t VpiType() const final { return vpiArrayTypespec; }

  virtual array_typespec* DeepClone(BaseClass* parent, CloneContext* context) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int32_t type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int32_t property) const override;

  virtual int32_t Compare(const BaseClass* other, CompareContext* context) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return UHDM_OBJECT_TYPE::uhdmarray_typespec; }

protected:
  void DeepCopy(array_typespec* clone, BaseClass* parent, CloneContext* context) const;

private:
  int32_t vpiArrayType_ = 0;

  VectorOfrange* ranges_ = nullptr;

  expr* left_expr_ = nullptr;

  expr* right_expr_ = nullptr;

  ref_typespec* index_typespec_ = nullptr;

  ref_typespec* elem_typespec_ = nullptr;

  function* resolution_func_ = nullptr;
};


typedef FactoryT<array_typespec> array_typespecFactory;


typedef FactoryT<std::vector<array_typespec *>> VectorOfarray_typespecFactory;

}  // namespace UHDM

#endif
