// This file is auto-generated by generate_ast_listener.py
// DO NOT EDIT

/*
 Copyright 2019 Alain Dargelas
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 *
 * File:   ParseTreeListener.h
 * Author: hs
 *
 */

#ifndef SURELOG_PARSETREELISTENER_H
#define SURELOG_PARSETREELISTENER_H
#pragma once

#include <Surelog/Common/NodeId.h>
#include <Surelog/Common/PathId.h>
#include <Surelog/SourceCompile/VObjectTypes.h>

#include <cstdint>
#include <type_traits>
#include <unordered_set>
#include <vector>

namespace SURELOG {

class ParseTreeListener;
class SymbolTable;
class VObject;
struct ParseTreeNodeEqualityComparer;
struct ParseTreeNodeHash;
struct ParseTreeNodeLessComparer;

class ParseTreeNode final {
 public:
  ParseTreeNode() : m_index(), m_object(nullptr) {}
  ParseTreeNode(const ParseTreeNode& node)
      : m_index(node.m_index), m_object(node.m_object) {}
  ParseTreeNode(const NodeId& index, const VObject* const object)
      : m_index(index), m_object(object) {}

  ParseTreeNode& operator=(const ParseTreeNode& rhs) {
    if (this != &rhs) {
      m_index = rhs.m_index;
      m_object = rhs.m_object;
    }
    return *this;
  }

 public:
  operator bool() const { return m_index && (m_object != nullptr); }

 private:
  NodeId m_index;
  const VObject* m_object = nullptr;

  friend class ParseTreeListener;
  friend struct ParseTreeNodeHash;
  friend struct ParseTreeNodeEqualityComparer;
  friend struct ParseTreeNodeLessComparer;
};

struct ParseTreeNodeEqualityComparer final {
  bool operator()(const ParseTreeNode& lhs, const ParseTreeNode& rhs) const {
    return (lhs.m_index == rhs.m_index) && (lhs.m_object == rhs.m_object);
  }
};

struct ParseTreeNodeHash final {
  size_t operator()(const ParseTreeNode& node) const {
    return std::hash<RawNodeId>()(node.m_index);
  }
};

class ParseTreeListener {
 protected:
  typedef std::unordered_set<ParseTreeNode, ParseTreeNodeHash,
                             ParseTreeNodeEqualityComparer>
      parsetreenode_set_t;
  typedef std::vector<ParseTreeNode> parsetreenode_stack_t;
  typedef std::vector<ParseTreeNode> parsetreenode_vector_t;

 public:
  ParseTreeListener() = default;
  virtual ~ParseTreeListener() = default;

  virtual void enterSourceFile(PathId fileId) {}
  virtual void leaveSourceFile(PathId fileId) {}

  virtual void enter(const ParseTreeNode& node) {}
  virtual void leave(const ParseTreeNode& node) {}
  virtual void visit(const ParseTreeNode& node) {}

  // clang-format off
  virtual void enterPP_Accelerate_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Accelerate_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Autoexpand_vectornets_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Autoexpand_vectornets_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Begin_keywords_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Begin_keywords_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Celldefine_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Celldefine_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Checker(const ParseTreeNode& node) {}
  virtual void leavePP_Checker(const ParseTreeNode& node) {}

  virtual void enterPP_Comment(const ParseTreeNode& node) {}
  virtual void leavePP_Comment(const ParseTreeNode& node) {}

  virtual void enterPP_Config(const ParseTreeNode& node) {}
  virtual void leavePP_Config(const ParseTreeNode& node) {}

  virtual void enterPP_Default_decay_time_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Default_decay_time_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Default_nettype_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Default_nettype_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Default_trireg_strength_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Default_trireg_strength_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Default_value(const ParseTreeNode& node) {}
  virtual void leavePP_Default_value(const ParseTreeNode& node) {}

  virtual void enterPP_Define_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Define_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Delay_mode_distributed_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Delay_mode_distributed_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Delay_mode_path_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Delay_mode_path_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Delay_mode_unit_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Delay_mode_unit_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Delay_mode_zero_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Delay_mode_zero_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Description(const ParseTreeNode& node) {}
  virtual void leavePP_Description(const ParseTreeNode& node) {}

  virtual void enterPP_Directive_in_macro(const ParseTreeNode& node) {}
  virtual void leavePP_Directive_in_macro(const ParseTreeNode& node) {}

  virtual void enterPP_Disable_portfaults_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Disable_portfaults_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Else_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Else_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Elseif_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Elseif_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Elseif_directive_in_macro_body(const ParseTreeNode& node) {}
  virtual void leavePP_Elseif_directive_in_macro_body(const ParseTreeNode& node) {}

  virtual void enterPP_Elsif_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Elsif_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Elsif_directive_in_macro_body(const ParseTreeNode& node) {}
  virtual void leavePP_Elsif_directive_in_macro_body(const ParseTreeNode& node) {}

  virtual void enterPP_Enable_portfaults_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Enable_portfaults_directive(const ParseTreeNode& node) {}

  virtual void enterPP_End_keywords_directive(const ParseTreeNode& node) {}
  virtual void leavePP_End_keywords_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Endcelldefine_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Endcelldefine_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Endchecker(const ParseTreeNode& node) {}
  virtual void leavePP_Endchecker(const ParseTreeNode& node) {}

  virtual void enterPP_Endconfig(const ParseTreeNode& node) {}
  virtual void leavePP_Endconfig(const ParseTreeNode& node) {}

  virtual void enterPP_Endif_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Endif_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Endinterface(const ParseTreeNode& node) {}
  virtual void leavePP_Endinterface(const ParseTreeNode& node) {}

  virtual void enterPP_Endmodule(const ParseTreeNode& node) {}
  virtual void leavePP_Endmodule(const ParseTreeNode& node) {}

  virtual void enterPP_Endpackage(const ParseTreeNode& node) {}
  virtual void leavePP_Endpackage(const ParseTreeNode& node) {}

  virtual void enterPP_Endprimitive(const ParseTreeNode& node) {}
  virtual void leavePP_Endprimitive(const ParseTreeNode& node) {}

  virtual void enterPP_Endprogram(const ParseTreeNode& node) {}
  virtual void leavePP_Endprogram(const ParseTreeNode& node) {}

  virtual void enterPP_Endprotect_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Endprotect_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Endprotected_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Endprotected_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Escaped_identifier(const ParseTreeNode& node) {}
  virtual void leavePP_Escaped_identifier(const ParseTreeNode& node) {}

  virtual void enterPP_Escaped_macro_definition_body(const ParseTreeNode& node) {}
  virtual void leavePP_Escaped_macro_definition_body(const ParseTreeNode& node) {}

  virtual void enterPP_Escaped_macro_definition_body_alt1(const ParseTreeNode& node) {}
  virtual void leavePP_Escaped_macro_definition_body_alt1(const ParseTreeNode& node) {}

  virtual void enterPP_Escaped_macro_definition_body_alt2(const ParseTreeNode& node) {}
  virtual void leavePP_Escaped_macro_definition_body_alt2(const ParseTreeNode& node) {}

  virtual void enterPP_Expand_vectornets_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Expand_vectornets_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Identifier_in_macro_body(const ParseTreeNode& node) {}
  virtual void leavePP_Identifier_in_macro_body(const ParseTreeNode& node) {}

  virtual void enterPP_Ifdef_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Ifdef_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Ifdef_directive_in_macro_body(const ParseTreeNode& node) {}
  virtual void leavePP_Ifdef_directive_in_macro_body(const ParseTreeNode& node) {}

  virtual void enterPP_Ifndef_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Ifndef_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Ifndef_directive_in_macro_body(const ParseTreeNode& node) {}
  virtual void leavePP_Ifndef_directive_in_macro_body(const ParseTreeNode& node) {}

  virtual void enterPP_Include_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Include_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Integral_number(const ParseTreeNode& node) {}
  virtual void leavePP_Integral_number(const ParseTreeNode& node) {}

  virtual void enterPP_Line_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Line_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Macro_actual_args(const ParseTreeNode& node) {}
  virtual void leavePP_Macro_actual_args(const ParseTreeNode& node) {}

  virtual void enterPP_Macro_arg(const ParseTreeNode& node) {}
  virtual void leavePP_Macro_arg(const ParseTreeNode& node) {}

  virtual void enterPP_Macro_arguments(const ParseTreeNode& node) {}
  virtual void leavePP_Macro_arguments(const ParseTreeNode& node) {}

  virtual void enterPP_Macro_definition(const ParseTreeNode& node) {}
  virtual void leavePP_Macro_definition(const ParseTreeNode& node) {}

  virtual void enterPP_Macro_instance(const ParseTreeNode& node) {}
  virtual void leavePP_Macro_instance(const ParseTreeNode& node) {}

  virtual void enterPP_Module(const ParseTreeNode& node) {}
  virtual void leavePP_Module(const ParseTreeNode& node) {}

  virtual void enterPP_Multiline_args_macro_definition(const ParseTreeNode& node) {}
  virtual void leavePP_Multiline_args_macro_definition(const ParseTreeNode& node) {}

  virtual void enterPP_Multiline_no_args_macro_definition(const ParseTreeNode& node) {}
  virtual void leavePP_Multiline_no_args_macro_definition(const ParseTreeNode& node) {}

  virtual void enterPP_Noaccelerate_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Noaccelerate_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Noexpand_vectornets_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Noexpand_vectornets_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Noremove_gatenames_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Noremove_gatenames_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Noremove_netnames_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Noremove_netnames_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Nosuppress_faults_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Nosuppress_faults_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Nounconnected_drive_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Nounconnected_drive_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Null_rule(const ParseTreeNode& node) {}
  virtual void leavePP_Null_rule(const ParseTreeNode& node) {}

  virtual void enterPP_Paired_parens(const ParseTreeNode& node) {}
  virtual void leavePP_Paired_parens(const ParseTreeNode& node) {}

  virtual void enterPP_Pound_delay(const ParseTreeNode& node) {}
  virtual void leavePP_Pound_delay(const ParseTreeNode& node) {}

  virtual void enterPP_Pound_pound_delay(const ParseTreeNode& node) {}
  virtual void leavePP_Pound_pound_delay(const ParseTreeNode& node) {}

  virtual void enterPP_Pragma_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Pragma_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Pragma_expression(const ParseTreeNode& node) {}
  virtual void leavePP_Pragma_expression(const ParseTreeNode& node) {}

  virtual void enterPP_Primitive(const ParseTreeNode& node) {}
  virtual void leavePP_Primitive(const ParseTreeNode& node) {}

  virtual void enterPP_Program(const ParseTreeNode& node) {}
  virtual void leavePP_Program(const ParseTreeNode& node) {}

  virtual void enterPP_Protect_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Protect_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Protected_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Protected_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Remove_gatename_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Remove_gatename_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Remove_netname_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Remove_netname_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Resetall_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Resetall_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Signed_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Signed_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Simple_args_macro_definition(const ParseTreeNode& node) {}
  virtual void leavePP_Simple_args_macro_definition(const ParseTreeNode& node) {}

  virtual void enterPP_Simple_args_macro_definition_in_macro_body(const ParseTreeNode& node) {}
  virtual void leavePP_Simple_args_macro_definition_in_macro_body(const ParseTreeNode& node) {}

  virtual void enterPP_Simple_macro_definition_body(const ParseTreeNode& node) {}
  virtual void leavePP_Simple_macro_definition_body(const ParseTreeNode& node) {}

  virtual void enterPP_Simple_macro_definition_body_in_macro_body(const ParseTreeNode& node) {}
  virtual void leavePP_Simple_macro_definition_body_in_macro_body(const ParseTreeNode& node) {}

  virtual void enterPP_Simple_no_args_macro_definition(const ParseTreeNode& node) {}
  virtual void leavePP_Simple_no_args_macro_definition(const ParseTreeNode& node) {}

  virtual void enterPP_Simple_no_args_macro_definition_in_macro_body(const ParseTreeNode& node) {}
  virtual void leavePP_Simple_no_args_macro_definition_in_macro_body(const ParseTreeNode& node) {}

  virtual void enterPP_Source_text(const ParseTreeNode& node) {}
  virtual void leavePP_Source_text(const ParseTreeNode& node) {}

  virtual void enterPP_String(const ParseTreeNode& node) {}
  virtual void leavePP_String(const ParseTreeNode& node) {}

  virtual void enterPP_String_blob(const ParseTreeNode& node) {}
  virtual void leavePP_String_blob(const ParseTreeNode& node) {}

  virtual void enterPP_Suppress_faults_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Suppress_faults_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Sv_file_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Sv_file_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Sv_interface(const ParseTreeNode& node) {}
  virtual void leavePP_Sv_interface(const ParseTreeNode& node) {}

  virtual void enterPP_Sv_line_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Sv_line_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Sv_package(const ParseTreeNode& node) {}
  virtual void leavePP_Sv_package(const ParseTreeNode& node) {}

  virtual void enterPP_Text_blob(const ParseTreeNode& node) {}
  virtual void leavePP_Text_blob(const ParseTreeNode& node) {}

  virtual void enterPP_Timescale_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Timescale_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Top_level_rule(const ParseTreeNode& node) {}
  virtual void leavePP_Top_level_rule(const ParseTreeNode& node) {}

  virtual void enterPP_Unconnected_drive_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Unconnected_drive_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Undef_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Undef_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Undefineall_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Undefineall_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Unsigned_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Unsigned_directive(const ParseTreeNode& node) {}

  virtual void enterPP_Unterminated_string(const ParseTreeNode& node) {}
  virtual void leavePP_Unterminated_string(const ParseTreeNode& node) {}

  virtual void enterPP_Uselib_directive(const ParseTreeNode& node) {}
  virtual void leavePP_Uselib_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Accelerate_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Accelerate_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Action_block(const ParseTreeNode& node) {}
  virtual void leavePA_Action_block(const ParseTreeNode& node) {}

  virtual void enterPA_Actual_arg_expr(const ParseTreeNode& node) {}
  virtual void leavePA_Actual_arg_expr(const ParseTreeNode& node) {}

  virtual void enterPA_Actual_arg_list(const ParseTreeNode& node) {}
  virtual void leavePA_Actual_arg_list(const ParseTreeNode& node) {}

  virtual void enterPA_Always_construct(const ParseTreeNode& node) {}
  virtual void leavePA_Always_construct(const ParseTreeNode& node) {}

  virtual void enterPA_Always_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Always_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_And_call(const ParseTreeNode& node) {}
  virtual void leavePA_And_call(const ParseTreeNode& node) {}

  virtual void enterPA_Anonymous_program(const ParseTreeNode& node) {}
  virtual void leavePA_Anonymous_program(const ParseTreeNode& node) {}

  virtual void enterPA_Anonymous_program_item(const ParseTreeNode& node) {}
  virtual void leavePA_Anonymous_program_item(const ParseTreeNode& node) {}

  virtual void enterPA_Ansi_port_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Ansi_port_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Argument(const ParseTreeNode& node) {}
  virtual void leavePA_Argument(const ParseTreeNode& node) {}

  virtual void enterPA_Array_manipulation_call(const ParseTreeNode& node) {}
  virtual void leavePA_Array_manipulation_call(const ParseTreeNode& node) {}

  virtual void enterPA_Array_member_label(const ParseTreeNode& node) {}
  virtual void leavePA_Array_member_label(const ParseTreeNode& node) {}

  virtual void enterPA_Array_method_name(const ParseTreeNode& node) {}
  virtual void leavePA_Array_method_name(const ParseTreeNode& node) {}

  virtual void enterPA_Array_pattern_key(const ParseTreeNode& node) {}
  virtual void leavePA_Array_pattern_key(const ParseTreeNode& node) {}

  virtual void enterPA_Array_range_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Array_range_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Assert_property_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Assert_property_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Assertion_item(const ParseTreeNode& node) {}
  virtual void leavePA_Assertion_item(const ParseTreeNode& node) {}

  virtual void enterPA_Assertion_item_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Assertion_item_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Assertion_variable_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Assertion_variable_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Assignment_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Assignment_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Assignment_pattern(const ParseTreeNode& node) {}
  virtual void leavePA_Assignment_pattern(const ParseTreeNode& node) {}

  virtual void enterPA_Assignment_pattern_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Assignment_pattern_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Assignment_pattern_expression_type(const ParseTreeNode& node) {}
  virtual void leavePA_Assignment_pattern_expression_type(const ParseTreeNode& node) {}

  virtual void enterPA_Assignment_pattern_key(const ParseTreeNode& node) {}
  virtual void leavePA_Assignment_pattern_key(const ParseTreeNode& node) {}

  virtual void enterPA_Assignment_pattern_net_lvalue(const ParseTreeNode& node) {}
  virtual void leavePA_Assignment_pattern_net_lvalue(const ParseTreeNode& node) {}

  virtual void enterPA_Assignment_pattern_variable_lvalue(const ParseTreeNode& node) {}
  virtual void leavePA_Assignment_pattern_variable_lvalue(const ParseTreeNode& node) {}

  virtual void enterPA_Associative_dimension(const ParseTreeNode& node) {}
  virtual void leavePA_Associative_dimension(const ParseTreeNode& node) {}

  virtual void enterPA_Assume_property_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Assume_property_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Attr_name(const ParseTreeNode& node) {}
  virtual void leavePA_Attr_name(const ParseTreeNode& node) {}

  virtual void enterPA_Attr_spec(const ParseTreeNode& node) {}
  virtual void leavePA_Attr_spec(const ParseTreeNode& node) {}

  virtual void enterPA_Attribute_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Attribute_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Autoexpand_vectornets_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Autoexpand_vectornets_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Begin_keywords_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Begin_keywords_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Binary_module_path_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Binary_module_path_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Bind_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Bind_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Bind_instantiation(const ParseTreeNode& node) {}
  virtual void leavePA_Bind_instantiation(const ParseTreeNode& node) {}

  virtual void enterPA_Bins_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Bins_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Bins_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Bins_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Bins_or_empty(const ParseTreeNode& node) {}
  virtual void leavePA_Bins_or_empty(const ParseTreeNode& node) {}

  virtual void enterPA_Bins_or_options(const ParseTreeNode& node) {}
  virtual void leavePA_Bins_or_options(const ParseTreeNode& node) {}

  virtual void enterPA_Bins_selection(const ParseTreeNode& node) {}
  virtual void leavePA_Bins_selection(const ParseTreeNode& node) {}

  virtual void enterPA_Bins_selection_or_option(const ParseTreeNode& node) {}
  virtual void leavePA_Bins_selection_or_option(const ParseTreeNode& node) {}

  virtual void enterPA_Bit_select(const ParseTreeNode& node) {}
  virtual void leavePA_Bit_select(const ParseTreeNode& node) {}

  virtual void enterPA_Block_event_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Block_event_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Block_item_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Block_item_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Blocking_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Blocking_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Boolean_abbrev(const ParseTreeNode& node) {}
  virtual void leavePA_Boolean_abbrev(const ParseTreeNode& node) {}

  virtual void enterPA_Built_in_method_call(const ParseTreeNode& node) {}
  virtual void leavePA_Built_in_method_call(const ParseTreeNode& node) {}

  virtual void enterPA_Case_generate_construct(const ParseTreeNode& node) {}
  virtual void leavePA_Case_generate_construct(const ParseTreeNode& node) {}

  virtual void enterPA_Case_generate_item(const ParseTreeNode& node) {}
  virtual void leavePA_Case_generate_item(const ParseTreeNode& node) {}

  virtual void enterPA_Case_inside_item(const ParseTreeNode& node) {}
  virtual void leavePA_Case_inside_item(const ParseTreeNode& node) {}

  virtual void enterPA_Case_item(const ParseTreeNode& node) {}
  virtual void leavePA_Case_item(const ParseTreeNode& node) {}

  virtual void enterPA_Case_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Case_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Case_pattern_item(const ParseTreeNode& node) {}
  virtual void leavePA_Case_pattern_item(const ParseTreeNode& node) {}

  virtual void enterPA_Case_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Case_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Cast(const ParseTreeNode& node) {}
  virtual void leavePA_Cast(const ParseTreeNode& node) {}

  virtual void enterPA_Casting_type(const ParseTreeNode& node) {}
  virtual void leavePA_Casting_type(const ParseTreeNode& node) {}

  virtual void enterPA_Cell_clause(const ParseTreeNode& node) {}
  virtual void leavePA_Cell_clause(const ParseTreeNode& node) {}

  virtual void enterPA_Celldefine_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Celldefine_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Chandle_type(const ParseTreeNode& node) {}
  virtual void leavePA_Chandle_type(const ParseTreeNode& node) {}

  virtual void enterPA_Charge_strength(const ParseTreeNode& node) {}
  virtual void leavePA_Charge_strength(const ParseTreeNode& node) {}

  virtual void enterPA_Checker_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Checker_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Checker_generate_item(const ParseTreeNode& node) {}
  virtual void leavePA_Checker_generate_item(const ParseTreeNode& node) {}

  virtual void enterPA_Checker_instantiation(const ParseTreeNode& node) {}
  virtual void leavePA_Checker_instantiation(const ParseTreeNode& node) {}

  virtual void enterPA_Checker_or_generate_item(const ParseTreeNode& node) {}
  virtual void leavePA_Checker_or_generate_item(const ParseTreeNode& node) {}

  virtual void enterPA_Checker_or_generate_item_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Checker_or_generate_item_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Checker_port_item(const ParseTreeNode& node) {}
  virtual void leavePA_Checker_port_item(const ParseTreeNode& node) {}

  virtual void enterPA_Checker_port_list(const ParseTreeNode& node) {}
  virtual void leavePA_Checker_port_list(const ParseTreeNode& node) {}

  virtual void enterPA_Class_constraint(const ParseTreeNode& node) {}
  virtual void leavePA_Class_constraint(const ParseTreeNode& node) {}

  virtual void enterPA_Class_constructor_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Class_constructor_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Class_constructor_prototype(const ParseTreeNode& node) {}
  virtual void leavePA_Class_constructor_prototype(const ParseTreeNode& node) {}

  virtual void enterPA_Class_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Class_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Class_item(const ParseTreeNode& node) {}
  virtual void leavePA_Class_item(const ParseTreeNode& node) {}

  virtual void enterPA_Class_item_qualifier(const ParseTreeNode& node) {}
  virtual void leavePA_Class_item_qualifier(const ParseTreeNode& node) {}

  virtual void enterPA_Class_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Class_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Class_method(const ParseTreeNode& node) {}
  virtual void leavePA_Class_method(const ParseTreeNode& node) {}

  virtual void enterPA_Class_new(const ParseTreeNode& node) {}
  virtual void leavePA_Class_new(const ParseTreeNode& node) {}

  virtual void enterPA_Class_property(const ParseTreeNode& node) {}
  virtual void leavePA_Class_property(const ParseTreeNode& node) {}

  virtual void enterPA_Class_scope(const ParseTreeNode& node) {}
  virtual void leavePA_Class_scope(const ParseTreeNode& node) {}

  virtual void enterPA_Class_type(const ParseTreeNode& node) {}
  virtual void leavePA_Class_type(const ParseTreeNode& node) {}

  virtual void enterPA_Clocking_decl_assign(const ParseTreeNode& node) {}
  virtual void leavePA_Clocking_decl_assign(const ParseTreeNode& node) {}

  virtual void enterPA_Clocking_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Clocking_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Clocking_direction(const ParseTreeNode& node) {}
  virtual void leavePA_Clocking_direction(const ParseTreeNode& node) {}

  virtual void enterPA_Clocking_drive(const ParseTreeNode& node) {}
  virtual void leavePA_Clocking_drive(const ParseTreeNode& node) {}

  virtual void enterPA_Clocking_event(const ParseTreeNode& node) {}
  virtual void leavePA_Clocking_event(const ParseTreeNode& node) {}

  virtual void enterPA_Clocking_item(const ParseTreeNode& node) {}
  virtual void leavePA_Clocking_item(const ParseTreeNode& node) {}

  virtual void enterPA_Clocking_skew(const ParseTreeNode& node) {}
  virtual void leavePA_Clocking_skew(const ParseTreeNode& node) {}

  virtual void enterPA_Clockvar(const ParseTreeNode& node) {}
  virtual void leavePA_Clockvar(const ParseTreeNode& node) {}

  virtual void enterPA_Clockvar_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Clockvar_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Cmos_switch_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Cmos_switch_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Cmos_switchtype(const ParseTreeNode& node) {}
  virtual void leavePA_Cmos_switchtype(const ParseTreeNode& node) {}

  virtual void enterPA_Combinational_body(const ParseTreeNode& node) {}
  virtual void leavePA_Combinational_body(const ParseTreeNode& node) {}

  virtual void enterPA_Combinational_entry(const ParseTreeNode& node) {}
  virtual void leavePA_Combinational_entry(const ParseTreeNode& node) {}

  virtual void enterPA_Comma(const ParseTreeNode& node) {}
  virtual void leavePA_Comma(const ParseTreeNode& node) {}

  virtual void enterPA_Comma_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Comma_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Complex_func_call(const ParseTreeNode& node) {}
  virtual void leavePA_Complex_func_call(const ParseTreeNode& node) {}

  virtual void enterPA_Concatenation(const ParseTreeNode& node) {}
  virtual void leavePA_Concatenation(const ParseTreeNode& node) {}

  virtual void enterPA_Concurrent_assertion_item(const ParseTreeNode& node) {}
  virtual void leavePA_Concurrent_assertion_item(const ParseTreeNode& node) {}

  virtual void enterPA_Concurrent_assertion_item_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Concurrent_assertion_item_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Concurrent_assertion_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Concurrent_assertion_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Cond_predicate(const ParseTreeNode& node) {}
  virtual void leavePA_Cond_predicate(const ParseTreeNode& node) {}

  virtual void enterPA_Conditional_generate_construct(const ParseTreeNode& node) {}
  virtual void leavePA_Conditional_generate_construct(const ParseTreeNode& node) {}

  virtual void enterPA_Conditional_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Conditional_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Conditional_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Conditional_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Config_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Config_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Config_rule_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Config_rule_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Consecutive_repetition(const ParseTreeNode& node) {}
  virtual void leavePA_Consecutive_repetition(const ParseTreeNode& node) {}

  virtual void enterPA_Const_or_range_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Const_or_range_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Const_type(const ParseTreeNode& node) {}
  virtual void leavePA_Const_type(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_assignment_pattern_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_assignment_pattern_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_bit_select(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_bit_select(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_cast(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_cast(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_concatenation(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_concatenation(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_indexed_range(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_indexed_range(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_mintypmax_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_mintypmax_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_multiple_concatenation(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_multiple_concatenation(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_param_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_param_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_part_select_range(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_part_select_range(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_primary(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_primary(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_range(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_range(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_range_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_range_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Constant_select(const ParseTreeNode& node) {}
  virtual void leavePA_Constant_select(const ParseTreeNode& node) {}

  virtual void enterPA_Constraint_block(const ParseTreeNode& node) {}
  virtual void leavePA_Constraint_block(const ParseTreeNode& node) {}

  virtual void enterPA_Constraint_block_item(const ParseTreeNode& node) {}
  virtual void leavePA_Constraint_block_item(const ParseTreeNode& node) {}

  virtual void enterPA_Constraint_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Constraint_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Constraint_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Constraint_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Constraint_primary(const ParseTreeNode& node) {}
  virtual void leavePA_Constraint_primary(const ParseTreeNode& node) {}

  virtual void enterPA_Constraint_prototype(const ParseTreeNode& node) {}
  virtual void leavePA_Constraint_prototype(const ParseTreeNode& node) {}

  virtual void enterPA_Constraint_set(const ParseTreeNode& node) {}
  virtual void leavePA_Constraint_set(const ParseTreeNode& node) {}

  virtual void enterPA_Context_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Context_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Continuous_assign(const ParseTreeNode& node) {}
  virtual void leavePA_Continuous_assign(const ParseTreeNode& node) {}

  virtual void enterPA_Controlled_timing_check_event(const ParseTreeNode& node) {}
  virtual void leavePA_Controlled_timing_check_event(const ParseTreeNode& node) {}

  virtual void enterPA_Cover_cross(const ParseTreeNode& node) {}
  virtual void leavePA_Cover_cross(const ParseTreeNode& node) {}

  virtual void enterPA_Cover_point(const ParseTreeNode& node) {}
  virtual void leavePA_Cover_point(const ParseTreeNode& node) {}

  virtual void enterPA_Cover_property_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Cover_property_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Cover_sequence_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Cover_sequence_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Coverage_event(const ParseTreeNode& node) {}
  virtual void leavePA_Coverage_event(const ParseTreeNode& node) {}

  virtual void enterPA_Coverage_option(const ParseTreeNode& node) {}
  virtual void leavePA_Coverage_option(const ParseTreeNode& node) {}

  virtual void enterPA_Coverage_spec(const ParseTreeNode& node) {}
  virtual void leavePA_Coverage_spec(const ParseTreeNode& node) {}

  virtual void enterPA_Coverage_spec_or_option(const ParseTreeNode& node) {}
  virtual void leavePA_Coverage_spec_or_option(const ParseTreeNode& node) {}

  virtual void enterPA_Covergroup_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Covergroup_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Cross_body(const ParseTreeNode& node) {}
  virtual void leavePA_Cross_body(const ParseTreeNode& node) {}

  virtual void enterPA_Cross_body_item(const ParseTreeNode& node) {}
  virtual void leavePA_Cross_body_item(const ParseTreeNode& node) {}

  virtual void enterPA_Cross_item(const ParseTreeNode& node) {}
  virtual void leavePA_Cross_item(const ParseTreeNode& node) {}

  virtual void enterPA_Cycle_delay(const ParseTreeNode& node) {}
  virtual void leavePA_Cycle_delay(const ParseTreeNode& node) {}

  virtual void enterPA_Cycle_delay_const_range_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Cycle_delay_const_range_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Cycle_delay_range(const ParseTreeNode& node) {}
  virtual void leavePA_Cycle_delay_range(const ParseTreeNode& node) {}

  virtual void enterPA_Data_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Data_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Data_type(const ParseTreeNode& node) {}
  virtual void leavePA_Data_type(const ParseTreeNode& node) {}

  virtual void enterPA_Data_type_or_implicit(const ParseTreeNode& node) {}
  virtual void leavePA_Data_type_or_implicit(const ParseTreeNode& node) {}

  virtual void enterPA_Data_type_or_void(const ParseTreeNode& node) {}
  virtual void leavePA_Data_type_or_void(const ParseTreeNode& node) {}

  virtual void enterPA_Default_clause(const ParseTreeNode& node) {}
  virtual void leavePA_Default_clause(const ParseTreeNode& node) {}

  virtual void enterPA_Default_decay_time_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Default_decay_time_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Default_nettype_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Default_nettype_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Default_skew(const ParseTreeNode& node) {}
  virtual void leavePA_Default_skew(const ParseTreeNode& node) {}

  virtual void enterPA_Default_trireg_strenght_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Default_trireg_strenght_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Deferred_immediate_assert_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Deferred_immediate_assert_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Deferred_immediate_assertion_item(const ParseTreeNode& node) {}
  virtual void leavePA_Deferred_immediate_assertion_item(const ParseTreeNode& node) {}

  virtual void enterPA_Deferred_immediate_assertion_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Deferred_immediate_assertion_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Deferred_immediate_assume_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Deferred_immediate_assume_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Deferred_immediate_cover_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Deferred_immediate_cover_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Defparam_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Defparam_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Delay2(const ParseTreeNode& node) {}
  virtual void leavePA_Delay2(const ParseTreeNode& node) {}

  virtual void enterPA_Delay3(const ParseTreeNode& node) {}
  virtual void leavePA_Delay3(const ParseTreeNode& node) {}

  virtual void enterPA_Delay_control(const ParseTreeNode& node) {}
  virtual void leavePA_Delay_control(const ParseTreeNode& node) {}

  virtual void enterPA_Delay_mode_distributed_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Delay_mode_distributed_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Delay_mode_path_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Delay_mode_path_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Delay_mode_unit_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Delay_mode_unit_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Delay_mode_zero_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Delay_mode_zero_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Delay_or_event_control(const ParseTreeNode& node) {}
  virtual void leavePA_Delay_or_event_control(const ParseTreeNode& node) {}

  virtual void enterPA_Delay_value(const ParseTreeNode& node) {}
  virtual void leavePA_Delay_value(const ParseTreeNode& node) {}

  virtual void enterPA_Delayed_data(const ParseTreeNode& node) {}
  virtual void leavePA_Delayed_data(const ParseTreeNode& node) {}

  virtual void enterPA_Delayed_reference(const ParseTreeNode& node) {}
  virtual void leavePA_Delayed_reference(const ParseTreeNode& node) {}

  virtual void enterPA_Description(const ParseTreeNode& node) {}
  virtual void leavePA_Description(const ParseTreeNode& node) {}

  virtual void enterPA_Design_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Design_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Disable_portfaults_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Disable_portfaults_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Disable_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Disable_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Dist_item(const ParseTreeNode& node) {}
  virtual void leavePA_Dist_item(const ParseTreeNode& node) {}

  virtual void enterPA_Dist_list(const ParseTreeNode& node) {}
  virtual void leavePA_Dist_list(const ParseTreeNode& node) {}

  virtual void enterPA_Dist_weight(const ParseTreeNode& node) {}
  virtual void leavePA_Dist_weight(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_fullskew_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_fullskew_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_hold_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_hold_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_nochange_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_nochange_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_period_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_period_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_recovery_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_recovery_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_recrem_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_recrem_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_removal_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_removal_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_root_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_root_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_setup_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_setup_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_setuphold_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_setuphold_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_skew_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_skew_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_timeskew_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_timeskew_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dollar_width_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_Dollar_width_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_Dpi_import_export(const ParseTreeNode& node) {}
  virtual void leavePA_Dpi_import_export(const ParseTreeNode& node) {}

  virtual void enterPA_Drive_strength(const ParseTreeNode& node) {}
  virtual void leavePA_Drive_strength(const ParseTreeNode& node) {}

  virtual void enterPA_Dynamic_array_new(const ParseTreeNode& node) {}
  virtual void leavePA_Dynamic_array_new(const ParseTreeNode& node) {}

  virtual void enterPA_Edge_control_specifier(const ParseTreeNode& node) {}
  virtual void leavePA_Edge_control_specifier(const ParseTreeNode& node) {}

  virtual void enterPA_Edge_descriptor(const ParseTreeNode& node) {}
  virtual void leavePA_Edge_descriptor(const ParseTreeNode& node) {}

  virtual void enterPA_Edge_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Edge_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Edge_indicator(const ParseTreeNode& node) {}
  virtual void leavePA_Edge_indicator(const ParseTreeNode& node) {}

  virtual void enterPA_Edge_input_list(const ParseTreeNode& node) {}
  virtual void leavePA_Edge_input_list(const ParseTreeNode& node) {}

  virtual void enterPA_Edge_sensitive_path_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Edge_sensitive_path_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Edge_symbol(const ParseTreeNode& node) {}
  virtual void leavePA_Edge_symbol(const ParseTreeNode& node) {}

  virtual void enterPA_Elaboration_system_task(const ParseTreeNode& node) {}
  virtual void leavePA_Elaboration_system_task(const ParseTreeNode& node) {}

  virtual void enterPA_Empty_queue(const ParseTreeNode& node) {}
  virtual void leavePA_Empty_queue(const ParseTreeNode& node) {}

  virtual void enterPA_Enable_gate_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Enable_gate_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Enable_gatetype(const ParseTreeNode& node) {}
  virtual void leavePA_Enable_gatetype(const ParseTreeNode& node) {}

  virtual void enterPA_Enable_portfaults_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Enable_portfaults_directive(const ParseTreeNode& node) {}

  virtual void enterPA_End_edge_offset(const ParseTreeNode& node) {}
  virtual void leavePA_End_edge_offset(const ParseTreeNode& node) {}

  virtual void enterPA_End_keywords_directive(const ParseTreeNode& node) {}
  virtual void leavePA_End_keywords_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Endcelldefine_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Endcelldefine_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Endprotect_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Endprotect_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Endprotected_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Endprotected_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Enum_base_type(const ParseTreeNode& node) {}
  virtual void leavePA_Enum_base_type(const ParseTreeNode& node) {}

  virtual void enterPA_Enum_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Enum_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Enum_name_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Enum_name_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Event_based_flag(const ParseTreeNode& node) {}
  virtual void leavePA_Event_based_flag(const ParseTreeNode& node) {}

  virtual void enterPA_Event_control(const ParseTreeNode& node) {}
  virtual void leavePA_Event_control(const ParseTreeNode& node) {}

  virtual void enterPA_Event_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Event_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Event_trigger(const ParseTreeNode& node) {}
  virtual void leavePA_Event_trigger(const ParseTreeNode& node) {}

  virtual void enterPA_Event_type(const ParseTreeNode& node) {}
  virtual void leavePA_Event_type(const ParseTreeNode& node) {}

  virtual void enterPA_Expand_vectornets_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Expand_vectornets_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Expect_property_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Expect_property_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Expression(const ParseTreeNode& node) {}
  virtual void leavePA_Expression(const ParseTreeNode& node) {}

  virtual void enterPA_Expression_or_cond_pattern(const ParseTreeNode& node) {}
  virtual void leavePA_Expression_or_cond_pattern(const ParseTreeNode& node) {}

  virtual void enterPA_Expression_or_dist(const ParseTreeNode& node) {}
  virtual void leavePA_Expression_or_dist(const ParseTreeNode& node) {}

  virtual void enterPA_Extern_constraint_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Extern_constraint_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Extern_qualifier(const ParseTreeNode& node) {}
  virtual void leavePA_Extern_qualifier(const ParseTreeNode& node) {}

  virtual void enterPA_Extern_tf_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Extern_tf_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_File_path_spec(const ParseTreeNode& node) {}
  virtual void leavePA_File_path_spec(const ParseTreeNode& node) {}

  virtual void enterPA_Final_construct(const ParseTreeNode& node) {}
  virtual void leavePA_Final_construct(const ParseTreeNode& node) {}

  virtual void enterPA_For_initialization(const ParseTreeNode& node) {}
  virtual void leavePA_For_initialization(const ParseTreeNode& node) {}

  virtual void enterPA_For_step(const ParseTreeNode& node) {}
  virtual void leavePA_For_step(const ParseTreeNode& node) {}

  virtual void enterPA_For_step_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_For_step_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_For_variable_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_For_variable_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Full_edge_sensitive_path_description(const ParseTreeNode& node) {}
  virtual void leavePA_Full_edge_sensitive_path_description(const ParseTreeNode& node) {}

  virtual void enterPA_Full_path_description(const ParseTreeNode& node) {}
  virtual void leavePA_Full_path_description(const ParseTreeNode& node) {}

  virtual void enterPA_Function_body_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Function_body_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Function_data_type(const ParseTreeNode& node) {}
  virtual void leavePA_Function_data_type(const ParseTreeNode& node) {}

  virtual void enterPA_Function_data_type_or_implicit(const ParseTreeNode& node) {}
  virtual void leavePA_Function_data_type_or_implicit(const ParseTreeNode& node) {}

  virtual void enterPA_Function_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Function_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Function_name_decl(const ParseTreeNode& node) {}
  virtual void leavePA_Function_name_decl(const ParseTreeNode& node) {}

  virtual void enterPA_Function_prototype(const ParseTreeNode& node) {}
  virtual void leavePA_Function_prototype(const ParseTreeNode& node) {}

  virtual void enterPA_Function_statement_or_null(const ParseTreeNode& node) {}
  virtual void leavePA_Function_statement_or_null(const ParseTreeNode& node) {}

  virtual void enterPA_Gate_instantiation(const ParseTreeNode& node) {}
  virtual void leavePA_Gate_instantiation(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_begin_end_block(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_begin_end_block(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_interface_block(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_interface_block(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_interface_case_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_interface_case_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_interface_conditional_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_interface_conditional_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_interface_item(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_interface_item(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_interface_loop_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_interface_loop_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_interface_named_block(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_interface_named_block(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_item(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_item(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_module_block(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_module_block(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_module_case_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_module_case_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_module_conditional_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_module_conditional_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_module_item(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_module_item(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_module_loop_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_module_loop_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_module_named_block(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_module_named_block(const ParseTreeNode& node) {}

  virtual void enterPA_Generate_region(const ParseTreeNode& node) {}
  virtual void leavePA_Generate_region(const ParseTreeNode& node) {}

  virtual void enterPA_Generated_interface_instantiation(const ParseTreeNode& node) {}
  virtual void leavePA_Generated_interface_instantiation(const ParseTreeNode& node) {}

  virtual void enterPA_Generated_module_instantiation(const ParseTreeNode& node) {}
  virtual void leavePA_Generated_module_instantiation(const ParseTreeNode& node) {}

  virtual void enterPA_Genvar_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Genvar_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Genvar_decl_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Genvar_decl_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Genvar_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Genvar_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Genvar_initialization(const ParseTreeNode& node) {}
  virtual void leavePA_Genvar_initialization(const ParseTreeNode& node) {}

  virtual void enterPA_Genvar_interface_case_item(const ParseTreeNode& node) {}
  virtual void leavePA_Genvar_interface_case_item(const ParseTreeNode& node) {}

  virtual void enterPA_Genvar_iteration(const ParseTreeNode& node) {}
  virtual void leavePA_Genvar_iteration(const ParseTreeNode& node) {}

  virtual void enterPA_Genvar_module_case_item(const ParseTreeNode& node) {}
  virtual void leavePA_Genvar_module_case_item(const ParseTreeNode& node) {}

  virtual void enterPA_Goto_repetition(const ParseTreeNode& node) {}
  virtual void leavePA_Goto_repetition(const ParseTreeNode& node) {}

  virtual void enterPA_Hierarchical_btf_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Hierarchical_btf_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Hierarchical_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Hierarchical_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Hierarchical_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Hierarchical_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Identifier_list(const ParseTreeNode& node) {}
  virtual void leavePA_Identifier_list(const ParseTreeNode& node) {}

  virtual void enterPA_If_generate_construct(const ParseTreeNode& node) {}
  virtual void leavePA_If_generate_construct(const ParseTreeNode& node) {}

  virtual void enterPA_Immediate_assertion_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Immediate_assertion_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Implicit_class_handle(const ParseTreeNode& node) {}
  virtual void leavePA_Implicit_class_handle(const ParseTreeNode& node) {}

  virtual void enterPA_Implicit_data_type(const ParseTreeNode& node) {}
  virtual void leavePA_Implicit_data_type(const ParseTreeNode& node) {}

  virtual void enterPA_Inc_or_dec_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Inc_or_dec_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Inc_or_dec_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Inc_or_dec_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Include_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Include_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Indexed_range(const ParseTreeNode& node) {}
  virtual void leavePA_Indexed_range(const ParseTreeNode& node) {}

  virtual void enterPA_Init_val(const ParseTreeNode& node) {}
  virtual void leavePA_Init_val(const ParseTreeNode& node) {}

  virtual void enterPA_Initial_construct(const ParseTreeNode& node) {}
  virtual void leavePA_Initial_construct(const ParseTreeNode& node) {}

  virtual void enterPA_Inout_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Inout_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Input_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Input_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Inst_clause(const ParseTreeNode& node) {}
  virtual void leavePA_Inst_clause(const ParseTreeNode& node) {}

  virtual void enterPA_Inst_name(const ParseTreeNode& node) {}
  virtual void leavePA_Inst_name(const ParseTreeNode& node) {}

  virtual void enterPA_Integer_atom_type(const ParseTreeNode& node) {}
  virtual void leavePA_Integer_atom_type(const ParseTreeNode& node) {}

  virtual void enterPA_Integer_type(const ParseTreeNode& node) {}
  virtual void leavePA_Integer_type(const ParseTreeNode& node) {}

  virtual void enterPA_Integer_vector_type(const ParseTreeNode& node) {}
  virtual void leavePA_Integer_vector_type(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_ansi_header(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_ansi_header(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_class_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_class_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_class_item(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_class_item(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_class_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_class_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_class_method(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_class_method(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_class_type(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_class_type(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_item(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_item(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_nonansi_header(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_nonansi_header(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_or_generate_item(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_or_generate_item(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_port_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_port_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Interface_port_header(const ParseTreeNode& node) {}
  virtual void leavePA_Interface_port_header(const ParseTreeNode& node) {}

  virtual void enterPA_Join_any_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Join_any_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Join_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Join_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Join_none_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Join_none_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Jump_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Jump_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Let_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Let_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Let_formal_type(const ParseTreeNode& node) {}
  virtual void leavePA_Let_formal_type(const ParseTreeNode& node) {}

  virtual void enterPA_Let_port_item(const ParseTreeNode& node) {}
  virtual void leavePA_Let_port_item(const ParseTreeNode& node) {}

  virtual void enterPA_Let_port_list(const ParseTreeNode& node) {}
  virtual void leavePA_Let_port_list(const ParseTreeNode& node) {}

  virtual void enterPA_Level_input_list(const ParseTreeNode& node) {}
  virtual void leavePA_Level_input_list(const ParseTreeNode& node) {}

  virtual void enterPA_Level_symbol(const ParseTreeNode& node) {}
  virtual void leavePA_Level_symbol(const ParseTreeNode& node) {}

  virtual void enterPA_Liblist_clause(const ParseTreeNode& node) {}
  virtual void leavePA_Liblist_clause(const ParseTreeNode& node) {}

  virtual void enterPA_Library_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Library_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Library_descriptions(const ParseTreeNode& node) {}
  virtual void leavePA_Library_descriptions(const ParseTreeNode& node) {}

  virtual void enterPA_Library_text(const ParseTreeNode& node) {}
  virtual void leavePA_Library_text(const ParseTreeNode& node) {}

  virtual void enterPA_Lifetime(const ParseTreeNode& node) {}
  virtual void leavePA_Lifetime(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_arguments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_arguments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_checker_port_connections(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_checker_port_connections(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_clocking_decl_assign(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_clocking_decl_assign(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_cross_items(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_cross_items(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_defparam_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_defparam_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_interface_identifiers(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_interface_identifiers(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_net_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_net_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_net_decl_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_net_decl_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_param_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_param_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_parameter_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_parameter_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_path_delay_expressions(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_path_delay_expressions(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_path_inputs(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_path_inputs(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_path_outputs(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_path_outputs(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_port_connections(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_port_connections(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_port_declarations(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_port_declarations(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_port_identifiers(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_port_identifiers(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_ports(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_ports(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_specparam_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_specparam_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_tf_variable_identifiers(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_tf_variable_identifiers(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_type_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_type_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_variable_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_variable_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_variable_decl_assignments(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_variable_decl_assignments(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_variable_identifiers(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_variable_identifiers(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_variable_port_identifiers(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_variable_port_identifiers(const ParseTreeNode& node) {}

  virtual void enterPA_List_of_virtual_interface_decl(const ParseTreeNode& node) {}
  virtual void leavePA_List_of_virtual_interface_decl(const ParseTreeNode& node) {}

  virtual void enterPA_Local_parameter_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Local_parameter_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Loop_generate_construct(const ParseTreeNode& node) {}
  virtual void leavePA_Loop_generate_construct(const ParseTreeNode& node) {}

  virtual void enterPA_Loop_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Loop_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Loop_variables(const ParseTreeNode& node) {}
  virtual void leavePA_Loop_variables(const ParseTreeNode& node) {}

  virtual void enterPA_Matches(const ParseTreeNode& node) {}
  virtual void leavePA_Matches(const ParseTreeNode& node) {}

  virtual void enterPA_Method_call(const ParseTreeNode& node) {}
  virtual void leavePA_Method_call(const ParseTreeNode& node) {}

  virtual void enterPA_Method_call_body(const ParseTreeNode& node) {}
  virtual void leavePA_Method_call_body(const ParseTreeNode& node) {}

  virtual void enterPA_Method_call_root(const ParseTreeNode& node) {}
  virtual void leavePA_Method_call_root(const ParseTreeNode& node) {}

  virtual void enterPA_Method_prototype(const ParseTreeNode& node) {}
  virtual void leavePA_Method_prototype(const ParseTreeNode& node) {}

  virtual void enterPA_Method_qualifier(const ParseTreeNode& node) {}
  virtual void leavePA_Method_qualifier(const ParseTreeNode& node) {}

  virtual void enterPA_Mintypmax_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Mintypmax_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Modport_hierarchical_ports_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Modport_hierarchical_ports_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Modport_item(const ParseTreeNode& node) {}
  virtual void leavePA_Modport_item(const ParseTreeNode& node) {}

  virtual void enterPA_Modport_ports_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Modport_ports_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Modport_simple_port(const ParseTreeNode& node) {}
  virtual void leavePA_Modport_simple_port(const ParseTreeNode& node) {}

  virtual void enterPA_Modport_simple_ports_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Modport_simple_ports_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Modport_tf_port(const ParseTreeNode& node) {}
  virtual void leavePA_Modport_tf_port(const ParseTreeNode& node) {}

  virtual void enterPA_Modport_tf_ports_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Modport_tf_ports_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Module_ansi_header(const ParseTreeNode& node) {}
  virtual void leavePA_Module_ansi_header(const ParseTreeNode& node) {}

  virtual void enterPA_Module_common_item(const ParseTreeNode& node) {}
  virtual void leavePA_Module_common_item(const ParseTreeNode& node) {}

  virtual void enterPA_Module_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Module_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Module_instantiation(const ParseTreeNode& node) {}
  virtual void leavePA_Module_instantiation(const ParseTreeNode& node) {}

  virtual void enterPA_Module_item(const ParseTreeNode& node) {}
  virtual void leavePA_Module_item(const ParseTreeNode& node) {}

  virtual void enterPA_Module_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Module_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Module_nonansi_header(const ParseTreeNode& node) {}
  virtual void leavePA_Module_nonansi_header(const ParseTreeNode& node) {}

  virtual void enterPA_Module_or_generate_item(const ParseTreeNode& node) {}
  virtual void leavePA_Module_or_generate_item(const ParseTreeNode& node) {}

  virtual void enterPA_Module_or_generate_item_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Module_or_generate_item_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Module_path_concatenation(const ParseTreeNode& node) {}
  virtual void leavePA_Module_path_concatenation(const ParseTreeNode& node) {}

  virtual void enterPA_Module_path_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Module_path_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Module_path_mintypmax_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Module_path_mintypmax_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Module_path_multiple_concatenation(const ParseTreeNode& node) {}
  virtual void leavePA_Module_path_multiple_concatenation(const ParseTreeNode& node) {}

  virtual void enterPA_Module_path_primary(const ParseTreeNode& node) {}
  virtual void leavePA_Module_path_primary(const ParseTreeNode& node) {}

  virtual void enterPA_Mos_switch_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Mos_switch_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Mos_switchtype(const ParseTreeNode& node) {}
  virtual void leavePA_Mos_switchtype(const ParseTreeNode& node) {}

  virtual void enterPA_Multiple_concatenation(const ParseTreeNode& node) {}
  virtual void leavePA_Multiple_concatenation(const ParseTreeNode& node) {}

  virtual void enterPA_N_input_gate_instance(const ParseTreeNode& node) {}
  virtual void leavePA_N_input_gate_instance(const ParseTreeNode& node) {}

  virtual void enterPA_N_input_gatetype(const ParseTreeNode& node) {}
  virtual void leavePA_N_input_gatetype(const ParseTreeNode& node) {}

  virtual void enterPA_N_output_gate_instance(const ParseTreeNode& node) {}
  virtual void leavePA_N_output_gate_instance(const ParseTreeNode& node) {}

  virtual void enterPA_N_output_gatetype(const ParseTreeNode& node) {}
  virtual void leavePA_N_output_gatetype(const ParseTreeNode& node) {}

  virtual void enterPA_Name_of_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Name_of_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Named_checker_port_connection(const ParseTreeNode& node) {}
  virtual void leavePA_Named_checker_port_connection(const ParseTreeNode& node) {}

  virtual void enterPA_Named_parameter_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Named_parameter_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Named_port_connection(const ParseTreeNode& node) {}
  virtual void leavePA_Named_port_connection(const ParseTreeNode& node) {}

  virtual void enterPA_Net_alias(const ParseTreeNode& node) {}
  virtual void leavePA_Net_alias(const ParseTreeNode& node) {}

  virtual void enterPA_Net_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Net_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Net_decl_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Net_decl_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Net_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Net_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Net_lvalue(const ParseTreeNode& node) {}
  virtual void leavePA_Net_lvalue(const ParseTreeNode& node) {}

  virtual void enterPA_Net_port_header(const ParseTreeNode& node) {}
  virtual void leavePA_Net_port_header(const ParseTreeNode& node) {}

  virtual void enterPA_Net_port_type(const ParseTreeNode& node) {}
  virtual void leavePA_Net_port_type(const ParseTreeNode& node) {}

  virtual void enterPA_Net_type(const ParseTreeNode& node) {}
  virtual void leavePA_Net_type(const ParseTreeNode& node) {}

  virtual void enterPA_Net_type_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Net_type_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Next_state(const ParseTreeNode& node) {}
  virtual void leavePA_Next_state(const ParseTreeNode& node) {}

  virtual void enterPA_Noaccelerate_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Noaccelerate_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Noexpand_vectornets_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Noexpand_vectornets_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Non_consecutive_repetition(const ParseTreeNode& node) {}
  virtual void leavePA_Non_consecutive_repetition(const ParseTreeNode& node) {}

  virtual void enterPA_Non_integer_type(const ParseTreeNode& node) {}
  virtual void leavePA_Non_integer_type(const ParseTreeNode& node) {}

  virtual void enterPA_Non_port_interface_item(const ParseTreeNode& node) {}
  virtual void leavePA_Non_port_interface_item(const ParseTreeNode& node) {}

  virtual void enterPA_Non_port_module_item(const ParseTreeNode& node) {}
  virtual void leavePA_Non_port_module_item(const ParseTreeNode& node) {}

  virtual void enterPA_Non_port_program_item(const ParseTreeNode& node) {}
  virtual void leavePA_Non_port_program_item(const ParseTreeNode& node) {}

  virtual void enterPA_Nonblocking_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Nonblocking_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Nonrange_select(const ParseTreeNode& node) {}
  virtual void leavePA_Nonrange_select(const ParseTreeNode& node) {}

  virtual void enterPA_Nonrange_variable_lvalue(const ParseTreeNode& node) {}
  virtual void leavePA_Nonrange_variable_lvalue(const ParseTreeNode& node) {}

  virtual void enterPA_Noremove_gatenames_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Noremove_gatenames_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Noremove_netnames_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Noremove_netnames_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Nosuppress_faults_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Nosuppress_faults_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Notifier(const ParseTreeNode& node) {}
  virtual void leavePA_Notifier(const ParseTreeNode& node) {}

  virtual void enterPA_Nounconnected_drive_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Nounconnected_drive_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Null_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Null_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Null_rule(const ParseTreeNode& node) {}
  virtual void leavePA_Null_rule(const ParseTreeNode& node) {}

  virtual void enterPA_Number(const ParseTreeNode& node) {}
  virtual void leavePA_Number(const ParseTreeNode& node) {}

  virtual void enterPA_Open_range_list(const ParseTreeNode& node) {}
  virtual void leavePA_Open_range_list(const ParseTreeNode& node) {}

  virtual void enterPA_Operator_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Operator_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Or_call(const ParseTreeNode& node) {}
  virtual void leavePA_Or_call(const ParseTreeNode& node) {}

  virtual void enterPA_Or_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Or_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Ordered_checker_port_connection(const ParseTreeNode& node) {}
  virtual void leavePA_Ordered_checker_port_connection(const ParseTreeNode& node) {}

  virtual void enterPA_Ordered_parameter_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Ordered_parameter_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Ordered_port_connection(const ParseTreeNode& node) {}
  virtual void leavePA_Ordered_port_connection(const ParseTreeNode& node) {}

  virtual void enterPA_Output_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Output_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Output_symbol(const ParseTreeNode& node) {}
  virtual void leavePA_Output_symbol(const ParseTreeNode& node) {}

  virtual void enterPA_Overload_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Overload_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Overload_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Overload_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Overload_proto_formals(const ParseTreeNode& node) {}
  virtual void leavePA_Overload_proto_formals(const ParseTreeNode& node) {}

  virtual void enterPA_Package_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Package_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Package_export_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Package_export_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Package_import_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Package_import_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Package_import_item(const ParseTreeNode& node) {}
  virtual void leavePA_Package_import_item(const ParseTreeNode& node) {}

  virtual void enterPA_Package_item(const ParseTreeNode& node) {}
  virtual void leavePA_Package_item(const ParseTreeNode& node) {}

  virtual void enterPA_Package_or_generate_item_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Package_or_generate_item_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Package_scope(const ParseTreeNode& node) {}
  virtual void leavePA_Package_scope(const ParseTreeNode& node) {}

  virtual void enterPA_Packed_dimension(const ParseTreeNode& node) {}
  virtual void leavePA_Packed_dimension(const ParseTreeNode& node) {}

  virtual void enterPA_Packed_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Packed_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Par_block(const ParseTreeNode& node) {}
  virtual void leavePA_Par_block(const ParseTreeNode& node) {}

  virtual void enterPA_Parallel_edge_sensitive_path_description(const ParseTreeNode& node) {}
  virtual void leavePA_Parallel_edge_sensitive_path_description(const ParseTreeNode& node) {}

  virtual void enterPA_Parallel_path_description(const ParseTreeNode& node) {}
  virtual void leavePA_Parallel_path_description(const ParseTreeNode& node) {}

  virtual void enterPA_Param_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Param_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Param_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Param_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Parameter_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Parameter_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Parameter_override(const ParseTreeNode& node) {}
  virtual void leavePA_Parameter_override(const ParseTreeNode& node) {}

  virtual void enterPA_Parameter_port_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Parameter_port_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Parameter_port_list(const ParseTreeNode& node) {}
  virtual void leavePA_Parameter_port_list(const ParseTreeNode& node) {}

  virtual void enterPA_Parameter_value_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Parameter_value_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Part_select_op(const ParseTreeNode& node) {}
  virtual void leavePA_Part_select_op(const ParseTreeNode& node) {}

  virtual void enterPA_Part_select_op_colon(const ParseTreeNode& node) {}
  virtual void leavePA_Part_select_op_colon(const ParseTreeNode& node) {}

  virtual void enterPA_Part_select_range(const ParseTreeNode& node) {}
  virtual void leavePA_Part_select_range(const ParseTreeNode& node) {}

  virtual void enterPA_Pass_en_switchtype(const ParseTreeNode& node) {}
  virtual void leavePA_Pass_en_switchtype(const ParseTreeNode& node) {}

  virtual void enterPA_Pass_enable_switch_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Pass_enable_switch_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Pass_switch_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Pass_switch_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Pass_switchtype(const ParseTreeNode& node) {}
  virtual void leavePA_Pass_switchtype(const ParseTreeNode& node) {}

  virtual void enterPA_Path_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Path_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Path_delay_value(const ParseTreeNode& node) {}
  virtual void leavePA_Path_delay_value(const ParseTreeNode& node) {}

  virtual void enterPA_Pattern(const ParseTreeNode& node) {}
  virtual void leavePA_Pattern(const ParseTreeNode& node) {}

  virtual void enterPA_Port(const ParseTreeNode& node) {}
  virtual void leavePA_Port(const ParseTreeNode& node) {}

  virtual void enterPA_Port_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Port_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Port_direction(const ParseTreeNode& node) {}
  virtual void leavePA_Port_direction(const ParseTreeNode& node) {}

  virtual void enterPA_Port_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Port_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Port_reference(const ParseTreeNode& node) {}
  virtual void leavePA_Port_reference(const ParseTreeNode& node) {}

  virtual void enterPA_Pound_delay_value(const ParseTreeNode& node) {}
  virtual void leavePA_Pound_delay_value(const ParseTreeNode& node) {}

  virtual void enterPA_Pragma_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Pragma_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Pragma_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Pragma_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Pragma_value(const ParseTreeNode& node) {}
  virtual void leavePA_Pragma_value(const ParseTreeNode& node) {}

  virtual void enterPA_Primary(const ParseTreeNode& node) {}
  virtual void leavePA_Primary(const ParseTreeNode& node) {}

  virtual void enterPA_Primary_literal(const ParseTreeNode& node) {}
  virtual void leavePA_Primary_literal(const ParseTreeNode& node) {}

  virtual void enterPA_Procedural_assertion_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Procedural_assertion_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Procedural_continuous_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Procedural_continuous_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Procedural_timing_control(const ParseTreeNode& node) {}
  virtual void leavePA_Procedural_timing_control(const ParseTreeNode& node) {}

  virtual void enterPA_Procedural_timing_control_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Procedural_timing_control_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Production(const ParseTreeNode& node) {}
  virtual void leavePA_Production(const ParseTreeNode& node) {}

  virtual void enterPA_Production_item(const ParseTreeNode& node) {}
  virtual void leavePA_Production_item(const ParseTreeNode& node) {}

  virtual void enterPA_Program_ansi_header(const ParseTreeNode& node) {}
  virtual void leavePA_Program_ansi_header(const ParseTreeNode& node) {}

  virtual void enterPA_Program_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Program_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Program_generate_item(const ParseTreeNode& node) {}
  virtual void leavePA_Program_generate_item(const ParseTreeNode& node) {}

  virtual void enterPA_Program_item(const ParseTreeNode& node) {}
  virtual void leavePA_Program_item(const ParseTreeNode& node) {}

  virtual void enterPA_Program_nonansi_header(const ParseTreeNode& node) {}
  virtual void leavePA_Program_nonansi_header(const ParseTreeNode& node) {}

  virtual void enterPA_Property_actual_arg(const ParseTreeNode& node) {}
  virtual void leavePA_Property_actual_arg(const ParseTreeNode& node) {}

  virtual void enterPA_Property_case_item(const ParseTreeNode& node) {}
  virtual void leavePA_Property_case_item(const ParseTreeNode& node) {}

  virtual void enterPA_Property_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Property_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Property_expr(const ParseTreeNode& node) {}
  virtual void leavePA_Property_expr(const ParseTreeNode& node) {}

  virtual void enterPA_Property_formal_type(const ParseTreeNode& node) {}
  virtual void leavePA_Property_formal_type(const ParseTreeNode& node) {}

  virtual void enterPA_Property_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Property_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Property_lvar_port_direction(const ParseTreeNode& node) {}
  virtual void leavePA_Property_lvar_port_direction(const ParseTreeNode& node) {}

  virtual void enterPA_Property_port_item(const ParseTreeNode& node) {}
  virtual void leavePA_Property_port_item(const ParseTreeNode& node) {}

  virtual void enterPA_Property_port_list(const ParseTreeNode& node) {}
  virtual void leavePA_Property_port_list(const ParseTreeNode& node) {}

  virtual void enterPA_Property_qualifier(const ParseTreeNode& node) {}
  virtual void leavePA_Property_qualifier(const ParseTreeNode& node) {}

  virtual void enterPA_Property_spec(const ParseTreeNode& node) {}
  virtual void leavePA_Property_spec(const ParseTreeNode& node) {}

  virtual void enterPA_Protect_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Protect_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Protected_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Protected_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Ps_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Ps_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Ps_or_hierarchical_array_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Ps_or_hierarchical_array_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Ps_or_hierarchical_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Ps_or_hierarchical_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Ps_or_hierarchical_sequence_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Ps_or_hierarchical_sequence_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Ps_type_identifier(const ParseTreeNode& node) {}
  virtual void leavePA_Ps_type_identifier(const ParseTreeNode& node) {}

  virtual void enterPA_Pull_gate_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Pull_gate_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Pulldown_strength(const ParseTreeNode& node) {}
  virtual void leavePA_Pulldown_strength(const ParseTreeNode& node) {}

  virtual void enterPA_Pullup_strength(const ParseTreeNode& node) {}
  virtual void leavePA_Pullup_strength(const ParseTreeNode& node) {}

  virtual void enterPA_Pulse_control_specparam(const ParseTreeNode& node) {}
  virtual void leavePA_Pulse_control_specparam(const ParseTreeNode& node) {}

  virtual void enterPA_Pulsestyle_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Pulsestyle_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Pure_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Pure_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Pure_virtual_qualifier(const ParseTreeNode& node) {}
  virtual void leavePA_Pure_virtual_qualifier(const ParseTreeNode& node) {}

  virtual void enterPA_Queue_dimension(const ParseTreeNode& node) {}
  virtual void leavePA_Queue_dimension(const ParseTreeNode& node) {}

  virtual void enterPA_Randcase_item(const ParseTreeNode& node) {}
  virtual void leavePA_Randcase_item(const ParseTreeNode& node) {}

  virtual void enterPA_Randcase_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Randcase_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Random_qualifier(const ParseTreeNode& node) {}
  virtual void leavePA_Random_qualifier(const ParseTreeNode& node) {}

  virtual void enterPA_Randomize_call(const ParseTreeNode& node) {}
  virtual void leavePA_Randomize_call(const ParseTreeNode& node) {}

  virtual void enterPA_Randsequence_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Randsequence_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Range_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Range_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Range_list(const ParseTreeNode& node) {}
  virtual void leavePA_Range_list(const ParseTreeNode& node) {}

  virtual void enterPA_Ref_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Ref_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Reference_event(const ParseTreeNode& node) {}
  virtual void leavePA_Reference_event(const ParseTreeNode& node) {}

  virtual void enterPA_Remain_active_flag(const ParseTreeNode& node) {}
  virtual void leavePA_Remain_active_flag(const ParseTreeNode& node) {}

  virtual void enterPA_Remove_gatename_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Remove_gatename_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Remove_netname_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Remove_netname_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Repeat_range(const ParseTreeNode& node) {}
  virtual void leavePA_Repeat_range(const ParseTreeNode& node) {}

  virtual void enterPA_Restrict_property_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Restrict_property_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Rs_case(const ParseTreeNode& node) {}
  virtual void leavePA_Rs_case(const ParseTreeNode& node) {}

  virtual void enterPA_Rs_case_item(const ParseTreeNode& node) {}
  virtual void leavePA_Rs_case_item(const ParseTreeNode& node) {}

  virtual void enterPA_Rs_code_block(const ParseTreeNode& node) {}
  virtual void leavePA_Rs_code_block(const ParseTreeNode& node) {}

  virtual void enterPA_Rs_if_else(const ParseTreeNode& node) {}
  virtual void leavePA_Rs_if_else(const ParseTreeNode& node) {}

  virtual void enterPA_Rs_prod(const ParseTreeNode& node) {}
  virtual void leavePA_Rs_prod(const ParseTreeNode& node) {}

  virtual void enterPA_Rs_production_list(const ParseTreeNode& node) {}
  virtual void leavePA_Rs_production_list(const ParseTreeNode& node) {}

  virtual void enterPA_Rs_repeat(const ParseTreeNode& node) {}
  virtual void leavePA_Rs_repeat(const ParseTreeNode& node) {}

  virtual void enterPA_Rs_rule(const ParseTreeNode& node) {}
  virtual void leavePA_Rs_rule(const ParseTreeNode& node) {}

  virtual void enterPA_Scalar_constant(const ParseTreeNode& node) {}
  virtual void leavePA_Scalar_constant(const ParseTreeNode& node) {}

  virtual void enterPA_Scalar_timing_check_condition(const ParseTreeNode& node) {}
  virtual void leavePA_Scalar_timing_check_condition(const ParseTreeNode& node) {}

  virtual void enterPA_Select(const ParseTreeNode& node) {}
  virtual void leavePA_Select(const ParseTreeNode& node) {}

  virtual void enterPA_Select_condition(const ParseTreeNode& node) {}
  virtual void leavePA_Select_condition(const ParseTreeNode& node) {}

  virtual void enterPA_Select_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Select_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Seq_block(const ParseTreeNode& node) {}
  virtual void leavePA_Seq_block(const ParseTreeNode& node) {}

  virtual void enterPA_Seq_input_list(const ParseTreeNode& node) {}
  virtual void leavePA_Seq_input_list(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_actual_arg(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_actual_arg(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_arg(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_arg(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_expr(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_expr(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_formal_type(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_formal_type(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_list_of_arguments(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_list_of_arguments(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_lvar_port_direction(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_lvar_port_direction(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_match_item(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_match_item(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_method_call(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_method_call(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_port_item(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_port_item(const ParseTreeNode& node) {}

  virtual void enterPA_Sequence_port_list(const ParseTreeNode& node) {}
  virtual void leavePA_Sequence_port_list(const ParseTreeNode& node) {}

  virtual void enterPA_Sequential_body(const ParseTreeNode& node) {}
  virtual void leavePA_Sequential_body(const ParseTreeNode& node) {}

  virtual void enterPA_Sequential_entry(const ParseTreeNode& node) {}
  virtual void leavePA_Sequential_entry(const ParseTreeNode& node) {}

  virtual void enterPA_Showcancelled_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Showcancelled_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Signed_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Signed_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Signing(const ParseTreeNode& node) {}
  virtual void leavePA_Signing(const ParseTreeNode& node) {}

  virtual void enterPA_Simple_immediate_assert_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Simple_immediate_assert_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Simple_immediate_assertion_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Simple_immediate_assertion_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Simple_immediate_assume_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Simple_immediate_assume_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Simple_immediate_cover_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Simple_immediate_cover_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Simple_path_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Simple_path_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Simple_type(const ParseTreeNode& node) {}
  virtual void leavePA_Simple_type(const ParseTreeNode& node) {}

  virtual void enterPA_Slice_size(const ParseTreeNode& node) {}
  virtual void leavePA_Slice_size(const ParseTreeNode& node) {}

  virtual void enterPA_Slline(const ParseTreeNode& node) {}
  virtual void leavePA_Slline(const ParseTreeNode& node) {}

  virtual void enterPA_Solve_before_list(const ParseTreeNode& node) {}
  virtual void leavePA_Solve_before_list(const ParseTreeNode& node) {}

  virtual void enterPA_Source_text(const ParseTreeNode& node) {}
  virtual void leavePA_Source_text(const ParseTreeNode& node) {}

  virtual void enterPA_Specify_block(const ParseTreeNode& node) {}
  virtual void leavePA_Specify_block(const ParseTreeNode& node) {}

  virtual void enterPA_Specify_input_terminal_descriptor(const ParseTreeNode& node) {}
  virtual void leavePA_Specify_input_terminal_descriptor(const ParseTreeNode& node) {}

  virtual void enterPA_Specify_item(const ParseTreeNode& node) {}
  virtual void leavePA_Specify_item(const ParseTreeNode& node) {}

  virtual void enterPA_Specify_output_terminal_descriptor(const ParseTreeNode& node) {}
  virtual void leavePA_Specify_output_terminal_descriptor(const ParseTreeNode& node) {}

  virtual void enterPA_Specify_terminal_descriptor(const ParseTreeNode& node) {}
  virtual void leavePA_Specify_terminal_descriptor(const ParseTreeNode& node) {}

  virtual void enterPA_Specparam_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Specparam_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Specparam_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Specparam_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Stamptime_condition(const ParseTreeNode& node) {}
  virtual void leavePA_Stamptime_condition(const ParseTreeNode& node) {}

  virtual void enterPA_Start_edge_offset(const ParseTreeNode& node) {}
  virtual void leavePA_Start_edge_offset(const ParseTreeNode& node) {}

  virtual void enterPA_State_dependent_path_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_State_dependent_path_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Statement(const ParseTreeNode& node) {}
  virtual void leavePA_Statement(const ParseTreeNode& node) {}

  virtual void enterPA_Statement_item(const ParseTreeNode& node) {}
  virtual void leavePA_Statement_item(const ParseTreeNode& node) {}

  virtual void enterPA_Statement_or_null(const ParseTreeNode& node) {}
  virtual void leavePA_Statement_or_null(const ParseTreeNode& node) {}

  virtual void enterPA_Stream_concatenation(const ParseTreeNode& node) {}
  virtual void leavePA_Stream_concatenation(const ParseTreeNode& node) {}

  virtual void enterPA_Stream_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Stream_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Stream_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Stream_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Streaming_concatenation(const ParseTreeNode& node) {}
  virtual void leavePA_Streaming_concatenation(const ParseTreeNode& node) {}

  virtual void enterPA_Strength0(const ParseTreeNode& node) {}
  virtual void leavePA_Strength0(const ParseTreeNode& node) {}

  virtual void enterPA_Strength1(const ParseTreeNode& node) {}
  virtual void leavePA_Strength1(const ParseTreeNode& node) {}

  virtual void enterPA_String_type(const ParseTreeNode& node) {}
  virtual void leavePA_String_type(const ParseTreeNode& node) {}

  virtual void enterPA_String_value(const ParseTreeNode& node) {}
  virtual void leavePA_String_value(const ParseTreeNode& node) {}

  virtual void enterPA_Struct_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Struct_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Struct_union(const ParseTreeNode& node) {}
  virtual void leavePA_Struct_union(const ParseTreeNode& node) {}

  virtual void enterPA_Struct_union_member(const ParseTreeNode& node) {}
  virtual void leavePA_Struct_union_member(const ParseTreeNode& node) {}

  virtual void enterPA_Structure_pattern_key(const ParseTreeNode& node) {}
  virtual void leavePA_Structure_pattern_key(const ParseTreeNode& node) {}

  virtual void enterPA_Subroutine_call(const ParseTreeNode& node) {}
  virtual void leavePA_Subroutine_call(const ParseTreeNode& node) {}

  virtual void enterPA_Subroutine_call_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Subroutine_call_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Super_dot_new(const ParseTreeNode& node) {}
  virtual void leavePA_Super_dot_new(const ParseTreeNode& node) {}

  virtual void enterPA_Super_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Super_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Suppress_faults_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Suppress_faults_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Surelog_macro_not_defined(const ParseTreeNode& node) {}
  virtual void leavePA_Surelog_macro_not_defined(const ParseTreeNode& node) {}

  virtual void enterPA_System_task(const ParseTreeNode& node) {}
  virtual void leavePA_System_task(const ParseTreeNode& node) {}

  virtual void enterPA_System_task_names(const ParseTreeNode& node) {}
  virtual void leavePA_System_task_names(const ParseTreeNode& node) {}

  virtual void enterPA_System_timing_check(const ParseTreeNode& node) {}
  virtual void leavePA_System_timing_check(const ParseTreeNode& node) {}

  virtual void enterPA_T01_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_T01_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_T0x_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_T0x_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_T0z_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_T0z_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_T10_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_T10_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_T1x_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_T1x_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_T1z_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_T1z_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_T_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_T_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Tagged_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Tagged_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Task_body_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Task_body_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Task_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Task_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Task_name_decl(const ParseTreeNode& node) {}
  virtual void leavePA_Task_name_decl(const ParseTreeNode& node) {}

  virtual void enterPA_Task_prototype(const ParseTreeNode& node) {}
  virtual void leavePA_Task_prototype(const ParseTreeNode& node) {}

  virtual void enterPA_Tf_item_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Tf_item_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Tf_port_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Tf_port_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Tf_port_direction(const ParseTreeNode& node) {}
  virtual void leavePA_Tf_port_direction(const ParseTreeNode& node) {}

  virtual void enterPA_Tf_port_item(const ParseTreeNode& node) {}
  virtual void leavePA_Tf_port_item(const ParseTreeNode& node) {}

  virtual void enterPA_Tf_port_list(const ParseTreeNode& node) {}
  virtual void leavePA_Tf_port_list(const ParseTreeNode& node) {}

  virtual void enterPA_Tfall_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Tfall_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_This_dot_super(const ParseTreeNode& node) {}
  virtual void leavePA_This_dot_super(const ParseTreeNode& node) {}

  virtual void enterPA_This_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_This_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Threshold(const ParseTreeNode& node) {}
  virtual void leavePA_Threshold(const ParseTreeNode& node) {}

  virtual void enterPA_Time_literal(const ParseTreeNode& node) {}
  virtual void leavePA_Time_literal(const ParseTreeNode& node) {}

  virtual void enterPA_Time_unit(const ParseTreeNode& node) {}
  virtual void leavePA_Time_unit(const ParseTreeNode& node) {}

  virtual void enterPA_Timescale_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Timescale_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Timeunits_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Timeunits_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Timing_check_condition(const ParseTreeNode& node) {}
  virtual void leavePA_Timing_check_condition(const ParseTreeNode& node) {}

  virtual void enterPA_Timing_check_event(const ParseTreeNode& node) {}
  virtual void leavePA_Timing_check_event(const ParseTreeNode& node) {}

  virtual void enterPA_Timing_check_event_control(const ParseTreeNode& node) {}
  virtual void leavePA_Timing_check_event_control(const ParseTreeNode& node) {}

  virtual void enterPA_Timing_check_limit(const ParseTreeNode& node) {}
  virtual void leavePA_Timing_check_limit(const ParseTreeNode& node) {}

  virtual void enterPA_Top_directives(const ParseTreeNode& node) {}
  virtual void leavePA_Top_directives(const ParseTreeNode& node) {}

  virtual void enterPA_Top_level_library_rule(const ParseTreeNode& node) {}
  virtual void leavePA_Top_level_library_rule(const ParseTreeNode& node) {}

  virtual void enterPA_Top_level_rule(const ParseTreeNode& node) {}
  virtual void leavePA_Top_level_rule(const ParseTreeNode& node) {}

  virtual void enterPA_Trans_list(const ParseTreeNode& node) {}
  virtual void leavePA_Trans_list(const ParseTreeNode& node) {}

  virtual void enterPA_Trans_range_list(const ParseTreeNode& node) {}
  virtual void leavePA_Trans_range_list(const ParseTreeNode& node) {}

  virtual void enterPA_Trans_set(const ParseTreeNode& node) {}
  virtual void leavePA_Trans_set(const ParseTreeNode& node) {}

  virtual void enterPA_Trise_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Trise_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Tx0_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Tx0_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Tx1_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Tx1_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Txz_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Txz_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Type_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Type_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Type_reference(const ParseTreeNode& node) {}
  virtual void leavePA_Type_reference(const ParseTreeNode& node) {}

  virtual void enterPA_Tz0_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Tz0_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Tz1_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Tz1_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Tz_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Tz_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Tzx_path_delay_expression(const ParseTreeNode& node) {}
  virtual void leavePA_Tzx_path_delay_expression(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_ansi_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_ansi_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_body(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_body(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_declaration_port_list(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_declaration_port_list(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_initial_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_initial_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_input_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_input_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_instance(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_instance(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_instantiation(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_instantiation(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_nonansi_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_nonansi_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_output_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_output_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_port_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_port_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_port_list(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_port_list(const ParseTreeNode& node) {}

  virtual void enterPA_Udp_reg_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Udp_reg_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Unary_module_path_operator(const ParseTreeNode& node) {}
  virtual void leavePA_Unary_module_path_operator(const ParseTreeNode& node) {}

  virtual void enterPA_Unbased_unsized_literal(const ParseTreeNode& node) {}
  virtual void leavePA_Unbased_unsized_literal(const ParseTreeNode& node) {}

  virtual void enterPA_Unconnected_drive_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Unconnected_drive_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Union_keyword(const ParseTreeNode& node) {}
  virtual void leavePA_Union_keyword(const ParseTreeNode& node) {}

  virtual void enterPA_Unique_call(const ParseTreeNode& node) {}
  virtual void leavePA_Unique_call(const ParseTreeNode& node) {}

  virtual void enterPA_Unique_priority(const ParseTreeNode& node) {}
  virtual void leavePA_Unique_priority(const ParseTreeNode& node) {}

  virtual void enterPA_Uniqueness_constraint(const ParseTreeNode& node) {}
  virtual void leavePA_Uniqueness_constraint(const ParseTreeNode& node) {}

  virtual void enterPA_Unpacked_dimension(const ParseTreeNode& node) {}
  virtual void leavePA_Unpacked_dimension(const ParseTreeNode& node) {}

  virtual void enterPA_Unsigned_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Unsigned_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Unsized_dimension(const ParseTreeNode& node) {}
  virtual void leavePA_Unsized_dimension(const ParseTreeNode& node) {}

  virtual void enterPA_Use_clause(const ParseTreeNode& node) {}
  virtual void leavePA_Use_clause(const ParseTreeNode& node) {}

  virtual void enterPA_Use_clause_config(const ParseTreeNode& node) {}
  virtual void leavePA_Use_clause_config(const ParseTreeNode& node) {}

  virtual void enterPA_Uselib_directive(const ParseTreeNode& node) {}
  virtual void leavePA_Uselib_directive(const ParseTreeNode& node) {}

  virtual void enterPA_Value_range(const ParseTreeNode& node) {}
  virtual void leavePA_Value_range(const ParseTreeNode& node) {}

  virtual void enterPA_Var_data_type(const ParseTreeNode& node) {}
  virtual void leavePA_Var_data_type(const ParseTreeNode& node) {}

  virtual void enterPA_Var_type(const ParseTreeNode& node) {}
  virtual void leavePA_Var_type(const ParseTreeNode& node) {}

  virtual void enterPA_Variable_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Variable_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Variable_decl_assignment(const ParseTreeNode& node) {}
  virtual void leavePA_Variable_decl_assignment(const ParseTreeNode& node) {}

  virtual void enterPA_Variable_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Variable_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Variable_dimension(const ParseTreeNode& node) {}
  virtual void leavePA_Variable_dimension(const ParseTreeNode& node) {}

  virtual void enterPA_Variable_impl_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Variable_impl_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Variable_lvalue(const ParseTreeNode& node) {}
  virtual void leavePA_Variable_lvalue(const ParseTreeNode& node) {}

  virtual void enterPA_Variable_port_header(const ParseTreeNode& node) {}
  virtual void leavePA_Variable_port_header(const ParseTreeNode& node) {}

  virtual void enterPA_Variable_port_type(const ParseTreeNode& node) {}
  virtual void leavePA_Variable_port_type(const ParseTreeNode& node) {}

  virtual void enterPA_Virtual_interface_declaration(const ParseTreeNode& node) {}
  virtual void leavePA_Virtual_interface_declaration(const ParseTreeNode& node) {}

  virtual void enterPA_Wait_statement(const ParseTreeNode& node) {}
  virtual void leavePA_Wait_statement(const ParseTreeNode& node) {}

  virtual void enterPA_Xor_call(const ParseTreeNode& node) {}
  virtual void leavePA_Xor_call(const ParseTreeNode& node) {}
  // clang-format on

  // clang-format off
  virtual void visitSL__INVALID_(const ParseTreeNode& node) {}
  virtual void visitSL_NoType(const ParseTreeNode& node) {}
  virtual void visitSL_Null(const ParseTreeNode& node) {}
  virtual void visitSL_IntConst(const ParseTreeNode& node) {}
  virtual void visitSL_RealConst(const ParseTreeNode& node) {}
  virtual void visitSL_StringConst(const ParseTreeNode& node) {}
  virtual void visitSL_StringLiteral(const ParseTreeNode& node) {}
  virtual void visitSL_Unparsable_Text(const ParseTreeNode& node) {}

  virtual void visitPP_ANY(const ParseTreeNode& node) {}
  virtual void visitPP_ASSIGN_OP(const ParseTreeNode& node) {}
  virtual void visitPP_Block_comment(const ParseTreeNode& node) {}
  virtual void visitPP_CHECKER(const ParseTreeNode& node) {}
  virtual void visitPP_CLOSE_BRACKET(const ParseTreeNode& node) {}
  virtual void visitPP_CLOSE_CURLY(const ParseTreeNode& node) {}
  virtual void visitPP_CLOSE_PARENS(const ParseTreeNode& node) {}
  virtual void visitPP_COMMA(const ParseTreeNode& node) {}
  virtual void visitPP_CONFIG(const ParseTreeNode& node) {}
  virtual void visitPP_CR(const ParseTreeNode& node) {}
  virtual void visitPP_DOUBLE_QUOTE(const ParseTreeNode& node) {}
  virtual void visitPP_ENDCHECKER(const ParseTreeNode& node) {}
  virtual void visitPP_ENDCONFIG(const ParseTreeNode& node) {}
  virtual void visitPP_ENDINTERFACE(const ParseTreeNode& node) {}
  virtual void visitPP_ENDMODULE(const ParseTreeNode& node) {}
  virtual void visitPP_ENDPACKAGE(const ParseTreeNode& node) {}
  virtual void visitPP_ENDPRIMITIVE(const ParseTreeNode& node) {}
  virtual void visitPP_ENDPROGRAM(const ParseTreeNode& node) {}
  virtual void visitPP_ESCAPED_CR(const ParseTreeNode& node) {}
  virtual void visitPP_ESCAPED_IDENTIFIER(const ParseTreeNode& node) {}
  virtual void visitPP_Fixed_point_number(const ParseTreeNode& node) {}
  virtual void visitPP_INTEGRAL_NUMBER(const ParseTreeNode& node) {}
  virtual void visitPP_INTERFACE(const ParseTreeNode& node) {}
  virtual void visitPP_MODULE(const ParseTreeNode& node) {}
  virtual void visitPP_Macro_Escaped_identifier(const ParseTreeNode& node) {}
  virtual void visitPP_Macro_identifier(const ParseTreeNode& node) {}
  virtual void visitPP_OPEN_BRACKET(const ParseTreeNode& node) {}
  virtual void visitPP_OPEN_CURLY(const ParseTreeNode& node) {}
  virtual void visitPP_OPEN_PARENS(const ParseTreeNode& node) {}
  virtual void visitPP_One_line_comment(const ParseTreeNode& node) {}
  virtual void visitPP_PACKAGE(const ParseTreeNode& node) {}
  virtual void visitPP_POUND_DELAY(const ParseTreeNode& node) {}
  virtual void visitPP_PRIMITIVE(const ParseTreeNode& node) {}
  virtual void visitPP_PROGRAM(const ParseTreeNode& node) {}
  virtual void visitPP_Pound_Pound_delay(const ParseTreeNode& node) {}
  virtual void visitPP_STRING(const ParseTreeNode& node) {}
  virtual void visitPP_Simple_identifier(const ParseTreeNode& node) {}
  virtual void visitPP_Spaces(const ParseTreeNode& node) {}
  virtual void visitPP_Special(const ParseTreeNode& node) {}
  virtual void visitPP_TEXT_CR(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ACCELERATE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_AUTOEXPAND_VECTORNETS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_BACKSLASH_TICK_QUOTE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_BEGIN_KEYWORDS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_CELLDEFINE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DEFAULT_DECAY_TIME(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DEFAULT_NETTYPE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DEFAULT_TRIREG_STRENGTH(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DEFINE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DELAY_MODE_DISTRIBUTED(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DELAY_MODE_PATH(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DELAY_MODE_UNIT(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DELAY_MODE_ZERO(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_DISABLE_PORTFAULTS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ELSE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ELSEIF(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ELSIF(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ENABLE_PORTFAULTS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ENDCELLDEFINE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ENDIF(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ENDPROTECT(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_ENDPROTECTED(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_END_KEYWORDS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_EXPAND_VECTORNETS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_FILE__(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_IFDEF(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_IFNDEF(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_INCLUDE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_LINE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_LINE__(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_NOACCELERATE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_NOEXPAND_VECTORNETS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_NOREMOVE_GATENAMES(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_NOREMOVE_NETNAMES(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_NOSUPPRESS_FAULTS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_NOUNCONNECTED_DRIVE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_PRAGMA(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_PROTECT(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_PROTECTED(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_QUOTE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_REMOVE_GATENAME(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_REMOVE_NETNAME(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_RESETALL(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_SIGNED(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_SUPPRESS_FAULTS(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_TICK(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_TIMESCALE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_UNCONNECTED_DRIVE(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_UNDEF(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_UNDEFINEALL(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_UNSIGNED(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_USELIB(const ParseTreeNode& node) {}
  virtual void visitPP_TICK_VARIABLE(const ParseTreeNode& node) {}
  virtual void visitPP_TIMESCALE(const ParseTreeNode& node) {}

  virtual void visitPA_ACCEPT_ON(const ParseTreeNode& node) {}
  virtual void visitPA_ADD_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_ALIAS(const ParseTreeNode& node) {}
  virtual void visitPA_ALWAYS(const ParseTreeNode& node) {}
  virtual void visitPA_ALWAYS_COMB(const ParseTreeNode& node) {}
  virtual void visitPA_ALWAYS_FF(const ParseTreeNode& node) {}
  virtual void visitPA_ALWAYS_LATCH(const ParseTreeNode& node) {}
  virtual void visitPA_AND(const ParseTreeNode& node) {}
  virtual void visitPA_ANY(const ParseTreeNode& node) {}
  virtual void visitPA_ARITH_SHIFT_LEFT(const ParseTreeNode& node) {}
  virtual void visitPA_ARITH_SHIFT_LEFT_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_ARITH_SHIFT_RIGHT(const ParseTreeNode& node) {}
  virtual void visitPA_ARITH_SHIFT_RIGHT_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_ASSERT(const ParseTreeNode& node) {}
  virtual void visitPA_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_ASSIGN_OP(const ParseTreeNode& node) {}
  virtual void visitPA_ASSIGN_VALUE(const ParseTreeNode& node) {}
  virtual void visitPA_ASSOCIATIVE_UNSPECIFIED(const ParseTreeNode& node) {}
  virtual void visitPA_ASSUME(const ParseTreeNode& node) {}
  virtual void visitPA_AT(const ParseTreeNode& node) {}
  virtual void visitPA_ATAT(const ParseTreeNode& node) {}
  virtual void visitPA_ATSTAR(const ParseTreeNode& node) {}
  virtual void visitPA_AT_PARENS_STAR(const ParseTreeNode& node) {}
  virtual void visitPA_AUTOMATIC(const ParseTreeNode& node) {}
  virtual void visitPA_BACK_TICK(const ParseTreeNode& node) {}
  virtual void visitPA_BANG(const ParseTreeNode& node) {}
  virtual void visitPA_BEFORE(const ParseTreeNode& node) {}
  virtual void visitPA_BEGIN(const ParseTreeNode& node) {}
  virtual void visitPA_BINARY_WILDCARD_EQUAL(const ParseTreeNode& node) {}
  virtual void visitPA_BINARY_WILDCARD_NOTEQUAL(const ParseTreeNode& node) {}
  virtual void visitPA_BIND(const ParseTreeNode& node) {}
  virtual void visitPA_BINS(const ParseTreeNode& node) {}
  virtual void visitPA_BINSOF(const ParseTreeNode& node) {}
  virtual void visitPA_BIT(const ParseTreeNode& node) {}
  virtual void visitPA_BITW_AND(const ParseTreeNode& node) {}
  virtual void visitPA_BITW_AND_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_BITW_LEFT_SHIFT_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_BITW_OR(const ParseTreeNode& node) {}
  virtual void visitPA_BITW_OR_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_BITW_RIGHT_SHIFT_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_BITW_XOR(const ParseTreeNode& node) {}
  virtual void visitPA_BITW_XOR_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_BREAK(const ParseTreeNode& node) {}
  virtual void visitPA_BUF(const ParseTreeNode& node) {}
  virtual void visitPA_BUFIF0(const ParseTreeNode& node) {}
  virtual void visitPA_BUFIF1(const ParseTreeNode& node) {}
  virtual void visitPA_BYTE(const ParseTreeNode& node) {}
  virtual void visitPA_Block_comment(const ParseTreeNode& node) {}
  virtual void visitPA_CASE(const ParseTreeNode& node) {}
  virtual void visitPA_CASEX(const ParseTreeNode& node) {}
  virtual void visitPA_CASEZ(const ParseTreeNode& node) {}
  virtual void visitPA_CELL(const ParseTreeNode& node) {}
  virtual void visitPA_CHANDLE(const ParseTreeNode& node) {}
  virtual void visitPA_CHECKER(const ParseTreeNode& node) {}
  virtual void visitPA_CLASS(const ParseTreeNode& node) {}
  virtual void visitPA_CLOCKING(const ParseTreeNode& node) {}
  virtual void visitPA_CLOSE_BRACKET(const ParseTreeNode& node) {}
  virtual void visitPA_CLOSE_CURLY(const ParseTreeNode& node) {}
  virtual void visitPA_CLOSE_PARENS(const ParseTreeNode& node) {}
  virtual void visitPA_CMOS(const ParseTreeNode& node) {}
  virtual void visitPA_COLON(const ParseTreeNode& node) {}
  virtual void visitPA_COLONCOLON(const ParseTreeNode& node) {}
  virtual void visitPA_COMMA(const ParseTreeNode& node) {}
  virtual void visitPA_COND_PRED_OP(const ParseTreeNode& node) {}
  virtual void visitPA_CONFIG(const ParseTreeNode& node) {}
  virtual void visitPA_CONSECUTIVE_REP(const ParseTreeNode& node) {}
  virtual void visitPA_CONST(const ParseTreeNode& node) {}
  virtual void visitPA_CONSTRAINT(const ParseTreeNode& node) {}
  virtual void visitPA_CONTEXT(const ParseTreeNode& node) {}
  virtual void visitPA_CONTINUE(const ParseTreeNode& node) {}
  virtual void visitPA_COVER(const ParseTreeNode& node) {}
  virtual void visitPA_COVERGROUP(const ParseTreeNode& node) {}
  virtual void visitPA_COVERPOINT(const ParseTreeNode& node) {}
  virtual void visitPA_CROSS(const ParseTreeNode& node) {}
  virtual void visitPA_DEASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_DEC_PART_SELECT_OP(const ParseTreeNode& node) {}
  virtual void visitPA_DEFAULT(const ParseTreeNode& node) {}
  virtual void visitPA_DEFPARAM(const ParseTreeNode& node) {}
  virtual void visitPA_DESIGN(const ParseTreeNode& node) {}
  virtual void visitPA_DISABLE(const ParseTreeNode& node) {}
  virtual void visitPA_DIST(const ParseTreeNode& node) {}
  virtual void visitPA_DIV(const ParseTreeNode& node) {}
  virtual void visitPA_DIV_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_DO(const ParseTreeNode& node) {}
  virtual void visitPA_DOLLAR(const ParseTreeNode& node) {}
  virtual void visitPA_DOLLAR_ROOT(const ParseTreeNode& node) {}
  virtual void visitPA_DOLLAR_UNIT(const ParseTreeNode& node) {}
  virtual void visitPA_DOT(const ParseTreeNode& node) {}
  virtual void visitPA_DOTSTAR(const ParseTreeNode& node) {}
  virtual void visitPA_EDGE(const ParseTreeNode& node) {}
  virtual void visitPA_ELSE(const ParseTreeNode& node) {}
  virtual void visitPA_END(const ParseTreeNode& node) {}
  virtual void visitPA_ENDCASE(const ParseTreeNode& node) {}
  virtual void visitPA_ENDCHECKER(const ParseTreeNode& node) {}
  virtual void visitPA_ENDCLASS(const ParseTreeNode& node) {}
  virtual void visitPA_ENDCLOCKING(const ParseTreeNode& node) {}
  virtual void visitPA_ENDCONFIG(const ParseTreeNode& node) {}
  virtual void visitPA_ENDFUNCTION(const ParseTreeNode& node) {}
  virtual void visitPA_ENDGENERATE(const ParseTreeNode& node) {}
  virtual void visitPA_ENDGROUP(const ParseTreeNode& node) {}
  virtual void visitPA_ENDINTERFACE(const ParseTreeNode& node) {}
  virtual void visitPA_ENDMODULE(const ParseTreeNode& node) {}
  virtual void visitPA_ENDPACKAGE(const ParseTreeNode& node) {}
  virtual void visitPA_ENDPRIMITIVE(const ParseTreeNode& node) {}
  virtual void visitPA_ENDPROGRAM(const ParseTreeNode& node) {}
  virtual void visitPA_ENDPROPERTY(const ParseTreeNode& node) {}
  virtual void visitPA_ENDSEQUENCE(const ParseTreeNode& node) {}
  virtual void visitPA_ENDSPECIFY(const ParseTreeNode& node) {}
  virtual void visitPA_ENDTABLE(const ParseTreeNode& node) {}
  virtual void visitPA_ENDTASK(const ParseTreeNode& node) {}
  virtual void visitPA_ENUM(const ParseTreeNode& node) {}
  virtual void visitPA_EQUIV(const ParseTreeNode& node) {}
  virtual void visitPA_EQUIVALENCE(const ParseTreeNode& node) {}
  virtual void visitPA_EVENT(const ParseTreeNode& node) {}
  virtual void visitPA_EVENTUALLY(const ParseTreeNode& node) {}
  virtual void visitPA_EXPECT(const ParseTreeNode& node) {}
  virtual void visitPA_EXPORT(const ParseTreeNode& node) {}
  virtual void visitPA_EXTENDS(const ParseTreeNode& node) {}
  virtual void visitPA_EXTERN(const ParseTreeNode& node) {}
  virtual void visitPA_Escaped_identifier(const ParseTreeNode& node) {}
  virtual void visitPA_FINAL(const ParseTreeNode& node) {}
  virtual void visitPA_FIRST_MATCH(const ParseTreeNode& node) {}
  virtual void visitPA_FOR(const ParseTreeNode& node) {}
  virtual void visitPA_FORCE(const ParseTreeNode& node) {}
  virtual void visitPA_FOREACH(const ParseTreeNode& node) {}
  virtual void visitPA_FOREVER(const ParseTreeNode& node) {}
  virtual void visitPA_FORK(const ParseTreeNode& node) {}
  virtual void visitPA_FORKJOIN(const ParseTreeNode& node) {}
  virtual void visitPA_FOUR_STATE_LOGIC_EQUAL(const ParseTreeNode& node) {}
  virtual void visitPA_FOUR_STATE_LOGIC_NOTEQUAL(const ParseTreeNode& node) {}
  virtual void visitPA_FULL_CONN_OP(const ParseTreeNode& node) {}
  virtual void visitPA_FUNCTION(const ParseTreeNode& node) {}
  virtual void visitPA_GENERATE(const ParseTreeNode& node) {}
  virtual void visitPA_GENVAR(const ParseTreeNode& node) {}
  virtual void visitPA_GLOBAL(const ParseTreeNode& node) {}
  virtual void visitPA_GOTO_REP(const ParseTreeNode& node) {}
  virtual void visitPA_GREATER(const ParseTreeNode& node) {}
  virtual void visitPA_GREATER_EQUAL(const ParseTreeNode& node) {}
  virtual void visitPA_HIGHZ0(const ParseTreeNode& node) {}
  virtual void visitPA_HIGHZ1(const ParseTreeNode& node) {}
  virtual void visitPA_IF(const ParseTreeNode& node) {}
  virtual void visitPA_IFF(const ParseTreeNode& node) {}
  virtual void visitPA_IFNONE(const ParseTreeNode& node) {}
  virtual void visitPA_IGNORE_BINS(const ParseTreeNode& node) {}
  virtual void visitPA_ILLEGAL_BINS(const ParseTreeNode& node) {}
  virtual void visitPA_IMPLEMENTS(const ParseTreeNode& node) {}
  virtual void visitPA_IMPLIES(const ParseTreeNode& node) {}
  virtual void visitPA_IMPLY(const ParseTreeNode& node) {}
  virtual void visitPA_IMPORT(const ParseTreeNode& node) {}
  virtual void visitPA_INCDIR(const ParseTreeNode& node) {}
  virtual void visitPA_INCLUDE(const ParseTreeNode& node) {}
  virtual void visitPA_INC_PART_SELECT_OP(const ParseTreeNode& node) {}
  virtual void visitPA_INITIAL(const ParseTreeNode& node) {}
  virtual void visitPA_INOUT(const ParseTreeNode& node) {}
  virtual void visitPA_INPUT(const ParseTreeNode& node) {}
  virtual void visitPA_INSIDE(const ParseTreeNode& node) {}
  virtual void visitPA_INSTANCE(const ParseTreeNode& node) {}
  virtual void visitPA_INT(const ParseTreeNode& node) {}
  virtual void visitPA_INTEGER(const ParseTreeNode& node) {}
  virtual void visitPA_INTERCONNECT(const ParseTreeNode& node) {}
  virtual void visitPA_INTERFACE(const ParseTreeNode& node) {}
  virtual void visitPA_INTERSECT(const ParseTreeNode& node) {}
  virtual void visitPA_Integral_number(const ParseTreeNode& node) {}
  virtual void visitPA_JOIN(const ParseTreeNode& node) {}
  virtual void visitPA_JOIN_ANY(const ParseTreeNode& node) {}
  virtual void visitPA_JOIN_NONE(const ParseTreeNode& node) {}
  virtual void visitPA_LARGE(const ParseTreeNode& node) {}
  virtual void visitPA_LESS(const ParseTreeNode& node) {}
  virtual void visitPA_LESS_EQUAL(const ParseTreeNode& node) {}
  virtual void visitPA_LET(const ParseTreeNode& node) {}
  virtual void visitPA_LIBLIST(const ParseTreeNode& node) {}
  virtual void visitPA_LIBRARY(const ParseTreeNode& node) {}
  virtual void visitPA_LOCAL(const ParseTreeNode& node) {}
  virtual void visitPA_LOCALPARAM(const ParseTreeNode& node) {}
  virtual void visitPA_LOGIC(const ParseTreeNode& node) {}
  virtual void visitPA_LOGICAL_AND(const ParseTreeNode& node) {}
  virtual void visitPA_LOGICAL_OR(const ParseTreeNode& node) {}
  virtual void visitPA_LONGINT(const ParseTreeNode& node) {}
  virtual void visitPA_MACROMODULE(const ParseTreeNode& node) {}
  virtual void visitPA_MATCHES(const ParseTreeNode& node) {}
  virtual void visitPA_MEDIUM(const ParseTreeNode& node) {}
  virtual void visitPA_MINUS(const ParseTreeNode& node) {}
  virtual void visitPA_MINUSMINUS(const ParseTreeNode& node) {}
  virtual void visitPA_MODPORT(const ParseTreeNode& node) {}
  virtual void visitPA_MODULE(const ParseTreeNode& node) {}
  virtual void visitPA_MODULO_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_MULT_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_NAND(const ParseTreeNode& node) {}
  virtual void visitPA_NEGEDGE(const ParseTreeNode& node) {}
  virtual void visitPA_NETTYPE(const ParseTreeNode& node) {}
  virtual void visitPA_NEW(const ParseTreeNode& node) {}
  virtual void visitPA_NEXTTIME(const ParseTreeNode& node) {}
  virtual void visitPA_NMOS(const ParseTreeNode& node) {}
  virtual void visitPA_NONOVERLAPPED(const ParseTreeNode& node) {}
  virtual void visitPA_NON_BLOCKING_TRIGGER_EVENT_OP(const ParseTreeNode& node) {}
  virtual void visitPA_NON_CONSECUTIVE_REP(const ParseTreeNode& node) {}
  virtual void visitPA_NON_OVERLAP_IMPLY(const ParseTreeNode& node) {}
  virtual void visitPA_NOR(const ParseTreeNode& node) {}
  virtual void visitPA_NOSHOWCANCELLED(const ParseTreeNode& node) {}
  virtual void visitPA_NOT(const ParseTreeNode& node) {}
  virtual void visitPA_NOTEQUAL(const ParseTreeNode& node) {}
  virtual void visitPA_NOTIF0(const ParseTreeNode& node) {}
  virtual void visitPA_NOTIF1(const ParseTreeNode& node) {}
  virtual void visitPA_NULL_KEYWORD(const ParseTreeNode& node) {}
  virtual void visitPA_ONESTEP(const ParseTreeNode& node) {}
  virtual void visitPA_ONE_TICK_B0(const ParseTreeNode& node) {}
  virtual void visitPA_ONE_TICK_B1(const ParseTreeNode& node) {}
  virtual void visitPA_ONE_TICK_BX(const ParseTreeNode& node) {}
  virtual void visitPA_ONE_TICK_Bx(const ParseTreeNode& node) {}
  virtual void visitPA_ONE_TICK_b0(const ParseTreeNode& node) {}
  virtual void visitPA_ONE_TICK_b1(const ParseTreeNode& node) {}
  virtual void visitPA_ONE_TICK_bX(const ParseTreeNode& node) {}
  virtual void visitPA_ONE_TICK_bx(const ParseTreeNode& node) {}
  virtual void visitPA_OPEN_BRACKET(const ParseTreeNode& node) {}
  virtual void visitPA_OPEN_CURLY(const ParseTreeNode& node) {}
  virtual void visitPA_OPEN_PARENS(const ParseTreeNode& node) {}
  virtual void visitPA_OPEN_PARENS_STAR(const ParseTreeNode& node) {}
  virtual void visitPA_OPTION_DOT(const ParseTreeNode& node) {}
  virtual void visitPA_OR(const ParseTreeNode& node) {}
  virtual void visitPA_OUTPUT(const ParseTreeNode& node) {}
  virtual void visitPA_OVERLAPPED(const ParseTreeNode& node) {}
  virtual void visitPA_OVERLAP_IMPLY(const ParseTreeNode& node) {}
  virtual void visitPA_One_line_comment(const ParseTreeNode& node) {}
  virtual void visitPA_PACKAGE(const ParseTreeNode& node) {}
  virtual void visitPA_PACKED(const ParseTreeNode& node) {}
  virtual void visitPA_PARAMETER(const ParseTreeNode& node) {}
  virtual void visitPA_PATHPULSE(const ParseTreeNode& node) {}
  virtual void visitPA_PERCENT(const ParseTreeNode& node) {}
  virtual void visitPA_PLUS(const ParseTreeNode& node) {}
  virtual void visitPA_PLUSPLUS(const ParseTreeNode& node) {}
  virtual void visitPA_PMOS(const ParseTreeNode& node) {}
  virtual void visitPA_POSEDGE(const ParseTreeNode& node) {}
  virtual void visitPA_POUND(const ParseTreeNode& node) {}
  virtual void visitPA_POUNDPOUND(const ParseTreeNode& node) {}
  virtual void visitPA_PRIMITIVE(const ParseTreeNode& node) {}
  virtual void visitPA_PRIORITY(const ParseTreeNode& node) {}
  virtual void visitPA_PROGRAM(const ParseTreeNode& node) {}
  virtual void visitPA_PROPERTY(const ParseTreeNode& node) {}
  virtual void visitPA_PROTECTED(const ParseTreeNode& node) {}
  virtual void visitPA_PULL0(const ParseTreeNode& node) {}
  virtual void visitPA_PULL1(const ParseTreeNode& node) {}
  virtual void visitPA_PULLDOWN(const ParseTreeNode& node) {}
  virtual void visitPA_PULLUP(const ParseTreeNode& node) {}
  virtual void visitPA_PULSESTYLE_ONDETECT(const ParseTreeNode& node) {}
  virtual void visitPA_PULSESTYLE_ONEVENT(const ParseTreeNode& node) {}
  virtual void visitPA_PURE(const ParseTreeNode& node) {}
  virtual void visitPA_Pound_Pound_delay(const ParseTreeNode& node) {}
  virtual void visitPA_Pound_delay(const ParseTreeNode& node) {}
  virtual void visitPA_QMARK(const ParseTreeNode& node) {}
  virtual void visitPA_RAND(const ParseTreeNode& node) {}
  virtual void visitPA_RANDC(const ParseTreeNode& node) {}
  virtual void visitPA_RANDCASE(const ParseTreeNode& node) {}
  virtual void visitPA_RANDOMIZE(const ParseTreeNode& node) {}
  virtual void visitPA_RANDSEQUENCE(const ParseTreeNode& node) {}
  virtual void visitPA_RCMOS(const ParseTreeNode& node) {}
  virtual void visitPA_REAL(const ParseTreeNode& node) {}
  virtual void visitPA_REALTIME(const ParseTreeNode& node) {}
  virtual void visitPA_REDUCTION_NAND(const ParseTreeNode& node) {}
  virtual void visitPA_REDUCTION_NOR(const ParseTreeNode& node) {}
  virtual void visitPA_REDUCTION_XNOR1(const ParseTreeNode& node) {}
  virtual void visitPA_REDUCTION_XNOR2(const ParseTreeNode& node) {}
  virtual void visitPA_REF(const ParseTreeNode& node) {}
  virtual void visitPA_REG(const ParseTreeNode& node) {}
  virtual void visitPA_REJECT_ON(const ParseTreeNode& node) {}
  virtual void visitPA_RELEASE(const ParseTreeNode& node) {}
  virtual void visitPA_REPEAT(const ParseTreeNode& node) {}
  virtual void visitPA_RESTRICT(const ParseTreeNode& node) {}
  virtual void visitPA_RETURN(const ParseTreeNode& node) {}
  virtual void visitPA_RNMOS(const ParseTreeNode& node) {}
  virtual void visitPA_RPMOS(const ParseTreeNode& node) {}
  virtual void visitPA_RTRAN(const ParseTreeNode& node) {}
  virtual void visitPA_RTRANIF0(const ParseTreeNode& node) {}
  virtual void visitPA_RTRANIF1(const ParseTreeNode& node) {}
  virtual void visitPA_Real_number(const ParseTreeNode& node) {}
  virtual void visitPA_SAMPLE(const ParseTreeNode& node) {}
  virtual void visitPA_SCALARED(const ParseTreeNode& node) {}
  virtual void visitPA_SEMICOLON(const ParseTreeNode& node) {}
  virtual void visitPA_SEQUENCE(const ParseTreeNode& node) {}
  virtual void visitPA_SHIFT_LEFT(const ParseTreeNode& node) {}
  virtual void visitPA_SHIFT_RIGHT(const ParseTreeNode& node) {}
  virtual void visitPA_SHORTINT(const ParseTreeNode& node) {}
  virtual void visitPA_SHORTREAL(const ParseTreeNode& node) {}
  virtual void visitPA_SHOWCANCELLED(const ParseTreeNode& node) {}
  virtual void visitPA_SIGNED(const ParseTreeNode& node) {}
  virtual void visitPA_SMALL(const ParseTreeNode& node) {}
  virtual void visitPA_SOFT(const ParseTreeNode& node) {}
  virtual void visitPA_SOLVE(const ParseTreeNode& node) {}
  virtual void visitPA_SPECIFY(const ParseTreeNode& node) {}
  virtual void visitPA_SPECPARAM(const ParseTreeNode& node) {}
  virtual void visitPA_STAR(const ParseTreeNode& node) {}
  virtual void visitPA_STARCOLONCOLONSTAR(const ParseTreeNode& node) {}
  virtual void visitPA_STARSTAR(const ParseTreeNode& node) {}
  virtual void visitPA_STAR_CLOSE_PARENS(const ParseTreeNode& node) {}
  virtual void visitPA_STATIC(const ParseTreeNode& node) {}
  virtual void visitPA_STRING(const ParseTreeNode& node) {}
  virtual void visitPA_STRONG(const ParseTreeNode& node) {}
  virtual void visitPA_STRONG0(const ParseTreeNode& node) {}
  virtual void visitPA_STRONG1(const ParseTreeNode& node) {}
  virtual void visitPA_STRUCT(const ParseTreeNode& node) {}
  virtual void visitPA_SUB_ASSIGN(const ParseTreeNode& node) {}
  virtual void visitPA_SUPER(const ParseTreeNode& node) {}
  virtual void visitPA_SUPPLY0(const ParseTreeNode& node) {}
  virtual void visitPA_SUPPLY1(const ParseTreeNode& node) {}
  virtual void visitPA_SURELOG_MACRO_NOT_DEFINED(const ParseTreeNode& node) {}
  virtual void visitPA_SYNC_ACCEPT_ON(const ParseTreeNode& node) {}
  virtual void visitPA_SYNC_REJECT_ON(const ParseTreeNode& node) {}
  virtual void visitPA_S_ALWAYS(const ParseTreeNode& node) {}
  virtual void visitPA_S_EVENTUALLY(const ParseTreeNode& node) {}
  virtual void visitPA_S_NEXTTIME(const ParseTreeNode& node) {}
  virtual void visitPA_S_UNTIL(const ParseTreeNode& node) {}
  virtual void visitPA_S_UNTIL_WITH(const ParseTreeNode& node) {}
  virtual void visitPA_Simple_identifier(const ParseTreeNode& node) {}
  virtual void visitPA_String(const ParseTreeNode& node) {}
  virtual void visitPA_TABLE(const ParseTreeNode& node) {}
  virtual void visitPA_TAGGED(const ParseTreeNode& node) {}
  virtual void visitPA_TASK(const ParseTreeNode& node) {}
  virtual void visitPA_THIS(const ParseTreeNode& node) {}
  virtual void visitPA_THROUGHOUT(const ParseTreeNode& node) {}
  virtual void visitPA_TICK(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_0(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_1(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_ACCELERATE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_AUTOEXPAND_VECTORNETS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_B0(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_B1(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_BEGIN_KEYWORDS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_CELLDEFINE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_DEFAULT_DECAY_TIME(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_DEFAULT_NETTYPE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_DEFAULT_TRIREG_STRENGTH(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_DELAY_MODE_DISTRIBUTED(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_DELAY_MODE_PATH(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_DELAY_MODE_UNIT(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_DELAY_MODE_ZERO(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_DISABLE_PORTFAULTS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_ENABLE_PORTFAULTS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_ENDCELLDEFINE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_ENDPROTECT(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_ENDPROTECTED(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_END_KEYWORDS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_EXPAND_VECTORNETS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_LINE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_NOACCELERATE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_NOEXPAND_VECTORNETS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_NOREMOVE_GATENAMES(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_NOREMOVE_NETNAMES(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_NOSUPPRESS_FAULTS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_NOUNCONNECTED_DRIVE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_PRAGMA(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_PROTECT(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_PROTECTED(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_REMOVE_GATENAME(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_REMOVE_NETNAME(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_SIGNED(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_SUPPRESS_FAULTS(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_TIMESCALE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_UNCONNECTED_DRIVE(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_UNSIGNED(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_USELIB(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_b0(const ParseTreeNode& node) {}
  virtual void visitPA_TICK_b1(const ParseTreeNode& node) {}
  virtual void visitPA_TILDA(const ParseTreeNode& node) {}
  virtual void visitPA_TIME(const ParseTreeNode& node) {}
  virtual void visitPA_TIMEPRECISION(const ParseTreeNode& node) {}
  virtual void visitPA_TIMEUNIT(const ParseTreeNode& node) {}
  virtual void visitPA_TRAN(const ParseTreeNode& node) {}
  virtual void visitPA_TRANIF0(const ParseTreeNode& node) {}
  virtual void visitPA_TRANIF1(const ParseTreeNode& node) {}
  virtual void visitPA_TRANSITION_OP(const ParseTreeNode& node) {}
  virtual void visitPA_TRI(const ParseTreeNode& node) {}
  virtual void visitPA_TRI0(const ParseTreeNode& node) {}
  virtual void visitPA_TRI1(const ParseTreeNode& node) {}
  virtual void visitPA_TRIAND(const ParseTreeNode& node) {}
  virtual void visitPA_TRIOR(const ParseTreeNode& node) {}
  virtual void visitPA_TRIREG(const ParseTreeNode& node) {}
  virtual void visitPA_TYPE(const ParseTreeNode& node) {}
  virtual void visitPA_TYPEDEF(const ParseTreeNode& node) {}
  virtual void visitPA_TYPE_OPTION_DOT(const ParseTreeNode& node) {}
  virtual void visitPA_UNION(const ParseTreeNode& node) {}
  virtual void visitPA_UNIQUE(const ParseTreeNode& node) {}
  virtual void visitPA_UNIQUE0(const ParseTreeNode& node) {}
  virtual void visitPA_UNSIGNED(const ParseTreeNode& node) {}
  virtual void visitPA_UNTIL(const ParseTreeNode& node) {}
  virtual void visitPA_UNTIL_WITH(const ParseTreeNode& node) {}
  virtual void visitPA_UNTYPED(const ParseTreeNode& node) {}
  virtual void visitPA_USE(const ParseTreeNode& node) {}
  virtual void visitPA_UWIRE(const ParseTreeNode& node) {}
  virtual void visitPA_VAR(const ParseTreeNode& node) {}
  virtual void visitPA_VECTORED(const ParseTreeNode& node) {}
  virtual void visitPA_VIRTUAL(const ParseTreeNode& node) {}
  virtual void visitPA_VOID(const ParseTreeNode& node) {}
  virtual void visitPA_WAIT(const ParseTreeNode& node) {}
  virtual void visitPA_WAIT_ORDER(const ParseTreeNode& node) {}
  virtual void visitPA_WAND(const ParseTreeNode& node) {}
  virtual void visitPA_WEAK(const ParseTreeNode& node) {}
  virtual void visitPA_WEAK0(const ParseTreeNode& node) {}
  virtual void visitPA_WEAK1(const ParseTreeNode& node) {}
  virtual void visitPA_WHILE(const ParseTreeNode& node) {}
  virtual void visitPA_WILDCARD(const ParseTreeNode& node) {}
  virtual void visitPA_WILD_EQUAL_OP(const ParseTreeNode& node) {}
  virtual void visitPA_WILD_NOTEQUAL_OP(const ParseTreeNode& node) {}
  virtual void visitPA_WIRE(const ParseTreeNode& node) {}
  virtual void visitPA_WITH(const ParseTreeNode& node) {}
  virtual void visitPA_WITHIN(const ParseTreeNode& node) {}
  virtual void visitPA_WOR(const ParseTreeNode& node) {}
  virtual void visitPA_White_space(const ParseTreeNode& node) {}
  virtual void visitPA_XNOR(const ParseTreeNode& node) {}
  virtual void visitPA_XOR(const ParseTreeNode& node) {}
  // clang-format on

  void listen(const ParseTreeNode& node);
  void listenChildren(const ParseTreeNode& node, bool ordered);
  void listenSiblings(const ParseTreeNode& node, bool ordered);

  void listen(PathId fileId, const VObject* objects, size_t count,
              const SymbolTable* symbolTable);

  VObjectType getNodeType(const ParseTreeNode& node) const;
  ParseTreeNode getRootNode() const;
  bool getNodeText(const ParseTreeNode& node, std::string& text) const;
  bool getNodeFileId(const ParseTreeNode& node, PathId& fileId) const;
  bool getNodeStartLocation(const ParseTreeNode& node, int32_t& line,
                            int32_t& column) const;
  bool getNodeEndLocation(const ParseTreeNode& node, int32_t& line,
                          int32_t& column) const;
  bool getNodeLocation(const ParseTreeNode& node, int32_t& startLine,
                       int32_t& startColumn, int32_t& endLine,
                       int32_t& endColumn) const;
  ParseTreeNode getNodeParent(const ParseTreeNode& node) const;
  ParseTreeNode getNodePrevSibling(const ParseTreeNode& node) const;
  ParseTreeNode getNodeNextSibling(const ParseTreeNode& node) const;
  bool getNodeChildren(const ParseTreeNode& node, bool ordered,
                       parsetreenode_vector_t& children) const;
  bool getNodeSiblings(const ParseTreeNode& node, bool ordered,
                       parsetreenode_vector_t& siblings) const;

 private:
  // clang-format off
  void listenPP_Accelerate_directive(const ParseTreeNode& node);
  void listenPP_Autoexpand_vectornets_directive(const ParseTreeNode& node);
  void listenPP_Begin_keywords_directive(const ParseTreeNode& node);
  void listenPP_Celldefine_directive(const ParseTreeNode& node);
  void listenPP_Checker(const ParseTreeNode& node);
  void listenPP_Comment(const ParseTreeNode& node);
  void listenPP_Config(const ParseTreeNode& node);
  void listenPP_Default_decay_time_directive(const ParseTreeNode& node);
  void listenPP_Default_nettype_directive(const ParseTreeNode& node);
  void listenPP_Default_trireg_strength_directive(const ParseTreeNode& node);
  void listenPP_Default_value(const ParseTreeNode& node);
  void listenPP_Define_directive(const ParseTreeNode& node);
  void listenPP_Delay_mode_distributed_directive(const ParseTreeNode& node);
  void listenPP_Delay_mode_path_directive(const ParseTreeNode& node);
  void listenPP_Delay_mode_unit_directive(const ParseTreeNode& node);
  void listenPP_Delay_mode_zero_directive(const ParseTreeNode& node);
  void listenPP_Description(const ParseTreeNode& node);
  void listenPP_Directive_in_macro(const ParseTreeNode& node);
  void listenPP_Disable_portfaults_directive(const ParseTreeNode& node);
  void listenPP_Else_directive(const ParseTreeNode& node);
  void listenPP_Elseif_directive(const ParseTreeNode& node);
  void listenPP_Elseif_directive_in_macro_body(const ParseTreeNode& node);
  void listenPP_Elsif_directive(const ParseTreeNode& node);
  void listenPP_Elsif_directive_in_macro_body(const ParseTreeNode& node);
  void listenPP_Enable_portfaults_directive(const ParseTreeNode& node);
  void listenPP_End_keywords_directive(const ParseTreeNode& node);
  void listenPP_Endcelldefine_directive(const ParseTreeNode& node);
  void listenPP_Endchecker(const ParseTreeNode& node);
  void listenPP_Endconfig(const ParseTreeNode& node);
  void listenPP_Endif_directive(const ParseTreeNode& node);
  void listenPP_Endinterface(const ParseTreeNode& node);
  void listenPP_Endmodule(const ParseTreeNode& node);
  void listenPP_Endpackage(const ParseTreeNode& node);
  void listenPP_Endprimitive(const ParseTreeNode& node);
  void listenPP_Endprogram(const ParseTreeNode& node);
  void listenPP_Endprotect_directive(const ParseTreeNode& node);
  void listenPP_Endprotected_directive(const ParseTreeNode& node);
  void listenPP_Escaped_identifier(const ParseTreeNode& node);
  void listenPP_Escaped_macro_definition_body(const ParseTreeNode& node);
  void listenPP_Escaped_macro_definition_body_alt1(const ParseTreeNode& node);
  void listenPP_Escaped_macro_definition_body_alt2(const ParseTreeNode& node);
  void listenPP_Expand_vectornets_directive(const ParseTreeNode& node);
  void listenPP_Identifier_in_macro_body(const ParseTreeNode& node);
  void listenPP_Ifdef_directive(const ParseTreeNode& node);
  void listenPP_Ifdef_directive_in_macro_body(const ParseTreeNode& node);
  void listenPP_Ifndef_directive(const ParseTreeNode& node);
  void listenPP_Ifndef_directive_in_macro_body(const ParseTreeNode& node);
  void listenPP_Include_directive(const ParseTreeNode& node);
  void listenPP_Integral_number(const ParseTreeNode& node);
  void listenPP_Line_directive(const ParseTreeNode& node);
  void listenPP_Macro_actual_args(const ParseTreeNode& node);
  void listenPP_Macro_arg(const ParseTreeNode& node);
  void listenPP_Macro_arguments(const ParseTreeNode& node);
  void listenPP_Macro_definition(const ParseTreeNode& node);
  void listenPP_Macro_instance(const ParseTreeNode& node);
  void listenPP_Module(const ParseTreeNode& node);
  void listenPP_Multiline_args_macro_definition(const ParseTreeNode& node);
  void listenPP_Multiline_no_args_macro_definition(const ParseTreeNode& node);
  void listenPP_Noaccelerate_directive(const ParseTreeNode& node);
  void listenPP_Noexpand_vectornets_directive(const ParseTreeNode& node);
  void listenPP_Noremove_gatenames_directive(const ParseTreeNode& node);
  void listenPP_Noremove_netnames_directive(const ParseTreeNode& node);
  void listenPP_Nosuppress_faults_directive(const ParseTreeNode& node);
  void listenPP_Nounconnected_drive_directive(const ParseTreeNode& node);
  void listenPP_Null_rule(const ParseTreeNode& node);
  void listenPP_Paired_parens(const ParseTreeNode& node);
  void listenPP_Pound_delay(const ParseTreeNode& node);
  void listenPP_Pound_pound_delay(const ParseTreeNode& node);
  void listenPP_Pragma_directive(const ParseTreeNode& node);
  void listenPP_Pragma_expression(const ParseTreeNode& node);
  void listenPP_Primitive(const ParseTreeNode& node);
  void listenPP_Program(const ParseTreeNode& node);
  void listenPP_Protect_directive(const ParseTreeNode& node);
  void listenPP_Protected_directive(const ParseTreeNode& node);
  void listenPP_Remove_gatename_directive(const ParseTreeNode& node);
  void listenPP_Remove_netname_directive(const ParseTreeNode& node);
  void listenPP_Resetall_directive(const ParseTreeNode& node);
  void listenPP_Signed_directive(const ParseTreeNode& node);
  void listenPP_Simple_args_macro_definition(const ParseTreeNode& node);
  void listenPP_Simple_args_macro_definition_in_macro_body(const ParseTreeNode& node);
  void listenPP_Simple_macro_definition_body(const ParseTreeNode& node);
  void listenPP_Simple_macro_definition_body_in_macro_body(const ParseTreeNode& node);
  void listenPP_Simple_no_args_macro_definition(const ParseTreeNode& node);
  void listenPP_Simple_no_args_macro_definition_in_macro_body(const ParseTreeNode& node);
  void listenPP_Source_text(const ParseTreeNode& node);
  void listenPP_String(const ParseTreeNode& node);
  void listenPP_String_blob(const ParseTreeNode& node);
  void listenPP_Suppress_faults_directive(const ParseTreeNode& node);
  void listenPP_Sv_file_directive(const ParseTreeNode& node);
  void listenPP_Sv_interface(const ParseTreeNode& node);
  void listenPP_Sv_line_directive(const ParseTreeNode& node);
  void listenPP_Sv_package(const ParseTreeNode& node);
  void listenPP_Text_blob(const ParseTreeNode& node);
  void listenPP_Timescale_directive(const ParseTreeNode& node);
  void listenPP_Top_level_rule(const ParseTreeNode& node);
  void listenPP_Unconnected_drive_directive(const ParseTreeNode& node);
  void listenPP_Undef_directive(const ParseTreeNode& node);
  void listenPP_Undefineall_directive(const ParseTreeNode& node);
  void listenPP_Unsigned_directive(const ParseTreeNode& node);
  void listenPP_Unterminated_string(const ParseTreeNode& node);
  void listenPP_Uselib_directive(const ParseTreeNode& node);

  void listenPA_Accelerate_directive(const ParseTreeNode& node);
  void listenPA_Action_block(const ParseTreeNode& node);
  void listenPA_Actual_arg_expr(const ParseTreeNode& node);
  void listenPA_Actual_arg_list(const ParseTreeNode& node);
  void listenPA_Always_construct(const ParseTreeNode& node);
  void listenPA_Always_keyword(const ParseTreeNode& node);
  void listenPA_And_call(const ParseTreeNode& node);
  void listenPA_Anonymous_program(const ParseTreeNode& node);
  void listenPA_Anonymous_program_item(const ParseTreeNode& node);
  void listenPA_Ansi_port_declaration(const ParseTreeNode& node);
  void listenPA_Argument(const ParseTreeNode& node);
  void listenPA_Array_manipulation_call(const ParseTreeNode& node);
  void listenPA_Array_member_label(const ParseTreeNode& node);
  void listenPA_Array_method_name(const ParseTreeNode& node);
  void listenPA_Array_pattern_key(const ParseTreeNode& node);
  void listenPA_Array_range_expression(const ParseTreeNode& node);
  void listenPA_Assert_property_statement(const ParseTreeNode& node);
  void listenPA_Assertion_item(const ParseTreeNode& node);
  void listenPA_Assertion_item_declaration(const ParseTreeNode& node);
  void listenPA_Assertion_variable_declaration(const ParseTreeNode& node);
  void listenPA_Assignment_operator(const ParseTreeNode& node);
  void listenPA_Assignment_pattern(const ParseTreeNode& node);
  void listenPA_Assignment_pattern_expression(const ParseTreeNode& node);
  void listenPA_Assignment_pattern_expression_type(const ParseTreeNode& node);
  void listenPA_Assignment_pattern_key(const ParseTreeNode& node);
  void listenPA_Assignment_pattern_net_lvalue(const ParseTreeNode& node);
  void listenPA_Assignment_pattern_variable_lvalue(const ParseTreeNode& node);
  void listenPA_Associative_dimension(const ParseTreeNode& node);
  void listenPA_Assume_property_statement(const ParseTreeNode& node);
  void listenPA_Attr_name(const ParseTreeNode& node);
  void listenPA_Attr_spec(const ParseTreeNode& node);
  void listenPA_Attribute_instance(const ParseTreeNode& node);
  void listenPA_Autoexpand_vectornets_directive(const ParseTreeNode& node);
  void listenPA_Begin_keywords_directive(const ParseTreeNode& node);
  void listenPA_Binary_module_path_operator(const ParseTreeNode& node);
  void listenPA_Bind_directive(const ParseTreeNode& node);
  void listenPA_Bind_instantiation(const ParseTreeNode& node);
  void listenPA_Bins_expression(const ParseTreeNode& node);
  void listenPA_Bins_keyword(const ParseTreeNode& node);
  void listenPA_Bins_or_empty(const ParseTreeNode& node);
  void listenPA_Bins_or_options(const ParseTreeNode& node);
  void listenPA_Bins_selection(const ParseTreeNode& node);
  void listenPA_Bins_selection_or_option(const ParseTreeNode& node);
  void listenPA_Bit_select(const ParseTreeNode& node);
  void listenPA_Block_event_expression(const ParseTreeNode& node);
  void listenPA_Block_item_declaration(const ParseTreeNode& node);
  void listenPA_Blocking_assignment(const ParseTreeNode& node);
  void listenPA_Boolean_abbrev(const ParseTreeNode& node);
  void listenPA_Built_in_method_call(const ParseTreeNode& node);
  void listenPA_Case_generate_construct(const ParseTreeNode& node);
  void listenPA_Case_generate_item(const ParseTreeNode& node);
  void listenPA_Case_inside_item(const ParseTreeNode& node);
  void listenPA_Case_item(const ParseTreeNode& node);
  void listenPA_Case_keyword(const ParseTreeNode& node);
  void listenPA_Case_pattern_item(const ParseTreeNode& node);
  void listenPA_Case_statement(const ParseTreeNode& node);
  void listenPA_Cast(const ParseTreeNode& node);
  void listenPA_Casting_type(const ParseTreeNode& node);
  void listenPA_Cell_clause(const ParseTreeNode& node);
  void listenPA_Celldefine_directive(const ParseTreeNode& node);
  void listenPA_Chandle_type(const ParseTreeNode& node);
  void listenPA_Charge_strength(const ParseTreeNode& node);
  void listenPA_Checker_declaration(const ParseTreeNode& node);
  void listenPA_Checker_generate_item(const ParseTreeNode& node);
  void listenPA_Checker_instantiation(const ParseTreeNode& node);
  void listenPA_Checker_or_generate_item(const ParseTreeNode& node);
  void listenPA_Checker_or_generate_item_declaration(const ParseTreeNode& node);
  void listenPA_Checker_port_item(const ParseTreeNode& node);
  void listenPA_Checker_port_list(const ParseTreeNode& node);
  void listenPA_Class_constraint(const ParseTreeNode& node);
  void listenPA_Class_constructor_declaration(const ParseTreeNode& node);
  void listenPA_Class_constructor_prototype(const ParseTreeNode& node);
  void listenPA_Class_declaration(const ParseTreeNode& node);
  void listenPA_Class_item(const ParseTreeNode& node);
  void listenPA_Class_item_qualifier(const ParseTreeNode& node);
  void listenPA_Class_keyword(const ParseTreeNode& node);
  void listenPA_Class_method(const ParseTreeNode& node);
  void listenPA_Class_new(const ParseTreeNode& node);
  void listenPA_Class_property(const ParseTreeNode& node);
  void listenPA_Class_scope(const ParseTreeNode& node);
  void listenPA_Class_type(const ParseTreeNode& node);
  void listenPA_Clocking_decl_assign(const ParseTreeNode& node);
  void listenPA_Clocking_declaration(const ParseTreeNode& node);
  void listenPA_Clocking_direction(const ParseTreeNode& node);
  void listenPA_Clocking_drive(const ParseTreeNode& node);
  void listenPA_Clocking_event(const ParseTreeNode& node);
  void listenPA_Clocking_item(const ParseTreeNode& node);
  void listenPA_Clocking_skew(const ParseTreeNode& node);
  void listenPA_Clockvar(const ParseTreeNode& node);
  void listenPA_Clockvar_expression(const ParseTreeNode& node);
  void listenPA_Cmos_switch_instance(const ParseTreeNode& node);
  void listenPA_Cmos_switchtype(const ParseTreeNode& node);
  void listenPA_Combinational_body(const ParseTreeNode& node);
  void listenPA_Combinational_entry(const ParseTreeNode& node);
  void listenPA_Comma(const ParseTreeNode& node);
  void listenPA_Comma_operator(const ParseTreeNode& node);
  void listenPA_Complex_func_call(const ParseTreeNode& node);
  void listenPA_Concatenation(const ParseTreeNode& node);
  void listenPA_Concurrent_assertion_item(const ParseTreeNode& node);
  void listenPA_Concurrent_assertion_item_declaration(const ParseTreeNode& node);
  void listenPA_Concurrent_assertion_statement(const ParseTreeNode& node);
  void listenPA_Cond_predicate(const ParseTreeNode& node);
  void listenPA_Conditional_generate_construct(const ParseTreeNode& node);
  void listenPA_Conditional_operator(const ParseTreeNode& node);
  void listenPA_Conditional_statement(const ParseTreeNode& node);
  void listenPA_Config_declaration(const ParseTreeNode& node);
  void listenPA_Config_rule_statement(const ParseTreeNode& node);
  void listenPA_Consecutive_repetition(const ParseTreeNode& node);
  void listenPA_Const_or_range_expression(const ParseTreeNode& node);
  void listenPA_Const_type(const ParseTreeNode& node);
  void listenPA_Constant_assignment_pattern_expression(const ParseTreeNode& node);
  void listenPA_Constant_bit_select(const ParseTreeNode& node);
  void listenPA_Constant_cast(const ParseTreeNode& node);
  void listenPA_Constant_concatenation(const ParseTreeNode& node);
  void listenPA_Constant_expression(const ParseTreeNode& node);
  void listenPA_Constant_indexed_range(const ParseTreeNode& node);
  void listenPA_Constant_mintypmax_expression(const ParseTreeNode& node);
  void listenPA_Constant_multiple_concatenation(const ParseTreeNode& node);
  void listenPA_Constant_param_expression(const ParseTreeNode& node);
  void listenPA_Constant_part_select_range(const ParseTreeNode& node);
  void listenPA_Constant_primary(const ParseTreeNode& node);
  void listenPA_Constant_range(const ParseTreeNode& node);
  void listenPA_Constant_range_expression(const ParseTreeNode& node);
  void listenPA_Constant_select(const ParseTreeNode& node);
  void listenPA_Constraint_block(const ParseTreeNode& node);
  void listenPA_Constraint_block_item(const ParseTreeNode& node);
  void listenPA_Constraint_declaration(const ParseTreeNode& node);
  void listenPA_Constraint_expression(const ParseTreeNode& node);
  void listenPA_Constraint_primary(const ParseTreeNode& node);
  void listenPA_Constraint_prototype(const ParseTreeNode& node);
  void listenPA_Constraint_set(const ParseTreeNode& node);
  void listenPA_Context_keyword(const ParseTreeNode& node);
  void listenPA_Continuous_assign(const ParseTreeNode& node);
  void listenPA_Controlled_timing_check_event(const ParseTreeNode& node);
  void listenPA_Cover_cross(const ParseTreeNode& node);
  void listenPA_Cover_point(const ParseTreeNode& node);
  void listenPA_Cover_property_statement(const ParseTreeNode& node);
  void listenPA_Cover_sequence_statement(const ParseTreeNode& node);
  void listenPA_Coverage_event(const ParseTreeNode& node);
  void listenPA_Coverage_option(const ParseTreeNode& node);
  void listenPA_Coverage_spec(const ParseTreeNode& node);
  void listenPA_Coverage_spec_or_option(const ParseTreeNode& node);
  void listenPA_Covergroup_declaration(const ParseTreeNode& node);
  void listenPA_Cross_body(const ParseTreeNode& node);
  void listenPA_Cross_body_item(const ParseTreeNode& node);
  void listenPA_Cross_item(const ParseTreeNode& node);
  void listenPA_Cycle_delay(const ParseTreeNode& node);
  void listenPA_Cycle_delay_const_range_expression(const ParseTreeNode& node);
  void listenPA_Cycle_delay_range(const ParseTreeNode& node);
  void listenPA_Data_declaration(const ParseTreeNode& node);
  void listenPA_Data_type(const ParseTreeNode& node);
  void listenPA_Data_type_or_implicit(const ParseTreeNode& node);
  void listenPA_Data_type_or_void(const ParseTreeNode& node);
  void listenPA_Default_clause(const ParseTreeNode& node);
  void listenPA_Default_decay_time_directive(const ParseTreeNode& node);
  void listenPA_Default_nettype_directive(const ParseTreeNode& node);
  void listenPA_Default_skew(const ParseTreeNode& node);
  void listenPA_Default_trireg_strenght_directive(const ParseTreeNode& node);
  void listenPA_Deferred_immediate_assert_statement(const ParseTreeNode& node);
  void listenPA_Deferred_immediate_assertion_item(const ParseTreeNode& node);
  void listenPA_Deferred_immediate_assertion_statement(const ParseTreeNode& node);
  void listenPA_Deferred_immediate_assume_statement(const ParseTreeNode& node);
  void listenPA_Deferred_immediate_cover_statement(const ParseTreeNode& node);
  void listenPA_Defparam_assignment(const ParseTreeNode& node);
  void listenPA_Delay2(const ParseTreeNode& node);
  void listenPA_Delay3(const ParseTreeNode& node);
  void listenPA_Delay_control(const ParseTreeNode& node);
  void listenPA_Delay_mode_distributed_directive(const ParseTreeNode& node);
  void listenPA_Delay_mode_path_directive(const ParseTreeNode& node);
  void listenPA_Delay_mode_unit_directive(const ParseTreeNode& node);
  void listenPA_Delay_mode_zero_directive(const ParseTreeNode& node);
  void listenPA_Delay_or_event_control(const ParseTreeNode& node);
  void listenPA_Delay_value(const ParseTreeNode& node);
  void listenPA_Delayed_data(const ParseTreeNode& node);
  void listenPA_Delayed_reference(const ParseTreeNode& node);
  void listenPA_Description(const ParseTreeNode& node);
  void listenPA_Design_statement(const ParseTreeNode& node);
  void listenPA_Disable_portfaults_directive(const ParseTreeNode& node);
  void listenPA_Disable_statement(const ParseTreeNode& node);
  void listenPA_Dist_item(const ParseTreeNode& node);
  void listenPA_Dist_list(const ParseTreeNode& node);
  void listenPA_Dist_weight(const ParseTreeNode& node);
  void listenPA_Dollar_fullskew_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_hold_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_keyword(const ParseTreeNode& node);
  void listenPA_Dollar_nochange_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_period_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_recovery_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_recrem_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_removal_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_root_keyword(const ParseTreeNode& node);
  void listenPA_Dollar_setup_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_setuphold_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_skew_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_timeskew_timing_check(const ParseTreeNode& node);
  void listenPA_Dollar_width_timing_check(const ParseTreeNode& node);
  void listenPA_Dpi_import_export(const ParseTreeNode& node);
  void listenPA_Drive_strength(const ParseTreeNode& node);
  void listenPA_Dynamic_array_new(const ParseTreeNode& node);
  void listenPA_Edge_control_specifier(const ParseTreeNode& node);
  void listenPA_Edge_descriptor(const ParseTreeNode& node);
  void listenPA_Edge_identifier(const ParseTreeNode& node);
  void listenPA_Edge_indicator(const ParseTreeNode& node);
  void listenPA_Edge_input_list(const ParseTreeNode& node);
  void listenPA_Edge_sensitive_path_declaration(const ParseTreeNode& node);
  void listenPA_Edge_symbol(const ParseTreeNode& node);
  void listenPA_Elaboration_system_task(const ParseTreeNode& node);
  void listenPA_Empty_queue(const ParseTreeNode& node);
  void listenPA_Enable_gate_instance(const ParseTreeNode& node);
  void listenPA_Enable_gatetype(const ParseTreeNode& node);
  void listenPA_Enable_portfaults_directive(const ParseTreeNode& node);
  void listenPA_End_edge_offset(const ParseTreeNode& node);
  void listenPA_End_keywords_directive(const ParseTreeNode& node);
  void listenPA_Endcelldefine_directive(const ParseTreeNode& node);
  void listenPA_Endprotect_directive(const ParseTreeNode& node);
  void listenPA_Endprotected_directive(const ParseTreeNode& node);
  void listenPA_Enum_base_type(const ParseTreeNode& node);
  void listenPA_Enum_keyword(const ParseTreeNode& node);
  void listenPA_Enum_name_declaration(const ParseTreeNode& node);
  void listenPA_Event_based_flag(const ParseTreeNode& node);
  void listenPA_Event_control(const ParseTreeNode& node);
  void listenPA_Event_expression(const ParseTreeNode& node);
  void listenPA_Event_trigger(const ParseTreeNode& node);
  void listenPA_Event_type(const ParseTreeNode& node);
  void listenPA_Expand_vectornets_directive(const ParseTreeNode& node);
  void listenPA_Expect_property_statement(const ParseTreeNode& node);
  void listenPA_Expression(const ParseTreeNode& node);
  void listenPA_Expression_or_cond_pattern(const ParseTreeNode& node);
  void listenPA_Expression_or_dist(const ParseTreeNode& node);
  void listenPA_Extern_constraint_declaration(const ParseTreeNode& node);
  void listenPA_Extern_qualifier(const ParseTreeNode& node);
  void listenPA_Extern_tf_declaration(const ParseTreeNode& node);
  void listenPA_File_path_spec(const ParseTreeNode& node);
  void listenPA_Final_construct(const ParseTreeNode& node);
  void listenPA_For_initialization(const ParseTreeNode& node);
  void listenPA_For_step(const ParseTreeNode& node);
  void listenPA_For_step_assignment(const ParseTreeNode& node);
  void listenPA_For_variable_declaration(const ParseTreeNode& node);
  void listenPA_Full_edge_sensitive_path_description(const ParseTreeNode& node);
  void listenPA_Full_path_description(const ParseTreeNode& node);
  void listenPA_Function_body_declaration(const ParseTreeNode& node);
  void listenPA_Function_data_type(const ParseTreeNode& node);
  void listenPA_Function_data_type_or_implicit(const ParseTreeNode& node);
  void listenPA_Function_declaration(const ParseTreeNode& node);
  void listenPA_Function_name_decl(const ParseTreeNode& node);
  void listenPA_Function_prototype(const ParseTreeNode& node);
  void listenPA_Function_statement_or_null(const ParseTreeNode& node);
  void listenPA_Gate_instantiation(const ParseTreeNode& node);
  void listenPA_Generate_begin_end_block(const ParseTreeNode& node);
  void listenPA_Generate_interface_block(const ParseTreeNode& node);
  void listenPA_Generate_interface_case_statement(const ParseTreeNode& node);
  void listenPA_Generate_interface_conditional_statement(const ParseTreeNode& node);
  void listenPA_Generate_interface_item(const ParseTreeNode& node);
  void listenPA_Generate_interface_loop_statement(const ParseTreeNode& node);
  void listenPA_Generate_interface_named_block(const ParseTreeNode& node);
  void listenPA_Generate_item(const ParseTreeNode& node);
  void listenPA_Generate_module_block(const ParseTreeNode& node);
  void listenPA_Generate_module_case_statement(const ParseTreeNode& node);
  void listenPA_Generate_module_conditional_statement(const ParseTreeNode& node);
  void listenPA_Generate_module_item(const ParseTreeNode& node);
  void listenPA_Generate_module_loop_statement(const ParseTreeNode& node);
  void listenPA_Generate_module_named_block(const ParseTreeNode& node);
  void listenPA_Generate_region(const ParseTreeNode& node);
  void listenPA_Generated_interface_instantiation(const ParseTreeNode& node);
  void listenPA_Generated_module_instantiation(const ParseTreeNode& node);
  void listenPA_Genvar_assignment(const ParseTreeNode& node);
  void listenPA_Genvar_decl_assignment(const ParseTreeNode& node);
  void listenPA_Genvar_declaration(const ParseTreeNode& node);
  void listenPA_Genvar_initialization(const ParseTreeNode& node);
  void listenPA_Genvar_interface_case_item(const ParseTreeNode& node);
  void listenPA_Genvar_iteration(const ParseTreeNode& node);
  void listenPA_Genvar_module_case_item(const ParseTreeNode& node);
  void listenPA_Goto_repetition(const ParseTreeNode& node);
  void listenPA_Hierarchical_btf_identifier(const ParseTreeNode& node);
  void listenPA_Hierarchical_identifier(const ParseTreeNode& node);
  void listenPA_Hierarchical_instance(const ParseTreeNode& node);
  void listenPA_Identifier(const ParseTreeNode& node);
  void listenPA_Identifier_list(const ParseTreeNode& node);
  void listenPA_If_generate_construct(const ParseTreeNode& node);
  void listenPA_Immediate_assertion_statement(const ParseTreeNode& node);
  void listenPA_Implicit_class_handle(const ParseTreeNode& node);
  void listenPA_Implicit_data_type(const ParseTreeNode& node);
  void listenPA_Inc_or_dec_expression(const ParseTreeNode& node);
  void listenPA_Inc_or_dec_operator(const ParseTreeNode& node);
  void listenPA_Include_statement(const ParseTreeNode& node);
  void listenPA_Indexed_range(const ParseTreeNode& node);
  void listenPA_Init_val(const ParseTreeNode& node);
  void listenPA_Initial_construct(const ParseTreeNode& node);
  void listenPA_Inout_declaration(const ParseTreeNode& node);
  void listenPA_Input_declaration(const ParseTreeNode& node);
  void listenPA_Inst_clause(const ParseTreeNode& node);
  void listenPA_Inst_name(const ParseTreeNode& node);
  void listenPA_Integer_atom_type(const ParseTreeNode& node);
  void listenPA_Integer_type(const ParseTreeNode& node);
  void listenPA_Integer_vector_type(const ParseTreeNode& node);
  void listenPA_Interface_ansi_header(const ParseTreeNode& node);
  void listenPA_Interface_class_declaration(const ParseTreeNode& node);
  void listenPA_Interface_class_item(const ParseTreeNode& node);
  void listenPA_Interface_class_keyword(const ParseTreeNode& node);
  void listenPA_Interface_class_method(const ParseTreeNode& node);
  void listenPA_Interface_class_type(const ParseTreeNode& node);
  void listenPA_Interface_declaration(const ParseTreeNode& node);
  void listenPA_Interface_identifier(const ParseTreeNode& node);
  void listenPA_Interface_item(const ParseTreeNode& node);
  void listenPA_Interface_nonansi_header(const ParseTreeNode& node);
  void listenPA_Interface_or_generate_item(const ParseTreeNode& node);
  void listenPA_Interface_port_declaration(const ParseTreeNode& node);
  void listenPA_Interface_port_header(const ParseTreeNode& node);
  void listenPA_Join_any_keyword(const ParseTreeNode& node);
  void listenPA_Join_keyword(const ParseTreeNode& node);
  void listenPA_Join_none_keyword(const ParseTreeNode& node);
  void listenPA_Jump_statement(const ParseTreeNode& node);
  void listenPA_Let_declaration(const ParseTreeNode& node);
  void listenPA_Let_formal_type(const ParseTreeNode& node);
  void listenPA_Let_port_item(const ParseTreeNode& node);
  void listenPA_Let_port_list(const ParseTreeNode& node);
  void listenPA_Level_input_list(const ParseTreeNode& node);
  void listenPA_Level_symbol(const ParseTreeNode& node);
  void listenPA_Liblist_clause(const ParseTreeNode& node);
  void listenPA_Library_declaration(const ParseTreeNode& node);
  void listenPA_Library_descriptions(const ParseTreeNode& node);
  void listenPA_Library_text(const ParseTreeNode& node);
  void listenPA_Lifetime(const ParseTreeNode& node);
  void listenPA_List_of_arguments(const ParseTreeNode& node);
  void listenPA_List_of_checker_port_connections(const ParseTreeNode& node);
  void listenPA_List_of_clocking_decl_assign(const ParseTreeNode& node);
  void listenPA_List_of_cross_items(const ParseTreeNode& node);
  void listenPA_List_of_defparam_assignments(const ParseTreeNode& node);
  void listenPA_List_of_interface_identifiers(const ParseTreeNode& node);
  void listenPA_List_of_net_assignments(const ParseTreeNode& node);
  void listenPA_List_of_net_decl_assignments(const ParseTreeNode& node);
  void listenPA_List_of_param_assignments(const ParseTreeNode& node);
  void listenPA_List_of_parameter_assignments(const ParseTreeNode& node);
  void listenPA_List_of_path_delay_expressions(const ParseTreeNode& node);
  void listenPA_List_of_path_inputs(const ParseTreeNode& node);
  void listenPA_List_of_path_outputs(const ParseTreeNode& node);
  void listenPA_List_of_port_connections(const ParseTreeNode& node);
  void listenPA_List_of_port_declarations(const ParseTreeNode& node);
  void listenPA_List_of_port_identifiers(const ParseTreeNode& node);
  void listenPA_List_of_ports(const ParseTreeNode& node);
  void listenPA_List_of_specparam_assignments(const ParseTreeNode& node);
  void listenPA_List_of_tf_variable_identifiers(const ParseTreeNode& node);
  void listenPA_List_of_type_assignments(const ParseTreeNode& node);
  void listenPA_List_of_variable_assignments(const ParseTreeNode& node);
  void listenPA_List_of_variable_decl_assignments(const ParseTreeNode& node);
  void listenPA_List_of_variable_identifiers(const ParseTreeNode& node);
  void listenPA_List_of_variable_port_identifiers(const ParseTreeNode& node);
  void listenPA_List_of_virtual_interface_decl(const ParseTreeNode& node);
  void listenPA_Local_parameter_declaration(const ParseTreeNode& node);
  void listenPA_Loop_generate_construct(const ParseTreeNode& node);
  void listenPA_Loop_statement(const ParseTreeNode& node);
  void listenPA_Loop_variables(const ParseTreeNode& node);
  void listenPA_Matches(const ParseTreeNode& node);
  void listenPA_Method_call(const ParseTreeNode& node);
  void listenPA_Method_call_body(const ParseTreeNode& node);
  void listenPA_Method_call_root(const ParseTreeNode& node);
  void listenPA_Method_prototype(const ParseTreeNode& node);
  void listenPA_Method_qualifier(const ParseTreeNode& node);
  void listenPA_Mintypmax_expression(const ParseTreeNode& node);
  void listenPA_Modport_hierarchical_ports_declaration(const ParseTreeNode& node);
  void listenPA_Modport_item(const ParseTreeNode& node);
  void listenPA_Modport_ports_declaration(const ParseTreeNode& node);
  void listenPA_Modport_simple_port(const ParseTreeNode& node);
  void listenPA_Modport_simple_ports_declaration(const ParseTreeNode& node);
  void listenPA_Modport_tf_port(const ParseTreeNode& node);
  void listenPA_Modport_tf_ports_declaration(const ParseTreeNode& node);
  void listenPA_Module_ansi_header(const ParseTreeNode& node);
  void listenPA_Module_common_item(const ParseTreeNode& node);
  void listenPA_Module_declaration(const ParseTreeNode& node);
  void listenPA_Module_instantiation(const ParseTreeNode& node);
  void listenPA_Module_item(const ParseTreeNode& node);
  void listenPA_Module_keyword(const ParseTreeNode& node);
  void listenPA_Module_nonansi_header(const ParseTreeNode& node);
  void listenPA_Module_or_generate_item(const ParseTreeNode& node);
  void listenPA_Module_or_generate_item_declaration(const ParseTreeNode& node);
  void listenPA_Module_path_concatenation(const ParseTreeNode& node);
  void listenPA_Module_path_expression(const ParseTreeNode& node);
  void listenPA_Module_path_mintypmax_expression(const ParseTreeNode& node);
  void listenPA_Module_path_multiple_concatenation(const ParseTreeNode& node);
  void listenPA_Module_path_primary(const ParseTreeNode& node);
  void listenPA_Mos_switch_instance(const ParseTreeNode& node);
  void listenPA_Mos_switchtype(const ParseTreeNode& node);
  void listenPA_Multiple_concatenation(const ParseTreeNode& node);
  void listenPA_N_input_gate_instance(const ParseTreeNode& node);
  void listenPA_N_input_gatetype(const ParseTreeNode& node);
  void listenPA_N_output_gate_instance(const ParseTreeNode& node);
  void listenPA_N_output_gatetype(const ParseTreeNode& node);
  void listenPA_Name_of_instance(const ParseTreeNode& node);
  void listenPA_Named_checker_port_connection(const ParseTreeNode& node);
  void listenPA_Named_parameter_assignment(const ParseTreeNode& node);
  void listenPA_Named_port_connection(const ParseTreeNode& node);
  void listenPA_Net_alias(const ParseTreeNode& node);
  void listenPA_Net_assignment(const ParseTreeNode& node);
  void listenPA_Net_decl_assignment(const ParseTreeNode& node);
  void listenPA_Net_declaration(const ParseTreeNode& node);
  void listenPA_Net_lvalue(const ParseTreeNode& node);
  void listenPA_Net_port_header(const ParseTreeNode& node);
  void listenPA_Net_port_type(const ParseTreeNode& node);
  void listenPA_Net_type(const ParseTreeNode& node);
  void listenPA_Net_type_declaration(const ParseTreeNode& node);
  void listenPA_Next_state(const ParseTreeNode& node);
  void listenPA_Noaccelerate_directive(const ParseTreeNode& node);
  void listenPA_Noexpand_vectornets_directive(const ParseTreeNode& node);
  void listenPA_Non_consecutive_repetition(const ParseTreeNode& node);
  void listenPA_Non_integer_type(const ParseTreeNode& node);
  void listenPA_Non_port_interface_item(const ParseTreeNode& node);
  void listenPA_Non_port_module_item(const ParseTreeNode& node);
  void listenPA_Non_port_program_item(const ParseTreeNode& node);
  void listenPA_Nonblocking_assignment(const ParseTreeNode& node);
  void listenPA_Nonrange_select(const ParseTreeNode& node);
  void listenPA_Nonrange_variable_lvalue(const ParseTreeNode& node);
  void listenPA_Noremove_gatenames_directive(const ParseTreeNode& node);
  void listenPA_Noremove_netnames_directive(const ParseTreeNode& node);
  void listenPA_Nosuppress_faults_directive(const ParseTreeNode& node);
  void listenPA_Notifier(const ParseTreeNode& node);
  void listenPA_Nounconnected_drive_directive(const ParseTreeNode& node);
  void listenPA_Null_keyword(const ParseTreeNode& node);
  void listenPA_Null_rule(const ParseTreeNode& node);
  void listenPA_Number(const ParseTreeNode& node);
  void listenPA_Open_range_list(const ParseTreeNode& node);
  void listenPA_Operator_assignment(const ParseTreeNode& node);
  void listenPA_Or_call(const ParseTreeNode& node);
  void listenPA_Or_operator(const ParseTreeNode& node);
  void listenPA_Ordered_checker_port_connection(const ParseTreeNode& node);
  void listenPA_Ordered_parameter_assignment(const ParseTreeNode& node);
  void listenPA_Ordered_port_connection(const ParseTreeNode& node);
  void listenPA_Output_declaration(const ParseTreeNode& node);
  void listenPA_Output_symbol(const ParseTreeNode& node);
  void listenPA_Overload_declaration(const ParseTreeNode& node);
  void listenPA_Overload_operator(const ParseTreeNode& node);
  void listenPA_Overload_proto_formals(const ParseTreeNode& node);
  void listenPA_Package_declaration(const ParseTreeNode& node);
  void listenPA_Package_export_declaration(const ParseTreeNode& node);
  void listenPA_Package_import_declaration(const ParseTreeNode& node);
  void listenPA_Package_import_item(const ParseTreeNode& node);
  void listenPA_Package_item(const ParseTreeNode& node);
  void listenPA_Package_or_generate_item_declaration(const ParseTreeNode& node);
  void listenPA_Package_scope(const ParseTreeNode& node);
  void listenPA_Packed_dimension(const ParseTreeNode& node);
  void listenPA_Packed_keyword(const ParseTreeNode& node);
  void listenPA_Par_block(const ParseTreeNode& node);
  void listenPA_Parallel_edge_sensitive_path_description(const ParseTreeNode& node);
  void listenPA_Parallel_path_description(const ParseTreeNode& node);
  void listenPA_Param_assignment(const ParseTreeNode& node);
  void listenPA_Param_expression(const ParseTreeNode& node);
  void listenPA_Parameter_declaration(const ParseTreeNode& node);
  void listenPA_Parameter_override(const ParseTreeNode& node);
  void listenPA_Parameter_port_declaration(const ParseTreeNode& node);
  void listenPA_Parameter_port_list(const ParseTreeNode& node);
  void listenPA_Parameter_value_assignment(const ParseTreeNode& node);
  void listenPA_Part_select_op(const ParseTreeNode& node);
  void listenPA_Part_select_op_colon(const ParseTreeNode& node);
  void listenPA_Part_select_range(const ParseTreeNode& node);
  void listenPA_Pass_en_switchtype(const ParseTreeNode& node);
  void listenPA_Pass_enable_switch_instance(const ParseTreeNode& node);
  void listenPA_Pass_switch_instance(const ParseTreeNode& node);
  void listenPA_Pass_switchtype(const ParseTreeNode& node);
  void listenPA_Path_declaration(const ParseTreeNode& node);
  void listenPA_Path_delay_expression(const ParseTreeNode& node);
  void listenPA_Path_delay_value(const ParseTreeNode& node);
  void listenPA_Pattern(const ParseTreeNode& node);
  void listenPA_Port(const ParseTreeNode& node);
  void listenPA_Port_declaration(const ParseTreeNode& node);
  void listenPA_Port_direction(const ParseTreeNode& node);
  void listenPA_Port_expression(const ParseTreeNode& node);
  void listenPA_Port_reference(const ParseTreeNode& node);
  void listenPA_Pound_delay_value(const ParseTreeNode& node);
  void listenPA_Pragma_directive(const ParseTreeNode& node);
  void listenPA_Pragma_expression(const ParseTreeNode& node);
  void listenPA_Pragma_value(const ParseTreeNode& node);
  void listenPA_Primary(const ParseTreeNode& node);
  void listenPA_Primary_literal(const ParseTreeNode& node);
  void listenPA_Procedural_assertion_statement(const ParseTreeNode& node);
  void listenPA_Procedural_continuous_assignment(const ParseTreeNode& node);
  void listenPA_Procedural_timing_control(const ParseTreeNode& node);
  void listenPA_Procedural_timing_control_statement(const ParseTreeNode& node);
  void listenPA_Production(const ParseTreeNode& node);
  void listenPA_Production_item(const ParseTreeNode& node);
  void listenPA_Program_ansi_header(const ParseTreeNode& node);
  void listenPA_Program_declaration(const ParseTreeNode& node);
  void listenPA_Program_generate_item(const ParseTreeNode& node);
  void listenPA_Program_item(const ParseTreeNode& node);
  void listenPA_Program_nonansi_header(const ParseTreeNode& node);
  void listenPA_Property_actual_arg(const ParseTreeNode& node);
  void listenPA_Property_case_item(const ParseTreeNode& node);
  void listenPA_Property_declaration(const ParseTreeNode& node);
  void listenPA_Property_expr(const ParseTreeNode& node);
  void listenPA_Property_formal_type(const ParseTreeNode& node);
  void listenPA_Property_instance(const ParseTreeNode& node);
  void listenPA_Property_lvar_port_direction(const ParseTreeNode& node);
  void listenPA_Property_port_item(const ParseTreeNode& node);
  void listenPA_Property_port_list(const ParseTreeNode& node);
  void listenPA_Property_qualifier(const ParseTreeNode& node);
  void listenPA_Property_spec(const ParseTreeNode& node);
  void listenPA_Protect_directive(const ParseTreeNode& node);
  void listenPA_Protected_directive(const ParseTreeNode& node);
  void listenPA_Ps_identifier(const ParseTreeNode& node);
  void listenPA_Ps_or_hierarchical_array_identifier(const ParseTreeNode& node);
  void listenPA_Ps_or_hierarchical_identifier(const ParseTreeNode& node);
  void listenPA_Ps_or_hierarchical_sequence_identifier(const ParseTreeNode& node);
  void listenPA_Ps_type_identifier(const ParseTreeNode& node);
  void listenPA_Pull_gate_instance(const ParseTreeNode& node);
  void listenPA_Pulldown_strength(const ParseTreeNode& node);
  void listenPA_Pullup_strength(const ParseTreeNode& node);
  void listenPA_Pulse_control_specparam(const ParseTreeNode& node);
  void listenPA_Pulsestyle_declaration(const ParseTreeNode& node);
  void listenPA_Pure_keyword(const ParseTreeNode& node);
  void listenPA_Pure_virtual_qualifier(const ParseTreeNode& node);
  void listenPA_Queue_dimension(const ParseTreeNode& node);
  void listenPA_Randcase_item(const ParseTreeNode& node);
  void listenPA_Randcase_statement(const ParseTreeNode& node);
  void listenPA_Random_qualifier(const ParseTreeNode& node);
  void listenPA_Randomize_call(const ParseTreeNode& node);
  void listenPA_Randsequence_statement(const ParseTreeNode& node);
  void listenPA_Range_expression(const ParseTreeNode& node);
  void listenPA_Range_list(const ParseTreeNode& node);
  void listenPA_Ref_declaration(const ParseTreeNode& node);
  void listenPA_Reference_event(const ParseTreeNode& node);
  void listenPA_Remain_active_flag(const ParseTreeNode& node);
  void listenPA_Remove_gatename_directive(const ParseTreeNode& node);
  void listenPA_Remove_netname_directive(const ParseTreeNode& node);
  void listenPA_Repeat_range(const ParseTreeNode& node);
  void listenPA_Restrict_property_statement(const ParseTreeNode& node);
  void listenPA_Rs_case(const ParseTreeNode& node);
  void listenPA_Rs_case_item(const ParseTreeNode& node);
  void listenPA_Rs_code_block(const ParseTreeNode& node);
  void listenPA_Rs_if_else(const ParseTreeNode& node);
  void listenPA_Rs_prod(const ParseTreeNode& node);
  void listenPA_Rs_production_list(const ParseTreeNode& node);
  void listenPA_Rs_repeat(const ParseTreeNode& node);
  void listenPA_Rs_rule(const ParseTreeNode& node);
  void listenPA_Scalar_constant(const ParseTreeNode& node);
  void listenPA_Scalar_timing_check_condition(const ParseTreeNode& node);
  void listenPA_Select(const ParseTreeNode& node);
  void listenPA_Select_condition(const ParseTreeNode& node);
  void listenPA_Select_expression(const ParseTreeNode& node);
  void listenPA_Seq_block(const ParseTreeNode& node);
  void listenPA_Seq_input_list(const ParseTreeNode& node);
  void listenPA_Sequence_actual_arg(const ParseTreeNode& node);
  void listenPA_Sequence_arg(const ParseTreeNode& node);
  void listenPA_Sequence_declaration(const ParseTreeNode& node);
  void listenPA_Sequence_expr(const ParseTreeNode& node);
  void listenPA_Sequence_formal_type(const ParseTreeNode& node);
  void listenPA_Sequence_instance(const ParseTreeNode& node);
  void listenPA_Sequence_list_of_arguments(const ParseTreeNode& node);
  void listenPA_Sequence_lvar_port_direction(const ParseTreeNode& node);
  void listenPA_Sequence_match_item(const ParseTreeNode& node);
  void listenPA_Sequence_method_call(const ParseTreeNode& node);
  void listenPA_Sequence_port_item(const ParseTreeNode& node);
  void listenPA_Sequence_port_list(const ParseTreeNode& node);
  void listenPA_Sequential_body(const ParseTreeNode& node);
  void listenPA_Sequential_entry(const ParseTreeNode& node);
  void listenPA_Showcancelled_declaration(const ParseTreeNode& node);
  void listenPA_Signed_directive(const ParseTreeNode& node);
  void listenPA_Signing(const ParseTreeNode& node);
  void listenPA_Simple_immediate_assert_statement(const ParseTreeNode& node);
  void listenPA_Simple_immediate_assertion_statement(const ParseTreeNode& node);
  void listenPA_Simple_immediate_assume_statement(const ParseTreeNode& node);
  void listenPA_Simple_immediate_cover_statement(const ParseTreeNode& node);
  void listenPA_Simple_path_declaration(const ParseTreeNode& node);
  void listenPA_Simple_type(const ParseTreeNode& node);
  void listenPA_Slice_size(const ParseTreeNode& node);
  void listenPA_Slline(const ParseTreeNode& node);
  void listenPA_Solve_before_list(const ParseTreeNode& node);
  void listenPA_Source_text(const ParseTreeNode& node);
  void listenPA_Specify_block(const ParseTreeNode& node);
  void listenPA_Specify_input_terminal_descriptor(const ParseTreeNode& node);
  void listenPA_Specify_item(const ParseTreeNode& node);
  void listenPA_Specify_output_terminal_descriptor(const ParseTreeNode& node);
  void listenPA_Specify_terminal_descriptor(const ParseTreeNode& node);
  void listenPA_Specparam_assignment(const ParseTreeNode& node);
  void listenPA_Specparam_declaration(const ParseTreeNode& node);
  void listenPA_Stamptime_condition(const ParseTreeNode& node);
  void listenPA_Start_edge_offset(const ParseTreeNode& node);
  void listenPA_State_dependent_path_declaration(const ParseTreeNode& node);
  void listenPA_Statement(const ParseTreeNode& node);
  void listenPA_Statement_item(const ParseTreeNode& node);
  void listenPA_Statement_or_null(const ParseTreeNode& node);
  void listenPA_Stream_concatenation(const ParseTreeNode& node);
  void listenPA_Stream_expression(const ParseTreeNode& node);
  void listenPA_Stream_operator(const ParseTreeNode& node);
  void listenPA_Streaming_concatenation(const ParseTreeNode& node);
  void listenPA_Strength0(const ParseTreeNode& node);
  void listenPA_Strength1(const ParseTreeNode& node);
  void listenPA_String_type(const ParseTreeNode& node);
  void listenPA_String_value(const ParseTreeNode& node);
  void listenPA_Struct_keyword(const ParseTreeNode& node);
  void listenPA_Struct_union(const ParseTreeNode& node);
  void listenPA_Struct_union_member(const ParseTreeNode& node);
  void listenPA_Structure_pattern_key(const ParseTreeNode& node);
  void listenPA_Subroutine_call(const ParseTreeNode& node);
  void listenPA_Subroutine_call_statement(const ParseTreeNode& node);
  void listenPA_Super_dot_new(const ParseTreeNode& node);
  void listenPA_Super_keyword(const ParseTreeNode& node);
  void listenPA_Suppress_faults_directive(const ParseTreeNode& node);
  void listenPA_Surelog_macro_not_defined(const ParseTreeNode& node);
  void listenPA_System_task(const ParseTreeNode& node);
  void listenPA_System_task_names(const ParseTreeNode& node);
  void listenPA_System_timing_check(const ParseTreeNode& node);
  void listenPA_T01_path_delay_expression(const ParseTreeNode& node);
  void listenPA_T0x_path_delay_expression(const ParseTreeNode& node);
  void listenPA_T0z_path_delay_expression(const ParseTreeNode& node);
  void listenPA_T10_path_delay_expression(const ParseTreeNode& node);
  void listenPA_T1x_path_delay_expression(const ParseTreeNode& node);
  void listenPA_T1z_path_delay_expression(const ParseTreeNode& node);
  void listenPA_T_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Tagged_keyword(const ParseTreeNode& node);
  void listenPA_Task_body_declaration(const ParseTreeNode& node);
  void listenPA_Task_declaration(const ParseTreeNode& node);
  void listenPA_Task_name_decl(const ParseTreeNode& node);
  void listenPA_Task_prototype(const ParseTreeNode& node);
  void listenPA_Tf_item_declaration(const ParseTreeNode& node);
  void listenPA_Tf_port_declaration(const ParseTreeNode& node);
  void listenPA_Tf_port_direction(const ParseTreeNode& node);
  void listenPA_Tf_port_item(const ParseTreeNode& node);
  void listenPA_Tf_port_list(const ParseTreeNode& node);
  void listenPA_Tfall_path_delay_expression(const ParseTreeNode& node);
  void listenPA_This_dot_super(const ParseTreeNode& node);
  void listenPA_This_keyword(const ParseTreeNode& node);
  void listenPA_Threshold(const ParseTreeNode& node);
  void listenPA_Time_literal(const ParseTreeNode& node);
  void listenPA_Time_unit(const ParseTreeNode& node);
  void listenPA_Timescale_directive(const ParseTreeNode& node);
  void listenPA_Timeunits_declaration(const ParseTreeNode& node);
  void listenPA_Timing_check_condition(const ParseTreeNode& node);
  void listenPA_Timing_check_event(const ParseTreeNode& node);
  void listenPA_Timing_check_event_control(const ParseTreeNode& node);
  void listenPA_Timing_check_limit(const ParseTreeNode& node);
  void listenPA_Top_directives(const ParseTreeNode& node);
  void listenPA_Top_level_library_rule(const ParseTreeNode& node);
  void listenPA_Top_level_rule(const ParseTreeNode& node);
  void listenPA_Trans_list(const ParseTreeNode& node);
  void listenPA_Trans_range_list(const ParseTreeNode& node);
  void listenPA_Trans_set(const ParseTreeNode& node);
  void listenPA_Trise_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Tx0_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Tx1_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Txz_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Type_declaration(const ParseTreeNode& node);
  void listenPA_Type_reference(const ParseTreeNode& node);
  void listenPA_Tz0_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Tz1_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Tz_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Tzx_path_delay_expression(const ParseTreeNode& node);
  void listenPA_Udp_ansi_declaration(const ParseTreeNode& node);
  void listenPA_Udp_body(const ParseTreeNode& node);
  void listenPA_Udp_declaration(const ParseTreeNode& node);
  void listenPA_Udp_declaration_port_list(const ParseTreeNode& node);
  void listenPA_Udp_initial_statement(const ParseTreeNode& node);
  void listenPA_Udp_input_declaration(const ParseTreeNode& node);
  void listenPA_Udp_instance(const ParseTreeNode& node);
  void listenPA_Udp_instantiation(const ParseTreeNode& node);
  void listenPA_Udp_nonansi_declaration(const ParseTreeNode& node);
  void listenPA_Udp_output_declaration(const ParseTreeNode& node);
  void listenPA_Udp_port_declaration(const ParseTreeNode& node);
  void listenPA_Udp_port_list(const ParseTreeNode& node);
  void listenPA_Udp_reg_declaration(const ParseTreeNode& node);
  void listenPA_Unary_module_path_operator(const ParseTreeNode& node);
  void listenPA_Unbased_unsized_literal(const ParseTreeNode& node);
  void listenPA_Unconnected_drive_directive(const ParseTreeNode& node);
  void listenPA_Union_keyword(const ParseTreeNode& node);
  void listenPA_Unique_call(const ParseTreeNode& node);
  void listenPA_Unique_priority(const ParseTreeNode& node);
  void listenPA_Uniqueness_constraint(const ParseTreeNode& node);
  void listenPA_Unpacked_dimension(const ParseTreeNode& node);
  void listenPA_Unsigned_directive(const ParseTreeNode& node);
  void listenPA_Unsized_dimension(const ParseTreeNode& node);
  void listenPA_Use_clause(const ParseTreeNode& node);
  void listenPA_Use_clause_config(const ParseTreeNode& node);
  void listenPA_Uselib_directive(const ParseTreeNode& node);
  void listenPA_Value_range(const ParseTreeNode& node);
  void listenPA_Var_data_type(const ParseTreeNode& node);
  void listenPA_Var_type(const ParseTreeNode& node);
  void listenPA_Variable_assignment(const ParseTreeNode& node);
  void listenPA_Variable_decl_assignment(const ParseTreeNode& node);
  void listenPA_Variable_declaration(const ParseTreeNode& node);
  void listenPA_Variable_dimension(const ParseTreeNode& node);
  void listenPA_Variable_impl_declaration(const ParseTreeNode& node);
  void listenPA_Variable_lvalue(const ParseTreeNode& node);
  void listenPA_Variable_port_header(const ParseTreeNode& node);
  void listenPA_Variable_port_type(const ParseTreeNode& node);
  void listenPA_Virtual_interface_declaration(const ParseTreeNode& node);
  void listenPA_Wait_statement(const ParseTreeNode& node);
  void listenPA_Xor_call(const ParseTreeNode& node);
  // clang-format on

 protected:
  parsetreenode_set_t m_visited;
  parsetreenode_stack_t m_callstack;

 private:
  const VObject* m_objects = nullptr;
  size_t m_count = 0;
  const SymbolTable* m_symbolTable = nullptr;
};
}  // namespace SURELOG

#endif  // SURELOG_PARSETREELISTENER_H
