/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   property_spec.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_PROPERTY_SPEC_H
#define UHDM_PROPERTY_SPEC_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "expr_dist.h"
#include "property_expr_group.h"


namespace UHDM {
class expr;

class property_spec final : public BaseClass {
  UHDM_IMPLEMENT_RTTI(property_spec, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: property_spec();
  virtual ~property_spec() final = default;

  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; return true; }

  virtual bool VpiFile(const std::filesystem::path& data) final;

  virtual SymbolFactory::ID VpiFileId() const final { return vpiFile_; }

  virtual std::filesystem::path VpiFile() const final;

  virtual unsigned int UhdmId() const final { return uhdmId_; }

  virtual bool UhdmId(unsigned int data) final { uhdmId_ = data; return true; }

  const any* VpiDisableCondition() const { return vpiDisableCondition_; }

  bool VpiDisableCondition(any* data) { if (!expr_distGroupCompliant(data)) return false; vpiDisableCondition_ = data; return true; }

  const expr* VpiClockingEvent() const { return vpiClockingEvent_; }

  bool VpiClockingEvent(expr* data) { vpiClockingEvent_ = data; return true; }

  const any* VpiPropertyExpr() const { return vpiPropertyExpr_; }

  bool VpiPropertyExpr(any* data) { if (!property_expr_groupGroupCompliant(data)) return false; vpiPropertyExpr_ = data; return true; }

  virtual unsigned int VpiType() const final { return vpiPropertySpec; }

  virtual property_spec* DeepClone(Serializer* serializer, ElaboratorListener* elaborator, BaseClass* parent) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int property) const override;

  virtual int Compare(const BaseClass* const other, AnySet& visited) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmproperty_spec; }

protected:
  void DeepCopy(property_spec* clone, Serializer* serializer,
                ElaboratorListener* elaborator, BaseClass* parent) const;

private:
  BaseClass* vpiParent_ = nullptr;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  any* vpiDisableCondition_ = nullptr;

  expr* vpiClockingEvent_ = nullptr;

  any* vpiPropertyExpr_ = nullptr;
};


typedef FactoryT<property_spec> property_specFactory;


typedef FactoryT<std::vector<property_spec *>> VectorOfproperty_specFactory;

}  // namespace UHDM

#endif
