/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   task_func.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_TASK_FUNC_H
#define UHDM_TASK_FUNC_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "scope.h"

#include "stmt.h"


namespace UHDM {
class task_func  : public scope {
public:
  // Implicit constructor used to initialize all members,
  // comment: task_func();
  virtual ~task_func()  {}
  
  task_func* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override = 0;

  bool VpiMethod() const { return vpiMethod_; }

  bool VpiMethod(bool data) { vpiMethod_ = data; return true;}

  int VpiAccessType() const { return vpiAccessType_; }

  bool VpiAccessType(int data) { vpiAccessType_ = data; return true;}

  int VpiVisibility() const { return vpiVisibility_; }

  bool VpiVisibility(int data) { vpiVisibility_ = data; return true;}

  bool VpiVirtual() const { return vpiVirtual_; }

  bool VpiVirtual(bool data) { vpiVirtual_ = data; return true;}

  bool VpiAutomatic() const { return vpiAutomatic_; }

  bool VpiAutomatic(bool data) { vpiAutomatic_ = data; return true;}

  bool VpiDPIPure() const { return vpiDPIPure_; }

  bool VpiDPIPure(bool data) { vpiDPIPure_ = data; return true;}

  bool VpiDPIContext() const { return vpiDPIContext_; }

  bool VpiDPIContext(bool data) { vpiDPIContext_ = data; return true;}

  int VpiDPICStr() const { return vpiDPICStr_; }

  bool VpiDPICStr(int data) { vpiDPICStr_ = data; return true;}

  bool VpiDPICIdentifier(const std::string& data);

  const std::string& VpiDPICIdentifier() const;

  const expr* Left_range() const { return left_range_; }

  bool Left_range(expr* data) { left_range_ = data; return true;}

  const expr* Right_range() const { return right_range_; }

  bool Right_range(expr* data) { right_range_ = data; return true;}

  const variables* Return() const { return return_; }

  bool Return(variables* data) { return_ = data; return true;}

  const instance* Instance() const { return instance_; }

  bool Instance(instance* data) { instance_ = data; return true;}

  const clocking_block* Class_defn() const { return class_defn_; }

  bool Class_defn(clocking_block* data) { class_defn_ = data; return true;}

  const ref_obj* Ref_obj() const { return ref_obj_; }

  bool Ref_obj(ref_obj* data) { ref_obj_ = data; return true;}

  VectorOfio_decl* Io_decls() const { return io_decls_; }

  bool Io_decls(VectorOfio_decl* data) { io_decls_ = data; return true;}

  const any* Stmt() const { return stmt_; }

  bool Stmt(any* data) {if (!stmtGroupCompliant(data)) return false; stmt_ = data; return true;}

  virtual  UHDM_OBJECT_TYPE UhdmType() const override { return uhdmtask_func; }

private:
  
  bool vpiMethod_ = 0;

  int vpiAccessType_ = 0;

  int vpiVisibility_ = 0;

  bool vpiVirtual_ = 0;

  bool vpiAutomatic_ = 0;

  bool vpiDPIPure_ = 0;

  bool vpiDPIContext_ = 0;

  int vpiDPICStr_ = 0;

  SymbolFactory::ID vpiDPICIdentifier_ = 0;

  expr* left_range_ = nullptr;

  expr* right_range_ = nullptr;

  variables* return_ = nullptr;

  instance* instance_ = nullptr;

  clocking_block* class_defn_ = nullptr;

  ref_obj* ref_obj_ = nullptr;

  VectorOfio_decl* io_decls_ = nullptr;

  any* stmt_ = nullptr;

};

#if 0 // This class cannot be instantiated
class task_funcFactory {
  friend Serializer;
public:
  task_func* Make() {
    task_func* obj = new task_func();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(task_func* tps) {
    for (std::vector<task_func*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<task_func*> objects_;
};
#endif

class VectorOftask_funcFactory {
  friend Serializer;
public:
 std::vector<task_func*>* Make() {
   std::vector<task_func*>* obj = new std::vector<task_func*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<task_func*>*> objects_;
};

}  // namespace UHDM

#endif
