/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   task.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_TASK_H
#define UHDM_TASK_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "task_func.h"



namespace UHDM {
class task final : public task_func {
public:
  // Implicit constructor used to initialize all members,
  // comment: task();
  virtual ~task() final {}
  
  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; if (data) uhdmParentType_ = data->UhdmType(); return true;}

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true;}

  virtual bool VpiFile(const std::string& data) final;

  virtual const std::string& VpiFile() const final;

  unsigned int UhdmId() const { return uhdmId_; }

  bool UhdmId(unsigned int data) { uhdmId_ = data; return true;}

  task* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override;

  unsigned int VpiType() const final { return vpiTask; }

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmtask; }

private:
  
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

};


class taskFactory {
  friend Serializer;
public:
  task* Make() {
    task* obj = new task();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(task* tps) {
    for (std::vector<task*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<task*> objects_;
};


class VectorOftaskFactory {
  friend Serializer;
public:
 std::vector<task*>* Make() {
   std::vector<task*>* obj = new std::vector<task*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<task*>*> objects_;
};

}  // namespace UHDM

#endif
