/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   scope.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_SCOPE_H
#define UHDM_SCOPE_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "BaseClass.h"

#include "parameters.h"
#include "instance_item.h"


namespace UHDM {
class scope  : public BaseClass {
public:
  // Implicit constructor used to initialize all members,
  // comment: scope();
  virtual ~scope()  {}
  
  scope* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override = 0;

  bool VpiName(const std::string& data);

  const std::string& VpiName() const;

  bool VpiFullName(const std::string& data);

  const std::string&  VpiFullName() const;

  VectorOfconcurrent_assertions* Concurrent_assertions() const { return concurrent_assertions_; }

  bool Concurrent_assertions(VectorOfconcurrent_assertions* data) { concurrent_assertions_ = data; return true;}

  VectorOfvariables* Variables() const { return variables_; }

  bool Variables(VectorOfvariables* data) { variables_ = data; return true;}

  VectorOfscope* Scopes() const { return scopes_; }

  bool Scopes(VectorOfscope* data) { scopes_ = data; return true;}

  VectorOftypespec* Typespecs() const { return typespecs_; }

  bool Typespecs(VectorOftypespec* data) { typespecs_ = data; return true;}

  VectorOfproperty_decl* Property_decls() const { return property_decls_; }

  bool Property_decls(VectorOfproperty_decl* data) { property_decls_ = data; return true;}

  VectorOfsequence_decl* Sequence_decls() const { return sequence_decls_; }

  bool Sequence_decls(VectorOfsequence_decl* data) { sequence_decls_ = data; return true;}

  VectorOfnamed_event* Named_events() const { return named_events_; }

  bool Named_events(VectorOfnamed_event* data) { named_events_ = data; return true;}

  VectorOfnamed_event_array* Named_event_arrays() const { return named_event_arrays_; }

  bool Named_event_arrays(VectorOfnamed_event_array* data) { named_event_arrays_ = data; return true;}

  VectorOfvirtual_interface_var* Virtual_interface_vars() const { return virtual_interface_vars_; }

  bool Virtual_interface_vars(VectorOfvirtual_interface_var* data) { virtual_interface_vars_ = data; return true;}

  VectorOflogic_var* Logic_vars() const { return logic_vars_; }

  bool Logic_vars(VectorOflogic_var* data) { logic_vars_ = data; return true;}

  VectorOfarray_var* Array_vars() const { return array_vars_; }

  bool Array_vars(VectorOfarray_var* data) { array_vars_ = data; return true;}

  VectorOfarray_var* Array_var_mems() const { return array_var_mems_; }

  bool Array_var_mems(VectorOfarray_var* data) { array_var_mems_ = data; return true;}

  VectorOfparam_assign* Param_assigns() const { return param_assigns_; }

  bool Param_assigns(VectorOfparam_assign* data) { param_assigns_ = data; return true;}

  VectorOflet_decl* Let_decls() const { return let_decls_; }

  bool Let_decls(VectorOflet_decl* data) { let_decls_ = data; return true;}

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true;}

  VectorOfany* Parameters() const { return parameters_; }

  bool Parameters(VectorOfany* data) {if (!parametersGroupCompliant(data)) return false; parameters_ = data; return true;}

  VectorOfany* Instance_items() const { return instance_items_; }

  bool Instance_items(VectorOfany* data) {if (!instance_itemGroupCompliant(data)) return false; instance_items_ = data; return true;}

  virtual  UHDM_OBJECT_TYPE UhdmType() const override { return uhdmscope; }

private:
  
  SymbolFactory::ID vpiName_ = 0;

  SymbolFactory::ID vpiFullName_ = 0;

  VectorOfconcurrent_assertions* concurrent_assertions_ = nullptr;

  VectorOfvariables* variables_ = nullptr;

  VectorOfscope* scopes_ = nullptr;

  VectorOftypespec* typespecs_ = nullptr;

  VectorOfproperty_decl* property_decls_ = nullptr;

  VectorOfsequence_decl* sequence_decls_ = nullptr;

  VectorOfnamed_event* named_events_ = nullptr;

  VectorOfnamed_event_array* named_event_arrays_ = nullptr;

  VectorOfvirtual_interface_var* virtual_interface_vars_ = nullptr;

  VectorOflogic_var* logic_vars_ = nullptr;

  VectorOfarray_var* array_vars_ = nullptr;

  VectorOfarray_var* array_var_mems_ = nullptr;

  VectorOfparam_assign* param_assigns_ = nullptr;

  VectorOflet_decl* let_decls_ = nullptr;

  VectorOfattribute* attributes_ = nullptr;

  VectorOfany* parameters_ = nullptr;

  VectorOfany* instance_items_ = nullptr;

};

#if 0 // This class cannot be instantiated
class scopeFactory {
  friend Serializer;
public:
  scope* Make() {
    scope* obj = new scope();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(scope* tps) {
    for (std::vector<scope*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<scope*> objects_;
};
#endif

class VectorOfscopeFactory {
  friend Serializer;
public:
 std::vector<scope*>* Make() {
   std::vector<scope*>* obj = new std::vector<scope*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<scope*>*> objects_;
};

}  // namespace UHDM

#endif
