/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   property_spec.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_PROPERTY_SPEC_H
#define UHDM_PROPERTY_SPEC_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "BaseClass.h"

#include "expr_dist.h"
#include "property_expr_group.h"


namespace UHDM {
class property_spec final : public BaseClass {
public:
  // Implicit constructor used to initialize all members,
  // comment: property_spec();
  virtual ~property_spec() final {}
  
  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; if (data) uhdmParentType_ = data->UhdmType(); return true;}

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true;}

  virtual bool VpiFile(const std::string& data) final;

  virtual const std::string& VpiFile() const final;

  unsigned int UhdmId() const { return uhdmId_; }

  bool UhdmId(unsigned int data) { uhdmId_ = data; return true;}

  property_spec* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override;

  const expr* VpiClockingEvent() const { return vpiClockingEvent_; }

  bool VpiClockingEvent(expr* data) { vpiClockingEvent_ = data; return true;}

  const any* VpiDisableCondition() const { return vpiDisableCondition_; }

  bool VpiDisableCondition(any* data) {if (!expr_distGroupCompliant(data)) return false; vpiDisableCondition_ = data; return true;}

  const any* VpiPropertyExpr() const { return vpiPropertyExpr_; }

  bool VpiPropertyExpr(any* data) {if (!property_expr_groupGroupCompliant(data)) return false; vpiPropertyExpr_ = data; return true;}

  unsigned int VpiType() const final { return vpiPropertySpec; }

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmproperty_spec; }

private:
  
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  expr* vpiClockingEvent_ = nullptr;

  any* vpiDisableCondition_ = nullptr;

  any* vpiPropertyExpr_ = nullptr;

};


class property_specFactory {
  friend Serializer;
public:
  property_spec* Make() {
    property_spec* obj = new property_spec();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(property_spec* tps) {
    for (std::vector<property_spec*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<property_spec*> objects_;
};


class VectorOfproperty_specFactory {
  friend Serializer;
public:
 std::vector<property_spec*>* Make() {
   std::vector<property_spec*>* obj = new std::vector<property_spec*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<property_spec*>*> objects_;
};

}  // namespace UHDM

#endif
