/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   program.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_PROGRAM_H
#define UHDM_PROGRAM_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "instance.h"

#include "expr_dist.h"


namespace UHDM {
class program final : public instance {
public:
  // Implicit constructor used to initialize all members,
  // comment: program();
  virtual ~program() final {}
  
  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; if (data) uhdmParentType_ = data->UhdmType(); return true;}

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true;}

  virtual bool VpiFile(const std::string& data) final;

  virtual const std::string& VpiFile() const final;

  unsigned int UhdmId() const { return uhdmId_; }

  bool UhdmId(unsigned int data) { uhdmId_ = data; return true;}

  program* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override;

  int VpiIndex() const { return vpiIndex_; }

  bool VpiIndex(int data) { vpiIndex_ = data; return true;}

    unsigned int VpiType() const final { return vpiProgram; }

  const instance_array* Instance_array() const { return instance_array_; }

  bool Instance_array(instance_array* data) { instance_array_ = data; return true;}

  VectorOfprocess_stmt* Process() const { return process_; }

  bool Process(VectorOfprocess_stmt* data) { process_ = data; return true;}

  const clocking_block* Default_clocking() const { return default_clocking_; }

  bool Default_clocking(clocking_block* data) { default_clocking_ = data; return true;}

  VectorOfinterface* Interfaces() const { return interfaces_; }

  bool Interfaces(VectorOfinterface* data) { interfaces_ = data; return true;}

  VectorOfinterface_array* Interface_arrays() const { return interface_arrays_; }

  bool Interface_arrays(VectorOfinterface_array* data) { interface_arrays_ = data; return true;}

  VectorOfcont_assign* Cont_assigns() const { return cont_assigns_; }

  bool Cont_assigns(VectorOfcont_assign* data) { cont_assigns_ = data; return true;}

  VectorOfclocking_block* Clocking_blocks() const { return clocking_blocks_; }

  bool Clocking_blocks(VectorOfclocking_block* data) { clocking_blocks_ = data; return true;}

  VectorOfport* Ports() const { return ports_; }

  bool Ports(VectorOfport* data) { ports_ = data; return true;}

  VectorOfgen_scope_array* Gen_scope_arrays() const { return gen_scope_arrays_; }

  bool Gen_scope_arrays(VectorOfgen_scope_array* data) { gen_scope_arrays_ = data; return true;}

  const any* Expr_dist() const { return expr_dist_; }

  bool Expr_dist(any* data) {if (!expr_distGroupCompliant(data)) return false; expr_dist_ = data; return true;}

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmprogram; }

private:
  
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  int vpiIndex_ = 0;

  instance_array* instance_array_ = nullptr;

  VectorOfprocess_stmt* process_ = nullptr;

  clocking_block* default_clocking_ = nullptr;

  VectorOfinterface* interfaces_ = nullptr;

  VectorOfinterface_array* interface_arrays_ = nullptr;

  VectorOfcont_assign* cont_assigns_ = nullptr;

  VectorOfclocking_block* clocking_blocks_ = nullptr;

  VectorOfport* ports_ = nullptr;

  VectorOfgen_scope_array* gen_scope_arrays_ = nullptr;

  any* expr_dist_ = nullptr;

};


class programFactory {
  friend Serializer;
public:
  program* Make() {
    program* obj = new program();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(program* tps) {
    for (std::vector<program*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<program*> objects_;
};


class VectorOfprogramFactory {
  friend Serializer;
public:
 std::vector<program*>* Make() {
   std::vector<program*>* obj = new std::vector<program*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<program*>*> objects_;
};

}  // namespace UHDM

#endif
