/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   ports.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_PORTS_H
#define UHDM_PORTS_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "BaseClass.h"

#include "expr_ref_obj_group.h"
#include "expr_ref_obj_group.h"


namespace UHDM {
class ports  : public BaseClass {
public:
  // Implicit constructor used to initialize all members,
  // comment: ports();
  virtual ~ports()  {}
  
  ports* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override = 0;

  int VpiPortIndex() const { return vpiPortIndex_; }

  bool VpiPortIndex(int data) { vpiPortIndex_ = data; return true;}

  bool VpiName(const std::string& data);

  const std::string& VpiName() const;

  int VpiPortType() const { return vpiPortType_; }

  bool VpiPortType(int data) { vpiPortType_ = data; return true;}

  bool VpiScalar() const { return vpiScalar_; }

  bool VpiScalar(bool data) { vpiScalar_ = data; return true;}

  bool VpiVector() const { return vpiVector_; }

  bool VpiVector(bool data) { vpiVector_ = data; return true;}

  bool VpiConnByName() const { return vpiConnByName_; }

  bool VpiConnByName(bool data) { vpiConnByName_ = data; return true;}

  int VpiDirection() const { return vpiDirection_; }

  bool VpiDirection(int data) { vpiDirection_ = data; return true;}

  int VpiSize() const { return vpiSize_; }

  bool VpiSize(int data) { vpiSize_ = data; return true;}

  bool VpiExplicitName(const std::string& data);

  const std::string& VpiExplicitName() const;

  const typespec* Typespec() const { return typespec_; }

  bool Typespec(typespec* data) { typespec_ = data; return true;}

  const instance* Instance() const { return instance_; }

  bool Instance(instance* data) { instance_ = data; return true;}

  const module* Module() const { return module_; }

  bool Module(module* data) { module_ = data; return true;}

  const any* High_conn() const { return high_conn_; }

  bool High_conn(any* data) {if (!expr_ref_obj_groupGroupCompliant(data)) return false; high_conn_ = data; return true;}

  const any* Low_conn() const { return low_conn_; }

  bool Low_conn(any* data) {if (!expr_ref_obj_groupGroupCompliant(data)) return false; low_conn_ = data; return true;}

  virtual  UHDM_OBJECT_TYPE UhdmType() const override { return uhdmports; }

private:
  
  int vpiPortIndex_ = 0;

  SymbolFactory::ID vpiName_ = 0;

  int vpiPortType_ = 0;

  bool vpiScalar_ = 0;

  bool vpiVector_ = 0;

  bool vpiConnByName_ = 0;

  int vpiDirection_ = 0;

  int vpiSize_ = 0;

  SymbolFactory::ID vpiExplicitName_ = 0;

  typespec* typespec_ = nullptr;

  instance* instance_ = nullptr;

  module* module_ = nullptr;

  any* high_conn_ = nullptr;

  any* low_conn_ = nullptr;

};

#if 0 // This class cannot be instantiated
class portsFactory {
  friend Serializer;
public:
  ports* Make() {
    ports* obj = new ports();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(ports* tps) {
    for (std::vector<ports*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<ports*> objects_;
};
#endif

class VectorOfportsFactory {
  friend Serializer;
public:
 std::vector<ports*>* Make() {
   std::vector<ports*>* obj = new std::vector<ports*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<ports*>*> objects_;
};

}  // namespace UHDM

#endif
