/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   port.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_PORT_H
#define UHDM_PORT_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "ports.h"



namespace UHDM {
class port final : public ports {
public:
  // Implicit constructor used to initialize all members,
  // comment: port();
  virtual ~port() final {}
  
  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; if (data) uhdmParentType_ = data->UhdmType(); return true;}

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true;}

  virtual bool VpiFile(const std::string& data) final;

  virtual const std::string& VpiFile() const final;

  unsigned int UhdmId() const { return uhdmId_; }

  bool UhdmId(unsigned int data) { uhdmId_ = data; return true;}

  port* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override;

  VectorOfport_bit* Bits() const { return bits_; }

  bool Bits(VectorOfport_bit* data) { bits_ = data; return true;}

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true;}

  unsigned int VpiType() const final { return vpiPort; }

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmport; }

private:
  
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  VectorOfport_bit* bits_ = nullptr;

  VectorOfattribute* attributes_ = nullptr;

};


class portFactory {
  friend Serializer;
public:
  port* Make() {
    port* obj = new port();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(port* tps) {
    for (std::vector<port*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<port*> objects_;
};


class VectorOfportFactory {
  friend Serializer;
public:
 std::vector<port*>* Make() {
   std::vector<port*>* obj = new std::vector<port*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<port*>*> objects_;
};

}  // namespace UHDM

#endif
