/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   operation.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_OPERATION_H
#define UHDM_OPERATION_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "expr.h"

#include "operand_group.h"


namespace UHDM {
class operation final : public expr {
public:
  // Implicit constructor used to initialize all members,
  // comment: operation();
  virtual ~operation() final {}
  
  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; if (data) uhdmParentType_ = data->UhdmType(); return true;}

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true;}

  virtual bool VpiFile(const std::string& data) final;

  virtual const std::string& VpiFile() const final;

  unsigned int UhdmId() const { return uhdmId_; }

  bool UhdmId(unsigned int data) { uhdmId_ = data; return true;}

  operation* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override;

  int VpiOpType() const { return vpiOpType_; }

  bool VpiOpType(int data) { vpiOpType_ = data; return true;}

  bool VpiReordered() const { return vpiReordered_; }

  bool VpiReordered(bool data) { vpiReordered_ = data; return true;}

  bool VpiOpStrong() const { return vpiOpStrong_; }

  bool VpiOpStrong(bool data) { vpiOpStrong_ = data; return true;}

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true;}

  VectorOfany* Operands() const { return operands_; }

  bool Operands(VectorOfany* data) {if (!operand_groupGroupCompliant(data)) return false; operands_ = data; return true;}

  unsigned int VpiType() const final { return vpiOperation; }

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmoperation; }

private:
  
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  int vpiOpType_ = 0;

  bool vpiReordered_ = 0;

  bool vpiOpStrong_ = 0;

  VectorOfattribute* attributes_ = nullptr;

  VectorOfany* operands_ = nullptr;

};


class operationFactory {
  friend Serializer;
public:
  operation* Make() {
    operation* obj = new operation();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(operation* tps) {
    for (std::vector<operation*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<operation*> objects_;
};


class VectorOfoperationFactory {
  friend Serializer;
public:
 std::vector<operation*>* Make() {
   std::vector<operation*>* obj = new std::vector<operation*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<operation*>*> objects_;
};

}  // namespace UHDM

#endif
