/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   instance.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_INSTANCE_H
#define UHDM_INSTANCE_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "scope.h"

#include "assertion.h"


namespace UHDM {
class instance  : public scope {
public:
  // Implicit constructor used to initialize all members,
  // comment: instance();
  virtual ~instance()  {}
  
  instance* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override = 0;

  bool VpiDefName(const std::string& data);

  const std::string& VpiDefName() const;

  bool VpiArrayMember() const { return vpiArrayMember_; }

  bool VpiArrayMember(bool data) { vpiArrayMember_ = data; return true;}

  bool VpiCellInstance() const { return vpiCellInstance_; }

  bool VpiCellInstance(bool data) { vpiCellInstance_ = data; return true;}

  int VpiDefNetType() const { return vpiDefNetType_; }

  bool VpiDefNetType(int data) { vpiDefNetType_ = data; return true;}

  bool VpiDefFile(const std::string& data);

  const std::string& VpiDefFile() const;

  int VpiDefLineNo() const { return vpiDefLineNo_; }

  bool VpiDefLineNo(int data) { vpiDefLineNo_ = data; return true;}

  int VpiDefDelayMode() const { return vpiDefDelayMode_; }

  bool VpiDefDelayMode(int data) { vpiDefDelayMode_ = data; return true;}

  bool VpiProtected() const { return vpiProtected_; }

  bool VpiProtected(bool data) { vpiProtected_ = data; return true;}

  int VpiTimePrecision() const { return vpiTimePrecision_; }

  bool VpiTimePrecision(int data) { vpiTimePrecision_ = data; return true;}

  int VpiTimeUnit() const { return vpiTimeUnit_; }

  bool VpiTimeUnit(int data) { vpiTimeUnit_ = data; return true;}

  int VpiUnconnDrive() const { return vpiUnconnDrive_; }

  bool VpiUnconnDrive(int data) { vpiUnconnDrive_ = data; return true;}

  bool VpiLibrary(const std::string& data);

  const std::string& VpiLibrary() const;

  bool VpiCell(const std::string& data);

  const std::string& VpiCell() const;

  bool VpiConfig(const std::string& data);

  const std::string& VpiConfig() const;

  bool VpiAutomatic() const { return vpiAutomatic_; }

  bool VpiAutomatic(bool data) { vpiAutomatic_ = data; return true;}

  bool VpiTop() const { return vpiTop_; }

  bool VpiTop(bool data) { vpiTop_ = data; return true;}

  VectorOftask_func* Task_funcs() const { return task_funcs_; }

  bool Task_funcs(VectorOftask_func* data) { task_funcs_ = data; return true;}

  VectorOfnet* Nets() const { return nets_; }

  bool Nets(VectorOfnet* data) { nets_ = data; return true;}

  const instance* Instance() const { return instance_; }

  bool Instance(instance* data) { instance_ = data; return true;}

  VectorOfprogram* Programs() const { return programs_; }

  bool Programs(VectorOfprogram* data) { programs_ = data; return true;}

  VectorOfprogram* Program_arrays() const { return program_arrays_; }

  bool Program_arrays(VectorOfprogram* data) { program_arrays_ = data; return true;}

  VectorOfarray_net* Array_nets() const { return array_nets_; }

  bool Array_nets(VectorOfarray_net* data) { array_nets_ = data; return true;}

  VectorOfspec_param* Spec_params() const { return spec_params_; }

  bool Spec_params(VectorOfspec_param* data) { spec_params_ = data; return true;}

  VectorOfclass_defn* Class_defns() const { return class_defns_; }

  bool Class_defns(VectorOfclass_defn* data) { class_defns_ = data; return true;}

  const module* Module() const { return module_; }

  bool Module(module* data) { module_ = data; return true;}

  VectorOfany* Assertions() const { return assertions_; }

  bool Assertions(VectorOfany* data) {if (!assertionGroupCompliant(data)) return false; assertions_ = data; return true;}

  virtual  UHDM_OBJECT_TYPE UhdmType() const override { return uhdminstance; }

private:
  
  SymbolFactory::ID vpiDefName_ = 0;

  bool vpiArrayMember_ = 0;

  bool vpiCellInstance_ = 0;

  int vpiDefNetType_ = 0;

  SymbolFactory::ID vpiDefFile_ = 0;

  int vpiDefLineNo_ = 0;

  int vpiDefDelayMode_ = 0;

  bool vpiProtected_ = 0;

  int vpiTimePrecision_ = 0;

  int vpiTimeUnit_ = 0;

  int vpiUnconnDrive_ = 0;

  SymbolFactory::ID vpiLibrary_ = 0;

  SymbolFactory::ID vpiCell_ = 0;

  SymbolFactory::ID vpiConfig_ = 0;

  bool vpiAutomatic_ = 0;

  bool vpiTop_ = 0;

  VectorOftask_func* task_funcs_ = nullptr;

  VectorOfnet* nets_ = nullptr;

  instance* instance_ = nullptr;

  VectorOfprogram* programs_ = nullptr;

  VectorOfprogram* program_arrays_ = nullptr;

  VectorOfarray_net* array_nets_ = nullptr;

  VectorOfspec_param* spec_params_ = nullptr;

  VectorOfclass_defn* class_defns_ = nullptr;

  module* module_ = nullptr;

  VectorOfany* assertions_ = nullptr;

};

#if 0 // This class cannot be instantiated
class instanceFactory {
  friend Serializer;
public:
  instance* Make() {
    instance* obj = new instance();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(instance* tps) {
    for (std::vector<instance*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<instance*> objects_;
};
#endif

class VectorOfinstanceFactory {
  friend Serializer;
public:
 std::vector<instance*>* Make() {
   std::vector<instance*>* obj = new std::vector<instance*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<instance*>*> objects_;
};

}  // namespace UHDM

#endif
