/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   gen_scope.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_GEN_SCOPE_H
#define UHDM_GEN_SCOPE_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "scope.h"

#include "assertion.h"


namespace UHDM {
class gen_scope final : public scope {
public:
  // Implicit constructor used to initialize all members,
  // comment: gen_scope();
  virtual ~gen_scope() final {}
  
  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; if (data) uhdmParentType_ = data->UhdmType(); return true;}

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true;}

  virtual bool VpiFile(const std::string& data) final;

  virtual const std::string& VpiFile() const final;

  unsigned int UhdmId() const { return uhdmId_; }

  bool UhdmId(unsigned int data) { uhdmId_ = data; return true;}

  gen_scope* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override;

  bool VpiArrayMember() const { return vpiArrayMember_; }

  bool VpiArrayMember(bool data) { vpiArrayMember_ = data; return true;}

  bool VpiProtected() const { return vpiProtected_; }

  bool VpiProtected(bool data) { vpiProtected_ = data; return true;}

  bool VpiImplicitDecl() const { return vpiImplicitDecl_; }

  bool VpiImplicitDecl(bool data) { vpiImplicitDecl_ = data; return true;}

  const expr* VpiIndex() const { return vpiIndex_; }

  bool VpiIndex(expr* data) { vpiIndex_ = data; return true;}

  VectorOfnet* Nets() const { return nets_; }

  bool Nets(VectorOfnet* data) { nets_ = data; return true;}

  VectorOfprocess_stmt* Process() const { return process_; }

  bool Process(VectorOfprocess_stmt* data) { process_ = data; return true;}

  VectorOfprimitive* Primitives() const { return primitives_; }

  bool Primitives(VectorOfprimitive* data) { primitives_ = data; return true;}

  VectorOfprimitive_array* Primitive_arrays() const { return primitive_arrays_; }

  bool Primitive_arrays(VectorOfprimitive_array* data) { primitive_arrays_ = data; return true;}

  VectorOfarray_net* Array_nets() const { return array_nets_; }

  bool Array_nets(VectorOfarray_net* data) { array_nets_ = data; return true;}

  VectorOfcont_assign* Cont_assigns() const { return cont_assigns_; }

  bool Cont_assigns(VectorOfcont_assign* data) { cont_assigns_ = data; return true;}

  VectorOfmodule* Modules() const { return modules_; }

  bool Modules(VectorOfmodule* data) { modules_ = data; return true;}

  VectorOfmodule_array* Module_arrays() const { return module_arrays_; }

  bool Module_arrays(VectorOfmodule_array* data) { module_arrays_ = data; return true;}

  VectorOfdef_param* Def_params() const { return def_params_; }

  bool Def_params(VectorOfdef_param* data) { def_params_ = data; return true;}

  VectorOfgen_scope_array* Gen_scope_arrays() const { return gen_scope_arrays_; }

  bool Gen_scope_arrays(VectorOfgen_scope_array* data) { gen_scope_arrays_ = data; return true;}

  VectorOfprogram* Programs() const { return programs_; }

  bool Programs(VectorOfprogram* data) { programs_ = data; return true;}

  VectorOfprogram* Program_arrays() const { return program_arrays_; }

  bool Program_arrays(VectorOfprogram* data) { program_arrays_ = data; return true;}

  VectorOfinterface* Interfaces() const { return interfaces_; }

  bool Interfaces(VectorOfinterface* data) { interfaces_ = data; return true;}

  VectorOfinterface_array* Interface_arrays() const { return interface_arrays_; }

  bool Interface_arrays(VectorOfinterface_array* data) { interface_arrays_ = data; return true;}

  VectorOfalias_stmt* Alias_stmts() const { return alias_stmts_; }

  bool Alias_stmts(VectorOfalias_stmt* data) { alias_stmts_ = data; return true;}

  VectorOfclocking_block* Clocking_blocks() const { return clocking_blocks_; }

  bool Clocking_blocks(VectorOfclocking_block* data) { clocking_blocks_ = data; return true;}

  VectorOfany* Assertions() const { return assertions_; }

  bool Assertions(VectorOfany* data) {if (!assertionGroupCompliant(data)) return false; assertions_ = data; return true;}

  unsigned int VpiType() const final { return vpiGenScope; }

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmgen_scope; }

private:
  
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  bool vpiArrayMember_ = 0;

  bool vpiProtected_ = 0;

  bool vpiImplicitDecl_ = 0;

  expr* vpiIndex_ = nullptr;

  VectorOfnet* nets_ = nullptr;

  VectorOfprocess_stmt* process_ = nullptr;

  VectorOfprimitive* primitives_ = nullptr;

  VectorOfprimitive_array* primitive_arrays_ = nullptr;

  VectorOfarray_net* array_nets_ = nullptr;

  VectorOfcont_assign* cont_assigns_ = nullptr;

  VectorOfmodule* modules_ = nullptr;

  VectorOfmodule_array* module_arrays_ = nullptr;

  VectorOfdef_param* def_params_ = nullptr;

  VectorOfgen_scope_array* gen_scope_arrays_ = nullptr;

  VectorOfprogram* programs_ = nullptr;

  VectorOfprogram* program_arrays_ = nullptr;

  VectorOfinterface* interfaces_ = nullptr;

  VectorOfinterface_array* interface_arrays_ = nullptr;

  VectorOfalias_stmt* alias_stmts_ = nullptr;

  VectorOfclocking_block* clocking_blocks_ = nullptr;

  VectorOfany* assertions_ = nullptr;

};


class gen_scopeFactory {
  friend Serializer;
public:
  gen_scope* Make() {
    gen_scope* obj = new gen_scope();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(gen_scope* tps) {
    for (std::vector<gen_scope*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<gen_scope*> objects_;
};


class VectorOfgen_scopeFactory {
  friend Serializer;
public:
 std::vector<gen_scope*>* Make() {
   std::vector<gen_scope*>* obj = new std::vector<gen_scope*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<gen_scope*>*> objects_;
};

}  // namespace UHDM

#endif
