/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   constraint.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_CONSTRAINT_H
#define UHDM_CONSTRAINT_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "BaseClass.h"

#include "constraint_item_group.h"


namespace UHDM {
class constraint final : public BaseClass {
public:
  // Implicit constructor used to initialize all members,
  // comment: constraint();
  virtual ~constraint() final {}
  
  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; if (data) uhdmParentType_ = data->UhdmType(); return true;}

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true;}

  virtual bool VpiFile(const std::string& data) final;

  virtual const std::string& VpiFile() const final;

  unsigned int UhdmId() const { return uhdmId_; }

  bool UhdmId(unsigned int data) { uhdmId_ = data; return true;}

  constraint* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override;

  bool VpiName(const std::string& data);

  const std::string& VpiName() const;

  bool VpiFullName(const std::string& data);

  const std::string&  VpiFullName() const;

  bool VpiVirtual() const { return vpiVirtual_; }

  bool VpiVirtual(bool data) { vpiVirtual_ = data; return true;}

  bool VpiAutomatic() const { return vpiAutomatic_; }

  bool VpiAutomatic(bool data) { vpiAutomatic_ = data; return true;}

  int VpiAllocScheme() const { return vpiAllocScheme_; }

  bool VpiAllocScheme(int data) { vpiAllocScheme_ = data; return true;}

  int VpiAccessType() const { return vpiAccessType_; }

  bool VpiAccessType(int data) { vpiAccessType_ = data; return true;}

  bool VpiIsConstraintEnabled() const { return vpiIsConstraintEnabled_; }

  bool VpiIsConstraintEnabled(bool data) { vpiIsConstraintEnabled_ = data; return true;}

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true;}

  VectorOfany* Constraint_items() const { return constraint_items_; }

  bool Constraint_items(VectorOfany* data) {if (!constraint_item_groupGroupCompliant(data)) return false; constraint_items_ = data; return true;}

  unsigned int VpiType() const final { return vpiConstraint; }

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmconstraint; }

private:
  
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  SymbolFactory::ID vpiName_ = 0;

  SymbolFactory::ID vpiFullName_ = 0;

  bool vpiVirtual_ = 0;

  bool vpiAutomatic_ = 0;

  int vpiAllocScheme_ = 0;

  int vpiAccessType_ = 0;

  bool vpiIsConstraintEnabled_ = 0;

  VectorOfattribute* attributes_ = nullptr;

  VectorOfany* constraint_items_ = nullptr;

};


class constraintFactory {
  friend Serializer;
public:
  constraint* Make() {
    constraint* obj = new constraint();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(constraint* tps) {
    for (std::vector<constraint*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<constraint*> objects_;
};


class VectorOfconstraintFactory {
  friend Serializer;
public:
 std::vector<constraint*>* Make() {
   std::vector<constraint*>* obj = new std::vector<constraint*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<constraint*>*> objects_;
};

}  // namespace UHDM

#endif
