/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   concurrent_assertions.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_CONCURRENT_ASSERTIONS_H
#define UHDM_CONCURRENT_ASSERTIONS_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "BaseClass.h"

#include "stmt.h"
#include "property_inst_spec_group.h"


namespace UHDM {
class concurrent_assertions  : public BaseClass {
public:
  // Implicit constructor used to initialize all members,
  // comment: concurrent_assertions();
  virtual ~concurrent_assertions()  {}
  
  concurrent_assertions* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override = 0;

  bool VpiName(const std::string& data);

  const std::string& VpiName() const;

  bool VpiFullName(const std::string& data);

  const std::string&  VpiFullName() const;

  bool VpiIsClockInferred() const { return vpiIsClockInferred_; }

  bool VpiIsClockInferred(bool data) { vpiIsClockInferred_ = data; return true;}

  const expr* Clocking_event() const { return clocking_event_; }

  bool Clocking_event(expr* data) { clocking_event_ = data; return true;}

  VectorOfattribute* Attributes() const { return attributes_; }

  bool Attributes(VectorOfattribute* data) { attributes_ = data; return true;}

  const any* Stmt() const { return stmt_; }

  bool Stmt(any* data) {if (!stmtGroupCompliant(data)) return false; stmt_ = data; return true;}

  const any* VpiProperty() const { return vpiProperty_; }

  bool VpiProperty(any* data) {if (!property_inst_spec_groupGroupCompliant(data)) return false; vpiProperty_ = data; return true;}

  virtual  UHDM_OBJECT_TYPE UhdmType() const override { return uhdmconcurrent_assertions; }

private:
  
  SymbolFactory::ID vpiName_ = 0;

  SymbolFactory::ID vpiFullName_ = 0;

  bool vpiIsClockInferred_ = 0;

  expr* clocking_event_ = nullptr;

  VectorOfattribute* attributes_ = nullptr;

  any* stmt_ = nullptr;

  any* vpiProperty_ = nullptr;

};

#if 0 // This class cannot be instantiated
class concurrent_assertionsFactory {
  friend Serializer;
public:
  concurrent_assertions* Make() {
    concurrent_assertions* obj = new concurrent_assertions();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(concurrent_assertions* tps) {
    for (std::vector<concurrent_assertions*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<concurrent_assertions*> objects_;
};
#endif

class VectorOfconcurrent_assertionsFactory {
  friend Serializer;
public:
 std::vector<concurrent_assertions*>* Make() {
   std::vector<concurrent_assertions*>* obj = new std::vector<concurrent_assertions*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<concurrent_assertions*>*> objects_;
};

}  // namespace UHDM

#endif
