/*
 Do not modify, auto-generated by model_gen.tcl

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   assignment.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_ASSIGNMENT_H
#define UHDM_ASSIGNMENT_H

#include "SymbolFactory.h"
#include "BaseClass.h"
#include "containers.h"

#include "atomic_stmt.h"

#include "expr_interf_expr_group.h"


namespace UHDM {
class assignment final : public atomic_stmt {
public:
  // Implicit constructor used to initialize all members,
  // comment: assignment();
  virtual ~assignment() final {}
  
  virtual const BaseClass* VpiParent() const final { return vpiParent_; }

  virtual bool VpiParent(BaseClass* data) final { vpiParent_ = data; if (data) uhdmParentType_ = data->UhdmType(); return true;}

  virtual unsigned int UhdmParentType() const final { return uhdmParentType_; }

  virtual bool UhdmParentType(unsigned int data) final { uhdmParentType_ = data; return true;}

  virtual bool VpiFile(const std::string& data) final;

  virtual const std::string& VpiFile() const final;

  unsigned int UhdmId() const { return uhdmId_; }

  bool UhdmId(unsigned int data) { uhdmId_ = data; return true;}

  assignment* DeepClone(Serializer* serializer, ElaboratorListener* elab_listener, BaseClass* parent) const override;

  int VpiOpType() const { return vpiOpType_; }

  bool VpiOpType(int data) { vpiOpType_ = data; return true;}

  bool VpiBlocking() const { return vpiBlocking_; }

  bool VpiBlocking(bool data) { vpiBlocking_ = data; return true;}

  const expr* Lhs() const { return lhs_; }

  bool Lhs(expr* data) { lhs_ = data; return true;}

  const delay_control* Delay_control() const { return delay_control_; }

  bool Delay_control(delay_control* data) { delay_control_ = data; return true;}

  const event_control* Event_control() const { return event_control_; }

  bool Event_control(event_control* data) { event_control_ = data; return true;}

  const repeat_control* Repeat_control() const { return repeat_control_; }

  bool Repeat_control(repeat_control* data) { repeat_control_ = data; return true;}

  const any* Rhs() const { return rhs_; }

  bool Rhs(any* data) {if (!expr_interf_expr_groupGroupCompliant(data)) return false; rhs_ = data; return true;}

  unsigned int VpiType() const final { return vpiAssignment; }

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return uhdmassignment; }

private:
  
  BaseClass* vpiParent_ = nullptr;

  unsigned int uhdmParentType_ = 0;

  SymbolFactory::ID vpiFile_ = 0;

  unsigned int uhdmId_ = 0;

  int vpiOpType_ = 0;

  bool vpiBlocking_ = 0;

  expr* lhs_ = nullptr;

  delay_control* delay_control_ = nullptr;

  event_control* event_control_ = nullptr;

  repeat_control* repeat_control_ = nullptr;

  any* rhs_ = nullptr;

};


class assignmentFactory {
  friend Serializer;
public:
  assignment* Make() {
    assignment* obj = new assignment();
    objects_.push_back(obj);
    return obj;
  }
  void Erase(assignment* tps) {
    for (std::vector<assignment*>::iterator itr = objects_.begin(); itr != objects_.end(); itr++) {
      if ((*itr) == tps) {
        objects_.erase(itr);
        break;
      }
    }
  }

private:
  std::vector<assignment*> objects_;
};


class VectorOfassignmentFactory {
  friend Serializer;
public:
 std::vector<assignment*>* Make() {
   std::vector<assignment*>* obj = new std::vector<assignment*>();
   objects_.push_back(obj);
   return obj;
 }
private:
 std::vector<std::vector<assignment*>*> objects_;
};

}  // namespace UHDM

#endif
