

from ofrcalc.routines.procsmiles import invokeFromSmiles
from ofrcalc.routines.iomanager import resultWriter, gradientPicSave, loadANNModel


def multiRunManager(inputList,vrange, picDir = 'gradientpics/',\
    resDir='res/', getGradients = False, absGradients = True):
    """
    function to read call the OFRCalculator for each
    of the input OFRS
    :param: inputList list of input objects (prepared by iomanager)
    :param: picDir str optional path for pictures
    :param: resDir str optional path for result csvs
    :param: getGradients bool should pictures be prepared
    :param: absGradients bool should absolute or signed gradient be used
    :return: int status of program (0 = good)
    """ 
    ## start with loading the model
    NNdict = loadANNModel()
    print('loaded model successfully')
    
    resultsList = []
    for i, ins in enumerate(inputList):
        print('**********')
        print('run ' + str(i+1) + ' of ' + str(len(inputList)))
        ins.update({'getGradients':getGradients})
        ins.update({'absGradients':absGradients})
        ins.update({'NNdict':NNdict})
        ins.update({'vrange':vrange})
        results = invokeFromSmiles(**ins)
        if getGradients:
            thisPicdir = picDir.strip('/') +"/" + ins['name']+'/'
            print(ins['name'] +': saving gradient projections to ' + thisPicdir)
            gradientPicSave(results, picDir = thisPicdir)
        resultsList.append(results)

    # write the results to a csv
    print('**********')
    print('all runs done, writing output to  ' + resDir)
    resultWriter(resultsList,  resDir = resDir)
    return(0)
