# function to handle parsing CLI arguments and checking on them 

import argparse


def createParser():
     """
     function to create argument parser for easy CLI access
     to the module and automatic creation of help text
     :return: argprase parser object
     """
     parser = argparse.ArgumentParser(
     description='Predict NEMD coefficient based on SMILEs strings.')

     parser.add_argument(dest='infile',  type=str, 
                    help='input file. see docs for syntax')
     parser.add_argument('--vlow',  type=float, 
                    help='minimun value for sliding velocity',
                    default = 0.5,nargs='?')                    
     parser.add_argument('--vhigh',  type=float, 
                    help='max value for sliding velocity',
                    default = 10.0,nargs='?')
     parser.add_argument('--vsteps',  type=int, 
                    help='steps to take between vlow and vhigh',
                    default = 5,nargs='?')                    
     parser.add_argument('--res', dest='resDir', type=str,
                         default='res/',
                         help='path to folder to save results')
     parser.add_argument('--pic', dest='picDir', type=str,
               default='gradientpics/', help='path to folder to save gradient \
               pictures, if draw is on')
     parser.add_argument('--draw', dest='getGradients',
                help='draw gradient pictures',  action="store_true")
     parser.add_argument('--signed', dest='absGradients',
                help='used signed  gradients',  action="store_false")
     return(parser)
