import pytest
import shutil
from argparse import Namespace
from molSimplify.Scripts.qcgen import (tcgen, gamgen, qgen,
                                       mlpgen, ogen, molcgen)


@pytest.mark.parametrize('gen_function, default_name',
                         [(tcgen, 'terachem_input'), (gamgen, 'gam.inp'),
                          (qgen, 'qch.inp'), (mlpgen, 'FeH2O6.mop'),
                          (ogen, 'orca.in'), (molcgen, 'molcas.input')])
def test_qcgen_defaults(resource_path_root, gen_function, default_name, tmpdir):
    """Calls the gen_function with as little parameters as possible to
    test the default input file generated."""
    args = Namespace(jobdir=str(tmpdir), reportonly=None, spin=None,
                     charge=None, runtyp=None, gpus=None, dispersion=None,
                     basis=None, qoption=None, name=None, tc_fix_dihedral=None,
                     method=None, oxstate='II', remoption=None, gbasis=None,
                     correlation=None, unrestricted=None, bsep=None,
                     ngauss=None, ndfunc=None, npfunc=None, sysoption=None,
                     ctrloption=None, scfoption=None, statoption=None,
                     jobmanager=False)
    xyzfile = resource_path_root / "inputs" / "qcgen" / "FeH2O6.xyz"
    # Copy xyz file to tmpdir
    shutil.copy(xyzfile, tmpdir / 'FeH2O6.xyz')

    jobdirs = gen_function(args, [str(tmpdir / 'FeH2O6')], 'B3LYP')

    sub_dir = tmpdir
    ref_dir = resource_path_root / "refs" / "qcgen" / f"{gen_function.__name__}"
    # These two generate a different subfolder structure...
    if gen_function is gamgen or gen_function is qgen:
        sub_dir = tmpdir / 'FeH2O6/B3LYP'
        ref_dir = f'{ref_dir}/FeH2O6/B3LYP'
    assert jobdirs[0] == sub_dir

    ref_file = resource_path_root / ref_dir / default_name
    with open(ref_file, 'r') as f:
        ref_lines = f.readlines()

    with open(sub_dir / default_name, 'r') as f:
        lines = f.readlines()

    # The gamgen input contains a time stamp that has to be removed
    # prior to comparison:
    if gen_function is gamgen:
        ref_lines = [line for line in ref_lines if not line.endswith(
            'XYZ structure generated by mol3D Class, molSimplify\n')]
        lines = [line for line in lines if not line.endswith(
            'XYZ structure generated by mol3D Class, molSimplify\n')]
    assert lines == ref_lines
