#!/bin/bash
set -euo pipefail

TEXDIR="${PREFIX}/share/tinytex"
BIN_DIR="${PREFIX}/bin"

mkdir -p "$TEXDIR"
mkdir -p "$BIN_DIR"

wget --progress=dot:giga "${TINYTEX_URL}${TARBALL}"
tar xzf "$TARBALL" --strip-components=1 -C "$TEXDIR"

cd "$TEXDIR/bin/x86_64-linux/"
./tlmgr option sys_bin "$BIN_DIR"
./tlmgr option repository ctan
./tlmgr path add
./tlmgr update --self
rm "$PREFIX/share/tinytex/texmf-var/web2c/tlmgr.log"
