git submodule init
git submodule update
mkdir build

if [[ "$OSTYPE" = "darwin"* ]]; then
	echo Copying prebuilt CPU binary...
	cp /tmp/libdgl.dylib build
else
	if [[ $USE_CUDA = 'ON' ]]; then
		echo Copying prebuilt CUDA $CUDA_VER binary...
		cp /tmp/dgl_binaries/libdgl.so.cu$CUDA_VER build/libdgl.so
	else
		echo Copying prebuilt CPU binary...
		cp /tmp/dgl_binaries/libdgl.so.cpu build/libdgl.so
	fi
fi
cd python
$PYTHON setup.py install --single-version-externally-managed --record=record.txt
