# -*- coding: utf-8 -*-
# **********************************************************************
#
# Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.5
#
# <auto-generated>
#
# Generated from file `Router.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

from sys import version_info as _version_info_
import Ice, IcePy
import Ice_BuiltinSequences_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module Ice
__name__ = 'Ice'

if 'Router' not in _M_Ice.__dict__:
    _M_Ice.Router = Ice.createTempClass()
    class Router(Ice.Object):
        """
        The Ice router interface. Routers can be set either globally with
        Communicator#setDefaultRouter, or with ice_router on specific
        proxies.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Ice.Router:
                raise RuntimeError('Ice.Router is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::Ice::Router')

        def ice_id(self, current=None):
            return '::Ice::Router'

        def ice_staticId():
            return '::Ice::Router'
        ice_staticId = staticmethod(ice_staticId)

        def getClientProxy(self, current=None):
            """
            Get the router's client proxy, i.e., the proxy to use for
            forwarding requests from the client to the router.
            If a null proxy is returned, the client will forward requests
            to the router's endpoints.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The router's client proxy.
            """
            pass

        def getServerProxy(self, current=None):
            """
            Get the router's server proxy, i.e., the proxy to use for
            forwarding requests from the server to the router.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The router's server proxy.
            """
            pass

        def addProxies(self, proxies, current=None):
            """
            Add new proxy information to the router's routing table.
            Arguments:
            proxies -- The proxies to add.
            current -- The Current object for the invocation.
            Returns: Proxies discarded by the router.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_Router)

        __repr__ = __str__

    _M_Ice.RouterPrx = Ice.createTempClass()
    class RouterPrx(Ice.ObjectPrx):

        """
        Get the router's client proxy, i.e., the proxy to use for
        forwarding requests from the client to the router.
        If a null proxy is returned, the client will forward requests
        to the router's endpoints.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The router's client proxy.
        """
        def getClientProxy(self, _ctx=None):
            return _M_Ice.Router._op_getClientProxy.invoke(self, ((), _ctx))

        """
        Get the router's client proxy, i.e., the proxy to use for
        forwarding requests from the client to the router.
        If a null proxy is returned, the client will forward requests
        to the router's endpoints.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getClientProxy(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.Router._op_getClientProxy.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Get the router's client proxy, i.e., the proxy to use for
        forwarding requests from the client to the router.
        If a null proxy is returned, the client will forward requests
        to the router's endpoints.
        Arguments:
        Returns: The router's client proxy.
        """
        def end_getClientProxy(self, _r):
            return _M_Ice.Router._op_getClientProxy.end(self, _r)

        """
        Get the router's server proxy, i.e., the proxy to use for
        forwarding requests from the server to the router.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The router's server proxy.
        """
        def getServerProxy(self, _ctx=None):
            return _M_Ice.Router._op_getServerProxy.invoke(self, ((), _ctx))

        """
        Get the router's server proxy, i.e., the proxy to use for
        forwarding requests from the server to the router.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getServerProxy(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.Router._op_getServerProxy.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Get the router's server proxy, i.e., the proxy to use for
        forwarding requests from the server to the router.
        Arguments:
        Returns: The router's server proxy.
        """
        def end_getServerProxy(self, _r):
            return _M_Ice.Router._op_getServerProxy.end(self, _r)

        """
        Add new proxy information to the router's routing table.
        Arguments:
        proxies -- The proxies to add.
        _ctx -- The request context for the invocation.
        Returns: Proxies discarded by the router.
        """
        def addProxies(self, proxies, _ctx=None):
            return _M_Ice.Router._op_addProxies.invoke(self, ((proxies, ), _ctx))

        """
        Add new proxy information to the router's routing table.
        Arguments:
        proxies -- The proxies to add.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_addProxies(self, proxies, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.Router._op_addProxies.begin(self, ((proxies, ), _response, _ex, _sent, _ctx))

        """
        Add new proxy information to the router's routing table.
        Arguments:
        proxies -- The proxies to add.
        Returns: Proxies discarded by the router.
        """
        def end_addProxies(self, _r):
            return _M_Ice.Router._op_addProxies.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Ice.RouterPrx.ice_checkedCast(proxy, '::Ice::Router', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Ice.RouterPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Ice::Router'
        ice_staticId = staticmethod(ice_staticId)

    _M_Ice._t_RouterPrx = IcePy.defineProxy('::Ice::Router', RouterPrx)

    _M_Ice._t_Router = IcePy.defineClass('::Ice::Router', Router, -1, (), True, False, None, (), ())
    Router._ice_type = _M_Ice._t_Router

    Router._op_getClientProxy = IcePy.Operation('getClientProxy', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), IcePy._t_ObjectPrx, False, 0), ())
    Router._op_getServerProxy = IcePy.Operation('getServerProxy', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), IcePy._t_ObjectPrx, False, 0), ())
    Router._op_addProxies = IcePy.Operation('addProxies', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), _M_Ice._t_ObjectProxySeq, False, 0),), (), ((), _M_Ice._t_ObjectProxySeq, False, 0), ())

    _M_Ice.Router = Router
    del Router

    _M_Ice.RouterPrx = RouterPrx
    del RouterPrx

if 'RouterFinder' not in _M_Ice.__dict__:
    _M_Ice.RouterFinder = Ice.createTempClass()
    class RouterFinder(Ice.Object):
        """
        This inferface should be implemented by services implementing the
        Ice::Router interface. It should be advertised through an Ice
        object with the identity `Ice/RouterFinder'. This allows clients to
        retrieve the router proxy with just the endpoint information of the
        service.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Ice.RouterFinder:
                raise RuntimeError('Ice.RouterFinder is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::Ice::RouterFinder')

        def ice_id(self, current=None):
            return '::Ice::RouterFinder'

        def ice_staticId():
            return '::Ice::RouterFinder'
        ice_staticId = staticmethod(ice_staticId)

        def getRouter(self, current=None):
            """
            Get the router proxy implemented by the process hosting this
            finder object. The proxy might point to several replicas.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The router proxy.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_RouterFinder)

        __repr__ = __str__

    _M_Ice.RouterFinderPrx = Ice.createTempClass()
    class RouterFinderPrx(Ice.ObjectPrx):

        """
        Get the router proxy implemented by the process hosting this
        finder object. The proxy might point to several replicas.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The router proxy.
        """
        def getRouter(self, _ctx=None):
            return _M_Ice.RouterFinder._op_getRouter.invoke(self, ((), _ctx))

        """
        Get the router proxy implemented by the process hosting this
        finder object. The proxy might point to several replicas.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getRouter(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.RouterFinder._op_getRouter.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Get the router proxy implemented by the process hosting this
        finder object. The proxy might point to several replicas.
        Arguments:
        Returns: The router proxy.
        """
        def end_getRouter(self, _r):
            return _M_Ice.RouterFinder._op_getRouter.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Ice.RouterFinderPrx.ice_checkedCast(proxy, '::Ice::RouterFinder', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Ice.RouterFinderPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Ice::RouterFinder'
        ice_staticId = staticmethod(ice_staticId)

    _M_Ice._t_RouterFinderPrx = IcePy.defineProxy('::Ice::RouterFinder', RouterFinderPrx)

    _M_Ice._t_RouterFinder = IcePy.defineClass('::Ice::RouterFinder', RouterFinder, -1, (), True, False, None, (), ())
    RouterFinder._ice_type = _M_Ice._t_RouterFinder

    RouterFinder._op_getRouter = IcePy.Operation('getRouter', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), ((), _M_Ice._t_RouterPrx, False, 0), ())

    _M_Ice.RouterFinder = RouterFinder
    del RouterFinder

    _M_Ice.RouterFinderPrx = RouterFinderPrx
    del RouterFinderPrx

# End of module Ice
