# -*- coding: utf-8 -*-
# **********************************************************************
#
# Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.5
#
# <auto-generated>
#
# Generated from file `FileServer.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

from sys import version_info as _version_info_
import Ice, IcePy
import IcePatch2_FileInfo_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module IcePatch2
_M_IcePatch2 = Ice.openModule('IcePatch2')

# Start of module IcePatch2
__name__ = 'IcePatch2'
_M_IcePatch2.__doc__ = """
IcePatch can be used to update file hierarchies in a simple and
efficient manner. Checksums ensure file integrity, and data is
compressed before downloading.
"""

if '_t_ByteSeqSeq' not in _M_IcePatch2.__dict__:
    _M_IcePatch2._t_ByteSeqSeq = IcePy.defineSequence('::IcePatch2::ByteSeqSeq', (), _M_Ice._t_ByteSeq)

if 'PartitionOutOfRangeException' not in _M_IcePatch2.__dict__:
    _M_IcePatch2.PartitionOutOfRangeException = Ice.createTempClass()
    class PartitionOutOfRangeException(Ice.UserException):
        """
        A partition argument for was not in the range 0-255.
        """
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IcePatch2::PartitionOutOfRangeException'

    _M_IcePatch2._t_PartitionOutOfRangeException = IcePy.defineException('::IcePatch2::PartitionOutOfRangeException', PartitionOutOfRangeException, (), False, None, ())
    PartitionOutOfRangeException._ice_type = _M_IcePatch2._t_PartitionOutOfRangeException

    _M_IcePatch2.PartitionOutOfRangeException = PartitionOutOfRangeException
    del PartitionOutOfRangeException

if 'FileAccessException' not in _M_IcePatch2.__dict__:
    _M_IcePatch2.FileAccessException = Ice.createTempClass()
    class FileAccessException(Ice.UserException):
        """
        This exception is raised if a file's contents cannot be read.
        Members:
        reason -- An explanation of the reason for the failure.
        """
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IcePatch2::FileAccessException'

    _M_IcePatch2._t_FileAccessException = IcePy.defineException('::IcePatch2::FileAccessException', FileAccessException, (), False, None, (('reason', (), IcePy._t_string, False, 0),))
    FileAccessException._ice_type = _M_IcePatch2._t_FileAccessException

    _M_IcePatch2.FileAccessException = FileAccessException
    del FileAccessException

if 'FileSizeRangeException' not in _M_IcePatch2.__dict__:
    _M_IcePatch2.FileSizeRangeException = Ice.createTempClass()
    class FileSizeRangeException(_M_IcePatch2.FileAccessException):
        """
        This exception is raised if an operation tries to use a file whose size is
        larger than 2.1 GB. Use the "large" versions of the operations instead.
        """
        def __init__(self, reason=''):
            _M_IcePatch2.FileAccessException.__init__(self, reason)

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IcePatch2::FileSizeRangeException'

    _M_IcePatch2._t_FileSizeRangeException = IcePy.defineException('::IcePatch2::FileSizeRangeException', FileSizeRangeException, (), False, _M_IcePatch2._t_FileAccessException, ())
    FileSizeRangeException._ice_type = _M_IcePatch2._t_FileSizeRangeException

    _M_IcePatch2.FileSizeRangeException = FileSizeRangeException
    del FileSizeRangeException

if 'FileServer' not in _M_IcePatch2.__dict__:
    _M_IcePatch2.FileServer = Ice.createTempClass()
    class FileServer(Ice.Object):
        """
        The interface that provides access to files.
        """
        def __init__(self):
            if Ice.getType(self) == _M_IcePatch2.FileServer:
                raise RuntimeError('IcePatch2.FileServer is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IcePatch2::FileServer')

        def ice_id(self, current=None):
            return '::IcePatch2::FileServer'

        def ice_staticId():
            return '::IcePatch2::FileServer'
        ice_staticId = staticmethod(ice_staticId)

        def getFileInfoSeq(self, partition, current=None):
            """
            Return file information for the specified partition.
             This operation is deprecated and only present for
            compatibility with old Ice clients (older than version 3.6).
            Arguments:
            partition -- The partition number in the range 0-255.
            current -- The Current object for the invocation.
            Returns: A sequence containing information about the files in the specified partition.
            Throws:
            FileSizeRangeException -- If a file is larger than 2.1GB.
            PartitionOutOfRangeException -- If the partition number is out of range.
            """
            pass

        def getLargeFileInfoSeq(self, partition, current=None):
            """
            Returns file information for the specified partition.
            Arguments:
            partition -- The partition number in the range 0-255.
            current -- The Current object for the invocation.
            Returns: A sequence containing information about the files in the specified partition.
            Throws:
            PartitionOutOfRangeException -- If the partition number is out of range.
            """
            pass

        def getChecksumSeq(self, current=None):
            """
            Return the checksums for all partitions.
            Arguments:
            current -- The Current object for the invocation.
            Returns: A sequence containing 256 checksums. Partitions with a checksum that differs from the previous checksum for the same partition contain updated files. Partitions with a checksum that is identical to the previous checksum do not contain updated files.
            """
            pass

        def getChecksum(self, current=None):
            """
            Return the master checksum for all partitions. If this checksum is the same
            as for a previous run, the entire file set is up-to-date.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The master checksum for the file set.
            """
            pass

        def getFileCompressed_async(self, _cb, path, pos, num, current=None):
            """
            Read the specified file. This operation may only return fewer bytes than requested
            in case there was an end-of-file condition.
             This operation is deprecated and only present for
            compatibility with old Ice clients (older than version 3.6).
            Arguments:
            _cb -- The asynchronous callback object.
            path -- The pathname (relative to the data directory) for the file to be read.
            pos -- The file offset at which to begin reading.
            num -- The number of bytes to be read.
            current -- The Current object for the invocation.
            Throws:
            FileAccessException -- If an error occurred while trying to read the file.
            FileSizeRangeException -- If a file is larger than 2.1GB.
            """
            pass

        def getLargeFileCompressed_async(self, _cb, path, pos, num, current=None):
            """
            Read the specified file. This operation may only return fewer bytes than requested
            in case there was an end-of-file condition.
            Arguments:
            _cb -- The asynchronous callback object.
            path -- The pathname (relative to the data directory) for the file to be read.
            pos -- The file offset at which to begin reading.
            num -- The number of bytes to be read.
            current -- The Current object for the invocation.
            Throws:
            FileAccessException -- If an error occurred while trying to read the file.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IcePatch2._t_FileServer)

        __repr__ = __str__

    _M_IcePatch2.FileServerPrx = Ice.createTempClass()
    class FileServerPrx(Ice.ObjectPrx):

        """
        Return file information for the specified partition.
         This operation is deprecated and only present for
        compatibility with old Ice clients (older than version 3.6).
        Arguments:
        partition -- The partition number in the range 0-255.
        _ctx -- The request context for the invocation.
        Returns: A sequence containing information about the files in the specified partition.
        Throws:
        FileSizeRangeException -- If a file is larger than 2.1GB.
        PartitionOutOfRangeException -- If the partition number is out of range.
        """
        def getFileInfoSeq(self, partition, _ctx=None):
            return _M_IcePatch2.FileServer._op_getFileInfoSeq.invoke(self, ((partition, ), _ctx))

        """
        Return file information for the specified partition.
         This operation is deprecated and only present for
        compatibility with old Ice clients (older than version 3.6).
        Arguments:
        partition -- The partition number in the range 0-255.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getFileInfoSeq(self, partition, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IcePatch2.FileServer._op_getFileInfoSeq.begin(self, ((partition, ), _response, _ex, _sent, _ctx))

        """
        Return file information for the specified partition.
         This operation is deprecated and only present for
        compatibility with old Ice clients (older than version 3.6).
        Arguments:
        partition -- The partition number in the range 0-255.
        Returns: A sequence containing information about the files in the specified partition.
        Throws:
        FileSizeRangeException -- If a file is larger than 2.1GB.
        PartitionOutOfRangeException -- If the partition number is out of range.
        """
        def end_getFileInfoSeq(self, _r):
            return _M_IcePatch2.FileServer._op_getFileInfoSeq.end(self, _r)

        """
        Returns file information for the specified partition.
        Arguments:
        partition -- The partition number in the range 0-255.
        _ctx -- The request context for the invocation.
        Returns: A sequence containing information about the files in the specified partition.
        Throws:
        PartitionOutOfRangeException -- If the partition number is out of range.
        """
        def getLargeFileInfoSeq(self, partition, _ctx=None):
            return _M_IcePatch2.FileServer._op_getLargeFileInfoSeq.invoke(self, ((partition, ), _ctx))

        """
        Returns file information for the specified partition.
        Arguments:
        partition -- The partition number in the range 0-255.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getLargeFileInfoSeq(self, partition, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IcePatch2.FileServer._op_getLargeFileInfoSeq.begin(self, ((partition, ), _response, _ex, _sent, _ctx))

        """
        Returns file information for the specified partition.
        Arguments:
        partition -- The partition number in the range 0-255.
        Returns: A sequence containing information about the files in the specified partition.
        Throws:
        PartitionOutOfRangeException -- If the partition number is out of range.
        """
        def end_getLargeFileInfoSeq(self, _r):
            return _M_IcePatch2.FileServer._op_getLargeFileInfoSeq.end(self, _r)

        """
        Return the checksums for all partitions.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: A sequence containing 256 checksums. Partitions with a checksum that differs from the previous checksum for the same partition contain updated files. Partitions with a checksum that is identical to the previous checksum do not contain updated files.
        """
        def getChecksumSeq(self, _ctx=None):
            return _M_IcePatch2.FileServer._op_getChecksumSeq.invoke(self, ((), _ctx))

        """
        Return the checksums for all partitions.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getChecksumSeq(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IcePatch2.FileServer._op_getChecksumSeq.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Return the checksums for all partitions.
        Arguments:
        Returns: A sequence containing 256 checksums. Partitions with a checksum that differs from the previous checksum for the same partition contain updated files. Partitions with a checksum that is identical to the previous checksum do not contain updated files.
        """
        def end_getChecksumSeq(self, _r):
            return _M_IcePatch2.FileServer._op_getChecksumSeq.end(self, _r)

        """
        Return the master checksum for all partitions. If this checksum is the same
        as for a previous run, the entire file set is up-to-date.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The master checksum for the file set.
        """
        def getChecksum(self, _ctx=None):
            return _M_IcePatch2.FileServer._op_getChecksum.invoke(self, ((), _ctx))

        """
        Return the master checksum for all partitions. If this checksum is the same
        as for a previous run, the entire file set is up-to-date.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getChecksum(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IcePatch2.FileServer._op_getChecksum.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Return the master checksum for all partitions. If this checksum is the same
        as for a previous run, the entire file set is up-to-date.
        Arguments:
        Returns: The master checksum for the file set.
        """
        def end_getChecksum(self, _r):
            return _M_IcePatch2.FileServer._op_getChecksum.end(self, _r)

        """
        Read the specified file. This operation may only return fewer bytes than requested
        in case there was an end-of-file condition.
         This operation is deprecated and only present for
        compatibility with old Ice clients (older than version 3.6).
        Arguments:
        path -- The pathname (relative to the data directory) for the file to be read.
        pos -- The file offset at which to begin reading.
        num -- The number of bytes to be read.
        _ctx -- The request context for the invocation.
        Returns: A sequence containing the compressed file contents.
        Throws:
        FileAccessException -- If an error occurred while trying to read the file.
        FileSizeRangeException -- If a file is larger than 2.1GB.
        """
        def getFileCompressed(self, path, pos, num, _ctx=None):
            return _M_IcePatch2.FileServer._op_getFileCompressed.invoke(self, ((path, pos, num), _ctx))

        """
        Read the specified file. This operation may only return fewer bytes than requested
        in case there was an end-of-file condition.
         This operation is deprecated and only present for
        compatibility with old Ice clients (older than version 3.6).
        Arguments:
        path -- The pathname (relative to the data directory) for the file to be read.
        pos -- The file offset at which to begin reading.
        num -- The number of bytes to be read.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getFileCompressed(self, path, pos, num, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IcePatch2.FileServer._op_getFileCompressed.begin(self, ((path, pos, num), _response, _ex, _sent, _ctx))

        """
        Read the specified file. This operation may only return fewer bytes than requested
        in case there was an end-of-file condition.
         This operation is deprecated and only present for
        compatibility with old Ice clients (older than version 3.6).
        Arguments:
        path -- The pathname (relative to the data directory) for the file to be read.
        pos -- The file offset at which to begin reading.
        num -- The number of bytes to be read.
        Returns: A sequence containing the compressed file contents.
        Throws:
        FileAccessException -- If an error occurred while trying to read the file.
        FileSizeRangeException -- If a file is larger than 2.1GB.
        """
        def end_getFileCompressed(self, _r):
            return _M_IcePatch2.FileServer._op_getFileCompressed.end(self, _r)

        """
        Read the specified file. This operation may only return fewer bytes than requested
        in case there was an end-of-file condition.
        Arguments:
        path -- The pathname (relative to the data directory) for the file to be read.
        pos -- The file offset at which to begin reading.
        num -- The number of bytes to be read.
        _ctx -- The request context for the invocation.
        Returns: A sequence containing the compressed file contents.
        Throws:
        FileAccessException -- If an error occurred while trying to read the file.
        """
        def getLargeFileCompressed(self, path, pos, num, _ctx=None):
            return _M_IcePatch2.FileServer._op_getLargeFileCompressed.invoke(self, ((path, pos, num), _ctx))

        """
        Read the specified file. This operation may only return fewer bytes than requested
        in case there was an end-of-file condition.
        Arguments:
        path -- The pathname (relative to the data directory) for the file to be read.
        pos -- The file offset at which to begin reading.
        num -- The number of bytes to be read.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getLargeFileCompressed(self, path, pos, num, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IcePatch2.FileServer._op_getLargeFileCompressed.begin(self, ((path, pos, num), _response, _ex, _sent, _ctx))

        """
        Read the specified file. This operation may only return fewer bytes than requested
        in case there was an end-of-file condition.
        Arguments:
        path -- The pathname (relative to the data directory) for the file to be read.
        pos -- The file offset at which to begin reading.
        num -- The number of bytes to be read.
        Returns: A sequence containing the compressed file contents.
        Throws:
        FileAccessException -- If an error occurred while trying to read the file.
        """
        def end_getLargeFileCompressed(self, _r):
            return _M_IcePatch2.FileServer._op_getLargeFileCompressed.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IcePatch2.FileServerPrx.ice_checkedCast(proxy, '::IcePatch2::FileServer', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IcePatch2.FileServerPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IcePatch2::FileServer'
        ice_staticId = staticmethod(ice_staticId)

    _M_IcePatch2._t_FileServerPrx = IcePy.defineProxy('::IcePatch2::FileServer', FileServerPrx)

    _M_IcePatch2._t_FileServer = IcePy.defineClass('::IcePatch2::FileServer', FileServer, -1, (), True, False, None, (), ())
    FileServer._ice_type = _M_IcePatch2._t_FileServer

    FileServer._op_getFileInfoSeq = IcePy.Operation('getFileInfoSeq', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_int, False, 0),), (), ((), _M_IcePatch2._t_FileInfoSeq, False, 0), (_M_IcePatch2._t_PartitionOutOfRangeException, _M_IcePatch2._t_FileSizeRangeException))
    FileServer._op_getFileInfoSeq.deprecate("getFileInfoSeq() is deprecated, use getLargeFileInfoSeq() instead.")
    FileServer._op_getLargeFileInfoSeq = IcePy.Operation('getLargeFileInfoSeq', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_int, False, 0),), (), ((), _M_IcePatch2._t_LargeFileInfoSeq, False, 0), (_M_IcePatch2._t_PartitionOutOfRangeException,))
    FileServer._op_getChecksumSeq = IcePy.Operation('getChecksumSeq', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_IcePatch2._t_ByteSeqSeq, False, 0), ())
    FileServer._op_getChecksum = IcePy.Operation('getChecksum', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_Ice._t_ByteSeq, False, 0), ())
    FileServer._op_getFileCompressed = IcePy.Operation('getFileCompressed', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, True, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_int, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_Ice._t_ByteSeq, False, 0), (_M_IcePatch2._t_FileAccessException, _M_IcePatch2._t_FileSizeRangeException))
    FileServer._op_getFileCompressed.deprecate("getFileCompressed() is deprecated, use getLargeFileCompressed() instead.")
    FileServer._op_getLargeFileCompressed = IcePy.Operation('getLargeFileCompressed', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, True, None, (), (((), IcePy._t_string, False, 0), ((), IcePy._t_long, False, 0), ((), IcePy._t_int, False, 0)), (), ((), _M_Ice._t_ByteSeq, False, 0), (_M_IcePatch2._t_FileAccessException,))

    _M_IcePatch2.FileServer = FileServer
    del FileServer

    _M_IcePatch2.FileServerPrx = FileServerPrx
    del FileServerPrx

# End of module IcePatch2

Ice.sliceChecksums["::IcePatch2::ByteSeqSeq"] = "4bef9684e41babda8aa55f759a854c"
Ice.sliceChecksums["::IcePatch2::FileAccessException"] = "e94ba15e1b6a3639c2358d2f384648"
Ice.sliceChecksums["::IcePatch2::FileServer"] = "4e2d29a4d5995edae6405e69b265943b"
Ice.sliceChecksums["::IcePatch2::FileSizeRangeException"] = "24ba4c71f6441c58b23a2058cd776c8"
Ice.sliceChecksums["::IcePatch2::PartitionOutOfRangeException"] = "edd324eb399a3f6fecc1a28c2296d8"
