# -*- coding: utf-8 -*-
# **********************************************************************
#
# Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.5
#
# <auto-generated>
#
# Generated from file `FileInfo.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

from sys import version_info as _version_info_
import Ice, IcePy
import Ice_BuiltinSequences_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module IcePatch2
_M_IcePatch2 = Ice.openModule('IcePatch2')
__name__ = 'IcePatch2'

if 'FileInfo' not in _M_IcePatch2.__dict__:
    _M_IcePatch2.FileInfo = Ice.createTempClass()
    class FileInfo(object):
        """
        Basic information about a single file.
        Members:
        path -- The pathname.
        checksum -- The SHA-1 checksum of the file.
        size -- The size of the compressed file in number of bytes.
        executable -- The executable flag.
        """
        def __init__(self, path='', checksum=None, size=0, executable=False):
            self.path = path
            self.checksum = checksum
            self.size = size
            self.executable = executable

        def __hash__(self):
            _h = 0
            _h = 5 * _h + Ice.getHash(self.path)
            if self.checksum:
                for _i0 in self.checksum:
                    _h = 5 * _h + Ice.getHash(_i0)
            _h = 5 * _h + Ice.getHash(self.size)
            _h = 5 * _h + Ice.getHash(self.executable)
            return _h % 0x7fffffff

        def __compare(self, other):
            if other is None:
                return 1
            elif not isinstance(other, _M_IcePatch2.FileInfo):
                return NotImplemented
            else:
                if self.path is None or other.path is None:
                    if self.path != other.path:
                        return (-1 if self.path is None else 1)
                else:
                    if self.path < other.path:
                        return -1
                    elif self.path > other.path:
                        return 1
                if self.checksum is None or other.checksum is None:
                    if self.checksum != other.checksum:
                        return (-1 if self.checksum is None else 1)
                else:
                    if self.checksum < other.checksum:
                        return -1
                    elif self.checksum > other.checksum:
                        return 1
                if self.size is None or other.size is None:
                    if self.size != other.size:
                        return (-1 if self.size is None else 1)
                else:
                    if self.size < other.size:
                        return -1
                    elif self.size > other.size:
                        return 1
                if self.executable is None or other.executable is None:
                    if self.executable != other.executable:
                        return (-1 if self.executable is None else 1)
                else:
                    if self.executable < other.executable:
                        return -1
                    elif self.executable > other.executable:
                        return 1
                return 0

        def __lt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r < 0

        def __le__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r <= 0

        def __gt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r > 0

        def __ge__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r >= 0

        def __eq__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r == 0

        def __ne__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r != 0

        def __str__(self):
            return IcePy.stringify(self, _M_IcePatch2._t_FileInfo)

        __repr__ = __str__

    _M_IcePatch2._t_FileInfo = IcePy.defineStruct('::IcePatch2::FileInfo', FileInfo, (), (
        ('path', (), IcePy._t_string),
        ('checksum', (), _M_Ice._t_ByteSeq),
        ('size', (), IcePy._t_int),
        ('executable', (), IcePy._t_bool)
    ))

    _M_IcePatch2.FileInfo = FileInfo
    del FileInfo

if '_t_FileInfoSeq' not in _M_IcePatch2.__dict__:
    _M_IcePatch2._t_FileInfoSeq = IcePy.defineSequence('::IcePatch2::FileInfoSeq', (), _M_IcePatch2._t_FileInfo)

if 'LargeFileInfo' not in _M_IcePatch2.__dict__:
    _M_IcePatch2.LargeFileInfo = Ice.createTempClass()
    class LargeFileInfo(object):
        """
        Basic information about a single file.
        Members:
        path -- The pathname.
        checksum -- The SHA-1 checksum of the file.
        size -- The size of the compressed file in number of bytes.
        executable -- The executable flag.
        """
        def __init__(self, path='', checksum=None, size=0, executable=False):
            self.path = path
            self.checksum = checksum
            self.size = size
            self.executable = executable

        def __hash__(self):
            _h = 0
            _h = 5 * _h + Ice.getHash(self.path)
            if self.checksum:
                for _i0 in self.checksum:
                    _h = 5 * _h + Ice.getHash(_i0)
            _h = 5 * _h + Ice.getHash(self.size)
            _h = 5 * _h + Ice.getHash(self.executable)
            return _h % 0x7fffffff

        def __compare(self, other):
            if other is None:
                return 1
            elif not isinstance(other, _M_IcePatch2.LargeFileInfo):
                return NotImplemented
            else:
                if self.path is None or other.path is None:
                    if self.path != other.path:
                        return (-1 if self.path is None else 1)
                else:
                    if self.path < other.path:
                        return -1
                    elif self.path > other.path:
                        return 1
                if self.checksum is None or other.checksum is None:
                    if self.checksum != other.checksum:
                        return (-1 if self.checksum is None else 1)
                else:
                    if self.checksum < other.checksum:
                        return -1
                    elif self.checksum > other.checksum:
                        return 1
                if self.size is None or other.size is None:
                    if self.size != other.size:
                        return (-1 if self.size is None else 1)
                else:
                    if self.size < other.size:
                        return -1
                    elif self.size > other.size:
                        return 1
                if self.executable is None or other.executable is None:
                    if self.executable != other.executable:
                        return (-1 if self.executable is None else 1)
                else:
                    if self.executable < other.executable:
                        return -1
                    elif self.executable > other.executable:
                        return 1
                return 0

        def __lt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r < 0

        def __le__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r <= 0

        def __gt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r > 0

        def __ge__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r >= 0

        def __eq__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r == 0

        def __ne__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r != 0

        def __str__(self):
            return IcePy.stringify(self, _M_IcePatch2._t_LargeFileInfo)

        __repr__ = __str__

    _M_IcePatch2._t_LargeFileInfo = IcePy.defineStruct('::IcePatch2::LargeFileInfo', LargeFileInfo, (), (
        ('path', (), IcePy._t_string),
        ('checksum', (), _M_Ice._t_ByteSeq),
        ('size', (), IcePy._t_long),
        ('executable', (), IcePy._t_bool)
    ))

    _M_IcePatch2.LargeFileInfo = LargeFileInfo
    del LargeFileInfo

if '_t_LargeFileInfoSeq' not in _M_IcePatch2.__dict__:
    _M_IcePatch2._t_LargeFileInfoSeq = IcePy.defineSequence('::IcePatch2::LargeFileInfoSeq', (), _M_IcePatch2._t_LargeFileInfo)

# End of module IcePatch2

Ice.sliceChecksums["::IcePatch2::FileInfo"] = "4c71622889c19c7d3b5ef8210245"
Ice.sliceChecksums["::IcePatch2::FileInfoSeq"] = "892945a7a7bfb532f6148c4be9889bd"
Ice.sliceChecksums["::IcePatch2::LargeFileInfo"] = "c711b1cd93bfe8cab428a3201e0f291"
Ice.sliceChecksums["::IcePatch2::LargeFileInfoSeq"] = "96e1aec0272b42f09289701462bb5921"
