# -*- coding: utf-8 -*-
# **********************************************************************
#
# Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.5
#
# <auto-generated>
#
# Generated from file `RemoteLogger.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

from sys import version_info as _version_info_
import Ice, IcePy
import Ice_BuiltinSequences_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module Ice
__name__ = 'Ice'

if 'LogMessageType' not in _M_Ice.__dict__:
    _M_Ice.LogMessageType = Ice.createTempClass()
    class LogMessageType(Ice.EnumBase):
        """
        An enumeration representing the different types of log messages.
        Enumerators:
        PrintMessage -- The Logger received a print message.
        TraceMessage -- The Logger received a trace message.
        WarningMessage -- The Logger received a warning message.
        ErrorMessage -- The Logger received an error message.
        """

        def __init__(self, _n, _v):
            Ice.EnumBase.__init__(self, _n, _v)

        def valueOf(self, _n):
            if _n in self._enumerators:
                return self._enumerators[_n]
            return None
        valueOf = classmethod(valueOf)

    LogMessageType.PrintMessage = LogMessageType("PrintMessage", 0)
    LogMessageType.TraceMessage = LogMessageType("TraceMessage", 1)
    LogMessageType.WarningMessage = LogMessageType("WarningMessage", 2)
    LogMessageType.ErrorMessage = LogMessageType("ErrorMessage", 3)
    LogMessageType._enumerators = { 0:LogMessageType.PrintMessage, 1:LogMessageType.TraceMessage, 2:LogMessageType.WarningMessage, 3:LogMessageType.ErrorMessage }

    _M_Ice._t_LogMessageType = IcePy.defineEnum('::Ice::LogMessageType', LogMessageType, (), LogMessageType._enumerators)

    _M_Ice.LogMessageType = LogMessageType
    del LogMessageType

if '_t_LogMessageTypeSeq' not in _M_Ice.__dict__:
    _M_Ice._t_LogMessageTypeSeq = IcePy.defineSequence('::Ice::LogMessageTypeSeq', (), _M_Ice._t_LogMessageType)

if 'LogMessage' not in _M_Ice.__dict__:
    _M_Ice.LogMessage = Ice.createTempClass()
    class LogMessage(object):
        """
        A complete log message.
        Members:
        type -- The type of message sent to the Logger.
        timestamp -- The date and time when the Logger received this message, expressed
        as the number of microseconds since the Unix Epoch (00:00:00 UTC on 1 January 1970)
        traceCategory -- For a message of type trace, the trace category of this log message;
        otherwise, the empty string.
        message -- The log message itself.
        """
        def __init__(self, type=_M_Ice.LogMessageType.PrintMessage, timestamp=0, traceCategory='', message=''):
            self.type = type
            self.timestamp = timestamp
            self.traceCategory = traceCategory
            self.message = message

        def __hash__(self):
            _h = 0
            _h = 5 * _h + Ice.getHash(self.type)
            _h = 5 * _h + Ice.getHash(self.timestamp)
            _h = 5 * _h + Ice.getHash(self.traceCategory)
            _h = 5 * _h + Ice.getHash(self.message)
            return _h % 0x7fffffff

        def __compare(self, other):
            if other is None:
                return 1
            elif not isinstance(other, _M_Ice.LogMessage):
                return NotImplemented
            else:
                if self.type is None or other.type is None:
                    if self.type != other.type:
                        return (-1 if self.type is None else 1)
                else:
                    if self.type < other.type:
                        return -1
                    elif self.type > other.type:
                        return 1
                if self.timestamp is None or other.timestamp is None:
                    if self.timestamp != other.timestamp:
                        return (-1 if self.timestamp is None else 1)
                else:
                    if self.timestamp < other.timestamp:
                        return -1
                    elif self.timestamp > other.timestamp:
                        return 1
                if self.traceCategory is None or other.traceCategory is None:
                    if self.traceCategory != other.traceCategory:
                        return (-1 if self.traceCategory is None else 1)
                else:
                    if self.traceCategory < other.traceCategory:
                        return -1
                    elif self.traceCategory > other.traceCategory:
                        return 1
                if self.message is None or other.message is None:
                    if self.message != other.message:
                        return (-1 if self.message is None else 1)
                else:
                    if self.message < other.message:
                        return -1
                    elif self.message > other.message:
                        return 1
                return 0

        def __lt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r < 0

        def __le__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r <= 0

        def __gt__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r > 0

        def __ge__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r >= 0

        def __eq__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r == 0

        def __ne__(self, other):
            r = self.__compare(other)
            if r is NotImplemented:
                return r
            else:
                return r != 0

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_LogMessage)

        __repr__ = __str__

    _M_Ice._t_LogMessage = IcePy.defineStruct('::Ice::LogMessage', LogMessage, (), (
        ('type', (), _M_Ice._t_LogMessageType),
        ('timestamp', (), IcePy._t_long),
        ('traceCategory', (), IcePy._t_string),
        ('message', (), IcePy._t_string)
    ))

    _M_Ice.LogMessage = LogMessage
    del LogMessage

if '_t_LogMessageSeq' not in _M_Ice.__dict__:
    _M_Ice._t_LogMessageSeq = IcePy.defineSequence('::Ice::LogMessageSeq', (), _M_Ice._t_LogMessage)

if 'RemoteLogger' not in _M_Ice.__dict__:
    _M_Ice.RemoteLogger = Ice.createTempClass()
    class RemoteLogger(Ice.Object):
        """
        The Ice remote logger interface. An application can implement a
        RemoteLogger to receive the log messages sent to the local Logger
        of another Ice application.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Ice.RemoteLogger:
                raise RuntimeError('Ice.RemoteLogger is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::Ice::RemoteLogger')

        def ice_id(self, current=None):
            return '::Ice::RemoteLogger'

        def ice_staticId():
            return '::Ice::RemoteLogger'
        ice_staticId = staticmethod(ice_staticId)

        def init(self, prefix, logMessages, current=None):
            """
            init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
            Arguments:
            prefix -- The prefix of the associated local Logger.
            logMessages -- Old log messages generated before "now".
            current -- The Current object for the invocation.
            """
            pass

        def log(self, message, current=None):
            """
            Log a LogMessage. Note that log may be called by LoggerAdmin before init.
            Arguments:
            message -- The message to log.
            current -- The Current object for the invocation.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_RemoteLogger)

        __repr__ = __str__

    _M_Ice.RemoteLoggerPrx = Ice.createTempClass()
    class RemoteLoggerPrx(Ice.ObjectPrx):

        """
        init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
        Arguments:
        prefix -- The prefix of the associated local Logger.
        logMessages -- Old log messages generated before "now".
        _ctx -- The request context for the invocation.
        """
        def init(self, prefix, logMessages, _ctx=None):
            return _M_Ice.RemoteLogger._op_init.invoke(self, ((prefix, logMessages), _ctx))

        """
        init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
        Arguments:
        prefix -- The prefix of the associated local Logger.
        logMessages -- Old log messages generated before "now".
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_init(self, prefix, logMessages, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.RemoteLogger._op_init.begin(self, ((prefix, logMessages), _response, _ex, _sent, _ctx))

        """
        init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
        Arguments:
        prefix -- The prefix of the associated local Logger.
        logMessages -- Old log messages generated before "now".
        """
        def end_init(self, _r):
            return _M_Ice.RemoteLogger._op_init.end(self, _r)

        """
        Log a LogMessage. Note that log may be called by LoggerAdmin before init.
        Arguments:
        message -- The message to log.
        _ctx -- The request context for the invocation.
        """
        def log(self, message, _ctx=None):
            return _M_Ice.RemoteLogger._op_log.invoke(self, ((message, ), _ctx))

        """
        Log a LogMessage. Note that log may be called by LoggerAdmin before init.
        Arguments:
        message -- The message to log.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_log(self, message, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.RemoteLogger._op_log.begin(self, ((message, ), _response, _ex, _sent, _ctx))

        """
        Log a LogMessage. Note that log may be called by LoggerAdmin before init.
        Arguments:
        message -- The message to log.
        """
        def end_log(self, _r):
            return _M_Ice.RemoteLogger._op_log.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Ice.RemoteLoggerPrx.ice_checkedCast(proxy, '::Ice::RemoteLogger', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Ice.RemoteLoggerPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Ice::RemoteLogger'
        ice_staticId = staticmethod(ice_staticId)

    _M_Ice._t_RemoteLoggerPrx = IcePy.defineProxy('::Ice::RemoteLogger', RemoteLoggerPrx)

    _M_Ice._t_RemoteLogger = IcePy.defineClass('::Ice::RemoteLogger', RemoteLogger, -1, (), True, False, None, (), ())
    RemoteLogger._ice_type = _M_Ice._t_RemoteLogger

    RemoteLogger._op_init = IcePy.Operation('init', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0), ((), _M_Ice._t_LogMessageSeq, False, 0)), (), None, ())
    RemoteLogger._op_log = IcePy.Operation('log', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_Ice._t_LogMessage, False, 0),), (), None, ())

    _M_Ice.RemoteLogger = RemoteLogger
    del RemoteLogger

    _M_Ice.RemoteLoggerPrx = RemoteLoggerPrx
    del RemoteLoggerPrx

if 'RemoteLoggerAlreadyAttachedException' not in _M_Ice.__dict__:
    _M_Ice.RemoteLoggerAlreadyAttachedException = Ice.createTempClass()
    class RemoteLoggerAlreadyAttachedException(Ice.UserException):
        """
        Thrown when the provided RemoteLogger was previously attached to a LoggerAdmin.
        """
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Ice::RemoteLoggerAlreadyAttachedException'

    _M_Ice._t_RemoteLoggerAlreadyAttachedException = IcePy.defineException('::Ice::RemoteLoggerAlreadyAttachedException', RemoteLoggerAlreadyAttachedException, (), False, None, ())
    RemoteLoggerAlreadyAttachedException._ice_type = _M_Ice._t_RemoteLoggerAlreadyAttachedException

    _M_Ice.RemoteLoggerAlreadyAttachedException = RemoteLoggerAlreadyAttachedException
    del RemoteLoggerAlreadyAttachedException

if 'LoggerAdmin' not in _M_Ice.__dict__:
    _M_Ice.LoggerAdmin = Ice.createTempClass()
    class LoggerAdmin(Ice.Object):
        """
        The interface of the admin object that allows an Ice application the attach its
        RemoteLogger to the Logger of this admin object's Ice communicator.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Ice.LoggerAdmin:
                raise RuntimeError('Ice.LoggerAdmin is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::LoggerAdmin', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Ice::LoggerAdmin'

        def ice_staticId():
            return '::Ice::LoggerAdmin'
        ice_staticId = staticmethod(ice_staticId)

        def attachRemoteLogger(self, prx, messageTypes, traceCategories, messageMax, current=None):
            """
            Attaches a RemoteLogger object to the local logger.
            attachRemoteLogger calls init on the provided RemoteLogger proxy.
            Arguments:
            prx -- A proxy to the remote logger.
            messageTypes -- The list of message types that the remote logger wishes to receive. An empty list means no filtering (send all message types).
            traceCategories -- The categories of traces that the remote logger wishes to receive. This parameter is ignored if messageTypes is not empty and does not include trace. An empty list means no filtering (send all trace categories).
            messageMax -- The maximum number of log messages (of all types) to be provided to init. A negative value requests all messages available.
            current -- The Current object for the invocation.
            Throws:
            RemoteLoggerAlreadyAttachedException -- Raised if this remote logger is already attached to this admin object.
            """
            pass

        def detachRemoteLogger(self, prx, current=None):
            """
            Detaches a RemoteLogger object from the local logger.
            Arguments:
            prx -- A proxy to the remote logger.
            current -- The Current object for the invocation.
            Returns: True if the provided remote logger proxy was detached, and false otherwise.
            """
            pass

        def getLog(self, messageTypes, traceCategories, messageMax, current=None):
            """
            Retrieves log messages recently logged.
            Arguments:
            messageTypes -- The list of message types that the caller wishes to receive. An empty list means no filtering (send all message types).
            traceCategories -- The categories of traces that caller wish to receive. This parameter is ignored if messageTypes is not empty and does not include trace. An empty list means no filtering (send all trace categories).
            messageMax -- The maximum number of log messages (of all types) to be returned. A negative value requests all messages available.
            current -- The Current object for the invocation.
            Returns a tuple containing the following:
            _retval -- The Log messages.
            prefix -- The prefix of the associated local logger.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_LoggerAdmin)

        __repr__ = __str__

    _M_Ice.LoggerAdminPrx = Ice.createTempClass()
    class LoggerAdminPrx(Ice.ObjectPrx):

        """
        Attaches a RemoteLogger object to the local logger.
        attachRemoteLogger calls init on the provided RemoteLogger proxy.
        Arguments:
        prx -- A proxy to the remote logger.
        messageTypes -- The list of message types that the remote logger wishes to receive. An empty list means no filtering (send all message types).
        traceCategories -- The categories of traces that the remote logger wishes to receive. This parameter is ignored if messageTypes is not empty and does not include trace. An empty list means no filtering (send all trace categories).
        messageMax -- The maximum number of log messages (of all types) to be provided to init. A negative value requests all messages available.
        _ctx -- The request context for the invocation.
        Throws:
        RemoteLoggerAlreadyAttachedException -- Raised if this remote logger is already attached to this admin object.
        """
        def attachRemoteLogger(self, prx, messageTypes, traceCategories, messageMax, _ctx=None):
            return _M_Ice.LoggerAdmin._op_attachRemoteLogger.invoke(self, ((prx, messageTypes, traceCategories, messageMax), _ctx))

        """
        Attaches a RemoteLogger object to the local logger.
        attachRemoteLogger calls init on the provided RemoteLogger proxy.
        Arguments:
        prx -- A proxy to the remote logger.
        messageTypes -- The list of message types that the remote logger wishes to receive. An empty list means no filtering (send all message types).
        traceCategories -- The categories of traces that the remote logger wishes to receive. This parameter is ignored if messageTypes is not empty and does not include trace. An empty list means no filtering (send all trace categories).
        messageMax -- The maximum number of log messages (of all types) to be provided to init. A negative value requests all messages available.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_attachRemoteLogger(self, prx, messageTypes, traceCategories, messageMax, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.LoggerAdmin._op_attachRemoteLogger.begin(self, ((prx, messageTypes, traceCategories, messageMax), _response, _ex, _sent, _ctx))

        """
        Attaches a RemoteLogger object to the local logger.
        attachRemoteLogger calls init on the provided RemoteLogger proxy.
        Arguments:
        prx -- A proxy to the remote logger.
        messageTypes -- The list of message types that the remote logger wishes to receive. An empty list means no filtering (send all message types).
        traceCategories -- The categories of traces that the remote logger wishes to receive. This parameter is ignored if messageTypes is not empty and does not include trace. An empty list means no filtering (send all trace categories).
        messageMax -- The maximum number of log messages (of all types) to be provided to init. A negative value requests all messages available.
        Throws:
        RemoteLoggerAlreadyAttachedException -- Raised if this remote logger is already attached to this admin object.
        """
        def end_attachRemoteLogger(self, _r):
            return _M_Ice.LoggerAdmin._op_attachRemoteLogger.end(self, _r)

        """
        Detaches a RemoteLogger object from the local logger.
        Arguments:
        prx -- A proxy to the remote logger.
        _ctx -- The request context for the invocation.
        Returns: True if the provided remote logger proxy was detached, and false otherwise.
        """
        def detachRemoteLogger(self, prx, _ctx=None):
            return _M_Ice.LoggerAdmin._op_detachRemoteLogger.invoke(self, ((prx, ), _ctx))

        """
        Detaches a RemoteLogger object from the local logger.
        Arguments:
        prx -- A proxy to the remote logger.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_detachRemoteLogger(self, prx, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.LoggerAdmin._op_detachRemoteLogger.begin(self, ((prx, ), _response, _ex, _sent, _ctx))

        """
        Detaches a RemoteLogger object from the local logger.
        Arguments:
        prx -- A proxy to the remote logger.
        Returns: True if the provided remote logger proxy was detached, and false otherwise.
        """
        def end_detachRemoteLogger(self, _r):
            return _M_Ice.LoggerAdmin._op_detachRemoteLogger.end(self, _r)

        """
        Retrieves log messages recently logged.
        Arguments:
        messageTypes -- The list of message types that the caller wishes to receive. An empty list means no filtering (send all message types).
        traceCategories -- The categories of traces that caller wish to receive. This parameter is ignored if messageTypes is not empty and does not include trace. An empty list means no filtering (send all trace categories).
        messageMax -- The maximum number of log messages (of all types) to be returned. A negative value requests all messages available.
        _ctx -- The request context for the invocation.
        Returns a tuple containing the following:
        _retval -- The Log messages.
        prefix -- The prefix of the associated local logger.
        """
        def getLog(self, messageTypes, traceCategories, messageMax, _ctx=None):
            return _M_Ice.LoggerAdmin._op_getLog.invoke(self, ((messageTypes, traceCategories, messageMax), _ctx))

        """
        Retrieves log messages recently logged.
        Arguments:
        messageTypes -- The list of message types that the caller wishes to receive. An empty list means no filtering (send all message types).
        traceCategories -- The categories of traces that caller wish to receive. This parameter is ignored if messageTypes is not empty and does not include trace. An empty list means no filtering (send all trace categories).
        messageMax -- The maximum number of log messages (of all types) to be returned. A negative value requests all messages available.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getLog(self, messageTypes, traceCategories, messageMax, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Ice.LoggerAdmin._op_getLog.begin(self, ((messageTypes, traceCategories, messageMax), _response, _ex, _sent, _ctx))

        """
        Retrieves log messages recently logged.
        Arguments:
        messageTypes -- The list of message types that the caller wishes to receive. An empty list means no filtering (send all message types).
        traceCategories -- The categories of traces that caller wish to receive. This parameter is ignored if messageTypes is not empty and does not include trace. An empty list means no filtering (send all trace categories).
        messageMax -- The maximum number of log messages (of all types) to be returned. A negative value requests all messages available.
        Returns a tuple containing the following:
        _retval -- The Log messages.
        prefix -- The prefix of the associated local logger.
        """
        def end_getLog(self, _r):
            return _M_Ice.LoggerAdmin._op_getLog.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Ice.LoggerAdminPrx.ice_checkedCast(proxy, '::Ice::LoggerAdmin', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Ice.LoggerAdminPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Ice::LoggerAdmin'
        ice_staticId = staticmethod(ice_staticId)

    _M_Ice._t_LoggerAdminPrx = IcePy.defineProxy('::Ice::LoggerAdmin', LoggerAdminPrx)

    _M_Ice._t_LoggerAdmin = IcePy.defineClass('::Ice::LoggerAdmin', LoggerAdmin, -1, (), True, False, None, (), ())
    LoggerAdmin._ice_type = _M_Ice._t_LoggerAdmin

    LoggerAdmin._op_attachRemoteLogger = IcePy.Operation('attachRemoteLogger', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_Ice._t_RemoteLoggerPrx, False, 0), ((), _M_Ice._t_LogMessageTypeSeq, False, 0), ((), _M_Ice._t_StringSeq, False, 0), ((), IcePy._t_int, False, 0)), (), None, (_M_Ice._t_RemoteLoggerAlreadyAttachedException,))
    LoggerAdmin._op_detachRemoteLogger = IcePy.Operation('detachRemoteLogger', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_Ice._t_RemoteLoggerPrx, False, 0),), (), ((), IcePy._t_bool, False, 0), ())
    LoggerAdmin._op_getLog = IcePy.Operation('getLog', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_Ice._t_LogMessageTypeSeq, False, 0), ((), _M_Ice._t_StringSeq, False, 0), ((), IcePy._t_int, False, 0)), (((), IcePy._t_string, False, 0),), ((), _M_Ice._t_LogMessageSeq, False, 0), ())

    _M_Ice.LoggerAdmin = LoggerAdmin
    del LoggerAdmin

    _M_Ice.LoggerAdminPrx = LoggerAdminPrx
    del LoggerAdminPrx

# End of module Ice
