# -*- coding: utf-8 -*-
# **********************************************************************
#
# Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.5
#
# <auto-generated>
#
# Generated from file `Session.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

from sys import version_info as _version_info_
import Ice, IcePy
import Ice_BuiltinSequences_ice
import Ice_Identity_ice
import Glacier2_SSLInfo_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')

# Start of module Glacier2
__name__ = 'Glacier2'

if 'CannotCreateSessionException' not in _M_Glacier2.__dict__:
    _M_Glacier2.CannotCreateSessionException = Ice.createTempClass()
    class CannotCreateSessionException(Ice.UserException):
        """
        This exception is raised if an attempt to create a new session failed.
        Members:
        reason -- The reason why session creation has failed.
        """
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'Glacier2::CannotCreateSessionException'

    _M_Glacier2._t_CannotCreateSessionException = IcePy.defineException('::Glacier2::CannotCreateSessionException', CannotCreateSessionException, (), True, None, (('reason', (), IcePy._t_string, False, 0),))
    CannotCreateSessionException._ice_type = _M_Glacier2._t_CannotCreateSessionException

    _M_Glacier2.CannotCreateSessionException = CannotCreateSessionException
    del CannotCreateSessionException

if 'Session' not in _M_Glacier2.__dict__:
    _M_Glacier2.Session = Ice.createTempClass()
    class Session(Ice.Object):
        """
        A client-visible session object, which is tied to the lifecycle of
        a Router.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Glacier2.Session:
                raise RuntimeError('Glacier2.Session is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::Session', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Glacier2::Session'

        def ice_staticId():
            return '::Glacier2::Session'
        ice_staticId = staticmethod(ice_staticId)

        def destroy(self, current=None):
            """
            Destroy the session. This is called automatically when the router is destroyed.
            Arguments:
            current -- The Current object for the invocation.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_Session)

        __repr__ = __str__

    _M_Glacier2.SessionPrx = Ice.createTempClass()
    class SessionPrx(Ice.ObjectPrx):

        """
        Destroy the session. This is called automatically when the router is destroyed.
        Arguments:
        _ctx -- The request context for the invocation.
        """
        def destroy(self, _ctx=None):
            return _M_Glacier2.Session._op_destroy.invoke(self, ((), _ctx))

        """
        Destroy the session. This is called automatically when the router is destroyed.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_destroy(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.Session._op_destroy.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Destroy the session. This is called automatically when the router is destroyed.
        Arguments:
        """
        def end_destroy(self, _r):
            return _M_Glacier2.Session._op_destroy.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Glacier2.SessionPrx.ice_checkedCast(proxy, '::Glacier2::Session', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Glacier2.SessionPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Glacier2::Session'
        ice_staticId = staticmethod(ice_staticId)

    _M_Glacier2._t_SessionPrx = IcePy.defineProxy('::Glacier2::Session', SessionPrx)

    _M_Glacier2._t_Session = IcePy.defineClass('::Glacier2::Session', Session, -1, (), True, False, None, (), ())
    Session._ice_type = _M_Glacier2._t_Session

    Session._op_destroy = IcePy.Operation('destroy', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), None, ())

    _M_Glacier2.Session = Session
    del Session

    _M_Glacier2.SessionPrx = SessionPrx
    del SessionPrx

if 'StringSet' not in _M_Glacier2.__dict__:
    _M_Glacier2.StringSet = Ice.createTempClass()
    class StringSet(Ice.Object):
        """
        An object for managing the set of identity constraints for specific
        parts of object identity on a
        Session.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Glacier2.StringSet:
                raise RuntimeError('Glacier2.StringSet is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::StringSet', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Glacier2::StringSet'

        def ice_staticId():
            return '::Glacier2::StringSet'
        ice_staticId = staticmethod(ice_staticId)

        def add(self, additions, current=None):
            """
            Add a sequence of strings to this set of constraints. Order is
            not preserved and duplicates are implicitly removed.
            Arguments:
            additions -- The sequence of strings to be added.
            current -- The Current object for the invocation.
            """
            pass

        def remove(self, deletions, current=None):
            """
            Remove a sequence of strings from this set of constraints. No
            errors are returned if an entry is not found.
            Arguments:
            deletions -- The sequence of strings to be removed.
            current -- The Current object for the invocation.
            """
            pass

        def get(self, current=None):
            """
            Returns a sequence of strings describing the constraints in this
            set.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The sequence of strings for this set.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_StringSet)

        __repr__ = __str__

    _M_Glacier2.StringSetPrx = Ice.createTempClass()
    class StringSetPrx(Ice.ObjectPrx):

        """
        Add a sequence of strings to this set of constraints. Order is
        not preserved and duplicates are implicitly removed.
        Arguments:
        additions -- The sequence of strings to be added.
        _ctx -- The request context for the invocation.
        """
        def add(self, additions, _ctx=None):
            return _M_Glacier2.StringSet._op_add.invoke(self, ((additions, ), _ctx))

        """
        Add a sequence of strings to this set of constraints. Order is
        not preserved and duplicates are implicitly removed.
        Arguments:
        additions -- The sequence of strings to be added.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_add(self, additions, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.StringSet._op_add.begin(self, ((additions, ), _response, _ex, _sent, _ctx))

        """
        Add a sequence of strings to this set of constraints. Order is
        not preserved and duplicates are implicitly removed.
        Arguments:
        additions -- The sequence of strings to be added.
        """
        def end_add(self, _r):
            return _M_Glacier2.StringSet._op_add.end(self, _r)

        """
        Remove a sequence of strings from this set of constraints. No
        errors are returned if an entry is not found.
        Arguments:
        deletions -- The sequence of strings to be removed.
        _ctx -- The request context for the invocation.
        """
        def remove(self, deletions, _ctx=None):
            return _M_Glacier2.StringSet._op_remove.invoke(self, ((deletions, ), _ctx))

        """
        Remove a sequence of strings from this set of constraints. No
        errors are returned if an entry is not found.
        Arguments:
        deletions -- The sequence of strings to be removed.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_remove(self, deletions, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.StringSet._op_remove.begin(self, ((deletions, ), _response, _ex, _sent, _ctx))

        """
        Remove a sequence of strings from this set of constraints. No
        errors are returned if an entry is not found.
        Arguments:
        deletions -- The sequence of strings to be removed.
        """
        def end_remove(self, _r):
            return _M_Glacier2.StringSet._op_remove.end(self, _r)

        """
        Returns a sequence of strings describing the constraints in this
        set.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The sequence of strings for this set.
        """
        def get(self, _ctx=None):
            return _M_Glacier2.StringSet._op_get.invoke(self, ((), _ctx))

        """
        Returns a sequence of strings describing the constraints in this
        set.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_get(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.StringSet._op_get.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Returns a sequence of strings describing the constraints in this
        set.
        Arguments:
        Returns: The sequence of strings for this set.
        """
        def end_get(self, _r):
            return _M_Glacier2.StringSet._op_get.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Glacier2.StringSetPrx.ice_checkedCast(proxy, '::Glacier2::StringSet', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Glacier2.StringSetPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Glacier2::StringSet'
        ice_staticId = staticmethod(ice_staticId)

    _M_Glacier2._t_StringSetPrx = IcePy.defineProxy('::Glacier2::StringSet', StringSetPrx)

    _M_Glacier2._t_StringSet = IcePy.defineClass('::Glacier2::StringSet', StringSet, -1, (), True, False, None, (), ())
    StringSet._ice_type = _M_Glacier2._t_StringSet

    StringSet._op_add = IcePy.Operation('add', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), _M_Ice._t_StringSeq, False, 0),), (), None, ())
    StringSet._op_remove = IcePy.Operation('remove', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), _M_Ice._t_StringSeq, False, 0),), (), None, ())
    StringSet._op_get = IcePy.Operation('get', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (), (), ((), _M_Ice._t_StringSeq, False, 0), ())

    _M_Glacier2.StringSet = StringSet
    del StringSet

    _M_Glacier2.StringSetPrx = StringSetPrx
    del StringSetPrx

if 'IdentitySet' not in _M_Glacier2.__dict__:
    _M_Glacier2.IdentitySet = Ice.createTempClass()
    class IdentitySet(Ice.Object):
        """
        An object for managing the set of object identity constraints on a
        Session.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Glacier2.IdentitySet:
                raise RuntimeError('Glacier2.IdentitySet is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::IdentitySet', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Glacier2::IdentitySet'

        def ice_staticId():
            return '::Glacier2::IdentitySet'
        ice_staticId = staticmethod(ice_staticId)

        def add(self, additions, current=None):
            """
            Add a sequence of Ice identities to this set of constraints. Order is
            not preserved and duplicates are implicitly removed.
            Arguments:
            additions -- The sequence of Ice identities to be added.
            current -- The Current object for the invocation.
            """
            pass

        def remove(self, deletions, current=None):
            """
            Remove a sequence of identities from this set of constraints. No
            errors are returned if an entry is not found.
            Arguments:
            deletions -- The sequence of Ice identities to be removed.
            current -- The Current object for the invocation.
            """
            pass

        def get(self, current=None):
            """
            Returns a sequence of identities describing the constraints in this
            set.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The sequence of Ice identities for this set.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_IdentitySet)

        __repr__ = __str__

    _M_Glacier2.IdentitySetPrx = Ice.createTempClass()
    class IdentitySetPrx(Ice.ObjectPrx):

        """
        Add a sequence of Ice identities to this set of constraints. Order is
        not preserved and duplicates are implicitly removed.
        Arguments:
        additions -- The sequence of Ice identities to be added.
        _ctx -- The request context for the invocation.
        """
        def add(self, additions, _ctx=None):
            return _M_Glacier2.IdentitySet._op_add.invoke(self, ((additions, ), _ctx))

        """
        Add a sequence of Ice identities to this set of constraints. Order is
        not preserved and duplicates are implicitly removed.
        Arguments:
        additions -- The sequence of Ice identities to be added.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_add(self, additions, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.IdentitySet._op_add.begin(self, ((additions, ), _response, _ex, _sent, _ctx))

        """
        Add a sequence of Ice identities to this set of constraints. Order is
        not preserved and duplicates are implicitly removed.
        Arguments:
        additions -- The sequence of Ice identities to be added.
        """
        def end_add(self, _r):
            return _M_Glacier2.IdentitySet._op_add.end(self, _r)

        """
        Remove a sequence of identities from this set of constraints. No
        errors are returned if an entry is not found.
        Arguments:
        deletions -- The sequence of Ice identities to be removed.
        _ctx -- The request context for the invocation.
        """
        def remove(self, deletions, _ctx=None):
            return _M_Glacier2.IdentitySet._op_remove.invoke(self, ((deletions, ), _ctx))

        """
        Remove a sequence of identities from this set of constraints. No
        errors are returned if an entry is not found.
        Arguments:
        deletions -- The sequence of Ice identities to be removed.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_remove(self, deletions, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.IdentitySet._op_remove.begin(self, ((deletions, ), _response, _ex, _sent, _ctx))

        """
        Remove a sequence of identities from this set of constraints. No
        errors are returned if an entry is not found.
        Arguments:
        deletions -- The sequence of Ice identities to be removed.
        """
        def end_remove(self, _r):
            return _M_Glacier2.IdentitySet._op_remove.end(self, _r)

        """
        Returns a sequence of identities describing the constraints in this
        set.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The sequence of Ice identities for this set.
        """
        def get(self, _ctx=None):
            return _M_Glacier2.IdentitySet._op_get.invoke(self, ((), _ctx))

        """
        Returns a sequence of identities describing the constraints in this
        set.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_get(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.IdentitySet._op_get.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Returns a sequence of identities describing the constraints in this
        set.
        Arguments:
        Returns: The sequence of Ice identities for this set.
        """
        def end_get(self, _r):
            return _M_Glacier2.IdentitySet._op_get.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Glacier2.IdentitySetPrx.ice_checkedCast(proxy, '::Glacier2::IdentitySet', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Glacier2.IdentitySetPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Glacier2::IdentitySet'
        ice_staticId = staticmethod(ice_staticId)

    _M_Glacier2._t_IdentitySetPrx = IcePy.defineProxy('::Glacier2::IdentitySet', IdentitySetPrx)

    _M_Glacier2._t_IdentitySet = IcePy.defineClass('::Glacier2::IdentitySet', IdentitySet, -1, (), True, False, None, (), ())
    IdentitySet._ice_type = _M_Glacier2._t_IdentitySet

    IdentitySet._op_add = IcePy.Operation('add', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), _M_Ice._t_IdentitySeq, False, 0),), (), None, ())
    IdentitySet._op_remove = IcePy.Operation('remove', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), _M_Ice._t_IdentitySeq, False, 0),), (), None, ())
    IdentitySet._op_get = IcePy.Operation('get', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (), (), ((), _M_Ice._t_IdentitySeq, False, 0), ())

    _M_Glacier2.IdentitySet = IdentitySet
    del IdentitySet

    _M_Glacier2.IdentitySetPrx = IdentitySetPrx
    del IdentitySetPrx

if 'SessionControl' not in _M_Glacier2.__dict__:
    _M_Glacier2.SessionControl = Ice.createTempClass()
    class SessionControl(Ice.Object):
        """
        An administrative session control object, which is tied to the
        lifecycle of a Session.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Glacier2.SessionControl:
                raise RuntimeError('Glacier2.SessionControl is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::SessionControl', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Glacier2::SessionControl'

        def ice_staticId():
            return '::Glacier2::SessionControl'
        ice_staticId = staticmethod(ice_staticId)

        def categories(self, current=None):
            """
            Access the object that manages the allowable categories
            for object identities for this session.
            Arguments:
            current -- The Current object for the invocation.
            Returns: A StringSet object.
            """
            pass

        def adapterIds(self, current=None):
            """
            Access the object that manages the allowable adapter identities
            for objects for this session.
            Arguments:
            current -- The Current object for the invocation.
            Returns: A StringSet object.
            """
            pass

        def identities(self, current=None):
            """
            Access the object that manages the allowable object identities
            for this session.
            Arguments:
            current -- The Current object for the invocation.
            Returns: An IdentitySet object.
            """
            pass

        def getSessionTimeout(self, current=None):
            """
            Get the session timeout.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The timeout.
            """
            pass

        def destroy(self, current=None):
            """
            Destroy the associated session.
            Arguments:
            current -- The Current object for the invocation.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_SessionControl)

        __repr__ = __str__

    _M_Glacier2.SessionControlPrx = Ice.createTempClass()
    class SessionControlPrx(Ice.ObjectPrx):

        """
        Access the object that manages the allowable categories
        for object identities for this session.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: A StringSet object.
        """
        def categories(self, _ctx=None):
            return _M_Glacier2.SessionControl._op_categories.invoke(self, ((), _ctx))

        """
        Access the object that manages the allowable categories
        for object identities for this session.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_categories(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.SessionControl._op_categories.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Access the object that manages the allowable categories
        for object identities for this session.
        Arguments:
        Returns: A StringSet object.
        """
        def end_categories(self, _r):
            return _M_Glacier2.SessionControl._op_categories.end(self, _r)

        """
        Access the object that manages the allowable adapter identities
        for objects for this session.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: A StringSet object.
        """
        def adapterIds(self, _ctx=None):
            return _M_Glacier2.SessionControl._op_adapterIds.invoke(self, ((), _ctx))

        """
        Access the object that manages the allowable adapter identities
        for objects for this session.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_adapterIds(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.SessionControl._op_adapterIds.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Access the object that manages the allowable adapter identities
        for objects for this session.
        Arguments:
        Returns: A StringSet object.
        """
        def end_adapterIds(self, _r):
            return _M_Glacier2.SessionControl._op_adapterIds.end(self, _r)

        """
        Access the object that manages the allowable object identities
        for this session.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: An IdentitySet object.
        """
        def identities(self, _ctx=None):
            return _M_Glacier2.SessionControl._op_identities.invoke(self, ((), _ctx))

        """
        Access the object that manages the allowable object identities
        for this session.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_identities(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.SessionControl._op_identities.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Access the object that manages the allowable object identities
        for this session.
        Arguments:
        Returns: An IdentitySet object.
        """
        def end_identities(self, _r):
            return _M_Glacier2.SessionControl._op_identities.end(self, _r)

        """
        Get the session timeout.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The timeout.
        """
        def getSessionTimeout(self, _ctx=None):
            return _M_Glacier2.SessionControl._op_getSessionTimeout.invoke(self, ((), _ctx))

        """
        Get the session timeout.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getSessionTimeout(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.SessionControl._op_getSessionTimeout.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Get the session timeout.
        Arguments:
        Returns: The timeout.
        """
        def end_getSessionTimeout(self, _r):
            return _M_Glacier2.SessionControl._op_getSessionTimeout.end(self, _r)

        """
        Destroy the associated session.
        Arguments:
        _ctx -- The request context for the invocation.
        """
        def destroy(self, _ctx=None):
            return _M_Glacier2.SessionControl._op_destroy.invoke(self, ((), _ctx))

        """
        Destroy the associated session.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_destroy(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.SessionControl._op_destroy.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Destroy the associated session.
        Arguments:
        """
        def end_destroy(self, _r):
            return _M_Glacier2.SessionControl._op_destroy.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Glacier2.SessionControlPrx.ice_checkedCast(proxy, '::Glacier2::SessionControl', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Glacier2.SessionControlPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Glacier2::SessionControl'
        ice_staticId = staticmethod(ice_staticId)

    _M_Glacier2._t_SessionControlPrx = IcePy.defineProxy('::Glacier2::SessionControl', SessionControlPrx)

    _M_Glacier2._t_SessionControl = IcePy.defineClass('::Glacier2::SessionControl', SessionControl, -1, (), True, False, None, (), ())
    SessionControl._ice_type = _M_Glacier2._t_SessionControl

    SessionControl._op_categories = IcePy.Operation('categories', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), ((), _M_Glacier2._t_StringSetPrx, False, 0), ())
    SessionControl._op_adapterIds = IcePy.Operation('adapterIds', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), ((), _M_Glacier2._t_StringSetPrx, False, 0), ())
    SessionControl._op_identities = IcePy.Operation('identities', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), ((), _M_Glacier2._t_IdentitySetPrx, False, 0), ())
    SessionControl._op_getSessionTimeout = IcePy.Operation('getSessionTimeout', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (), (), ((), IcePy._t_int, False, 0), ())
    SessionControl._op_destroy = IcePy.Operation('destroy', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), None, ())

    _M_Glacier2.SessionControl = SessionControl
    del SessionControl

    _M_Glacier2.SessionControlPrx = SessionControlPrx
    del SessionControlPrx

if 'SessionManager' not in _M_Glacier2.__dict__:
    _M_Glacier2.SessionManager = Ice.createTempClass()
    class SessionManager(Ice.Object):
        """
        The session manager for username/password authenticated users that
        is responsible for managing Session objects. New session objects
        are created by the Router object calling on an application-provided
        session manager. If no session manager is provided by the application,
        no client-visible sessions are passed to the client.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Glacier2.SessionManager:
                raise RuntimeError('Glacier2.SessionManager is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::SessionManager', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Glacier2::SessionManager'

        def ice_staticId():
            return '::Glacier2::SessionManager'
        ice_staticId = staticmethod(ice_staticId)

        def create(self, userId, control, current=None):
            """
            Create a new session.
            Arguments:
            userId -- The user id for the session.
            control -- A proxy to the session control object.
            current -- The Current object for the invocation.
            Returns: A proxy to the newly created session.
            Throws:
            CannotCreateSessionException -- Raised if the session cannot be created.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_SessionManager)

        __repr__ = __str__

    _M_Glacier2.SessionManagerPrx = Ice.createTempClass()
    class SessionManagerPrx(Ice.ObjectPrx):

        """
        Create a new session.
        Arguments:
        userId -- The user id for the session.
        control -- A proxy to the session control object.
        _ctx -- The request context for the invocation.
        Returns: A proxy to the newly created session.
        Throws:
        CannotCreateSessionException -- Raised if the session cannot be created.
        """
        def create(self, userId, control, _ctx=None):
            return _M_Glacier2.SessionManager._op_create.invoke(self, ((userId, control), _ctx))

        """
        Create a new session.
        Arguments:
        userId -- The user id for the session.
        control -- A proxy to the session control object.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_create(self, userId, control, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.SessionManager._op_create.begin(self, ((userId, control), _response, _ex, _sent, _ctx))

        """
        Create a new session.
        Arguments:
        userId -- The user id for the session.
        control -- A proxy to the session control object.
        Returns: A proxy to the newly created session.
        Throws:
        CannotCreateSessionException -- Raised if the session cannot be created.
        """
        def end_create(self, _r):
            return _M_Glacier2.SessionManager._op_create.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Glacier2.SessionManagerPrx.ice_checkedCast(proxy, '::Glacier2::SessionManager', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Glacier2.SessionManagerPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Glacier2::SessionManager'
        ice_staticId = staticmethod(ice_staticId)

    _M_Glacier2._t_SessionManagerPrx = IcePy.defineProxy('::Glacier2::SessionManager', SessionManagerPrx)

    _M_Glacier2._t_SessionManager = IcePy.defineClass('::Glacier2::SessionManager', SessionManager, -1, (), True, False, None, (), ())
    SessionManager._ice_type = _M_Glacier2._t_SessionManager

    SessionManager._op_create = IcePy.Operation('create', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, Ice.FormatType.SlicedFormat, (), (((), IcePy._t_string, False, 0), ((), _M_Glacier2._t_SessionControlPrx, False, 0)), (), ((), _M_Glacier2._t_SessionPrx, False, 0), (_M_Glacier2._t_CannotCreateSessionException,))

    _M_Glacier2.SessionManager = SessionManager
    del SessionManager

    _M_Glacier2.SessionManagerPrx = SessionManagerPrx
    del SessionManagerPrx

if 'SSLSessionManager' not in _M_Glacier2.__dict__:
    _M_Glacier2.SSLSessionManager = Ice.createTempClass()
    class SSLSessionManager(Ice.Object):
        """
        The session manager for SSL authenticated users that is
        responsible for managing Session objects. New session objects are
        created by the Router object calling on an application-provided
        session manager. If no session manager is provided by the
        application, no client-visible sessions are passed to the client.
        """
        def __init__(self):
            if Ice.getType(self) == _M_Glacier2.SSLSessionManager:
                raise RuntimeError('Glacier2.SSLSessionManager is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::SSLSessionManager', '::Ice::Object')

        def ice_id(self, current=None):
            return '::Glacier2::SSLSessionManager'

        def ice_staticId():
            return '::Glacier2::SSLSessionManager'
        ice_staticId = staticmethod(ice_staticId)

        def create(self, info, control, current=None):
            """
            Create a new session.
            Arguments:
            info -- The SSL info.
            control -- A proxy to the session control object.
            current -- The Current object for the invocation.
            Returns: A proxy to the newly created session.
            Throws:
            CannotCreateSessionException -- Raised if the session cannot be created.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Glacier2._t_SSLSessionManager)

        __repr__ = __str__

    _M_Glacier2.SSLSessionManagerPrx = Ice.createTempClass()
    class SSLSessionManagerPrx(Ice.ObjectPrx):

        """
        Create a new session.
        Arguments:
        info -- The SSL info.
        control -- A proxy to the session control object.
        _ctx -- The request context for the invocation.
        Returns: A proxy to the newly created session.
        Throws:
        CannotCreateSessionException -- Raised if the session cannot be created.
        """
        def create(self, info, control, _ctx=None):
            return _M_Glacier2.SSLSessionManager._op_create.invoke(self, ((info, control), _ctx))

        """
        Create a new session.
        Arguments:
        info -- The SSL info.
        control -- A proxy to the session control object.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_create(self, info, control, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_Glacier2.SSLSessionManager._op_create.begin(self, ((info, control), _response, _ex, _sent, _ctx))

        """
        Create a new session.
        Arguments:
        info -- The SSL info.
        control -- A proxy to the session control object.
        Returns: A proxy to the newly created session.
        Throws:
        CannotCreateSessionException -- Raised if the session cannot be created.
        """
        def end_create(self, _r):
            return _M_Glacier2.SSLSessionManager._op_create.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_Glacier2.SSLSessionManagerPrx.ice_checkedCast(proxy, '::Glacier2::SSLSessionManager', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_Glacier2.SSLSessionManagerPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::Glacier2::SSLSessionManager'
        ice_staticId = staticmethod(ice_staticId)

    _M_Glacier2._t_SSLSessionManagerPrx = IcePy.defineProxy('::Glacier2::SSLSessionManager', SSLSessionManagerPrx)

    _M_Glacier2._t_SSLSessionManager = IcePy.defineClass('::Glacier2::SSLSessionManager', SSLSessionManager, -1, (), True, False, None, (), ())
    SSLSessionManager._ice_type = _M_Glacier2._t_SSLSessionManager

    SSLSessionManager._op_create = IcePy.Operation('create', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, Ice.FormatType.SlicedFormat, (), (((), _M_Glacier2._t_SSLInfo, False, 0), ((), _M_Glacier2._t_SessionControlPrx, False, 0)), (), ((), _M_Glacier2._t_SessionPrx, False, 0), (_M_Glacier2._t_CannotCreateSessionException,))

    _M_Glacier2.SSLSessionManager = SSLSessionManager
    del SSLSessionManager

    _M_Glacier2.SSLSessionManagerPrx = SSLSessionManagerPrx
    del SSLSessionManagerPrx

# End of module Glacier2

Ice.sliceChecksums["::Glacier2::CannotCreateSessionException"] = "f3cf2057ea305ed04671164dfaeb6d95"
Ice.sliceChecksums["::Glacier2::IdentitySet"] = "622e43adfd1f535abaee1b089583847"
Ice.sliceChecksums["::Glacier2::SSLSessionManager"] = "4eb77cf437452f5296bf24dda4967d"
Ice.sliceChecksums["::Glacier2::Session"] = "8e47590dc18dd2a2e2e7749c941fc7"
Ice.sliceChecksums["::Glacier2::SessionControl"] = "83a11c547492ddc72db70659938222"
Ice.sliceChecksums["::Glacier2::SessionManager"] = "f3c67f2f29415754c0f1ccc1ab5558e"
Ice.sliceChecksums["::Glacier2::StringSet"] = "1b46953cdce5ef8b6fe92056adf3fda0"
