# -*- coding: utf-8 -*-
# **********************************************************************
#
# Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.5
#
# <auto-generated>
#
# Generated from file `IceStorm.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

from sys import version_info as _version_info_
import Ice, IcePy
import Ice_Identity_ice
import Ice_SliceChecksumDict_ice
import IceStorm_Metrics_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module IceMX
_M_IceMX = Ice.openModule('IceMX')

# Start of module IceStorm
_M_IceStorm = Ice.openModule('IceStorm')
__name__ = 'IceStorm'
_M_IceStorm.__doc__ = """
A messaging service with support for federation. In contrast to
most other messaging or event services, IceStorm supports typed
events, meaning that broadcasting a message over a federation is as
easy as invoking a method on an interface.
"""

if 'Topic' not in _M_IceStorm.__dict__:
    _M_IceStorm._t_Topic = IcePy.declareClass('::IceStorm::Topic')
    _M_IceStorm._t_TopicPrx = IcePy.declareProxy('::IceStorm::Topic')

if 'LinkInfo' not in _M_IceStorm.__dict__:
    _M_IceStorm.LinkInfo = Ice.createTempClass()
    class LinkInfo(object):
        """
        Information on the topic links.
        Members:
        theTopic -- The linked topic.
        name -- The name of the linked topic.
        cost -- The cost of traversing this link.
        """
        def __init__(self, theTopic=None, name='', cost=0):
            self.theTopic = theTopic
            self.name = name
            self.cost = cost

        def __eq__(self, other):
            if other is None:
                return False
            elif not isinstance(other, _M_IceStorm.LinkInfo):
                return NotImplemented
            else:
                if self.theTopic != other.theTopic:
                    return False
                if self.name != other.name:
                    return False
                if self.cost != other.cost:
                    return False
                return True

        def __ne__(self, other):
            return not self.__eq__(other)

        def __str__(self):
            return IcePy.stringify(self, _M_IceStorm._t_LinkInfo)

        __repr__ = __str__

    _M_IceStorm._t_LinkInfo = IcePy.defineStruct('::IceStorm::LinkInfo', LinkInfo, (), (
        ('theTopic', (), _M_IceStorm._t_TopicPrx),
        ('name', (), IcePy._t_string),
        ('cost', (), IcePy._t_int)
    ))

    _M_IceStorm.LinkInfo = LinkInfo
    del LinkInfo

if '_t_LinkInfoSeq' not in _M_IceStorm.__dict__:
    _M_IceStorm._t_LinkInfoSeq = IcePy.defineSequence('::IceStorm::LinkInfoSeq', (), _M_IceStorm._t_LinkInfo)

if '_t_QoS' not in _M_IceStorm.__dict__:
    _M_IceStorm._t_QoS = IcePy.defineDictionary('::IceStorm::QoS', (), IcePy._t_string, IcePy._t_string)

if 'LinkExists' not in _M_IceStorm.__dict__:
    _M_IceStorm.LinkExists = Ice.createTempClass()
    class LinkExists(Ice.UserException):
        """
        This exception indicates that an attempt was made to create a link
        that already exists.
        Members:
        name -- The name of the linked topic.
        """
        def __init__(self, name=''):
            self.name = name

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceStorm::LinkExists'

    _M_IceStorm._t_LinkExists = IcePy.defineException('::IceStorm::LinkExists', LinkExists, (), False, None, (('name', (), IcePy._t_string, False, 0),))
    LinkExists._ice_type = _M_IceStorm._t_LinkExists

    _M_IceStorm.LinkExists = LinkExists
    del LinkExists

if 'NoSuchLink' not in _M_IceStorm.__dict__:
    _M_IceStorm.NoSuchLink = Ice.createTempClass()
    class NoSuchLink(Ice.UserException):
        """
        This exception indicates that an attempt was made to remove a
        link that does not exist.
        Members:
        name -- The name of the link that does not exist.
        """
        def __init__(self, name=''):
            self.name = name

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceStorm::NoSuchLink'

    _M_IceStorm._t_NoSuchLink = IcePy.defineException('::IceStorm::NoSuchLink', NoSuchLink, (), False, None, (('name', (), IcePy._t_string, False, 0),))
    NoSuchLink._ice_type = _M_IceStorm._t_NoSuchLink

    _M_IceStorm.NoSuchLink = NoSuchLink
    del NoSuchLink

if 'AlreadySubscribed' not in _M_IceStorm.__dict__:
    _M_IceStorm.AlreadySubscribed = Ice.createTempClass()
    class AlreadySubscribed(Ice.UserException):
        """
        This exception indicates that an attempt was made to subscribe
        a proxy for which a subscription already exists.
        """
        def __init__(self):
            pass

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceStorm::AlreadySubscribed'

    _M_IceStorm._t_AlreadySubscribed = IcePy.defineException('::IceStorm::AlreadySubscribed', AlreadySubscribed, (), False, None, ())
    AlreadySubscribed._ice_type = _M_IceStorm._t_AlreadySubscribed

    _M_IceStorm.AlreadySubscribed = AlreadySubscribed
    del AlreadySubscribed

if 'InvalidSubscriber' not in _M_IceStorm.__dict__:
    _M_IceStorm.InvalidSubscriber = Ice.createTempClass()
    class InvalidSubscriber(Ice.UserException):
        """
        This exception indicates that an attempt was made to subscribe
        a proxy that is null.
        Members:
        reason -- The reason for the failure.
        """
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceStorm::InvalidSubscriber'

    _M_IceStorm._t_InvalidSubscriber = IcePy.defineException('::IceStorm::InvalidSubscriber', InvalidSubscriber, (), False, None, (('reason', (), IcePy._t_string, False, 0),))
    InvalidSubscriber._ice_type = _M_IceStorm._t_InvalidSubscriber

    _M_IceStorm.InvalidSubscriber = InvalidSubscriber
    del InvalidSubscriber

if 'BadQoS' not in _M_IceStorm.__dict__:
    _M_IceStorm.BadQoS = Ice.createTempClass()
    class BadQoS(Ice.UserException):
        """
        This exception indicates that a subscription failed due to an
        invalid QoS.
        Members:
        reason -- The reason for the failure.
        """
        def __init__(self, reason=''):
            self.reason = reason

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceStorm::BadQoS'

    _M_IceStorm._t_BadQoS = IcePy.defineException('::IceStorm::BadQoS', BadQoS, (), False, None, (('reason', (), IcePy._t_string, False, 0),))
    BadQoS._ice_type = _M_IceStorm._t_BadQoS

    _M_IceStorm.BadQoS = BadQoS
    del BadQoS

if 'Topic' not in _M_IceStorm.__dict__:
    _M_IceStorm.Topic = Ice.createTempClass()
    class Topic(Ice.Object):
        """
        Publishers publish information on a particular topic. A topic
        logically represents a type.
        """
        def __init__(self):
            if Ice.getType(self) == _M_IceStorm.Topic:
                raise RuntimeError('IceStorm.Topic is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceStorm::Topic')

        def ice_id(self, current=None):
            return '::IceStorm::Topic'

        def ice_staticId():
            return '::IceStorm::Topic'
        ice_staticId = staticmethod(ice_staticId)

        def getName(self, current=None):
            """
            Get the name of this topic.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The name of the topic.
            """
            pass

        def getPublisher(self, current=None):
            """
            Get a proxy to a publisher object for this topic. To publish
            data to a topic, the publisher calls getPublisher and then
            casts to the topic type. An unchecked cast must be used on this
            proxy. If a replicated IceStorm deployment is used this call
            may return a replicated proxy.
            Arguments:
            current -- The Current object for the invocation.
            Returns: A proxy to publish data on this topic.
            """
            pass

        def getNonReplicatedPublisher(self, current=None):
            """
            Get a non-replicated proxy to a publisher object for this
            topic. To publish data to a topic, the publisher calls
            getPublisher and then casts to the topic type. An unchecked
            cast must be used on this proxy.
            Arguments:
            current -- The Current object for the invocation.
            Returns: A proxy to publish data on this topic.
            """
            pass

        def subscribeAndGetPublisher(self, theQoS, subscriber, current=None):
            """
            Subscribe with the given qos to this topic.  A
            per-subscriber publisher object is returned.
            Arguments:
            theQoS -- The quality of service parameters for this subscription.
            subscriber -- The subscriber's proxy.
            current -- The Current object for the invocation.
            Returns: The per-subscriber publisher object.
            Throws:
            AlreadySubscribed -- Raised if the subscriber object is already subscribed.
            BadQoS -- Raised if the requested quality of service is unavailable or invalid.
            InvalidSubscriber -- Raised if the subscriber object is null.
            """
            pass

        def unsubscribe(self, subscriber, current=None):
            """
            Unsubscribe the given subscriber.
            Arguments:
            subscriber -- The proxy of an existing subscriber.
            current -- The Current object for the invocation.
            """
            pass

        def link(self, linkTo, cost, current=None):
            """
            Create a link to the given topic. All events originating
            on this topic will also be sent to linkTo.
            Arguments:
            linkTo -- The topic to link to.
            cost -- The cost to the linked topic.
            current -- The Current object for the invocation.
            Throws:
            LinkExists -- Raised if a link to the same topic already exists.
            """
            pass

        def unlink(self, linkTo, current=None):
            """
            Destroy the link from this topic to the given topic linkTo.
            Arguments:
            linkTo -- The topic to destroy the link to.
            current -- The Current object for the invocation.
            Throws:
            NoSuchLink -- Raised if a link to the topic does not exist.
            """
            pass

        def getLinkInfoSeq(self, current=None):
            """
            Retrieve information on the current links.
            Arguments:
            current -- The Current object for the invocation.
            Returns: A sequence of LinkInfo objects.
            """
            pass

        def getSubscribers(self, current=None):
            """
            Retrieve the list of subscribers for this topic.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The sequence of Ice identities for the subscriber objects.
            """
            pass

        def destroy(self, current=None):
            """
            Destroy the topic.
            Arguments:
            current -- The Current object for the invocation.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceStorm._t_Topic)

        __repr__ = __str__

    _M_IceStorm.TopicPrx = Ice.createTempClass()
    class TopicPrx(Ice.ObjectPrx):

        """
        Get the name of this topic.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The name of the topic.
        """
        def getName(self, _ctx=None):
            return _M_IceStorm.Topic._op_getName.invoke(self, ((), _ctx))

        """
        Get the name of this topic.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getName(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_getName.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Get the name of this topic.
        Arguments:
        Returns: The name of the topic.
        """
        def end_getName(self, _r):
            return _M_IceStorm.Topic._op_getName.end(self, _r)

        """
        Get a proxy to a publisher object for this topic. To publish
        data to a topic, the publisher calls getPublisher and then
        casts to the topic type. An unchecked cast must be used on this
        proxy. If a replicated IceStorm deployment is used this call
        may return a replicated proxy.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: A proxy to publish data on this topic.
        """
        def getPublisher(self, _ctx=None):
            return _M_IceStorm.Topic._op_getPublisher.invoke(self, ((), _ctx))

        """
        Get a proxy to a publisher object for this topic. To publish
        data to a topic, the publisher calls getPublisher and then
        casts to the topic type. An unchecked cast must be used on this
        proxy. If a replicated IceStorm deployment is used this call
        may return a replicated proxy.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getPublisher(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_getPublisher.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Get a proxy to a publisher object for this topic. To publish
        data to a topic, the publisher calls getPublisher and then
        casts to the topic type. An unchecked cast must be used on this
        proxy. If a replicated IceStorm deployment is used this call
        may return a replicated proxy.
        Arguments:
        Returns: A proxy to publish data on this topic.
        """
        def end_getPublisher(self, _r):
            return _M_IceStorm.Topic._op_getPublisher.end(self, _r)

        """
        Get a non-replicated proxy to a publisher object for this
        topic. To publish data to a topic, the publisher calls
        getPublisher and then casts to the topic type. An unchecked
        cast must be used on this proxy.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: A proxy to publish data on this topic.
        """
        def getNonReplicatedPublisher(self, _ctx=None):
            return _M_IceStorm.Topic._op_getNonReplicatedPublisher.invoke(self, ((), _ctx))

        """
        Get a non-replicated proxy to a publisher object for this
        topic. To publish data to a topic, the publisher calls
        getPublisher and then casts to the topic type. An unchecked
        cast must be used on this proxy.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getNonReplicatedPublisher(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_getNonReplicatedPublisher.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Get a non-replicated proxy to a publisher object for this
        topic. To publish data to a topic, the publisher calls
        getPublisher and then casts to the topic type. An unchecked
        cast must be used on this proxy.
        Arguments:
        Returns: A proxy to publish data on this topic.
        """
        def end_getNonReplicatedPublisher(self, _r):
            return _M_IceStorm.Topic._op_getNonReplicatedPublisher.end(self, _r)

        """
        Subscribe with the given qos to this topic.  A
        per-subscriber publisher object is returned.
        Arguments:
        theQoS -- The quality of service parameters for this subscription.
        subscriber -- The subscriber's proxy.
        _ctx -- The request context for the invocation.
        Returns: The per-subscriber publisher object.
        Throws:
        AlreadySubscribed -- Raised if the subscriber object is already subscribed.
        BadQoS -- Raised if the requested quality of service is unavailable or invalid.
        InvalidSubscriber -- Raised if the subscriber object is null.
        """
        def subscribeAndGetPublisher(self, theQoS, subscriber, _ctx=None):
            return _M_IceStorm.Topic._op_subscribeAndGetPublisher.invoke(self, ((theQoS, subscriber), _ctx))

        """
        Subscribe with the given qos to this topic.  A
        per-subscriber publisher object is returned.
        Arguments:
        theQoS -- The quality of service parameters for this subscription.
        subscriber -- The subscriber's proxy.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_subscribeAndGetPublisher(self, theQoS, subscriber, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_subscribeAndGetPublisher.begin(self, ((theQoS, subscriber), _response, _ex, _sent, _ctx))

        """
        Subscribe with the given qos to this topic.  A
        per-subscriber publisher object is returned.
        Arguments:
        theQoS -- The quality of service parameters for this subscription.
        subscriber -- The subscriber's proxy.
        Returns: The per-subscriber publisher object.
        Throws:
        AlreadySubscribed -- Raised if the subscriber object is already subscribed.
        BadQoS -- Raised if the requested quality of service is unavailable or invalid.
        InvalidSubscriber -- Raised if the subscriber object is null.
        """
        def end_subscribeAndGetPublisher(self, _r):
            return _M_IceStorm.Topic._op_subscribeAndGetPublisher.end(self, _r)

        """
        Unsubscribe the given subscriber.
        Arguments:
        subscriber -- The proxy of an existing subscriber.
        _ctx -- The request context for the invocation.
        """
        def unsubscribe(self, subscriber, _ctx=None):
            return _M_IceStorm.Topic._op_unsubscribe.invoke(self, ((subscriber, ), _ctx))

        """
        Unsubscribe the given subscriber.
        Arguments:
        subscriber -- The proxy of an existing subscriber.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_unsubscribe(self, subscriber, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_unsubscribe.begin(self, ((subscriber, ), _response, _ex, _sent, _ctx))

        """
        Unsubscribe the given subscriber.
        Arguments:
        subscriber -- The proxy of an existing subscriber.
        """
        def end_unsubscribe(self, _r):
            return _M_IceStorm.Topic._op_unsubscribe.end(self, _r)

        """
        Create a link to the given topic. All events originating
        on this topic will also be sent to linkTo.
        Arguments:
        linkTo -- The topic to link to.
        cost -- The cost to the linked topic.
        _ctx -- The request context for the invocation.
        Throws:
        LinkExists -- Raised if a link to the same topic already exists.
        """
        def link(self, linkTo, cost, _ctx=None):
            return _M_IceStorm.Topic._op_link.invoke(self, ((linkTo, cost), _ctx))

        """
        Create a link to the given topic. All events originating
        on this topic will also be sent to linkTo.
        Arguments:
        linkTo -- The topic to link to.
        cost -- The cost to the linked topic.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_link(self, linkTo, cost, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_link.begin(self, ((linkTo, cost), _response, _ex, _sent, _ctx))

        """
        Create a link to the given topic. All events originating
        on this topic will also be sent to linkTo.
        Arguments:
        linkTo -- The topic to link to.
        cost -- The cost to the linked topic.
        Throws:
        LinkExists -- Raised if a link to the same topic already exists.
        """
        def end_link(self, _r):
            return _M_IceStorm.Topic._op_link.end(self, _r)

        """
        Destroy the link from this topic to the given topic linkTo.
        Arguments:
        linkTo -- The topic to destroy the link to.
        _ctx -- The request context for the invocation.
        Throws:
        NoSuchLink -- Raised if a link to the topic does not exist.
        """
        def unlink(self, linkTo, _ctx=None):
            return _M_IceStorm.Topic._op_unlink.invoke(self, ((linkTo, ), _ctx))

        """
        Destroy the link from this topic to the given topic linkTo.
        Arguments:
        linkTo -- The topic to destroy the link to.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_unlink(self, linkTo, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_unlink.begin(self, ((linkTo, ), _response, _ex, _sent, _ctx))

        """
        Destroy the link from this topic to the given topic linkTo.
        Arguments:
        linkTo -- The topic to destroy the link to.
        Throws:
        NoSuchLink -- Raised if a link to the topic does not exist.
        """
        def end_unlink(self, _r):
            return _M_IceStorm.Topic._op_unlink.end(self, _r)

        """
        Retrieve information on the current links.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: A sequence of LinkInfo objects.
        """
        def getLinkInfoSeq(self, _ctx=None):
            return _M_IceStorm.Topic._op_getLinkInfoSeq.invoke(self, ((), _ctx))

        """
        Retrieve information on the current links.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getLinkInfoSeq(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_getLinkInfoSeq.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Retrieve information on the current links.
        Arguments:
        Returns: A sequence of LinkInfo objects.
        """
        def end_getLinkInfoSeq(self, _r):
            return _M_IceStorm.Topic._op_getLinkInfoSeq.end(self, _r)

        """
        Retrieve the list of subscribers for this topic.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The sequence of Ice identities for the subscriber objects.
        """
        def getSubscribers(self, _ctx=None):
            return _M_IceStorm.Topic._op_getSubscribers.invoke(self, ((), _ctx))

        """
        Retrieve the list of subscribers for this topic.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getSubscribers(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_getSubscribers.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Retrieve the list of subscribers for this topic.
        Arguments:
        Returns: The sequence of Ice identities for the subscriber objects.
        """
        def end_getSubscribers(self, _r):
            return _M_IceStorm.Topic._op_getSubscribers.end(self, _r)

        """
        Destroy the topic.
        Arguments:
        _ctx -- The request context for the invocation.
        """
        def destroy(self, _ctx=None):
            return _M_IceStorm.Topic._op_destroy.invoke(self, ((), _ctx))

        """
        Destroy the topic.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_destroy(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Topic._op_destroy.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Destroy the topic.
        Arguments:
        """
        def end_destroy(self, _r):
            return _M_IceStorm.Topic._op_destroy.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceStorm.TopicPrx.ice_checkedCast(proxy, '::IceStorm::Topic', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceStorm.TopicPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceStorm::Topic'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceStorm._t_TopicPrx = IcePy.defineProxy('::IceStorm::Topic', TopicPrx)

    _M_IceStorm._t_Topic = IcePy.defineClass('::IceStorm::Topic', Topic, -1, (), True, False, None, (), ())
    Topic._ice_type = _M_IceStorm._t_Topic

    Topic._op_getName = IcePy.Operation('getName', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), IcePy._t_string, False, 0), ())
    Topic._op_getPublisher = IcePy.Operation('getPublisher', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), IcePy._t_ObjectPrx, False, 0), ())
    Topic._op_getNonReplicatedPublisher = IcePy.Operation('getNonReplicatedPublisher', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), IcePy._t_ObjectPrx, False, 0), ())
    Topic._op_subscribeAndGetPublisher = IcePy.Operation('subscribeAndGetPublisher', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceStorm._t_QoS, False, 0), ((), IcePy._t_ObjectPrx, False, 0)), (), ((), IcePy._t_ObjectPrx, False, 0), (_M_IceStorm._t_AlreadySubscribed, _M_IceStorm._t_InvalidSubscriber, _M_IceStorm._t_BadQoS))
    Topic._op_unsubscribe = IcePy.Operation('unsubscribe', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_ObjectPrx, False, 0),), (), None, ())
    Topic._op_link = IcePy.Operation('link', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceStorm._t_TopicPrx, False, 0), ((), IcePy._t_int, False, 0)), (), None, (_M_IceStorm._t_LinkExists,))
    Topic._op_unlink = IcePy.Operation('unlink', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), _M_IceStorm._t_TopicPrx, False, 0),), (), None, (_M_IceStorm._t_NoSuchLink,))
    Topic._op_getLinkInfoSeq = IcePy.Operation('getLinkInfoSeq', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_IceStorm._t_LinkInfoSeq, False, 0), ())
    Topic._op_getSubscribers = IcePy.Operation('getSubscribers', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), ((), _M_Ice._t_IdentitySeq, False, 0), ())
    Topic._op_destroy = IcePy.Operation('destroy', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), None, ())

    _M_IceStorm.Topic = Topic
    del Topic

    _M_IceStorm.TopicPrx = TopicPrx
    del TopicPrx

if '_t_TopicDict' not in _M_IceStorm.__dict__:
    _M_IceStorm._t_TopicDict = IcePy.defineDictionary('::IceStorm::TopicDict', (), IcePy._t_string, _M_IceStorm._t_TopicPrx)

if 'TopicExists' not in _M_IceStorm.__dict__:
    _M_IceStorm.TopicExists = Ice.createTempClass()
    class TopicExists(Ice.UserException):
        """
        This exception indicates that an attempt was made to create a topic
        that already exists.
        Members:
        name -- The name of the topic that already exists.
        """
        def __init__(self, name=''):
            self.name = name

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceStorm::TopicExists'

    _M_IceStorm._t_TopicExists = IcePy.defineException('::IceStorm::TopicExists', TopicExists, (), False, None, (('name', (), IcePy._t_string, False, 0),))
    TopicExists._ice_type = _M_IceStorm._t_TopicExists

    _M_IceStorm.TopicExists = TopicExists
    del TopicExists

if 'NoSuchTopic' not in _M_IceStorm.__dict__:
    _M_IceStorm.NoSuchTopic = Ice.createTempClass()
    class NoSuchTopic(Ice.UserException):
        """
        This exception indicates that an attempt was made to retrieve a
        topic that does not exist.
        Members:
        name -- The name of the topic that does not exist.
        """
        def __init__(self, name=''):
            self.name = name

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

        _ice_name = 'IceStorm::NoSuchTopic'

    _M_IceStorm._t_NoSuchTopic = IcePy.defineException('::IceStorm::NoSuchTopic', NoSuchTopic, (), False, None, (('name', (), IcePy._t_string, False, 0),))
    NoSuchTopic._ice_type = _M_IceStorm._t_NoSuchTopic

    _M_IceStorm.NoSuchTopic = NoSuchTopic
    del NoSuchTopic

if 'TopicManager' not in _M_IceStorm.__dict__:
    _M_IceStorm.TopicManager = Ice.createTempClass()
    class TopicManager(Ice.Object):
        """
        A topic manager manages topics, and subscribers to topics.
        """
        def __init__(self):
            if Ice.getType(self) == _M_IceStorm.TopicManager:
                raise RuntimeError('IceStorm.TopicManager is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceStorm::TopicManager')

        def ice_id(self, current=None):
            return '::IceStorm::TopicManager'

        def ice_staticId():
            return '::IceStorm::TopicManager'
        ice_staticId = staticmethod(ice_staticId)

        def create(self, name, current=None):
            """
            Create a new topic. The topic name must be unique.
            Arguments:
            name -- The name of the topic.
            current -- The Current object for the invocation.
            Returns: A proxy to the topic instance.
            Throws:
            TopicExists -- Raised if a topic with the same name already exists.
            """
            pass

        def retrieve(self, name, current=None):
            """
            Retrieve a topic by name.
            Arguments:
            name -- The name of the topic.
            current -- The Current object for the invocation.
            Returns: A proxy to the topic instance.
            Throws:
            NoSuchTopic -- Raised if the topic does not exist.
            """
            pass

        def retrieveAll(self, current=None):
            """
            Retrieve all topics managed by this topic manager.
            Arguments:
            current -- The Current object for the invocation.
            Returns: A dictionary of string, topic proxy pairs.
            """
            pass

        def getSliceChecksums(self, current=None):
            """
            Returns the checksums for the IceStorm Slice definitions.
            Arguments:
            current -- The Current object for the invocation.
            Returns: A dictionary mapping Slice type ids to their checksums.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceStorm._t_TopicManager)

        __repr__ = __str__

    _M_IceStorm.TopicManagerPrx = Ice.createTempClass()
    class TopicManagerPrx(Ice.ObjectPrx):

        """
        Create a new topic. The topic name must be unique.
        Arguments:
        name -- The name of the topic.
        _ctx -- The request context for the invocation.
        Returns: A proxy to the topic instance.
        Throws:
        TopicExists -- Raised if a topic with the same name already exists.
        """
        def create(self, name, _ctx=None):
            return _M_IceStorm.TopicManager._op_create.invoke(self, ((name, ), _ctx))

        """
        Create a new topic. The topic name must be unique.
        Arguments:
        name -- The name of the topic.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_create(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.TopicManager._op_create.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        """
        Create a new topic. The topic name must be unique.
        Arguments:
        name -- The name of the topic.
        Returns: A proxy to the topic instance.
        Throws:
        TopicExists -- Raised if a topic with the same name already exists.
        """
        def end_create(self, _r):
            return _M_IceStorm.TopicManager._op_create.end(self, _r)

        """
        Retrieve a topic by name.
        Arguments:
        name -- The name of the topic.
        _ctx -- The request context for the invocation.
        Returns: A proxy to the topic instance.
        Throws:
        NoSuchTopic -- Raised if the topic does not exist.
        """
        def retrieve(self, name, _ctx=None):
            return _M_IceStorm.TopicManager._op_retrieve.invoke(self, ((name, ), _ctx))

        """
        Retrieve a topic by name.
        Arguments:
        name -- The name of the topic.
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_retrieve(self, name, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.TopicManager._op_retrieve.begin(self, ((name, ), _response, _ex, _sent, _ctx))

        """
        Retrieve a topic by name.
        Arguments:
        name -- The name of the topic.
        Returns: A proxy to the topic instance.
        Throws:
        NoSuchTopic -- Raised if the topic does not exist.
        """
        def end_retrieve(self, _r):
            return _M_IceStorm.TopicManager._op_retrieve.end(self, _r)

        """
        Retrieve all topics managed by this topic manager.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: A dictionary of string, topic proxy pairs.
        """
        def retrieveAll(self, _ctx=None):
            return _M_IceStorm.TopicManager._op_retrieveAll.invoke(self, ((), _ctx))

        """
        Retrieve all topics managed by this topic manager.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_retrieveAll(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.TopicManager._op_retrieveAll.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Retrieve all topics managed by this topic manager.
        Arguments:
        Returns: A dictionary of string, topic proxy pairs.
        """
        def end_retrieveAll(self, _r):
            return _M_IceStorm.TopicManager._op_retrieveAll.end(self, _r)

        """
        Returns the checksums for the IceStorm Slice definitions.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: A dictionary mapping Slice type ids to their checksums.
        """
        def getSliceChecksums(self, _ctx=None):
            return _M_IceStorm.TopicManager._op_getSliceChecksums.invoke(self, ((), _ctx))

        """
        Returns the checksums for the IceStorm Slice definitions.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getSliceChecksums(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.TopicManager._op_getSliceChecksums.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Returns the checksums for the IceStorm Slice definitions.
        Arguments:
        Returns: A dictionary mapping Slice type ids to their checksums.
        """
        def end_getSliceChecksums(self, _r):
            return _M_IceStorm.TopicManager._op_getSliceChecksums.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceStorm.TopicManagerPrx.ice_checkedCast(proxy, '::IceStorm::TopicManager', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceStorm.TopicManagerPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceStorm::TopicManager'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceStorm._t_TopicManagerPrx = IcePy.defineProxy('::IceStorm::TopicManager', TopicManagerPrx)

    _M_IceStorm._t_TopicManager = IcePy.defineClass('::IceStorm::TopicManager', TopicManager, -1, (), True, False, None, (), ())
    TopicManager._ice_type = _M_IceStorm._t_TopicManager

    TopicManager._op_create = IcePy.Operation('create', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceStorm._t_TopicPrx, False, 0), (_M_IceStorm._t_TopicExists,))
    TopicManager._op_retrieve = IcePy.Operation('retrieve', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_IceStorm._t_TopicPrx, False, 0), (_M_IceStorm._t_NoSuchTopic,))
    TopicManager._op_retrieveAll = IcePy.Operation('retrieveAll', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_IceStorm._t_TopicDict, False, 0), ())
    TopicManager._op_getSliceChecksums = IcePy.Operation('getSliceChecksums', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (), (), ((), _M_Ice._t_SliceChecksumDict, False, 0), ())

    _M_IceStorm.TopicManager = TopicManager
    del TopicManager

    _M_IceStorm.TopicManagerPrx = TopicManagerPrx
    del TopicManagerPrx

if 'Finder' not in _M_IceStorm.__dict__:
    _M_IceStorm.Finder = Ice.createTempClass()
    class Finder(Ice.Object):
        """
        This inferface is advertised by the IceStorm service through the
        Ice object with the identity `IceStorm/Finder'. This allows clients
        to retrieve the topic manager with just the endpoint information of
        the IceStorm service.
        """
        def __init__(self):
            if Ice.getType(self) == _M_IceStorm.Finder:
                raise RuntimeError('IceStorm.Finder is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceStorm::Finder')

        def ice_id(self, current=None):
            return '::IceStorm::Finder'

        def ice_staticId():
            return '::IceStorm::Finder'
        ice_staticId = staticmethod(ice_staticId)

        def getTopicManager(self, current=None):
            """
            Get the topic manager proxy. The proxy might point to several
            replicas.
            Arguments:
            current -- The Current object for the invocation.
            Returns: The topic manager proxy.
            """
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceStorm._t_Finder)

        __repr__ = __str__

    _M_IceStorm.FinderPrx = Ice.createTempClass()
    class FinderPrx(Ice.ObjectPrx):

        """
        Get the topic manager proxy. The proxy might point to several
        replicas.
        Arguments:
        _ctx -- The request context for the invocation.
        Returns: The topic manager proxy.
        """
        def getTopicManager(self, _ctx=None):
            return _M_IceStorm.Finder._op_getTopicManager.invoke(self, ((), _ctx))

        """
        Get the topic manager proxy. The proxy might point to several
        replicas.
        Arguments:
        _response -- The asynchronous response callback.
        _ex -- The asynchronous exception callback.
        _sent -- The asynchronous sent callback.
        _ctx -- The request context for the invocation.
        Returns: An asynchronous result object for the invocation.
        """
        def begin_getTopicManager(self, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceStorm.Finder._op_getTopicManager.begin(self, ((), _response, _ex, _sent, _ctx))

        """
        Get the topic manager proxy. The proxy might point to several
        replicas.
        Arguments:
        Returns: The topic manager proxy.
        """
        def end_getTopicManager(self, _r):
            return _M_IceStorm.Finder._op_getTopicManager.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceStorm.FinderPrx.ice_checkedCast(proxy, '::IceStorm::Finder', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceStorm.FinderPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceStorm::Finder'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceStorm._t_FinderPrx = IcePy.defineProxy('::IceStorm::Finder', FinderPrx)

    _M_IceStorm._t_Finder = IcePy.defineClass('::IceStorm::Finder', Finder, -1, (), True, False, None, (), ())
    Finder._ice_type = _M_IceStorm._t_Finder

    Finder._op_getTopicManager = IcePy.Operation('getTopicManager', Ice.OperationMode.Normal, Ice.OperationMode.Normal, False, None, (), (), (), ((), _M_IceStorm._t_TopicManagerPrx, False, 0), ())

    _M_IceStorm.Finder = Finder
    del Finder

    _M_IceStorm.FinderPrx = FinderPrx
    del FinderPrx

# End of module IceStorm

Ice.sliceChecksums["::IceStorm::AlreadySubscribed"] = "5a82e77b38f02f3118c536f9446a889e"
Ice.sliceChecksums["::IceStorm::BadQoS"] = "44f2de592dd62e3f7f4ffdf043692d"
Ice.sliceChecksums["::IceStorm::Finder"] = "74a058c59ac11fe9a98347ab96533e0"
Ice.sliceChecksums["::IceStorm::InvalidSubscriber"] = "79b17123acba6189e77285da82a862d3"
Ice.sliceChecksums["::IceStorm::LinkExists"] = "e11768febd56a8813729ce69be6c4c2"
Ice.sliceChecksums["::IceStorm::LinkInfo"] = "d0e073e5e0925ec95656f71d572e2e13"
Ice.sliceChecksums["::IceStorm::LinkInfoSeq"] = "a8921e43838692bbe6ca63f3dcf9b6"
Ice.sliceChecksums["::IceStorm::NoSuchLink"] = "fd8f652776796bffca2df1a3baf455a3"
Ice.sliceChecksums["::IceStorm::NoSuchTopic"] = "7a9479a5c39cdd32335d722bbc971176"
Ice.sliceChecksums["::IceStorm::QoS"] = "3e27cb32bc95cca7b013efbf5c254b35"
Ice.sliceChecksums["::IceStorm::Topic"] = "7058388fe7d6c582c2506237904eb7c9"
Ice.sliceChecksums["::IceStorm::TopicDict"] = "fff078a98be068c52d9e1d7d8f6df2a"
Ice.sliceChecksums["::IceStorm::TopicExists"] = "38e6913833539b8d616d114d4e7b28d"
Ice.sliceChecksums["::IceStorm::TopicManager"] = "ffc1baf19222891f8b432be6551fed5"
