from ctypes import c_void_p, c_int, c_int64, c_uint8, CFUNCTYPE
from ctypes import cdll
import ctypes.util
from typing import Any
import platform
import sys


def _load_library() -> Any:
    os_system = platform.system().lower()

    ext = ""
    if os_system == "linux":
        ext = ".so"
    if os_system == "darwin":
        ext = ".dylib"

    lib_name = "zaber-motion-lib" + ext
    # On windows, since Python 3.8 you need an extra call to find_library
    # https://github.com/beetbox/pyacoustid/issues/54
    if sys.platform == 'win32':
        lib_name = ctypes.util.find_library(lib_name)
    return cdll.LoadLibrary(lib_name)


lib = _load_library()

CALLBACK = CFUNCTYPE(None, c_void_p, c_int64)

c_call = lib.call
c_call.argtypes = [c_void_p, c_int64, CALLBACK, c_uint8]
c_call.restype = c_int

c_set_event_handler = lib.setEventHandler
c_set_event_handler.argtypes = [c_int64, CALLBACK]
c_set_event_handler.restype = None
