# z5 cmake module
# This module sets the following variables in your project:
#
#   z5_FOUND - true if z5 found on the system
#   z5_INCLUDE_DIRS - the directory containing z5 headers
#   z5_LIBRARY - empty


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was z5-config.cmake                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
find_dependency(nlohmann_json)

if(NOT TARGET z5)
    include("${CMAKE_CURRENT_LIST_DIR}/z5-targets.cmake")
    get_target_property(z5_INCLUDE_DIRS z5 INTERFACE_INCLUDE_DIRECTORIES)
endif()

# TODO check if we can use this for compression libraries
# if(Z5_USE_ZLIB)
#     find_dependency(zlib)
# endif()
