############################################################################
# Copyright (c) 2017, Sylvain Corlay, Johan Mabille and Loic Gouarin       #
#                                                                          #
# Distributed under the terms of the BSD 3-Clause License.                 #
#                                                                          #
# The full license is in the file LICENSE, distributed with this software. #
############################################################################

# xwidgets cmake module
# This module sets the following variables in your project::
#
#   xwidgets_FOUND - true if xwidgets found on the system
#   xwidgets_INCLUDE_DIRS - the directory containing xwidgets headers
#   xwidgets_LIBRARY - the library for dynamic linking


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was xwidgetsConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
if(NOT TARGET xwidgets AND NOT TARGET xwidgets-static)
  include("${CMAKE_CURRENT_LIST_DIR}/xwidgetsTargets.cmake")

  if (TARGET xwidgets AND TARGET xwidgets-static)
    get_target_property(xwidgets_INCLUDE_DIR xwidgets INTERFACE_INCLUDE_DIRECTORIES)
    get_target_property(xwidgets_LIBRARY xwidgets LOCATION)
    get_target_property(xwidgets_STATIC_LIBRARY xwidgets-static LOCATION)  
  elseif (TARGET xwidgets)
    get_target_property(xwidgets_INCLUDE_DIR xwidgets INTERFACE_INCLUDE_DIRECTORIES)
    get_target_property(xwidgets_LIBRARY xwidgets LOCATION)
  elseif (TARGET xwidgets-static)
    get_target_property(xwidgets_INCLUDE_DIR xwidgets-static INTERFACE_INCLUDE_DIRECTORIES)
    get_target_property(xwidgets_STATIC_LIBRARY xwidgets-static LOCATION)  
  endif()
endif()
