/***************************************************************************
* Copyright (c) 2016, Sylvain Corlay and Johan Mabille                     *
*                                                                          *
* Distributed under the terms of the BSD 3-Clause License.                 *
*                                                                          *
* The full license is in the file LICENSE, distributed with this software. *
****************************************************************************/

#ifndef XTL_XVARIANT_HPP
#define XTL_XVARIANT_HPP

#ifndef __cpp_exceptions
    #define __cpp_exceptions
    #include "xvariant_impl.hpp"
    #undef __cpp_exceptions
#else
    #include "xvariant_impl.hpp"
#endif

#include "xclosure.hpp"

namespace xtl
{
    using mpark::variant;
    using mpark::monostate;
    using mpark::bad_variant_access;
    using mpark::variant_size;
#ifdef MPARK_VARIABLE_TEMPLATES
    using mpark::variant_size_v;
#endif
    using mpark::variant_alternative;
    using mpark::variant_alternative_t;
    using mpark::variant_npos;

    using mpark::visit;
    using mpark::holds_alternative;
    using mpark::get;
    using mpark::get_if;

    namespace detail
    {
        template <class T>
        struct xgetter
        {
            template <class... Ts>
            static inline constexpr T& get(xtl::variant<Ts...>& v)
            {
                return xtl::get<T>(v);
            }

            template <class... Ts>
            static inline constexpr T&& get(xtl::variant<Ts...>&& v)
            {
                return xtl::get<T>(std::move(v));
            }

            template <class... Ts>
            static inline constexpr const T& get(const xtl::variant<Ts...>& v)
            {
                return xtl::get<T>(v);
            }

            template <class... Ts>
            static inline constexpr const T&& get(const xtl::variant<Ts...>&& v)
            {
                return xtl::get<T>(std::move(v));
            }
        };

        template <class T>
        struct xgetter<T&>
        {
            template <class... Ts>
            static inline constexpr T& get(xtl::variant<Ts...>& v)
            {
                return xtl::get<xtl::xclosure_wrapper<T&>>(v).get();
            }

            template <class... Ts>
            static inline constexpr T&& get(xtl::variant<Ts...>&& v)
            {
                return xtl::get<xtl::xclosure_wrapper<T&>>(std::move(v)).get();
            }

            template <class... Ts>
            static inline constexpr const T& get(const xtl::variant<Ts...>& v)
            {
                return xtl::get<xtl::xclosure_wrapper<T&>>(v).get();
            }

            template <class... Ts>
            static inline constexpr const T&& get(const xtl::variant<Ts...>&& v)
            {
                return xtl::get<xtl::xclosure_wrapper<T&>>(std::move(v)).get();
            }
        };
    }

    template <class T, class... Ts>
    inline constexpr decltype(auto) xget(xtl::variant<Ts...>& v)
    {
        return detail::xgetter<T>::get(v);
    }

    template <class T, class... Ts>
    inline constexpr decltype(auto) xget(xtl::variant<Ts...>&& v)
    {
        return detail::xgetter<T>::get(std::move(v));
    }

    template <class T, class... Ts>
    inline constexpr decltype(auto) xget(const xtl::variant<Ts...>& v)
    {
        return detail::xgetter<T>::get(v);
    }

    template <class T, class... Ts>
    inline constexpr decltype(auto) xget(const xtl::variant<Ts...>&& v)
    {
        return detail::xgetter<T>::get(std::move(v));
    }
}

#endif
