# This file is part of xrayutilities.
#
# xrayutilities is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 1 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
# Copyright (C) 2018 Dominik Kriegner <dominik.kriegner@gmail.com>

wp = {'1': {'1a': (7, ('(x, y, z)', ))},
      '2': {'1a': (0, ('(0, 0, 0)', )),
            '1b': (0, ('(0, 0, 1/2)', )),
            '1c': (0, ('(0, 1/2, 0)', )),
            '1d': (0, ('(1/2, 0, 0)', )),
            '1e': (0, ('(1/2, 1/2, 0)', )),
            '1f': (0, ('(1/2, 0, 1/2)', )),
            '1g': (0, ('(0, 1/2, 1/2)', )),
            '1h': (0, ('(1/2, 1/2, 1/2)', )),
            '2i': (7, ('(x, y, z)', '(-x, -y, -z)'))},
      '3:b': {'1a': (2, ('(0, y, 0)', )),
              '1b': (2, ('(0, y, 1/2)', )),
              '1c': (2, ('(1/2, y, 0)', )),
              '1d': (2, ('(1/2, y, 1/2)', )),
              '2e': (7, ('(x, y, z)', '(-x, y, -z)'))},
      '3:c': {'1a': (4, ('(0, 0, z)', )),
              '1b': (4, ('(1/2, 0, z)', )),
              '1c': (4, ('(0, 1/2, z)', )),
              '1d': (4, ('(1/2, 1/2, z)', )),
              '2e': (7, ('(x, y, z)', '(-x, -y, z)'))},
      '4:b': {'2a': (7, ('(x, y, z)', '(-x, y+1/2, -z)'))},
      '4:c': {'2a': (7, ('(x, y, z)', '(-x, -y, z+1/2)'))},
      '5:b': {'2a': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)')),
              '2b': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 1/2)')),
              '4c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, y, -z)',
                         '(-x+1/2, y+1/2, -z)'))},
      '5:c': {'2a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)')),
              '2b': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)')),
              '4c': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x, -y+1/2, z+1/2)'))},
      '6:b': {'1a': (5, ('(x, 0, z)', )),
              '1b': (5, ('(x, 1/2, z)', )),
              '2c': (7, ('(x, y, z)', '(x, -y, z)'))},
      '6:c': {'1a': (3, ('(x, y, 0)', )),
              '1b': (3, ('(x, y, 1/2)', )),
              '2c': (7, ('(x, y, z)', '(x, y, -z)'))},
      '7:b': {'2a': (7, ('(x, y, z)', '(x, -y, z+1/2)'))},
      '7:c': {'2a': (7, ('(x, y, z)', '(x+1/2, y, -z)'))},
      '8:b': {'2a': (5, ('(x, 0, z)', '(x+1/2, 1/2, z)')),
              '4b': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(x, -y, z)',
                         '(x+1/2, -y+1/2, z)'))},
      '8:c': {'2a': (3, ('(x, y, 0)', '(x, y+1/2, 1/2)')),
              '4b': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(x, y, -z)',
                         '(x, y+1/2, -z+1/2)'))},
      '9:b': {'4a': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(x, -y, z+1/2)',
                         '(x+1/2, -y+1/2, z+1/2)'))},
      '9:c': {'4a': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(x+1/2, y, -z)',
                         '(x+1/2, y+1/2, -z+1/2)'))},
      '10:b': {'1a': (0, ('(0, 0, 0)', )),
               '1b': (0, ('(0, 1/2, 0)', )),
               '1c': (0, ('(0, 0, 1/2)', )),
               '1d': (0, ('(1/2, 0, 0)', )),
               '1e': (0, ('(1/2, 1/2, 0)', )),
               '1f': (0, ('(0, 1/2, 1/2)', )),
               '1g': (0, ('(1/2, 0, 1/2)', )),
               '1h': (0, ('(1/2, 1/2, 1/2)', )),
               '2i': (2, ('(0, y, 0)', '(0, -y, 0)')),
               '2j': (2, ('(1/2, y, 0)', '(1/2, -y, 0)')),
               '2k': (2, ('(0, y, 1/2)', '(0, -y, 1/2)')),
               '2l': (2, ('(1/2, y, 1/2)', '(1/2, -y, 1/2)')),
               '2m': (5, ('(x, 0, z)', '(-x, 0, -z)')),
               '2n': (5, ('(x, 1/2, z)', '(-x, 1/2, -z)')),
               '4o': (7, ('(x, y, z)', '(-x, y, -z)', '(-x, -y, -z)',
                          '(x, -y, z)'))},
      '10:c': {'1a': (0, ('(0, 0, 0)', )),
               '1b': (0, ('(0, 0, 1/2)', )),
               '1c': (0, ('(1/2, 0, 0)', )),
               '1d': (0, ('(0, 1/2, 0)', )),
               '1e': (0, ('(0, 1/2, 1/2)', )),
               '1f': (0, ('(1/2, 0, 1/2)', )),
               '1g': (0, ('(1/2, 1/2, 0)', )),
               '1h': (0, ('(1/2, 1/2, 1/2)', )),
               '2i': (4, ('(0, 0, z)', '(0, 0, -z)')),
               '2j': (4, ('(0, 1/2, z)', '(0, 1/2, -z)')),
               '2k': (4, ('(1/2, 0, z)', '(1/2, 0, -z)')),
               '2l': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
               '2m': (3, ('(x, y, 0)', '(-x, -y, 0)')),
               '2n': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)')),
               '4o': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, -y, -z)',
                          '(x, y, -z)'))},
      '11:b': {'2a': (0, ('(0, 0, 0)', '(0, 1/2, 0)')),
               '2b': (0, ('(1/2, 0, 0)', '(1/2, 1/2, 0)')),
               '2c': (0, ('(0, 0, 1/2)', '(0, 1/2, 1/2)')),
               '2d': (0, ('(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)')),
               '2e': (5, ('(x, 1/4, z)', '(-x, 3/4, -z)')),
               '4f': (7, ('(x, y, z)', '(-x, y+1/2, -z)', '(-x, -y, -z)',
                          '(x, -y+1/2, z)'))},
      '11:c': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
               '2b': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)')),
               '2c': (0, ('(1/2, 0, 0)', '(1/2, 0, 1/2)')),
               '2d': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
               '2e': (3, ('(x, y, 1/4)', '(-x, -y, 3/4)')),
               '4f': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-x, -y, -z)',
                          '(x, y, -z+1/2)'))},
      '12:b': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
               '2b': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)')),
               '2c': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
               '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)')),
               '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                          '(1/4, 3/4, 0)')),
               '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)')),
               '4g': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)', '(0, -y, 0)',
                          '(1/2, -y+1/2, 0)')),
               '4h': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 1/2)', '(0, -y, 1/2)',
                          '(1/2, -y+1/2, 1/2)')),
               '4i': (5, ('(x, 0, z)', '(x+1/2, 1/2, z)', '(-x, 0, -z)',
                          '(-x+1/2, 1/2, -z)')),
               '8j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z)'))},
      '12:c': {'2a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)')),
               '2b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)')),
               '2c': (0, ('(1/2, 0, 0)', '(1/2, 1/2, 1/2)')),
               '2d': (0, ('(1/2, 0, 1/2)', '(1/2, 1/2, 0)')),
               '4e': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(0, 3/4, 1/4)',
                          '(0, 1/4, 3/4)')),
               '4f': (0, ('(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(1/2, 1/4, 3/4)')),
               '4g': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(0, 0, -z)',
                          '(0, 1/2, -z+1/2)')),
               '4h': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 0, -z)',
                          '(1/2, 1/2, -z+1/2)')),
               '4i': (3, ('(x, y, 0)', '(x, y+1/2, 1/2)', '(-x, -y, 0)',
                          '(-x, -y+1/2, 1/2)')),
               '8j': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x, -y+1/2, z+1/2)', '(-x, -y, -z)',
                          '(-x, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x, y+1/2, -z+1/2)'))},
      '13:b': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
               '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
               '2c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)')),
               '2d': (0, ('(1/2, 0, 0)', '(1/2, 0, 1/2)')),
               '2e': (2, ('(0, y, 1/4)', '(0, -y, 3/4)')),
               '2f': (2, ('(1/2, y, 1/4)', '(1/2, -y, 3/4)')),
               '4g': (7, ('(x, y, z)', '(-x, y, -z+1/2)', '(-x, -y, -z)',
                          '(x, -y, z+1/2)'))},
      '13:c': {'2a': (0, ('(0, 0, 0)', '(1/2, 0, 0)')),
               '2b': (0, ('(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)')),
               '2c': (0, ('(0, 0, 1/2)', '(1/2, 0, 1/2)')),
               '2d': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 0)')),
               '2e': (4, ('(1/4, 0, z)', '(3/4, 0, -z)')),
               '2f': (4, ('(1/4, 1/2, z)', '(3/4, 1/2, -z)')),
               '4g': (7, ('(x, y, z)', '(-x+1/2, -y, z)', '(-x, -y, -z)',
                          '(x+1/2, y, -z)'))},
      '14:b': {'2a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)')),
               '2b': (0, ('(1/2, 0, 0)', '(1/2, 1/2, 1/2)')),
               '2c': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)')),
               '2d': (0, ('(1/2, 0, 1/2)', '(1/2, 1/2, 0)')),
               '4e': (7, ('(x, y, z)', '(-x, y+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(x, -y+1/2, z+1/2)'))},
      '14:c': {'2a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)')),
               '2b': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 1/2)')),
               '2c': (0, ('(1/2, 0, 0)', '(0, 0, 1/2)')),
               '2d': (0, ('(1/2, 1/2, 0)', '(0, 1/2, 1/2)')),
               '4e': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)', '(-x, -y, -z)',
                          '(x+1/2, y, -z+1/2)'))},
      '15:b': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)',
                          '(1/2, 1/2, 1/2)')),
               '4b': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                          '(1/2, 0, 1/2)')),
               '4c': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 1/2)',
                          '(1/4, 3/4, 1/2)')),
               '4d': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(3/4, 1/4, 0)', '(1/4, 3/4, 0)')),
               '4e': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)', '(0, -y, 3/4)',
                          '(1/2, -y+1/2, 3/4)')),
               '8f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, y, -z+1/2)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z)', '(x, -y, z+1/2)',
                          '(x+1/2, -y+1/2, z+1/2)'))},
      '15:c': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 0)',
                          '(1/2, 1/2, 1/2)')),
               '4b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 1/2)',
                          '(1/2, 1/2, 0)')),
               '4c': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 3/4, 1/4)',
                          '(1/2, 1/4, 3/4)')),
               '4d': (0, ('(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                          '(0, 3/4, 1/4)', '(0, 1/4, 3/4)')),
               '4e': (4, ('(1/4, 0, z)', '(1/4, 1/2, z+1/2)', '(3/4, 0, -z)',
                          '(3/4, 1/2, -z+1/2)')),
               '8f': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x+1/2, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, -z)',
                          '(-x, -y+1/2, -z+1/2)', '(x+1/2, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)'))},
      '16': {'1a': (0, ('(0, 0, 0)', )),
             '1b': (0, ('(1/2, 0, 0)', )),
             '1c': (0, ('(0, 1/2, 0)', )),
             '1d': (0, ('(0, 0, 1/2)', )),
             '1e': (0, ('(1/2, 1/2, 0)', )),
             '1f': (0, ('(1/2, 0, 1/2)', )),
             '1g': (0, ('(0, 1/2, 1/2)', )),
             '1h': (0, ('(1/2, 1/2, 1/2)', )),
             '2i': (1, ('(x, 0, 0)', '(-x, 0, 0)')),
             '2j': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)')),
             '2k': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)')),
             '2l': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)')),
             '2m': (2, ('(0, y, 0)', '(0, -y, 0)')),
             '2n': (2, ('(0, y, 1/2)', '(0, -y, 1/2)')),
             '2o': (2, ('(1/2, y, 0)', '(1/2, -y, 0)')),
             '2p': (2, ('(1/2, y, 1/2)', '(1/2, -y, 1/2)')),
             '2q': (4, ('(0, 0, z)', '(0, 0, -z)')),
             '2r': (4, ('(1/2, 0, z)', '(1/2, 0, -z)')),
             '2s': (4, ('(0, 1/2, z)', '(0, 1/2, -z)')),
             '2t': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
             '4u': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                        '(x, -y, -z)'))},
      '17': {'2a': (1, ('(x, 0, 0)', '(-x, 0, 1/2)')),
             '2b': (1, ('(x, 1/2, 0)', '(-x, 1/2, 1/2)')),
             '2c': (2, ('(0, y, 1/4)', '(0, -y, 3/4)')),
             '2d': (2, ('(1/2, y, 1/4)', '(1/2, -y, 3/4)')),
             '4e': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-x, y, -z+1/2)',
                        '(x, -y, -z)'))},
      '18': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, -z)')),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, -z)')),
             '4c': (7, ('(x, y, z)', '(-x, -y, z)', '(-x+1/2, y+1/2, -z)',
                        '(x+1/2, -y+1/2, -z)'))},
      '19': {'4a': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                        '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)'))},
      '20': {'4a': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)')),
             '4b': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)', '(0, -y, 3/4)',
                        '(1/2, -y+1/2, 3/4)')),
             '8c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z+1/2)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z+1/2)',
                        '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                        '(x+1/2, -y+1/2, -z)'))},
      '21': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
             '2b': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)')),
             '2c': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)')),
             '2d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
             '4e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 0)')),
             '4f': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)')),
             '4g': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)', '(0, -y, 0)',
                        '(1/2, -y+1/2, 0)')),
             '4h': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 1/2)', '(0, -y, 1/2)',
                        '(1/2, -y+1/2, 1/2)')),
             '4i': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, -z)',
                        '(1/2, 1/2, -z)')),
             '4j': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                        '(1/2, 0, -z)')),
             '4k': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(3/4, 1/4, -z)',
                        '(1/4, 3/4, -z)')),
             '8l': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z)', '(-x, y, -z)',
                        '(-x+1/2, y+1/2, -z)', '(x, -y, -z)',
                        '(x+1/2, -y+1/2, -z)'))},
      '22': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                        '(1/2, 1/2, 0)')),
             '4b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                        '(1/2, 1/2, 1/2)')),
             '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                        '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)')),
             '4d': (0, ('(1/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                        '(3/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
             '8e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                        '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                        '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)')),
             '8f': (2, ('(0, y, 0)', '(0, y+1/2, 1/2)', '(1/2, y, 1/2)',
                        '(1/2, y+1/2, 0)', '(0, -y, 0)', '(0, -y+1/2, 1/2)',
                        '(1/2, -y, 1/2)', '(1/2, -y+1/2, 0)')),
             '8g': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                        '(1/2, 1/2, z)', '(0, 0, -z)', '(0, 1/2, -z+1/2)',
                        '(1/2, 0, -z+1/2)', '(1/2, 1/2, -z)')),
             '8h': (4, ('(1/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                        '(3/4, 1/4, z+1/2)', '(3/4, 3/4, z)',
                        '(3/4, 1/4, -z)', '(3/4, 3/4, -z+1/2)',
                        '(1/4, 1/4, -z+1/2)', '(1/4, 3/4, -z)')),
             '8i': (2, ('(1/4, y, 1/4)', '(1/4, y+1/2, 3/4)', '(3/4, y, 3/4)',
                        '(3/4, y+1/2, 1/4)', '(3/4, -y, 1/4)',
                        '(3/4, -y+1/2, 3/4)', '(1/4, -y, 3/4)',
                        '(1/4, -y+1/2, 1/4)')),
             '8j': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)', '(x+1/2, 1/4, 3/4)',
                        '(x+1/2, 3/4, 1/4)', '(-x, 3/4, 1/4)',
                        '(-x, 1/4, 3/4)', '(-x+1/2, 3/4, 3/4)',
                        '(-x+1/2, 1/4, 1/4)')),
             '16k': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                         '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                         '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                         '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                         '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                         '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                         '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                         '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)'))},
      '23': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
             '2b': (0, ('(1/2, 0, 0)', '(0, 1/2, 1/2)')),
             '2c': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
             '2d': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)')),
             '4e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 1/2)')),
             '4f': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 0)')),
             '4g': (2, ('(0, y, 0)', '(1/2, y+1/2, 1/2)', '(0, -y, 0)',
                        '(1/2, -y+1/2, 1/2)')),
             '4h': (2, ('(1/2, y, 0)', '(0, y+1/2, 1/2)', '(1/2, -y, 0)',
                        '(0, -y+1/2, 1/2)')),
             '4i': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)')),
             '4j': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, -z+1/2)')),
             '8k': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                        '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                        '(x+1/2, -y+1/2, -z+1/2)'))},
      '24': {'4a': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                        '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)')),
             '4b': (2, ('(1/4, y, 0)', '(3/4, y+1/2, 1/2)', '(1/4, -y, 1/2)',
                        '(3/4, -y+1/2, 0)')),
             '4c': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                        '(0, 3/4, -z+1/2)', '(1/2, 1/4, -z)')),
             '8d': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                        '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                        '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                        '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)'))},
      '25': {'1a': (4, ('(0, 0, z)', )),
             '1b': (4, ('(0, 1/2, z)', )),
             '1c': (4, ('(1/2, 0, z)', )),
             '1d': (4, ('(1/2, 1/2, z)', )),
             '2e': (5, ('(x, 0, z)', '(-x, 0, z)')),
             '2f': (5, ('(x, 1/2, z)', '(-x, 1/2, z)')),
             '2g': (6, ('(0, y, z)', '(0, -y, z)')),
             '2h': (6, ('(1/2, y, z)', '(1/2, -y, z)')),
             '4i': (7, ('(x, y, z)', '(-x, -y, z)', '(x, -y, z)',
                        '(-x, y, z)'))},
      '26': {'2a': (6, ('(0, y, z)', '(0, -y, z+1/2)')),
             '2b': (6, ('(1/2, y, z)', '(1/2, -y, z+1/2)')),
             '4c': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(x, -y, z+1/2)',
                        '(-x, y, z)'))},
      '27': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
             '2b': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)')),
             '2c': (4, ('(1/2, 0, z)', '(1/2, 0, z+1/2)')),
             '2d': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)')),
             '4e': (7, ('(x, y, z)', '(-x, -y, z)', '(x, -y, z+1/2)',
                        '(-x, y, z+1/2)'))},
      '28': {'2a': (4, ('(0, 0, z)', '(1/2, 0, z)')),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 1/2, z)')),
             '2c': (6, ('(1/4, y, z)', '(3/4, -y, z)')),
             '4d': (7, ('(x, y, z)', '(-x, -y, z)', '(x+1/2, -y, z)',
                        '(-x+1/2, y, z)'))},
      '29': {'4a': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(x+1/2, -y, z)',
                        '(-x+1/2, y, z+1/2)'))},
      '30': {'2a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)')),
             '2b': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)')),
             '4c': (7, ('(x, y, z)', '(-x, -y, z)', '(x, -y+1/2, z+1/2)',
                        '(-x, y+1/2, z+1/2)'))},
      '31': {'2a': (6, ('(0, y, z)', '(1/2, -y, z+1/2)')),
             '4b': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                        '(x+1/2, -y, z+1/2)', '(-x, y, z)'))},
      '32': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z)')),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, z)')),
             '4c': (7, ('(x, y, z)', '(-x, -y, z)', '(x+1/2, -y+1/2, z)',
                        '(-x+1/2, y+1/2, z)'))},
      '33': {'4a': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                        '(-x+1/2, y+1/2, z+1/2)'))},
      '34': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)')),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)')),
             '4c': (7, ('(x, y, z)', '(-x, -y, z)', '(x+1/2, -y+1/2, z+1/2)',
                        '(-x+1/2, y+1/2, z+1/2)'))},
      '35': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z)')),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, z)')),
             '4c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(1/4, 3/4, z)',
                        '(3/4, 1/4, z)')),
             '4d': (5, ('(x, 0, z)', '(x+1/2, 1/2, z)', '(-x, 0, z)',
                        '(-x+1/2, 1/2, z)')),
             '4e': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y, z)',
                        '(1/2, -y+1/2, z)')),
             '8f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z)', '(x, -y, z)',
                        '(x+1/2, -y+1/2, z)', '(-x, y, z)',
                        '(-x+1/2, y+1/2, z)'))},
      '36': {'4a': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y, z+1/2)',
                        '(1/2, -y+1/2, z+1/2)')),
             '8b': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z+1/2)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(x, -y, z+1/2)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                        '(-x+1/2, y+1/2, z)'))},
      '37': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, z+1/2)',
                        '(1/2, 1/2, z+1/2)')),
             '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, z+1/2)',
                        '(1/2, 0, z+1/2)')),
             '4c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(1/4, 3/4, z+1/2)',
                        '(3/4, 1/4, z+1/2)')),
             '8d': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z)', '(x, -y, z+1/2)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z+1/2)',
                        '(-x+1/2, y+1/2, z+1/2)'))},
      '38': {'2a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)')),
             '2b': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)')),
             '4c': (5, ('(x, 0, z)', '(x, 1/2, z+1/2)', '(-x, 0, z)',
                        '(-x, 1/2, z+1/2)')),
             '4d': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(0, -y, z)',
                        '(0, -y+1/2, z+1/2)')),
             '4e': (6, ('(1/2, y, z)', '(1/2, y+1/2, z+1/2)', '(1/2, -y, z)',
                        '(1/2, -y+1/2, z+1/2)')),
             '8f': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x, -y+1/2, z+1/2)', '(x, -y, z)',
                        '(x, -y+1/2, z+1/2)', '(-x, y, z)',
                        '(-x, y+1/2, z+1/2)'))},
      '39': {'4a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(0, 1/2, z)',
                        '(0, 0, z+1/2)')),
             '4b': (4, ('(1/2, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 1/2, z)',
                        '(1/2, 0, z+1/2)')),
             '4c': (5, ('(x, 1/4, z)', '(x, 3/4, z+1/2)', '(-x, 3/4, z)',
                        '(-x, 1/4, z+1/2)')),
             '8d': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x, -y+1/2, z+1/2)', '(x, -y+1/2, z)',
                        '(x, -y, z+1/2)', '(-x, y+1/2, z)', '(-x, y, z+1/2)'
                        ))},
      '40': {'4a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z)',
                        '(1/2, 1/2, z+1/2)')),
             '4b': (6, ('(1/4, y, z)', '(1/4, y+1/2, z+1/2)', '(3/4, -y, z)',
                        '(3/4, -y+1/2, z+1/2)')),
             '8c': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x, -y+1/2, z+1/2)', '(x+1/2, -y, z)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x+1/2, y, z)',
                        '(-x+1/2, y+1/2, z+1/2)'))},
      '41': {'4a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 1/2, z)',
                        '(1/2, 0, z+1/2)')),
             '8b': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x, -y+1/2, z+1/2)', '(x+1/2, -y+1/2, z)',
                        '(x+1/2, -y, z+1/2)', '(-x+1/2, y+1/2, z)',
                        '(-x+1/2, y, z+1/2)'))},
      '42': {'4a': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                        '(1/2, 1/2, z)')),
             '8b': (4, ('(1/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                        '(3/4, 1/4, z+1/2)', '(3/4, 3/4, z)', '(1/4, 3/4, z)',
                        '(1/4, 1/4, z+1/2)', '(3/4, 3/4, z+1/2)',
                        '(3/4, 1/4, z)')),
             '8c': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                        '(1/2, y+1/2, z)', '(0, -y, z)', '(0, -y+1/2, z+1/2)',
                        '(1/2, -y, z+1/2)', '(1/2, -y+1/2, z)')),
             '8d': (5, ('(x, 0, z)', '(x, 1/2, z+1/2)', '(x+1/2, 0, z+1/2)',
                        '(x+1/2, 1/2, z)', '(-x, 0, z)', '(-x, 1/2, z+1/2)',
                        '(-x+1/2, 0, z+1/2)', '(-x+1/2, 1/2, z)')),
             '16e': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                         '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                         '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                         '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                         '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                         '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                         '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                         '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)'))},
      '43': {'8a': (4, ('(0, 0, z)', '(1/2, 0, z+1/2)', '(0, 1/2, z+1/2)',
                        '(1/2, 1/2, z)', '(1/4, 1/4, z+1/4)',
                        '(3/4, 1/4, z+3/4)', '(1/4, 3/4, z+3/4)',
                        '(3/4, 3/4, z+1/4)')),
             '16b': (7, ('(x, y, z)', '(x+1/2, y, z+1/2)',
                         '(x, y+1/2, z+1/2)', '(x+1/2, y+1/2, z)',
                         '(-x, -y, z)', '(-x+1/2, -y, z+1/2)',
                         '(-x, -y+1/2, z+1/2)', '(-x+1/2, -y+1/2, z)',
                         '(x+1/4, -y+1/4, z+1/4)', '(x+3/4, -y+1/4, z+3/4)',
                         '(x+1/4, -y+3/4, z+3/4)', '(x+3/4, -y+3/4, z+1/4)',
                         '(-x+1/4, y+1/4, z+1/4)', '(-x+3/4, y+1/4, z+3/4)',
                         '(-x+1/4, y+3/4, z+3/4)', '(-x+3/4, y+3/4, z+1/4)'))},
      '44': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)')),
             '2b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)')),
             '4c': (5, ('(x, 0, z)', '(x+1/2, 1/2, z+1/2)', '(-x, 0, z)',
                        '(-x+1/2, 1/2, z+1/2)')),
             '4d': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                        '(1/2, -y+1/2, z+1/2)')),
             '8e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(x, -y, z)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                        '(-x+1/2, y+1/2, z+1/2)'))},
      '45': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 1/2, z)',
                        '(0, 0, z+1/2)')),
             '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)')),
             '8c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(x+1/2, -y+1/2, z)',
                        '(x, -y, z+1/2)', '(-x+1/2, y+1/2, z)',
                        '(-x, y, z+1/2)'))},
      '46': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)')),
             '4b': (6, ('(1/4, y, z)', '(3/4, y+1/2, z+1/2)', '(3/4, -y, z)',
                        '(1/4, -y+1/2, z+1/2)')),
             '8c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(x+1/2, -y, z)',
                        '(x, -y+1/2, z+1/2)', '(-x+1/2, y, z)',
                        '(-x, y+1/2, z+1/2)'))},
      '47': {'8A': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                        '(x, -y, -z)', '(-x, -y, -z)', '(x, y, -z)',
                        '(x, -y, z)', '(-x, y, z)')),
             '1a': (0, ('(0, 0, 0)', )),
             '1b': (0, ('(1/2, 0, 0)', )),
             '1c': (0, ('(0, 0, 1/2)', )),
             '1d': (0, ('(1/2, 0, 1/2)', )),
             '1e': (0, ('(0, 1/2, 0)', )),
             '1f': (0, ('(1/2, 1/2, 0)', )),
             '1g': (0, ('(0, 1/2, 1/2)', )),
             '1h': (0, ('(1/2, 1/2, 1/2)', )),
             '2i': (1, ('(x, 0, 0)', '(-x, 0, 0)')),
             '2j': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)')),
             '2k': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)')),
             '2l': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)')),
             '2m': (2, ('(0, y, 0)', '(0, -y, 0)')),
             '2n': (2, ('(0, y, 1/2)', '(0, -y, 1/2)')),
             '2o': (2, ('(1/2, y, 0)', '(1/2, -y, 0)')),
             '2p': (2, ('(1/2, y, 1/2)', '(1/2, -y, 1/2)')),
             '2q': (4, ('(0, 0, z)', '(0, 0, -z)')),
             '2r': (4, ('(0, 1/2, z)', '(0, 1/2, -z)')),
             '2s': (4, ('(1/2, 0, z)', '(1/2, 0, -z)')),
             '2t': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
             '4u': (6, ('(0, y, z)', '(0, -y, z)', '(0, y, -z)',
                        '(0, -y, -z)')),
             '4v': (6, ('(1/2, y, z)', '(1/2, -y, z)', '(1/2, y, -z)',
                        '(1/2, -y, -z)')),
             '4w': (5, ('(x, 0, z)', '(-x, 0, z)', '(-x, 0, -z)',
                        '(x, 0, -z)')),
             '4x': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(-x, 1/2, -z)',
                        '(x, 1/2, -z)')),
             '4y': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-x, y, 0)',
                        '(x, -y, 0)')),
             '4z': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)', '(-x, y, 1/2)',
                        '(x, -y, 1/2)'))},
      '48:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
               '2b': (0, ('(1/2, 0, 0)', '(0, 1/2, 1/2)')),
               '2c': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
               '2d': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)')),
               '4e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                          '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)')),
               '4f': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                          '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)')),
               '4g': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(-x+1/2, 1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)')),
               '4h': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(-x+1/2, 1/2, 0)',
                          '(x+1/2, 1/2, 0)')),
               '4i': (2, ('(0, y, 0)', '(0, -y, 0)', '(1/2, -y+1/2, 1/2)',
                          '(1/2, y+1/2, 1/2)')),
               '4j': (2, ('(1/2, y, 0)', '(1/2, -y, 0)', '(0, -y+1/2, 1/2)',
                          '(0, y+1/2, 1/2)')),
               '4k': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                          '(1/2, 1/2, z+1/2)')),
               '4l': (4, ('(0, 1/2, z)', '(0, 1/2, -z)', '(1/2, 0, -z+1/2)',
                          '(1/2, 0, z+1/2)')),
               '8m': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                          '(x+1/2, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, z+1/2)',
                          '(-x+1/2, y+1/2, z+1/2)'))},
      '48:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
               '2b': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)')),
               '2c': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)')),
               '2d': (0, ('(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)')),
               '4e': (0, ('(1/2, 1/2, 1/2)', '(0, 0, 1/2)', '(0, 1/2, 0)',
                          '(1/2, 0, 0)')),
               '4f': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 1/2)')),
               '4g': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                          '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)')),
               '4h': (1, ('(x, 1/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                          '(-x, 3/4, 1/4)', '(x+1/2, 3/4, 1/4)')),
               '4i': (2, ('(1/4, y, 1/4)', '(1/4, -y+1/2, 1/4)',
                          '(3/4, -y, 3/4)', '(3/4, y+1/2, 3/4)')),
               '4j': (2, ('(3/4, y, 1/4)', '(3/4, -y+1/2, 1/4)',
                          '(1/4, -y, 3/4)', '(1/4, y+1/2, 3/4)')),
               '4k': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, -z+1/2)',
                          '(3/4, 3/4, -z)', '(3/4, 3/4, z+1/2)')),
               '4l': (4, ('(1/4, 3/4, z)', '(1/4, 3/4, -z+1/2)',
                          '(3/4, 1/4, -z)', '(3/4, 1/4, z+1/2)')),
               '8m': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                          '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                          '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)'))},
      '49': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
             '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
             '2c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)')),
             '2d': (0, ('(1/2, 0, 0)', '(1/2, 0, 1/2)')),
             '2e': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
             '2f': (0, ('(1/2, 0, 1/4)', '(1/2, 0, 3/4)')),
             '2g': (0, ('(0, 1/2, 1/4)', '(0, 1/2, 3/4)')),
             '2h': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)')),
             '4i': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(-x, 0, 3/4)',
                        '(x, 0, 3/4)')),
             '4j': (1, ('(x, 1/2, 1/4)', '(-x, 1/2, 1/4)', '(-x, 1/2, 3/4)',
                        '(x, 1/2, 3/4)')),
             '4k': (2, ('(0, y, 1/4)', '(0, -y, 1/4)', '(0, -y, 3/4)',
                        '(0, y, 3/4)')),
             '4l': (2, ('(1/2, y, 1/4)', '(1/2, -y, 1/4)', '(1/2, -y, 3/4)',
                        '(1/2, y, 3/4)')),
             '4m': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                        '(0, 0, z+1/2)')),
             '4n': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z+1/2)',
                        '(1/2, 1/2, -z)', '(1/2, 1/2, z+1/2)')),
             '4o': (4, ('(0, 1/2, z)', '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                        '(0, 1/2, z+1/2)')),
             '4p': (4, ('(1/2, 0, z)', '(1/2, 0, -z+1/2)', '(1/2, 0, -z)',
                        '(1/2, 0, z+1/2)')),
             '4q': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-x, y, 1/2)',
                        '(x, -y, 1/2)')),
             '8r': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z+1/2)',
                        '(x, -y, -z+1/2)', '(-x, -y, -z)', '(x, y, -z)',
                        '(x, -y, z+1/2)', '(-x, y, z+1/2)'))},
      '50:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
               '2b': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)')),
               '2c': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)')),
               '2d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
               '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                          '(1/4, 3/4, 0)')),
               '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)')),
               '4g': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(-x+1/2, 1/2, 0)',
                          '(x+1/2, 1/2, 0)')),
               '4h': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)')),
               '4i': (2, ('(0, y, 0)', '(0, -y, 0)', '(1/2, -y+1/2, 0)',
                          '(1/2, y+1/2, 0)')),
               '4j': (2, ('(0, y, 1/2)', '(0, -y, 1/2)', '(1/2, -y+1/2, 1/2)',
                          '(1/2, y+1/2, 1/2)')),
               '4k': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z)',
                          '(1/2, 1/2, z)')),
               '4l': (4, ('(0, 1/2, z)', '(0, 1/2, -z)', '(1/2, 0, -z)',
                          '(1/2, 0, z)')),
               '8m': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(-x+1/2, -y+1/2, -z)',
                          '(x+1/2, y+1/2, -z)', '(x+1/2, -y+1/2, z)',
                          '(-x+1/2, y+1/2, z)'))},
      '50:2': {'2a': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)')),
               '2b': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 0)')),
               '2c': (0, ('(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)')),
               '2d': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)')),
               '4e': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                          '(0, 1/2, 0)')),
               '4f': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 1/2)')),
               '4g': (1, ('(x, 1/4, 0)', '(-x+1/2, 1/4, 0)', '(-x, 3/4, 0)',
                          '(x+1/2, 3/4, 0)')),
               '4h': (1, ('(x, 1/4, 1/2)', '(-x+1/2, 1/4, 1/2)',
                          '(-x, 3/4, 1/2)', '(x+1/2, 3/4, 1/2)')),
               '4i': (2, ('(1/4, y, 0)', '(1/4, -y+1/2, 0)', '(3/4, -y, 0)',
                          '(3/4, y+1/2, 0)')),
               '4j': (2, ('(1/4, y, 1/2)', '(1/4, -y+1/2, 1/2)',
                          '(3/4, -y, 1/2)', '(3/4, y+1/2, 1/2)')),
               '4k': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, -z)', '(3/4, 3/4, -z)',
                          '(3/4, 3/4, z)')),
               '4l': (4, ('(1/4, 3/4, z)', '(1/4, 3/4, -z)', '(3/4, 1/4, -z)',
                          '(3/4, 1/4, z)')),
               '8m': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-x+1/2, y, -z)', '(x, -y+1/2, -z)',
                          '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                          '(x+1/2, -y, z)', '(-x, y+1/2, z)'))},
      '51': {'2a': (0, ('(0, 0, 0)', '(1/2, 0, 0)')),
             '2b': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 0)')),
             '2c': (0, ('(0, 0, 1/2)', '(1/2, 0, 1/2)')),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)')),
             '2e': (4, ('(1/4, 0, z)', '(3/4, 0, -z)')),
             '2f': (4, ('(1/4, 1/2, z)', '(3/4, 1/2, -z)')),
             '4g': (2, ('(0, y, 0)', '(1/2, -y, 0)', '(0, -y, 0)',
                        '(1/2, y, 0)')),
             '4h': (2, ('(0, y, 1/2)', '(1/2, -y, 1/2)', '(0, -y, 1/2)',
                        '(1/2, y, 1/2)')),
             '4i': (5, ('(x, 0, z)', '(-x+1/2, 0, z)', '(-x, 0, -z)',
                        '(x+1/2, 0, -z)')),
             '4j': (5, ('(x, 1/2, z)', '(-x+1/2, 1/2, z)', '(-x, 1/2, -z)',
                        '(x+1/2, 1/2, -z)')),
             '4k': (6, ('(1/4, y, z)', '(1/4, -y, z)', '(3/4, y, -z)',
                        '(3/4, -y, -z)')),
             '8l': (7, ('(x, y, z)', '(-x+1/2, -y, z)', '(-x, y, -z)',
                        '(x+1/2, -y, -z)', '(-x, -y, -z)', '(x+1/2, y, -z)',
                        '(x, -y, z)', '(-x+1/2, y, z)'))},
      '52': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 0)', '(1/2, 1/2, 1/2)',
                        '(0, 1/2, 1/2)')),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                        '(0, 1/2, 0)')),
             '4c': (4, ('(1/4, 0, z)', '(1/4, 1/2, -z+1/2)', '(3/4, 0, -z)',
                        '(3/4, 1/2, z+1/2)')),
             '4d': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 3/4, 1/4)',
                        '(-x, 3/4, 3/4)', '(x+1/2, 1/4, 3/4)')),
             '8e': (7, ('(x, y, z)', '(-x+1/2, -y, z)',
                        '(-x+1/2, y+1/2, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                        '(-x, -y, -z)', '(x+1/2, y, -z)',
                        '(x+1/2, -y+1/2, z+1/2)', '(-x, y+1/2, z+1/2)'))},
      '53': {'2a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)')),
             '2b': (0, ('(1/2, 0, 0)', '(0, 0, 1/2)')),
             '2c': (0, ('(1/2, 1/2, 0)', '(0, 1/2, 1/2)')),
             '2d': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 1/2)')),
             '4e': (1, ('(x, 0, 0)', '(-x+1/2, 0, 1/2)', '(-x, 0, 0)',
                        '(x+1/2, 0, 1/2)')),
             '4f': (1, ('(x, 1/2, 0)', '(-x+1/2, 1/2, 1/2)', '(-x, 1/2, 0)',
                        '(x+1/2, 1/2, 1/2)')),
             '4g': (2, ('(1/4, y, 1/4)', '(1/4, -y, 3/4)', '(3/4, -y, 3/4)',
                        '(3/4, y, 1/4)')),
             '4h': (6, ('(0, y, z)', '(1/2, -y, z+1/2)', '(1/2, y, -z+1/2)',
                        '(0, -y, -z)')),
             '8i': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                        '(-x+1/2, y, -z+1/2)', '(x, -y, -z)', '(-x, -y, -z)',
                        '(x+1/2, y, -z+1/2)', '(x+1/2, -y, z+1/2)',
                        '(-x, y, z)'))},
      '54': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)',
                        '(1/2, 0, 1/2)')),
             '4b': (0, ('(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 1/2, 1/2)')),
             '4c': (2, ('(0, y, 1/4)', '(1/2, -y, 1/4)', '(0, -y, 3/4)',
                        '(1/2, y, 3/4)')),
             '4d': (4, ('(1/4, 0, z)', '(3/4, 0, -z+1/2)', '(3/4, 0, -z)',
                        '(1/4, 0, z+1/2)')),
             '4e': (4, ('(1/4, 1/2, z)', '(3/4, 1/2, -z+1/2)',
                        '(3/4, 1/2, -z)', '(1/4, 1/2, z+1/2)')),
             '8f': (7, ('(x, y, z)', '(-x+1/2, -y, z)', '(-x, y, -z+1/2)',
                        '(x+1/2, -y, -z+1/2)', '(-x, -y, -z)',
                        '(x+1/2, y, -z)', '(x, -y, z+1/2)',
                        '(-x+1/2, y, z+1/2)'))},
      '55': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
             '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)')),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)')),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, -z)', '(0, 0, -z)',
                        '(1/2, 1/2, z)')),
             '4f': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(0, 1/2, -z)',
                        '(1/2, 0, z)')),
             '4g': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-x+1/2, y+1/2, 0)',
                        '(x+1/2, -y+1/2, 0)')),
             '4h': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)',
                        '(-x+1/2, y+1/2, 1/2)', '(x+1/2, -y+1/2, 1/2)')),
             '8i': (7, ('(x, y, z)', '(-x, -y, z)', '(-x+1/2, y+1/2, -z)',
                        '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)', '(x, y, -z)',
                        '(x+1/2, -y+1/2, z)', '(-x+1/2, y+1/2, z)'))},
      '56': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)')),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 0)',
                        '(1/2, 0, 0)')),
             '4c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z+1/2)',
                        '(3/4, 3/4, -z)', '(1/4, 1/4, z+1/2)')),
             '4d': (4, ('(1/4, 3/4, z)', '(3/4, 1/4, -z+1/2)',
                        '(3/4, 1/4, -z)', '(1/4, 3/4, z+1/2)')),
             '8e': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                        '(-x, y+1/2, -z+1/2)', '(x+1/2, -y, -z+1/2)',
                        '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                        '(x, -y+1/2, z+1/2)', '(-x+1/2, y, z+1/2)'))},
      '57': {'4a': (0, ('(0, 0, 0)', '(0, 0, 1/2)', '(0, 1/2, 1/2)',
                        '(0, 1/2, 0)')),
             '4b': (0, ('(1/2, 0, 0)', '(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)',
                        '(1/2, 1/2, 0)')),
             '4c': (1, ('(x, 1/4, 0)', '(-x, 3/4, 1/2)', '(-x, 3/4, 0)',
                        '(x, 1/4, 1/2)')),
             '4d': (3, ('(x, y, 1/4)', '(-x, -y, 3/4)', '(-x, y+1/2, 1/4)',
                        '(x, -y+1/2, 3/4)')),
             '8e': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-x, y+1/2, -z+1/2)',
                        '(x, -y+1/2, -z)', '(-x, -y, -z)', '(x, y, -z+1/2)',
                        '(x, -y+1/2, z+1/2)', '(-x, y+1/2, z)'))},
      '58': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
             '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)')),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)')),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, -z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, z+1/2)')),
             '4f': (4, ('(0, 1/2, z)', '(1/2, 0, -z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, z+1/2)')),
             '4g': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-x+1/2, y+1/2, 1/2)',
                        '(x+1/2, -y+1/2, 1/2)')),
             '8h': (7, ('(x, y, z)', '(-x, -y, z)', '(-x+1/2, y+1/2, -z+1/2)',
                        '(x+1/2, -y+1/2, -z+1/2)', '(-x, -y, -z)',
                        '(x, y, -z)', '(x+1/2, -y+1/2, z+1/2)',
                        '(-x+1/2, y+1/2, z+1/2)'))},
      '59:1': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, -z)')),
               '2b': (4, ('(0, 1/2, z)', '(1/2, 0, -z)')),
               '4c': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(1/4, 3/4, 0)',
                          '(3/4, 1/4, 0)')),
               '4d': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)')),
               '4e': (6, ('(0, y, z)', '(0, -y, z)', '(1/2, y+1/2, -z)',
                          '(1/2, -y+1/2, -z)')),
               '4f': (5, ('(x, 0, z)', '(-x, 0, z)', '(-x+1/2, 1/2, -z)',
                          '(x+1/2, 1/2, -z)')),
               '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-x+1/2, y+1/2, -z)',
                          '(x+1/2, -y+1/2, -z)', '(-x+1/2, -y+1/2, -z)',
                          '(x+1/2, y+1/2, -z)', '(x, -y, z)', '(-x, y, z)'))},
      '59:2': {'2a': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z)')),
               '2b': (4, ('(1/4, 3/4, z)', '(3/4, 1/4, -z)')),
               '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 0)',
                          '(1/2, 0, 0)')),
               '4d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/2)',
                          '(1/2, 0, 1/2)')),
               '4e': (6, ('(1/4, y, z)', '(1/4, -y+1/2, z)',
                          '(3/4, y+1/2, -z)', '(3/4, -y, -z)')),
               '4f': (5, ('(x, 1/4, z)', '(-x+1/2, 1/4, z)', '(-x, 3/4, -z)',
                          '(x+1/2, 3/4, -z)')),
               '8g': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y+1/2, -z)', '(x+1/2, -y, -z)',
                          '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                          '(x, -y+1/2, z)', '(-x+1/2, y, z)'))},
      '60': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 0, 1/2)',
                        '(1/2, 1/2, 0)')),
             '4b': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 0)')),
             '4c': (2, ('(0, y, 1/4)', '(1/2, -y+1/2, 3/4)', '(0, -y, 3/4)',
                        '(1/2, y+1/2, 1/4)')),
             '8d': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z+1/2)',
                        '(-x, y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                        '(-x, -y, -z)', '(x+1/2, y+1/2, -z+1/2)',
                        '(x, -y, z+1/2)', '(-x+1/2, y+1/2, z)'))},
      '61': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                        '(1/2, 1/2, 0)')),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                        '(1/2, 1/2, 1/2)')),
             '8c': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                        '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                        '(-x, -y, -z)', '(x+1/2, y, -z+1/2)',
                        '(x, -y+1/2, z+1/2)', '(-x+1/2, y+1/2, z)'))},
      '62': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 0)',
                        '(1/2, 1/2, 1/2)')),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 1/2, 0)')),
             '4c': (5, ('(x, 1/4, z)', '(-x+1/2, 3/4, z+1/2)',
                        '(-x, 3/4, -z)', '(x+1/2, 1/4, -z+1/2)')),
             '8d': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)', '(-x, y+1/2, -z)',
                        '(x+1/2, -y+1/2, -z+1/2)', '(-x, -y, -z)',
                        '(x+1/2, y, -z+1/2)', '(x, -y+1/2, z)',
                        '(-x+1/2, y+1/2, z+1/2)'))},
      '63': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)',
                        '(1/2, 1/2, 1/2)')),
             '4b': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)')),
             '4c': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)', '(0, -y, 3/4)',
                        '(1/2, -y+1/2, 3/4)')),
             '8d': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 3/4, 1/2)',
                        '(1/4, 1/4, 1/2)', '(3/4, 1/4, 1/2)',
                        '(1/4, 3/4, 1/2)', '(1/4, 3/4, 0)', '(3/4, 1/4, 0)')),
             '8e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 0)', '(x, 0, 1/2)',
                        '(x+1/2, 1/2, 1/2)')),
             '8f': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y, z+1/2)',
                        '(1/2, -y+1/2, z+1/2)', '(0, y, -z+1/2)',
                        '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                        '(1/2, -y+1/2, -z)')),
             '8g': (3, ('(x, y, 1/4)', '(x+1/2, y+1/2, 1/4)', '(-x, -y, 3/4)',
                        '(-x+1/2, -y+1/2, 3/4)', '(-x, y, 1/4)',
                        '(-x+1/2, y+1/2, 1/4)', '(x, -y, 3/4)',
                        '(x+1/2, -y+1/2, 3/4)')),
             '16h': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z+1/2)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z+1/2)',
                         '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y, -z+1/2)',
                         '(x+1/2, y+1/2, -z+1/2)', '(x, -y, z+1/2)',
                         '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z)'))},
      '64': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)')),
             '4b': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 1/2)',
                        '(0, 0, 1/2)')),
             '8c': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 1/2)',
                        '(1/4, 3/4, 1/2)', '(3/4, 3/4, 1/2)',
                        '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)', '(3/4, 1/4, 0)')),
             '8d': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 1/2, 1/2)',
                        '(-x+1/2, 0, 1/2)', '(-x, 0, 0)', '(-x+1/2, 1/2, 0)',
                        '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)')),
             '8e': (2, ('(1/4, y, 1/4)', '(3/4, y+1/2, 1/4)',
                        '(3/4, -y+1/2, 3/4)', '(1/4, -y, 3/4)',
                        '(3/4, -y, 3/4)', '(1/4, -y+1/2, 3/4)',
                        '(1/4, y+1/2, 1/4)', '(3/4, y, 1/4)')),
             '8f': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y+1/2, z+1/2)',
                        '(1/2, -y, z+1/2)', '(0, y+1/2, -z+1/2)',
                        '(1/2, y, -z+1/2)', '(0, -y, -z)',
                        '(1/2, -y+1/2, -z)')),
             '16g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)',
                         '(-x, -y+1/2, z+1/2)', '(-x+1/2, -y, z+1/2)',
                         '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z+1/2)',
                         '(x, -y, -z)', '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y+1/2, -z+1/2)',
                         '(x+1/2, y, -z+1/2)', '(x, -y+1/2, z+1/2)',
                         '(x+1/2, -y, z+1/2)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z)'))},
      '65': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
             '2b': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)')),
             '2c': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)')),
             '2d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
             '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                        '(1/4, 3/4, 0)')),
             '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                        '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)')),
             '4g': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 0)')),
             '4h': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)')),
             '4i': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)', '(0, -y, 0)',
                        '(1/2, -y+1/2, 0)')),
             '4j': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 1/2)', '(0, -y, 1/2)',
                        '(1/2, -y+1/2, 1/2)')),
             '4k': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, -z)',
                        '(1/2, 1/2, -z)')),
             '4l': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                        '(1/2, 0, -z)')),
             '8m': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(3/4, 1/4, -z)',
                        '(1/4, 3/4, -z)', '(3/4, 3/4, -z)', '(1/4, 1/4, -z)',
                        '(1/4, 3/4, z)', '(3/4, 1/4, z)')),
             '8n': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y, z)',
                        '(1/2, -y+1/2, z)', '(0, y, -z)', '(1/2, y+1/2, -z)',
                        '(0, -y, -z)', '(1/2, -y+1/2, -z)')),
             '8o': (5, ('(x, 0, z)', '(x+1/2, 1/2, z)', '(-x, 0, z)',
                        '(-x+1/2, 1/2, z)', '(-x, 0, -z)',
                        '(-x+1/2, 1/2, -z)', '(x, 0, -z)', '(x+1/2, 1/2, -z)'
                        )),
             '8p': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 0)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 0)', '(-x, y, 0)',
                        '(-x+1/2, y+1/2, 0)', '(x, -y, 0)',
                        '(x+1/2, -y+1/2, 0)')),
             '8q': (3, ('(x, y, 1/2)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 1/2)',
                        '(-x+1/2, -y+1/2, 1/2)', '(-x, y, 1/2)',
                        '(-x+1/2, y+1/2, 1/2)', '(x, -y, 1/2)',
                        '(x+1/2, -y+1/2, 1/2)')),
             '16r': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z)', '(-x, y, -z)',
                         '(-x+1/2, y+1/2, -z)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z)', '(x, -y, z)',
                         '(x+1/2, -y+1/2, z)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z)'))},
      '66': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 1/4)', '(0, 0, 3/4)',
                        '(1/2, 1/2, 3/4)')),
             '4b': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(0, 1/2, 3/4)',
                        '(1/2, 0, 3/4)')),
             '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)',
                        '(1/2, 1/2, 1/2)')),
             '4d': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)')),
             '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 1/2)',
                        '(1/4, 3/4, 1/2)')),
             '4f': (0, ('(1/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                        '(1/4, 1/4, 1/2)')),
             '8g': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 1/4)', '(-x, 0, 1/4)',
                        '(-x+1/2, 1/2, 1/4)', '(-x, 0, 3/4)',
                        '(-x+1/2, 1/2, 3/4)', '(x, 0, 3/4)',
                        '(x+1/2, 1/2, 3/4)')),
             '8h': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)', '(0, -y, 1/4)',
                        '(1/2, -y+1/2, 1/4)', '(0, -y, 3/4)',
                        '(1/2, -y+1/2, 3/4)', '(0, y, 3/4)',
                        '(1/2, y+1/2, 3/4)')),
             '8i': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, -z+1/2)',
                        '(1/2, 1/2, -z+1/2)', '(0, 0, -z)', '(1/2, 1/2, -z)',
                        '(0, 0, z+1/2)', '(1/2, 1/2, z+1/2)')),
             '8j': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z+1/2)',
                        '(1/2, 0, -z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z)',
                        '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)')),
             '8k': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)',
                        '(3/4, 1/4, -z+1/2)', '(1/4, 3/4, -z+1/2)',
                        '(3/4, 3/4, -z)', '(1/4, 1/4, -z)',
                        '(1/4, 3/4, z+1/2)', '(3/4, 1/4, z+1/2)')),
             '8l': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 0)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 0)', '(-x, y, 1/2)',
                        '(-x+1/2, y+1/2, 1/2)', '(x, -y, 1/2)',
                        '(x+1/2, -y+1/2, 1/2)')),
             '16m': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z)', '(-x, y, -z+1/2)',
                         '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z+1/2)',
                         '(x+1/2, -y+1/2, -z+1/2)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z)', '(x, -y, z+1/2)',
                         '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z+1/2)',
                         '(-x+1/2, y+1/2, z+1/2)'))},
      '67': {'4a': (0, ('(1/4, 0, 0)', '(3/4, 1/2, 0)', '(3/4, 0, 0)',
                        '(1/4, 1/2, 0)')),
             '4b': (0, ('(1/4, 0, 1/2)', '(3/4, 1/2, 1/2)', '(3/4, 0, 1/2)',
                        '(1/4, 1/2, 1/2)')),
             '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 0)',
                        '(1/2, 0, 0)')),
             '4d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 1/2)')),
             '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                        '(1/4, 3/4, 0)')),
             '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                        '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)')),
             '4g': (4, ('(0, 1/4, z)', '(1/2, 3/4, z)', '(0, 3/4, -z)',
                        '(1/2, 1/4, -z)')),
             '8h': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x, 1/2, 0)',
                        '(-x+1/2, 0, 0)', '(-x, 0, 0)', '(-x+1/2, 1/2, 0)',
                        '(x, 1/2, 0)', '(x+1/2, 0, 0)')),
             '8i': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 1/2)', '(-x, 1/2, 1/2)',
                        '(-x+1/2, 0, 1/2)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 1/2)', '(x, 1/2, 1/2)',
                        '(x+1/2, 0, 1/2)')),
             '8j': (2, ('(1/4, y, 0)', '(3/4, y+1/2, 0)', '(3/4, -y+1/2, 0)',
                        '(1/4, -y, 0)', '(3/4, -y, 0)', '(1/4, -y+1/2, 0)',
                        '(1/4, y+1/2, 0)', '(3/4, y, 0)')),
             '8k': (2, ('(1/4, y, 1/2)', '(3/4, y+1/2, 1/2)',
                        '(3/4, -y+1/2, 1/2)', '(1/4, -y, 1/2)',
                        '(3/4, -y, 1/2)', '(1/4, -y+1/2, 1/2)',
                        '(1/4, y+1/2, 1/2)', '(3/4, y, 1/2)')),
             '8l': (4, ('(1/4, 0, z)', '(3/4, 1/2, z)', '(3/4, 1/2, -z)',
                        '(1/4, 0, -z)', '(3/4, 0, -z)', '(1/4, 1/2, -z)',
                        '(1/4, 1/2, z)', '(3/4, 0, z)')),
             '8m': (6, ('(0, y, z)', '(1/2, y+1/2, z)', '(0, -y+1/2, z)',
                        '(1/2, -y, z)', '(0, y+1/2, -z)', '(1/2, y, -z)',
                        '(0, -y, -z)', '(1/2, -y+1/2, -z)')),
             '8n': (5, ('(x, 1/4, z)', '(x+1/2, 3/4, z)', '(-x, 1/4, z)',
                        '(-x+1/2, 3/4, z)', '(-x, 3/4, -z)',
                        '(-x+1/2, 1/4, -z)', '(x, 3/4, -z)',
                        '(x+1/2, 1/4, -z)')),
             '16o': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)', '(-x, -y+1/2, z)',
                         '(-x+1/2, -y, z)', '(-x, y+1/2, -z)',
                         '(-x+1/2, y, -z)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z)', '(x, y+1/2, -z)',
                         '(x+1/2, y, -z)', '(x, -y+1/2, z)', '(x+1/2, -y, z)',
                         '(-x, y, z)', '(-x+1/2, y+1/2, z)'))},
      '68:1': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                          '(1/2, 0, 1/2)')),
               '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 0)',
                          '(1/2, 0, 0)')),
               '8c': (0, ('(1/4, 0, 1/4)', '(3/4, 1/2, 1/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)', '(3/4, 0, 3/4)',
                          '(1/4, 1/2, 3/4)', '(3/4, 1/2, 3/4)',
                          '(1/4, 0, 3/4)')),
               '8d': (0, ('(0, 1/4, 1/4)', '(1/2, 3/4, 1/4)',
                          '(1/2, 1/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(0, 3/4, 3/4)')),
               '8e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 0)', '(-x+1/2, 1/2, 0)',
                          '(-x, 0, 0)', '(-x, 1/2, 1/2)', '(-x+1/2, 0, 1/2)',
                          '(x+1/2, 0, 1/2)', '(x, 1/2, 1/2)')),
               '8f': (2, ('(0, y, 0)', '(1/2, y+1/2, 0)', '(1/2, -y+1/2, 0)',
                          '(0, -y, 0)', '(0, -y+1/2, 1/2)', '(1/2, -y, 1/2)',
                          '(1/2, y, 1/2)', '(0, y+1/2, 1/2)')),
               '8g': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(0, 0, -z)',
                          '(1/2, 1/2, -z)', '(0, 1/2, -z+1/2)',
                          '(1/2, 0, -z+1/2)', '(0, 1/2, z+1/2)',
                          '(1/2, 0, z+1/2)')),
               '8h': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z)', '(3/4, 1/4, -z)',
                          '(1/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)',
                          '(1/4, 3/4, -z+1/2)', '(1/4, 1/4, z+1/2)',
                          '(3/4, 3/4, z+1/2)')),
               '16i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)',
                           '(-x+1/2, -y+1/2, z)', '(-x, -y, z)',
                           '(-x, y, -z)', '(-x+1/2, y+1/2, -z)',
                           '(x+1/2, -y+1/2, -z)', '(x, -y, -z)',
                           '(-x, -y+1/2, -z+1/2)', '(-x+1/2, -y, -z+1/2)',
                           '(x+1/2, y, -z+1/2)', '(x, y+1/2, -z+1/2)',
                           '(x, -y+1/2, z+1/2)', '(x+1/2, -y, z+1/2)',
                           '(-x+1/2, y, z+1/2)', '(-x, y+1/2, z+1/2)'))},
      '68:2': {'4a': (0, ('(0, 1/4, 1/4)', '(1/2, 3/4, 1/4)', '(0, 3/4, 3/4)',
                          '(1/2, 1/4, 3/4)')),
               '4b': (0, ('(0, 1/4, 3/4)', '(1/2, 3/4, 3/4)', '(0, 3/4, 1/4)',
                          '(1/2, 1/4, 1/4)')),
               '8c': (0, ('(1/4, 3/4, 0)', '(3/4, 1/4, 0)', '(1/4, 1/4, 0)',
                          '(3/4, 3/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(1/4, 3/4, 1/2)')),
               '8d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                          '(0, 1/2, 0)', '(0, 0, 1/2)', '(1/2, 1/2, 1/2)',
                          '(1/2, 0, 1/2)', '(0, 1/2, 1/2)')),
               '8e': (1, ('(x, 1/4, 1/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x+1/2, 3/4, 1/4)', '(-x, 1/4, 1/4)',
                          '(-x, 3/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x, 3/4, 3/4)')),
               '8f': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 1/4)',
                          '(1/2, -y, 1/4)', '(0, -y+1/2, 1/4)',
                          '(0, -y, 3/4)', '(1/2, -y+1/2, 3/4)',
                          '(1/2, y, 3/4)', '(0, y+1/2, 3/4)')),
               '8g': (4, ('(0, 1/4, z)', '(1/2, 3/4, z)', '(0, 1/4, -z+1/2)',
                          '(1/2, 3/4, -z+1/2)', '(0, 3/4, -z)',
                          '(1/2, 1/4, -z)', '(0, 3/4, z+1/2)',
                          '(1/2, 1/4, z+1/2)')),
               '8h': (4, ('(1/4, 0, z)', '(3/4, 1/2, z)', '(3/4, 0, -z+1/2)',
                          '(1/4, 1/2, -z+1/2)', '(3/4, 0, -z)',
                          '(1/4, 1/2, -z)', '(1/4, 0, z+1/2)',
                          '(3/4, 1/2, z+1/2)')),
               '16i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z)',
                           '(-x+1/2, -y, z)', '(-x, -y+1/2, z)',
                           '(-x, y, -z+1/2)', '(-x+1/2, y+1/2, -z+1/2)',
                           '(x+1/2, -y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                           '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z)',
                           '(x+1/2, y, -z)', '(x, y+1/2, -z)',
                           '(x, -y, z+1/2)', '(x+1/2, -y+1/2, z+1/2)',
                           '(-x+1/2, y, z+1/2)', '(-x, y+1/2, z+1/2)'))},
      '69': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                        '(1/2, 1/2, 0)')),
             '4b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                        '(1/2, 1/2, 1/2)')),
             '8c': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                        '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                        '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)')),
             '8d': (0, ('(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                        '(3/4, 1/2, 1/4)', '(3/4, 0, 1/4)', '(3/4, 1/2, 3/4)',
                        '(1/4, 0, 3/4)', '(1/4, 1/2, 1/4)')),
             '8e': (0, ('(1/4, 1/4, 0)', '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                        '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                        '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)')),
             '8f': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                        '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                        '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                        '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)')),
             '8g': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                        '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                        '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)')),
             '8h': (2, ('(0, y, 0)', '(0, y+1/2, 1/2)', '(1/2, y, 1/2)',
                        '(1/2, y+1/2, 0)', '(0, -y, 0)', '(0, -y+1/2, 1/2)',
                        '(1/2, -y, 1/2)', '(1/2, -y+1/2, 0)')),
             '8i': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                        '(1/2, 1/2, z)', '(0, 0, -z)', '(0, 1/2, -z+1/2)',
                        '(1/2, 0, -z+1/2)', '(1/2, 1/2, -z)')),
             '16j': (4, ('(1/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                         '(3/4, 1/4, z+1/2)', '(3/4, 3/4, z)',
                         '(3/4, 1/4, -z)', '(3/4, 3/4, -z+1/2)',
                         '(1/4, 1/4, -z+1/2)', '(1/4, 3/4, -z)',
                         '(3/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)',
                         '(1/4, 3/4, -z+1/2)', '(1/4, 1/4, -z)',
                         '(1/4, 3/4, z)', '(1/4, 1/4, z+1/2)',
                         '(3/4, 3/4, z+1/2)', '(3/4, 1/4, z)')),
             '16k': (2, ('(1/4, y, 1/4)', '(1/4, y+1/2, 3/4)',
                         '(3/4, y, 3/4)', '(3/4, y+1/2, 1/4)',
                         '(3/4, -y, 1/4)', '(3/4, -y+1/2, 3/4)',
                         '(1/4, -y, 3/4)', '(1/4, -y+1/2, 1/4)',
                         '(3/4, -y, 3/4)', '(3/4, -y+1/2, 1/4)',
                         '(1/4, -y, 1/4)', '(1/4, -y+1/2, 3/4)',
                         '(1/4, y, 3/4)', '(1/4, y+1/2, 1/4)',
                         '(3/4, y, 1/4)', '(3/4, y+1/2, 3/4)')),
             '16l': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                         '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                         '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                         '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                         '(-x, 3/4, 3/4)', '(-x, 1/4, 1/4)',
                         '(-x+1/2, 3/4, 1/4)', '(-x+1/2, 1/4, 3/4)',
                         '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                         '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)')),
             '16m': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                         '(1/2, y+1/2, z)', '(0, -y, z)',
                         '(0, -y+1/2, z+1/2)', '(1/2, -y, z+1/2)',
                         '(1/2, -y+1/2, z)', '(0, y, -z)',
                         '(0, y+1/2, -z+1/2)', '(1/2, y, -z+1/2)',
                         '(1/2, y+1/2, -z)', '(0, -y, -z)',
                         '(0, -y+1/2, -z+1/2)', '(1/2, -y, -z+1/2)',
                         '(1/2, -y+1/2, -z)')),
             '16n': (5, ('(x, 0, z)', '(x, 1/2, z+1/2)', '(x+1/2, 0, z+1/2)',
                         '(x+1/2, 1/2, z)', '(-x, 0, z)', '(-x, 1/2, z+1/2)',
                         '(-x+1/2, 0, z+1/2)', '(-x+1/2, 1/2, z)',
                         '(-x, 0, -z)', '(-x, 1/2, -z+1/2)',
                         '(-x+1/2, 0, -z+1/2)', '(-x+1/2, 1/2, -z)',
                         '(x, 0, -z)', '(x, 1/2, -z+1/2)',
                         '(x+1/2, 0, -z+1/2)', '(x+1/2, 1/2, -z)')),
             '16o': (3, ('(x, y, 0)', '(x, y+1/2, 1/2)', '(x+1/2, y, 1/2)',
                         '(x+1/2, y+1/2, 0)', '(-x, -y, 0)',
                         '(-x, -y+1/2, 1/2)', '(-x+1/2, -y, 1/2)',
                         '(-x+1/2, -y+1/2, 0)', '(-x, y, 0)',
                         '(-x, y+1/2, 1/2)', '(-x+1/2, y, 1/2)',
                         '(-x+1/2, y+1/2, 0)', '(x, -y, 0)',
                         '(x, -y+1/2, 1/2)', '(x+1/2, -y, 1/2)',
                         '(x+1/2, -y+1/2, 0)')),
             '32p': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                         '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                         '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                         '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                         '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                         '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                         '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                         '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                         '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                         '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                         '(x, y, -z)', '(x, y+1/2, -z+1/2)',
                         '(x+1/2, y, -z+1/2)', '(x+1/2, y+1/2, -z)',
                         '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                         '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                         '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                         '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)'))},
      '70:1': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(1/2, 1/2, 0)', '(1/4, 1/4, 1/4)',
                          '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                          '(3/4, 3/4, 1/4)')),
               '8b': (0, ('(0, 0, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                          '(1/2, 1/2, 1/2)', '(1/4, 1/4, 3/4)',
                          '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)',
                          '(3/4, 3/4, 3/4)')),
               '16c': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                           '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                           '(7/8, 7/8, 1/8)', '(7/8, 3/8, 5/8)',
                           '(3/8, 7/8, 5/8)', '(3/8, 3/8, 1/8)',
                           '(7/8, 1/8, 7/8)', '(7/8, 5/8, 3/8)',
                           '(3/8, 1/8, 3/8)', '(3/8, 5/8, 7/8)',
                           '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)',
                           '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)')),
               '16d': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                           '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                           '(3/8, 3/8, 5/8)', '(3/8, 7/8, 1/8)',
                           '(7/8, 3/8, 1/8)', '(7/8, 7/8, 5/8)',
                           '(3/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                           '(7/8, 5/8, 7/8)', '(7/8, 1/8, 3/8)',
                           '(5/8, 3/8, 3/8)', '(5/8, 7/8, 7/8)',
                           '(1/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)')),
               '16e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                           '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                           '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)',
                           '(-x+1/4, 1/4, 1/4)', '(-x+1/4, 3/4, 3/4)',
                           '(-x+3/4, 1/4, 3/4)', '(-x+3/4, 3/4, 1/4)',
                           '(x+1/4, 1/4, 1/4)', '(x+1/4, 3/4, 3/4)',
                           '(x+3/4, 1/4, 3/4)', '(x+3/4, 3/4, 1/4)')),
               '16f': (2, ('(0, y, 0)', '(0, y+1/2, 1/2)', '(1/2, y, 1/2)',
                           '(1/2, y+1/2, 0)', '(0, -y, 0)',
                           '(0, -y+1/2, 1/2)', '(1/2, -y, 1/2)',
                           '(1/2, -y+1/2, 0)', '(1/4, -y+1/4, 1/4)',
                           '(1/4, -y+3/4, 3/4)', '(3/4, -y+1/4, 3/4)',
                           '(3/4, -y+3/4, 1/4)', '(1/4, y+1/4, 1/4)',
                           '(1/4, y+3/4, 3/4)', '(3/4, y+1/4, 3/4)',
                           '(3/4, y+3/4, 1/4)')),
               '16g': (4, ('(0, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                           '(1/2, 1/2, z)', '(0, 0, -z)', '(0, 1/2, -z+1/2)',
                           '(1/2, 0, -z+1/2)', '(1/2, 1/2, -z)',
                           '(1/4, 1/4, -z+1/4)', '(1/4, 3/4, -z+3/4)',
                           '(3/4, 1/4, -z+3/4)', '(3/4, 3/4, -z+1/4)',
                           '(1/4, 1/4, z+1/4)', '(1/4, 3/4, z+3/4)',
                           '(3/4, 1/4, z+3/4)', '(3/4, 3/4, z+1/4)')),
               '32h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                           '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                           '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                           '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                           '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                           '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                           '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                           '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                           '(-x+1/4, -y+1/4, -z+1/4)',
                           '(-x+1/4, -y+3/4, -z+3/4)',
                           '(-x+3/4, -y+1/4, -z+3/4)',
                           '(-x+3/4, -y+3/4, -z+1/4)',
                           '(x+1/4, y+1/4, -z+1/4)', '(x+1/4, y+3/4, -z+3/4)',
                           '(x+3/4, y+1/4, -z+3/4)', '(x+3/4, y+3/4, -z+1/4)',
                           '(x+1/4, -y+1/4, z+1/4)', '(x+1/4, -y+3/4, z+3/4)',
                           '(x+3/4, -y+1/4, z+3/4)', '(x+3/4, -y+3/4, z+1/4)',
                           '(-x+1/4, y+1/4, z+1/4)', '(-x+1/4, y+3/4, z+3/4)',
                           '(-x+3/4, y+1/4, z+3/4)', '(-x+3/4, y+3/4, z+1/4)'
                           ))},
      '70:2': {'8a': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                          '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                          '(7/8, 7/8, 7/8)', '(7/8, 3/8, 3/8)',
                          '(3/8, 7/8, 3/8)', '(3/8, 3/8, 7/8)')),
               '8b': (0, ('(1/8, 1/8, 5/8)', '(1/8, 5/8, 1/8)',
                          '(5/8, 1/8, 1/8)', '(5/8, 5/8, 5/8)',
                          '(7/8, 7/8, 3/8)', '(7/8, 3/8, 7/8)',
                          '(3/8, 7/8, 7/8)', '(3/8, 3/8, 3/8)')),
               '16c': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 1/2, 0)', '(3/4, 3/4, 0)',
                           '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)',
                           '(1/4, 1/4, 0)', '(3/4, 0, 3/4)',
                           '(3/4, 1/2, 1/4)', '(1/4, 0, 1/4)',
                           '(1/4, 1/2, 3/4)', '(0, 3/4, 3/4)',
                           '(0, 1/4, 1/4)', '(1/2, 3/4, 1/4)',
                           '(1/2, 1/4, 3/4)')),
               '16d': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                           '(0, 0, 1/2)', '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)',
                           '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                           '(1/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                           '(3/4, 1/2, 3/4)', '(3/4, 0, 1/4)',
                           '(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                           '(0, 1/4, 3/4)', '(0, 3/4, 1/4)')),
               '16e': (1, ('(x, 1/8, 1/8)', '(x, 5/8, 5/8)',
                           '(x+1/2, 1/8, 5/8)', '(x+1/2, 5/8, 1/8)',
                           '(-x+3/4, 5/8, 1/8)', '(-x+3/4, 1/8, 5/8)',
                           '(-x+1/4, 5/8, 5/8)', '(-x+1/4, 1/8, 1/8)',
                           '(-x, 7/8, 7/8)', '(-x, 3/8, 3/8)',
                           '(-x+1/2, 7/8, 3/8)', '(-x+1/2, 3/8, 7/8)',
                           '(x+1/4, 3/8, 7/8)', '(x+1/4, 7/8, 3/8)',
                           '(x+3/4, 3/8, 3/8)', '(x+3/4, 7/8, 7/8)')),
               '16f': (2, ('(1/8, y, 1/8)', '(1/8, y+1/2, 5/8)',
                           '(5/8, y, 5/8)', '(5/8, y+1/2, 1/8)',
                           '(5/8, -y+3/4, 1/8)', '(5/8, -y+1/4, 5/8)',
                           '(1/8, -y+3/4, 5/8)', '(1/8, -y+1/4, 1/8)',
                           '(7/8, -y, 7/8)', '(7/8, -y+1/2, 3/8)',
                           '(3/8, -y, 3/8)', '(3/8, -y+1/2, 7/8)',
                           '(3/8, y+1/4, 7/8)', '(3/8, y+3/4, 3/8)',
                           '(7/8, y+1/4, 3/8)', '(7/8, y+3/4, 7/8)')),
               '16g': (4, ('(1/8, 1/8, z)', '(1/8, 5/8, z+1/2)',
                           '(5/8, 1/8, z+1/2)', '(5/8, 5/8, z)',
                           '(5/8, 1/8, -z+3/4)', '(5/8, 5/8, -z+1/4)',
                           '(1/8, 1/8, -z+1/4)', '(1/8, 5/8, -z+3/4)',
                           '(7/8, 7/8, -z)', '(7/8, 3/8, -z+1/2)',
                           '(3/8, 7/8, -z+1/2)', '(3/8, 3/8, -z)',
                           '(3/8, 7/8, z+1/4)', '(3/8, 3/8, z+3/4)',
                           '(7/8, 7/8, z+3/4)', '(7/8, 3/8, z+1/4)')),
               '32h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                           '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                           '(-x+3/4, -y+3/4, z)', '(-x+3/4, -y+1/4, z+1/2)',
                           '(-x+1/4, -y+3/4, z+1/2)', '(-x+1/4, -y+1/4, z)',
                           '(-x+3/4, y, -z+3/4)', '(-x+3/4, y+1/2, -z+1/4)',
                           '(-x+1/4, y, -z+1/4)', '(-x+1/4, y+1/2, -z+3/4)',
                           '(x, -y+3/4, -z+3/4)', '(x, -y+1/4, -z+1/4)',
                           '(x+1/2, -y+3/4, -z+1/4)',
                           '(x+1/2, -y+1/4, -z+3/4)', '(-x, -y, -z)',
                           '(-x, -y+1/2, -z+1/2)', '(-x+1/2, -y, -z+1/2)',
                           '(-x+1/2, -y+1/2, -z)', '(x+1/4, y+1/4, -z)',
                           '(x+1/4, y+3/4, -z+1/2)', '(x+3/4, y+1/4, -z+1/2)',
                           '(x+3/4, y+3/4, -z)', '(x+1/4, -y, z+1/4)',
                           '(x+1/4, -y+1/2, z+3/4)', '(x+3/4, -y, z+3/4)',
                           '(x+3/4, -y+1/2, z+1/4)', '(-x, y+1/4, z+1/4)',
                           '(-x, y+3/4, z+3/4)', '(-x+1/2, y+1/4, z+3/4)',
                           '(-x+1/2, y+3/4, z+1/4)'))},
      '71': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
             '2b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)')),
             '2c': (0, ('(1/2, 1/2, 0)', '(0, 0, 1/2)')),
             '2d': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 0)')),
             '4e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 1/2)')),
             '4f': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                        '(-x+1/2, 0, 1/2)')),
             '4g': (2, ('(0, y, 0)', '(1/2, y+1/2, 1/2)', '(0, -y, 0)',
                        '(1/2, -y+1/2, 1/2)')),
             '4h': (2, ('(0, y, 1/2)', '(1/2, y+1/2, 0)', '(0, -y, 1/2)',
                        '(1/2, -y+1/2, 0)')),
             '4i': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)')),
             '4j': (4, ('(1/2, 0, z)', '(0, 1/2, z+1/2)', '(1/2, 0, -z)',
                        '(0, 1/2, -z+1/2)')),
             '8k': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                        '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                        '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)')),
             '8l': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                        '(1/2, -y+1/2, z+1/2)', '(0, y, -z)',
                        '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                        '(1/2, -y+1/2, -z+1/2)')),
             '8m': (5, ('(x, 0, z)', '(x+1/2, 1/2, z+1/2)', '(-x, 0, z)',
                        '(-x+1/2, 1/2, z+1/2)', '(-x, 0, -z)',
                        '(-x+1/2, 1/2, -z+1/2)', '(x, 0, -z)',
                        '(x+1/2, 1/2, -z+1/2)')),
             '8n': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 1/2)', '(-x, y, 0)',
                        '(-x+1/2, y+1/2, 1/2)', '(x, -y, 0)',
                        '(x+1/2, -y+1/2, 1/2)')),
             '16o': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                         '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z+1/2)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z+1/2)', '(x, -y, z)',
                         '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z+1/2)'))},
      '72': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)', '(0, 0, 3/4)',
                        '(1/2, 1/2, 1/4)')),
             '4b': (0, ('(1/2, 0, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 3/4)',
                        '(0, 1/2, 1/4)')),
             '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 1/2, 0)',
                        '(0, 0, 1/2)')),
             '4d': (0, ('(1/2, 0, 0)', '(0, 1/2, 1/2)', '(0, 1/2, 0)',
                        '(1/2, 0, 1/2)')),
             '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                        '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                        '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)')),
             '8f': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)', '(-x, 0, 1/4)',
                        '(-x+1/2, 1/2, 3/4)', '(-x, 0, 3/4)',
                        '(-x+1/2, 1/2, 1/4)', '(x, 0, 3/4)',
                        '(x+1/2, 1/2, 1/4)')),
             '8g': (2, ('(0, y, 1/4)', '(1/2, y+1/2, 3/4)', '(0, -y, 1/4)',
                        '(1/2, -y+1/2, 3/4)', '(0, -y, 3/4)',
                        '(1/2, -y+1/2, 1/4)', '(0, y, 3/4)',
                        '(1/2, y+1/2, 1/4)')),
             '8h': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 1/2, -z)',
                        '(0, 0, -z+1/2)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                        '(1/2, 1/2, z)', '(0, 0, z+1/2)')),
             '8i': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                        '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, -z+1/2)', '(1/2, 0, z)', '(0, 1/2, z+1/2)'
                        )),
             '8j': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 1/2)', '(-x+1/2, y+1/2, 0)',
                        '(-x, y, 1/2)', '(x+1/2, -y+1/2, 0)', '(x, -y, 1/2)'
                        )),
             '16k': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-x+1/2, y+1/2, -z)',
                         '(-x, y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                         '(x, -y, -z+1/2)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, z)',
                         '(x, -y, z+1/2)', '(-x+1/2, y+1/2, z)',
                         '(-x, y, z+1/2)'))},
      '73': {'8a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                        '(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 0)',
                        '(1/2, 1/2, 0)', '(0, 0, 1/2)')),
             '8b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                        '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                        '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)')),
             '8c': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                        '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(-x, 0, 3/4)',
                        '(-x+1/2, 1/2, 1/4)', '(x+1/2, 0, 1/4)',
                        '(x, 1/2, 3/4)')),
             '8d': (2, ('(1/4, y, 0)', '(3/4, y+1/2, 1/2)', '(1/4, -y, 1/2)',
                        '(3/4, -y+1/2, 0)', '(3/4, -y, 0)',
                        '(1/4, -y+1/2, 1/2)', '(3/4, y, 1/2)',
                        '(1/4, y+1/2, 0)')),
             '8e': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                        '(0, 3/4, -z+1/2)', '(1/2, 1/4, -z)', '(0, 3/4, -z)',
                        '(1/2, 1/4, -z+1/2)', '(0, 1/4, z+1/2)',
                        '(1/2, 3/4, z)')),
             '16f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                         '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                         '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                         '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                         '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                         '(x+1/2, y, -z+1/2)', '(x, y+1/2, -z)',
                         '(x, -y+1/2, z+1/2)', '(x+1/2, -y, z)',
                         '(-x+1/2, y+1/2, z)', '(-x, y, z+1/2)'))},
      '74': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 0)',
                        '(1/2, 0, 1/2)')),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                        '(1/2, 0, 0)')),
             '4c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)')),
             '4d': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                        '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)')),
             '4e': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)', '(0, 3/4, -z)',
                        '(1/2, 1/4, -z+1/2)')),
             '8f': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 1/2, 0)',
                        '(-x+1/2, 0, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 1/2)', '(x, 1/2, 0)',
                        '(x+1/2, 0, 1/2)')),
             '8g': (2, ('(1/4, y, 1/4)', '(3/4, y+1/2, 3/4)',
                        '(3/4, -y+1/2, 1/4)', '(1/4, -y, 3/4)',
                        '(3/4, -y, 3/4)', '(1/4, -y+1/2, 1/4)',
                        '(1/4, y+1/2, 3/4)', '(3/4, y, 1/4)')),
             '8h': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y+1/2, z)',
                        '(1/2, -y, z+1/2)', '(0, y+1/2, -z)',
                        '(1/2, y, -z+1/2)', '(0, -y, -z)',
                        '(1/2, -y+1/2, -z+1/2)')),
             '8i': (5, ('(x, 1/4, z)', '(x+1/2, 3/4, z+1/2)', '(-x, 1/4, z)',
                        '(-x+1/2, 3/4, z+1/2)', '(-x, 3/4, -z)',
                        '(-x+1/2, 1/4, -z+1/2)', '(x, 3/4, -z)',
                        '(x+1/2, 1/4, -z+1/2)')),
             '16j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                         '(-x, -y+1/2, z)', '(-x+1/2, -y, z+1/2)',
                         '(-x, y+1/2, -z)', '(-x+1/2, y, -z+1/2)',
                         '(x, -y, -z)', '(x+1/2, -y+1/2, -z+1/2)',
                         '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                         '(x, y+1/2, -z)', '(x+1/2, y, -z+1/2)',
                         '(x, -y+1/2, z)', '(x+1/2, -y, z+1/2)', '(-x, y, z)',
                         '(-x+1/2, y+1/2, z+1/2)'))},
      '75': {'1a': (4, ('(0, 0, z)', )),
             '1b': (4, ('(1/2, 1/2, z)', )),
             '2c': (4, ('(0, 1/2, z)', '(1/2, 0, z)')),
             '4d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                        '(y, -x, z)'))},
      '76': {'4a': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-y, x, z+1/4)',
                        '(y, -x, z+3/4)'))},
      '77': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
             '2b': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)')),
             '2c': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)')),
             '4d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                        '(y, -x, z+1/2)'))},
      '78': {'4a': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-y, x, z+3/4)',
                        '(y, -x, z+1/4)'))},
      '79': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)')),
             '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)')),
             '8c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                        '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                        '(y+1/2, -x+1/2, z+1/2)'))},
      '80': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                        '(1/2, 0, z+3/4)')),
             '8b': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                        '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)'))},
      '81': {'1a': (0, ('(0, 0, 0)', )),
             '1b': (0, ('(0, 0, 1/2)', )),
             '1c': (0, ('(1/2, 1/2, 0)', )),
             '1d': (0, ('(1/2, 1/2, 1/2)', )),
             '2e': (4, ('(0, 0, z)', '(0, 0, -z)')),
             '2f': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
             '2g': (4, ('(0, 1/2, z)', '(1/2, 0, -z)')),
             '4h': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                        '(-y, x, -z)'))},
      '82': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
             '2c': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)')),
             '2d': (0, ('(0, 1/2, 3/4)', '(1/2, 0, 1/4)')),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)')),
             '4f': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                        '(0, 1/2, -z+1/2)')),
             '8g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                        '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                        '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                        '(-y+1/2, x+1/2, -z+1/2)'))},
      '83': {'1a': (0, ('(0, 0, 0)', )),
             '1b': (0, ('(0, 0, 1/2)', )),
             '1c': (0, ('(1/2, 1/2, 0)', )),
             '1d': (0, ('(1/2, 1/2, 1/2)', )),
             '2e': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)')),
             '2f': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)')),
             '2g': (4, ('(0, 0, z)', '(0, 0, -z)')),
             '2h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
             '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                        '(1/2, 0, -z)')),
             '4j': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                        '(y, -x, 0)')),
             '4k': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)', '(-y, x, 1/2)',
                        '(y, -x, 1/2)')),
             '8l': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                        '(y, -x, z)', '(-x, -y, -z)', '(x, y, -z)',
                        '(y, -x, -z)', '(-y, x, -z)'))},
      '84': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
             '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
             '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)')),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)')),
             '2e': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
             '2f': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)')),
             '4g': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                        '(0, 0, -z+1/2)')),
             '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)',
                        '(1/2, 1/2, -z)', '(1/2, 1/2, -z+1/2)')),
             '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, -z+1/2)')),
             '4j': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 1/2)',
                        '(y, -x, 1/2)')),
             '8k': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                        '(y, -x, z+1/2)', '(-x, -y, -z)', '(x, y, -z)',
                        '(y, -x, -z+1/2)', '(-y, x, -z+1/2)'))},
      '85:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
               '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
               '2c': (4, ('(0, 1/2, z)', '(1/2, 0, -z)')),
               '4d': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(1/4, 3/4, 0)',
                          '(3/4, 1/4, 0)')),
               '4e': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)')),
               '4f': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                          '(0, 0, -z)')),
               '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z)',
                          '(y+1/2, -x+1/2, z)', '(-x+1/2, -y+1/2, -z)',
                          '(x+1/2, y+1/2, -z)', '(y, -x, -z)', '(-y, x, -z)'
                          ))},
      '85:2': {'2a': (0, ('(1/4, 3/4, 0)', '(3/4, 1/4, 0)')),
               '2b': (0, ('(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)')),
               '2c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z)')),
               '4d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                          '(0, 1/2, 0)')),
               '4e': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 1/2)')),
               '4f': (4, ('(1/4, 3/4, z)', '(3/4, 1/4, z)', '(3/4, 1/4, -z)',
                          '(1/4, 3/4, -z)')),
               '8g': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-y+1/2, x, z)', '(y, -x+1/2, z)', '(-x, -y, -z)',
                          '(x+1/2, y+1/2, -z)', '(y+1/2, -x, -z)',
                          '(-y, x+1/2, -z)'))},
      '86:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
               '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
               '4c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                          '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)')),
               '4d': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)',
                          '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)')),
               '4e': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)',
                          '(1/2, 0, -z+1/2)', '(1/2, 0, -z)')),
               '4f': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                          '(1/2, 1/2, -z+1/2)', '(0, 0, -z)')),
               '8g': (7, ('(x, y, z)', '(-x, -y, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y+1/2, -x+1/2, z+1/2)',
                          '(-x+1/2, -y+1/2, -z+1/2)',
                          '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                          '(-y, x, -z)'))},
      '86:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
               '2b': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)')),
               '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(0, 1/2, 1/2)',
                          '(1/2, 0, 1/2)')),
               '4d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(0, 1/2, 0)',
                          '(1/2, 0, 0)')),
               '4e': (4, ('(3/4, 1/4, z)', '(3/4, 1/4, z+1/2)',
                          '(1/4, 3/4, -z)', '(1/4, 3/4, -z+1/2)')),
               '4f': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, z+1/2)',
                          '(3/4, 3/4, -z)', '(1/4, 1/4, -z+1/2)')),
               '8g': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                          '(-y, x+1/2, z+1/2)', '(y+1/2, -x, z+1/2)',
                          '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                          '(y, -x+1/2, -z+1/2)', '(-y+1/2, x, -z+1/2)'))},
      '87': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
             '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                        '(0, 1/2, 1/2)')),
             '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)',
                        '(0, 1/2, 3/4)')),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)')),
             '8f': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                        '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                        '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                        '(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)')),
             '8g': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z+1/2)',
                        '(1/2, 0, -z)', '(0, 1/2, -z+1/2)')),
             '8h': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                        '(-x+1/2, -y+1/2, 1/2)', '(-y, x, 0)',
                        '(-y+1/2, x+1/2, 1/2)', '(y, -x, 0)',
                        '(y+1/2, -x+1/2, 1/2)')),
             '16i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                         '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                         '(y+1/2, -x+1/2, z+1/2)', '(-x, -y, -z)',
                         '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                         '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                         '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                         '(-y+1/2, x+1/2, -z+1/2)'))},
      '88:1': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/4)',
                          '(1/2, 0, 3/4)')),
               '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(0, 1/2, 3/4)',
                          '(1/2, 0, 1/4)')),
               '8c': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                          '(1/2, 1/4, 5/8)', '(0, 3/4, 1/8)',
                          '(3/4, 1/2, 3/8)', '(1/4, 0, 7/8)', '(3/4, 0, 7/8)',
                          '(1/4, 1/2, 3/8)')),
               '8d': (0, ('(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)',
                          '(1/2, 1/4, 1/8)', '(0, 3/4, 5/8)',
                          '(3/4, 1/2, 7/8)', '(1/4, 0, 3/8)', '(3/4, 0, 3/8)',
                          '(1/4, 1/2, 7/8)')),
               '8e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                          '(1/2, 0, z+3/4)', '(0, 1/2, -z+1/4)',
                          '(1/2, 0, -z+3/4)', '(0, 0, -z)',
                          '(1/2, 1/2, -z+1/2)')),
               '16f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                           '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                           '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                           '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                           '(-x, -y+1/2, -z+1/4)', '(-x+1/2, -y, -z+3/4)',
                           '(x+1/2, y, -z+3/4)', '(x, y+1/2, -z+1/4)',
                           '(y, -x, -z)', '(y+1/2, -x+1/2, -z+1/2)',
                           '(-y+1/2, x+1/2, -z+1/2)', '(-y, x, -z)'))},
      '88:2': {'4a': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                          '(1/2, 1/4, 3/8)', '(0, 3/4, 7/8)')),
               '4b': (0, ('(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)',
                          '(1/2, 1/4, 7/8)', '(0, 3/4, 3/8)')),
               '8c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 0)', '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                          '(3/4, 3/4, 3/4)', '(1/4, 1/4, 1/4)')),
               '8d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                          '(0, 1/2, 1/2)', '(3/4, 1/4, 3/4)',
                          '(1/4, 3/4, 1/4)', '(3/4, 3/4, 1/4)',
                          '(1/4, 1/4, 3/4)')),
               '8e': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                          '(1/2, 1/4, z+1/4)', '(0, 3/4, z+3/4)',
                          '(0, 3/4, -z)', '(1/2, 1/4, -z+1/2)',
                          '(1/2, 3/4, -z+3/4)', '(0, 1/4, -z+1/4)')),
               '16f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                           '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                           '(-y+3/4, x+1/4, z+1/4)', '(-y+1/4, x+3/4, z+3/4)',
                           '(y+3/4, -x+3/4, z+3/4)', '(y+1/4, -x+1/4, z+1/4)',
                           '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                           '(x+1/2, y, -z+1/2)', '(x, y+1/2, -z)',
                           '(y+1/4, -x+3/4, -z+3/4)',
                           '(y+3/4, -x+1/4, -z+1/4)',
                           '(-y+1/4, x+1/4, -z+1/4)',
                           '(-y+3/4, x+3/4, -z+3/4)'))},
      '89': {'1a': (0, ('(0, 0, 0)', )),
             '1b': (0, ('(0, 0, 1/2)', )),
             '1c': (0, ('(1/2, 1/2, 0)', )),
             '1d': (0, ('(1/2, 1/2, 1/2)', )),
             '2e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)')),
             '2f': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)')),
             '2g': (4, ('(0, 0, z)', '(0, 0, -z)')),
             '2h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
             '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                        '(1/2, 0, -z)')),
             '4j': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 0)',
                        '(x, -x, 0)')),
             '4k': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x, x, 1/2)',
                        '(x, -x, 1/2)')),
             '4l': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)'
                        )),
             '4m': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                        '(1/2, -x, 1/2)')),
             '4n': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 1/2)',
                        '(0, -x, 1/2)')),
             '4o': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, x, 0)',
                        '(1/2, -x, 0)')),
             '8p': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                        '(y, -x, z)', '(-x, y, -z)', '(x, -y, -z)',
                        '(y, x, -z)', '(-y, -x, -z)'))},
      '90': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
             '2c': (4, ('(0, 1/2, z)', '(1/2, 0, -z)')),
             '4d': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                        '(0, 0, -z)')),
             '4e': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 0)',
                        '(x+1/2, -x+1/2, 0)')),
             '4f': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)',
                        '(-x+1/2, x+1/2, 1/2)', '(x+1/2, -x+1/2, 1/2)')),
             '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z)',
                        '(y+1/2, -x+1/2, z)', '(-x+1/2, y+1/2, -z)',
                        '(x+1/2, -y+1/2, -z)', '(y, x, -z)', '(-y, -x, -z)'))},
      '91': {'4a': (2, ('(0, y, 0)', '(0, -y, 1/2)', '(-y, 0, 1/4)',
                        '(y, 0, 3/4)')),
             '4b': (2, ('(1/2, y, 0)', '(1/2, -y, 1/2)', '(-y, 1/2, 1/4)',
                        '(y, 1/2, 3/4)')),
             '4c': (1, ('(x, x, 3/8)', '(-x, -x, 7/8)', '(-x, x, 5/8)',
                        '(x, -x, 1/8)')),
             '8d': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-y, x, z+1/4)',
                        '(y, -x, z+3/4)', '(-x, y, -z)', '(x, -y, -z+1/2)',
                        '(y, x, -z+3/4)', '(-y, -x, -z+1/4)'))},
      '92': {'4a': (1, ('(x, x, 0)', '(-x, -x, 1/2)', '(-x+1/2, x+1/2, 1/4)',
                        '(x+1/2, -x+1/2, 3/4)')),
             '8b': (7, ('(x, y, z)', '(-x, -y, z+1/2)',
                        '(-y+1/2, x+1/2, z+1/4)', '(y+1/2, -x+1/2, z+3/4)',
                        '(-x+1/2, y+1/2, -z+1/4)', '(x+1/2, -y+1/2, -z+3/4)',
                        '(y, x, -z)', '(-y, -x, -z+1/2)'))},
      '93': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
             '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
             '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)')),
             '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)')),
             '2e': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
             '2f': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)')),
             '4g': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                        '(0, 0, -z+1/2)')),
             '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)',
                        '(1/2, 1/2, -z)', '(1/2, 1/2, -z+1/2)')),
             '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z)',
                        '(1/2, 0, -z+1/2)')),
             '4j': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 1/2)',
                        '(0, -x, 1/2)')),
             '4k': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 0)',
                        '(1/2, -x, 0)')),
             '4l': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 0)',
                        '(0, -x, 0)')),
             '4m': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, x, 1/2)',
                        '(1/2, -x, 1/2)')),
             '4n': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)', '(-x, x, 3/4)',
                        '(x, -x, 3/4)')),
             '4o': (1, ('(x, x, 3/4)', '(-x, -x, 3/4)', '(-x, x, 1/4)',
                        '(x, -x, 1/4)')),
             '8p': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                        '(y, -x, z+1/2)', '(-x, y, -z)', '(x, -y, -z)',
                        '(y, x, -z+1/2)', '(-y, -x, -z+1/2)'))},
      '94': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
             '4c': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                        '(1/2, 1/2, -z+1/2)', '(0, 0, -z)')),
             '4d': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(1/2, 0, -z+1/2)',
                        '(1/2, 0, -z)')),
             '4e': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 1/2)',
                        '(x+1/2, -x+1/2, 1/2)')),
             '4f': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x+1/2, x+1/2, 0)',
                        '(x+1/2, -x+1/2, 0)')),
             '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z+1/2)',
                        '(y+1/2, -x+1/2, z+1/2)', '(-x+1/2, y+1/2, -z+1/2)',
                        '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                        '(-y, -x, -z)'))},
      '95': {'4a': (2, ('(0, y, 0)', '(0, -y, 1/2)', '(-y, 0, 3/4)',
                        '(y, 0, 1/4)')),
             '4b': (2, ('(1/2, y, 0)', '(1/2, -y, 1/2)', '(-y, 1/2, 3/4)',
                        '(y, 1/2, 1/4)')),
             '4c': (1, ('(x, x, 5/8)', '(-x, -x, 1/8)', '(-x, x, 3/8)',
                        '(x, -x, 7/8)')),
             '8d': (7, ('(x, y, z)', '(-x, -y, z+1/2)', '(-y, x, z+3/4)',
                        '(y, -x, z+1/4)', '(-x, y, -z)', '(x, -y, -z+1/2)',
                        '(y, x, -z+1/4)', '(-y, -x, -z+3/4)'))},
      '96': {'4a': (1, ('(x, x, 0)', '(-x, -x, 1/2)', '(-x+1/2, x+1/2, 3/4)',
                        '(x+1/2, -x+1/2, 1/4)')),
             '8b': (7, ('(x, y, z)', '(-x, -y, z+1/2)',
                        '(-y+1/2, x+1/2, z+3/4)', '(y+1/2, -x+1/2, z+1/4)',
                        '(-x+1/2, y+1/2, -z+3/4)', '(x+1/2, -y+1/2, -z+1/4)',
                        '(y, x, -z)', '(-y, -x, -z+1/2)'))},
      '97': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
             '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
             '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                        '(0, 1/2, 1/2)')),
             '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)',
                        '(0, 1/2, 3/4)')),
             '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                        '(1/2, 1/2, -z+1/2)')),
             '8f': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                        '(0, 1/2, z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z+1/2)',
                        '(1/2, 0, -z)', '(0, 1/2, -z+1/2)')),
             '8g': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)', '(-x, -x, 0)',
                        '(-x+1/2, -x+1/2, 1/2)', '(-x, x, 0)',
                        '(-x+1/2, x+1/2, 1/2)', '(x, -x, 0)',
                        '(x+1/2, -x+1/2, 1/2)')),
             '8h': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                        '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                        '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                        '(1/2, -x+1/2, 1/2)')),
             '8i': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                        '(-x+1/2, 1/2, 0)', '(0, x, 1/2)', '(1/2, x+1/2, 0)',
                        '(0, -x, 1/2)', '(1/2, -x+1/2, 0)')),
             '8j': (1, ('(x, x+1/2, 1/4)', '(x+1/2, x, 3/4)',
                        '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                        '(-x+1/2, x, 1/4)', '(-x, x+1/2, 3/4)',
                        '(x+1/2, -x, 1/4)', '(x, -x+1/2, 3/4)')),
             '16k': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                         '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                         '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z)',
                         '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                         '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                         '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                         '(-y+1/2, -x+1/2, -z+1/2)'))},
      '98': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/4)',
                        '(1/2, 0, 3/4)')),
             '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(0, 1/2, 3/4)',
                        '(1/2, 0, 1/4)')),
             '8c': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                        '(1/2, 0, z+3/4)', '(1/2, 0, -z+3/4)',
                        '(0, 1/2, -z+1/4)', '(1/2, 1/2, -z+1/2)',
                        '(0, 0, -z)')),
             '8d': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)',
                        '(-x+1/2, -x+1/2, 1/2)', '(-x, -x, 0)',
                        '(-x, x+1/2, 1/4)', '(-x+1/2, x, 3/4)',
                        '(x+1/2, -x, 3/4)', '(x, -x+1/2, 1/4)')),
             '8e': (1, ('(-x, x, 0)', '(-x+1/2, x+1/2, 1/2)',
                        '(x+1/2, -x+1/2, 1/2)', '(x, -x, 0)',
                        '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                        '(x+1/2, x, 3/4)', '(x, x+1/2, 1/4)')),
             '8f': (1, ('(x, 1/4, 1/8)', '(x+1/2, 3/4, 5/8)',
                        '(-x+1/2, 1/4, 5/8)', '(-x, 3/4, 1/8)',
                        '(3/4, x+1/2, 3/8)', '(1/4, x, 7/8)',
                        '(3/4, -x, 7/8)', '(1/4, -x+1/2, 3/8)')),
             '16g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                         '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                         '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                         '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                         '(-x+1/2, y, -z+3/4)', '(-x, y+1/2, -z+1/4)',
                         '(x, -y+1/2, -z+1/4)', '(x+1/2, -y, -z+3/4)',
                         '(y+1/2, x+1/2, -z+1/2)', '(y, x, -z)',
                         '(-y, -x, -z)', '(-y+1/2, -x+1/2, -z+1/2)'))},
      '99': {'1a': (4, ('(0, 0, z)', )),
             '1b': (4, ('(1/2, 1/2, z)', )),
             '2c': (4, ('(1/2, 0, z)', '(0, 1/2, z)')),
             '4d': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, z)',
                        '(x, -x, z)')),
             '4e': (5, ('(x, 0, z)', '(-x, 0, z)', '(0, x, z)', '(0, -x, z)'
                        )),
             '4f': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(1/2, x, z)',
                        '(1/2, -x, z)')),
             '8g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                        '(y, -x, z)', '(x, -y, z)', '(-x, y, z)',
                        '(-y, -x, z)', '(y, x, z)'))},
      '100': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z)')),
              '2b': (4, ('(1/2, 0, z)', '(0, 1/2, z)')),
              '4c': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)', '(-x+1/2, x, z)',
                         '(x+1/2, -x, z)')),
              '8d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                         '(y, -x, z)', '(x+1/2, -y+1/2, z)',
                         '(-x+1/2, y+1/2, z)', '(-y+1/2, -x+1/2, z)',
                         '(y+1/2, x+1/2, z)'))},
      '101': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '2b': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)')),
              '4c': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, z+1/2)',
                         '(1/2, 0, z)')),
              '4d': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, z+1/2)',
                         '(x, -x, z+1/2)')),
              '8e': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                         '(y, -x, z+1/2)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                         '(-y, -x, z)', '(y, x, z)'))},
      '102': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)')),
              '4b': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                         '(1/2, 0, z)')),
              '4c': (5, ('(x, x, z)', '(-x, -x, z)', '(-x+1/2, x+1/2, z+1/2)',
                         '(x+1/2, -x+1/2, z+1/2)')),
              '8d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z+1/2)',
                         '(y+1/2, -x+1/2, z+1/2)', '(x+1/2, -y+1/2, z+1/2)',
                         '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)', '(y, x, z)'
                         ))},
      '103': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '2b': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)')),
              '4c': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, z+1/2)',
                         '(1/2, 0, z+1/2)')),
              '8d': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                         '(y, -x, z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                         '(-y, -x, z+1/2)', '(y, x, z+1/2)'))},
      '104': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)')),
              '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(1/2, 0, z+1/2)',
                         '(0, 1/2, z+1/2)')),
              '8c': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                         '(y, -x, z)', '(x+1/2, -y+1/2, z+1/2)',
                         '(-x+1/2, y+1/2, z+1/2)', '(-y+1/2, -x+1/2, z+1/2)',
                         '(y+1/2, x+1/2, z+1/2)'))},
      '105': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '2b': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)')),
              '2c': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)')),
              '4d': (5, ('(x, 0, z)', '(-x, 0, z)', '(0, x, z+1/2)',
                         '(0, -x, z+1/2)')),
              '4e': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(1/2, x, z+1/2)',
                         '(1/2, -x, z+1/2)')),
              '8f': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                         '(y, -x, z+1/2)', '(x, -y, z)', '(-x, y, z)',
                         '(-y, -x, z+1/2)', '(y, x, z+1/2)'))},
      '106': {'4a': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(1/2, 1/2, z)',
                         '(1/2, 1/2, z+1/2)')),
              '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                         '(0, 1/2, z+1/2)')),
              '8c': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                         '(y, -x, z+1/2)', '(x+1/2, -y+1/2, z)',
                         '(-x+1/2, y+1/2, z)', '(-y+1/2, -x+1/2, z+1/2)',
                         '(y+1/2, x+1/2, z+1/2)'))},
      '107': {'2a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)')),
              '4b': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                         '(0, 1/2, z+1/2)')),
              '8c': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                         '(-x+1/2, -x+1/2, z+1/2)', '(-x, x, z)',
                         '(-x+1/2, x+1/2, z+1/2)', '(x, -x, z)',
                         '(x+1/2, -x+1/2, z+1/2)')),
              '8d': (5, ('(x, 0, z)', '(x+1/2, 1/2, z+1/2)', '(-x, 0, z)',
                         '(-x+1/2, 1/2, z+1/2)', '(0, x, z)',
                         '(1/2, x+1/2, z+1/2)', '(0, -x, z)',
                         '(1/2, -x+1/2, z+1/2)')),
              '16e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)'))},
      '108': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, z+1/2)',
                         '(1/2, 1/2, z)')),
              '4b': (4, ('(1/2, 0, z)', '(0, 1/2, z+1/2)', '(0, 1/2, z)',
                         '(1/2, 0, z+1/2)')),
              '8c': (5, ('(x, x+1/2, z)', '(x+1/2, x, z+1/2)',
                         '(-x, -x+1/2, z)', '(-x+1/2, -x, z+1/2)',
                         '(-x+1/2, x, z)', '(-x, x+1/2, z+1/2)',
                         '(x+1/2, -x, z)', '(x, -x+1/2, z+1/2)')),
              '16d': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(x, -y, z+1/2)',
                          '(x+1/2, -y+1/2, z)', '(-x, y, z+1/2)',
                          '(-x+1/2, y+1/2, z)', '(-y, -x, z+1/2)',
                          '(-y+1/2, -x+1/2, z)', '(y, x, z+1/2)',
                          '(y+1/2, x+1/2, z)'))},
      '109': {'4a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                         '(1/2, 0, z+3/4)')),
              '8b': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)',
                         '(1/2, -y+1/2, z+1/2)', '(0, -y, z)',
                         '(-y, 1/2, z+1/4)', '(-y+1/2, 0, z+3/4)',
                         '(y+1/2, 0, z+3/4)', '(y, 1/2, z+1/4)')),
              '16c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                          '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                          '(x, -y, z)', '(x+1/2, -y+1/2, z+1/2)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-x, y, z)',
                          '(-y, -x+1/2, z+1/4)', '(-y+1/2, -x, z+3/4)',
                          '(y+1/2, x, z+3/4)', '(y, x+1/2, z+1/4)'))},
      '110': {'8a': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 1/2, z+1/4)',
                         '(1/2, 0, z+3/4)', '(0, 0, z+1/2)', '(1/2, 1/2, z)',
                         '(0, 1/2, z+3/4)', '(1/2, 0, z+1/4)')),
              '16b': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                          '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                          '(x, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                          '(-x+1/2, y+1/2, z)', '(-x, y, z+1/2)',
                          '(-y, -x+1/2, z+3/4)', '(-y+1/2, -x, z+1/4)',
                          '(y+1/2, x, z+1/4)', '(y, x+1/2, z+3/4)'))},
      '111': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(1/2, 1/2, 1/2)', )),
              '1c': (0, ('(0, 0, 1/2)', )),
              '1d': (0, ('(1/2, 1/2, 0)', )),
              '2e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)')),
              '2f': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)')),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
              '4i': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, -x, 0)', '(0, x, 0)'
                         )),
              '4j': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, -x, 1/2)',
                         '(1/2, x, 1/2)')),
              '4k': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, -x, 1/2)',
                         '(0, x, 1/2)')),
              '4l': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, -x, 0)',
                         '(1/2, x, 0)')),
              '4m': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(0, 1/2, -z)',
                         '(1/2, 0, z)')),
              '4n': (5, ('(x, x, z)', '(-x, -x, z)', '(x, -x, -z)',
                         '(-x, x, -z)')),
              '8o': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(-x, y, -z)', '(x, -y, -z)',
                         '(-y, -x, z)', '(y, x, z)'))},
      '112': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2b': (0, ('(1/2, 0, 1/4)', '(0, 1/2, 3/4)')),
              '2c': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)')),
              '2d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)')),
              '2e': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2f': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
              '4g': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(0, -x, 3/4)',
                         '(0, x, 3/4)')),
              '4h': (2, ('(1/2, y, 1/4)', '(1/2, -y, 1/4)', '(y, 1/2, 3/4)',
                         '(-y, 1/2, 3/4)')),
              '4i': (1, ('(x, 1/2, 1/4)', '(-x, 1/2, 1/4)', '(1/2, -x, 3/4)',
                         '(1/2, x, 3/4)')),
              '4j': (2, ('(0, y, 1/4)', '(0, -y, 1/4)', '(y, 0, 3/4)',
                         '(-y, 0, 3/4)')),
              '4k': (4, ('(0, 0, z)', '(0, 0, -z)', '(0, 0, -z+1/2)',
                         '(0, 0, z+1/2)')),
              '4l': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                         '(1/2, 1/2, -z+1/2)', '(1/2, 1/2, z+1/2)')),
              '4m': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, z+1/2)')),
              '8n': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(-x, y, -z+1/2)', '(x, -y, -z+1/2)',
                         '(-y, -x, z+1/2)', '(y, x, z+1/2)'))},
      '113': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
              '2c': (4, ('(0, 1/2, z)', '(1/2, 0, -z)')),
              '4d': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z)',
                         '(1/2, 1/2, z)')),
              '4e': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)',
                         '(x+1/2, -x, -z)', '(-x+1/2, x, -z)')),
              '8f': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(-x+1/2, y+1/2, -z)',
                         '(x+1/2, -y+1/2, -z)', '(-y+1/2, -x+1/2, z)',
                         '(y+1/2, x+1/2, z)'))},
      '114': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
              '4c': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                         '(1/2, 1/2, z+1/2)')),
              '4d': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(1/2, 0, -z+1/2)',
                         '(0, 1/2, z+1/2)')),
              '8e': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(-x+1/2, y+1/2, -z+1/2)',
                         '(x+1/2, -y+1/2, -z+1/2)', '(-y+1/2, -x+1/2, z+1/2)',
                         '(y+1/2, x+1/2, z+1/2)'))},
      '115': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(1/2, 1/2, 0)', )),
              '1c': (0, ('(1/2, 1/2, 1/2)', )),
              '1d': (0, ('(0, 0, 1/2)', )),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2f': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
              '2g': (4, ('(0, 1/2, z)', '(1/2, 0, -z)')),
              '4h': (1, ('(x, x, 0)', '(-x, -x, 0)', '(x, -x, 0)',
                         '(-x, x, 0)')),
              '4i': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(x, -x, 1/2)',
                         '(-x, x, 1/2)')),
              '4j': (5, ('(x, 0, z)', '(-x, 0, z)', '(0, -x, -z)',
                         '(0, x, -z)')),
              '4k': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(1/2, -x, -z)',
                         '(1/2, x, -z)')),
              '8l': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(x, -y, z)', '(-x, y, z)',
                         '(y, x, -z)', '(-y, -x, -z)'))},
      '116': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2b': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)')),
              '2c': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2d': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
              '4e': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)', '(x, -x, 3/4)',
                         '(-x, x, 3/4)')),
              '4f': (1, ('(x, x, 3/4)', '(-x, -x, 3/4)', '(x, -x, 1/4)',
                         '(-x, x, 1/4)')),
              '4g': (4, ('(0, 0, z)', '(0, 0, -z)', '(0, 0, z+1/2)',
                         '(0, 0, -z+1/2)')),
              '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                         '(1/2, 1/2, z+1/2)', '(1/2, 1/2, -z+1/2)')),
              '4i': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(0, 1/2, z+1/2)',
                         '(1/2, 0, -z+1/2)')),
              '8j': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                         '(y, x, -z+1/2)', '(-y, -x, -z+1/2)'))},
      '117': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
              '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)')),
              '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, z)',
                         '(1/2, 1/2, -z)')),
              '4f': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(1/2, 0, z)',
                         '(0, 1/2, -z)')),
              '4g': (1, ('(x, x+1/2, 0)', '(-x, -x+1/2, 0)', '(x+1/2, -x, 0)',
                         '(-x+1/2, x, 0)')),
              '4h': (1, ('(x, x+1/2, 1/2)', '(-x, -x+1/2, 1/2)',
                         '(x+1/2, -x, 1/2)', '(-x+1/2, x, 1/2)')),
              '8i': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(x+1/2, -y+1/2, z)',
                         '(-x+1/2, y+1/2, z)', '(y+1/2, x+1/2, -z)',
                         '(-y+1/2, -x+1/2, -z)'))},
      '118': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
              '2c': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)')),
              '2d': (0, ('(0, 1/2, 3/4)', '(1/2, 0, 1/4)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, z+1/2)',
                         '(1/2, 1/2, -z+1/2)')),
              '4f': (1, ('(x, -x+1/2, 1/4)', '(-x, x+1/2, 1/4)',
                         '(-x+1/2, -x, 3/4)', '(x+1/2, x, 3/4)')),
              '4g': (1, ('(x, x+1/2, 1/4)', '(-x, -x+1/2, 1/4)',
                         '(x+1/2, -x, 3/4)', '(-x+1/2, x, 3/4)')),
              '4h': (4, ('(0, 1/2, z)', '(1/2, 0, -z)', '(1/2, 0, z+1/2)',
                         '(0, 1/2, -z+1/2)')),
              '8i': (7, ('(x, y, z)', '(-x, -y, z)', '(y, -x, -z)',
                         '(-y, x, -z)', '(x+1/2, -y+1/2, z+1/2)',
                         '(-x+1/2, y+1/2, z+1/2)', '(y+1/2, x+1/2, -z+1/2)',
                         '(-y+1/2, -x+1/2, -z+1/2)'))},
      '119': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
              '2c': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)')),
              '2d': (0, ('(0, 1/2, 3/4)', '(1/2, 0, 1/4)')),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)')),
              '4f': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)')),
              '8g': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)', '(-x, -x, 0)',
                         '(-x+1/2, -x+1/2, 1/2)', '(x, -x, 0)',
                         '(x+1/2, -x+1/2, 1/2)', '(-x, x, 0)',
                         '(-x+1/2, x+1/2, 1/2)')),
              '8h': (1, ('(x, x+1/2, 1/4)', '(x+1/2, x, 3/4)',
                         '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                         '(x+1/2, -x, 3/4)', '(x, -x+1/2, 1/4)',
                         '(-x+1/2, x, 3/4)', '(-x, x+1/2, 1/4)')),
              '8i': (5, ('(x, 0, z)', '(x+1/2, 1/2, z+1/2)', '(-x, 0, z)',
                         '(-x+1/2, 1/2, z+1/2)', '(0, -x, -z)',
                         '(1/2, -x+1/2, -z+1/2)', '(0, x, -z)',
                         '(1/2, x+1/2, -z+1/2)')),
              '16j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(y, x, -z)',
                          '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                          '(-y+1/2, -x+1/2, -z+1/2)'))},
      '120': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)', '(0, 0, 3/4)',
                         '(1/2, 1/2, 1/4)')),
              '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 0, 1/2)',
                         '(1/2, 1/2, 0)')),
              '4c': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 1/4)')),
              '4d': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)')),
              '8e': (1, ('(x, x, 1/4)', '(x+1/2, x+1/2, 3/4)',
                         '(-x, -x, 1/4)', '(-x+1/2, -x+1/2, 3/4)',
                         '(x, -x, 3/4)', '(x+1/2, -x+1/2, 1/4)',
                         '(-x, x, 3/4)', '(-x+1/2, x+1/2, 1/4)')),
              '8f': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)', '(0, 0, z+1/2)',
                         '(1/2, 1/2, z)', '(0, 0, -z+1/2)', '(1/2, 1/2, -z)'
                         )),
              '8g': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)', '(0, 1/2, z+1/2)', '(1/2, 0, z)',
                         '(1/2, 0, -z+1/2)', '(0, 1/2, -z)')),
              '8h': (1, ('(x, x+1/2, 0)', '(x+1/2, x, 1/2)',
                         '(-x, -x+1/2, 0)', '(-x+1/2, -x, 1/2)',
                         '(x+1/2, -x, 0)', '(x, -x+1/2, 1/2)',
                         '(-x+1/2, x, 0)', '(-x, x+1/2, 1/2)')),
              '16i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, -y, z+1/2)',
                          '(x+1/2, -y+1/2, z)', '(-x, y, z+1/2)',
                          '(-x+1/2, y+1/2, z)', '(y, x, -z+1/2)',
                          '(y+1/2, x+1/2, -z)', '(-y, -x, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z)'))},
      '121': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
              '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)')),
              '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 1/4)')),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)')),
              '8f': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                         '(-x+1/2, 1/2, 1/2)', '(0, -x, 0)',
                         '(1/2, -x+1/2, 1/2)', '(0, x, 0)',
                         '(1/2, x+1/2, 1/2)')),
              '8g': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                         '(-x+1/2, 1/2, 0)', '(0, -x, 1/2)',
                         '(1/2, -x+1/2, 0)', '(0, x, 1/2)', '(1/2, x+1/2, 0)'
                         )),
              '8h': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                         '(1/2, 0, -z+1/2)', '(1/2, 0, z)', '(0, 1/2, z+1/2)'
                         )),
              '8i': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                         '(-x+1/2, -x+1/2, z+1/2)', '(x, -x, -z)',
                         '(x+1/2, -x+1/2, -z+1/2)', '(-x, x, -z)',
                         '(-x+1/2, x+1/2, -z+1/2)')),
              '16j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)'))},
      '122': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 3/4)',
                         '(0, 1/2, 1/4)')),
              '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(1/2, 0, 1/4)',
                         '(0, 1/2, 3/4)')),
              '8c': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)', '(1/2, 0, -z+3/4)',
                         '(0, 1/2, -z+1/4)', '(1/2, 0, z+3/4)',
                         '(0, 1/2, z+1/4)')),
              '8d': (1, ('(x, 1/4, 1/8)', '(x+1/2, 3/4, 5/8)',
                         '(-x, 3/4, 1/8)', '(-x+1/2, 1/4, 5/8)',
                         '(1/4, -x, 7/8)', '(3/4, -x+1/2, 3/8)',
                         '(3/4, x, 7/8)', '(1/4, x+1/2, 3/8)')),
              '16e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(-x+1/2, y, -z+3/4)',
                          '(-x, y+1/2, -z+1/4)', '(x+1/2, -y, -z+3/4)',
                          '(x, -y+1/2, -z+1/4)', '(-y+1/2, -x, z+3/4)',
                          '(-y, -x+1/2, z+1/4)', '(y+1/2, x, z+3/4)',
                          '(y, x+1/2, z+1/4)'))},
      '123': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '1c': (0, ('(1/2, 1/2, 0)', )),
              '1d': (0, ('(1/2, 1/2, 1/2)', )),
              '2e': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)')),
              '2f': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)')),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z)')),
              '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                         '(1/2, 0, -z)')),
              '4j': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 0)',
                         '(x, -x, 0)')),
              '4k': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x, x, 1/2)',
                         '(x, -x, 1/2)')),
              '4l': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)'
                         )),
              '4m': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 1/2)',
                         '(0, -x, 1/2)')),
              '4n': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, x, 0)',
                         '(1/2, -x, 0)')),
              '4o': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)')),
              '8p': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                         '(y, -x, 0)', '(-x, y, 0)', '(x, -y, 0)',
                         '(y, x, 0)', '(-y, -x, 0)')),
              '8q': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x, y, 1/2)', '(x, -y, 1/2)',
                         '(y, x, 1/2)', '(-y, -x, 1/2)')),
              '8r': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, z)',
                         '(x, -x, z)', '(-x, x, -z)', '(x, -x, -z)',
                         '(x, x, -z)', '(-x, -x, -z)')),
              '8s': (5, ('(x, 0, z)', '(-x, 0, z)', '(0, x, z)', '(0, -x, z)',
                         '(-x, 0, -z)', '(x, 0, -z)', '(0, x, -z)',
                         '(0, -x, -z)')),
              '8t': (5, ('(x, 1/2, z)', '(-x, 1/2, z)', '(1/2, x, z)',
                         '(1/2, -x, z)', '(-x, 1/2, -z)', '(x, 1/2, -z)',
                         '(1/2, x, -z)', '(1/2, -x, -z)')),
              '16u': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                          '(y, -x, z)', '(-x, y, -z)', '(x, -y, -z)',
                          '(y, x, -z)', '(-y, -x, -z)', '(-x, -y, -z)',
                          '(x, y, -z)', '(y, -x, -z)', '(-y, x, -z)',
                          '(x, -y, z)', '(-x, y, z)', '(-y, -x, z)',
                          '(y, x, z)'))},
      '124': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2c': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)')),
              '2d': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
              '4e': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                         '(1/2, 0, 1/2)')),
              '4f': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 3/4)')),
              '4g': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)')),
              '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, -z+1/2)',
                         '(1/2, 1/2, -z)', '(1/2, 1/2, z+1/2)')),
              '8i': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, -z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z)',
                         '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)')),
              '8j': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)', '(-x, x, 1/4)',
                         '(x, -x, 1/4)', '(-x, -x, 3/4)', '(x, x, 3/4)',
                         '(x, -x, 3/4)', '(-x, x, 3/4)')),
              '8k': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(0, x, 1/4)',
                         '(0, -x, 1/4)', '(-x, 0, 3/4)', '(x, 0, 3/4)',
                         '(0, -x, 3/4)', '(0, x, 3/4)')),
              '8l': (1, ('(x, 1/2, 1/4)', '(-x, 1/2, 1/4)', '(1/2, x, 1/4)',
                         '(1/2, -x, 1/4)', '(-x, 1/2, 3/4)', '(x, 1/2, 3/4)',
                         '(1/2, -x, 3/4)', '(1/2, x, 3/4)')),
              '8m': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                         '(y, -x, 0)', '(-x, y, 1/2)', '(x, -y, 1/2)',
                         '(y, x, 1/2)', '(-y, -x, 1/2)')),
              '16n': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                          '(y, -x, z)', '(-x, y, -z+1/2)', '(x, -y, -z+1/2)',
                          '(y, x, -z+1/2)', '(-y, -x, -z+1/2)',
                          '(-x, -y, -z)', '(x, y, -z)', '(y, -x, -z)',
                          '(-y, x, -z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                          '(-y, -x, z+1/2)', '(y, x, z+1/2)'))},
      '125:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
                '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)')),
                '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)')),
                '4e': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(3/4, 1/4, 0)',
                           '(1/4, 3/4, 0)')),
                '4f': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                           '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)')),
                '4g': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z)',
                           '(1/2, 1/2, z)')),
                '4h': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(0, 1/2, -z)',
                           '(1/2, 0, -z)')),
                '8i': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 0)',
                           '(x, -x, 0)', '(-x+1/2, -x+1/2, 0)',
                           '(x+1/2, x+1/2, 0)', '(x+1/2, -x+1/2, 0)',
                           '(-x+1/2, x+1/2, 0)')),
                '8j': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x, x, 1/2)',
                           '(x, -x, 1/2)', '(-x+1/2, -x+1/2, 1/2)',
                           '(x+1/2, x+1/2, 1/2)', '(x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, x+1/2, 1/2)')),
                '8k': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                           '(0, -x, 0)', '(-x+1/2, 1/2, 0)',
                           '(x+1/2, 1/2, 0)', '(1/2, -x+1/2, 0)',
                           '(1/2, x+1/2, 0)')),
                '8l': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 1/2)',
                           '(0, -x, 1/2)', '(-x+1/2, 1/2, 1/2)',
                           '(x+1/2, 1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                           '(1/2, x+1/2, 1/2)')),
                '8m': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)',
                           '(-x+1/2, x, z)', '(x+1/2, -x, z)',
                           '(-x, x+1/2, -z)', '(x, -x+1/2, -z)',
                           '(x+1/2, x, -z)', '(-x+1/2, -x, -z)')),
                '16n': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                            '(y, -x, z)', '(-x, y, -z)', '(x, -y, -z)',
                            '(y, x, -z)', '(-y, -x, -z)',
                            '(-x+1/2, -y+1/2, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x+1/2, -z)', '(-y+1/2, x+1/2, -z)',
                            '(x+1/2, -y+1/2, z)', '(-x+1/2, y+1/2, z)',
                            '(-y+1/2, -x+1/2, z)', '(y+1/2, x+1/2, z)'))},
      '125:2': {'2a': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)')),
                '2b': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)')),
                '2c': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 0)')),
                '2d': (0, ('(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)')),
                '4e': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)')),
                '4f': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)')),
                '4g': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, -z)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, z)')),
                '4h': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z)', '(3/4, 1/4, -z)',
                           '(1/4, 3/4, -z)')),
                '8i': (1, ('(x, x, 0)', '(-x+1/2, -x+1/2, 0)',
                           '(-x+1/2, x, 0)', '(x, -x+1/2, 0)', '(-x, -x, 0)',
                           '(x+1/2, x+1/2, 0)', '(x+1/2, -x, 0)',
                           '(-x, x+1/2, 0)')),
                '8j': (1, ('(x, x, 1/2)', '(-x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, x, 1/2)', '(x, -x+1/2, 1/2)',
                           '(-x, -x, 1/2)', '(x+1/2, x+1/2, 1/2)',
                           '(x+1/2, -x, 1/2)', '(-x, x+1/2, 1/2)')),
                '8k': (1, ('(x, 1/4, 0)', '(-x+1/2, 1/4, 0)', '(1/4, x, 0)',
                           '(1/4, -x+1/2, 0)', '(-x, 3/4, 0)',
                           '(x+1/2, 3/4, 0)', '(3/4, -x, 0)',
                           '(3/4, x+1/2, 0)')),
                '8l': (1, ('(x, 1/4, 1/2)', '(-x+1/2, 1/4, 1/2)',
                           '(1/4, x, 1/2)', '(1/4, -x+1/2, 1/2)',
                           '(-x, 3/4, 1/2)', '(x+1/2, 3/4, 1/2)',
                           '(3/4, -x, 1/2)', '(3/4, x+1/2, 1/2)')),
                '8m': (5, ('(x, -x, z)', '(-x+1/2, x+1/2, z)',
                           '(x+1/2, x, z)', '(-x, -x+1/2, z)',
                           '(-x+1/2, -x, -z)', '(x, x+1/2, -z)',
                           '(-x, x, -z)', '(x+1/2, -x+1/2, -z)')),
                '16n': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z)', '(y, -x+1/2, z)',
                            '(-x+1/2, y, -z)', '(x, -y+1/2, -z)',
                            '(y, x, -z)', '(-y+1/2, -x+1/2, -z)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z)', '(-y, x+1/2, -z)',
                            '(x+1/2, -y, z)', '(-x, y+1/2, z)', '(-y, -x, z)',
                            '(y+1/2, x+1/2, z)'))},
      '126:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
                '4c': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 1/2, 1/2)',
                           '(1/2, 0, 1/2)')),
                '4d': (0, ('(1/2, 0, 1/4)', '(0, 1/2, 1/4)', '(1/2, 0, 3/4)',
                           '(0, 1/2, 3/4)')),
                '4e': (4, ('(0, 0, z)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                           '(1/2, 1/2, z+1/2)')),
                '8f': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)',
                           '(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)')),
                '8g': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 0, -z)',
                           '(0, 1/2, -z)', '(0, 1/2, -z+1/2)',
                           '(1/2, 0, -z+1/2)', '(0, 1/2, z+1/2)',
                           '(1/2, 0, z+1/2)')),
                '8h': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 0)',
                           '(x, -x, 0)', '(-x+1/2, -x+1/2, 1/2)',
                           '(x+1/2, x+1/2, 1/2)', '(x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, x+1/2, 1/2)')),
                '8i': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                           '(0, -x, 0)', '(-x+1/2, 1/2, 1/2)',
                           '(x+1/2, 1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                           '(1/2, x+1/2, 1/2)')),
                '8j': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 1/2)',
                           '(0, -x, 1/2)', '(-x+1/2, 1/2, 0)',
                           '(x+1/2, 1/2, 0)', '(1/2, -x+1/2, 0)',
                           '(1/2, x+1/2, 0)')),
                '16k': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                            '(y, -x, z)', '(-x, y, -z)', '(x, -y, -z)',
                            '(y, x, -z)', '(-y, -x, -z)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)',
                            '(y+1/2, -x+1/2, -z+1/2)',
                            '(-y+1/2, x+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-y+1/2, -x+1/2, z+1/2)',
                            '(y+1/2, x+1/2, z+1/2)'))},
      '126:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
                '2b': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)')),
                '4c': (0, ('(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)')),
                '4d': (0, ('(1/4, 3/4, 0)', '(3/4, 1/4, 0)',
                           '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)')),
                '4e': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, -z+1/2)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, z+1/2)')),
                '8f': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                           '(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
                '8g': (4, ('(1/4, 3/4, z)', '(3/4, 1/4, z)',
                           '(1/4, 3/4, -z+1/2)', '(3/4, 1/4, -z+1/2)',
                           '(3/4, 1/4, -z)', '(1/4, 3/4, -z)',
                           '(3/4, 1/4, z+1/2)', '(1/4, 3/4, z+1/2)')),
                '8h': (1, ('(x, x, 1/4)', '(-x+1/2, -x+1/2, 1/4)',
                           '(-x+1/2, x, 1/4)', '(x, -x+1/2, 1/4)',
                           '(-x, -x, 3/4)', '(x+1/2, x+1/2, 3/4)',
                           '(x+1/2, -x, 3/4)', '(-x, x+1/2, 3/4)')),
                '8i': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                           '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                           '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)',
                           '(3/4, -x, 3/4)', '(3/4, x+1/2, 3/4)')),
                '8j': (1, ('(x, 3/4, 1/4)', '(-x+1/2, 3/4, 1/4)',
                           '(3/4, x, 1/4)', '(3/4, -x+1/2, 1/4)',
                           '(-x, 1/4, 3/4)', '(x+1/2, 1/4, 3/4)',
                           '(1/4, -x, 3/4)', '(1/4, x+1/2, 3/4)')),
                '16k': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z)', '(y, -x+1/2, z)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(y, x, -z+1/2)', '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z)', '(-y, x+1/2, -z)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-y, -x, z+1/2)', '(y+1/2, x+1/2, z+1/2)'))},
      '127': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
              '2c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)')),
              '2d': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)')),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, -z)', '(0, 0, -z)',
                         '(1/2, 1/2, z)')),
              '4f': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(1/2, 0, -z)',
                         '(0, 1/2, -z)')),
              '4g': (1, ('(x, x+1/2, 0)', '(-x, -x+1/2, 0)', '(-x+1/2, x, 0)',
                         '(x+1/2, -x, 0)')),
              '4h': (1, ('(x, x+1/2, 1/2)', '(-x, -x+1/2, 1/2)',
                         '(-x+1/2, x, 1/2)', '(x+1/2, -x, 1/2)')),
              '8i': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                         '(y, -x, 0)', '(-x+1/2, y+1/2, 0)',
                         '(x+1/2, -y+1/2, 0)', '(y+1/2, x+1/2, 0)',
                         '(-y+1/2, -x+1/2, 0)')),
              '8j': (3, ('(x, y, 1/2)', '(-x, -y, 1/2)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x+1/2, y+1/2, 1/2)',
                         '(x+1/2, -y+1/2, 1/2)', '(y+1/2, x+1/2, 1/2)',
                         '(-y+1/2, -x+1/2, 1/2)')),
              '8k': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)', '(-x+1/2, x, z)',
                         '(x+1/2, -x, z)', '(-x+1/2, x, -z)',
                         '(x+1/2, -x, -z)', '(x, x+1/2, -z)',
                         '(-x, -x+1/2, -z)')),
              '16l': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                          '(y, -x, z)', '(-x+1/2, y+1/2, -z)',
                          '(x+1/2, -y+1/2, -z)', '(y+1/2, x+1/2, -z)',
                          '(-y+1/2, -x+1/2, -z)', '(-x, -y, -z)',
                          '(x, y, -z)', '(y, -x, -z)', '(-y, x, -z)',
                          '(x+1/2, -y+1/2, z)', '(-x+1/2, y+1/2, z)',
                          '(-y+1/2, -x+1/2, z)', '(y+1/2, x+1/2, z)'))},
      '128': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
              '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 1/2)')),
              '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 3/4)')),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, -z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, z+1/2)')),
              '8f': (4, ('(0, 1/2, z)', '(1/2, 0, z)', '(1/2, 0, -z+1/2)',
                         '(0, 1/2, -z+1/2)', '(0, 1/2, -z)', '(1/2, 0, -z)',
                         '(1/2, 0, z+1/2)', '(0, 1/2, z+1/2)')),
              '8g': (1, ('(x, x+1/2, 1/4)', '(-x, -x+1/2, 1/4)',
                         '(-x+1/2, x, 1/4)', '(x+1/2, -x, 1/4)',
                         '(-x, -x+1/2, 3/4)', '(x, x+1/2, 3/4)',
                         '(x+1/2, -x, 3/4)', '(-x+1/2, x, 3/4)')),
              '8h': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 0)',
                         '(y, -x, 0)', '(-x+1/2, y+1/2, 1/2)',
                         '(x+1/2, -y+1/2, 1/2)', '(y+1/2, x+1/2, 1/2)',
                         '(-y+1/2, -x+1/2, 1/2)')),
              '16i': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z)',
                          '(y, -x, z)', '(-x+1/2, y+1/2, -z+1/2)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(y+1/2, x+1/2, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(x, y, -z)', '(y, -x, -z)', '(-y, x, -z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x+1/2, y+1/2, z+1/2)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y+1/2, x+1/2, z+1/2)'
                          ))},
      '129:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)')),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
                '2c': (4, ('(0, 1/2, z)', '(1/2, 0, -z)')),
                '4d': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(1/4, 3/4, 0)',
                           '(3/4, 1/4, 0)')),
                '4e': (0, ('(1/4, 1/4, 1/2)', '(3/4, 3/4, 1/2)',
                           '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)')),
                '4f': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(1/2, 1/2, -z)',
                           '(0, 0, -z)')),
                '8g': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 0)',
                           '(x+1/2, -x+1/2, 0)', '(-x+1/2, -x+1/2, 0)',
                           '(x+1/2, x+1/2, 0)', '(x, -x, 0)', '(-x, x, 0)')),
                '8h': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)',
                           '(-x+1/2, x+1/2, 1/2)', '(x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, -x+1/2, 1/2)', '(x+1/2, x+1/2, 1/2)',
                           '(x, -x, 1/2)', '(-x, x, 1/2)')),
                '8i': (6, ('(0, y, z)', '(0, -y, z)', '(-y+1/2, 1/2, z)',
                           '(y+1/2, 1/2, z)', '(1/2, y+1/2, -z)',
                           '(1/2, -y+1/2, -z)', '(y, 0, -z)', '(-y, 0, -z)')),
                '8j': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)',
                           '(-x, x+1/2, z)', '(x, -x+1/2, z)',
                           '(-x+1/2, x, -z)', '(x+1/2, -x, -z)',
                           '(x+1/2, x, -z)', '(-x+1/2, -x, -z)')),
                '16k': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z)',
                            '(y+1/2, -x+1/2, z)', '(-x+1/2, y+1/2, -z)',
                            '(x+1/2, -y+1/2, -z)', '(y, x, -z)',
                            '(-y, -x, -z)', '(-x+1/2, -y+1/2, -z)',
                            '(x+1/2, y+1/2, -z)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x, -y, z)', '(-x, y, z)',
                            '(-y+1/2, -x+1/2, z)', '(y+1/2, x+1/2, z)'))},
      '129:2': {'2a': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 0)')),
                '2b': (0, ('(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)')),
                '2c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z)')),
                '4d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)')),
                '4e': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)')),
                '4f': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z)', '(1/4, 3/4, -z)',
                           '(3/4, 1/4, -z)')),
                '8g': (1, ('(x, -x, 0)', '(-x+1/2, x+1/2, 0)',
                           '(x+1/2, x, 0)', '(-x, -x+1/2, 0)', '(-x, x, 0)',
                           '(x+1/2, -x+1/2, 0)', '(-x+1/2, -x, 0)',
                           '(x, x+1/2, 0)')),
                '8h': (1, ('(x, -x, 1/2)', '(-x+1/2, x+1/2, 1/2)',
                           '(x+1/2, x, 1/2)', '(-x, -x+1/2, 1/2)',
                           '(-x, x, 1/2)', '(x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, -x, 1/2)', '(x, x+1/2, 1/2)')),
                '8i': (6, ('(1/4, y, z)', '(1/4, -y+1/2, z)',
                           '(-y+1/2, 1/4, z)', '(y, 1/4, z)',
                           '(3/4, y+1/2, -z)', '(3/4, -y, -z)',
                           '(y+1/2, 3/4, -z)', '(-y, 3/4, -z)')),
                '8j': (5, ('(x, x, z)', '(-x+1/2, -x+1/2, z)',
                           '(-x+1/2, x, z)', '(x, -x+1/2, z)',
                           '(-x, x+1/2, -z)', '(x+1/2, -x, -z)',
                           '(x+1/2, x+1/2, -z)', '(-x, -x, -z)')),
                '16k': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z)', '(y, -x+1/2, z)',
                            '(-x, y+1/2, -z)', '(x+1/2, -y, -z)',
                            '(y+1/2, x+1/2, -z)', '(-y, -x, -z)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z)', '(-y, x+1/2, -z)',
                            '(x, -y+1/2, z)', '(-x+1/2, y, z)',
                            '(-y+1/2, -x+1/2, z)', '(y, x, z)'))},
      '130:1': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 1/4)',
                           '(1/2, 1/2, 3/4)', '(0, 0, 3/4)')),
                '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)',
                           '(0, 0, 1/2)')),
                '4c': (4, ('(0, 1/2, z)', '(1/2, 0, -z+1/2)', '(1/2, 0, -z)',
                           '(0, 1/2, z+1/2)')),
                '8d': (0, ('(1/4, 1/4, 0)', '(3/4, 3/4, 0)', '(1/4, 3/4, 0)',
                           '(3/4, 1/4, 0)', '(1/4, 3/4, 1/2)',
                           '(3/4, 1/4, 1/2)', '(1/4, 1/4, 1/2)',
                           '(3/4, 3/4, 1/2)')),
                '8e': (4, ('(0, 0, z)', '(1/2, 1/2, z)', '(1/2, 1/2, -z+1/2)',
                           '(0, 0, -z+1/2)', '(1/2, 1/2, -z)', '(0, 0, -z)',
                           '(0, 0, z+1/2)', '(1/2, 1/2, z+1/2)')),
                '8f': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)',
                           '(-x+1/2, x+1/2, 1/4)', '(x+1/2, -x+1/2, 1/4)',
                           '(-x+1/2, -x+1/2, 3/4)', '(x+1/2, x+1/2, 3/4)',
                           '(x, -x, 3/4)', '(-x, x, 3/4)')),
                '16g': (7, ('(x, y, z)', '(-x, -y, z)', '(-y+1/2, x+1/2, z)',
                            '(y+1/2, -x+1/2, z)', '(-x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z+1/2)',
                            '(-y, -x, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                            '(x+1/2, y+1/2, -z)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                            '(-y+1/2, -x+1/2, z+1/2)',
                            '(y+1/2, x+1/2, z+1/2)'))},
      '130:2': {'4a': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)')),
                '4b': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 0)',
                           '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)')),
                '4c': (4, ('(1/4, 1/4, z)', '(3/4, 3/4, -z+1/2)',
                           '(3/4, 3/4, -z)', '(1/4, 1/4, z+1/2)')),
                '8d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 1/2, 1/2)', '(0, 0, 1/2)')),
                '8e': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z)',
                           '(1/4, 3/4, -z+1/2)', '(3/4, 1/4, -z+1/2)',
                           '(1/4, 3/4, -z)', '(3/4, 1/4, -z)',
                           '(3/4, 1/4, z+1/2)', '(1/4, 3/4, z+1/2)')),
                '8f': (1, ('(x, -x, 1/4)', '(-x+1/2, x+1/2, 1/4)',
                           '(x+1/2, x, 1/4)', '(-x, -x+1/2, 1/4)',
                           '(-x, x, 3/4)', '(x+1/2, -x+1/2, 3/4)',
                           '(-x+1/2, -x, 3/4)', '(x, x+1/2, 3/4)')),
                '16g': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z)', '(y, -x+1/2, z)',
                            '(-x, y+1/2, -z+1/2)', '(x+1/2, -y, -z+1/2)',
                            '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z)', '(-y, x+1/2, -z)',
                            '(x, -y+1/2, z+1/2)', '(-x+1/2, y, z+1/2)',
                            '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z+1/2)'))},
      '131': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2b': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
              '2c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)')),
              '2d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)')),
              '2e': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2f': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)')),
              '4g': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                         '(0, 0, -z+1/2)')),
              '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)',
                         '(1/2, 1/2, -z)', '(1/2, 1/2, -z+1/2)')),
              '4i': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z)',
                         '(1/2, 0, -z+1/2)')),
              '4j': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 1/2)',
                         '(0, -x, 1/2)')),
              '4k': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 0)',
                         '(1/2, -x, 0)')),
              '4l': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(0, x, 0)',
                         '(0, -x, 0)')),
              '4m': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)')),
              '8n': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)', '(-x, x, 3/4)',
                         '(x, -x, 3/4)', '(-x, -x, 3/4)', '(x, x, 3/4)',
                         '(x, -x, 1/4)', '(-x, x, 1/4)')),
              '8o': (6, ('(0, y, z)', '(0, -y, z)', '(-y, 0, z+1/2)',
                         '(y, 0, z+1/2)', '(0, y, -z)', '(0, -y, -z)',
                         '(y, 0, -z+1/2)', '(-y, 0, -z+1/2)')),
              '8p': (6, ('(1/2, y, z)', '(1/2, -y, z)', '(-y, 1/2, z+1/2)',
                         '(y, 1/2, z+1/2)', '(1/2, y, -z)', '(1/2, -y, -z)',
                         '(y, 1/2, -z+1/2)', '(-y, 1/2, -z+1/2)')),
              '8q': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x, y, 0)', '(x, -y, 0)',
                         '(y, x, 1/2)', '(-y, -x, 1/2)')),
              '16r': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                          '(y, -x, z+1/2)', '(-x, y, -z)', '(x, -y, -z)',
                          '(y, x, -z+1/2)', '(-y, -x, -z+1/2)',
                          '(-x, -y, -z)', '(x, y, -z)', '(y, -x, -z+1/2)',
                          '(-y, x, -z+1/2)', '(x, -y, z)', '(-x, y, z)',
                          '(-y, -x, z+1/2)', '(y, x, z+1/2)'))},
      '132': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2c': (0, ('(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)')),
              '2d': (0, ('(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)')),
              '4e': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 1/4)')),
              '4f': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                         '(1/2, 0, 0)')),
              '4g': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z+1/2)',
                         '(0, 0, -z)')),
              '4h': (4, ('(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)',
                         '(1/2, 1/2, -z+1/2)', '(1/2, 1/2, -z)')),
              '4i': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x, x, 1/2)',
                         '(x, -x, 1/2)')),
              '4j': (1, ('(x, x, 1/2)', '(-x, -x, 1/2)', '(-x, x, 0)',
                         '(x, -x, 0)')),
              '8k': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, -z)', '(0, 1/2, -z)', '(1/2, 0, -z+1/2)',
                         '(0, 1/2, z+1/2)', '(1/2, 0, z)')),
              '8l': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(0, x, 3/4)',
                         '(0, -x, 3/4)', '(-x, 0, 3/4)', '(x, 0, 3/4)',
                         '(0, -x, 1/4)', '(0, x, 1/4)')),
              '8m': (1, ('(x, 1/2, 1/4)', '(-x, 1/2, 1/4)', '(1/2, x, 3/4)',
                         '(1/2, -x, 3/4)', '(-x, 1/2, 3/4)', '(x, 1/2, 3/4)',
                         '(1/2, -x, 1/4)', '(1/2, x, 1/4)')),
              '8n': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x, y, 1/2)', '(x, -y, 1/2)',
                         '(y, x, 0)', '(-y, -x, 0)')),
              '8o': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, z+1/2)',
                         '(x, -x, z+1/2)', '(-x, x, -z+1/2)',
                         '(x, -x, -z+1/2)', '(x, x, -z)', '(-x, -x, -z)')),
              '16p': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                          '(y, -x, z+1/2)', '(-x, y, -z+1/2)',
                          '(x, -y, -z+1/2)', '(y, x, -z)', '(-y, -x, -z)',
                          '(-x, -y, -z)', '(x, y, -z)', '(y, -x, -z+1/2)',
                          '(-y, x, -z+1/2)', '(x, -y, z+1/2)',
                          '(-x, y, z+1/2)', '(-y, -x, z)', '(y, x, z)'))},
      '133:1': {'4a': (0, ('(0, 1/2, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 1/4)',
                           '(1/2, 0, 3/4)')),
                '4b': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)',
                           '(1/2, 1/2, 1/4)', '(0, 0, 3/4)')),
                '4c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 0, 0)')),
                '4d': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 0, 1/2)',
                           '(1/2, 1/2, 0)')),
                '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)')),
                '8f': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)',
                           '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                           '(1/2, 0, -z+1/2)', '(1/2, 0, -z)', '(1/2, 0, z)',
                           '(1/2, 0, z+1/2)')),
                '8g': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z+1/2)',
                           '(1/2, 1/2, -z)', '(1/2, 1/2, -z+1/2)',
                           '(0, 0, -z)', '(1/2, 1/2, z)', '(0, 0, z+1/2)')),
                '8h': (1, ('(x, 0, 1/4)', '(-x, 0, 1/4)', '(1/2, x+1/2, 3/4)',
                           '(1/2, -x+1/2, 3/4)', '(-x+1/2, 1/2, 1/4)',
                           '(x+1/2, 1/2, 1/4)', '(0, -x, 3/4)', '(0, x, 3/4)'
                           )),
                '8i': (1, ('(x, 0, 3/4)', '(-x, 0, 3/4)', '(1/2, x+1/2, 1/4)',
                           '(1/2, -x+1/2, 1/4)', '(-x+1/2, 1/2, 3/4)',
                           '(x+1/2, 1/2, 3/4)', '(0, -x, 1/4)', '(0, x, 1/4)'
                           )),
                '8j': (1, ('(x, x+1/2, 0)', '(-x, -x+1/2, 0)',
                           '(-x, x+1/2, 1/2)', '(x, -x+1/2, 1/2)',
                           '(-x+1/2, -x, 1/2)', '(x+1/2, x, 1/2)',
                           '(x+1/2, -x, 0)', '(-x+1/2, x, 0)')),
                '16k': (7, ('(x, y, z)', '(-x, -y, z)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z+1/2)',
                            '(x, -y, -z+1/2)', '(y+1/2, x+1/2, -z)',
                            '(-y+1/2, -x+1/2, -z)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x+1/2, -y+1/2, z)',
                            '(-x+1/2, y+1/2, z)', '(-y, -x, z+1/2)',
                            '(y, x, z+1/2)'))},
      '133:2': {'4a': (0, ('(1/4, 1/4, 0)', '(1/4, 1/4, 1/2)',
                           '(3/4, 3/4, 0)', '(3/4, 3/4, 1/2)')),
                '4b': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 1/2)',
                           '(1/4, 3/4, 0)', '(3/4, 1/4, 1/2)')),
                '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 1/4, 3/4)',
                           '(3/4, 3/4, 3/4)', '(3/4, 3/4, 1/4)')),
                '4d': (0, ('(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)')),
                '8e': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                           '(0, 0, 1/2)', '(1/2, 1/2, 1/2)')),
                '8f': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, z+1/2)',
                           '(1/4, 1/4, -z)', '(1/4, 1/4, -z+1/2)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, -z+1/2)',
                           '(3/4, 3/4, z)', '(3/4, 3/4, z+1/2)')),
                '8g': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                           '(3/4, 1/4, -z)', '(1/4, 3/4, -z+1/2)',
                           '(1/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)',
                           '(1/4, 3/4, z)', '(3/4, 1/4, z+1/2)')),
                '8h': (1, ('(x, 1/4, 0)', '(-x+1/2, 1/4, 0)', '(1/4, x, 1/2)',
                           '(1/4, -x+1/2, 1/2)', '(-x, 3/4, 0)',
                           '(x+1/2, 3/4, 0)', '(3/4, -x, 1/2)',
                           '(3/4, x+1/2, 1/2)')),
                '8i': (1, ('(x, 1/4, 1/2)', '(-x+1/2, 1/4, 1/2)',
                           '(1/4, x, 0)', '(1/4, -x+1/2, 0)',
                           '(-x, 3/4, 1/2)', '(x+1/2, 3/4, 1/2)',
                           '(3/4, -x, 0)', '(3/4, x+1/2, 0)')),
                '8j': (1, ('(x, x, 1/4)', '(-x+1/2, -x+1/2, 1/4)',
                           '(-x+1/2, x, 3/4)', '(x, -x+1/2, 3/4)',
                           '(-x, -x, 3/4)', '(x+1/2, x+1/2, 3/4)',
                           '(x+1/2, -x, 1/4)', '(-x, x+1/2, 1/4)')),
                '16k': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z+1/2)', '(y, -x+1/2, z+1/2)',
                            '(-x+1/2, y, -z)', '(x, -y+1/2, -z)',
                            '(y, x, -z+1/2)', '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z+1/2)', '(-y, x+1/2, -z+1/2)',
                            '(x+1/2, -y, z)', '(-x, y+1/2, z)',
                            '(-y, -x, z+1/2)', '(y+1/2, x+1/2, z+1/2)'))},
      '134:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
                '4c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 0, 0)')),
                '4d': (0, ('(0, 1/2, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 1/4)',
                           '(1/2, 0, 3/4)')),
                '4e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)')),
                '4f': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)')),
                '4g': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                           '(1/2, 1/2, -z+1/2)')),
                '8h': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(0, 1/2, -z)',
                           '(0, 1/2, -z+1/2)', '(1/2, 0, -z+1/2)',
                           '(1/2, 0, -z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)')),
                '8i': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(1/2, x+1/2, 1/2)',
                           '(1/2, -x+1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                           '(x+1/2, 1/2, 1/2)', '(0, -x, 0)', '(0, x, 0)')),
                '8j': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x+1/2, 0)',
                           '(1/2, -x+1/2, 0)', '(-x+1/2, 1/2, 0)',
                           '(x+1/2, 1/2, 0)', '(0, -x, 1/2)', '(0, x, 1/2)')),
                '8k': (1, ('(x, x+1/2, 1/4)', '(-x, -x+1/2, 1/4)',
                           '(-x, x+1/2, 3/4)', '(x, -x+1/2, 3/4)',
                           '(-x+1/2, -x, 1/4)', '(x+1/2, x, 1/4)',
                           '(x+1/2, -x, 3/4)', '(-x+1/2, x, 3/4)')),
                '8l': (1, ('(x, x+1/2, 3/4)', '(-x, -x+1/2, 3/4)',
                           '(-x, x+1/2, 1/4)', '(x, -x+1/2, 1/4)',
                           '(-x+1/2, -x, 3/4)', '(x+1/2, x, 3/4)',
                           '(x+1/2, -x, 1/4)', '(-x+1/2, x, 1/4)')),
                '8m': (5, ('(x, x, z)', '(-x, -x, z)',
                           '(-x+1/2, x+1/2, z+1/2)', '(x+1/2, -x+1/2, z+1/2)',
                           '(-x, x, -z)', '(x, -x, -z)',
                           '(x+1/2, x+1/2, -z+1/2)',
                           '(-x+1/2, -x+1/2, -z+1/2)')),
                '16n': (7, ('(x, y, z)', '(-x, -y, z)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z)',
                            '(x, -y, -z)', '(y+1/2, x+1/2, -z+1/2)',
                            '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)',
                            '(y, x, z)'))},
      '134:2': {'2a': (0, ('(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)')),
                '2b': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)')),
                '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 1/4, 3/4)',
                           '(3/4, 3/4, 3/4)', '(3/4, 3/4, 1/4)')),
                '4d': (0, ('(1/4, 1/4, 0)', '(1/4, 1/4, 1/2)',
                           '(3/4, 3/4, 0)', '(3/4, 3/4, 1/2)')),
                '4e': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)')),
                '4f': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)')),
                '4g': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                           '(3/4, 1/4, -z+1/2)', '(1/4, 3/4, -z)')),
                '8h': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, z+1/2)',
                           '(1/4, 1/4, -z+1/2)', '(1/4, 1/4, -z)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, -z+1/2)',
                           '(3/4, 3/4, z+1/2)', '(3/4, 3/4, z)')),
                '8i': (1, ('(x, 1/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                           '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                           '(-x, 3/4, 1/4)', '(x+1/2, 3/4, 1/4)',
                           '(3/4, -x, 3/4)', '(3/4, x+1/2, 3/4)')),
                '8j': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                           '(1/4, x, 3/4)', '(1/4, -x+1/2, 3/4)',
                           '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)',
                           '(3/4, -x, 1/4)', '(3/4, x+1/2, 1/4)')),
                '8k': (1, ('(x, x, 0)', '(-x+1/2, -x+1/2, 0)',
                           '(-x+1/2, x, 1/2)', '(x, -x+1/2, 1/2)',
                           '(-x, -x, 0)', '(x+1/2, x+1/2, 0)',
                           '(x+1/2, -x, 1/2)', '(-x, x+1/2, 1/2)')),
                '8l': (1, ('(x, x, 1/2)', '(-x+1/2, -x+1/2, 1/2)',
                           '(-x+1/2, x, 0)', '(x, -x+1/2, 0)',
                           '(-x, -x, 1/2)', '(x+1/2, x+1/2, 1/2)',
                           '(x+1/2, -x, 0)', '(-x, x+1/2, 0)')),
                '8m': (5, ('(x, -x, z)', '(-x+1/2, x+1/2, z)',
                           '(x+1/2, x, z+1/2)', '(-x, -x+1/2, z+1/2)',
                           '(-x+1/2, -x, -z+1/2)', '(x, x+1/2, -z+1/2)',
                           '(-x, x, -z)', '(x+1/2, -x+1/2, -z)')),
                '16n': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z+1/2)', '(y, -x+1/2, z+1/2)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(y, x, -z)', '(-y+1/2, -x+1/2, -z)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z+1/2)', '(-y, x+1/2, -z+1/2)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-y, -x, z)', '(y+1/2, x+1/2, z)'))},
      '135': {'4a': (0, ('(0, 0, 0)', '(0, 0, 1/2)', '(1/2, 1/2, 0)',
                         '(1/2, 1/2, 1/2)')),
              '4b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)', '(1/2, 1/2, 3/4)',
                         '(1/2, 1/2, 1/4)')),
              '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)')),
              '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(0, 1/2, 3/4)',
                         '(1/2, 0, 1/4)')),
              '8e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(1/2, 1/2, -z)',
                         '(1/2, 1/2, -z+1/2)', '(0, 0, -z)', '(0, 0, -z+1/2)',
                         '(1/2, 1/2, z)', '(1/2, 1/2, z+1/2)')),
              '8f': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)', '(0, 1/2, -z)',
                         '(1/2, 0, -z+1/2)', '(1/2, 0, z)', '(0, 1/2, z+1/2)'
                         )),
              '8g': (1, ('(x, x+1/2, 1/4)', '(-x, -x+1/2, 1/4)',
                         '(-x+1/2, x, 3/4)', '(x+1/2, -x, 3/4)',
                         '(-x, -x+1/2, 3/4)', '(x, x+1/2, 3/4)',
                         '(x+1/2, -x, 1/4)', '(-x+1/2, x, 1/4)')),
              '8h': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y, x, 1/2)',
                         '(y, -x, 1/2)', '(-x+1/2, y+1/2, 0)',
                         '(x+1/2, -y+1/2, 0)', '(y+1/2, x+1/2, 1/2)',
                         '(-y+1/2, -x+1/2, 1/2)')),
              '16i': (7, ('(x, y, z)', '(-x, -y, z)', '(-y, x, z+1/2)',
                          '(y, -x, z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x+1/2, -y+1/2, -z)', '(y+1/2, x+1/2, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(x, y, -z)', '(y, -x, -z+1/2)', '(-y, x, -z+1/2)',
                          '(x+1/2, -y+1/2, z)', '(-x+1/2, y+1/2, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y+1/2, x+1/2, z+1/2)'
                          ))},
      '136': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
              '4c': (0, ('(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 0, 0)')),
              '4d': (0, ('(0, 1/2, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 1/4)',
                         '(1/2, 0, 3/4)')),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                         '(1/2, 1/2, -z+1/2)', '(0, 0, -z)')),
              '4f': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 1/2)',
                         '(x+1/2, -x+1/2, 1/2)')),
              '4g': (1, ('(x, -x, 0)', '(-x, x, 0)', '(x+1/2, x+1/2, 1/2)',
                         '(-x+1/2, -x+1/2, 1/2)')),
              '8h': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(1/2, 0, -z+1/2)',
                         '(1/2, 0, -z)', '(0, 1/2, -z)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, z+1/2)', '(1/2, 0, z)')),
              '8i': (3, ('(x, y, 0)', '(-x, -y, 0)', '(-y+1/2, x+1/2, 1/2)',
                         '(y+1/2, -x+1/2, 1/2)', '(-x+1/2, y+1/2, 1/2)',
                         '(x+1/2, -y+1/2, 1/2)', '(y, x, 0)', '(-y, -x, 0)')),
              '8j': (5, ('(x, x, z)', '(-x, -x, z)', '(-x+1/2, x+1/2, z+1/2)',
                         '(x+1/2, -x+1/2, z+1/2)', '(-x+1/2, x+1/2, -z+1/2)',
                         '(x+1/2, -x+1/2, -z+1/2)', '(x, x, -z)',
                         '(-x, -x, -z)')),
              '16k': (7, ('(x, y, z)', '(-x, -y, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y+1/2, -x+1/2, z+1/2)',
                          '(-x+1/2, y+1/2, -z+1/2)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                          '(-y, -x, -z)', '(-x, -y, -z)', '(x, y, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x+1/2, -y+1/2, z+1/2)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)',
                          '(y, x, z)'))},
      '137:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
                '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
                '4c': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                           '(1/2, 1/2, -z+1/2)', '(0, 0, -z)')),
                '4d': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)',
                           '(1/2, 0, -z+1/2)', '(1/2, 0, -z)')),
                '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)',
                           '(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)')),
                '8f': (1, ('(x, x, 0)', '(-x, -x, 0)', '(-x+1/2, x+1/2, 1/2)',
                           '(x+1/2, -x+1/2, 1/2)', '(-x+1/2, -x+1/2, 1/2)',
                           '(x+1/2, x+1/2, 1/2)', '(x, -x, 0)', '(-x, x, 0)'
                           )),
                '8g': (6, ('(0, y, z)', '(0, -y, z)', '(-y+1/2, 1/2, z+1/2)',
                           '(y+1/2, 1/2, z+1/2)', '(1/2, y+1/2, -z+1/2)',
                           '(1/2, -y+1/2, -z+1/2)', '(y, 0, -z)',
                           '(-y, 0, -z)')),
                '16h': (7, ('(x, y, z)', '(-x, -y, z)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                            '(-y, -x, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x, -y, z)', '(-x, y, z)',
                            '(-y+1/2, -x+1/2, z+1/2)',
                            '(y+1/2, x+1/2, z+1/2)'))},
      '137:2': {'2a': (0, ('(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)')),
                '2b': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)')),
                '4c': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                           '(1/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)')),
                '4d': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, z+1/2)',
                           '(3/4, 3/4, -z)', '(3/4, 3/4, -z+1/2)')),
                '8e': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                           '(1/2, 1/2, 1/2)', '(0, 0, 1/2)')),
                '8f': (1, ('(x, -x, 1/4)', '(-x+1/2, x+1/2, 1/4)',
                           '(x+1/2, x, 3/4)', '(-x, -x+1/2, 3/4)',
                           '(-x, x, 3/4)', '(x+1/2, -x+1/2, 3/4)',
                           '(-x+1/2, -x, 1/4)', '(x, x+1/2, 1/4)')),
                '8g': (6, ('(1/4, y, z)', '(1/4, -y+1/2, z)',
                           '(-y+1/2, 1/4, z+1/2)', '(y, 1/4, z+1/2)',
                           '(3/4, y+1/2, -z)', '(3/4, -y, -z)',
                           '(y+1/2, 3/4, -z+1/2)', '(-y, 3/4, -z+1/2)')),
                '16h': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z+1/2)', '(y, -x+1/2, z+1/2)',
                            '(-x, y+1/2, -z)', '(x+1/2, -y, -z)',
                            '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z+1/2)', '(-y, x+1/2, -z+1/2)',
                            '(x, -y+1/2, z)', '(-x+1/2, y, z)',
                            '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z+1/2)'))},
      '138:1': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)',
                           '(1/2, 1/2, 1/4)', '(0, 0, 3/4)')),
                '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 1/2, 0)',
                           '(0, 0, 1/2)')),
                '4c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)')),
                '4d': (0, ('(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)')),
                '4e': (4, ('(0, 1/2, z)', '(0, 1/2, z+1/2)', '(1/2, 0, -z)',
                           '(1/2, 0, -z+1/2)')),
                '8f': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(1/2, 1/2, -z)',
                           '(0, 0, -z+1/2)', '(1/2, 1/2, -z+1/2)',
                           '(0, 0, -z)', '(0, 0, z+1/2)', '(1/2, 1/2, z)')),
                '8g': (1, ('(x, x, 1/4)', '(-x, -x, 1/4)',
                           '(-x+1/2, x+1/2, 3/4)', '(x+1/2, -x+1/2, 3/4)',
                           '(-x+1/2, -x+1/2, 1/4)', '(x+1/2, x+1/2, 1/4)',
                           '(x, -x, 3/4)', '(-x, x, 3/4)')),
                '8h': (1, ('(x, x, 3/4)', '(-x, -x, 3/4)',
                           '(-x+1/2, x+1/2, 1/4)', '(x+1/2, -x+1/2, 1/4)',
                           '(-x+1/2, -x+1/2, 3/4)', '(x+1/2, x+1/2, 3/4)',
                           '(x, -x, 1/4)', '(-x, x, 1/4)')),
                '8i': (5, ('(x, x+1/2, z)', '(-x, -x+1/2, z)',
                           '(-x, x+1/2, z+1/2)', '(x, -x+1/2, z+1/2)',
                           '(-x+1/2, x, -z)', '(x+1/2, -x, -z)',
                           '(x+1/2, x, -z+1/2)', '(-x+1/2, -x, -z+1/2)')),
                '16j': (7, ('(x, y, z)', '(-x, -y, z)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)', '(-x+1/2, y+1/2, -z)',
                            '(x+1/2, -y+1/2, -z)', '(y, x, -z+1/2)',
                            '(-y, -x, -z+1/2)', '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                            '(-y, x, -z)', '(x, -y, z+1/2)', '(-x, y, z+1/2)',
                            '(-y+1/2, -x+1/2, z)', '(y+1/2, x+1/2, z)'))},
      '138:2': {'4a': (0, ('(3/4, 1/4, 0)', '(1/4, 3/4, 1/2)',
                           '(1/4, 3/4, 0)', '(3/4, 1/4, 1/2)')),
                '4b': (0, ('(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)')),
                '4c': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                           '(0, 1/2, 0)')),
                '4d': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)')),
                '4e': (4, ('(1/4, 1/4, z)', '(1/4, 1/4, z+1/2)',
                           '(3/4, 3/4, -z+1/2)', '(3/4, 3/4, -z)')),
                '8f': (4, ('(3/4, 1/4, z)', '(1/4, 3/4, z+1/2)',
                           '(1/4, 3/4, -z+1/2)', '(3/4, 1/4, -z)',
                           '(1/4, 3/4, -z)', '(3/4, 1/4, -z+1/2)',
                           '(3/4, 1/4, z+1/2)', '(1/4, 3/4, z)')),
                '8g': (1, ('(x, -x, 1/2)', '(-x+1/2, x+1/2, 1/2)',
                           '(x+1/2, x, 0)', '(-x, -x+1/2, 0)', '(-x, x, 1/2)',
                           '(x+1/2, -x+1/2, 1/2)', '(-x+1/2, -x, 0)',
                           '(x, x+1/2, 0)')),
                '8h': (1, ('(x, -x, 0)', '(-x+1/2, x+1/2, 0)',
                           '(x+1/2, x, 1/2)', '(-x, -x+1/2, 1/2)',
                           '(-x, x, 0)', '(x+1/2, -x+1/2, 0)',
                           '(-x+1/2, -x, 1/2)', '(x, x+1/2, 1/2)')),
                '8i': (5, ('(x, x, z)', '(-x+1/2, -x+1/2, z)',
                           '(-x+1/2, x, z+1/2)', '(x, -x+1/2, z+1/2)',
                           '(-x, x+1/2, -z+1/2)', '(x+1/2, -x, -z+1/2)',
                           '(x+1/2, x+1/2, -z)', '(-x, -x, -z)')),
                '16j': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-y+1/2, x, z+1/2)', '(y, -x+1/2, z+1/2)',
                            '(-x, y+1/2, -z+1/2)', '(x+1/2, -y, -z+1/2)',
                            '(y+1/2, x+1/2, -z)', '(-y, -x, -z)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(y+1/2, -x, -z+1/2)', '(-y, x+1/2, -z+1/2)',
                            '(x, -y+1/2, z+1/2)', '(-x+1/2, y, z+1/2)',
                            '(-y+1/2, -x+1/2, z)', '(y, x, z)'))},
      '139': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '2b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)')),
              '4c': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)')),
              '4d': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)',
                         '(0, 1/2, 3/4)')),
              '4e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z)',
                         '(1/2, 1/2, -z+1/2)')),
              '8f': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)')),
              '8g': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                         '(0, 1/2, z+1/2)', '(0, 1/2, -z)',
                         '(1/2, 0, -z+1/2)', '(1/2, 0, -z)',
                         '(0, 1/2, -z+1/2)')),
              '8h': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)', '(-x, -x, 0)',
                         '(-x+1/2, -x+1/2, 1/2)', '(-x, x, 0)',
                         '(-x+1/2, x+1/2, 1/2)', '(x, -x, 0)',
                         '(x+1/2, -x+1/2, 1/2)')),
              '8i': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                         '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                         '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                         '(1/2, -x+1/2, 1/2)')),
              '8j': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                         '(-x+1/2, 0, 1/2)', '(1/2, x, 0)', '(0, x+1/2, 1/2)',
                         '(1/2, -x, 0)', '(0, -x+1/2, 1/2)')),
              '16k': (1, ('(x, x+1/2, 1/4)', '(x+1/2, x, 3/4)',
                          '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                          '(-x+1/2, x, 1/4)', '(-x, x+1/2, 3/4)',
                          '(x+1/2, -x, 1/4)', '(x, -x+1/2, 3/4)',
                          '(-x, -x+1/2, 3/4)', '(-x+1/2, -x, 1/4)',
                          '(x, x+1/2, 3/4)', '(x+1/2, x, 1/4)',
                          '(x+1/2, -x, 3/4)', '(x, -x+1/2, 1/4)',
                          '(-x+1/2, x, 3/4)', '(-x, x+1/2, 1/4)')),
              '16l': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                          '(-x+1/2, -y+1/2, 1/2)', '(-y, x, 0)',
                          '(-y+1/2, x+1/2, 1/2)', '(y, -x, 0)',
                          '(y+1/2, -x+1/2, 1/2)', '(-x, y, 0)',
                          '(-x+1/2, y+1/2, 1/2)', '(x, -y, 0)',
                          '(x+1/2, -y+1/2, 1/2)', '(y, x, 0)',
                          '(y+1/2, x+1/2, 1/2)', '(-y, -x, 0)',
                          '(-y+1/2, -x+1/2, 1/2)')),
              '16m': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                          '(-x+1/2, -x+1/2, z+1/2)', '(-x, x, z)',
                          '(-x+1/2, x+1/2, z+1/2)', '(x, -x, z)',
                          '(x+1/2, -x+1/2, z+1/2)', '(-x, x, -z)',
                          '(-x+1/2, x+1/2, -z+1/2)', '(x, -x, -z)',
                          '(x+1/2, -x+1/2, -z+1/2)', '(x, x, -z)',
                          '(x+1/2, x+1/2, -z+1/2)', '(-x, -x, -z)',
                          '(-x+1/2, -x+1/2, -z+1/2)')),
              '16n': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                          '(1/2, -y+1/2, z+1/2)', '(-y, 0, z)',
                          '(-y+1/2, 1/2, z+1/2)', '(y, 0, z)',
                          '(y+1/2, 1/2, z+1/2)', '(0, y, -z)',
                          '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                          '(1/2, -y+1/2, -z+1/2)', '(y, 0, -z)',
                          '(y+1/2, 1/2, -z+1/2)', '(-y, 0, -z)',
                          '(-y+1/2, 1/2, -z+1/2)')),
              '32o': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(y, x, -z)',
                          '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)'))},
      '140': {'4a': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)', '(0, 0, 3/4)',
                         '(1/2, 1/2, 1/4)')),
              '4b': (0, ('(0, 1/2, 1/4)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)',
                         '(0, 1/2, 3/4)')),
              '4c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 0, 1/2)',
                         '(1/2, 1/2, 0)')),
              '4d': (0, ('(0, 1/2, 0)', '(1/2, 0, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 1/2)')),
              '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(1/4, 3/4, 1/4)', '(3/4, 1/4, 3/4)')),
              '8f': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)', '(0, 0, -z+1/2)',
                         '(1/2, 1/2, -z)', '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                         '(0, 0, z+1/2)', '(1/2, 1/2, z)')),
              '8g': (4, ('(0, 1/2, z)', '(1/2, 0, z+1/2)', '(1/2, 0, z)',
                         '(0, 1/2, z+1/2)', '(0, 1/2, -z+1/2)',
                         '(1/2, 0, -z)', '(1/2, 0, -z+1/2)', '(0, 1/2, -z)')),
              '8h': (1, ('(x, x+1/2, 0)', '(x+1/2, x, 1/2)',
                         '(-x, -x+1/2, 0)', '(-x+1/2, -x, 1/2)',
                         '(-x+1/2, x, 0)', '(-x, x+1/2, 1/2)',
                         '(x+1/2, -x, 0)', '(x, -x+1/2, 1/2)')),
              '16i': (1, ('(x, x, 1/4)', '(x+1/2, x+1/2, 3/4)',
                          '(-x, -x, 1/4)', '(-x+1/2, -x+1/2, 3/4)',
                          '(-x, x, 1/4)', '(-x+1/2, x+1/2, 3/4)',
                          '(x, -x, 1/4)', '(x+1/2, -x+1/2, 3/4)',
                          '(-x, -x, 3/4)', '(-x+1/2, -x+1/2, 1/4)',
                          '(x, x, 3/4)', '(x+1/2, x+1/2, 1/4)',
                          '(x, -x, 3/4)', '(x+1/2, -x+1/2, 1/4)',
                          '(-x, x, 3/4)', '(-x+1/2, x+1/2, 1/4)')),
              '16j': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)', '(-x, 0, 1/4)',
                          '(-x+1/2, 1/2, 3/4)', '(0, x, 1/4)',
                          '(1/2, x+1/2, 3/4)', '(0, -x, 1/4)',
                          '(1/2, -x+1/2, 3/4)', '(-x, 0, 3/4)',
                          '(-x+1/2, 1/2, 1/4)', '(x, 0, 3/4)',
                          '(x+1/2, 1/2, 1/4)', '(0, -x, 3/4)',
                          '(1/2, -x+1/2, 1/4)', '(0, x, 3/4)',
                          '(1/2, x+1/2, 1/4)')),
              '16k': (3, ('(x, y, 0)', '(x+1/2, y+1/2, 1/2)', '(-x, -y, 0)',
                          '(-x+1/2, -y+1/2, 1/2)', '(-y, x, 0)',
                          '(-y+1/2, x+1/2, 1/2)', '(y, -x, 0)',
                          '(y+1/2, -x+1/2, 1/2)', '(-x, y, 1/2)',
                          '(-x+1/2, y+1/2, 0)', '(x, -y, 1/2)',
                          '(x+1/2, -y+1/2, 0)', '(y, x, 1/2)',
                          '(y+1/2, x+1/2, 0)', '(-y, -x, 1/2)',
                          '(-y+1/2, -x+1/2, 0)')),
              '16l': (5, ('(x, x+1/2, z)', '(x+1/2, x, z+1/2)',
                          '(-x, -x+1/2, z)', '(-x+1/2, -x, z+1/2)',
                          '(-x+1/2, x, z)', '(-x, x+1/2, z+1/2)',
                          '(x+1/2, -x, z)', '(x, -x+1/2, z+1/2)',
                          '(-x, x+1/2, -z+1/2)', '(-x+1/2, x, -z)',
                          '(x, -x+1/2, -z+1/2)', '(x+1/2, -x, -z)',
                          '(x+1/2, x, -z+1/2)', '(x, x+1/2, -z)',
                          '(-x+1/2, -x, -z+1/2)', '(-x, -x+1/2, -z)')),
              '32m': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-x, y, -z+1/2)',
                          '(-x+1/2, y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(x+1/2, -y+1/2, -z)', '(y, x, -z+1/2)',
                          '(y+1/2, x+1/2, -z)', '(-y, -x, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, -y, z+1/2)',
                          '(x+1/2, -y+1/2, z)', '(-x, y, z+1/2)',
                          '(-x+1/2, y+1/2, z)', '(-y, -x, z+1/2)',
                          '(-y+1/2, -x+1/2, z)', '(y, x, z+1/2)',
                          '(y+1/2, x+1/2, z)'))},
      '141:1': {'4a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/4)',
                           '(1/2, 0, 3/4)')),
                '4b': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(0, 1/2, 3/4)',
                           '(1/2, 0, 1/4)')),
                '8c': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                           '(1/2, 1/4, 5/8)', '(0, 3/4, 1/8)',
                           '(3/4, 1/2, 3/8)', '(1/4, 0, 7/8)',
                           '(3/4, 0, 7/8)', '(1/4, 1/2, 3/8)')),
                '8d': (0, ('(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)',
                           '(1/2, 1/4, 1/8)', '(0, 3/4, 5/8)',
                           '(3/4, 1/2, 7/8)', '(1/4, 0, 3/8)',
                           '(3/4, 0, 3/8)', '(1/4, 1/2, 7/8)')),
                '8e': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                           '(0, 1/2, z+1/4)', '(1/2, 0, z+3/4)',
                           '(1/2, 0, -z+3/4)', '(0, 1/2, -z+1/4)',
                           '(1/2, 1/2, -z+1/2)', '(0, 0, -z)')),
                '16f': (1, ('(x, 1/4, 1/8)', '(x+1/2, 3/4, 5/8)',
                            '(-x+1/2, 1/4, 5/8)', '(-x, 3/4, 1/8)',
                            '(3/4, x+1/2, 3/8)', '(1/4, x, 7/8)',
                            '(3/4, -x, 7/8)', '(1/4, -x+1/2, 3/8)',
                            '(-x, 1/4, 1/8)', '(-x+1/2, 3/4, 5/8)',
                            '(x+1/2, 1/4, 5/8)', '(x, 3/4, 1/8)',
                            '(1/4, -x, 7/8)', '(3/4, -x+1/2, 3/8)',
                            '(1/4, x+1/2, 3/8)', '(3/4, x, 7/8)')),
                '16g': (1, ('(x, x, 0)', '(x+1/2, x+1/2, 1/2)',
                            '(-x+1/2, -x+1/2, 1/2)', '(-x, -x, 0)',
                            '(-x, x+1/2, 1/4)', '(-x+1/2, x, 3/4)',
                            '(x+1/2, -x, 3/4)', '(x, -x+1/2, 1/4)',
                            '(-x, -x+1/2, 1/4)', '(-x+1/2, -x, 3/4)',
                            '(x+1/2, x, 3/4)', '(x, x+1/2, 1/4)',
                            '(x, -x, 0)', '(x+1/2, -x+1/2, 1/2)',
                            '(-x+1/2, x+1/2, 1/2)', '(-x, x, 0)')),
                '16h': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)',
                            '(1/2, -y+1/2, z+1/2)', '(0, -y, z)',
                            '(-y, 1/2, z+1/4)', '(-y+1/2, 0, z+3/4)',
                            '(y+1/2, 0, z+3/4)', '(y, 1/2, z+1/4)',
                            '(1/2, y, -z+3/4)', '(0, y+1/2, -z+1/4)',
                            '(0, -y+1/2, -z+1/4)', '(1/2, -y, -z+3/4)',
                            '(y+1/2, 1/2, -z+1/2)', '(y, 0, -z)',
                            '(-y, 0, -z)', '(-y+1/2, 1/2, -z+1/2)')),
                '32i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                            '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                            '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                            '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                            '(-x+1/2, y, -z+3/4)', '(-x, y+1/2, -z+1/4)',
                            '(x, -y+1/2, -z+1/4)', '(x+1/2, -y, -z+3/4)',
                            '(y+1/2, x+1/2, -z+1/2)', '(y, x, -z)',
                            '(-y, -x, -z)', '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x, -y+1/2, -z+1/4)', '(-x+1/2, -y, -z+3/4)',
                            '(x+1/2, y, -z+3/4)', '(x, y+1/2, -z+1/4)',
                            '(y, -x, -z)', '(y+1/2, -x+1/2, -z+1/2)',
                            '(-y+1/2, x+1/2, -z+1/2)', '(-y, x, -z)',
                            '(x+1/2, -y+1/2, z+1/2)', '(x, -y, z)',
                            '(-x, y, z)', '(-x+1/2, y+1/2, z+1/2)',
                            '(-y+1/2, -x, z+3/4)', '(-y, -x+1/2, z+1/4)',
                            '(y, x+1/2, z+1/4)', '(y+1/2, x, z+3/4)'))},
      '141:2': {'4a': (0, ('(0, 3/4, 1/8)', '(1/2, 1/4, 5/8)',
                           '(1/2, 3/4, 3/8)', '(0, 1/4, 7/8)')),
                '4b': (0, ('(0, 1/4, 3/8)', '(1/2, 3/4, 7/8)',
                           '(0, 3/4, 5/8)', '(1/2, 1/4, 1/8)')),
                '8c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 0)', '(1/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)')),
                '8d': (0, ('(0, 0, 1/2)', '(1/2, 1/2, 0)', '(1/2, 0, 0)',
                           '(0, 1/2, 1/2)', '(1/4, 3/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 1/4, 1/4)',
                           '(3/4, 3/4, 3/4)')),
                '8e': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                           '(0, 3/4, z+1/4)', '(1/2, 1/4, z+3/4)',
                           '(1/2, 1/4, -z+1/2)', '(0, 3/4, -z)',
                           '(1/2, 3/4, -z+1/4)', '(0, 1/4, -z+3/4)')),
                '16f': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)',
                            '(-x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                            '(1/4, x+3/4, 1/4)', '(3/4, x+1/4, 3/4)',
                            '(1/4, -x+1/4, 3/4)', '(3/4, -x+3/4, 1/4)',
                            '(-x, 0, 0)', '(-x+1/2, 1/2, 1/2)',
                            '(x+1/2, 0, 1/2)', '(x, 1/2, 0)',
                            '(3/4, -x+1/4, 3/4)', '(1/4, -x+3/4, 1/4)',
                            '(3/4, x+3/4, 1/4)', '(1/4, x+1/4, 3/4)')),
                '16g': (1, ('(x, x+1/4, 7/8)', '(x+1/2, x+3/4, 3/8)',
                            '(-x+1/2, -x+3/4, 3/8)', '(-x, -x+1/4, 7/8)',
                            '(-x, x+3/4, 1/8)', '(-x+1/2, x+1/4, 5/8)',
                            '(x+1/2, -x+1/4, 5/8)', '(x, -x+3/4, 1/8)',
                            '(-x, -x+3/4, 1/8)', '(-x+1/2, -x+1/4, 5/8)',
                            '(x+1/2, x+1/4, 5/8)', '(x, x+3/4, 1/8)',
                            '(x, -x+1/4, 7/8)', '(x+1/2, -x+3/4, 3/8)',
                            '(-x+1/2, x+3/4, 3/8)', '(-x, x+1/4, 7/8)')),
                '16h': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)',
                            '(1/2, -y, z+1/2)', '(0, -y+1/2, z)',
                            '(-y+1/4, 3/4, z+1/4)', '(-y+3/4, 1/4, z+3/4)',
                            '(y+1/4, 1/4, z+3/4)', '(y+3/4, 3/4, z+1/4)',
                            '(1/2, y, -z+1/2)', '(0, y+1/2, -z)',
                            '(0, -y, -z)', '(1/2, -y+1/2, -z+1/2)',
                            '(y+1/4, 3/4, -z+1/4)', '(y+3/4, 1/4, -z+3/4)',
                            '(-y+1/4, 1/4, -z+3/4)', '(-y+3/4, 3/4, -z+1/4)'
                            )),
                '32i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                            '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                            '(-y+1/4, x+3/4, z+1/4)',
                            '(-y+3/4, x+1/4, z+3/4)',
                            '(y+1/4, -x+1/4, z+3/4)',
                            '(y+3/4, -x+3/4, z+1/4)', '(-x+1/2, y, -z+1/2)',
                            '(-x, y+1/2, -z)', '(x, -y, -z)',
                            '(x+1/2, -y+1/2, -z+1/2)',
                            '(y+1/4, x+3/4, -z+1/4)',
                            '(y+3/4, x+1/4, -z+3/4)',
                            '(-y+1/4, -x+1/4, -z+3/4)',
                            '(-y+3/4, -x+3/4, -z+1/4)', '(-x, -y, -z)',
                            '(-x+1/2, -y+1/2, -z+1/2)', '(x+1/2, y, -z+1/2)',
                            '(x, y+1/2, -z)', '(y+3/4, -x+1/4, -z+3/4)',
                            '(y+1/4, -x+3/4, -z+1/4)',
                            '(-y+3/4, x+3/4, -z+1/4)',
                            '(-y+1/4, x+1/4, -z+3/4)', '(x+1/2, -y, z+1/2)',
                            '(x, -y+1/2, z)', '(-x, y, z)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-y+3/4, -x+1/4, z+3/4)',
                            '(-y+1/4, -x+3/4, z+1/4)',
                            '(y+3/4, x+3/4, z+1/4)', '(y+1/4, x+1/4, z+3/4)'
                            ))},
      '142:1': {'8a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(0, 1/2, 1/4)',
                           '(1/2, 0, 3/4)', '(1/2, 0, 1/4)', '(0, 1/2, 3/4)',
                           '(1/2, 1/2, 0)', '(0, 0, 1/2)')),
                '8b': (0, ('(0, 0, 1/4)', '(1/2, 1/2, 3/4)', '(0, 1/2, 1/2)',
                           '(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 0, 3/4)', '(1/2, 1/2, 1/4)')),
                '16c': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                            '(1/2, 1/4, 5/8)', '(0, 3/4, 1/8)',
                            '(3/4, 1/2, 3/8)', '(1/4, 0, 7/8)',
                            '(3/4, 0, 7/8)', '(1/4, 1/2, 3/8)',
                            '(1/2, 1/4, 1/8)', '(0, 3/4, 5/8)',
                            '(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)',
                            '(3/4, 1/2, 7/8)', '(1/4, 0, 3/8)',
                            '(3/4, 0, 3/8)', '(1/4, 1/2, 7/8)')),
                '16d': (4, ('(0, 0, z)', '(1/2, 1/2, z+1/2)',
                            '(0, 1/2, z+1/4)', '(1/2, 0, z+3/4)',
                            '(1/2, 0, -z+1/4)', '(0, 1/2, -z+3/4)',
                            '(1/2, 1/2, -z)', '(0, 0, -z+1/2)',
                            '(0, 1/2, -z+1/4)', '(1/2, 0, -z+3/4)',
                            '(0, 0, -z)', '(1/2, 1/2, -z+1/2)',
                            '(1/2, 1/2, z)', '(0, 0, z+1/2)',
                            '(1/2, 0, z+1/4)', '(0, 1/2, z+3/4)')),
                '16e': (2, ('(1/4, y, 1/8)', '(3/4, y+1/2, 5/8)',
                            '(1/4, -y+1/2, 5/8)', '(3/4, -y, 1/8)',
                            '(-y, 3/4, 3/8)', '(-y+1/2, 1/4, 7/8)',
                            '(y+1/2, 3/4, 7/8)', '(y, 1/4, 3/8)',
                            '(3/4, -y+1/2, 1/8)', '(1/4, -y, 5/8)',
                            '(3/4, y, 5/8)', '(1/4, y+1/2, 1/8)',
                            '(y, 3/4, 7/8)', '(y+1/2, 1/4, 3/8)',
                            '(-y+1/2, 3/4, 3/8)', '(-y, 1/4, 7/8)')),
                '16f': (1, ('(x, x, 1/4)', '(x+1/2, x+1/2, 3/4)',
                            '(-x+1/2, -x+1/2, 3/4)', '(-x, -x, 1/4)',
                            '(-x, x+1/2, 1/2)', '(-x+1/2, x, 0)',
                            '(x+1/2, -x, 0)', '(x, -x+1/2, 1/2)',
                            '(-x, -x+1/2, 0)', '(-x+1/2, -x, 1/2)',
                            '(x+1/2, x, 1/2)', '(x, x+1/2, 0)',
                            '(x, -x, 3/4)', '(x+1/2, -x+1/2, 1/4)',
                            '(-x+1/2, x+1/2, 1/4)', '(-x, x, 3/4)')),
                '32g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                            '(-x+1/2, -y+1/2, z+1/2)', '(-x, -y, z)',
                            '(-y, x+1/2, z+1/4)', '(-y+1/2, x, z+3/4)',
                            '(y+1/2, -x, z+3/4)', '(y, -x+1/2, z+1/4)',
                            '(-x+1/2, y, -z+1/4)', '(-x, y+1/2, -z+3/4)',
                            '(x, -y+1/2, -z+3/4)', '(x+1/2, -y, -z+1/4)',
                            '(y+1/2, x+1/2, -z)', '(y, x, -z+1/2)',
                            '(-y, -x, -z+1/2)', '(-y+1/2, -x+1/2, -z)',
                            '(-x, -y+1/2, -z+1/4)', '(-x+1/2, -y, -z+3/4)',
                            '(x+1/2, y, -z+3/4)', '(x, y+1/2, -z+1/4)',
                            '(y, -x, -z)', '(y+1/2, -x+1/2, -z+1/2)',
                            '(-y+1/2, x+1/2, -z+1/2)', '(-y, x, -z)',
                            '(x+1/2, -y+1/2, z)', '(x, -y, z+1/2)',
                            '(-x, y, z+1/2)', '(-x+1/2, y+1/2, z)',
                            '(-y+1/2, -x, z+1/4)', '(-y, -x+1/2, z+3/4)',
                            '(y, x+1/2, z+3/4)', '(y+1/2, x, z+1/4)'))},
      '142:2': {'8a': (0, ('(0, 1/4, 3/8)', '(1/2, 3/4, 7/8)',
                           '(0, 3/4, 5/8)', '(1/2, 1/4, 1/8)',
                           '(1/2, 1/4, 5/8)', '(0, 3/4, 1/8)',
                           '(1/2, 3/4, 3/8)', '(0, 1/4, 7/8)')),
                '8b': (0, ('(0, 1/4, 1/8)', '(1/2, 3/4, 5/8)',
                           '(0, 3/4, 3/8)', '(1/2, 1/4, 7/8)',
                           '(0, 3/4, 7/8)', '(1/2, 1/4, 3/8)',
                           '(0, 1/4, 5/8)', '(1/2, 3/4, 1/8)')),
                '16c': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(0, 1/2, 0)', '(1/4, 3/4, 1/4)',
                            '(3/4, 1/4, 3/4)', '(1/4, 1/4, 3/4)',
                            '(3/4, 3/4, 1/4)', '(1/2, 0, 0)', '(0, 1/2, 1/2)',
                            '(0, 0, 1/2)', '(1/2, 1/2, 0)', '(1/4, 3/4, 3/4)',
                            '(3/4, 1/4, 1/4)', '(1/4, 1/4, 1/4)',
                            '(3/4, 3/4, 3/4)')),
                '16d': (4, ('(0, 1/4, z)', '(1/2, 3/4, z+1/2)',
                            '(0, 3/4, z+1/4)', '(1/2, 1/4, z+3/4)',
                            '(1/2, 1/4, -z)', '(0, 3/4, -z+1/2)',
                            '(1/2, 3/4, -z+3/4)', '(0, 1/4, -z+1/4)',
                            '(0, 3/4, -z)', '(1/2, 1/4, -z+1/2)',
                            '(0, 1/4, -z+3/4)', '(1/2, 3/4, -z+1/4)',
                            '(1/2, 3/4, z)', '(0, 1/4, z+1/2)',
                            '(1/2, 1/4, z+1/4)', '(0, 3/4, z+3/4)')),
                '16e': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                            '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)',
                            '(1/4, x+3/4, 1/2)', '(3/4, x+1/4, 0)',
                            '(1/4, -x+1/4, 0)', '(3/4, -x+3/4, 1/2)',
                            '(-x, 0, 3/4)', '(-x+1/2, 1/2, 1/4)',
                            '(x+1/2, 0, 1/4)', '(x, 1/2, 3/4)',
                            '(3/4, -x+1/4, 1/2)', '(1/4, -x+3/4, 0)',
                            '(3/4, x+3/4, 0)', '(1/4, x+1/4, 1/2)')),
                '16f': (1, ('(x, x+1/4, 1/8)', '(x+1/2, x+3/4, 5/8)',
                            '(-x+1/2, -x+3/4, 5/8)', '(-x, -x+1/4, 1/8)',
                            '(-x, x+3/4, 3/8)', '(-x+1/2, x+1/4, 7/8)',
                            '(x+1/2, -x+1/4, 7/8)', '(x, -x+3/4, 3/8)',
                            '(-x, -x+3/4, 7/8)', '(-x+1/2, -x+1/4, 3/8)',
                            '(x+1/2, x+1/4, 3/8)', '(x, x+3/4, 7/8)',
                            '(x, -x+1/4, 5/8)', '(x+1/2, -x+3/4, 1/8)',
                            '(-x+1/2, x+3/4, 1/8)', '(-x, x+1/4, 5/8)')),
                '32g': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                            '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                            '(-y+1/4, x+3/4, z+1/4)',
                            '(-y+3/4, x+1/4, z+3/4)',
                            '(y+1/4, -x+1/4, z+3/4)',
                            '(y+3/4, -x+3/4, z+1/4)', '(-x+1/2, y, -z)',
                            '(-x, y+1/2, -z+1/2)', '(x, -y, -z+1/2)',
                            '(x+1/2, -y+1/2, -z)', '(y+1/4, x+3/4, -z+3/4)',
                            '(y+3/4, x+1/4, -z+1/4)',
                            '(-y+1/4, -x+1/4, -z+1/4)',
                            '(-y+3/4, -x+3/4, -z+3/4)', '(-x, -y, -z)',
                            '(-x+1/2, -y+1/2, -z+1/2)', '(x+1/2, y, -z+1/2)',
                            '(x, y+1/2, -z)', '(y+3/4, -x+1/4, -z+3/4)',
                            '(y+1/4, -x+3/4, -z+1/4)',
                            '(-y+3/4, x+3/4, -z+1/4)',
                            '(-y+1/4, x+1/4, -z+3/4)', '(x+1/2, -y, z)',
                            '(x, -y+1/2, z+1/2)', '(-x, y, z+1/2)',
                            '(-x+1/2, y+1/2, z)', '(-y+3/4, -x+1/4, z+1/4)',
                            '(-y+1/4, -x+3/4, z+3/4)',
                            '(y+3/4, x+3/4, z+3/4)', '(y+1/4, x+1/4, z+1/4)'
                            ))},
      '143': {'1a': (4, ('(0, 0, z)', )),
              '1b': (4, ('(1/3, 2/3, z)', )),
              '1c': (4, ('(2/3, 1/3, z)', )),
              '3d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)'))},
      '144': {'3a': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)'
                         ))},
      '145': {'3a': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)'
                         ))},
      '146:H': {'3a': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)')),
                '9b': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                           '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                           '(-y+2/3, x-y+1/3, z+1/3)',
                           '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                           '(-x+y+2/3, -x+1/3, z+1/3)',
                           '(-x+y+1/3, -x+2/3, z+2/3)'))},
      '146:R': {'1a': (1, ('(x, x, x)', )),
                '3b': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)'))},
      '147': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '2c': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2d': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, -z)')),
              '3e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)')),
              '3f': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '6g': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)'))},
      '148:H': {'3a': (0, ('(0, 0, 0)', '(2/3, 1/3, 1/3)', '(1/3, 2/3, 2/3)'
                           )),
                '3b': (0, ('(0, 0, 1/2)', '(2/3, 1/3, 5/6)',
                           '(1/3, 2/3, 1/6)')),
                '6c': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)', '(0, 0, -z)',
                           '(2/3, 1/3, -z+1/3)', '(1/3, 2/3, -z+2/3)')),
                '9d': (0, ('(1/2, 0, 1/2)', '(1/6, 1/3, 5/6)',
                           '(5/6, 2/3, 1/6)', '(0, 1/2, 1/2)',
                           '(2/3, 5/6, 5/6)', '(1/3, 1/6, 1/6)',
                           '(1/2, 1/2, 1/2)', '(1/6, 5/6, 5/6)',
                           '(5/6, 1/6, 1/6)')),
                '9e': (0, ('(1/2, 0, 0)', '(1/6, 1/3, 1/3)',
                           '(5/6, 2/3, 2/3)', '(0, 1/2, 0)',
                           '(2/3, 5/6, 1/3)', '(1/3, 1/6, 2/3)',
                           '(1/2, 1/2, 0)', '(1/6, 5/6, 1/3)',
                           '(5/6, 1/6, 2/3)')),
                '18f': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(-x, -y, -z)',
                            '(-x+2/3, -y+1/3, -z+1/3)',
                            '(-x+1/3, -y+2/3, -z+2/3)', '(y, -x+y, -z)',
                            '(y+2/3, -x+y+1/3, -z+1/3)',
                            '(y+1/3, -x+y+2/3, -z+2/3)', '(x-y, x, -z)',
                            '(x-y+2/3, x+1/3, -z+1/3)',
                            '(x-y+1/3, x+2/3, -z+2/3)'))},
      '148:R': {'1a': (0, ('(0, 0, 0)', )),
                '1b': (0, ('(1/2, 1/2, 1/2)', )),
                '2c': (1, ('(x, x, x)', '(-x, -x, -x)')),
                '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
                '3e': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'
                           )),
                '6f': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                           '(-x, -y, -z)', '(-z, -x, -y)', '(-y, -z, -x)'))},
      '149': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '1c': (0, ('(1/3, 2/3, 0)', )),
              '1d': (0, ('(1/3, 2/3, 1/2)', )),
              '1e': (0, ('(2/3, 1/3, 0)', )),
              '1f': (0, ('(2/3, 1/3, 1/2)', )),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)')),
              '2i': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, -z)')),
              '3j': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)')),
              '3k': (1, ('(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)')),
              '6l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)'))},
      '150': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '2c': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2d': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, -z)')),
              '3e': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)')),
              '3f': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)')),
              '6g': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)'))},
      '151': {'3a': (1, ('(x, -x, 1/3)', '(x, 2*x, 2/3)', '(-2*x, -x, 0)')),
              '3b': (1, ('(x, -x, 5/6)', '(x, 2*x, 1/6)', '(-2*x, -x, 1/2)')),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)',
                         '(-y, -x, -z+2/3)', '(-x+y, y, -z+1/3)',
                         '(x, x-y, -z)'))},
      '152': {'3a': (1, ('(x, 0, 1/3)', '(0, x, 2/3)', '(-x, -x, 0)')),
              '3b': (1, ('(x, 0, 5/6)', '(0, x, 1/6)', '(-x, -x, 1/2)')),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)',
                         '(y, x, -z)', '(x-y, -y, -z+2/3)',
                         '(-x, -x+y, -z+1/3)'))},
      '153': {'3a': (1, ('(x, -x, 2/3)', '(x, 2*x, 1/3)', '(-2*x, -x, 0)')),
              '3b': (1, ('(x, -x, 1/6)', '(x, 2*x, 5/6)', '(-2*x, -x, 1/2)')),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)',
                         '(-y, -x, -z+1/3)', '(-x+y, y, -z+2/3)',
                         '(x, x-y, -z)'))},
      '154': {'3a': (1, ('(x, 0, 2/3)', '(0, x, 1/3)', '(-x, -x, 0)')),
              '3b': (1, ('(x, 0, 1/6)', '(0, x, 5/6)', '(-x, -x, 1/2)')),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)',
                         '(y, x, -z)', '(x-y, -y, -z+1/3)',
                         '(-x, -x+y, -z+2/3)'))},
      '155:H': {'3a': (0, ('(0, 0, 0)', '(2/3, 1/3, 1/3)', '(1/3, 2/3, 2/3)'
                           )),
                '3b': (0, ('(0, 0, 1/2)', '(2/3, 1/3, 5/6)',
                           '(1/3, 2/3, 1/6)')),
                '6c': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)', '(0, 0, -z)',
                           '(2/3, 1/3, -z+1/3)', '(1/3, 2/3, -z+2/3)')),
                '9d': (1, ('(x, 0, 0)', '(x+2/3, 1/3, 1/3)',
                           '(x+1/3, 2/3, 2/3)', '(0, x, 0)',
                           '(2/3, x+1/3, 1/3)', '(1/3, x+2/3, 2/3)',
                           '(-x, -x, 0)', '(-x+2/3, -x+1/3, 1/3)',
                           '(-x+1/3, -x+2/3, 2/3)')),
                '9e': (1, ('(x, 0, 1/2)', '(x+2/3, 1/3, 5/6)',
                           '(x+1/3, 2/3, 1/6)', '(0, x, 1/2)',
                           '(2/3, x+1/3, 5/6)', '(1/3, x+2/3, 1/6)',
                           '(-x, -x, 1/2)', '(-x+2/3, -x+1/3, 5/6)',
                           '(-x+1/3, -x+2/3, 1/6)')),
                '18f': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(y, x, -z)',
                            '(y+2/3, x+1/3, -z+1/3)',
                            '(y+1/3, x+2/3, -z+2/3)', '(x-y, -y, -z)',
                            '(x-y+2/3, -y+1/3, -z+1/3)',
                            '(x-y+1/3, -y+2/3, -z+2/3)', '(-x, -x+y, -z)',
                            '(-x+2/3, -x+y+1/3, -z+1/3)',
                            '(-x+1/3, -x+y+2/3, -z+2/3)'))},
      '155:R': {'1a': (0, ('(0, 0, 0)', )),
                '1b': (0, ('(1/2, 1/2, 1/2)', )),
                '2c': (1, ('(x, x, x)', '(-x, -x, -x)')),
                '3d': (2, ('(0, y, -y)', '(-y, 0, y)', '(y, -y, 0)')),
                '3e': (2, ('(1/2, y, -y)', '(-y, 1/2, y)', '(y, -y, 1/2)')),
                '6f': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                           '(-z, -y, -x)', '(-y, -x, -z)', '(-x, -z, -y)'))},
      '156': {'1a': (4, ('(0, 0, z)', )),
              '1b': (4, ('(1/3, 2/3, z)', )),
              '1c': (4, ('(2/3, 1/3, z)', )),
              '3d': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)')),
              '6e': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)'))},
      '157': {'1a': (4, ('(0, 0, z)', )),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)')),
              '3c': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)')),
              '6d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'))},
      '158': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '2b': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, z+1/2)')),
              '2c': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, z+1/2)')),
              '6d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-y, -x, z+1/2)', '(-x+y, y, z+1/2)',
                         '(x, x-y, z+1/2)'))},
      '159': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)')),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(y, x, z+1/2)', '(x-y, -y, z+1/2)',
                         '(-x, -x+y, z+1/2)'))},
      '160:H': {'3a': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)')),
                '9b': (5, ('(x, -x, z)', '(x+2/3, -x+1/3, z+1/3)',
                           '(x+1/3, -x+2/3, z+2/3)', '(x, 2*x, z)',
                           '(x+2/3, 2*x+1/3, z+1/3)',
                           '(x+1/3, 2*x+2/3, z+2/3)', '(-2*x, -x, z)',
                           '(-2*x+2/3, -x+1/3, z+1/3)',
                           '(-2*x+1/3, -x+2/3, z+2/3)')),
                '18c': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(-y, -x, z)',
                            '(-y+2/3, -x+1/3, z+1/3)',
                            '(-y+1/3, -x+2/3, z+2/3)', '(-x+y, y, z)',
                            '(-x+y+2/3, y+1/3, z+1/3)',
                            '(-x+y+1/3, y+2/3, z+2/3)', '(x, x-y, z)',
                            '(x+2/3, x-y+1/3, z+1/3)',
                            '(x+1/3, x-y+2/3, z+2/3)'))},
      '160:R': {'1a': (1, ('(x, x, x)', )),
                '3b': (5, ('(x, x, z)', '(z, x, x)', '(x, z, x)')),
                '6c': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)', '(z, y, x)',
                           '(y, x, z)', '(x, z, y)'))},
      '161:H': {'6a': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)', '(0, 0, z+1/2)',
                           '(2/3, 1/3, z+5/6)', '(1/3, 2/3, z+1/6)')),
                '18b': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(-y, -x, z+1/2)',
                            '(-y+2/3, -x+1/3, z+5/6)',
                            '(-y+1/3, -x+2/3, z+1/6)', '(-x+y, y, z+1/2)',
                            '(-x+y+2/3, y+1/3, z+5/6)',
                            '(-x+y+1/3, y+2/3, z+1/6)', '(x, x-y, z+1/2)',
                            '(x+2/3, x-y+1/3, z+5/6)',
                            '(x+1/3, x-y+2/3, z+1/6)'))},
      '161:R': {'2a': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)')),
                '6b': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                           '(z+1/2, y+1/2, x+1/2)', '(y+1/2, x+1/2, z+1/2)',
                           '(x+1/2, z+1/2, y+1/2)'))},
      '162': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)')),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)')),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '3f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)')),
              '3g': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '4h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)', '(2/3, 1/3, -z)',
                         '(2/3, 1/3, z)')),
              '6i': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)',
                         '(-x, x, 0)', '(-x, -2*x, 0)', '(2*x, x, 0)')),
              '6j': (1, ('(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)',
                         '(-x, x, 1/2)', '(-x, -2*x, 1/2)', '(2*x, x, 1/2)')),
              '6k': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                         '(0, -x, -z)', '(-x, 0, -z)', '(x, x, -z)')),
              '12l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'))},
      '163': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)')),
              '2d': (0, ('(2/3, 1/3, 1/4)', '(1/3, 2/3, 3/4)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)')),
              '4f': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z+1/2)',
                         '(2/3, 1/3, -z)', '(2/3, 1/3, z+1/2)')),
              '6g': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '6h': (1, ('(x, -x, 1/4)', '(x, 2*x, 1/4)', '(-2*x, -x, 1/4)',
                         '(-x, x, 3/4)', '(-x, -2*x, 3/4)', '(2*x, x, 3/4)')),
              '12i': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-y, -x, -z+1/2)', '(-x+y, y, -z+1/2)',
                          '(x, x-y, -z+1/2)', '(-x, -y, -z)', '(y, -x+y, -z)',
                          '(x-y, x, -z)', '(y, x, z+1/2)', '(x-y, -y, z+1/2)',
                          '(-x, -x+y, z+1/2)'))},
      '164': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '2c': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2d': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, -z)')),
              '3e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)')),
              '3f': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '6g': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(-x, 0, 0)', '(0, -x, 0)', '(x, x, 0)')),
              '6h': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)',
                         '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)')),
              '6i': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)',
                         '(-x, x, -z)', '(2*x, x, -z)', '(-x, -2*x, -z)')),
              '12j': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)'))},
      '165': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '4c': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)')),
              '4d': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, -z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, z+1/2)')),
              '6e': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '6f': (1, ('(x, 0, 1/4)', '(0, x, 1/4)', '(-x, -x, 1/4)',
                         '(-x, 0, 3/4)', '(0, -x, 3/4)', '(x, x, 3/4)')),
              '12g': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(y, x, -z+1/2)', '(x-y, -y, -z+1/2)',
                          '(-x, -x+y, -z+1/2)', '(-x, -y, -z)',
                          '(y, -x+y, -z)', '(x-y, x, -z)', '(-y, -x, z+1/2)',
                          '(-x+y, y, z+1/2)', '(x, x-y, z+1/2)'))},
      '166:H': {'3a': (0, ('(0, 0, 0)', '(2/3, 1/3, 1/3)', '(1/3, 2/3, 2/3)'
                           )),
                '3b': (0, ('(0, 0, 1/2)', '(2/3, 1/3, 5/6)',
                           '(1/3, 2/3, 1/6)')),
                '6c': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                           '(1/3, 2/3, z+2/3)', '(0, 0, -z)',
                           '(2/3, 1/3, -z+1/3)', '(1/3, 2/3, -z+2/3)')),
                '9d': (0, ('(1/2, 0, 1/2)', '(1/6, 1/3, 5/6)',
                           '(5/6, 2/3, 1/6)', '(0, 1/2, 1/2)',
                           '(2/3, 5/6, 5/6)', '(1/3, 1/6, 1/6)',
                           '(1/2, 1/2, 1/2)', '(1/6, 5/6, 5/6)',
                           '(5/6, 1/6, 1/6)')),
                '9e': (0, ('(1/2, 0, 0)', '(1/6, 1/3, 1/3)',
                           '(5/6, 2/3, 2/3)', '(0, 1/2, 0)',
                           '(2/3, 5/6, 1/3)', '(1/3, 1/6, 2/3)',
                           '(1/2, 1/2, 0)', '(1/6, 5/6, 1/3)',
                           '(5/6, 1/6, 2/3)')),
                '18f': (1, ('(x, 0, 0)', '(x+2/3, 1/3, 1/3)',
                            '(x+1/3, 2/3, 2/3)', '(0, x, 0)',
                            '(2/3, x+1/3, 1/3)', '(1/3, x+2/3, 2/3)',
                            '(-x, -x, 0)', '(-x+2/3, -x+1/3, 1/3)',
                            '(-x+1/3, -x+2/3, 2/3)', '(-x, 0, 0)',
                            '(-x+2/3, 1/3, 1/3)', '(-x+1/3, 2/3, 2/3)',
                            '(0, -x, 0)', '(2/3, -x+1/3, 1/3)',
                            '(1/3, -x+2/3, 2/3)', '(x, x, 0)',
                            '(x+2/3, x+1/3, 1/3)', '(x+1/3, x+2/3, 2/3)')),
                '18g': (1, ('(x, 0, 1/2)', '(x+2/3, 1/3, 5/6)',
                            '(x+1/3, 2/3, 1/6)', '(0, x, 1/2)',
                            '(2/3, x+1/3, 5/6)', '(1/3, x+2/3, 1/6)',
                            '(-x, -x, 1/2)', '(-x+2/3, -x+1/3, 5/6)',
                            '(-x+1/3, -x+2/3, 1/6)', '(-x, 0, 1/2)',
                            '(-x+2/3, 1/3, 5/6)', '(-x+1/3, 2/3, 1/6)',
                            '(0, -x, 1/2)', '(2/3, -x+1/3, 5/6)',
                            '(1/3, -x+2/3, 1/6)', '(x, x, 1/2)',
                            '(x+2/3, x+1/3, 5/6)', '(x+1/3, x+2/3, 1/6)')),
                '18h': (5, ('(x, -x, z)', '(x+2/3, -x+1/3, z+1/3)',
                            '(x+1/3, -x+2/3, z+2/3)', '(x, 2*x, z)',
                            '(x+2/3, 2*x+1/3, z+1/3)',
                            '(x+1/3, 2*x+2/3, z+2/3)', '(-2*x, -x, z)',
                            '(-2*x+2/3, -x+1/3, z+1/3)',
                            '(-2*x+1/3, -x+2/3, z+2/3)', '(-x, x, -z)',
                            '(-x+2/3, x+1/3, -z+1/3)',
                            '(-x+1/3, x+2/3, -z+2/3)', '(2*x, x, -z)',
                            '(2*x+2/3, x+1/3, -z+1/3)',
                            '(2*x+1/3, x+2/3, -z+2/3)', '(-x, -2*x, -z)',
                            '(-x+2/3, -2*x+1/3, -z+1/3)',
                            '(-x+1/3, -2*x+2/3, -z+2/3)')),
                '36i': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(y, x, -z)',
                            '(y+2/3, x+1/3, -z+1/3)',
                            '(y+1/3, x+2/3, -z+2/3)', '(x-y, -y, -z)',
                            '(x-y+2/3, -y+1/3, -z+1/3)',
                            '(x-y+1/3, -y+2/3, -z+2/3)', '(-x, -x+y, -z)',
                            '(-x+2/3, -x+y+1/3, -z+1/3)',
                            '(-x+1/3, -x+y+2/3, -z+2/3)', '(-x, -y, -z)',
                            '(-x+2/3, -y+1/3, -z+1/3)',
                            '(-x+1/3, -y+2/3, -z+2/3)', '(y, -x+y, -z)',
                            '(y+2/3, -x+y+1/3, -z+1/3)',
                            '(y+1/3, -x+y+2/3, -z+2/3)', '(x-y, x, -z)',
                            '(x-y+2/3, x+1/3, -z+1/3)',
                            '(x-y+1/3, x+2/3, -z+2/3)', '(-y, -x, z)',
                            '(-y+2/3, -x+1/3, z+1/3)',
                            '(-y+1/3, -x+2/3, z+2/3)', '(-x+y, y, z)',
                            '(-x+y+2/3, y+1/3, z+1/3)',
                            '(-x+y+1/3, y+2/3, z+2/3)', '(x, x-y, z)',
                            '(x+2/3, x-y+1/3, z+1/3)',
                            '(x+1/3, x-y+2/3, z+2/3)'))},
      '166:R': {'1a': (0, ('(0, 0, 0)', )),
                '1b': (0, ('(1/2, 1/2, 1/2)', )),
                '2c': (1, ('(x, x, x)', '(-x, -x, -x)')),
                '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
                '3e': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)'
                           )),
                '6f': (1, ('(x, -x, 0)', '(0, x, -x)', '(-x, 0, x)',
                           '(-x, x, 0)', '(0, -x, x)', '(x, 0, -x)')),
                '6g': (1, ('(x, -x, 1/2)', '(1/2, x, -x)', '(-x, 1/2, x)',
                           '(-x, x, 1/2)', '(1/2, -x, x)', '(x, 1/2, -x)')),
                '6h': (5, ('(x, x, z)', '(z, x, x)', '(x, z, x)',
                           '(-z, -x, -x)', '(-x, -x, -z)', '(-x, -z, -x)')),
                '12i': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                            '(-z, -y, -x)', '(-y, -x, -z)', '(-x, -z, -y)',
                            '(-x, -y, -z)', '(-z, -x, -y)', '(-y, -z, -x)',
                            '(z, y, x)', '(y, x, z)', '(x, z, y)'))},
      '167:H': {'6a': (0, ('(0, 0, 1/4)', '(2/3, 1/3, 7/12)',
                           '(1/3, 2/3, 11/12)', '(0, 0, 3/4)',
                           '(2/3, 1/3, 1/12)', '(1/3, 2/3, 5/12)')),
                '6b': (0, ('(0, 0, 0)', '(2/3, 1/3, 1/3)', '(1/3, 2/3, 2/3)',
                           '(0, 0, 1/2)', '(2/3, 1/3, 5/6)',
                           '(1/3, 2/3, 1/6)')),
                '12c': (4, ('(0, 0, z)', '(2/3, 1/3, z+1/3)',
                            '(1/3, 2/3, z+2/3)', '(0, 0, -z+1/2)',
                            '(2/3, 1/3, -z+5/6)', '(1/3, 2/3, -z+1/6)',
                            '(0, 0, -z)', '(2/3, 1/3, -z+1/3)',
                            '(1/3, 2/3, -z+2/3)', '(0, 0, z+1/2)',
                            '(2/3, 1/3, z+5/6)', '(1/3, 2/3, z+1/6)')),
                '18d': (0, ('(1/2, 0, 0)', '(1/6, 1/3, 1/3)',
                            '(5/6, 2/3, 2/3)', '(0, 1/2, 0)',
                            '(2/3, 5/6, 1/3)', '(1/3, 1/6, 2/3)',
                            '(1/2, 1/2, 0)', '(1/6, 5/6, 1/3)',
                            '(5/6, 1/6, 2/3)', '(0, 1/2, 1/2)',
                            '(2/3, 5/6, 5/6)', '(1/3, 1/6, 1/6)',
                            '(1/2, 0, 1/2)', '(1/6, 1/3, 5/6)',
                            '(5/6, 2/3, 1/6)', '(1/2, 1/2, 1/2)',
                            '(1/6, 5/6, 5/6)', '(5/6, 1/6, 1/6)')),
                '18e': (1, ('(x, 0, 1/4)', '(x+2/3, 1/3, 7/12)',
                            '(x+1/3, 2/3, 11/12)', '(0, x, 1/4)',
                            '(2/3, x+1/3, 7/12)', '(1/3, x+2/3, 11/12)',
                            '(-x, -x, 1/4)', '(-x+2/3, -x+1/3, 7/12)',
                            '(-x+1/3, -x+2/3, 11/12)', '(-x, 0, 3/4)',
                            '(-x+2/3, 1/3, 1/12)', '(-x+1/3, 2/3, 5/12)',
                            '(0, -x, 3/4)', '(2/3, -x+1/3, 1/12)',
                            '(1/3, -x+2/3, 5/12)', '(x, x, 3/4)',
                            '(x+2/3, x+1/3, 1/12)', '(x+1/3, x+2/3, 5/12)')),
                '36f': (7, ('(x, y, z)', '(x+2/3, y+1/3, z+1/3)',
                            '(x+1/3, y+2/3, z+2/3)', '(-y, x-y, z)',
                            '(-y+2/3, x-y+1/3, z+1/3)',
                            '(-y+1/3, x-y+2/3, z+2/3)', '(-x+y, -x, z)',
                            '(-x+y+2/3, -x+1/3, z+1/3)',
                            '(-x+y+1/3, -x+2/3, z+2/3)', '(y, x, -z+1/2)',
                            '(y+2/3, x+1/3, -z+5/6)',
                            '(y+1/3, x+2/3, -z+1/6)', '(x-y, -y, -z+1/2)',
                            '(x-y+2/3, -y+1/3, -z+5/6)',
                            '(x-y+1/3, -y+2/3, -z+1/6)', '(-x, -x+y, -z+1/2)',
                            '(-x+2/3, -x+y+1/3, -z+5/6)',
                            '(-x+1/3, -x+y+2/3, -z+1/6)', '(-x, -y, -z)',
                            '(-x+2/3, -y+1/3, -z+1/3)',
                            '(-x+1/3, -y+2/3, -z+2/3)', '(y, -x+y, -z)',
                            '(y+2/3, -x+y+1/3, -z+1/3)',
                            '(y+1/3, -x+y+2/3, -z+2/3)', '(x-y, x, -z)',
                            '(x-y+2/3, x+1/3, -z+1/3)',
                            '(x-y+1/3, x+2/3, -z+2/3)', '(-y, -x, z+1/2)',
                            '(-y+2/3, -x+1/3, z+5/6)',
                            '(-y+1/3, -x+2/3, z+1/6)', '(-x+y, y, z+1/2)',
                            '(-x+y+2/3, y+1/3, z+5/6)',
                            '(-x+y+1/3, y+2/3, z+1/6)', '(x, x-y, z+1/2)',
                            '(x+2/3, x-y+1/3, z+5/6)',
                            '(x+1/3, x-y+2/3, z+1/6)'))},
      '167:R': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
                '2b': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
                '4c': (1, ('(x, x, x)', '(-x+1/2, -x+1/2, -x+1/2)',
                           '(-x, -x, -x)', '(x+1/2, x+1/2, x+1/2)')),
                '6d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)',
                           '(1/2, 1/2, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)'
                           )),
                '6e': (1, ('(x, -x+1/2, 1/4)', '(1/4, x, -x+1/2)',
                           '(-x+1/2, 1/4, x)', '(-x, x+1/2, 3/4)',
                           '(3/4, -x, x+1/2)', '(x+1/2, 3/4, -x)')),
                '12f': (7, ('(x, y, z)', '(z, x, y)', '(y, z, x)',
                            '(-z+1/2, -y+1/2, -x+1/2)',
                            '(-y+1/2, -x+1/2, -z+1/2)',
                            '(-x+1/2, -z+1/2, -y+1/2)', '(-x, -y, -z)',
                            '(-z, -x, -y)', '(-y, -z, -x)',
                            '(z+1/2, y+1/2, x+1/2)', '(y+1/2, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, y+1/2)'))},
      '168': {'1a': (4, ('(0, 0, z)', )),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)')),
              '3c': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)')),
              '6d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)'))},
      '169': {'6a': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)',
                         '(-x, -y, z+1/2)', '(y, -x+y, z+5/6)',
                         '(x-y, x, z+1/6)'))},
      '170': {'6a': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)',
                         '(-x, -y, z+1/2)', '(y, -x+y, z+1/6)',
                         '(x-y, x, z+5/6)'))},
      '171': {'3a': (4, ('(0, 0, z)', '(0, 0, z+2/3)', '(0, 0, z+1/3)')),
              '3b': (4, ('(1/2, 1/2, z)', '(1/2, 0, z+2/3)',
                         '(0, 1/2, z+1/3)')),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+2/3)', '(-x+y, -x, z+1/3)',
                         '(-x, -y, z)', '(y, -x+y, z+2/3)', '(x-y, x, z+1/3)'
                         ))},
      '172': {'3a': (4, ('(0, 0, z)', '(0, 0, z+1/3)', '(0, 0, z+2/3)')),
              '3b': (4, ('(1/2, 1/2, z)', '(1/2, 0, z+1/3)',
                         '(0, 1/2, z+2/3)')),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z+1/3)', '(-x+y, -x, z+2/3)',
                         '(-x, -y, z)', '(y, -x+y, z+1/3)', '(x-y, x, z+2/3)'
                         ))},
      '173': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)')),
              '6c': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                         '(x-y, x, z+1/2)'))},
      '174': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '1c': (0, ('(1/3, 2/3, 0)', )),
              '1d': (0, ('(1/3, 2/3, 1/2)', )),
              '1e': (0, ('(2/3, 1/3, 0)', )),
              '1f': (0, ('(2/3, 1/3, 1/2)', )),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)')),
              '2i': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, -z)')),
              '3j': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)')),
              '3k': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)')),
              '6l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                         '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)'))},
      '175': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)')),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)')),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '3f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)')),
              '3g': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '4h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)', '(2/3, 1/3, -z)',
                         '(1/3, 2/3, -z)')),
              '6i': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                         '(1/2, 0, -z)', '(0, 1/2, -z)', '(1/2, 1/2, -z)')),
              '6j': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                         '(-x, -y, 0)', '(y, -x+y, 0)', '(x-y, x, 0)')),
              '6k': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)',
                         '(-x, -y, 1/2)', '(y, -x+y, 1/2)', '(x-y, x, 1/2)')),
              '12l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)'))},
      '176': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)')),
              '2d': (0, ('(2/3, 1/3, 1/4)', '(1/3, 2/3, 3/4)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                         '(0, 0, -z+1/2)')),
              '4f': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z+1/2)')),
              '6g': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '6h': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                         '(-x, -y, 3/4)', '(y, -x+y, 3/4)', '(x-y, x, 3/4)')),
              '12i': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(-x, -y, -z)', '(y, -x+y, -z)',
                          '(x-y, x, -z)', '(x, y, -z+1/2)',
                          '(-y, x-y, -z+1/2)', '(-x+y, -x, -z+1/2)'))},
      '177': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)')),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)')),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '3f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)')),
              '3g': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '4h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)', '(2/3, 1/3, -z)',
                         '(1/3, 2/3, -z)')),
              '6i': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                         '(0, 1/2, -z)', '(1/2, 0, -z)', '(1/2, 1/2, -z)')),
              '6j': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(-x, 0, 0)', '(0, -x, 0)', '(x, x, 0)')),
              '6k': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)',
                         '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)')),
              '6l': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)',
                         '(-x, x, 0)', '(-x, -2*x, 0)', '(2*x, x, 0)')),
              '6m': (1, ('(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)',
                         '(-x, x, 1/2)', '(-x, -2*x, 1/2)', '(2*x, x, 1/2)')),
              '12n': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)'))},
      '178': {'6a': (1, ('(x, 0, 0)', '(0, x, 1/3)', '(-x, -x, 2/3)',
                         '(-x, 0, 1/2)', '(0, -x, 5/6)', '(x, x, 1/6)')),
              '6b': (1, ('(x, 2*x, 1/4)', '(-2*x, -x, 7/12)',
                         '(x, -x, 11/12)', '(-x, -2*x, 3/4)',
                         '(2*x, x, 1/12)', '(-x, x, 5/12)')),
              '12c': (7, ('(x, y, z)', '(-y, x-y, z+1/3)',
                          '(-x+y, -x, z+2/3)', '(-x, -y, z+1/2)',
                          '(y, -x+y, z+5/6)', '(x-y, x, z+1/6)',
                          '(y, x, -z+1/3)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z+2/3)', '(-y, -x, -z+5/6)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+1/6)'))},
      '179': {'6a': (1, ('(x, 0, 0)', '(0, x, 2/3)', '(-x, -x, 1/3)',
                         '(-x, 0, 1/2)', '(0, -x, 1/6)', '(x, x, 5/6)')),
              '6b': (1, ('(x, 2*x, 3/4)', '(-2*x, -x, 5/12)', '(x, -x, 1/12)',
                         '(-x, -2*x, 1/4)', '(2*x, x, 11/12)',
                         '(-x, x, 7/12)')),
              '12c': (7, ('(x, y, z)', '(-y, x-y, z+2/3)',
                          '(-x+y, -x, z+1/3)', '(-x, -y, z+1/2)',
                          '(y, -x+y, z+1/6)', '(x-y, x, z+5/6)',
                          '(y, x, -z+2/3)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z+1/3)', '(-y, -x, -z+1/6)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+5/6)'))},
      '180': {'3a': (0, ('(0, 0, 0)', '(0, 0, 2/3)', '(0, 0, 1/3)')),
              '3b': (0, ('(0, 0, 1/2)', '(0, 0, 1/6)', '(0, 0, 5/6)')),
              '3c': (0, ('(1/2, 0, 0)', '(0, 1/2, 2/3)', '(1/2, 1/2, 1/3)')),
              '3d': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/6)', '(1/2, 1/2, 5/6)'
                         )),
              '6e': (4, ('(0, 0, z)', '(0, 0, z+2/3)', '(0, 0, z+1/3)',
                         '(0, 0, -z+2/3)', '(0, 0, -z)', '(0, 0, -z+1/3)')),
              '6f': (4, ('(1/2, 0, z)', '(0, 1/2, z+2/3)',
                         '(1/2, 1/2, z+1/3)', '(0, 1/2, -z+2/3)',
                         '(1/2, 0, -z)', '(1/2, 1/2, -z+1/3)')),
              '6g': (1, ('(x, 0, 0)', '(0, x, 2/3)', '(-x, -x, 1/3)',
                         '(-x, 0, 0)', '(0, -x, 2/3)', '(x, x, 1/3)')),
              '6h': (1, ('(x, 0, 1/2)', '(0, x, 1/6)', '(-x, -x, 5/6)',
                         '(-x, 0, 1/2)', '(0, -x, 1/6)', '(x, x, 5/6)')),
              '6i': (1, ('(x, 2*x, 0)', '(-2*x, -x, 2/3)', '(x, -x, 1/3)',
                         '(-x, -2*x, 0)', '(2*x, x, 2/3)', '(-x, x, 1/3)')),
              '6j': (1, ('(x, 2*x, 1/2)', '(-2*x, -x, 1/6)', '(x, -x, 5/6)',
                         '(-x, -2*x, 1/2)', '(2*x, x, 1/6)', '(-x, x, 5/6)')),
              '12k': (7, ('(x, y, z)', '(-y, x-y, z+2/3)',
                          '(-x+y, -x, z+1/3)', '(-x, -y, z)',
                          '(y, -x+y, z+2/3)', '(x-y, x, z+1/3)',
                          '(y, x, -z+2/3)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z+1/3)', '(-y, -x, -z+2/3)',
                          '(-x+y, y, -z)', '(x, x-y, -z+1/3)'))},
      '181': {'3a': (0, ('(0, 0, 0)', '(0, 0, 1/3)', '(0, 0, 2/3)')),
              '3b': (0, ('(0, 0, 1/2)', '(0, 0, 5/6)', '(0, 0, 1/6)')),
              '3c': (0, ('(1/2, 0, 0)', '(0, 1/2, 1/3)', '(1/2, 1/2, 2/3)')),
              '3d': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 5/6)', '(1/2, 1/2, 1/6)'
                         )),
              '6e': (4, ('(0, 0, z)', '(0, 0, z+1/3)', '(0, 0, z+2/3)',
                         '(0, 0, -z+1/3)', '(0, 0, -z)', '(0, 0, -z+2/3)')),
              '6f': (4, ('(1/2, 0, z)', '(0, 1/2, z+1/3)',
                         '(1/2, 1/2, z+2/3)', '(0, 1/2, -z+1/3)',
                         '(1/2, 0, -z)', '(1/2, 1/2, -z+2/3)')),
              '6g': (1, ('(x, 0, 0)', '(0, x, 1/3)', '(-x, -x, 2/3)',
                         '(-x, 0, 0)', '(0, -x, 1/3)', '(x, x, 2/3)')),
              '6h': (1, ('(x, 0, 1/2)', '(0, x, 5/6)', '(-x, -x, 1/6)',
                         '(-x, 0, 1/2)', '(0, -x, 5/6)', '(x, x, 1/6)')),
              '6i': (1, ('(x, 2*x, 0)', '(-2*x, -x, 1/3)', '(x, -x, 2/3)',
                         '(-x, -2*x, 0)', '(2*x, x, 1/3)', '(-x, x, 2/3)')),
              '6j': (1, ('(x, 2*x, 1/2)', '(-2*x, -x, 5/6)', '(x, -x, 1/6)',
                         '(-x, -2*x, 1/2)', '(2*x, x, 5/6)', '(-x, x, 1/6)')),
              '12k': (7, ('(x, y, z)', '(-y, x-y, z+1/3)',
                          '(-x+y, -x, z+2/3)', '(-x, -y, z)',
                          '(y, -x+y, z+1/3)', '(x-y, x, z+2/3)',
                          '(y, x, -z+1/3)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z+2/3)', '(-y, -x, -z+1/3)',
                          '(-x+y, y, -z)', '(x, x-y, -z+2/3)'))},
      '182': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)')),
              '2d': (0, ('(1/3, 2/3, 3/4)', '(2/3, 1/3, 1/4)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                         '(0, 0, -z+1/2)')),
              '4f': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z+1/2)')),
              '6g': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)')),
              '6h': (1, ('(x, 2*x, 1/4)', '(-2*x, -x, 1/4)', '(x, -x, 1/4)',
                         '(-x, -2*x, 3/4)', '(2*x, x, 3/4)', '(-x, x, 3/4)')),
              '12i': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(y, x, -z)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z)', '(-y, -x, -z+1/2)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+1/2)'))},
      '183': {'1a': (4, ('(0, 0, z)', )),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)')),
              '3c': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)')),
              '6d': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                         '(-x, 0, z)', '(0, -x, z)', '(x, x, z)')),
              '6e': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)',
                         '(-x, x, z)', '(-x, -2*x, z)', '(2*x, x, z)')),
              '12f': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)',
                          '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'))},
      '184': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '4b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)',
                         '(1/3, 2/3, z+1/2)', '(2/3, 1/3, z+1/2)')),
              '6c': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                         '(0, 1/2, z+1/2)', '(1/2, 0, z+1/2)',
                         '(1/2, 1/2, z+1/2)')),
              '12d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(-y, -x, z+1/2)', '(-x+y, y, z+1/2)',
                          '(x, x-y, z+1/2)', '(y, x, z+1/2)',
                          '(x-y, -y, z+1/2)', '(-x, -x+y, z+1/2)'))},
      '185': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '4b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(1/3, 2/3, z+1/2)', '(2/3, 1/3, z)')),
              '6c': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                         '(-x, 0, z+1/2)', '(0, -x, z+1/2)', '(x, x, z+1/2)'
                         )),
              '12d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(-y, -x, z+1/2)',
                          '(-x+y, y, z+1/2)', '(x, x-y, z+1/2)', '(y, x, z)',
                          '(x-y, -y, z)', '(-x, -x+y, z)'))},
      '186': {'2a': (4, ('(0, 0, z)', '(0, 0, z+1/2)')),
              '2b': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)')),
              '6c': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)',
                         '(-x, x, z+1/2)', '(-x, -2*x, z+1/2)',
                         '(2*x, x, z+1/2)')),
              '12d': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(-y, -x, z)', '(-x+y, y, z)',
                          '(x, x-y, z)', '(y, x, z+1/2)', '(x-y, -y, z+1/2)',
                          '(-x, -x+y, z+1/2)'))},
      '187': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '1c': (0, ('(1/3, 2/3, 0)', )),
              '1d': (0, ('(1/3, 2/3, 1/2)', )),
              '1e': (0, ('(2/3, 1/3, 0)', )),
              '1f': (0, ('(2/3, 1/3, 1/2)', )),
              '2g': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '2h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)')),
              '2i': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, -z)')),
              '3j': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)')),
              '3k': (1, ('(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)')),
              '6l': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                         '(-y, -x, 0)', '(-x+y, y, 0)', '(x, x-y, 0)')),
              '6m': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)',
                         '(-y, -x, 1/2)', '(-x+y, y, 1/2)', '(x, x-y, 1/2)')),
              '6n': (5, ('(x, -x, z)', '(x, 2*x, z)', '(-2*x, -x, z)',
                         '(x, -x, -z)', '(x, 2*x, -z)', '(-2*x, -x, -z)')),
              '12o': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)',
                          '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)'))},
      '188': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2c': (0, ('(1/3, 2/3, 0)', '(1/3, 2/3, 1/2)')),
              '2d': (0, ('(1/3, 2/3, 1/4)', '(1/3, 2/3, 3/4)')),
              '2e': (0, ('(2/3, 1/3, 0)', '(2/3, 1/3, 1/2)')),
              '2f': (0, ('(2/3, 1/3, 1/4)', '(2/3, 1/3, 3/4)')),
              '4g': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, z+1/2)',
                         '(0, 0, -z)')),
              '4h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z+1/2)',
                         '(1/3, 2/3, z+1/2)', '(1/3, 2/3, -z)')),
              '4i': (4, ('(2/3, 1/3, z)', '(2/3, 1/3, -z+1/2)',
                         '(2/3, 1/3, z+1/2)', '(2/3, 1/3, -z)')),
              '6j': (1, ('(x, -x, 0)', '(x, 2*x, 0)', '(-2*x, -x, 0)',
                         '(x, -x, 1/2)', '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)')),
              '6k': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                         '(-y, -x, 3/4)', '(-x+y, y, 3/4)', '(x, x-y, 3/4)')),
              '12l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(x, y, -z+1/2)', '(-y, x-y, -z+1/2)',
                          '(-x+y, -x, -z+1/2)', '(-y, -x, z+1/2)',
                          '(-x+y, y, z+1/2)', '(x, x-y, z+1/2)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)'))},
      '189': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)')),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)')),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '3f': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)')),
              '3g': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)')),
              '4h': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z)', '(2/3, 1/3, -z)',
                         '(2/3, 1/3, z)')),
              '6i': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                         '(x, 0, -z)', '(0, x, -z)', '(-x, -x, -z)')),
              '6j': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                         '(y, x, 0)', '(x-y, -y, 0)', '(-x, -x+y, 0)')),
              '6k': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)',
                         '(y, x, 1/2)', '(x-y, -y, 1/2)', '(-x, -x+y, 1/2)')),
              '12l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)',
                          '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)',
                          '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'))},
      '190': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)')),
              '2d': (0, ('(2/3, 1/3, 1/4)', '(1/3, 2/3, 3/4)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)')),
              '4f': (4, ('(1/3, 2/3, z)', '(1/3, 2/3, -z+1/2)',
                         '(2/3, 1/3, -z)', '(2/3, 1/3, z+1/2)')),
              '6g': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)')),
              '6h': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                         '(y, x, 3/4)', '(x-y, -y, 3/4)', '(-x, -x+y, 3/4)')),
              '12i': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(x, y, -z+1/2)', '(-y, x-y, -z+1/2)',
                          '(-x+y, -x, -z+1/2)', '(y, x, -z)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z)', '(y, x, z+1/2)',
                          '(x-y, -y, z+1/2)', '(-x, -x+y, z+1/2)'))},
      '191': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(0, 0, 1/2)', )),
              '2c': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)')),
              '2d': (0, ('(1/3, 2/3, 1/2)', '(2/3, 1/3, 1/2)')),
              '2e': (4, ('(0, 0, z)', '(0, 0, -z)')),
              '3f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)')),
              '3g': (0, ('(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '4h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)', '(2/3, 1/3, -z)',
                         '(1/3, 2/3, -z)')),
              '6i': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                         '(0, 1/2, -z)', '(1/2, 0, -z)', '(1/2, 1/2, -z)')),
              '6j': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                         '(-x, 0, 0)', '(0, -x, 0)', '(x, x, 0)')),
              '6k': (1, ('(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)',
                         '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)')),
              '6l': (1, ('(x, 2*x, 0)', '(-2*x, -x, 0)', '(x, -x, 0)',
                         '(-x, -2*x, 0)', '(2*x, x, 0)', '(-x, x, 0)')),
              '6m': (1, ('(x, 2*x, 1/2)', '(-2*x, -x, 1/2)', '(x, -x, 1/2)',
                         '(-x, -2*x, 1/2)', '(2*x, x, 1/2)', '(-x, x, 1/2)')),
              '12n': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                          '(-x, 0, z)', '(0, -x, z)', '(x, x, z)',
                          '(0, x, -z)', '(x, 0, -z)', '(-x, -x, -z)',
                          '(0, -x, -z)', '(-x, 0, -z)', '(x, x, -z)')),
              '12o': (5, ('(x, 2*x, z)', '(-2*x, -x, z)', '(x, -x, z)',
                          '(-x, -2*x, z)', '(2*x, x, z)', '(-x, x, z)',
                          '(2*x, x, -z)', '(-x, -2*x, -z)', '(-x, x, -z)',
                          '(-2*x, -x, -z)', '(x, 2*x, -z)', '(x, -x, -z)')),
              '12p': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                          '(-x, -y, 0)', '(y, -x+y, 0)', '(x-y, x, 0)',
                          '(y, x, 0)', '(x-y, -y, 0)', '(-x, -x+y, 0)',
                          '(-y, -x, 0)', '(-x+y, y, 0)', '(x, x-y, 0)')),
              '12q': (3, ('(x, y, 1/2)', '(-y, x-y, 1/2)', '(-x+y, -x, 1/2)',
                          '(-x, -y, 1/2)', '(y, -x+y, 1/2)', '(x-y, x, 1/2)',
                          '(y, x, 1/2)', '(x-y, -y, 1/2)', '(-x, -x+y, 1/2)',
                          '(-y, -x, 1/2)', '(-x+y, y, 1/2)', '(x, x-y, 1/2)'
                          )),
              '24r': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(y, x, -z)', '(x-y, -y, -z)', '(-x, -x+y, -z)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)',
                          '(-y, -x, z)', '(-x+y, y, z)', '(x, x-y, z)',
                          '(y, x, z)', '(x-y, -y, z)', '(-x, -x+y, z)'))},
      '192': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '4c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 1/4)',
                         '(2/3, 1/3, 3/4)', '(1/3, 2/3, 3/4)')),
              '4d': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 0)', '(2/3, 1/3, 1/2)',
                         '(1/3, 2/3, 1/2)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, -z+1/2)', '(0, 0, -z)',
                         '(0, 0, z+1/2)')),
              '6f': (0, ('(1/2, 0, 1/4)', '(0, 1/2, 1/4)', '(1/2, 1/2, 1/4)',
                         '(1/2, 0, 3/4)', '(0, 1/2, 3/4)', '(1/2, 1/2, 3/4)'
                         )),
              '6g': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '8h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z)',
                         '(2/3, 1/3, -z+1/2)', '(1/3, 2/3, -z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z)',
                         '(1/3, 2/3, z+1/2)', '(2/3, 1/3, z+1/2)')),
              '12i': (4, ('(1/2, 0, z)', '(0, 1/2, z)', '(1/2, 1/2, z)',
                          '(0, 1/2, -z+1/2)', '(1/2, 0, -z+1/2)',
                          '(1/2, 1/2, -z+1/2)', '(1/2, 0, -z)',
                          '(0, 1/2, -z)', '(1/2, 1/2, -z)', '(0, 1/2, z+1/2)',
                          '(1/2, 0, z+1/2)', '(1/2, 1/2, z+1/2)')),
              '12j': (1, ('(x, 0, 1/4)', '(0, x, 1/4)', '(-x, -x, 1/4)',
                          '(-x, 0, 1/4)', '(0, -x, 1/4)', '(x, x, 1/4)',
                          '(-x, 0, 3/4)', '(0, -x, 3/4)', '(x, x, 3/4)',
                          '(x, 0, 3/4)', '(0, x, 3/4)', '(-x, -x, 3/4)')),
              '12k': (1, ('(x, 2*x, 1/4)', '(-2*x, -x, 1/4)', '(x, -x, 1/4)',
                          '(-x, -2*x, 1/4)', '(2*x, x, 1/4)', '(-x, x, 1/4)',
                          '(-x, -2*x, 3/4)', '(2*x, x, 3/4)', '(-x, x, 3/4)',
                          '(x, 2*x, 3/4)', '(-2*x, -x, 3/4)', '(x, -x, 3/4)'
                          )),
              '12l': (3, ('(x, y, 0)', '(-y, x-y, 0)', '(-x+y, -x, 0)',
                          '(-x, -y, 0)', '(y, -x+y, 0)', '(x-y, x, 0)',
                          '(y, x, 1/2)', '(x-y, -y, 1/2)', '(-x, -x+y, 1/2)',
                          '(-y, -x, 1/2)', '(-x+y, y, 1/2)', '(x, x-y, 1/2)'
                          )),
              '24m': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z)', '(y, -x+y, z)', '(x-y, x, z)',
                          '(y, x, -z+1/2)', '(x-y, -y, -z+1/2)',
                          '(-x, -x+y, -z+1/2)', '(-y, -x, -z+1/2)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+1/2)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z)', '(-y, x-y, -z)', '(-x+y, -x, -z)',
                          '(-y, -x, z+1/2)', '(-x+y, y, z+1/2)',
                          '(x, x-y, z+1/2)', '(y, x, z+1/2)',
                          '(x-y, -y, z+1/2)', '(-x, -x+y, z+1/2)'))},
      '193': {'2a': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2b': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '4c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)',
                         '(2/3, 1/3, 1/4)', '(1/3, 2/3, 3/4)')),
              '4d': (0, ('(1/3, 2/3, 0)', '(2/3, 1/3, 1/2)', '(2/3, 1/3, 0)',
                         '(1/3, 2/3, 1/2)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z+1/2)',
                         '(0, 0, -z)')),
              '6f': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '6g': (1, ('(x, 0, 1/4)', '(0, x, 1/4)', '(-x, -x, 1/4)',
                         '(-x, 0, 3/4)', '(0, -x, 3/4)', '(x, x, 3/4)')),
              '8h': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(2/3, 1/3, -z+1/2)', '(1/3, 2/3, -z)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z+1/2)',
                         '(1/3, 2/3, z+1/2)', '(2/3, 1/3, z)')),
              '12i': (1, ('(x, 2*x, 0)', '(-2*x, -x, 0)', '(x, -x, 0)',
                          '(-x, -2*x, 1/2)', '(2*x, x, 1/2)', '(-x, x, 1/2)',
                          '(-x, -2*x, 0)', '(2*x, x, 0)', '(-x, x, 0)',
                          '(x, 2*x, 1/2)', '(-2*x, -x, 1/2)', '(x, -x, 1/2)'
                          )),
              '12j': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                          '(-x, -y, 3/4)', '(y, -x+y, 3/4)', '(x-y, x, 3/4)',
                          '(y, x, 1/4)', '(x-y, -y, 1/4)', '(-x, -x+y, 1/4)',
                          '(-y, -x, 3/4)', '(-x+y, y, 3/4)', '(x, x-y, 3/4)'
                          )),
              '12k': (5, ('(x, 0, z)', '(0, x, z)', '(-x, -x, z)',
                          '(-x, 0, z+1/2)', '(0, -x, z+1/2)', '(x, x, z+1/2)',
                          '(0, x, -z+1/2)', '(x, 0, -z+1/2)',
                          '(-x, -x, -z+1/2)', '(0, -x, -z)', '(-x, 0, -z)',
                          '(x, x, -z)')),
              '24l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(y, x, -z+1/2)',
                          '(x-y, -y, -z+1/2)', '(-x, -x+y, -z+1/2)',
                          '(-y, -x, -z)', '(-x+y, y, -z)', '(x, x-y, -z)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z+1/2)', '(-y, x-y, -z+1/2)',
                          '(-x+y, -x, -z+1/2)', '(-y, -x, z+1/2)',
                          '(-x+y, y, z+1/2)', '(x, x-y, z+1/2)', '(y, x, z)',
                          '(x-y, -y, z)', '(-x, -x+y, z)'))},
      '194': {'2a': (0, ('(0, 0, 0)', '(0, 0, 1/2)')),
              '2b': (0, ('(0, 0, 1/4)', '(0, 0, 3/4)')),
              '2c': (0, ('(1/3, 2/3, 1/4)', '(2/3, 1/3, 3/4)')),
              '2d': (0, ('(1/3, 2/3, 3/4)', '(2/3, 1/3, 1/4)')),
              '4e': (4, ('(0, 0, z)', '(0, 0, z+1/2)', '(0, 0, -z)',
                         '(0, 0, -z+1/2)')),
              '4f': (4, ('(1/3, 2/3, z)', '(2/3, 1/3, z+1/2)',
                         '(2/3, 1/3, -z)', '(1/3, 2/3, -z+1/2)')),
              '6g': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(1/2, 1/2, 0)',
                         '(1/2, 0, 1/2)', '(0, 1/2, 1/2)', '(1/2, 1/2, 1/2)'
                         )),
              '6h': (1, ('(x, 2*x, 1/4)', '(-2*x, -x, 1/4)', '(x, -x, 1/4)',
                         '(-x, -2*x, 3/4)', '(2*x, x, 3/4)', '(-x, x, 3/4)')),
              '12i': (1, ('(x, 0, 0)', '(0, x, 0)', '(-x, -x, 0)',
                          '(-x, 0, 1/2)', '(0, -x, 1/2)', '(x, x, 1/2)',
                          '(-x, 0, 0)', '(0, -x, 0)', '(x, x, 0)',
                          '(x, 0, 1/2)', '(0, x, 1/2)', '(-x, -x, 1/2)')),
              '12j': (3, ('(x, y, 1/4)', '(-y, x-y, 1/4)', '(-x+y, -x, 1/4)',
                          '(-x, -y, 3/4)', '(y, -x+y, 3/4)', '(x-y, x, 3/4)',
                          '(y, x, 3/4)', '(x-y, -y, 3/4)', '(-x, -x+y, 3/4)',
                          '(-y, -x, 1/4)', '(-x+y, y, 1/4)', '(x, x-y, 1/4)'
                          )),
              '12k': (5, ('(x, 2*x, z)', '(-2*x, -x, z)', '(x, -x, z)',
                          '(-x, -2*x, z+1/2)', '(2*x, x, z+1/2)',
                          '(-x, x, z+1/2)', '(2*x, x, -z)', '(-x, -2*x, -z)',
                          '(-x, x, -z)', '(-2*x, -x, -z+1/2)',
                          '(x, 2*x, -z+1/2)', '(x, -x, -z+1/2)')),
              '24l': (7, ('(x, y, z)', '(-y, x-y, z)', '(-x+y, -x, z)',
                          '(-x, -y, z+1/2)', '(y, -x+y, z+1/2)',
                          '(x-y, x, z+1/2)', '(y, x, -z)', '(x-y, -y, -z)',
                          '(-x, -x+y, -z)', '(-y, -x, -z+1/2)',
                          '(-x+y, y, -z+1/2)', '(x, x-y, -z+1/2)',
                          '(-x, -y, -z)', '(y, -x+y, -z)', '(x-y, x, -z)',
                          '(x, y, -z+1/2)', '(-y, x-y, -z+1/2)',
                          '(-x+y, -x, -z+1/2)', '(-y, -x, z)', '(-x+y, y, z)',
                          '(x, x-y, z)', '(y, x, z+1/2)', '(x-y, -y, z+1/2)',
                          '(-x, -x+y, z+1/2)'))},
      '195': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(1/2, 1/2, 1/2)', )),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)')),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
              '4e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)')),
              '6f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)')),
              '6g': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                         '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)')),
              '6h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                         '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)')),
              '6i': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'
                         )),
              '12j': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)'))},
      '196': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)')),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)')),
              '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)')),
              '4d': (0, ('(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)')),
              '16e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)')),
              '24f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)')),
              '24g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)')),
              '48h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)'))},
      '197': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)')),
              '8c': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                         '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                         '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                         '(x+1/2, -x+1/2, -x+1/2)')),
              '12d': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)')),
              '12e': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                          '(-x+1/2, 0, 1/2)', '(0, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(1/2, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x+1/2)')),
              '24f': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)'))},
      '198': {'4a': (1, ('(x, x, x)', '(-x+1/2, -x, x+1/2)',
                         '(-x, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, -x)')),
              '12b': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z+1/2, -x+1/2, -y)',
                          '(-z+1/2, -x, y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(y, z, x)', '(-y, z+1/2, -x+1/2)',
                          '(y+1/2, -z+1/2, -x)', '(-y+1/2, -z, x+1/2)'))},
      '199': {'8a': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                         '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                         '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                         '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)')),
              '12b': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)')),
              '24c': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)'))},
      '200': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(1/2, 1/2, 1/2)', )),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)')),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
              '6e': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)')),
              '6f': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                         '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)')),
              '6g': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                         '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)')),
              '6h': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'
                         )),
              '8i': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(-x, -x, -x)', '(x, x, -x)',
                         '(x, -x, x)', '(-x, x, x)')),
              '12j': (6, ('(0, y, z)', '(0, -y, z)', '(0, y, -z)',
                          '(0, -y, -z)', '(z, 0, y)', '(z, 0, -y)',
                          '(-z, 0, y)', '(-z, 0, -y)', '(y, z, 0)',
                          '(-y, z, 0)', '(y, -z, 0)', '(-y, -z, 0)')),
              '12k': (6, ('(1/2, y, z)', '(1/2, -y, z)', '(1/2, y, -z)',
                          '(1/2, -y, -z)', '(z, 1/2, y)', '(z, 1/2, -y)',
                          '(-z, 1/2, y)', '(-z, 1/2, -y)', '(y, z, 1/2)',
                          '(-y, z, 1/2)', '(y, -z, 1/2)', '(-y, -z, 1/2)')),
              '24l': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(-x, -y, -z)', '(x, y, -z)', '(x, -y, z)',
                          '(-x, y, z)', '(-z, -x, -y)', '(-z, x, y)',
                          '(z, x, -y)', '(z, -x, y)', '(-y, -z, -x)',
                          '(y, -z, x)', '(-y, z, x)', '(y, z, -x)'))},
      '201:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
                '4b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)')),
                '4c': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)')),
                '6d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                           '(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
                '8e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                           '(x, -x, -x)', '(-x+1/2, -x+1/2, -x+1/2)',
                           '(x+1/2, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, x+1/2)',
                           '(-x+1/2, x+1/2, x+1/2)')),
                '12f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                            '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                            '(-x+1/2, 1/2, 1/2)', '(x+1/2, 1/2, 1/2)',
                            '(1/2, -x+1/2, 1/2)', '(1/2, x+1/2, 1/2)',
                            '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)')),
                '12g': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                            '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                            '(-x+1/2, 0, 1/2)', '(x+1/2, 0, 1/2)',
                            '(1/2, -x+1/2, 0)', '(1/2, x+1/2, 0)',
                            '(0, 1/2, -x+1/2)', '(0, 1/2, x+1/2)')),
                '24h': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                            '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                            '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                            '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-z+1/2, -x+1/2, -y+1/2)',
                            '(-z+1/2, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y+1/2)',
                            '(z+1/2, -x+1/2, y+1/2)',
                            '(-y+1/2, -z+1/2, -x+1/2)',
                            '(y+1/2, -z+1/2, x+1/2)',
                            '(-y+1/2, z+1/2, x+1/2)',
                            '(y+1/2, z+1/2, -x+1/2)'))},
      '201:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
                '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)')),
                '4c': (0, ('(1/2, 1/2, 1/2)', '(0, 0, 1/2)', '(0, 1/2, 0)',
                           '(1/2, 0, 0)')),
                '6d': (0, ('(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)',
                           '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)')),
                '8e': (1, ('(x, x, x)', '(-x+1/2, -x+1/2, x)',
                           '(-x+1/2, x, -x+1/2)', '(x, -x+1/2, -x+1/2)',
                           '(-x, -x, -x)', '(x+1/2, x+1/2, -x)',
                           '(x+1/2, -x, x+1/2)', '(-x, x+1/2, x+1/2)')),
                '12f': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                            '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                            '(1/4, 1/4, x)', '(1/4, 1/4, -x+1/2)',
                            '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)',
                            '(3/4, -x, 3/4)', '(3/4, x+1/2, 3/4)',
                            '(3/4, 3/4, -x)', '(3/4, 3/4, x+1/2)')),
                '12g': (1, ('(x, 3/4, 1/4)', '(-x+1/2, 3/4, 1/4)',
                            '(1/4, x, 3/4)', '(1/4, -x+1/2, 3/4)',
                            '(3/4, 1/4, x)', '(3/4, 1/4, -x+1/2)',
                            '(-x, 1/4, 3/4)', '(x+1/2, 1/4, 3/4)',
                            '(3/4, -x, 1/4)', '(3/4, x+1/2, 1/4)',
                            '(1/4, 3/4, -x)', '(1/4, 3/4, x+1/2)')),
                '24h': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(z, x, y)', '(z, -x+1/2, -y+1/2)',
                            '(-z+1/2, -x+1/2, y)', '(-z+1/2, x, -y+1/2)',
                            '(y, z, x)', '(-y+1/2, z, -x+1/2)',
                            '(y, -z+1/2, -x+1/2)', '(-y+1/2, -z+1/2, x)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-z, -x, -y)', '(-z, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y)', '(z+1/2, -x, y+1/2)',
                            '(-y, -z, -x)', '(y+1/2, -z, x+1/2)',
                            '(-y, z+1/2, x+1/2)', '(y+1/2, z+1/2, -x)'))},
      '202': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)')),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)')),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)')),
              '24d': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)')),
              '24e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)')),
              '32f': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(-x, -x, -x)', '(-x, -x+1/2, -x+1/2)',
                          '(-x+1/2, -x, -x+1/2)', '(-x+1/2, -x+1/2, -x)',
                          '(x, x, -x)', '(x, x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x+1/2, x+1/2, -x)',
                          '(x, -x, x)', '(x, -x+1/2, x+1/2)',
                          '(x+1/2, -x, x+1/2)', '(x+1/2, -x+1/2, x)',
                          '(-x, x, x)', '(-x, x+1/2, x+1/2)',
                          '(-x+1/2, x, x+1/2)', '(-x+1/2, x+1/2, x)')),
              '48g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(-x, 3/4, 3/4)', '(-x, 1/4, 1/4)',
                          '(-x+1/2, 3/4, 1/4)', '(-x+1/2, 1/4, 3/4)',
                          '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                          '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)',
                          '(3/4, -x, 3/4)', '(3/4, -x+1/2, 1/4)',
                          '(1/4, -x, 1/4)', '(1/4, -x+1/2, 3/4)',
                          '(3/4, x, 1/4)', '(3/4, x+1/2, 3/4)',
                          '(1/4, x, 3/4)', '(1/4, x+1/2, 1/4)',
                          '(3/4, 3/4, -x)', '(3/4, 1/4, -x+1/2)',
                          '(1/4, 3/4, -x+1/2)', '(1/4, 1/4, -x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)')),
              '48h': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                          '(1/2, y+1/2, z)', '(0, -y, z)',
                          '(0, -y+1/2, z+1/2)', '(1/2, -y, z+1/2)',
                          '(1/2, -y+1/2, z)', '(0, y, -z)',
                          '(0, y+1/2, -z+1/2)', '(1/2, y, -z+1/2)',
                          '(1/2, y+1/2, -z)', '(0, -y, -z)',
                          '(0, -y+1/2, -z+1/2)', '(1/2, -y, -z+1/2)',
                          '(1/2, -y+1/2, -z)', '(z, 0, y)', '(z, 1/2, y+1/2)',
                          '(z+1/2, 0, y+1/2)', '(z+1/2, 1/2, y)',
                          '(z, 0, -y)', '(z, 1/2, -y+1/2)',
                          '(z+1/2, 0, -y+1/2)', '(z+1/2, 1/2, -y)',
                          '(-z, 0, y)', '(-z, 1/2, y+1/2)',
                          '(-z+1/2, 0, y+1/2)', '(-z+1/2, 1/2, y)',
                          '(-z, 0, -y)', '(-z, 1/2, -y+1/2)',
                          '(-z+1/2, 0, -y+1/2)', '(-z+1/2, 1/2, -y)',
                          '(y, z, 0)', '(y, z+1/2, 1/2)', '(y+1/2, z, 1/2)',
                          '(y+1/2, z+1/2, 0)', '(-y, z, 0)',
                          '(-y, z+1/2, 1/2)', '(-y+1/2, z, 1/2)',
                          '(-y+1/2, z+1/2, 0)', '(y, -z, 0)',
                          '(y, -z+1/2, 1/2)', '(y+1/2, -z, 1/2)',
                          '(y+1/2, -z+1/2, 0)', '(-y, -z, 0)',
                          '(-y, -z+1/2, 1/2)', '(-y+1/2, -z, 1/2)',
                          '(-y+1/2, -z+1/2, 0)')),
              '96i': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                          '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                          '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                          '(x, y, -z)', '(x, y+1/2, -z+1/2)',
                          '(x+1/2, y, -z+1/2)', '(x+1/2, y+1/2, -z)',
                          '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                          '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                          '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                          '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)',
                          '(-z, -x, -y)', '(-z, -x+1/2, -y+1/2)',
                          '(-z+1/2, -x, -y+1/2)', '(-z+1/2, -x+1/2, -y)',
                          '(-z, x, y)', '(-z, x+1/2, y+1/2)',
                          '(-z+1/2, x, y+1/2)', '(-z+1/2, x+1/2, y)',
                          '(z, x, -y)', '(z, x+1/2, -y+1/2)',
                          '(z+1/2, x, -y+1/2)', '(z+1/2, x+1/2, -y)',
                          '(z, -x, y)', '(z, -x+1/2, y+1/2)',
                          '(z+1/2, -x, y+1/2)', '(z+1/2, -x+1/2, y)',
                          '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                          '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                          '(y, -z, x)', '(y, -z+1/2, x+1/2)',
                          '(y+1/2, -z, x+1/2)', '(y+1/2, -z+1/2, x)',
                          '(-y, z, x)', '(-y, z+1/2, x+1/2)',
                          '(-y+1/2, z, x+1/2)', '(-y+1/2, z+1/2, x)',
                          '(y, z, -x)', '(y, z+1/2, -x+1/2)',
                          '(y+1/2, z, -x+1/2)', '(y+1/2, z+1/2, -x)'))},
      '203:1': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 1/2, 0)', '(1/4, 1/4, 1/4)',
                           '(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)')),
                '8b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                           '(0, 0, 1/2)', '(3/4, 3/4, 3/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(1/4, 1/4, 3/4)')),
                '16c': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                            '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                            '(7/8, 7/8, 1/8)', '(7/8, 3/8, 5/8)',
                            '(3/8, 7/8, 5/8)', '(3/8, 3/8, 1/8)',
                            '(7/8, 1/8, 7/8)', '(7/8, 5/8, 3/8)',
                            '(3/8, 1/8, 3/8)', '(3/8, 5/8, 7/8)',
                            '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)',
                            '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)')),
                '16d': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                            '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                            '(3/8, 3/8, 5/8)', '(3/8, 7/8, 1/8)',
                            '(7/8, 3/8, 1/8)', '(7/8, 7/8, 5/8)',
                            '(3/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                            '(7/8, 5/8, 7/8)', '(7/8, 1/8, 3/8)',
                            '(5/8, 3/8, 3/8)', '(5/8, 7/8, 7/8)',
                            '(1/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)')),
                '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                            '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                            '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                            '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                            '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                            '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                            '(-x+1/4, -x+1/4, -x+1/4)',
                            '(-x+1/4, -x+3/4, -x+3/4)',
                            '(-x+3/4, -x+1/4, -x+3/4)',
                            '(-x+3/4, -x+3/4, -x+1/4)',
                            '(x+1/4, x+1/4, -x+1/4)',
                            '(x+1/4, x+3/4, -x+3/4)',
                            '(x+3/4, x+1/4, -x+3/4)',
                            '(x+3/4, x+3/4, -x+1/4)',
                            '(x+1/4, -x+1/4, x+1/4)',
                            '(x+1/4, -x+3/4, x+3/4)',
                            '(x+3/4, -x+1/4, x+3/4)',
                            '(x+3/4, -x+3/4, x+1/4)',
                            '(-x+1/4, x+1/4, x+1/4)',
                            '(-x+1/4, x+3/4, x+3/4)',
                            '(-x+3/4, x+1/4, x+3/4)',
                            '(-x+3/4, x+3/4, x+1/4)')),
                '48f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                            '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                            '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)',
                            '(0, x, 0)', '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                            '(1/2, x+1/2, 0)', '(0, -x, 0)',
                            '(0, -x+1/2, 1/2)', '(1/2, -x, 1/2)',
                            '(1/2, -x+1/2, 0)', '(0, 0, x)',
                            '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                            '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                            '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)',
                            '(-x+1/4, 1/4, 1/4)', '(-x+1/4, 3/4, 3/4)',
                            '(-x+3/4, 1/4, 3/4)', '(-x+3/4, 3/4, 1/4)',
                            '(x+1/4, 1/4, 1/4)', '(x+1/4, 3/4, 3/4)',
                            '(x+3/4, 1/4, 3/4)', '(x+3/4, 3/4, 1/4)',
                            '(1/4, -x+1/4, 1/4)', '(1/4, -x+3/4, 3/4)',
                            '(3/4, -x+1/4, 3/4)', '(3/4, -x+3/4, 1/4)',
                            '(1/4, x+1/4, 1/4)', '(1/4, x+3/4, 3/4)',
                            '(3/4, x+1/4, 3/4)', '(3/4, x+3/4, 1/4)',
                            '(1/4, 1/4, -x+1/4)', '(1/4, 3/4, -x+3/4)',
                            '(3/4, 1/4, -x+3/4)', '(3/4, 3/4, -x+1/4)',
                            '(1/4, 1/4, x+1/4)', '(1/4, 3/4, x+3/4)',
                            '(3/4, 1/4, x+3/4)', '(3/4, 3/4, x+1/4)')),
                '96g': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                            '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                            '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                            '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                            '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                            '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                            '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                            '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                            '(z, x, y)', '(z, x+1/2, y+1/2)',
                            '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                            '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                            '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                            '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                            '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                            '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                            '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                            '(y, z, x)', '(y, z+1/2, x+1/2)',
                            '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                            '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                            '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                            '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                            '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                            '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                            '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                            '(-x+1/4, -y+1/4, -z+1/4)',
                            '(-x+1/4, -y+3/4, -z+3/4)',
                            '(-x+3/4, -y+1/4, -z+3/4)',
                            '(-x+3/4, -y+3/4, -z+1/4)',
                            '(x+1/4, y+1/4, -z+1/4)',
                            '(x+1/4, y+3/4, -z+3/4)',
                            '(x+3/4, y+1/4, -z+3/4)',
                            '(x+3/4, y+3/4, -z+1/4)',
                            '(x+1/4, -y+1/4, z+1/4)',
                            '(x+1/4, -y+3/4, z+3/4)',
                            '(x+3/4, -y+1/4, z+3/4)',
                            '(x+3/4, -y+3/4, z+1/4)',
                            '(-x+1/4, y+1/4, z+1/4)',
                            '(-x+1/4, y+3/4, z+3/4)',
                            '(-x+3/4, y+1/4, z+3/4)',
                            '(-x+3/4, y+3/4, z+1/4)',
                            '(-z+1/4, -x+1/4, -y+1/4)',
                            '(-z+1/4, -x+3/4, -y+3/4)',
                            '(-z+3/4, -x+1/4, -y+3/4)',
                            '(-z+3/4, -x+3/4, -y+1/4)',
                            '(-z+1/4, x+1/4, y+1/4)',
                            '(-z+1/4, x+3/4, y+3/4)',
                            '(-z+3/4, x+1/4, y+3/4)',
                            '(-z+3/4, x+3/4, y+1/4)',
                            '(z+1/4, x+1/4, -y+1/4)',
                            '(z+1/4, x+3/4, -y+3/4)',
                            '(z+3/4, x+1/4, -y+3/4)',
                            '(z+3/4, x+3/4, -y+1/4)',
                            '(z+1/4, -x+1/4, y+1/4)',
                            '(z+1/4, -x+3/4, y+3/4)',
                            '(z+3/4, -x+1/4, y+3/4)',
                            '(z+3/4, -x+3/4, y+1/4)',
                            '(-y+1/4, -z+1/4, -x+1/4)',
                            '(-y+1/4, -z+3/4, -x+3/4)',
                            '(-y+3/4, -z+1/4, -x+3/4)',
                            '(-y+3/4, -z+3/4, -x+1/4)',
                            '(y+1/4, -z+1/4, x+1/4)',
                            '(y+1/4, -z+3/4, x+3/4)',
                            '(y+3/4, -z+1/4, x+3/4)',
                            '(y+3/4, -z+3/4, x+1/4)',
                            '(-y+1/4, z+1/4, x+1/4)',
                            '(-y+1/4, z+3/4, x+3/4)',
                            '(-y+3/4, z+1/4, x+3/4)',
                            '(-y+3/4, z+3/4, x+1/4)',
                            '(y+1/4, z+1/4, -x+1/4)',
                            '(y+1/4, z+3/4, -x+3/4)',
                            '(y+3/4, z+1/4, -x+3/4)',
                            '(y+3/4, z+3/4, -x+1/4)'))},
      '203:2': {'8a': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                           '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                           '(7/8, 7/8, 7/8)', '(7/8, 3/8, 3/8)',
                           '(3/8, 7/8, 3/8)', '(3/8, 3/8, 7/8)')),
                '8b': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                           '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                           '(3/8, 3/8, 3/8)', '(3/8, 7/8, 7/8)',
                           '(7/8, 3/8, 7/8)', '(7/8, 7/8, 3/8)')),
                '16c': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(1/2, 1/2, 0)', '(3/4, 3/4, 0)',
                            '(3/4, 1/4, 1/2)', '(1/4, 3/4, 1/2)',
                            '(1/4, 1/4, 0)', '(3/4, 0, 3/4)',
                            '(3/4, 1/2, 1/4)', '(1/4, 0, 1/4)',
                            '(1/4, 1/2, 3/4)', '(0, 3/4, 3/4)',
                            '(0, 1/4, 1/4)', '(1/2, 3/4, 1/4)',
                            '(1/2, 1/4, 3/4)')),
                '16d': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                            '(0, 0, 1/2)', '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)',
                            '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                            '(1/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                            '(3/4, 1/2, 3/4)', '(3/4, 0, 1/4)',
                            '(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                            '(0, 1/4, 3/4)', '(0, 3/4, 1/4)')),
                '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x+3/4, -x+3/4, x)', '(-x+3/4, -x+1/4, x+1/2)',
                            '(-x+1/4, -x+3/4, x+1/2)', '(-x+1/4, -x+1/4, x)',
                            '(-x+3/4, x, -x+3/4)', '(-x+3/4, x+1/2, -x+1/4)',
                            '(-x+1/4, x, -x+1/4)', '(-x+1/4, x+1/2, -x+3/4)',
                            '(x, -x+3/4, -x+3/4)', '(x, -x+1/4, -x+1/4)',
                            '(x+1/2, -x+3/4, -x+1/4)',
                            '(x+1/2, -x+1/4, -x+3/4)', '(-x, -x, -x)',
                            '(-x, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x+1/2)',
                            '(-x+1/2, -x+1/2, -x)', '(x+1/4, x+1/4, -x)',
                            '(x+1/4, x+3/4, -x+1/2)',
                            '(x+3/4, x+1/4, -x+1/2)', '(x+3/4, x+3/4, -x)',
                            '(x+1/4, -x, x+1/4)', '(x+1/4, -x+1/2, x+3/4)',
                            '(x+3/4, -x, x+3/4)', '(x+3/4, -x+1/2, x+1/4)',
                            '(-x, x+1/4, x+1/4)', '(-x, x+3/4, x+3/4)',
                            '(-x+1/2, x+1/4, x+3/4)',
                            '(-x+1/2, x+3/4, x+1/4)')),
                '48f': (1, ('(x, 1/8, 1/8)', '(x, 5/8, 5/8)',
                            '(x+1/2, 1/8, 5/8)', '(x+1/2, 5/8, 1/8)',
                            '(-x+3/4, 5/8, 1/8)', '(-x+3/4, 1/8, 5/8)',
                            '(-x+1/4, 5/8, 5/8)', '(-x+1/4, 1/8, 1/8)',
                            '(1/8, x, 1/8)', '(1/8, x+1/2, 5/8)',
                            '(5/8, x, 5/8)', '(5/8, x+1/2, 1/8)',
                            '(1/8, -x+3/4, 5/8)', '(1/8, -x+1/4, 1/8)',
                            '(5/8, -x+3/4, 1/8)', '(5/8, -x+1/4, 5/8)',
                            '(1/8, 1/8, x)', '(1/8, 5/8, x+1/2)',
                            '(5/8, 1/8, x+1/2)', '(5/8, 5/8, x)',
                            '(5/8, 1/8, -x+3/4)', '(5/8, 5/8, -x+1/4)',
                            '(1/8, 1/8, -x+1/4)', '(1/8, 5/8, -x+3/4)',
                            '(-x, 7/8, 7/8)', '(-x, 3/8, 3/8)',
                            '(-x+1/2, 7/8, 3/8)', '(-x+1/2, 3/8, 7/8)',
                            '(x+1/4, 3/8, 7/8)', '(x+1/4, 7/8, 3/8)',
                            '(x+3/4, 3/8, 3/8)', '(x+3/4, 7/8, 7/8)',
                            '(7/8, -x, 7/8)', '(7/8, -x+1/2, 3/8)',
                            '(3/8, -x, 3/8)', '(3/8, -x+1/2, 7/8)',
                            '(7/8, x+1/4, 3/8)', '(7/8, x+3/4, 7/8)',
                            '(3/8, x+1/4, 7/8)', '(3/8, x+3/4, 3/8)',
                            '(7/8, 7/8, -x)', '(7/8, 3/8, -x+1/2)',
                            '(3/8, 7/8, -x+1/2)', '(3/8, 3/8, -x)',
                            '(3/8, 7/8, x+1/4)', '(3/8, 3/8, x+3/4)',
                            '(7/8, 7/8, x+3/4)', '(7/8, 3/8, x+1/4)')),
                '96g': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                            '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                            '(-x+3/4, -y+3/4, z)', '(-x+3/4, -y+1/4, z+1/2)',
                            '(-x+1/4, -y+3/4, z+1/2)', '(-x+1/4, -y+1/4, z)',
                            '(-x+3/4, y, -z+3/4)', '(-x+3/4, y+1/2, -z+1/4)',
                            '(-x+1/4, y, -z+1/4)', '(-x+1/4, y+1/2, -z+3/4)',
                            '(x, -y+3/4, -z+3/4)', '(x, -y+1/4, -z+1/4)',
                            '(x+1/2, -y+3/4, -z+1/4)',
                            '(x+1/2, -y+1/4, -z+3/4)', '(z, x, y)',
                            '(z, x+1/2, y+1/2)', '(z+1/2, x, y+1/2)',
                            '(z+1/2, x+1/2, y)', '(z, -x+3/4, -y+3/4)',
                            '(z, -x+1/4, -y+1/4)', '(z+1/2, -x+3/4, -y+1/4)',
                            '(z+1/2, -x+1/4, -y+3/4)', '(-z+3/4, -x+3/4, y)',
                            '(-z+3/4, -x+1/4, y+1/2)',
                            '(-z+1/4, -x+3/4, y+1/2)', '(-z+1/4, -x+1/4, y)',
                            '(-z+3/4, x, -y+3/4)', '(-z+3/4, x+1/2, -y+1/4)',
                            '(-z+1/4, x, -y+1/4)', '(-z+1/4, x+1/2, -y+3/4)',
                            '(y, z, x)', '(y, z+1/2, x+1/2)',
                            '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                            '(-y+3/4, z, -x+3/4)', '(-y+3/4, z+1/2, -x+1/4)',
                            '(-y+1/4, z, -x+1/4)', '(-y+1/4, z+1/2, -x+3/4)',
                            '(y, -z+3/4, -x+3/4)', '(y, -z+1/4, -x+1/4)',
                            '(y+1/2, -z+3/4, -x+1/4)',
                            '(y+1/2, -z+1/4, -x+3/4)', '(-y+3/4, -z+3/4, x)',
                            '(-y+3/4, -z+1/4, x+1/2)',
                            '(-y+1/4, -z+3/4, x+1/2)', '(-y+1/4, -z+1/4, x)',
                            '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                            '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                            '(x+1/4, y+1/4, -z)', '(x+1/4, y+3/4, -z+1/2)',
                            '(x+3/4, y+1/4, -z+1/2)', '(x+3/4, y+3/4, -z)',
                            '(x+1/4, -y, z+1/4)', '(x+1/4, -y+1/2, z+3/4)',
                            '(x+3/4, -y, z+3/4)', '(x+3/4, -y+1/2, z+1/4)',
                            '(-x, y+1/4, z+1/4)', '(-x, y+3/4, z+3/4)',
                            '(-x+1/2, y+1/4, z+3/4)',
                            '(-x+1/2, y+3/4, z+1/4)', '(-z, -x, -y)',
                            '(-z, -x+1/2, -y+1/2)', '(-z+1/2, -x, -y+1/2)',
                            '(-z+1/2, -x+1/2, -y)', '(-z, x+1/4, y+1/4)',
                            '(-z, x+3/4, y+3/4)', '(-z+1/2, x+1/4, y+3/4)',
                            '(-z+1/2, x+3/4, y+1/4)', '(z+1/4, x+1/4, -y)',
                            '(z+1/4, x+3/4, -y+1/2)',
                            '(z+3/4, x+1/4, -y+1/2)', '(z+3/4, x+3/4, -y)',
                            '(z+1/4, -x, y+1/4)', '(z+1/4, -x+1/2, y+3/4)',
                            '(z+3/4, -x, y+3/4)', '(z+3/4, -x+1/2, y+1/4)',
                            '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                            '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                            '(y+1/4, -z, x+1/4)', '(y+1/4, -z+1/2, x+3/4)',
                            '(y+3/4, -z, x+3/4)', '(y+3/4, -z+1/2, x+1/4)',
                            '(-y, z+1/4, x+1/4)', '(-y, z+3/4, x+3/4)',
                            '(-y+1/2, z+1/4, x+3/4)',
                            '(-y+1/2, z+3/4, x+1/4)', '(y+1/4, z+1/4, -x)',
                            '(y+1/4, z+3/4, -x+1/2)',
                            '(y+3/4, z+1/4, -x+1/2)', '(y+3/4, z+3/4, -x)'))},
      '204': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)')),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)')),
              '12d': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)')),
              '12e': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                          '(-x+1/2, 1/2, 0)', '(1/2, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(0, 1/2, x)',
                          '(1/2, 0, x+1/2)', '(0, 1/2, -x)',
                          '(1/2, 0, -x+1/2)')),
              '16f': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                          '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(-x, -x, -x)',
                          '(-x+1/2, -x+1/2, -x+1/2)', '(x, x, -x)',
                          '(x+1/2, x+1/2, -x+1/2)', '(x, -x, x)',
                          '(x+1/2, -x+1/2, x+1/2)', '(-x, x, x)',
                          '(-x+1/2, x+1/2, x+1/2)')),
              '24g': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                          '(1/2, -y+1/2, z+1/2)', '(0, y, -z)',
                          '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                          '(1/2, -y+1/2, -z+1/2)', '(z, 0, y)',
                          '(z+1/2, 1/2, y+1/2)', '(z, 0, -y)',
                          '(z+1/2, 1/2, -y+1/2)', '(-z, 0, y)',
                          '(-z+1/2, 1/2, y+1/2)', '(-z, 0, -y)',
                          '(-z+1/2, 1/2, -y+1/2)', '(y, z, 0)',
                          '(y+1/2, z+1/2, 1/2)', '(-y, z, 0)',
                          '(-y+1/2, z+1/2, 1/2)', '(y, -z, 0)',
                          '(y+1/2, -z+1/2, 1/2)', '(-y, -z, 0)',
                          '(-y+1/2, -z+1/2, 1/2)')),
              '48h': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-z, -x, -y)',
                          '(-z+1/2, -x+1/2, -y+1/2)', '(-z, x, y)',
                          '(-z+1/2, x+1/2, y+1/2)', '(z, x, -y)',
                          '(z+1/2, x+1/2, -y+1/2)', '(z, -x, y)',
                          '(z+1/2, -x+1/2, y+1/2)', '(-y, -z, -x)',
                          '(-y+1/2, -z+1/2, -x+1/2)', '(y, -z, x)',
                          '(y+1/2, -z+1/2, x+1/2)', '(-y, z, x)',
                          '(-y+1/2, z+1/2, x+1/2)', '(y, z, -x)',
                          '(y+1/2, z+1/2, -x+1/2)'))},
      '205': {'4a': (0, ('(0, 0, 0)', '(1/2, 0, 1/2)', '(0, 1/2, 1/2)',
                         '(1/2, 1/2, 0)')),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(0, 1/2, 0)', '(1/2, 0, 0)',
                         '(0, 0, 1/2)')),
              '8c': (1, ('(x, x, x)', '(-x+1/2, -x, x+1/2)',
                         '(-x, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                         '(-x, -x, -x)', '(x+1/2, x, -x+1/2)',
                         '(x, -x+1/2, x+1/2)', '(-x+1/2, x+1/2, x)')),
              '24d': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z+1/2, -x+1/2, -y)',
                          '(-z+1/2, -x, y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(y, z, x)', '(-y, z+1/2, -x+1/2)',
                          '(y+1/2, -z+1/2, -x)', '(-y+1/2, -z, x+1/2)',
                          '(-x, -y, -z)', '(x+1/2, y, -z+1/2)',
                          '(x, -y+1/2, z+1/2)', '(-x+1/2, y+1/2, z)',
                          '(-z, -x, -y)', '(-z+1/2, x+1/2, y)',
                          '(z+1/2, x, -y+1/2)', '(z, -x+1/2, y+1/2)',
                          '(-y, -z, -x)', '(y, -z+1/2, x+1/2)',
                          '(-y+1/2, z+1/2, x)', '(y+1/2, z, -x+1/2)'))},
      '206': {'8a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 0)',
                         '(1/2, 1/2, 0)', '(0, 0, 1/2)')),
              '8b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)')),
              '16c': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                          '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(-x, -x, -x)', '(-x+1/2, -x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x, x+1/2, -x)',
                          '(x, -x+1/2, x+1/2)', '(x+1/2, -x, x)',
                          '(-x+1/2, x+1/2, x)', '(-x, x, x+1/2)')),
              '24d': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)', '(-x, 0, 3/4)',
                          '(-x+1/2, 1/2, 1/4)', '(x+1/2, 0, 1/4)',
                          '(x, 1/2, 3/4)', '(3/4, -x, 0)',
                          '(1/4, -x+1/2, 1/2)', '(1/4, x+1/2, 0)',
                          '(3/4, x, 1/2)', '(0, 3/4, -x)',
                          '(1/2, 1/4, -x+1/2)', '(0, 1/4, x+1/2)',
                          '(1/2, 3/4, x)')),
              '48e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)',
                          '(-x, -y, -z)', '(-x+1/2, -y+1/2, -z+1/2)',
                          '(x+1/2, y, -z+1/2)', '(x, y+1/2, -z)',
                          '(x, -y+1/2, z+1/2)', '(x+1/2, -y, z)',
                          '(-x+1/2, y+1/2, z)', '(-x, y, z+1/2)',
                          '(-z, -x, -y)', '(-z+1/2, -x+1/2, -y+1/2)',
                          '(-z+1/2, x+1/2, y)', '(-z, x, y+1/2)',
                          '(z+1/2, x, -y+1/2)', '(z, x+1/2, -y)',
                          '(z, -x+1/2, y+1/2)', '(z+1/2, -x, y)',
                          '(-y, -z, -x)', '(-y+1/2, -z+1/2, -x+1/2)',
                          '(y, -z+1/2, x+1/2)', '(y+1/2, -z, x)',
                          '(-y+1/2, z+1/2, x)', '(-y, z, x+1/2)',
                          '(y+1/2, z, -x+1/2)', '(y, z+1/2, -x)'))},
      '207': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(1/2, 1/2, 1/2)', )),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)')),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
              '6e': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)')),
              '6f': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'
                         )),
              '8g': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(x, x, -x)', '(-x, -x, -x)',
                         '(x, -x, x)', '(-x, x, x)')),
              '12h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(1/2, x, 0)', '(1/2, -x, 0)', '(x, 0, 1/2)',
                          '(-x, 0, 1/2)', '(0, 1/2, -x)', '(0, 1/2, x)')),
              '12i': (2, ('(0, y, y)', '(0, -y, y)', '(0, y, -y)',
                          '(0, -y, -y)', '(y, 0, y)', '(y, 0, -y)',
                          '(-y, 0, y)', '(-y, 0, -y)', '(y, y, 0)',
                          '(-y, y, 0)', '(y, -y, 0)', '(-y, -y, 0)')),
              '12j': (2, ('(1/2, y, y)', '(1/2, -y, y)', '(1/2, y, -y)',
                          '(1/2, -y, -y)', '(y, 1/2, y)', '(y, 1/2, -y)',
                          '(-y, 1/2, y)', '(-y, 1/2, -y)', '(y, y, 1/2)',
                          '(-y, y, 1/2)', '(y, -y, 1/2)', '(-y, -y, 1/2)')),
              '24k': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y, x, -z)', '(-y, -x, -z)', '(y, -x, z)',
                          '(-y, x, z)', '(x, z, -y)', '(-x, z, y)',
                          '(-x, -z, -y)', '(x, -z, y)', '(z, y, -x)',
                          '(z, -y, x)', '(-z, y, x)', '(-z, -y, -x)'))},
      '208': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '4b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)')),
              '4c': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                         '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)')),
              '6d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)')),
              '6e': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                         '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)')),
              '6f': (0, ('(1/4, 1/2, 0)', '(3/4, 1/2, 0)', '(0, 1/4, 1/2)',
                         '(0, 3/4, 1/2)', '(1/2, 0, 1/4)', '(1/2, 0, 3/4)')),
              '8g': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(x+1/2, x+1/2, -x+1/2)',
                         '(-x+1/2, -x+1/2, -x+1/2)', '(x+1/2, -x+1/2, x+1/2)',
                         '(-x+1/2, x+1/2, x+1/2)')),
              '12h': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                          '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)')),
              '12i': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                          '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                          '(1/2, x+1/2, 0)', '(1/2, -x+1/2, 0)',
                          '(x+1/2, 0, 1/2)', '(-x+1/2, 0, 1/2)',
                          '(0, 1/2, -x+1/2)', '(0, 1/2, x+1/2)')),
              '12j': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(0, x+1/2, 1/2)', '(0, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x+1/2, 1/2, 0)',
                          '(1/2, 0, -x+1/2)', '(1/2, 0, x+1/2)')),
              '12k': (2, ('(1/4, y, -y+1/2)', '(3/4, -y, -y+1/2)',
                          '(3/4, y, y+1/2)', '(1/4, -y, y+1/2)',
                          '(-y+1/2, 1/4, y)', '(-y+1/2, 3/4, -y)',
                          '(y+1/2, 3/4, y)', '(y+1/2, 1/4, -y)',
                          '(y, -y+1/2, 1/4)', '(-y, -y+1/2, 3/4)',
                          '(y, y+1/2, 3/4)', '(-y, y+1/2, 1/4)')),
              '12l': (2, ('(1/4, y, y+1/2)', '(3/4, -y, y+1/2)',
                          '(3/4, y, -y+1/2)', '(1/4, -y, -y+1/2)',
                          '(y+1/2, 1/4, y)', '(y+1/2, 3/4, -y)',
                          '(-y+1/2, 3/4, y)', '(-y+1/2, 1/4, -y)',
                          '(y, y+1/2, 1/4)', '(-y, y+1/2, 3/4)',
                          '(y, -y+1/2, 3/4)', '(-y, -y+1/2, 1/4)')),
              '24m': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y+1/2, x+1/2, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z+1/2)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-y+1/2, x+1/2, z+1/2)',
                          '(x+1/2, z+1/2, -y+1/2)', '(-x+1/2, z+1/2, y+1/2)',
                          '(-x+1/2, -z+1/2, -y+1/2)',
                          '(x+1/2, -z+1/2, y+1/2)', '(z+1/2, y+1/2, -x+1/2)',
                          '(z+1/2, -y+1/2, x+1/2)', '(-z+1/2, y+1/2, x+1/2)',
                          '(-z+1/2, -y+1/2, -x+1/2)'))},
      '209': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)')),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)')),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(1/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(3/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
              '24d': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)')),
              '24e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)')),
              '32f': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x, x, -x)', '(x, x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x+1/2, x+1/2, -x)',
                          '(-x, -x, -x)', '(-x, -x+1/2, -x+1/2)',
                          '(-x+1/2, -x, -x+1/2)', '(-x+1/2, -x+1/2, -x)',
                          '(x, -x, x)', '(x, -x+1/2, x+1/2)',
                          '(x+1/2, -x, x+1/2)', '(x+1/2, -x+1/2, x)',
                          '(-x, x, x)', '(-x, x+1/2, x+1/2)',
                          '(-x+1/2, x, x+1/2)', '(-x+1/2, x+1/2, x)')),
              '48g': (2, ('(0, y, y)', '(0, y+1/2, y+1/2)', '(1/2, y, y+1/2)',
                          '(1/2, y+1/2, y)', '(0, -y, y)',
                          '(0, -y+1/2, y+1/2)', '(1/2, -y, y+1/2)',
                          '(1/2, -y+1/2, y)', '(0, y, -y)',
                          '(0, y+1/2, -y+1/2)', '(1/2, y, -y+1/2)',
                          '(1/2, y+1/2, -y)', '(0, -y, -y)',
                          '(0, -y+1/2, -y+1/2)', '(1/2, -y, -y+1/2)',
                          '(1/2, -y+1/2, -y)', '(y, 0, y)', '(y, 1/2, y+1/2)',
                          '(y+1/2, 0, y+1/2)', '(y+1/2, 1/2, y)',
                          '(y, 0, -y)', '(y, 1/2, -y+1/2)',
                          '(y+1/2, 0, -y+1/2)', '(y+1/2, 1/2, -y)',
                          '(-y, 0, y)', '(-y, 1/2, y+1/2)',
                          '(-y+1/2, 0, y+1/2)', '(-y+1/2, 1/2, y)',
                          '(-y, 0, -y)', '(-y, 1/2, -y+1/2)',
                          '(-y+1/2, 0, -y+1/2)', '(-y+1/2, 1/2, -y)',
                          '(y, y, 0)', '(y, y+1/2, 1/2)', '(y+1/2, y, 1/2)',
                          '(y+1/2, y+1/2, 0)', '(-y, y, 0)',
                          '(-y, y+1/2, 1/2)', '(-y+1/2, y, 1/2)',
                          '(-y+1/2, y+1/2, 0)', '(y, -y, 0)',
                          '(y, -y+1/2, 1/2)', '(y+1/2, -y, 1/2)',
                          '(y+1/2, -y+1/2, 0)', '(-y, -y, 0)',
                          '(-y, -y+1/2, 1/2)', '(-y+1/2, -y, 1/2)',
                          '(-y+1/2, -y+1/2, 0)')),
              '48h': (2, ('(1/2, y, y)', '(1/2, y+1/2, y+1/2)',
                          '(0, y, y+1/2)', '(0, y+1/2, y)', '(1/2, -y, y)',
                          '(1/2, -y+1/2, y+1/2)', '(0, -y, y+1/2)',
                          '(0, -y+1/2, y)', '(1/2, y, -y)',
                          '(1/2, y+1/2, -y+1/2)', '(0, y, -y+1/2)',
                          '(0, y+1/2, -y)', '(1/2, -y, -y)',
                          '(1/2, -y+1/2, -y+1/2)', '(0, -y, -y+1/2)',
                          '(0, -y+1/2, -y)', '(y, 1/2, y)', '(y, 0, y+1/2)',
                          '(y+1/2, 1/2, y+1/2)', '(y+1/2, 0, y)',
                          '(y, 1/2, -y)', '(y, 0, -y+1/2)',
                          '(y+1/2, 1/2, -y+1/2)', '(y+1/2, 0, -y)',
                          '(-y, 1/2, y)', '(-y, 0, y+1/2)',
                          '(-y+1/2, 1/2, y+1/2)', '(-y+1/2, 0, y)',
                          '(-y, 1/2, -y)', '(-y, 0, -y+1/2)',
                          '(-y+1/2, 1/2, -y+1/2)', '(-y+1/2, 0, -y)',
                          '(y, y, 1/2)', '(y, y+1/2, 0)', '(y+1/2, y, 0)',
                          '(y+1/2, y+1/2, 1/2)', '(-y, y, 1/2)',
                          '(-y, y+1/2, 0)', '(-y+1/2, y, 0)',
                          '(-y+1/2, y+1/2, 1/2)', '(y, -y, 1/2)',
                          '(y, -y+1/2, 0)', '(y+1/2, -y, 0)',
                          '(y+1/2, -y+1/2, 1/2)', '(-y, -y, 1/2)',
                          '(-y, -y+1/2, 0)', '(-y+1/2, -y, 0)',
                          '(-y+1/2, -y+1/2, 1/2)')),
              '48i': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(1/4, x, 3/4)', '(1/4, x+1/2, 1/4)',
                          '(3/4, x, 1/4)', '(3/4, x+1/2, 3/4)',
                          '(3/4, -x, 3/4)', '(3/4, -x+1/2, 1/4)',
                          '(1/4, -x, 1/4)', '(1/4, -x+1/2, 3/4)',
                          '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                          '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)',
                          '(-x, 1/4, 1/4)', '(-x, 3/4, 3/4)',
                          '(-x+1/2, 1/4, 3/4)', '(-x+1/2, 3/4, 1/4)',
                          '(1/4, 1/4, -x)', '(1/4, 3/4, -x+1/2)',
                          '(3/4, 1/4, -x+1/2)', '(3/4, 3/4, -x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)')),
              '96j': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                          '(y, x, -z)', '(y, x+1/2, -z+1/2)',
                          '(y+1/2, x, -z+1/2)', '(y+1/2, x+1/2, -z)',
                          '(-y, -x, -z)', '(-y, -x+1/2, -z+1/2)',
                          '(-y+1/2, -x, -z+1/2)', '(-y+1/2, -x+1/2, -z)',
                          '(y, -x, z)', '(y, -x+1/2, z+1/2)',
                          '(y+1/2, -x, z+1/2)', '(y+1/2, -x+1/2, z)',
                          '(-y, x, z)', '(-y, x+1/2, z+1/2)',
                          '(-y+1/2, x, z+1/2)', '(-y+1/2, x+1/2, z)',
                          '(x, z, -y)', '(x, z+1/2, -y+1/2)',
                          '(x+1/2, z, -y+1/2)', '(x+1/2, z+1/2, -y)',
                          '(-x, z, y)', '(-x, z+1/2, y+1/2)',
                          '(-x+1/2, z, y+1/2)', '(-x+1/2, z+1/2, y)',
                          '(-x, -z, -y)', '(-x, -z+1/2, -y+1/2)',
                          '(-x+1/2, -z, -y+1/2)', '(-x+1/2, -z+1/2, -y)',
                          '(x, -z, y)', '(x, -z+1/2, y+1/2)',
                          '(x+1/2, -z, y+1/2)', '(x+1/2, -z+1/2, y)',
                          '(z, y, -x)', '(z, y+1/2, -x+1/2)',
                          '(z+1/2, y, -x+1/2)', '(z+1/2, y+1/2, -x)',
                          '(z, -y, x)', '(z, -y+1/2, x+1/2)',
                          '(z+1/2, -y, x+1/2)', '(z+1/2, -y+1/2, x)',
                          '(-z, y, x)', '(-z, y+1/2, x+1/2)',
                          '(-z+1/2, y, x+1/2)', '(-z+1/2, y+1/2, x)',
                          '(-z, -y, -x)', '(-z, -y+1/2, -x+1/2)',
                          '(-z+1/2, -y, -x+1/2)', '(-z+1/2, -y+1/2, -x)'))},
      '210': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)', '(3/4, 1/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 1/4)',
                         '(1/4, 3/4, 3/4)')),
              '8b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)', '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)')),
              '16c': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                          '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                          '(7/8, 3/8, 5/8)', '(7/8, 7/8, 1/8)',
                          '(3/8, 3/8, 1/8)', '(3/8, 7/8, 5/8)',
                          '(3/8, 5/8, 7/8)', '(3/8, 1/8, 3/8)',
                          '(7/8, 5/8, 3/8)', '(7/8, 1/8, 7/8)',
                          '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)',
                          '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)')),
              '16d': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                          '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                          '(3/8, 7/8, 1/8)', '(3/8, 3/8, 5/8)',
                          '(7/8, 7/8, 5/8)', '(7/8, 3/8, 1/8)',
                          '(7/8, 1/8, 3/8)', '(7/8, 5/8, 7/8)',
                          '(3/8, 1/8, 7/8)', '(3/8, 5/8, 3/8)',
                          '(1/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)',
                          '(5/8, 3/8, 3/8)', '(5/8, 7/8, 7/8)')),
              '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x+1/2, x+1/2)', '(-x, -x, x)',
                          '(-x+1/2, -x+1/2, x)', '(-x+1/2, -x, x+1/2)',
                          '(-x+1/2, x+1/2, -x)', '(-x+1/2, x, -x+1/2)',
                          '(-x, x+1/2, -x+1/2)', '(-x, x, -x)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+3/4, x+1/4, -x+3/4)', '(x+3/4, x+3/4, -x+1/4)',
                          '(x+1/4, x+1/4, -x+1/4)', '(x+1/4, x+3/4, -x+3/4)',
                          '(-x+1/4, -x+1/4, -x+1/4)',
                          '(-x+1/4, -x+3/4, -x+3/4)',
                          '(-x+3/4, -x+1/4, -x+3/4)',
                          '(-x+3/4, -x+3/4, -x+1/4)',
                          '(x+1/4, -x+3/4, x+3/4)', '(x+1/4, -x+1/4, x+1/4)',
                          '(x+3/4, -x+3/4, x+1/4)', '(x+3/4, -x+1/4, x+3/4)',
                          '(-x+3/4, x+3/4, x+1/4)', '(-x+3/4, x+1/4, x+3/4)',
                          '(-x+1/4, x+3/4, x+3/4)', '(-x+1/4, x+1/4, x+1/4)'
                          )),
              '48f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 0)', '(-x+1/2, 0, 1/2)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(1/2, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(0, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(0, 0, x)', '(0, 1/2, x+1/2)',
                          '(1/2, 0, x+1/2)', '(1/2, 1/2, x)',
                          '(1/2, 1/2, -x)', '(1/2, 0, -x+1/2)',
                          '(0, 1/2, -x+1/2)', '(0, 0, -x)',
                          '(3/4, x+1/4, 3/4)', '(3/4, x+3/4, 1/4)',
                          '(1/4, x+1/4, 1/4)', '(1/4, x+3/4, 3/4)',
                          '(1/4, -x+1/4, 1/4)', '(1/4, -x+3/4, 3/4)',
                          '(3/4, -x+1/4, 3/4)', '(3/4, -x+3/4, 1/4)',
                          '(x+3/4, 1/4, 3/4)', '(x+3/4, 3/4, 1/4)',
                          '(x+1/4, 1/4, 1/4)', '(x+1/4, 3/4, 3/4)',
                          '(-x+3/4, 3/4, 1/4)', '(-x+3/4, 1/4, 3/4)',
                          '(-x+1/4, 3/4, 3/4)', '(-x+1/4, 1/4, 1/4)',
                          '(3/4, 1/4, -x+3/4)', '(3/4, 3/4, -x+1/4)',
                          '(1/4, 1/4, -x+1/4)', '(1/4, 3/4, -x+3/4)',
                          '(1/4, 3/4, x+3/4)', '(1/4, 1/4, x+1/4)',
                          '(3/4, 3/4, x+1/4)', '(3/4, 1/4, x+3/4)')),
              '48g': (2, ('(1/8, y, -y+1/4)', '(1/8, y+1/2, -y+3/4)',
                          '(5/8, y, -y+3/4)', '(5/8, y+1/2, -y+1/4)',
                          '(7/8, -y+1/2, -y+3/4)', '(7/8, -y, -y+1/4)',
                          '(3/8, -y+1/2, -y+1/4)', '(3/8, -y, -y+3/4)',
                          '(3/8, y+1/2, y+3/4)', '(3/8, y, y+1/4)',
                          '(7/8, y+1/2, y+1/4)', '(7/8, y, y+3/4)',
                          '(5/8, -y, y+1/4)', '(5/8, -y+1/2, y+3/4)',
                          '(1/8, -y, y+3/4)', '(1/8, -y+1/2, y+1/4)',
                          '(-y+1/4, 1/8, y)', '(-y+1/4, 5/8, y+1/2)',
                          '(-y+3/4, 1/8, y+1/2)', '(-y+3/4, 5/8, y)',
                          '(-y+3/4, 7/8, -y+1/2)', '(-y+3/4, 3/8, -y)',
                          '(-y+1/4, 7/8, -y)', '(-y+1/4, 3/8, -y+1/2)',
                          '(y+3/4, 3/8, y+1/2)', '(y+3/4, 7/8, y)',
                          '(y+1/4, 3/8, y)', '(y+1/4, 7/8, y+1/2)',
                          '(y+1/4, 5/8, -y)', '(y+1/4, 1/8, -y+1/2)',
                          '(y+3/4, 5/8, -y+1/2)', '(y+3/4, 1/8, -y)',
                          '(y, -y+1/4, 1/8)', '(y, -y+3/4, 5/8)',
                          '(y+1/2, -y+1/4, 5/8)', '(y+1/2, -y+3/4, 1/8)',
                          '(-y+1/2, -y+3/4, 7/8)', '(-y+1/2, -y+1/4, 3/8)',
                          '(-y, -y+3/4, 3/8)', '(-y, -y+1/4, 7/8)',
                          '(y+1/2, y+3/4, 3/8)', '(y+1/2, y+1/4, 7/8)',
                          '(y, y+3/4, 7/8)', '(y, y+1/4, 3/8)',
                          '(-y, y+1/4, 5/8)', '(-y, y+3/4, 1/8)',
                          '(-y+1/2, y+1/4, 1/8)', '(-y+1/2, y+3/4, 5/8)')),
              '96h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x+1/2, y+1/2, -z)', '(-x+1/2, y, -z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(-x, y, -z)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z, x+1/2, y+1/2)', '(z+1/2, x, y+1/2)',
                          '(z+1/2, x+1/2, y)', '(z+1/2, -x, -y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y)',
                          '(z, -x+1/2, -y+1/2)', '(-z, -x+1/2, y+1/2)',
                          '(-z, -x, y)', '(-z+1/2, -x+1/2, y)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(-z+1/2, x, -y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(-z, x, -y)', '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y+1/2, z+1/2, -x)', '(-y+1/2, z, -x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y, z, -x)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(-y, -z+1/2, x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x)', '(-y+1/2, -z, x+1/2)',
                          '(y+3/4, x+1/4, -z+3/4)', '(y+3/4, x+3/4, -z+1/4)',
                          '(y+1/4, x+1/4, -z+1/4)', '(y+1/4, x+3/4, -z+3/4)',
                          '(-y+1/4, -x+1/4, -z+1/4)',
                          '(-y+1/4, -x+3/4, -z+3/4)',
                          '(-y+3/4, -x+1/4, -z+3/4)',
                          '(-y+3/4, -x+3/4, -z+1/4)',
                          '(y+1/4, -x+3/4, z+3/4)', '(y+1/4, -x+1/4, z+1/4)',
                          '(y+3/4, -x+3/4, z+1/4)', '(y+3/4, -x+1/4, z+3/4)',
                          '(-y+3/4, x+3/4, z+1/4)', '(-y+3/4, x+1/4, z+3/4)',
                          '(-y+1/4, x+3/4, z+3/4)', '(-y+1/4, x+1/4, z+1/4)',
                          '(x+3/4, z+1/4, -y+3/4)', '(x+3/4, z+3/4, -y+1/4)',
                          '(x+1/4, z+1/4, -y+1/4)', '(x+1/4, z+3/4, -y+3/4)',
                          '(-x+3/4, z+3/4, y+1/4)', '(-x+3/4, z+1/4, y+3/4)',
                          '(-x+1/4, z+3/4, y+3/4)', '(-x+1/4, z+1/4, y+1/4)',
                          '(-x+1/4, -z+1/4, -y+1/4)',
                          '(-x+1/4, -z+3/4, -y+3/4)',
                          '(-x+3/4, -z+1/4, -y+3/4)',
                          '(-x+3/4, -z+3/4, -y+1/4)',
                          '(x+1/4, -z+3/4, y+3/4)', '(x+1/4, -z+1/4, y+1/4)',
                          '(x+3/4, -z+3/4, y+1/4)', '(x+3/4, -z+1/4, y+3/4)',
                          '(z+3/4, y+1/4, -x+3/4)', '(z+3/4, y+3/4, -x+1/4)',
                          '(z+1/4, y+1/4, -x+1/4)', '(z+1/4, y+3/4, -x+3/4)',
                          '(z+1/4, -y+3/4, x+3/4)', '(z+1/4, -y+1/4, x+1/4)',
                          '(z+3/4, -y+3/4, x+1/4)', '(z+3/4, -y+1/4, x+3/4)',
                          '(-z+3/4, y+3/4, x+1/4)', '(-z+3/4, y+1/4, x+3/4)',
                          '(-z+1/4, y+3/4, x+3/4)', '(-z+1/4, y+1/4, x+1/4)',
                          '(-z+1/4, -y+1/4, -x+1/4)',
                          '(-z+1/4, -y+3/4, -x+3/4)',
                          '(-z+3/4, -y+1/4, -x+3/4)',
                          '(-z+3/4, -y+3/4, -x+1/4)'))},
      '211': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)')),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)')),
              '12d': (0, ('(1/4, 1/2, 0)', '(3/4, 0, 1/2)', '(3/4, 1/2, 0)',
                          '(1/4, 0, 1/2)', '(0, 1/4, 1/2)', '(1/2, 3/4, 0)',
                          '(0, 3/4, 1/2)', '(1/2, 1/4, 0)', '(1/2, 0, 1/4)',
                          '(0, 1/2, 3/4)', '(1/2, 0, 3/4)', '(0, 1/2, 1/4)')),
              '12e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)')),
              '16f': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                          '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(x, x, -x)',
                          '(x+1/2, x+1/2, -x+1/2)', '(-x, -x, -x)',
                          '(-x+1/2, -x+1/2, -x+1/2)', '(x, -x, x)',
                          '(x+1/2, -x+1/2, x+1/2)', '(-x, x, x)',
                          '(-x+1/2, x+1/2, x+1/2)')),
              '24g': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                          '(-x+1/2, 0, 1/2)', '(0, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(1/2, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x+1/2)', '(1/2, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(x, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                          '(-x+1/2, 1/2, 0)', '(0, 1/2, -x)',
                          '(1/2, 0, -x+1/2)', '(0, 1/2, x)',
                          '(1/2, 0, x+1/2)')),
              '24h': (2, ('(0, y, y)', '(1/2, y+1/2, y+1/2)', '(0, -y, y)',
                          '(1/2, -y+1/2, y+1/2)', '(0, y, -y)',
                          '(1/2, y+1/2, -y+1/2)', '(0, -y, -y)',
                          '(1/2, -y+1/2, -y+1/2)', '(y, 0, y)',
                          '(y+1/2, 1/2, y+1/2)', '(y, 0, -y)',
                          '(y+1/2, 1/2, -y+1/2)', '(-y, 0, y)',
                          '(-y+1/2, 1/2, y+1/2)', '(-y, 0, -y)',
                          '(-y+1/2, 1/2, -y+1/2)', '(y, y, 0)',
                          '(y+1/2, y+1/2, 1/2)', '(-y, y, 0)',
                          '(-y+1/2, y+1/2, 1/2)', '(y, -y, 0)',
                          '(y+1/2, -y+1/2, 1/2)', '(-y, -y, 0)',
                          '(-y+1/2, -y+1/2, 1/2)')),
              '24i': (2, ('(1/4, y, -y+1/2)', '(3/4, y+1/2, -y)',
                          '(3/4, -y, -y+1/2)', '(1/4, -y+1/2, -y)',
                          '(3/4, y, y+1/2)', '(1/4, y+1/2, y)',
                          '(1/4, -y, y+1/2)', '(3/4, -y+1/2, y)',
                          '(-y+1/2, 1/4, y)', '(-y, 3/4, y+1/2)',
                          '(-y+1/2, 3/4, -y)', '(-y, 1/4, -y+1/2)',
                          '(y+1/2, 3/4, y)', '(y, 1/4, y+1/2)',
                          '(y+1/2, 1/4, -y)', '(y, 3/4, -y+1/2)',
                          '(y, -y+1/2, 1/4)', '(y+1/2, -y, 3/4)',
                          '(-y, -y+1/2, 3/4)', '(-y+1/2, -y, 1/4)',
                          '(y, y+1/2, 3/4)', '(y+1/2, y, 1/4)',
                          '(-y, y+1/2, 1/4)', '(-y+1/2, y, 3/4)')),
              '48j': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)', '(y, x, -z)',
                          '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(x, z, -y)',
                          '(x+1/2, z+1/2, -y+1/2)', '(-x, z, y)',
                          '(-x+1/2, z+1/2, y+1/2)', '(-x, -z, -y)',
                          '(-x+1/2, -z+1/2, -y+1/2)', '(x, -z, y)',
                          '(x+1/2, -z+1/2, y+1/2)', '(z, y, -x)',
                          '(z+1/2, y+1/2, -x+1/2)', '(z, -y, x)',
                          '(z+1/2, -y+1/2, x+1/2)', '(-z, y, x)',
                          '(-z+1/2, y+1/2, x+1/2)', '(-z, -y, -x)',
                          '(-z+1/2, -y+1/2, -x+1/2)'))},
      '212': {'4a': (0, ('(1/8, 1/8, 1/8)', '(3/8, 7/8, 5/8)',
                         '(7/8, 5/8, 3/8)', '(5/8, 3/8, 7/8)')),
              '4b': (0, ('(5/8, 5/8, 5/8)', '(7/8, 3/8, 1/8)',
                         '(3/8, 1/8, 7/8)', '(1/8, 7/8, 3/8)')),
              '8c': (1, ('(x, x, x)', '(-x+1/2, -x, x+1/2)',
                         '(-x, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                         '(x+1/4, x+3/4, -x+3/4)', '(-x+1/4, -x+1/4, -x+1/4)',
                         '(x+3/4, -x+3/4, x+1/4)', '(-x+3/4, x+1/4, x+3/4)')),
              '12d': (2, ('(1/8, y, -y+1/4)', '(3/8, -y, -y+3/4)',
                          '(7/8, y+1/2, y+1/4)', '(5/8, -y+1/2, y+3/4)',
                          '(-y+1/4, 1/8, y)', '(-y+3/4, 3/8, -y)',
                          '(y+1/4, 7/8, y+1/2)', '(y+3/4, 5/8, -y+1/2)',
                          '(y, -y+1/4, 1/8)', '(-y, -y+3/4, 3/8)',
                          '(y+1/2, y+1/4, 7/8)', '(-y+1/2, y+3/4, 5/8)')),
              '24e': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z+1/2, -x+1/2, -y)',
                          '(-z+1/2, -x, y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(y, z, x)', '(-y, z+1/2, -x+1/2)',
                          '(y+1/2, -z+1/2, -x)', '(-y+1/2, -z, x+1/2)',
                          '(y+1/4, x+3/4, -z+3/4)',
                          '(-y+1/4, -x+1/4, -z+1/4)',
                          '(y+3/4, -x+3/4, z+1/4)', '(-y+3/4, x+1/4, z+3/4)',
                          '(x+1/4, z+3/4, -y+3/4)', '(-x+3/4, z+1/4, y+3/4)',
                          '(-x+1/4, -z+1/4, -y+1/4)',
                          '(x+3/4, -z+3/4, y+1/4)', '(z+1/4, y+3/4, -x+3/4)',
                          '(z+3/4, -y+3/4, x+1/4)', '(-z+3/4, y+1/4, x+3/4)',
                          '(-z+1/4, -y+1/4, -x+1/4)'))},
      '213': {'4a': (0, ('(3/8, 3/8, 3/8)', '(1/8, 5/8, 7/8)',
                         '(5/8, 7/8, 1/8)', '(7/8, 1/8, 5/8)')),
              '4b': (0, ('(7/8, 7/8, 7/8)', '(5/8, 1/8, 3/8)',
                         '(1/8, 3/8, 5/8)', '(3/8, 5/8, 1/8)')),
              '8c': (1, ('(x, x, x)', '(-x+1/2, -x, x+1/2)',
                         '(-x, x+1/2, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                         '(x+3/4, x+1/4, -x+1/4)', '(-x+3/4, -x+3/4, -x+3/4)',
                         '(x+1/4, -x+1/4, x+3/4)', '(-x+1/4, x+3/4, x+1/4)')),
              '12d': (2, ('(1/8, y, y+1/4)', '(3/8, -y, y+3/4)',
                          '(7/8, y+1/2, -y+1/4)', '(5/8, -y+1/2, -y+3/4)',
                          '(y+1/4, 1/8, y)', '(y+3/4, 3/8, -y)',
                          '(-y+1/4, 7/8, y+1/2)', '(-y+3/4, 5/8, -y+1/2)',
                          '(y, y+1/4, 1/8)', '(-y, y+3/4, 3/8)',
                          '(y+1/2, -y+1/4, 7/8)', '(-y+1/2, -y+3/4, 5/8)')),
              '24e': (7, ('(x, y, z)', '(-x+1/2, -y, z+1/2)',
                          '(-x, y+1/2, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z+1/2, -x+1/2, -y)',
                          '(-z+1/2, -x, y+1/2)', '(-z, x+1/2, -y+1/2)',
                          '(y, z, x)', '(-y, z+1/2, -x+1/2)',
                          '(y+1/2, -z+1/2, -x)', '(-y+1/2, -z, x+1/2)',
                          '(y+3/4, x+1/4, -z+1/4)',
                          '(-y+3/4, -x+3/4, -z+3/4)',
                          '(y+1/4, -x+1/4, z+3/4)', '(-y+1/4, x+3/4, z+1/4)',
                          '(x+3/4, z+1/4, -y+1/4)', '(-x+1/4, z+3/4, y+1/4)',
                          '(-x+3/4, -z+3/4, -y+3/4)',
                          '(x+1/4, -z+1/4, y+3/4)', '(z+3/4, y+1/4, -x+1/4)',
                          '(z+1/4, -y+1/4, x+3/4)', '(-z+1/4, y+3/4, x+1/4)',
                          '(-z+3/4, -y+3/4, -x+3/4)'))},
      '214': {'8a': (0, ('(1/8, 1/8, 1/8)', '(5/8, 5/8, 5/8)',
                         '(3/8, 7/8, 5/8)', '(7/8, 3/8, 1/8)',
                         '(7/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                         '(5/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)')),
              '8b': (0, ('(7/8, 7/8, 7/8)', '(3/8, 3/8, 3/8)',
                         '(5/8, 1/8, 3/8)', '(1/8, 5/8, 7/8)',
                         '(1/8, 3/8, 5/8)', '(5/8, 7/8, 1/8)',
                         '(3/8, 5/8, 1/8)', '(7/8, 1/8, 5/8)')),
              '12c': (0, ('(1/8, 0, 1/4)', '(5/8, 1/2, 3/4)', '(3/8, 0, 3/4)',
                          '(7/8, 1/2, 1/4)', '(1/4, 1/8, 0)',
                          '(3/4, 5/8, 1/2)', '(3/4, 3/8, 0)',
                          '(1/4, 7/8, 1/2)', '(0, 1/4, 1/8)',
                          '(1/2, 3/4, 5/8)', '(0, 3/4, 3/8)',
                          '(1/2, 1/4, 7/8)')),
              '12d': (0, ('(5/8, 0, 1/4)', '(1/8, 1/2, 3/4)', '(7/8, 0, 3/4)',
                          '(3/8, 1/2, 1/4)', '(1/4, 5/8, 0)',
                          '(3/4, 1/8, 1/2)', '(3/4, 7/8, 0)',
                          '(1/4, 3/8, 1/2)', '(0, 1/4, 5/8)',
                          '(1/2, 3/4, 1/8)', '(0, 3/4, 7/8)',
                          '(1/2, 1/4, 3/8)')),
              '16e': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                          '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(x+3/4, x+1/4, -x+1/4)', '(x+1/4, x+3/4, -x+3/4)',
                          '(-x+3/4, -x+3/4, -x+3/4)',
                          '(-x+1/4, -x+1/4, -x+1/4)',
                          '(x+1/4, -x+1/4, x+3/4)', '(x+3/4, -x+3/4, x+1/4)',
                          '(-x+1/4, x+3/4, x+1/4)', '(-x+3/4, x+1/4, x+3/4)'
                          )),
              '24f': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)', '(3/4, x+1/4, 0)',
                          '(1/4, x+3/4, 1/2)', '(3/4, -x+3/4, 1/2)',
                          '(1/4, -x+1/4, 0)', '(x+3/4, 1/2, 1/4)',
                          '(x+1/4, 0, 3/4)', '(-x+1/4, 0, 1/4)',
                          '(-x+3/4, 1/2, 3/4)', '(0, 1/4, -x+1/4)',
                          '(1/2, 3/4, -x+3/4)', '(1/2, 1/4, x+3/4)',
                          '(0, 3/4, x+1/4)')),
              '24g': (2, ('(1/8, y, y+1/4)', '(5/8, y+1/2, y+3/4)',
                          '(3/8, -y, y+3/4)', '(7/8, -y+1/2, y+1/4)',
                          '(7/8, y+1/2, -y+1/4)', '(3/8, y, -y+3/4)',
                          '(5/8, -y+1/2, -y+3/4)', '(1/8, -y, -y+1/4)',
                          '(y+1/4, 1/8, y)', '(y+3/4, 5/8, y+1/2)',
                          '(y+3/4, 3/8, -y)', '(y+1/4, 7/8, -y+1/2)',
                          '(-y+1/4, 7/8, y+1/2)', '(-y+3/4, 3/8, y)',
                          '(-y+3/4, 5/8, -y+1/2)', '(-y+1/4, 1/8, -y)',
                          '(y, y+1/4, 1/8)', '(y+1/2, y+3/4, 5/8)',
                          '(-y, y+3/4, 3/8)', '(-y+1/2, y+1/4, 7/8)',
                          '(y+1/2, -y+1/4, 7/8)', '(y, -y+3/4, 3/8)',
                          '(-y+1/2, -y+3/4, 5/8)', '(-y, -y+1/4, 1/8)')),
              '24h': (2, ('(1/8, y, -y+1/4)', '(5/8, y+1/2, -y+3/4)',
                          '(3/8, -y, -y+3/4)', '(7/8, -y+1/2, -y+1/4)',
                          '(7/8, y+1/2, y+1/4)', '(3/8, y, y+3/4)',
                          '(5/8, -y+1/2, y+3/4)', '(1/8, -y, y+1/4)',
                          '(-y+1/4, 1/8, y)', '(-y+3/4, 5/8, y+1/2)',
                          '(-y+3/4, 3/8, -y)', '(-y+1/4, 7/8, -y+1/2)',
                          '(y+1/4, 7/8, y+1/2)', '(y+3/4, 3/8, y)',
                          '(y+3/4, 5/8, -y+1/2)', '(y+1/4, 1/8, -y)',
                          '(y, -y+1/4, 1/8)', '(y+1/2, -y+3/4, 5/8)',
                          '(-y, -y+3/4, 3/8)', '(-y+1/2, -y+1/4, 7/8)',
                          '(y+1/2, y+1/4, 7/8)', '(y, y+3/4, 3/8)',
                          '(-y+1/2, y+3/4, 5/8)', '(-y, y+1/4, 1/8)')),
              '48i': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)',
                          '(y+3/4, x+1/4, -z+1/4)', '(y+1/4, x+3/4, -z+3/4)',
                          '(-y+3/4, -x+3/4, -z+3/4)',
                          '(-y+1/4, -x+1/4, -z+1/4)',
                          '(y+1/4, -x+1/4, z+3/4)', '(y+3/4, -x+3/4, z+1/4)',
                          '(-y+1/4, x+3/4, z+1/4)', '(-y+3/4, x+1/4, z+3/4)',
                          '(x+3/4, z+1/4, -y+1/4)', '(x+1/4, z+3/4, -y+3/4)',
                          '(-x+1/4, z+3/4, y+1/4)', '(-x+3/4, z+1/4, y+3/4)',
                          '(-x+3/4, -z+3/4, -y+3/4)',
                          '(-x+1/4, -z+1/4, -y+1/4)',
                          '(x+1/4, -z+1/4, y+3/4)', '(x+3/4, -z+3/4, y+1/4)',
                          '(z+3/4, y+1/4, -x+1/4)', '(z+1/4, y+3/4, -x+3/4)',
                          '(z+1/4, -y+1/4, x+3/4)', '(z+3/4, -y+3/4, x+1/4)',
                          '(-z+1/4, y+3/4, x+1/4)', '(-z+3/4, y+1/4, x+3/4)',
                          '(-z+3/4, -y+3/4, -x+3/4)',
                          '(-z+1/4, -y+1/4, -x+1/4)'))},
      '215': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(1/2, 1/2, 1/2)', )),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)')),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
              '4e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)')),
              '6f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)')),
              '6g': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'
                         )),
              '12h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(1/2, x, 0)', '(1/2, -x, 0)', '(x, 0, 1/2)',
                          '(-x, 0, 1/2)', '(0, 1/2, x)', '(0, 1/2, -x)')),
              '12i': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, -z)',
                          '(x, -x, -z)', '(z, x, x)', '(z, -x, -x)',
                          '(-z, -x, x)', '(-z, x, -x)', '(x, z, x)',
                          '(-x, z, -x)', '(x, -z, -x)', '(-x, -z, x)')),
              '24j': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y, x, z)', '(-y, -x, z)', '(y, -x, -z)',
                          '(-y, x, -z)', '(x, z, y)', '(-x, z, -y)',
                          '(-x, -z, y)', '(x, -z, -y)', '(z, y, x)',
                          '(z, -y, -x)', '(-z, y, -x)', '(-z, -y, x)'))},
      '216': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)')),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)')),
              '4c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)')),
              '4d': (0, ('(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)')),
              '16e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)')),
              '24f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)')),
              '24g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)')),
              '48h': (5, ('(x, x, z)', '(x, x+1/2, z+1/2)',
                          '(x+1/2, x, z+1/2)', '(x+1/2, x+1/2, z)',
                          '(-x, -x, z)', '(-x, -x+1/2, z+1/2)',
                          '(-x+1/2, -x, z+1/2)', '(-x+1/2, -x+1/2, z)',
                          '(-x, x, -z)', '(-x, x+1/2, -z+1/2)',
                          '(-x+1/2, x, -z+1/2)', '(-x+1/2, x+1/2, -z)',
                          '(x, -x, -z)', '(x, -x+1/2, -z+1/2)',
                          '(x+1/2, -x, -z+1/2)', '(x+1/2, -x+1/2, -z)',
                          '(z, x, x)', '(z, x+1/2, x+1/2)',
                          '(z+1/2, x, x+1/2)', '(z+1/2, x+1/2, x)',
                          '(z, -x, -x)', '(z, -x+1/2, -x+1/2)',
                          '(z+1/2, -x, -x+1/2)', '(z+1/2, -x+1/2, -x)',
                          '(-z, -x, x)', '(-z, -x+1/2, x+1/2)',
                          '(-z+1/2, -x, x+1/2)', '(-z+1/2, -x+1/2, x)',
                          '(-z, x, -x)', '(-z, x+1/2, -x+1/2)',
                          '(-z+1/2, x, -x+1/2)', '(-z+1/2, x+1/2, -x)',
                          '(x, z, x)', '(x, z+1/2, x+1/2)',
                          '(x+1/2, z, x+1/2)', '(x+1/2, z+1/2, x)',
                          '(-x, z, -x)', '(-x, z+1/2, -x+1/2)',
                          '(-x+1/2, z, -x+1/2)', '(-x+1/2, z+1/2, -x)',
                          '(x, -z, -x)', '(x, -z+1/2, -x+1/2)',
                          '(x+1/2, -z, -x+1/2)', '(x+1/2, -z+1/2, -x)',
                          '(-x, -z, x)', '(-x, -z+1/2, x+1/2)',
                          '(-x+1/2, -z, x+1/2)', '(-x+1/2, -z+1/2, x)')),
              '96i': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                          '(y, x, z)', '(y, x+1/2, z+1/2)',
                          '(y+1/2, x, z+1/2)', '(y+1/2, x+1/2, z)',
                          '(-y, -x, z)', '(-y, -x+1/2, z+1/2)',
                          '(-y+1/2, -x, z+1/2)', '(-y+1/2, -x+1/2, z)',
                          '(y, -x, -z)', '(y, -x+1/2, -z+1/2)',
                          '(y+1/2, -x, -z+1/2)', '(y+1/2, -x+1/2, -z)',
                          '(-y, x, -z)', '(-y, x+1/2, -z+1/2)',
                          '(-y+1/2, x, -z+1/2)', '(-y+1/2, x+1/2, -z)',
                          '(x, z, y)', '(x, z+1/2, y+1/2)',
                          '(x+1/2, z, y+1/2)', '(x+1/2, z+1/2, y)',
                          '(-x, z, -y)', '(-x, z+1/2, -y+1/2)',
                          '(-x+1/2, z, -y+1/2)', '(-x+1/2, z+1/2, -y)',
                          '(-x, -z, y)', '(-x, -z+1/2, y+1/2)',
                          '(-x+1/2, -z, y+1/2)', '(-x+1/2, -z+1/2, y)',
                          '(x, -z, -y)', '(x, -z+1/2, -y+1/2)',
                          '(x+1/2, -z, -y+1/2)', '(x+1/2, -z+1/2, -y)',
                          '(z, y, x)', '(z, y+1/2, x+1/2)',
                          '(z+1/2, y, x+1/2)', '(z+1/2, y+1/2, x)',
                          '(z, -y, -x)', '(z, -y+1/2, -x+1/2)',
                          '(z+1/2, -y, -x+1/2)', '(z+1/2, -y+1/2, -x)',
                          '(-z, y, -x)', '(-z, y+1/2, -x+1/2)',
                          '(-z+1/2, y, -x+1/2)', '(-z+1/2, y+1/2, -x)',
                          '(-z, -y, x)', '(-z, -y+1/2, x+1/2)',
                          '(-z+1/2, -y, x+1/2)', '(-z+1/2, -y+1/2, x)'))},
      '217': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)')),
              '8c': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                         '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                         '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                         '(x+1/2, -x+1/2, -x+1/2)')),
              '12d': (0, ('(1/4, 1/2, 0)', '(3/4, 0, 1/2)', '(3/4, 1/2, 0)',
                          '(1/4, 0, 1/2)', '(0, 1/4, 1/2)', '(1/2, 3/4, 0)',
                          '(0, 3/4, 1/2)', '(1/2, 1/4, 0)', '(1/2, 0, 1/4)',
                          '(0, 1/2, 3/4)', '(1/2, 0, 3/4)', '(0, 1/2, 1/4)')),
              '12e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)')),
              '24f': (1, ('(x, 1/2, 0)', '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                          '(-x+1/2, 0, 1/2)', '(0, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(1/2, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x+1/2)', '(1/2, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(x, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                          '(-x+1/2, 1/2, 0)', '(0, 1/2, x)',
                          '(1/2, 0, x+1/2)', '(0, 1/2, -x)',
                          '(1/2, 0, -x+1/2)')),
              '24g': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                          '(-x+1/2, -x+1/2, z+1/2)', '(-x, x, -z)',
                          '(-x+1/2, x+1/2, -z+1/2)', '(x, -x, -z)',
                          '(x+1/2, -x+1/2, -z+1/2)', '(z, x, x)',
                          '(z+1/2, x+1/2, x+1/2)', '(z, -x, -x)',
                          '(z+1/2, -x+1/2, -x+1/2)', '(-z, -x, x)',
                          '(-z+1/2, -x+1/2, x+1/2)', '(-z, x, -x)',
                          '(-z+1/2, x+1/2, -x+1/2)', '(x, z, x)',
                          '(x+1/2, z+1/2, x+1/2)', '(-x, z, -x)',
                          '(-x+1/2, z+1/2, -x+1/2)', '(x, -z, -x)',
                          '(x+1/2, -z+1/2, -x+1/2)', '(-x, -z, x)',
                          '(-x+1/2, -z+1/2, x+1/2)')),
              '48h': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x, z, y)',
                          '(x+1/2, z+1/2, y+1/2)', '(-x, z, -y)',
                          '(-x+1/2, z+1/2, -y+1/2)', '(-x, -z, y)',
                          '(-x+1/2, -z+1/2, y+1/2)', '(x, -z, -y)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(z, y, x)',
                          '(z+1/2, y+1/2, x+1/2)', '(z, -y, -x)',
                          '(z+1/2, -y+1/2, -x+1/2)', '(-z, y, -x)',
                          '(-z+1/2, y+1/2, -x+1/2)', '(-z, -y, x)',
                          '(-z+1/2, -y+1/2, x+1/2)'))},
      '218': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)')),
              '6c': (0, ('(1/4, 1/2, 0)', '(3/4, 1/2, 0)', '(0, 1/4, 1/2)',
                         '(0, 3/4, 1/2)', '(1/2, 0, 1/4)', '(1/2, 0, 3/4)')),
              '6d': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                         '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)')),
              '8e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(x+1/2, x+1/2, x+1/2)',
                         '(-x+1/2, -x+1/2, x+1/2)', '(x+1/2, -x+1/2, -x+1/2)',
                         '(-x+1/2, x+1/2, -x+1/2)')),
              '12f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                          '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(1/2, 1/2, x+1/2)', '(1/2, 1/2, -x+1/2)')),
              '12g': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(0, x+1/2, 1/2)', '(0, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x+1/2, 1/2, 0)',
                          '(1/2, 0, x+1/2)', '(1/2, 0, -x+1/2)')),
              '12h': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                          '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                          '(1/2, x+1/2, 0)', '(1/2, -x+1/2, 0)',
                          '(x+1/2, 0, 1/2)', '(-x+1/2, 0, 1/2)',
                          '(0, 1/2, x+1/2)', '(0, 1/2, -x+1/2)')),
              '24i': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y+1/2, x+1/2, z+1/2)', '(-y+1/2, -x+1/2, z+1/2)',
                          '(y+1/2, -x+1/2, -z+1/2)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(x+1/2, z+1/2, y+1/2)',
                          '(-x+1/2, z+1/2, -y+1/2)',
                          '(-x+1/2, -z+1/2, y+1/2)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(z+1/2, y+1/2, x+1/2)',
                          '(z+1/2, -y+1/2, -x+1/2)',
                          '(-z+1/2, y+1/2, -x+1/2)',
                          '(-z+1/2, -y+1/2, x+1/2)'))},
      '219': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 0)', '(0, 0, 1/2)')),
              '8b': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)')),
              '24c': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)')),
              '24d': (0, ('(1/4, 0, 0)', '(1/4, 1/2, 1/2)', '(3/4, 0, 1/2)',
                          '(3/4, 1/2, 0)', '(3/4, 0, 0)', '(3/4, 1/2, 1/2)',
                          '(1/4, 0, 1/2)', '(1/4, 1/2, 0)', '(0, 1/4, 0)',
                          '(0, 3/4, 1/2)', '(1/2, 1/4, 1/2)', '(1/2, 3/4, 0)',
                          '(0, 3/4, 0)', '(0, 1/4, 1/2)', '(1/2, 3/4, 1/2)',
                          '(1/2, 1/4, 0)', '(0, 0, 1/4)', '(0, 1/2, 3/4)',
                          '(1/2, 0, 3/4)', '(1/2, 1/2, 1/4)', '(0, 0, 3/4)',
                          '(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(1/2, 1/2, 3/4)'
                          )),
              '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x+1/2, x+1/2, x+1/2)', '(x+1/2, x, x)',
                          '(x, x+1/2, x)', '(x, x, x+1/2)',
                          '(-x+1/2, -x+1/2, x+1/2)', '(-x+1/2, -x, x)',
                          '(-x, -x+1/2, x)', '(-x, -x, x+1/2)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(x+1/2, -x, -x)',
                          '(x, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(-x, x+1/2, -x)', '(-x, x, -x+1/2)')),
              '48f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, x, 0)', '(0, x+1/2, 0)',
                          '(0, x, 1/2)', '(1/2, -x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 0)', '(0, -x, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(x+1/2, 0, 0)', '(x, 1/2, 0)',
                          '(x, 0, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(-x+1/2, 0, 0)', '(-x, 1/2, 0)', '(-x, 0, 1/2)',
                          '(1/2, 1/2, x+1/2)', '(1/2, 0, x)', '(0, 1/2, x)',
                          '(0, 0, x+1/2)', '(1/2, 1/2, -x+1/2)',
                          '(1/2, 0, -x)', '(0, 1/2, -x)', '(0, 0, -x+1/2)')),
              '48g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(3/4, x+1/2, 3/4)', '(3/4, x, 1/4)',
                          '(1/4, x+1/2, 1/4)', '(1/4, x, 3/4)',
                          '(1/4, -x+1/2, 3/4)', '(1/4, -x, 1/4)',
                          '(3/4, -x+1/2, 1/4)', '(3/4, -x, 3/4)',
                          '(x+1/2, 3/4, 3/4)', '(x+1/2, 1/4, 1/4)',
                          '(x, 3/4, 1/4)', '(x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 1/4)', '(-x+1/2, 1/4, 3/4)',
                          '(-x, 3/4, 3/4)', '(-x, 1/4, 1/4)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 1/4, -x+1/2)', '(3/4, 3/4, -x)',
                          '(1/4, 1/4, -x)', '(1/4, 3/4, -x+1/2)')),
              '96h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                          '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                          '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                          '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                          '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                          '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                          '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                          '(z, x, y)', '(z, x+1/2, y+1/2)',
                          '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                          '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                          '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                          '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                          '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                          '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                          '(y, z, x)', '(y, z+1/2, x+1/2)',
                          '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                          '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                          '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                          '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                          '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                          '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                          '(y+1/2, x+1/2, z+1/2)', '(y+1/2, x, z)',
                          '(y, x+1/2, z)', '(y, x, z+1/2)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(-y+1/2, -x, z)',
                          '(-y, -x+1/2, z)', '(-y, -x, z+1/2)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(y+1/2, -x, -z)',
                          '(y, -x+1/2, -z)', '(y, -x, -z+1/2)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(-y+1/2, x, -z)',
                          '(-y, x+1/2, -z)', '(-y, x, -z+1/2)',
                          '(x+1/2, z+1/2, y+1/2)', '(x+1/2, z, y)',
                          '(x, z+1/2, y)', '(x, z, y+1/2)',
                          '(-x+1/2, z+1/2, -y+1/2)', '(-x+1/2, z, -y)',
                          '(-x, z+1/2, -y)', '(-x, z, -y+1/2)',
                          '(-x+1/2, -z+1/2, y+1/2)', '(-x+1/2, -z, y)',
                          '(-x, -z+1/2, y)', '(-x, -z, y+1/2)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(x+1/2, -z, -y)',
                          '(x, -z+1/2, -y)', '(x, -z, -y+1/2)',
                          '(z+1/2, y+1/2, x+1/2)', '(z+1/2, y, x)',
                          '(z, y+1/2, x)', '(z, y, x+1/2)',
                          '(z+1/2, -y+1/2, -x+1/2)', '(z+1/2, -y, -x)',
                          '(z, -y+1/2, -x)', '(z, -y, -x+1/2)',
                          '(-z+1/2, y+1/2, -x+1/2)', '(-z+1/2, y, -x)',
                          '(-z, y+1/2, -x)', '(-z, y, -x+1/2)',
                          '(-z+1/2, -y+1/2, x+1/2)', '(-z+1/2, -y, x)',
                          '(-z, -y+1/2, x)', '(-z, -y, x+1/2)'))},
      '220': {'12a': (0, ('(3/8, 0, 1/4)', '(7/8, 1/2, 3/4)', '(1/8, 0, 3/4)',
                          '(5/8, 1/2, 1/4)', '(1/4, 3/8, 0)',
                          '(3/4, 7/8, 1/2)', '(3/4, 1/8, 0)',
                          '(1/4, 5/8, 1/2)', '(0, 1/4, 3/8)',
                          '(1/2, 3/4, 7/8)', '(0, 3/4, 1/8)',
                          '(1/2, 1/4, 5/8)')),
              '12b': (0, ('(7/8, 0, 1/4)', '(3/8, 1/2, 3/4)', '(5/8, 0, 3/4)',
                          '(1/8, 1/2, 1/4)', '(1/4, 7/8, 0)',
                          '(3/4, 3/8, 1/2)', '(3/4, 5/8, 0)',
                          '(1/4, 1/8, 1/2)', '(0, 1/4, 7/8)',
                          '(1/2, 3/4, 3/8)', '(0, 3/4, 5/8)',
                          '(1/2, 1/4, 1/8)')),
              '16c': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                          '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(x+1/4, x+1/4, x+1/4)', '(x+3/4, x+3/4, x+3/4)',
                          '(-x+1/4, -x+3/4, x+3/4)',
                          '(-x+3/4, -x+1/4, x+1/4)',
                          '(x+3/4, -x+1/4, -x+3/4)',
                          '(x+1/4, -x+3/4, -x+1/4)',
                          '(-x+3/4, x+3/4, -x+1/4)',
                          '(-x+1/4, x+1/4, -x+3/4)')),
              '24d': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)', '(1/4, x+1/4, 1/2)',
                          '(3/4, x+3/4, 0)', '(1/4, -x+3/4, 0)',
                          '(3/4, -x+1/4, 1/2)', '(x+1/4, 1/2, 1/4)',
                          '(x+3/4, 0, 3/4)', '(-x+3/4, 0, 1/4)',
                          '(-x+1/4, 1/2, 3/4)', '(1/2, 1/4, x+1/4)',
                          '(0, 3/4, x+3/4)', '(0, 1/4, -x+3/4)',
                          '(1/2, 3/4, -x+1/4)')),
              '48e': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)',
                          '(y+1/4, x+1/4, z+1/4)', '(y+3/4, x+3/4, z+3/4)',
                          '(-y+1/4, -x+3/4, z+3/4)',
                          '(-y+3/4, -x+1/4, z+1/4)',
                          '(y+3/4, -x+1/4, -z+3/4)',
                          '(y+1/4, -x+3/4, -z+1/4)',
                          '(-y+3/4, x+3/4, -z+1/4)',
                          '(-y+1/4, x+1/4, -z+3/4)', '(x+1/4, z+1/4, y+1/4)',
                          '(x+3/4, z+3/4, y+3/4)', '(-x+3/4, z+3/4, -y+1/4)',
                          '(-x+1/4, z+1/4, -y+3/4)',
                          '(-x+1/4, -z+3/4, y+3/4)',
                          '(-x+3/4, -z+1/4, y+1/4)',
                          '(x+3/4, -z+1/4, -y+3/4)',
                          '(x+1/4, -z+3/4, -y+1/4)', '(z+1/4, y+1/4, x+1/4)',
                          '(z+3/4, y+3/4, x+3/4)', '(z+3/4, -y+1/4, -x+3/4)',
                          '(z+1/4, -y+3/4, -x+1/4)',
                          '(-z+3/4, y+3/4, -x+1/4)',
                          '(-z+1/4, y+1/4, -x+3/4)',
                          '(-z+1/4, -y+3/4, x+3/4)',
                          '(-z+3/4, -y+1/4, x+1/4)'))},
      '221': {'1a': (0, ('(0, 0, 0)', )),
              '1b': (0, ('(1/2, 1/2, 1/2)', )),
              '3c': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)')),
              '3d': (0, ('(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
              '6e': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)', '(0, -x, 0)',
                         '(0, 0, x)', '(0, 0, -x)')),
              '6f': (1, ('(x, 1/2, 1/2)', '(-x, 1/2, 1/2)', '(1/2, x, 1/2)',
                         '(1/2, -x, 1/2)', '(1/2, 1/2, x)', '(1/2, 1/2, -x)'
                         )),
              '8g': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                         '(x, -x, -x)', '(x, x, -x)', '(-x, -x, -x)',
                         '(x, -x, x)', '(-x, x, x)')),
              '12h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(1/2, x, 0)', '(1/2, -x, 0)', '(x, 0, 1/2)',
                          '(-x, 0, 1/2)', '(0, 1/2, -x)', '(0, 1/2, x)')),
              '12i': (2, ('(0, y, y)', '(0, -y, y)', '(0, y, -y)',
                          '(0, -y, -y)', '(y, 0, y)', '(y, 0, -y)',
                          '(-y, 0, y)', '(-y, 0, -y)', '(y, y, 0)',
                          '(-y, y, 0)', '(y, -y, 0)', '(-y, -y, 0)')),
              '12j': (2, ('(1/2, y, y)', '(1/2, -y, y)', '(1/2, y, -y)',
                          '(1/2, -y, -y)', '(y, 1/2, y)', '(y, 1/2, -y)',
                          '(-y, 1/2, y)', '(-y, 1/2, -y)', '(y, y, 1/2)',
                          '(-y, y, 1/2)', '(y, -y, 1/2)', '(-y, -y, 1/2)')),
              '24k': (6, ('(0, y, z)', '(0, -y, z)', '(0, y, -z)',
                          '(0, -y, -z)', '(z, 0, y)', '(z, 0, -y)',
                          '(-z, 0, y)', '(-z, 0, -y)', '(y, z, 0)',
                          '(-y, z, 0)', '(y, -z, 0)', '(-y, -z, 0)',
                          '(y, 0, -z)', '(-y, 0, -z)', '(y, 0, z)',
                          '(-y, 0, z)', '(0, z, -y)', '(0, z, y)',
                          '(0, -z, -y)', '(0, -z, y)', '(z, y, 0)',
                          '(z, -y, 0)', '(-z, y, 0)', '(-z, -y, 0)')),
              '24l': (6, ('(1/2, y, z)', '(1/2, -y, z)', '(1/2, y, -z)',
                          '(1/2, -y, -z)', '(z, 1/2, y)', '(z, 1/2, -y)',
                          '(-z, 1/2, y)', '(-z, 1/2, -y)', '(y, z, 1/2)',
                          '(-y, z, 1/2)', '(y, -z, 1/2)', '(-y, -z, 1/2)',
                          '(y, 1/2, -z)', '(-y, 1/2, -z)', '(y, 1/2, z)',
                          '(-y, 1/2, z)', '(1/2, z, -y)', '(1/2, z, y)',
                          '(1/2, -z, -y)', '(1/2, -z, y)', '(z, y, 1/2)',
                          '(z, -y, 1/2)', '(-z, y, 1/2)', '(-z, -y, 1/2)')),
              '24m': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, -z)',
                          '(x, -x, -z)', '(z, x, x)', '(z, -x, -x)',
                          '(-z, -x, x)', '(-z, x, -x)', '(x, z, x)',
                          '(-x, z, -x)', '(x, -z, -x)', '(-x, -z, x)',
                          '(x, x, -z)', '(-x, -x, -z)', '(x, -x, z)',
                          '(-x, x, z)', '(x, z, -x)', '(-x, z, x)',
                          '(-x, -z, -x)', '(x, -z, x)', '(z, x, -x)',
                          '(z, -x, x)', '(-z, x, x)', '(-z, -x, -x)')),
              '48n': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y, x, -z)', '(-y, -x, -z)', '(y, -x, z)',
                          '(-y, x, z)', '(x, z, -y)', '(-x, z, y)',
                          '(-x, -z, -y)', '(x, -z, y)', '(z, y, -x)',
                          '(z, -y, x)', '(-z, y, x)', '(-z, -y, -x)',
                          '(-x, -y, -z)', '(x, y, -z)', '(x, -y, z)',
                          '(-x, y, z)', '(-z, -x, -y)', '(-z, x, y)',
                          '(z, x, -y)', '(z, -x, y)', '(-y, -z, -x)',
                          '(y, -z, x)', '(-y, z, x)', '(y, z, -x)',
                          '(-y, -x, z)', '(y, x, z)', '(-y, x, -z)',
                          '(y, -x, -z)', '(-x, -z, y)', '(x, -z, -y)',
                          '(x, z, y)', '(-x, z, -y)', '(-z, -y, x)',
                          '(-z, y, -x)', '(z, -y, -x)', '(z, y, x)'))},
      '222:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
                '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                           '(1/2, 0, 0)', '(0, 1/2, 0)', '(0, 0, 1/2)')),
                '8c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)',
                           '(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)')),
                '12d': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                            '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)',
                            '(0, 1/4, 1/2)', '(0, 3/4, 1/2)', '(1/4, 1/2, 0)',
                            '(3/4, 1/2, 0)', '(1/2, 0, 3/4)', '(1/2, 0, 1/4)'
                            )),
                '12e': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                            '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                            '(-x+1/2, 1/2, 1/2)', '(x+1/2, 1/2, 1/2)',
                            '(1/2, -x+1/2, 1/2)', '(1/2, x+1/2, 1/2)',
                            '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)')),
                '16f': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                            '(x, -x, -x)', '(x, x, -x)', '(-x, -x, -x)',
                            '(x, -x, x)', '(-x, x, x)',
                            '(-x+1/2, -x+1/2, -x+1/2)',
                            '(x+1/2, x+1/2, -x+1/2)',
                            '(x+1/2, -x+1/2, x+1/2)',
                            '(-x+1/2, x+1/2, x+1/2)',
                            '(-x+1/2, -x+1/2, x+1/2)',
                            '(x+1/2, x+1/2, x+1/2)',
                            '(-x+1/2, x+1/2, -x+1/2)',
                            '(x+1/2, -x+1/2, -x+1/2)')),
                '24g': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                            '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                            '(0, x, 1/2)', '(0, -x, 1/2)', '(x, 1/2, 0)',
                            '(-x, 1/2, 0)', '(1/2, 0, -x)', '(1/2, 0, x)',
                            '(-x+1/2, 1/2, 0)', '(x+1/2, 1/2, 0)',
                            '(0, -x+1/2, 1/2)', '(0, x+1/2, 1/2)',
                            '(1/2, 0, -x+1/2)', '(1/2, 0, x+1/2)',
                            '(1/2, -x+1/2, 0)', '(1/2, x+1/2, 0)',
                            '(-x+1/2, 0, 1/2)', '(x+1/2, 0, 1/2)',
                            '(0, 1/2, x+1/2)', '(0, 1/2, -x+1/2)')),
                '24h': (2, ('(0, y, y)', '(0, -y, y)', '(0, y, -y)',
                            '(0, -y, -y)', '(y, 0, y)', '(y, 0, -y)',
                            '(-y, 0, y)', '(-y, 0, -y)', '(y, y, 0)',
                            '(-y, y, 0)', '(y, -y, 0)', '(-y, -y, 0)',
                            '(1/2, -y+1/2, -y+1/2)', '(1/2, y+1/2, -y+1/2)',
                            '(1/2, -y+1/2, y+1/2)', '(1/2, y+1/2, y+1/2)',
                            '(-y+1/2, 1/2, -y+1/2)', '(-y+1/2, 1/2, y+1/2)',
                            '(y+1/2, 1/2, -y+1/2)', '(y+1/2, 1/2, y+1/2)',
                            '(-y+1/2, -y+1/2, 1/2)', '(y+1/2, -y+1/2, 1/2)',
                            '(-y+1/2, y+1/2, 1/2)', '(y+1/2, y+1/2, 1/2)')),
                '48i': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                            '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                            '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                            '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                            '(y, x, -z)', '(-y, -x, -z)', '(y, -x, z)',
                            '(-y, x, z)', '(x, z, -y)', '(-x, z, y)',
                            '(-x, -z, -y)', '(x, -z, y)', '(z, y, -x)',
                            '(z, -y, x)', '(-z, y, x)', '(-z, -y, -x)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-z+1/2, -x+1/2, -y+1/2)',
                            '(-z+1/2, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y+1/2)',
                            '(z+1/2, -x+1/2, y+1/2)',
                            '(-y+1/2, -z+1/2, -x+1/2)',
                            '(y+1/2, -z+1/2, x+1/2)',
                            '(-y+1/2, z+1/2, x+1/2)',
                            '(y+1/2, z+1/2, -x+1/2)',
                            '(-y+1/2, -x+1/2, z+1/2)',
                            '(y+1/2, x+1/2, z+1/2)',
                            '(-y+1/2, x+1/2, -z+1/2)',
                            '(y+1/2, -x+1/2, -z+1/2)',
                            '(-x+1/2, -z+1/2, y+1/2)',
                            '(x+1/2, -z+1/2, -y+1/2)',
                            '(x+1/2, z+1/2, y+1/2)',
                            '(-x+1/2, z+1/2, -y+1/2)',
                            '(-z+1/2, -y+1/2, x+1/2)',
                            '(-z+1/2, y+1/2, -x+1/2)',
                            '(z+1/2, -y+1/2, -x+1/2)',
                            '(z+1/2, y+1/2, x+1/2)'))},
      '222:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
                '6b': (0, ('(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(1/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)',
                           '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)')),
                '8c': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)', '(0, 0, 1/2)', '(1/2, 1/2, 1/2)',
                           '(0, 1/2, 0)', '(1/2, 0, 0)')),
                '12d': (0, ('(0, 3/4, 1/4)', '(1/2, 3/4, 1/4)',
                            '(1/4, 0, 3/4)', '(1/4, 1/2, 3/4)',
                            '(3/4, 1/4, 0)', '(3/4, 1/4, 1/2)',
                            '(3/4, 0, 1/4)', '(3/4, 1/2, 1/4)',
                            '(0, 1/4, 3/4)', '(1/2, 1/4, 3/4)',
                            '(1/4, 3/4, 1/2)', '(1/4, 3/4, 0)')),
                '12e': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                            '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                            '(1/4, 1/4, x)', '(1/4, 1/4, -x+1/2)',
                            '(-x, 3/4, 3/4)', '(x+1/2, 3/4, 3/4)',
                            '(3/4, -x, 3/4)', '(3/4, x+1/2, 3/4)',
                            '(3/4, 3/4, -x)', '(3/4, 3/4, x+1/2)')),
                '16f': (1, ('(x, x, x)', '(-x+1/2, -x+1/2, x)',
                            '(-x+1/2, x, -x+1/2)', '(x, -x+1/2, -x+1/2)',
                            '(x, x, -x+1/2)', '(-x+1/2, -x+1/2, -x+1/2)',
                            '(x, -x+1/2, x)', '(-x+1/2, x, x)',
                            '(-x, -x, -x)', '(x+1/2, x+1/2, -x)',
                            '(x+1/2, -x, x+1/2)', '(-x, x+1/2, x+1/2)',
                            '(-x, -x, x+1/2)', '(x+1/2, x+1/2, x+1/2)',
                            '(-x, x+1/2, -x)', '(x+1/2, -x, -x)')),
                '24g': (1, ('(x, 3/4, 1/4)', '(-x+1/2, 3/4, 1/4)',
                            '(1/4, x, 3/4)', '(1/4, -x+1/2, 3/4)',
                            '(3/4, 1/4, x)', '(3/4, 1/4, -x+1/2)',
                            '(3/4, x, 1/4)', '(3/4, -x+1/2, 1/4)',
                            '(x, 1/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                            '(1/4, 3/4, -x+1/2)', '(1/4, 3/4, x)',
                            '(-x, 1/4, 3/4)', '(x+1/2, 1/4, 3/4)',
                            '(3/4, -x, 1/4)', '(3/4, x+1/2, 1/4)',
                            '(1/4, 3/4, -x)', '(1/4, 3/4, x+1/2)',
                            '(1/4, -x, 3/4)', '(1/4, x+1/2, 3/4)',
                            '(-x, 3/4, 1/4)', '(x+1/2, 3/4, 1/4)',
                            '(3/4, 1/4, x+1/2)', '(3/4, 1/4, -x)')),
                '24h': (2, ('(1/4, y, y)', '(1/4, -y+1/2, y)',
                            '(1/4, y, -y+1/2)', '(1/4, -y+1/2, -y+1/2)',
                            '(y, 1/4, y)', '(y, 1/4, -y+1/2)',
                            '(-y+1/2, 1/4, y)', '(-y+1/2, 1/4, -y+1/2)',
                            '(y, y, 1/4)', '(-y+1/2, y, 1/4)',
                            '(y, -y+1/2, 1/4)', '(-y+1/2, -y+1/2, 1/4)',
                            '(3/4, -y, -y)', '(3/4, y+1/2, -y)',
                            '(3/4, -y, y+1/2)', '(3/4, y+1/2, y+1/2)',
                            '(-y, 3/4, -y)', '(-y, 3/4, y+1/2)',
                            '(y+1/2, 3/4, -y)', '(y+1/2, 3/4, y+1/2)',
                            '(-y, -y, 3/4)', '(y+1/2, -y, 3/4)',
                            '(-y, y+1/2, 3/4)', '(y+1/2, y+1/2, 3/4)')),
                '48i': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(z, x, y)', '(z, -x+1/2, -y+1/2)',
                            '(-z+1/2, -x+1/2, y)', '(-z+1/2, x, -y+1/2)',
                            '(y, z, x)', '(-y+1/2, z, -x+1/2)',
                            '(y, -z+1/2, -x+1/2)', '(-y+1/2, -z+1/2, x)',
                            '(y, x, -z+1/2)', '(-y+1/2, -x+1/2, -z+1/2)',
                            '(y, -x+1/2, z)', '(-y+1/2, x, z)',
                            '(x, z, -y+1/2)', '(-x+1/2, z, y)',
                            '(-x+1/2, -z+1/2, -y+1/2)', '(x, -z+1/2, y)',
                            '(z, y, -x+1/2)', '(z, -y+1/2, x)',
                            '(-z+1/2, y, x)', '(-z+1/2, -y+1/2, -x+1/2)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-z, -x, -y)', '(-z, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y)', '(z+1/2, -x, y+1/2)',
                            '(-y, -z, -x)', '(y+1/2, -z, x+1/2)',
                            '(-y, z+1/2, x+1/2)', '(y+1/2, z+1/2, -x)',
                            '(-y, -x, z+1/2)', '(y+1/2, x+1/2, z+1/2)',
                            '(-y, x+1/2, -z)', '(y+1/2, -x, -z)',
                            '(-x, -z, y+1/2)', '(x+1/2, -z, -y)',
                            '(x+1/2, z+1/2, y+1/2)', '(-x, z+1/2, -y)',
                            '(-z, -y, x+1/2)', '(-z, y+1/2, -x)',
                            '(z+1/2, -y, -x)', '(z+1/2, y+1/2, x+1/2)'))},
      '223': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                         '(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)')),
              '6c': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                         '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)')),
              '6d': (0, ('(1/4, 1/2, 0)', '(3/4, 1/2, 0)', '(0, 1/4, 1/2)',
                         '(0, 3/4, 1/2)', '(1/2, 0, 1/4)', '(1/2, 0, 3/4)')),
              '8e': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                         '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)')),
              '12f': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                          '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)')),
              '12g': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                          '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                          '(1/2, x+1/2, 0)', '(1/2, -x+1/2, 0)',
                          '(x+1/2, 0, 1/2)', '(-x+1/2, 0, 1/2)',
                          '(0, 1/2, -x+1/2)', '(0, 1/2, x+1/2)')),
              '12h': (1, ('(x, 1/2, 0)', '(-x, 1/2, 0)', '(0, x, 1/2)',
                          '(0, -x, 1/2)', '(1/2, 0, x)', '(1/2, 0, -x)',
                          '(0, x+1/2, 1/2)', '(0, -x+1/2, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x+1/2, 1/2, 0)',
                          '(1/2, 0, -x+1/2)', '(1/2, 0, x+1/2)')),
              '16i': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                          '(x, -x, -x)', '(x+1/2, x+1/2, -x+1/2)',
                          '(-x+1/2, -x+1/2, -x+1/2)',
                          '(x+1/2, -x+1/2, x+1/2)', '(-x+1/2, x+1/2, x+1/2)',
                          '(-x, -x, -x)', '(x, x, -x)', '(x, -x, x)',
                          '(-x, x, x)', '(-x+1/2, -x+1/2, x+1/2)',
                          '(x+1/2, x+1/2, x+1/2)', '(-x+1/2, x+1/2, -x+1/2)',
                          '(x+1/2, -x+1/2, -x+1/2)')),
              '24j': (2, ('(1/4, y, y+1/2)', '(3/4, -y, y+1/2)',
                          '(3/4, y, -y+1/2)', '(1/4, -y, -y+1/2)',
                          '(y+1/2, 1/4, y)', '(y+1/2, 3/4, -y)',
                          '(-y+1/2, 3/4, y)', '(-y+1/2, 1/4, -y)',
                          '(y, y+1/2, 1/4)', '(-y, y+1/2, 3/4)',
                          '(y, -y+1/2, 3/4)', '(-y, -y+1/2, 1/4)',
                          '(3/4, -y, -y+1/2)', '(1/4, y, -y+1/2)',
                          '(1/4, -y, y+1/2)', '(3/4, y, y+1/2)',
                          '(-y+1/2, 3/4, -y)', '(-y+1/2, 1/4, y)',
                          '(y+1/2, 1/4, -y)', '(y+1/2, 3/4, y)',
                          '(-y, -y+1/2, 3/4)', '(y, -y+1/2, 1/4)',
                          '(-y, y+1/2, 1/4)', '(y, y+1/2, 3/4)')),
              '24k': (6, ('(0, y, z)', '(0, -y, z)', '(0, y, -z)',
                          '(0, -y, -z)', '(z, 0, y)', '(z, 0, -y)',
                          '(-z, 0, y)', '(-z, 0, -y)', '(y, z, 0)',
                          '(-y, z, 0)', '(y, -z, 0)', '(-y, -z, 0)',
                          '(y+1/2, 1/2, -z+1/2)', '(-y+1/2, 1/2, -z+1/2)',
                          '(y+1/2, 1/2, z+1/2)', '(-y+1/2, 1/2, z+1/2)',
                          '(1/2, z+1/2, -y+1/2)', '(1/2, z+1/2, y+1/2)',
                          '(1/2, -z+1/2, -y+1/2)', '(1/2, -z+1/2, y+1/2)',
                          '(z+1/2, y+1/2, 1/2)', '(z+1/2, -y+1/2, 1/2)',
                          '(-z+1/2, y+1/2, 1/2)', '(-z+1/2, -y+1/2, 1/2)')),
              '48l': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                          '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                          '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                          '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                          '(y+1/2, x+1/2, -z+1/2)',
                          '(-y+1/2, -x+1/2, -z+1/2)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-y+1/2, x+1/2, z+1/2)',
                          '(x+1/2, z+1/2, -y+1/2)', '(-x+1/2, z+1/2, y+1/2)',
                          '(-x+1/2, -z+1/2, -y+1/2)',
                          '(x+1/2, -z+1/2, y+1/2)', '(z+1/2, y+1/2, -x+1/2)',
                          '(z+1/2, -y+1/2, x+1/2)', '(-z+1/2, y+1/2, x+1/2)',
                          '(-z+1/2, -y+1/2, -x+1/2)', '(-x, -y, -z)',
                          '(x, y, -z)', '(x, -y, z)', '(-x, y, z)',
                          '(-z, -x, -y)', '(-z, x, y)', '(z, x, -y)',
                          '(z, -x, y)', '(-y, -z, -x)', '(y, -z, x)',
                          '(-y, z, x)', '(y, z, -x)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y+1/2, x+1/2, z+1/2)',
                          '(-y+1/2, x+1/2, -z+1/2)',
                          '(y+1/2, -x+1/2, -z+1/2)',
                          '(-x+1/2, -z+1/2, y+1/2)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(x+1/2, z+1/2, y+1/2)',
                          '(-x+1/2, z+1/2, -y+1/2)',
                          '(-z+1/2, -y+1/2, x+1/2)',
                          '(-z+1/2, y+1/2, -x+1/2)',
                          '(z+1/2, -y+1/2, -x+1/2)', '(z+1/2, y+1/2, x+1/2)'
                          ))},
      '224:1': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
                '4b': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 1/4)',
                           '(3/4, 1/4, 3/4)', '(1/4, 3/4, 3/4)')),
                '4c': (0, ('(3/4, 3/4, 3/4)', '(1/4, 1/4, 3/4)',
                           '(1/4, 3/4, 1/4)', '(3/4, 1/4, 1/4)')),
                '6d': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 1/2)', '(1/2, 1/2, 0)',
                           '(0, 1/2, 0)', '(1/2, 0, 0)', '(0, 0, 1/2)')),
                '8e': (1, ('(x, x, x)', '(-x, -x, x)', '(-x, x, -x)',
                           '(x, -x, -x)', '(x+1/2, x+1/2, -x+1/2)',
                           '(-x+1/2, -x+1/2, -x+1/2)',
                           '(x+1/2, -x+1/2, x+1/2)', '(-x+1/2, x+1/2, x+1/2)'
                           )),
                '12f': (0, ('(1/4, 0, 1/2)', '(3/4, 0, 1/2)', '(1/2, 1/4, 0)',
                            '(1/2, 3/4, 0)', '(0, 1/2, 1/4)', '(0, 1/2, 3/4)',
                            '(1/4, 1/2, 0)', '(3/4, 1/2, 0)', '(0, 1/4, 1/2)',
                            '(0, 3/4, 1/2)', '(1/2, 0, 1/4)', '(1/2, 0, 3/4)'
                            )),
                '12g': (1, ('(x, 0, 0)', '(-x, 0, 0)', '(0, x, 0)',
                            '(0, -x, 0)', '(0, 0, x)', '(0, 0, -x)',
                            '(1/2, x+1/2, 1/2)', '(1/2, -x+1/2, 1/2)',
                            '(x+1/2, 1/2, 1/2)', '(-x+1/2, 1/2, 1/2)',
                            '(1/2, 1/2, -x+1/2)', '(1/2, 1/2, x+1/2)')),
                '24h': (1, ('(x, 0, 1/2)', '(-x, 0, 1/2)', '(1/2, x, 0)',
                            '(1/2, -x, 0)', '(0, 1/2, x)', '(0, 1/2, -x)',
                            '(1/2, x+1/2, 0)', '(1/2, -x+1/2, 0)',
                            '(x+1/2, 0, 1/2)', '(-x+1/2, 0, 1/2)',
                            '(0, 1/2, -x+1/2)', '(0, 1/2, x+1/2)',
                            '(-x+1/2, 1/2, 0)', '(x+1/2, 1/2, 0)',
                            '(0, -x+1/2, 1/2)', '(0, x+1/2, 1/2)',
                            '(1/2, 0, -x+1/2)', '(1/2, 0, x+1/2)',
                            '(0, -x, 1/2)', '(0, x, 1/2)', '(-x, 1/2, 0)',
                            '(x, 1/2, 0)', '(1/2, 0, x)', '(1/2, 0, -x)')),
                '24i': (2, ('(1/4, y, -y+1/2)', '(3/4, -y, -y+1/2)',
                            '(3/4, y, y+1/2)', '(1/4, -y, y+1/2)',
                            '(-y+1/2, 1/4, y)', '(-y+1/2, 3/4, -y)',
                            '(y+1/2, 3/4, y)', '(y+1/2, 1/4, -y)',
                            '(y, -y+1/2, 1/4)', '(-y, -y+1/2, 3/4)',
                            '(y, y+1/2, 3/4)', '(-y, y+1/2, 1/4)',
                            '(1/4, -y+1/2, y)', '(3/4, y+1/2, y)',
                            '(3/4, -y+1/2, -y)', '(1/4, y+1/2, -y)',
                            '(y, 1/4, -y+1/2)', '(y, 3/4, y+1/2)',
                            '(-y, 3/4, -y+1/2)', '(-y, 1/4, y+1/2)',
                            '(-y+1/2, y, 1/4)', '(y+1/2, y, 3/4)',
                            '(-y+1/2, -y, 3/4)', '(y+1/2, -y, 1/4)')),
                '24j': (2, ('(1/4, y, y+1/2)', '(3/4, -y, y+1/2)',
                            '(3/4, y, -y+1/2)', '(1/4, -y, -y+1/2)',
                            '(y+1/2, 1/4, y)', '(y+1/2, 3/4, -y)',
                            '(-y+1/2, 3/4, y)', '(-y+1/2, 1/4, -y)',
                            '(y, y+1/2, 1/4)', '(-y, y+1/2, 3/4)',
                            '(y, -y+1/2, 3/4)', '(-y, -y+1/2, 1/4)',
                            '(1/4, -y+1/2, -y)', '(3/4, y+1/2, -y)',
                            '(3/4, -y+1/2, y)', '(1/4, y+1/2, y)',
                            '(-y, 1/4, -y+1/2)', '(-y, 3/4, y+1/2)',
                            '(y, 3/4, -y+1/2)', '(y, 1/4, y+1/2)',
                            '(-y+1/2, -y, 1/4)', '(y+1/2, -y, 3/4)',
                            '(-y+1/2, y, 3/4)', '(y+1/2, y, 1/4)')),
                '24k': (5, ('(x, x, z)', '(-x, -x, z)', '(-x, x, -z)',
                            '(x, -x, -z)', '(z, x, x)', '(z, -x, -x)',
                            '(-z, -x, x)', '(-z, x, -x)', '(x, z, x)',
                            '(-x, z, -x)', '(x, -z, -x)', '(-x, -z, x)',
                            '(x+1/2, x+1/2, -z+1/2)',
                            '(-x+1/2, -x+1/2, -z+1/2)',
                            '(x+1/2, -x+1/2, z+1/2)',
                            '(-x+1/2, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, -x+1/2)',
                            '(-x+1/2, z+1/2, x+1/2)',
                            '(-x+1/2, -z+1/2, -x+1/2)',
                            '(x+1/2, -z+1/2, x+1/2)',
                            '(z+1/2, x+1/2, -x+1/2)',
                            '(z+1/2, -x+1/2, x+1/2)',
                            '(-z+1/2, x+1/2, x+1/2)',
                            '(-z+1/2, -x+1/2, -x+1/2)')),
                '48l': (7, ('(x, y, z)', '(-x, -y, z)', '(-x, y, -z)',
                            '(x, -y, -z)', '(z, x, y)', '(z, -x, -y)',
                            '(-z, -x, y)', '(-z, x, -y)', '(y, z, x)',
                            '(-y, z, -x)', '(y, -z, -x)', '(-y, -z, x)',
                            '(y+1/2, x+1/2, -z+1/2)',
                            '(-y+1/2, -x+1/2, -z+1/2)',
                            '(y+1/2, -x+1/2, z+1/2)',
                            '(-y+1/2, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, -y+1/2)',
                            '(-x+1/2, z+1/2, y+1/2)',
                            '(-x+1/2, -z+1/2, -y+1/2)',
                            '(x+1/2, -z+1/2, y+1/2)',
                            '(z+1/2, y+1/2, -x+1/2)',
                            '(z+1/2, -y+1/2, x+1/2)',
                            '(-z+1/2, y+1/2, x+1/2)',
                            '(-z+1/2, -y+1/2, -x+1/2)',
                            '(-x+1/2, -y+1/2, -z+1/2)',
                            '(x+1/2, y+1/2, -z+1/2)',
                            '(x+1/2, -y+1/2, z+1/2)',
                            '(-x+1/2, y+1/2, z+1/2)',
                            '(-z+1/2, -x+1/2, -y+1/2)',
                            '(-z+1/2, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y+1/2)',
                            '(z+1/2, -x+1/2, y+1/2)',
                            '(-y+1/2, -z+1/2, -x+1/2)',
                            '(y+1/2, -z+1/2, x+1/2)',
                            '(-y+1/2, z+1/2, x+1/2)',
                            '(y+1/2, z+1/2, -x+1/2)', '(-y, -x, z)',
                            '(y, x, z)', '(-y, x, -z)', '(y, -x, -z)',
                            '(-x, -z, y)', '(x, -z, -y)', '(x, z, y)',
                            '(-x, z, -y)', '(-z, -y, x)', '(-z, y, -x)',
                            '(z, -y, -x)', '(z, y, x)'))},
      '224:2': {'2a': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
                '4b': (0, ('(0, 0, 0)', '(1/2, 1/2, 0)', '(1/2, 0, 1/2)',
                           '(0, 1/2, 1/2)')),
                '4c': (0, ('(1/2, 1/2, 1/2)', '(0, 0, 1/2)', '(0, 1/2, 0)',
                           '(1/2, 0, 0)')),
                '6d': (0, ('(1/4, 3/4, 3/4)', '(3/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)', '(1/4, 3/4, 1/4)',
                           '(3/4, 1/4, 1/4)', '(1/4, 1/4, 3/4)')),
                '8e': (1, ('(x, x, x)', '(-x+1/2, -x+1/2, x)',
                           '(-x+1/2, x, -x+1/2)', '(x, -x+1/2, -x+1/2)',
                           '(x+1/2, x+1/2, -x)', '(-x, -x, -x)',
                           '(x+1/2, -x, x+1/2)', '(-x, x+1/2, x+1/2)')),
                '12f': (0, ('(1/2, 1/4, 3/4)', '(0, 1/4, 3/4)',
                            '(3/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                            '(1/4, 3/4, 1/2)', '(1/4, 3/4, 0)',
                            '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)',
                            '(1/4, 1/2, 3/4)', '(1/4, 0, 3/4)',
                            '(3/4, 1/4, 1/2)', '(3/4, 1/4, 0)')),
                '12g': (1, ('(x, 1/4, 1/4)', '(-x+1/2, 1/4, 1/4)',
                            '(1/4, x, 1/4)', '(1/4, -x+1/2, 1/4)',
                            '(1/4, 1/4, x)', '(1/4, 1/4, -x+1/2)',
                            '(3/4, x+1/2, 3/4)', '(3/4, -x, 3/4)',
                            '(x+1/2, 3/4, 3/4)', '(-x, 3/4, 3/4)',
                            '(3/4, 3/4, -x)', '(3/4, 3/4, x+1/2)')),
                '24h': (1, ('(x, 1/4, 3/4)', '(-x+1/2, 1/4, 3/4)',
                            '(3/4, x, 1/4)', '(3/4, -x+1/2, 1/4)',
                            '(1/4, 3/4, x)', '(1/4, 3/4, -x+1/2)',
                            '(3/4, x+1/2, 1/4)', '(3/4, -x, 1/4)',
                            '(x+1/2, 1/4, 3/4)', '(-x, 1/4, 3/4)',
                            '(1/4, 3/4, -x)', '(1/4, 3/4, x+1/2)',
                            '(-x, 3/4, 1/4)', '(x+1/2, 3/4, 1/4)',
                            '(1/4, -x, 3/4)', '(1/4, x+1/2, 3/4)',
                            '(3/4, 1/4, -x)', '(3/4, 1/4, x+1/2)',
                            '(1/4, -x+1/2, 3/4)', '(1/4, x, 3/4)',
                            '(-x+1/2, 3/4, 1/4)', '(x, 3/4, 1/4)',
                            '(3/4, 1/4, x)', '(3/4, 1/4, -x+1/2)')),
                '24i': (2, ('(1/2, y, y+1/2)', '(0, -y+1/2, y+1/2)',
                            '(0, y, -y)', '(1/2, -y+1/2, -y)',
                            '(y+1/2, 1/2, y)', '(y+1/2, 0, -y+1/2)',
                            '(-y, 0, y)', '(-y, 1/2, -y+1/2)',
                            '(y, y+1/2, 1/2)', '(-y+1/2, y+1/2, 0)',
                            '(y, -y, 0)', '(-y+1/2, -y, 1/2)',
                            '(1/2, -y, -y+1/2)', '(0, y+1/2, -y+1/2)',
                            '(0, -y, y)', '(1/2, y+1/2, y)',
                            '(-y+1/2, 1/2, -y)', '(-y+1/2, 0, y+1/2)',
                            '(y, 0, -y)', '(y, 1/2, y+1/2)',
                            '(-y, -y+1/2, 1/2)', '(y+1/2, -y+1/2, 0)',
                            '(-y, y, 0)', '(y+1/2, y, 1/2)')),
                '24j': (2, ('(1/2, y, -y)', '(0, -y+1/2, -y)',
                            '(0, y, y+1/2)', '(1/2, -y+1/2, y+1/2)',
                            '(-y, 1/2, y)', '(-y, 0, -y+1/2)',
                            '(y+1/2, 0, y)', '(y+1/2, 1/2, -y+1/2)',
                            '(y, -y, 1/2)', '(-y+1/2, -y, 0)',
                            '(y, y+1/2, 0)', '(-y+1/2, y+1/2, 1/2)',
                            '(1/2, -y, y)', '(0, y+1/2, y)',
                            '(0, -y, -y+1/2)', '(1/2, y+1/2, -y+1/2)',
                            '(y, 1/2, -y)', '(y, 0, y+1/2)',
                            '(-y+1/2, 0, -y)', '(-y+1/2, 1/2, y+1/2)',
                            '(-y, y, 1/2)', '(y+1/2, y, 0)',
                            '(-y, -y+1/2, 0)', '(y+1/2, -y+1/2, 1/2)')),
                '24k': (5, ('(x, x, z)', '(-x+1/2, -x+1/2, z)',
                            '(-x+1/2, x, -z+1/2)', '(x, -x+1/2, -z+1/2)',
                            '(z, x, x)', '(z, -x+1/2, -x+1/2)',
                            '(-z+1/2, -x+1/2, x)', '(-z+1/2, x, -x+1/2)',
                            '(x, z, x)', '(-x+1/2, z, -x+1/2)',
                            '(x, -z+1/2, -x+1/2)', '(-x+1/2, -z+1/2, x)',
                            '(x+1/2, x+1/2, -z)', '(-x, -x, -z)',
                            '(x+1/2, -x, z+1/2)', '(-x, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, -x)', '(-x, z+1/2, x+1/2)',
                            '(-x, -z, -x)', '(x+1/2, -z, x+1/2)',
                            '(z+1/2, x+1/2, -x)', '(z+1/2, -x, x+1/2)',
                            '(-z, x+1/2, x+1/2)', '(-z, -x, -x)')),
                '48l': (7, ('(x, y, z)', '(-x+1/2, -y+1/2, z)',
                            '(-x+1/2, y, -z+1/2)', '(x, -y+1/2, -z+1/2)',
                            '(z, x, y)', '(z, -x+1/2, -y+1/2)',
                            '(-z+1/2, -x+1/2, y)', '(-z+1/2, x, -y+1/2)',
                            '(y, z, x)', '(-y+1/2, z, -x+1/2)',
                            '(y, -z+1/2, -x+1/2)', '(-y+1/2, -z+1/2, x)',
                            '(y+1/2, x+1/2, -z)', '(-y, -x, -z)',
                            '(y+1/2, -x, z+1/2)', '(-y, x+1/2, z+1/2)',
                            '(x+1/2, z+1/2, -y)', '(-x, z+1/2, y+1/2)',
                            '(-x, -z, -y)', '(x+1/2, -z, y+1/2)',
                            '(z+1/2, y+1/2, -x)', '(z+1/2, -y, x+1/2)',
                            '(-z, y+1/2, x+1/2)', '(-z, -y, -x)',
                            '(-x, -y, -z)', '(x+1/2, y+1/2, -z)',
                            '(x+1/2, -y, z+1/2)', '(-x, y+1/2, z+1/2)',
                            '(-z, -x, -y)', '(-z, x+1/2, y+1/2)',
                            '(z+1/2, x+1/2, -y)', '(z+1/2, -x, y+1/2)',
                            '(-y, -z, -x)', '(y+1/2, -z, x+1/2)',
                            '(-y, z+1/2, x+1/2)', '(y+1/2, z+1/2, -x)',
                            '(-y+1/2, -x+1/2, z)', '(y, x, z)',
                            '(-y+1/2, x, -z+1/2)', '(y, -x+1/2, -z+1/2)',
                            '(-x+1/2, -z+1/2, y)', '(x, -z+1/2, -y+1/2)',
                            '(x, z, y)', '(-x+1/2, z, -y+1/2)',
                            '(-z+1/2, -y+1/2, x)', '(-z+1/2, y, -x+1/2)',
                            '(z, -y+1/2, -x+1/2)', '(z, y, x)'))},
      '225': {'4a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)')),
              '4b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                         '(0, 0, 1/2)')),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(1/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(3/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)')),
              '24d': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)')),
              '24e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)')),
              '32f': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x, x, -x)', '(x, x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x+1/2, x+1/2, -x)',
                          '(-x, -x, -x)', '(-x, -x+1/2, -x+1/2)',
                          '(-x+1/2, -x, -x+1/2)', '(-x+1/2, -x+1/2, -x)',
                          '(x, -x, x)', '(x, -x+1/2, x+1/2)',
                          '(x+1/2, -x, x+1/2)', '(x+1/2, -x+1/2, x)',
                          '(-x, x, x)', '(-x, x+1/2, x+1/2)',
                          '(-x+1/2, x, x+1/2)', '(-x+1/2, x+1/2, x)')),
              '48g': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(1/4, x, 3/4)', '(1/4, x+1/2, 1/4)',
                          '(3/4, x, 1/4)', '(3/4, x+1/2, 3/4)',
                          '(3/4, -x, 3/4)', '(3/4, -x+1/2, 1/4)',
                          '(1/4, -x, 1/4)', '(1/4, -x+1/2, 3/4)',
                          '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                          '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)',
                          '(-x, 1/4, 1/4)', '(-x, 3/4, 3/4)',
                          '(-x+1/2, 1/4, 3/4)', '(-x+1/2, 3/4, 1/4)',
                          '(1/4, 1/4, -x)', '(1/4, 3/4, -x+1/2)',
                          '(3/4, 1/4, -x+1/2)', '(3/4, 3/4, -x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)')),
              '48h': (2, ('(0, y, y)', '(0, y+1/2, y+1/2)', '(1/2, y, y+1/2)',
                          '(1/2, y+1/2, y)', '(0, -y, y)',
                          '(0, -y+1/2, y+1/2)', '(1/2, -y, y+1/2)',
                          '(1/2, -y+1/2, y)', '(0, y, -y)',
                          '(0, y+1/2, -y+1/2)', '(1/2, y, -y+1/2)',
                          '(1/2, y+1/2, -y)', '(0, -y, -y)',
                          '(0, -y+1/2, -y+1/2)', '(1/2, -y, -y+1/2)',
                          '(1/2, -y+1/2, -y)', '(y, 0, y)', '(y, 1/2, y+1/2)',
                          '(y+1/2, 0, y+1/2)', '(y+1/2, 1/2, y)',
                          '(y, 0, -y)', '(y, 1/2, -y+1/2)',
                          '(y+1/2, 0, -y+1/2)', '(y+1/2, 1/2, -y)',
                          '(-y, 0, y)', '(-y, 1/2, y+1/2)',
                          '(-y+1/2, 0, y+1/2)', '(-y+1/2, 1/2, y)',
                          '(-y, 0, -y)', '(-y, 1/2, -y+1/2)',
                          '(-y+1/2, 0, -y+1/2)', '(-y+1/2, 1/2, -y)',
                          '(y, y, 0)', '(y, y+1/2, 1/2)', '(y+1/2, y, 1/2)',
                          '(y+1/2, y+1/2, 0)', '(-y, y, 0)',
                          '(-y, y+1/2, 1/2)', '(-y+1/2, y, 1/2)',
                          '(-y+1/2, y+1/2, 0)', '(y, -y, 0)',
                          '(y, -y+1/2, 1/2)', '(y+1/2, -y, 1/2)',
                          '(y+1/2, -y+1/2, 0)', '(-y, -y, 0)',
                          '(-y, -y+1/2, 1/2)', '(-y+1/2, -y, 1/2)',
                          '(-y+1/2, -y+1/2, 0)')),
              '48i': (2, ('(1/2, y, y)', '(1/2, y+1/2, y+1/2)',
                          '(0, y, y+1/2)', '(0, y+1/2, y)', '(1/2, -y, y)',
                          '(1/2, -y+1/2, y+1/2)', '(0, -y, y+1/2)',
                          '(0, -y+1/2, y)', '(1/2, y, -y)',
                          '(1/2, y+1/2, -y+1/2)', '(0, y, -y+1/2)',
                          '(0, y+1/2, -y)', '(1/2, -y, -y)',
                          '(1/2, -y+1/2, -y+1/2)', '(0, -y, -y+1/2)',
                          '(0, -y+1/2, -y)', '(y, 1/2, y)', '(y, 0, y+1/2)',
                          '(y+1/2, 1/2, y+1/2)', '(y+1/2, 0, y)',
                          '(y, 1/2, -y)', '(y, 0, -y+1/2)',
                          '(y+1/2, 1/2, -y+1/2)', '(y+1/2, 0, -y)',
                          '(-y, 1/2, y)', '(-y, 0, y+1/2)',
                          '(-y+1/2, 1/2, y+1/2)', '(-y+1/2, 0, y)',
                          '(-y, 1/2, -y)', '(-y, 0, -y+1/2)',
                          '(-y+1/2, 1/2, -y+1/2)', '(-y+1/2, 0, -y)',
                          '(y, y, 1/2)', '(y, y+1/2, 0)', '(y+1/2, y, 0)',
                          '(y+1/2, y+1/2, 1/2)', '(-y, y, 1/2)',
                          '(-y, y+1/2, 0)', '(-y+1/2, y, 0)',
                          '(-y+1/2, y+1/2, 1/2)', '(y, -y, 1/2)',
                          '(y, -y+1/2, 0)', '(y+1/2, -y, 0)',
                          '(y+1/2, -y+1/2, 1/2)', '(-y, -y, 1/2)',
                          '(-y, -y+1/2, 0)', '(-y+1/2, -y, 0)',
                          '(-y+1/2, -y+1/2, 1/2)')),
              '96j': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                          '(1/2, y+1/2, z)', '(0, -y, z)',
                          '(0, -y+1/2, z+1/2)', '(1/2, -y, z+1/2)',
                          '(1/2, -y+1/2, z)', '(0, y, -z)',
                          '(0, y+1/2, -z+1/2)', '(1/2, y, -z+1/2)',
                          '(1/2, y+1/2, -z)', '(0, -y, -z)',
                          '(0, -y+1/2, -z+1/2)', '(1/2, -y, -z+1/2)',
                          '(1/2, -y+1/2, -z)', '(z, 0, y)', '(z, 1/2, y+1/2)',
                          '(z+1/2, 0, y+1/2)', '(z+1/2, 1/2, y)',
                          '(z, 0, -y)', '(z, 1/2, -y+1/2)',
                          '(z+1/2, 0, -y+1/2)', '(z+1/2, 1/2, -y)',
                          '(-z, 0, y)', '(-z, 1/2, y+1/2)',
                          '(-z+1/2, 0, y+1/2)', '(-z+1/2, 1/2, y)',
                          '(-z, 0, -y)', '(-z, 1/2, -y+1/2)',
                          '(-z+1/2, 0, -y+1/2)', '(-z+1/2, 1/2, -y)',
                          '(y, z, 0)', '(y, z+1/2, 1/2)', '(y+1/2, z, 1/2)',
                          '(y+1/2, z+1/2, 0)', '(-y, z, 0)',
                          '(-y, z+1/2, 1/2)', '(-y+1/2, z, 1/2)',
                          '(-y+1/2, z+1/2, 0)', '(y, -z, 0)',
                          '(y, -z+1/2, 1/2)', '(y+1/2, -z, 1/2)',
                          '(y+1/2, -z+1/2, 0)', '(-y, -z, 0)',
                          '(-y, -z+1/2, 1/2)', '(-y+1/2, -z, 1/2)',
                          '(-y+1/2, -z+1/2, 0)', '(y, 0, -z)',
                          '(y, 1/2, -z+1/2)', '(y+1/2, 0, -z+1/2)',
                          '(y+1/2, 1/2, -z)', '(-y, 0, -z)',
                          '(-y, 1/2, -z+1/2)', '(-y+1/2, 0, -z+1/2)',
                          '(-y+1/2, 1/2, -z)', '(y, 0, z)', '(y, 1/2, z+1/2)',
                          '(y+1/2, 0, z+1/2)', '(y+1/2, 1/2, z)',
                          '(-y, 0, z)', '(-y, 1/2, z+1/2)',
                          '(-y+1/2, 0, z+1/2)', '(-y+1/2, 1/2, z)',
                          '(0, z, -y)', '(0, z+1/2, -y+1/2)',
                          '(1/2, z, -y+1/2)', '(1/2, z+1/2, -y)', '(0, z, y)',
                          '(0, z+1/2, y+1/2)', '(1/2, z, y+1/2)',
                          '(1/2, z+1/2, y)', '(0, -z, -y)',
                          '(0, -z+1/2, -y+1/2)', '(1/2, -z, -y+1/2)',
                          '(1/2, -z+1/2, -y)', '(0, -z, y)',
                          '(0, -z+1/2, y+1/2)', '(1/2, -z, y+1/2)',
                          '(1/2, -z+1/2, y)', '(z, y, 0)', '(z, y+1/2, 1/2)',
                          '(z+1/2, y, 1/2)', '(z+1/2, y+1/2, 0)',
                          '(z, -y, 0)', '(z, -y+1/2, 1/2)',
                          '(z+1/2, -y, 1/2)', '(z+1/2, -y+1/2, 0)',
                          '(-z, y, 0)', '(-z, y+1/2, 1/2)',
                          '(-z+1/2, y, 1/2)', '(-z+1/2, y+1/2, 0)',
                          '(-z, -y, 0)', '(-z, -y+1/2, 1/2)',
                          '(-z+1/2, -y, 1/2)', '(-z+1/2, -y+1/2, 0)')),
              '96k': (5, ('(x, x, z)', '(x, x+1/2, z+1/2)',
                          '(x+1/2, x, z+1/2)', '(x+1/2, x+1/2, z)',
                          '(-x, -x, z)', '(-x, -x+1/2, z+1/2)',
                          '(-x+1/2, -x, z+1/2)', '(-x+1/2, -x+1/2, z)',
                          '(-x, x, -z)', '(-x, x+1/2, -z+1/2)',
                          '(-x+1/2, x, -z+1/2)', '(-x+1/2, x+1/2, -z)',
                          '(x, -x, -z)', '(x, -x+1/2, -z+1/2)',
                          '(x+1/2, -x, -z+1/2)', '(x+1/2, -x+1/2, -z)',
                          '(z, x, x)', '(z, x+1/2, x+1/2)',
                          '(z+1/2, x, x+1/2)', '(z+1/2, x+1/2, x)',
                          '(z, -x, -x)', '(z, -x+1/2, -x+1/2)',
                          '(z+1/2, -x, -x+1/2)', '(z+1/2, -x+1/2, -x)',
                          '(-z, -x, x)', '(-z, -x+1/2, x+1/2)',
                          '(-z+1/2, -x, x+1/2)', '(-z+1/2, -x+1/2, x)',
                          '(-z, x, -x)', '(-z, x+1/2, -x+1/2)',
                          '(-z+1/2, x, -x+1/2)', '(-z+1/2, x+1/2, -x)',
                          '(x, z, x)', '(x, z+1/2, x+1/2)',
                          '(x+1/2, z, x+1/2)', '(x+1/2, z+1/2, x)',
                          '(-x, z, -x)', '(-x, z+1/2, -x+1/2)',
                          '(-x+1/2, z, -x+1/2)', '(-x+1/2, z+1/2, -x)',
                          '(x, -z, -x)', '(x, -z+1/2, -x+1/2)',
                          '(x+1/2, -z, -x+1/2)', '(x+1/2, -z+1/2, -x)',
                          '(-x, -z, x)', '(-x, -z+1/2, x+1/2)',
                          '(-x+1/2, -z, x+1/2)', '(-x+1/2, -z+1/2, x)',
                          '(x, x, -z)', '(x, x+1/2, -z+1/2)',
                          '(x+1/2, x, -z+1/2)', '(x+1/2, x+1/2, -z)',
                          '(-x, -x, -z)', '(-x, -x+1/2, -z+1/2)',
                          '(-x+1/2, -x, -z+1/2)', '(-x+1/2, -x+1/2, -z)',
                          '(x, -x, z)', '(x, -x+1/2, z+1/2)',
                          '(x+1/2, -x, z+1/2)', '(x+1/2, -x+1/2, z)',
                          '(-x, x, z)', '(-x, x+1/2, z+1/2)',
                          '(-x+1/2, x, z+1/2)', '(-x+1/2, x+1/2, z)',
                          '(x, z, -x)', '(x, z+1/2, -x+1/2)',
                          '(x+1/2, z, -x+1/2)', '(x+1/2, z+1/2, -x)',
                          '(-x, z, x)', '(-x, z+1/2, x+1/2)',
                          '(-x+1/2, z, x+1/2)', '(-x+1/2, z+1/2, x)',
                          '(-x, -z, -x)', '(-x, -z+1/2, -x+1/2)',
                          '(-x+1/2, -z, -x+1/2)', '(-x+1/2, -z+1/2, -x)',
                          '(x, -z, x)', '(x, -z+1/2, x+1/2)',
                          '(x+1/2, -z, x+1/2)', '(x+1/2, -z+1/2, x)',
                          '(z, x, -x)', '(z, x+1/2, -x+1/2)',
                          '(z+1/2, x, -x+1/2)', '(z+1/2, x+1/2, -x)',
                          '(z, -x, x)', '(z, -x+1/2, x+1/2)',
                          '(z+1/2, -x, x+1/2)', '(z+1/2, -x+1/2, x)',
                          '(-z, x, x)', '(-z, x+1/2, x+1/2)',
                          '(-z+1/2, x, x+1/2)', '(-z+1/2, x+1/2, x)',
                          '(-z, -x, -x)', '(-z, -x+1/2, -x+1/2)',
                          '(-z+1/2, -x, -x+1/2)', '(-z+1/2, -x+1/2, -x)')),
              '192l': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                           '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                           '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                           '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                           '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                           '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                           '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                           '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                           '(z, x, y)', '(z, x+1/2, y+1/2)',
                           '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                           '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                           '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                           '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                           '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                           '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                           '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                           '(y, z, x)', '(y, z+1/2, x+1/2)',
                           '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                           '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                           '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                           '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                           '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                           '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                           '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                           '(y, x, -z)', '(y, x+1/2, -z+1/2)',
                           '(y+1/2, x, -z+1/2)', '(y+1/2, x+1/2, -z)',
                           '(-y, -x, -z)', '(-y, -x+1/2, -z+1/2)',
                           '(-y+1/2, -x, -z+1/2)', '(-y+1/2, -x+1/2, -z)',
                           '(y, -x, z)', '(y, -x+1/2, z+1/2)',
                           '(y+1/2, -x, z+1/2)', '(y+1/2, -x+1/2, z)',
                           '(-y, x, z)', '(-y, x+1/2, z+1/2)',
                           '(-y+1/2, x, z+1/2)', '(-y+1/2, x+1/2, z)',
                           '(x, z, -y)', '(x, z+1/2, -y+1/2)',
                           '(x+1/2, z, -y+1/2)', '(x+1/2, z+1/2, -y)',
                           '(-x, z, y)', '(-x, z+1/2, y+1/2)',
                           '(-x+1/2, z, y+1/2)', '(-x+1/2, z+1/2, y)',
                           '(-x, -z, -y)', '(-x, -z+1/2, -y+1/2)',
                           '(-x+1/2, -z, -y+1/2)', '(-x+1/2, -z+1/2, -y)',
                           '(x, -z, y)', '(x, -z+1/2, y+1/2)',
                           '(x+1/2, -z, y+1/2)', '(x+1/2, -z+1/2, y)',
                           '(z, y, -x)', '(z, y+1/2, -x+1/2)',
                           '(z+1/2, y, -x+1/2)', '(z+1/2, y+1/2, -x)',
                           '(z, -y, x)', '(z, -y+1/2, x+1/2)',
                           '(z+1/2, -y, x+1/2)', '(z+1/2, -y+1/2, x)',
                           '(-z, y, x)', '(-z, y+1/2, x+1/2)',
                           '(-z+1/2, y, x+1/2)', '(-z+1/2, y+1/2, x)',
                           '(-z, -y, -x)', '(-z, -y+1/2, -x+1/2)',
                           '(-z+1/2, -y, -x+1/2)', '(-z+1/2, -y+1/2, -x)',
                           '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                           '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                           '(x, y, -z)', '(x, y+1/2, -z+1/2)',
                           '(x+1/2, y, -z+1/2)', '(x+1/2, y+1/2, -z)',
                           '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                           '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                           '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                           '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)',
                           '(-z, -x, -y)', '(-z, -x+1/2, -y+1/2)',
                           '(-z+1/2, -x, -y+1/2)', '(-z+1/2, -x+1/2, -y)',
                           '(-z, x, y)', '(-z, x+1/2, y+1/2)',
                           '(-z+1/2, x, y+1/2)', '(-z+1/2, x+1/2, y)',
                           '(z, x, -y)', '(z, x+1/2, -y+1/2)',
                           '(z+1/2, x, -y+1/2)', '(z+1/2, x+1/2, -y)',
                           '(z, -x, y)', '(z, -x+1/2, y+1/2)',
                           '(z+1/2, -x, y+1/2)', '(z+1/2, -x+1/2, y)',
                           '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                           '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                           '(y, -z, x)', '(y, -z+1/2, x+1/2)',
                           '(y+1/2, -z, x+1/2)', '(y+1/2, -z+1/2, x)',
                           '(-y, z, x)', '(-y, z+1/2, x+1/2)',
                           '(-y+1/2, z, x+1/2)', '(-y+1/2, z+1/2, x)',
                           '(y, z, -x)', '(y, z+1/2, -x+1/2)',
                           '(y+1/2, z, -x+1/2)', '(y+1/2, z+1/2, -x)',
                           '(-y, -x, z)', '(-y, -x+1/2, z+1/2)',
                           '(-y+1/2, -x, z+1/2)', '(-y+1/2, -x+1/2, z)',
                           '(y, x, z)', '(y, x+1/2, z+1/2)',
                           '(y+1/2, x, z+1/2)', '(y+1/2, x+1/2, z)',
                           '(-y, x, -z)', '(-y, x+1/2, -z+1/2)',
                           '(-y+1/2, x, -z+1/2)', '(-y+1/2, x+1/2, -z)',
                           '(y, -x, -z)', '(y, -x+1/2, -z+1/2)',
                           '(y+1/2, -x, -z+1/2)', '(y+1/2, -x+1/2, -z)',
                           '(-x, -z, y)', '(-x, -z+1/2, y+1/2)',
                           '(-x+1/2, -z, y+1/2)', '(-x+1/2, -z+1/2, y)',
                           '(x, -z, -y)', '(x, -z+1/2, -y+1/2)',
                           '(x+1/2, -z, -y+1/2)', '(x+1/2, -z+1/2, -y)',
                           '(x, z, y)', '(x, z+1/2, y+1/2)',
                           '(x+1/2, z, y+1/2)', '(x+1/2, z+1/2, y)',
                           '(-x, z, -y)', '(-x, z+1/2, -y+1/2)',
                           '(-x+1/2, z, -y+1/2)', '(-x+1/2, z+1/2, -y)',
                           '(-z, -y, x)', '(-z, -y+1/2, x+1/2)',
                           '(-z+1/2, -y, x+1/2)', '(-z+1/2, -y+1/2, x)',
                           '(-z, y, -x)', '(-z, y+1/2, -x+1/2)',
                           '(-z+1/2, y, -x+1/2)', '(-z+1/2, y+1/2, -x)',
                           '(z, -y, -x)', '(z, -y+1/2, -x+1/2)',
                           '(z+1/2, -y, -x+1/2)', '(z+1/2, -y+1/2, -x)',
                           '(z, y, x)', '(z, y+1/2, x+1/2)',
                           '(z+1/2, y, x+1/2)', '(z+1/2, y+1/2, x)'))},
      '226': {'8a': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                         '(3/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)',
                         '(1/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)')),
              '8b': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                         '(1/2, 1/2, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                         '(0, 1/2, 0)', '(0, 0, 1/2)')),
              '24c': (0, ('(1/4, 0, 0)', '(1/4, 1/2, 1/2)', '(3/4, 0, 1/2)',
                          '(3/4, 1/2, 0)', '(3/4, 0, 0)', '(3/4, 1/2, 1/2)',
                          '(1/4, 0, 1/2)', '(1/4, 1/2, 0)', '(0, 1/4, 0)',
                          '(0, 3/4, 1/2)', '(1/2, 1/4, 1/2)', '(1/2, 3/4, 0)',
                          '(0, 3/4, 0)', '(0, 1/4, 1/2)', '(1/2, 3/4, 1/2)',
                          '(1/2, 1/4, 0)', '(0, 0, 1/4)', '(0, 1/2, 3/4)',
                          '(1/2, 0, 3/4)', '(1/2, 1/2, 1/4)', '(0, 0, 3/4)',
                          '(0, 1/2, 1/4)', '(1/2, 0, 1/4)', '(1/2, 1/2, 3/4)'
                          )),
              '24d': (0, ('(0, 1/4, 1/4)', '(0, 3/4, 3/4)', '(1/2, 1/4, 3/4)',
                          '(1/2, 3/4, 1/4)', '(0, 3/4, 1/4)', '(0, 1/4, 3/4)',
                          '(1/2, 3/4, 3/4)', '(1/2, 1/4, 1/4)',
                          '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)', '(3/4, 0, 3/4)',
                          '(3/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                          '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                          '(3/4, 1/2, 3/4)', '(1/4, 1/4, 0)',
                          '(1/4, 3/4, 1/2)', '(3/4, 1/4, 1/2)',
                          '(3/4, 3/4, 0)', '(3/4, 1/4, 0)', '(3/4, 3/4, 1/2)',
                          '(1/4, 1/4, 1/2)', '(1/4, 3/4, 0)')),
              '48e': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                          '(x+1/2, 1/2, 0)', '(-x, 0, 0)', '(-x, 1/2, 1/2)',
                          '(-x+1/2, 0, 1/2)', '(-x+1/2, 1/2, 0)', '(0, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 0)', '(0, -x+1/2, 1/2)',
                          '(1/2, -x, 1/2)', '(1/2, -x+1/2, 0)', '(0, 0, x)',
                          '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                          '(1/2, 1/2, x)', '(0, 0, -x)', '(0, 1/2, -x+1/2)',
                          '(1/2, 0, -x+1/2)', '(1/2, 1/2, -x)',
                          '(1/2, x+1/2, 1/2)', '(1/2, x, 0)', '(0, x+1/2, 0)',
                          '(0, x, 1/2)', '(1/2, -x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 0)', '(0, -x, 1/2)',
                          '(x+1/2, 1/2, 1/2)', '(x+1/2, 0, 0)', '(x, 1/2, 0)',
                          '(x, 0, 1/2)', '(-x+1/2, 1/2, 1/2)',
                          '(-x+1/2, 0, 0)', '(-x, 1/2, 0)', '(-x, 0, 1/2)',
                          '(1/2, 1/2, -x+1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x)', '(0, 0, -x+1/2)',
                          '(1/2, 1/2, x+1/2)', '(1/2, 0, x)', '(0, 1/2, x)',
                          '(0, 0, x+1/2)')),
              '48f': (1, ('(x, 1/4, 1/4)', '(x, 3/4, 3/4)',
                          '(x+1/2, 1/4, 3/4)', '(x+1/2, 3/4, 1/4)',
                          '(-x, 3/4, 1/4)', '(-x, 1/4, 3/4)',
                          '(-x+1/2, 3/4, 3/4)', '(-x+1/2, 1/4, 1/4)',
                          '(1/4, x, 1/4)', '(1/4, x+1/2, 3/4)',
                          '(3/4, x, 3/4)', '(3/4, x+1/2, 1/4)',
                          '(1/4, -x, 3/4)', '(1/4, -x+1/2, 1/4)',
                          '(3/4, -x, 1/4)', '(3/4, -x+1/2, 3/4)',
                          '(1/4, 1/4, x)', '(1/4, 3/4, x+1/2)',
                          '(3/4, 1/4, x+1/2)', '(3/4, 3/4, x)',
                          '(3/4, 1/4, -x)', '(3/4, 3/4, -x+1/2)',
                          '(1/4, 1/4, -x+1/2)', '(1/4, 3/4, -x)',
                          '(-x, 3/4, 3/4)', '(-x, 1/4, 1/4)',
                          '(-x+1/2, 3/4, 1/4)', '(-x+1/2, 1/4, 3/4)',
                          '(x, 1/4, 3/4)', '(x, 3/4, 1/4)',
                          '(x+1/2, 1/4, 1/4)', '(x+1/2, 3/4, 3/4)',
                          '(3/4, -x, 3/4)', '(3/4, -x+1/2, 1/4)',
                          '(1/4, -x, 1/4)', '(1/4, -x+1/2, 3/4)',
                          '(3/4, x, 1/4)', '(3/4, x+1/2, 3/4)',
                          '(1/4, x, 3/4)', '(1/4, x+1/2, 1/4)',
                          '(3/4, 3/4, -x)', '(3/4, 1/4, -x+1/2)',
                          '(1/4, 3/4, -x+1/2)', '(1/4, 1/4, -x)',
                          '(1/4, 3/4, x)', '(1/4, 1/4, x+1/2)',
                          '(3/4, 3/4, x+1/2)', '(3/4, 1/4, x)')),
              '64g': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                          '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                          '(-x, -x, x)', '(-x, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x+1/2, -x+1/2, x)',
                          '(-x, x, -x)', '(-x, x+1/2, -x+1/2)',
                          '(-x+1/2, x, -x+1/2)', '(-x+1/2, x+1/2, -x)',
                          '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                          '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                          '(x+1/2, x+1/2, -x+1/2)', '(x+1/2, x, -x)',
                          '(x, x+1/2, -x)', '(x, x, -x+1/2)',
                          '(-x+1/2, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x)',
                          '(-x, -x+1/2, -x)', '(-x, -x, -x+1/2)',
                          '(x+1/2, -x+1/2, x+1/2)', '(x+1/2, -x, x)',
                          '(x, -x+1/2, x)', '(x, -x, x+1/2)',
                          '(-x+1/2, x+1/2, x+1/2)', '(-x+1/2, x, x)',
                          '(-x, x+1/2, x)', '(-x, x, x+1/2)', '(-x, -x, -x)',
                          '(-x, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x+1/2)',
                          '(-x+1/2, -x+1/2, -x)', '(x, x, -x)',
                          '(x, x+1/2, -x+1/2)', '(x+1/2, x, -x+1/2)',
                          '(x+1/2, x+1/2, -x)', '(x, -x, x)',
                          '(x, -x+1/2, x+1/2)', '(x+1/2, -x, x+1/2)',
                          '(x+1/2, -x+1/2, x)', '(-x, x, x)',
                          '(-x, x+1/2, x+1/2)', '(-x+1/2, x, x+1/2)',
                          '(-x+1/2, x+1/2, x)', '(-x+1/2, -x+1/2, x+1/2)',
                          '(-x+1/2, -x, x)', '(-x, -x+1/2, x)',
                          '(-x, -x, x+1/2)', '(x+1/2, x+1/2, x+1/2)',
                          '(x+1/2, x, x)', '(x, x+1/2, x)', '(x, x, x+1/2)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(-x, x+1/2, -x)', '(-x, x, -x+1/2)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(x+1/2, -x, -x)',
                          '(x, -x+1/2, -x)', '(x, -x, -x+1/2)')),
              '96h': (2, ('(1/4, y, y)', '(1/4, y+1/2, y+1/2)',
                          '(3/4, y, y+1/2)', '(3/4, y+1/2, y)',
                          '(3/4, -y, y)', '(3/4, -y+1/2, y+1/2)',
                          '(1/4, -y, y+1/2)', '(1/4, -y+1/2, y)',
                          '(3/4, y, -y)', '(3/4, y+1/2, -y+1/2)',
                          '(1/4, y, -y+1/2)', '(1/4, y+1/2, -y)',
                          '(1/4, -y, -y)', '(1/4, -y+1/2, -y+1/2)',
                          '(3/4, -y, -y+1/2)', '(3/4, -y+1/2, -y)',
                          '(y, 1/4, y)', '(y, 3/4, y+1/2)',
                          '(y+1/2, 1/4, y+1/2)', '(y+1/2, 3/4, y)',
                          '(y, 3/4, -y)', '(y, 1/4, -y+1/2)',
                          '(y+1/2, 3/4, -y+1/2)', '(y+1/2, 1/4, -y)',
                          '(-y, 3/4, y)', '(-y, 1/4, y+1/2)',
                          '(-y+1/2, 3/4, y+1/2)', '(-y+1/2, 1/4, y)',
                          '(-y, 1/4, -y)', '(-y, 3/4, -y+1/2)',
                          '(-y+1/2, 1/4, -y+1/2)', '(-y+1/2, 3/4, -y)',
                          '(y, y, 1/4)', '(y, y+1/2, 3/4)', '(y+1/2, y, 3/4)',
                          '(y+1/2, y+1/2, 1/4)', '(-y, y, 3/4)',
                          '(-y, y+1/2, 1/4)', '(-y+1/2, y, 1/4)',
                          '(-y+1/2, y+1/2, 3/4)', '(y, -y, 3/4)',
                          '(y, -y+1/2, 1/4)', '(y+1/2, -y, 1/4)',
                          '(y+1/2, -y+1/2, 3/4)', '(-y, -y, 1/4)',
                          '(-y, -y+1/2, 3/4)', '(-y+1/2, -y, 3/4)',
                          '(-y+1/2, -y+1/2, 1/4)', '(3/4, -y, -y)',
                          '(3/4, -y+1/2, -y+1/2)', '(1/4, -y, -y+1/2)',
                          '(1/4, -y+1/2, -y)', '(1/4, y, -y)',
                          '(1/4, y+1/2, -y+1/2)', '(3/4, y, -y+1/2)',
                          '(3/4, y+1/2, -y)', '(1/4, -y, y)',
                          '(1/4, -y+1/2, y+1/2)', '(3/4, -y, y+1/2)',
                          '(3/4, -y+1/2, y)', '(3/4, y, y)',
                          '(3/4, y+1/2, y+1/2)', '(1/4, y, y+1/2)',
                          '(1/4, y+1/2, y)', '(-y, 3/4, -y)',
                          '(-y, 1/4, -y+1/2)', '(-y+1/2, 3/4, -y+1/2)',
                          '(-y+1/2, 1/4, -y)', '(-y, 1/4, y)',
                          '(-y, 3/4, y+1/2)', '(-y+1/2, 1/4, y+1/2)',
                          '(-y+1/2, 3/4, y)', '(y, 1/4, -y)',
                          '(y, 3/4, -y+1/2)', '(y+1/2, 1/4, -y+1/2)',
                          '(y+1/2, 3/4, -y)', '(y, 3/4, y)',
                          '(y, 1/4, y+1/2)', '(y+1/2, 3/4, y+1/2)',
                          '(y+1/2, 1/4, y)', '(-y, -y, 3/4)',
                          '(-y, -y+1/2, 1/4)', '(-y+1/2, -y, 1/4)',
                          '(-y+1/2, -y+1/2, 3/4)', '(y, -y, 1/4)',
                          '(y, -y+1/2, 3/4)', '(y+1/2, -y, 3/4)',
                          '(y+1/2, -y+1/2, 1/4)', '(-y, y, 1/4)',
                          '(-y, y+1/2, 3/4)', '(-y+1/2, y, 3/4)',
                          '(-y+1/2, y+1/2, 1/4)', '(y, y, 3/4)',
                          '(y, y+1/2, 1/4)', '(y+1/2, y, 1/4)',
                          '(y+1/2, y+1/2, 3/4)')),
              '96i': (6, ('(0, y, z)', '(0, y+1/2, z+1/2)', '(1/2, y, z+1/2)',
                          '(1/2, y+1/2, z)', '(0, -y, z)',
                          '(0, -y+1/2, z+1/2)', '(1/2, -y, z+1/2)',
                          '(1/2, -y+1/2, z)', '(0, y, -z)',
                          '(0, y+1/2, -z+1/2)', '(1/2, y, -z+1/2)',
                          '(1/2, y+1/2, -z)', '(0, -y, -z)',
                          '(0, -y+1/2, -z+1/2)', '(1/2, -y, -z+1/2)',
                          '(1/2, -y+1/2, -z)', '(z, 0, y)', '(z, 1/2, y+1/2)',
                          '(z+1/2, 0, y+1/2)', '(z+1/2, 1/2, y)',
                          '(z, 0, -y)', '(z, 1/2, -y+1/2)',
                          '(z+1/2, 0, -y+1/2)', '(z+1/2, 1/2, -y)',
                          '(-z, 0, y)', '(-z, 1/2, y+1/2)',
                          '(-z+1/2, 0, y+1/2)', '(-z+1/2, 1/2, y)',
                          '(-z, 0, -y)', '(-z, 1/2, -y+1/2)',
                          '(-z+1/2, 0, -y+1/2)', '(-z+1/2, 1/2, -y)',
                          '(y, z, 0)', '(y, z+1/2, 1/2)', '(y+1/2, z, 1/2)',
                          '(y+1/2, z+1/2, 0)', '(-y, z, 0)',
                          '(-y, z+1/2, 1/2)', '(-y+1/2, z, 1/2)',
                          '(-y+1/2, z+1/2, 0)', '(y, -z, 0)',
                          '(y, -z+1/2, 1/2)', '(y+1/2, -z, 1/2)',
                          '(y+1/2, -z+1/2, 0)', '(-y, -z, 0)',
                          '(-y, -z+1/2, 1/2)', '(-y+1/2, -z, 1/2)',
                          '(-y+1/2, -z+1/2, 0)', '(y+1/2, 1/2, -z+1/2)',
                          '(y+1/2, 0, -z)', '(y, 1/2, -z)', '(y, 0, -z+1/2)',
                          '(-y+1/2, 1/2, -z+1/2)', '(-y+1/2, 0, -z)',
                          '(-y, 1/2, -z)', '(-y, 0, -z+1/2)',
                          '(y+1/2, 1/2, z+1/2)', '(y+1/2, 0, z)',
                          '(y, 1/2, z)', '(y, 0, z+1/2)',
                          '(-y+1/2, 1/2, z+1/2)', '(-y+1/2, 0, z)',
                          '(-y, 1/2, z)', '(-y, 0, z+1/2)',
                          '(1/2, z+1/2, -y+1/2)', '(1/2, z, -y)',
                          '(0, z+1/2, -y)', '(0, z, -y+1/2)',
                          '(1/2, z+1/2, y+1/2)', '(1/2, z, y)',
                          '(0, z+1/2, y)', '(0, z, y+1/2)',
                          '(1/2, -z+1/2, -y+1/2)', '(1/2, -z, -y)',
                          '(0, -z+1/2, -y)', '(0, -z, -y+1/2)',
                          '(1/2, -z+1/2, y+1/2)', '(1/2, -z, y)',
                          '(0, -z+1/2, y)', '(0, -z, y+1/2)',
                          '(z+1/2, y+1/2, 1/2)', '(z+1/2, y, 0)',
                          '(z, y+1/2, 0)', '(z, y, 1/2)',
                          '(z+1/2, -y+1/2, 1/2)', '(z+1/2, -y, 0)',
                          '(z, -y+1/2, 0)', '(z, -y, 1/2)',
                          '(-z+1/2, y+1/2, 1/2)', '(-z+1/2, y, 0)',
                          '(-z, y+1/2, 0)', '(-z, y, 1/2)',
                          '(-z+1/2, -y+1/2, 1/2)', '(-z+1/2, -y, 0)',
                          '(-z, -y+1/2, 0)', '(-z, -y, 1/2)')),
              '192j': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                           '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                           '(-x, -y, z)', '(-x, -y+1/2, z+1/2)',
                           '(-x+1/2, -y, z+1/2)', '(-x+1/2, -y+1/2, z)',
                           '(-x, y, -z)', '(-x, y+1/2, -z+1/2)',
                           '(-x+1/2, y, -z+1/2)', '(-x+1/2, y+1/2, -z)',
                           '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                           '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                           '(z, x, y)', '(z, x+1/2, y+1/2)',
                           '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                           '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                           '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                           '(-z, -x, y)', '(-z, -x+1/2, y+1/2)',
                           '(-z+1/2, -x, y+1/2)', '(-z+1/2, -x+1/2, y)',
                           '(-z, x, -y)', '(-z, x+1/2, -y+1/2)',
                           '(-z+1/2, x, -y+1/2)', '(-z+1/2, x+1/2, -y)',
                           '(y, z, x)', '(y, z+1/2, x+1/2)',
                           '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                           '(-y, z, -x)', '(-y, z+1/2, -x+1/2)',
                           '(-y+1/2, z, -x+1/2)', '(-y+1/2, z+1/2, -x)',
                           '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                           '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                           '(-y, -z, x)', '(-y, -z+1/2, x+1/2)',
                           '(-y+1/2, -z, x+1/2)', '(-y+1/2, -z+1/2, x)',
                           '(y+1/2, x+1/2, -z+1/2)', '(y+1/2, x, -z)',
                           '(y, x+1/2, -z)', '(y, x, -z+1/2)',
                           '(-y+1/2, -x+1/2, -z+1/2)', '(-y+1/2, -x, -z)',
                           '(-y, -x+1/2, -z)', '(-y, -x, -z+1/2)',
                           '(y+1/2, -x+1/2, z+1/2)', '(y+1/2, -x, z)',
                           '(y, -x+1/2, z)', '(y, -x, z+1/2)',
                           '(-y+1/2, x+1/2, z+1/2)', '(-y+1/2, x, z)',
                           '(-y, x+1/2, z)', '(-y, x, z+1/2)',
                           '(x+1/2, z+1/2, -y+1/2)', '(x+1/2, z, -y)',
                           '(x, z+1/2, -y)', '(x, z, -y+1/2)',
                           '(-x+1/2, z+1/2, y+1/2)', '(-x+1/2, z, y)',
                           '(-x, z+1/2, y)', '(-x, z, y+1/2)',
                           '(-x+1/2, -z+1/2, -y+1/2)', '(-x+1/2, -z, -y)',
                           '(-x, -z+1/2, -y)', '(-x, -z, -y+1/2)',
                           '(x+1/2, -z+1/2, y+1/2)', '(x+1/2, -z, y)',
                           '(x, -z+1/2, y)', '(x, -z, y+1/2)',
                           '(z+1/2, y+1/2, -x+1/2)', '(z+1/2, y, -x)',
                           '(z, y+1/2, -x)', '(z, y, -x+1/2)',
                           '(z+1/2, -y+1/2, x+1/2)', '(z+1/2, -y, x)',
                           '(z, -y+1/2, x)', '(z, -y, x+1/2)',
                           '(-z+1/2, y+1/2, x+1/2)', '(-z+1/2, y, x)',
                           '(-z, y+1/2, x)', '(-z, y, x+1/2)',
                           '(-z+1/2, -y+1/2, -x+1/2)', '(-z+1/2, -y, -x)',
                           '(-z, -y+1/2, -x)', '(-z, -y, -x+1/2)',
                           '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                           '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                           '(x, y, -z)', '(x, y+1/2, -z+1/2)',
                           '(x+1/2, y, -z+1/2)', '(x+1/2, y+1/2, -z)',
                           '(x, -y, z)', '(x, -y+1/2, z+1/2)',
                           '(x+1/2, -y, z+1/2)', '(x+1/2, -y+1/2, z)',
                           '(-x, y, z)', '(-x, y+1/2, z+1/2)',
                           '(-x+1/2, y, z+1/2)', '(-x+1/2, y+1/2, z)',
                           '(-z, -x, -y)', '(-z, -x+1/2, -y+1/2)',
                           '(-z+1/2, -x, -y+1/2)', '(-z+1/2, -x+1/2, -y)',
                           '(-z, x, y)', '(-z, x+1/2, y+1/2)',
                           '(-z+1/2, x, y+1/2)', '(-z+1/2, x+1/2, y)',
                           '(z, x, -y)', '(z, x+1/2, -y+1/2)',
                           '(z+1/2, x, -y+1/2)', '(z+1/2, x+1/2, -y)',
                           '(z, -x, y)', '(z, -x+1/2, y+1/2)',
                           '(z+1/2, -x, y+1/2)', '(z+1/2, -x+1/2, y)',
                           '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                           '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                           '(y, -z, x)', '(y, -z+1/2, x+1/2)',
                           '(y+1/2, -z, x+1/2)', '(y+1/2, -z+1/2, x)',
                           '(-y, z, x)', '(-y, z+1/2, x+1/2)',
                           '(-y+1/2, z, x+1/2)', '(-y+1/2, z+1/2, x)',
                           '(y, z, -x)', '(y, z+1/2, -x+1/2)',
                           '(y+1/2, z, -x+1/2)', '(y+1/2, z+1/2, -x)',
                           '(-y+1/2, -x+1/2, z+1/2)', '(-y+1/2, -x, z)',
                           '(-y, -x+1/2, z)', '(-y, -x, z+1/2)',
                           '(y+1/2, x+1/2, z+1/2)', '(y+1/2, x, z)',
                           '(y, x+1/2, z)', '(y, x, z+1/2)',
                           '(-y+1/2, x+1/2, -z+1/2)', '(-y+1/2, x, -z)',
                           '(-y, x+1/2, -z)', '(-y, x, -z+1/2)',
                           '(y+1/2, -x+1/2, -z+1/2)', '(y+1/2, -x, -z)',
                           '(y, -x+1/2, -z)', '(y, -x, -z+1/2)',
                           '(-x+1/2, -z+1/2, y+1/2)', '(-x+1/2, -z, y)',
                           '(-x, -z+1/2, y)', '(-x, -z, y+1/2)',
                           '(x+1/2, -z+1/2, -y+1/2)', '(x+1/2, -z, -y)',
                           '(x, -z+1/2, -y)', '(x, -z, -y+1/2)',
                           '(x+1/2, z+1/2, y+1/2)', '(x+1/2, z, y)',
                           '(x, z+1/2, y)', '(x, z, y+1/2)',
                           '(-x+1/2, z+1/2, -y+1/2)', '(-x+1/2, z, -y)',
                           '(-x, z+1/2, -y)', '(-x, z, -y+1/2)',
                           '(-z+1/2, -y+1/2, x+1/2)', '(-z+1/2, -y, x)',
                           '(-z, -y+1/2, x)', '(-z, -y, x+1/2)',
                           '(-z+1/2, y+1/2, -x+1/2)', '(-z+1/2, y, -x)',
                           '(-z, y+1/2, -x)', '(-z, y, -x+1/2)',
                           '(z+1/2, -y+1/2, -x+1/2)', '(z+1/2, -y, -x)',
                           '(z, -y+1/2, -x)', '(z, -y, -x+1/2)',
                           '(z+1/2, y+1/2, x+1/2)', '(z+1/2, y, x)',
                           '(z, y+1/2, x)', '(z, y, x+1/2)'))},
      '227:1': {'8a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                           '(1/2, 1/2, 0)', '(3/4, 1/4, 3/4)',
                           '(3/4, 3/4, 1/4)', '(1/4, 1/4, 1/4)',
                           '(1/4, 3/4, 3/4)')),
                '8b': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                           '(0, 0, 1/2)', '(1/4, 3/4, 1/4)',
                           '(1/4, 1/4, 3/4)', '(3/4, 3/4, 3/4)',
                           '(3/4, 1/4, 1/4)')),
                '16c': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                            '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                            '(7/8, 3/8, 5/8)', '(7/8, 7/8, 1/8)',
                            '(3/8, 3/8, 1/8)', '(3/8, 7/8, 5/8)',
                            '(3/8, 5/8, 7/8)', '(3/8, 1/8, 3/8)',
                            '(7/8, 5/8, 3/8)', '(7/8, 1/8, 7/8)',
                            '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)',
                            '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)')),
                '16d': (0, ('(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                            '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                            '(3/8, 7/8, 1/8)', '(3/8, 3/8, 5/8)',
                            '(7/8, 7/8, 5/8)', '(7/8, 3/8, 1/8)',
                            '(7/8, 1/8, 3/8)', '(7/8, 5/8, 7/8)',
                            '(3/8, 1/8, 7/8)', '(3/8, 5/8, 3/8)',
                            '(1/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)',
                            '(5/8, 3/8, 3/8)', '(5/8, 7/8, 7/8)')),
                '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x, -x+1/2, x+1/2)', '(-x, -x, x)',
                            '(-x+1/2, -x+1/2, x)', '(-x+1/2, -x, x+1/2)',
                            '(-x+1/2, x+1/2, -x)', '(-x+1/2, x, -x+1/2)',
                            '(-x, x+1/2, -x+1/2)', '(-x, x, -x)',
                            '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                            '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                            '(x+3/4, x+1/4, -x+3/4)',
                            '(x+3/4, x+3/4, -x+1/4)',
                            '(x+1/4, x+1/4, -x+1/4)',
                            '(x+1/4, x+3/4, -x+3/4)',
                            '(-x+1/4, -x+1/4, -x+1/4)',
                            '(-x+1/4, -x+3/4, -x+3/4)',
                            '(-x+3/4, -x+1/4, -x+3/4)',
                            '(-x+3/4, -x+3/4, -x+1/4)',
                            '(x+1/4, -x+3/4, x+3/4)',
                            '(x+1/4, -x+1/4, x+1/4)',
                            '(x+3/4, -x+3/4, x+1/4)',
                            '(x+3/4, -x+1/4, x+3/4)',
                            '(-x+3/4, x+3/4, x+1/4)',
                            '(-x+3/4, x+1/4, x+3/4)',
                            '(-x+1/4, x+3/4, x+3/4)',
                            '(-x+1/4, x+1/4, x+1/4)')),
                '48f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                            '(x+1/2, 1/2, 0)', '(-x, 1/2, 1/2)', '(-x, 0, 0)',
                            '(-x+1/2, 1/2, 0)', '(-x+1/2, 0, 1/2)',
                            '(0, x, 0)', '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                            '(1/2, x+1/2, 0)', '(1/2, -x, 1/2)',
                            '(1/2, -x+1/2, 0)', '(0, -x, 0)',
                            '(0, -x+1/2, 1/2)', '(0, 0, x)',
                            '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                            '(1/2, 1/2, x)', '(1/2, 1/2, -x)',
                            '(1/2, 0, -x+1/2)', '(0, 1/2, -x+1/2)',
                            '(0, 0, -x)', '(3/4, x+1/4, 3/4)',
                            '(3/4, x+3/4, 1/4)', '(1/4, x+1/4, 1/4)',
                            '(1/4, x+3/4, 3/4)', '(1/4, -x+1/4, 1/4)',
                            '(1/4, -x+3/4, 3/4)', '(3/4, -x+1/4, 3/4)',
                            '(3/4, -x+3/4, 1/4)', '(x+3/4, 1/4, 3/4)',
                            '(x+3/4, 3/4, 1/4)', '(x+1/4, 1/4, 1/4)',
                            '(x+1/4, 3/4, 3/4)', '(-x+3/4, 3/4, 1/4)',
                            '(-x+3/4, 1/4, 3/4)', '(-x+1/4, 3/4, 3/4)',
                            '(-x+1/4, 1/4, 1/4)', '(3/4, 1/4, -x+3/4)',
                            '(3/4, 3/4, -x+1/4)', '(1/4, 1/4, -x+1/4)',
                            '(1/4, 3/4, -x+3/4)', '(1/4, 3/4, x+3/4)',
                            '(1/4, 1/4, x+1/4)', '(3/4, 3/4, x+1/4)',
                            '(3/4, 1/4, x+3/4)')),
                '96g': (5, ('(x, x, z)', '(x, x+1/2, z+1/2)',
                            '(x+1/2, x, z+1/2)', '(x+1/2, x+1/2, z)',
                            '(-x, -x+1/2, z+1/2)', '(-x, -x, z)',
                            '(-x+1/2, -x+1/2, z)', '(-x+1/2, -x, z+1/2)',
                            '(-x+1/2, x+1/2, -z)', '(-x+1/2, x, -z+1/2)',
                            '(-x, x+1/2, -z+1/2)', '(-x, x, -z)',
                            '(x+1/2, -x, -z+1/2)', '(x+1/2, -x+1/2, -z)',
                            '(x, -x, -z)', '(x, -x+1/2, -z+1/2)', '(z, x, x)',
                            '(z, x+1/2, x+1/2)', '(z+1/2, x, x+1/2)',
                            '(z+1/2, x+1/2, x)', '(z+1/2, -x, -x+1/2)',
                            '(z+1/2, -x+1/2, -x)', '(z, -x, -x)',
                            '(z, -x+1/2, -x+1/2)', '(-z, -x+1/2, x+1/2)',
                            '(-z, -x, x)', '(-z+1/2, -x+1/2, x)',
                            '(-z+1/2, -x, x+1/2)', '(-z+1/2, x+1/2, -x)',
                            '(-z+1/2, x, -x+1/2)', '(-z, x+1/2, -x+1/2)',
                            '(-z, x, -x)', '(x, z, x)', '(x, z+1/2, x+1/2)',
                            '(x+1/2, z, x+1/2)', '(x+1/2, z+1/2, x)',
                            '(-x+1/2, z+1/2, -x)', '(-x+1/2, z, -x+1/2)',
                            '(-x, z+1/2, -x+1/2)', '(-x, z, -x)',
                            '(x+1/2, -z, -x+1/2)', '(x+1/2, -z+1/2, -x)',
                            '(x, -z, -x)', '(x, -z+1/2, -x+1/2)',
                            '(-x, -z+1/2, x+1/2)', '(-x, -z, x)',
                            '(-x+1/2, -z+1/2, x)', '(-x+1/2, -z, x+1/2)',
                            '(x+3/4, x+1/4, -z+3/4)',
                            '(x+3/4, x+3/4, -z+1/4)',
                            '(x+1/4, x+1/4, -z+1/4)',
                            '(x+1/4, x+3/4, -z+3/4)',
                            '(-x+1/4, -x+1/4, -z+1/4)',
                            '(-x+1/4, -x+3/4, -z+3/4)',
                            '(-x+3/4, -x+1/4, -z+3/4)',
                            '(-x+3/4, -x+3/4, -z+1/4)',
                            '(x+1/4, -x+3/4, z+3/4)',
                            '(x+1/4, -x+1/4, z+1/4)',
                            '(x+3/4, -x+3/4, z+1/4)',
                            '(x+3/4, -x+1/4, z+3/4)',
                            '(-x+3/4, x+3/4, z+1/4)',
                            '(-x+3/4, x+1/4, z+3/4)',
                            '(-x+1/4, x+3/4, z+3/4)',
                            '(-x+1/4, x+1/4, z+1/4)',
                            '(x+3/4, z+1/4, -x+3/4)',
                            '(x+3/4, z+3/4, -x+1/4)',
                            '(x+1/4, z+1/4, -x+1/4)',
                            '(x+1/4, z+3/4, -x+3/4)',
                            '(-x+3/4, z+3/4, x+1/4)',
                            '(-x+3/4, z+1/4, x+3/4)',
                            '(-x+1/4, z+3/4, x+3/4)',
                            '(-x+1/4, z+1/4, x+1/4)',
                            '(-x+1/4, -z+1/4, -x+1/4)',
                            '(-x+1/4, -z+3/4, -x+3/4)',
                            '(-x+3/4, -z+1/4, -x+3/4)',
                            '(-x+3/4, -z+3/4, -x+1/4)',
                            '(x+1/4, -z+3/4, x+3/4)',
                            '(x+1/4, -z+1/4, x+1/4)',
                            '(x+3/4, -z+3/4, x+1/4)',
                            '(x+3/4, -z+1/4, x+3/4)',
                            '(z+3/4, x+1/4, -x+3/4)',
                            '(z+3/4, x+3/4, -x+1/4)',
                            '(z+1/4, x+1/4, -x+1/4)',
                            '(z+1/4, x+3/4, -x+3/4)',
                            '(z+1/4, -x+3/4, x+3/4)',
                            '(z+1/4, -x+1/4, x+1/4)',
                            '(z+3/4, -x+3/4, x+1/4)',
                            '(z+3/4, -x+1/4, x+3/4)',
                            '(-z+3/4, x+3/4, x+1/4)',
                            '(-z+3/4, x+1/4, x+3/4)',
                            '(-z+1/4, x+3/4, x+3/4)',
                            '(-z+1/4, x+1/4, x+1/4)',
                            '(-z+1/4, -x+1/4, -x+1/4)',
                            '(-z+1/4, -x+3/4, -x+3/4)',
                            '(-z+3/4, -x+1/4, -x+3/4)',
                            '(-z+3/4, -x+3/4, -x+1/4)')),
                '96h': (2, ('(1/8, y, -y+1/4)', '(1/8, y+1/2, -y+3/4)',
                            '(5/8, y, -y+3/4)', '(5/8, y+1/2, -y+1/4)',
                            '(7/8, -y+1/2, -y+3/4)', '(7/8, -y, -y+1/4)',
                            '(3/8, -y+1/2, -y+1/4)', '(3/8, -y, -y+3/4)',
                            '(3/8, y+1/2, y+3/4)', '(3/8, y, y+1/4)',
                            '(7/8, y+1/2, y+1/4)', '(7/8, y, y+3/4)',
                            '(5/8, -y, y+1/4)', '(5/8, -y+1/2, y+3/4)',
                            '(1/8, -y, y+3/4)', '(1/8, -y+1/2, y+1/4)',
                            '(-y+1/4, 1/8, y)', '(-y+1/4, 5/8, y+1/2)',
                            '(-y+3/4, 1/8, y+1/2)', '(-y+3/4, 5/8, y)',
                            '(-y+3/4, 7/8, -y+1/2)', '(-y+3/4, 3/8, -y)',
                            '(-y+1/4, 7/8, -y)', '(-y+1/4, 3/8, -y+1/2)',
                            '(y+3/4, 3/8, y+1/2)', '(y+3/4, 7/8, y)',
                            '(y+1/4, 3/8, y)', '(y+1/4, 7/8, y+1/2)',
                            '(y+1/4, 5/8, -y)', '(y+1/4, 1/8, -y+1/2)',
                            '(y+3/4, 5/8, -y+1/2)', '(y+3/4, 1/8, -y)',
                            '(y, -y+1/4, 1/8)', '(y, -y+3/4, 5/8)',
                            '(y+1/2, -y+1/4, 5/8)', '(y+1/2, -y+3/4, 1/8)',
                            '(-y+1/2, -y+3/4, 7/8)', '(-y+1/2, -y+1/4, 3/8)',
                            '(-y, -y+3/4, 3/8)', '(-y, -y+1/4, 7/8)',
                            '(y+1/2, y+3/4, 3/8)', '(y+1/2, y+1/4, 7/8)',
                            '(y, y+3/4, 7/8)', '(y, y+1/4, 3/8)',
                            '(-y, y+1/4, 5/8)', '(-y, y+3/4, 1/8)',
                            '(-y+1/2, y+1/4, 1/8)', '(-y+1/2, y+3/4, 5/8)',
                            '(1/8, -y+1/4, y)', '(1/8, -y+3/4, y+1/2)',
                            '(5/8, -y+1/4, y+1/2)', '(5/8, -y+3/4, y)',
                            '(3/8, y+3/4, y+1/2)', '(3/8, y+1/4, y)',
                            '(7/8, y+3/4, y)', '(7/8, y+1/4, y+1/2)',
                            '(7/8, -y+3/4, -y+1/2)', '(7/8, -y+1/4, -y)',
                            '(3/8, -y+3/4, -y)', '(3/8, -y+1/4, -y+1/2)',
                            '(5/8, y+1/4, -y)', '(5/8, y+3/4, -y+1/2)',
                            '(1/8, y+1/4, -y+1/2)', '(1/8, y+3/4, -y)',
                            '(y, 1/8, -y+1/4)', '(y, 5/8, -y+3/4)',
                            '(y+1/2, 1/8, -y+3/4)', '(y+1/2, 5/8, -y+1/4)',
                            '(y+1/2, 3/8, y+3/4)', '(y+1/2, 7/8, y+1/4)',
                            '(y, 3/8, y+1/4)', '(y, 7/8, y+3/4)',
                            '(-y+1/2, 7/8, -y+3/4)', '(-y+1/2, 3/8, -y+1/4)',
                            '(-y, 7/8, -y+1/4)', '(-y, 3/8, -y+3/4)',
                            '(-y, 5/8, y+1/4)', '(-y, 1/8, y+3/4)',
                            '(-y+1/2, 5/8, y+3/4)', '(-y+1/2, 1/8, y+1/4)',
                            '(-y+1/4, y, 1/8)', '(-y+1/4, y+1/2, 5/8)',
                            '(-y+3/4, y, 5/8)', '(-y+3/4, y+1/2, 1/8)',
                            '(y+3/4, y+1/2, 3/8)', '(y+3/4, y, 7/8)',
                            '(y+1/4, y+1/2, 7/8)', '(y+1/4, y, 3/8)',
                            '(-y+3/4, -y+1/2, 7/8)', '(-y+3/4, -y, 3/8)',
                            '(-y+1/4, -y+1/2, 3/8)', '(-y+1/4, -y, 7/8)',
                            '(y+1/4, -y, 5/8)', '(y+1/4, -y+1/2, 1/8)',
                            '(y+3/4, -y, 1/8)', '(y+3/4, -y+1/2, 5/8)')),
                '192i': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                             '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                             '(-x, -y+1/2, z+1/2)', '(-x, -y, z)',
                             '(-x+1/2, -y+1/2, z)', '(-x+1/2, -y, z+1/2)',
                             '(-x+1/2, y+1/2, -z)', '(-x+1/2, y, -z+1/2)',
                             '(-x, y+1/2, -z+1/2)', '(-x, y, -z)',
                             '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                             '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                             '(z, x, y)', '(z, x+1/2, y+1/2)',
                             '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                             '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                             '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                             '(-z, -x+1/2, y+1/2)', '(-z, -x, y)',
                             '(-z+1/2, -x+1/2, y)', '(-z+1/2, -x, y+1/2)',
                             '(-z+1/2, x+1/2, -y)', '(-z+1/2, x, -y+1/2)',
                             '(-z, x+1/2, -y+1/2)', '(-z, x, -y)',
                             '(y, z, x)', '(y, z+1/2, x+1/2)',
                             '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                             '(-y+1/2, z+1/2, -x)', '(-y+1/2, z, -x+1/2)',
                             '(-y, z+1/2, -x+1/2)', '(-y, z, -x)',
                             '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                             '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                             '(-y, -z+1/2, x+1/2)', '(-y, -z, x)',
                             '(-y+1/2, -z+1/2, x)', '(-y+1/2, -z, x+1/2)',
                             '(y+3/4, x+1/4, -z+3/4)',
                             '(y+3/4, x+3/4, -z+1/4)',
                             '(y+1/4, x+1/4, -z+1/4)',
                             '(y+1/4, x+3/4, -z+3/4)',
                             '(-y+1/4, -x+1/4, -z+1/4)',
                             '(-y+1/4, -x+3/4, -z+3/4)',
                             '(-y+3/4, -x+1/4, -z+3/4)',
                             '(-y+3/4, -x+3/4, -z+1/4)',
                             '(y+1/4, -x+3/4, z+3/4)',
                             '(y+1/4, -x+1/4, z+1/4)',
                             '(y+3/4, -x+3/4, z+1/4)',
                             '(y+3/4, -x+1/4, z+3/4)',
                             '(-y+3/4, x+3/4, z+1/4)',
                             '(-y+3/4, x+1/4, z+3/4)',
                             '(-y+1/4, x+3/4, z+3/4)',
                             '(-y+1/4, x+1/4, z+1/4)',
                             '(x+3/4, z+1/4, -y+3/4)',
                             '(x+3/4, z+3/4, -y+1/4)',
                             '(x+1/4, z+1/4, -y+1/4)',
                             '(x+1/4, z+3/4, -y+3/4)',
                             '(-x+3/4, z+3/4, y+1/4)',
                             '(-x+3/4, z+1/4, y+3/4)',
                             '(-x+1/4, z+3/4, y+3/4)',
                             '(-x+1/4, z+1/4, y+1/4)',
                             '(-x+1/4, -z+1/4, -y+1/4)',
                             '(-x+1/4, -z+3/4, -y+3/4)',
                             '(-x+3/4, -z+1/4, -y+3/4)',
                             '(-x+3/4, -z+3/4, -y+1/4)',
                             '(x+1/4, -z+3/4, y+3/4)',
                             '(x+1/4, -z+1/4, y+1/4)',
                             '(x+3/4, -z+3/4, y+1/4)',
                             '(x+3/4, -z+1/4, y+3/4)',
                             '(z+3/4, y+1/4, -x+3/4)',
                             '(z+3/4, y+3/4, -x+1/4)',
                             '(z+1/4, y+1/4, -x+1/4)',
                             '(z+1/4, y+3/4, -x+3/4)',
                             '(z+1/4, -y+3/4, x+3/4)',
                             '(z+1/4, -y+1/4, x+1/4)',
                             '(z+3/4, -y+3/4, x+1/4)',
                             '(z+3/4, -y+1/4, x+3/4)',
                             '(-z+3/4, y+3/4, x+1/4)',
                             '(-z+3/4, y+1/4, x+3/4)',
                             '(-z+1/4, y+3/4, x+3/4)',
                             '(-z+1/4, y+1/4, x+1/4)',
                             '(-z+1/4, -y+1/4, -x+1/4)',
                             '(-z+1/4, -y+3/4, -x+3/4)',
                             '(-z+3/4, -y+1/4, -x+3/4)',
                             '(-z+3/4, -y+3/4, -x+1/4)',
                             '(-x+1/4, -y+1/4, -z+1/4)',
                             '(-x+1/4, -y+3/4, -z+3/4)',
                             '(-x+3/4, -y+1/4, -z+3/4)',
                             '(-x+3/4, -y+3/4, -z+1/4)',
                             '(x+1/4, y+3/4, -z+3/4)',
                             '(x+1/4, y+1/4, -z+1/4)',
                             '(x+3/4, y+3/4, -z+1/4)',
                             '(x+3/4, y+1/4, -z+3/4)',
                             '(x+3/4, -y+3/4, z+1/4)',
                             '(x+3/4, -y+1/4, z+3/4)',
                             '(x+1/4, -y+3/4, z+3/4)',
                             '(x+1/4, -y+1/4, z+1/4)',
                             '(-x+3/4, y+1/4, z+3/4)',
                             '(-x+3/4, y+3/4, z+1/4)',
                             '(-x+1/4, y+1/4, z+1/4)',
                             '(-x+1/4, y+3/4, z+3/4)',
                             '(-z+1/4, -x+1/4, -y+1/4)',
                             '(-z+1/4, -x+3/4, -y+3/4)',
                             '(-z+3/4, -x+1/4, -y+3/4)',
                             '(-z+3/4, -x+3/4, -y+1/4)',
                             '(-z+3/4, x+1/4, y+3/4)',
                             '(-z+3/4, x+3/4, y+1/4)',
                             '(-z+1/4, x+1/4, y+1/4)',
                             '(-z+1/4, x+3/4, y+3/4)',
                             '(z+1/4, x+3/4, -y+3/4)',
                             '(z+1/4, x+1/4, -y+1/4)',
                             '(z+3/4, x+3/4, -y+1/4)',
                             '(z+3/4, x+1/4, -y+3/4)',
                             '(z+3/4, -x+3/4, y+1/4)',
                             '(z+3/4, -x+1/4, y+3/4)',
                             '(z+1/4, -x+3/4, y+3/4)',
                             '(z+1/4, -x+1/4, y+1/4)',
                             '(-y+1/4, -z+1/4, -x+1/4)',
                             '(-y+1/4, -z+3/4, -x+3/4)',
                             '(-y+3/4, -z+1/4, -x+3/4)',
                             '(-y+3/4, -z+3/4, -x+1/4)',
                             '(y+3/4, -z+3/4, x+1/4)',
                             '(y+3/4, -z+1/4, x+3/4)',
                             '(y+1/4, -z+3/4, x+3/4)',
                             '(y+1/4, -z+1/4, x+1/4)',
                             '(-y+3/4, z+1/4, x+3/4)',
                             '(-y+3/4, z+3/4, x+1/4)',
                             '(-y+1/4, z+1/4, x+1/4)',
                             '(-y+1/4, z+3/4, x+3/4)',
                             '(y+1/4, z+3/4, -x+3/4)',
                             '(y+1/4, z+1/4, -x+1/4)',
                             '(y+3/4, z+3/4, -x+1/4)',
                             '(y+3/4, z+1/4, -x+3/4)', '(-y+1/2, -x, z+1/2)',
                             '(-y+1/2, -x+1/2, z)', '(-y, -x, z)',
                             '(-y, -x+1/2, z+1/2)', '(y, x, z)',
                             '(y, x+1/2, z+1/2)', '(y+1/2, x, z+1/2)',
                             '(y+1/2, x+1/2, z)', '(-y, x+1/2, -z+1/2)',
                             '(-y, x, -z)', '(-y+1/2, x+1/2, -z)',
                             '(-y+1/2, x, -z+1/2)', '(y+1/2, -x+1/2, -z)',
                             '(y+1/2, -x, -z+1/2)', '(y, -x+1/2, -z+1/2)',
                             '(y, -x, -z)', '(-x+1/2, -z, y+1/2)',
                             '(-x+1/2, -z+1/2, y)', '(-x, -z, y)',
                             '(-x, -z+1/2, y+1/2)', '(x+1/2, -z+1/2, -y)',
                             '(x+1/2, -z, -y+1/2)', '(x, -z+1/2, -y+1/2)',
                             '(x, -z, -y)', '(x, z, y)', '(x, z+1/2, y+1/2)',
                             '(x+1/2, z, y+1/2)', '(x+1/2, z+1/2, y)',
                             '(-x, z+1/2, -y+1/2)', '(-x, z, -y)',
                             '(-x+1/2, z+1/2, -y)', '(-x+1/2, z, -y+1/2)',
                             '(-z+1/2, -y, x+1/2)', '(-z+1/2, -y+1/2, x)',
                             '(-z, -y, x)', '(-z, -y+1/2, x+1/2)',
                             '(-z, y+1/2, -x+1/2)', '(-z, y, -x)',
                             '(-z+1/2, y+1/2, -x)', '(-z+1/2, y, -x+1/2)',
                             '(z+1/2, -y+1/2, -x)', '(z+1/2, -y, -x+1/2)',
                             '(z, -y+1/2, -x+1/2)', '(z, -y, -x)',
                             '(z, y, x)', '(z, y+1/2, x+1/2)',
                             '(z+1/2, y, x+1/2)', '(z+1/2, y+1/2, x)'))},
      '227:2': {'8a': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                           '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                           '(7/8, 3/8, 3/8)', '(7/8, 7/8, 7/8)',
                           '(3/8, 3/8, 7/8)', '(3/8, 7/8, 3/8)')),
                '8b': (0, ('(3/8, 3/8, 3/8)', '(3/8, 7/8, 7/8)',
                           '(7/8, 3/8, 7/8)', '(7/8, 7/8, 3/8)',
                           '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                           '(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)')),
                '16c': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(1/2, 1/2, 0)', '(3/4, 1/4, 1/2)',
                            '(3/4, 3/4, 0)', '(1/4, 1/4, 0)',
                            '(1/4, 3/4, 1/2)', '(1/4, 1/2, 3/4)',
                            '(1/4, 0, 1/4)', '(3/4, 1/2, 1/4)',
                            '(3/4, 0, 3/4)', '(1/2, 3/4, 1/4)',
                            '(1/2, 1/4, 3/4)', '(0, 3/4, 3/4)',
                            '(0, 1/4, 1/4)')),
                '16d': (0, ('(1/2, 1/2, 1/2)', '(1/2, 0, 0)', '(0, 1/2, 0)',
                            '(0, 0, 1/2)', '(1/4, 3/4, 0)', '(1/4, 1/4, 1/2)',
                            '(3/4, 3/4, 1/2)', '(3/4, 1/4, 0)',
                            '(3/4, 0, 1/4)', '(3/4, 1/2, 3/4)',
                            '(1/4, 0, 3/4)', '(1/4, 1/2, 1/4)',
                            '(0, 1/4, 3/4)', '(0, 3/4, 1/4)',
                            '(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)')),
                '32e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x+3/4, -x+1/4, x+1/2)', '(-x+3/4, -x+3/4, x)',
                            '(-x+1/4, -x+1/4, x)', '(-x+1/4, -x+3/4, x+1/2)',
                            '(-x+1/4, x+1/2, -x+3/4)', '(-x+1/4, x, -x+1/4)',
                            '(-x+3/4, x+1/2, -x+1/4)', '(-x+3/4, x, -x+3/4)',
                            '(x+1/2, -x+3/4, -x+1/4)',
                            '(x+1/2, -x+1/4, -x+3/4)', '(x, -x+3/4, -x+3/4)',
                            '(x, -x+1/4, -x+1/4)', '(x+3/4, x+1/4, -x+1/2)',
                            '(x+3/4, x+3/4, -x)', '(x+1/4, x+1/4, -x)',
                            '(x+1/4, x+3/4, -x+1/2)', '(-x, -x, -x)',
                            '(-x, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x+1/2)',
                            '(-x+1/2, -x+1/2, -x)', '(x+1/4, -x+1/2, x+3/4)',
                            '(x+1/4, -x, x+1/4)', '(x+3/4, -x+1/2, x+1/4)',
                            '(x+3/4, -x, x+3/4)', '(-x+1/2, x+3/4, x+1/4)',
                            '(-x+1/2, x+1/4, x+3/4)', '(-x, x+3/4, x+3/4)',
                            '(-x, x+1/4, x+1/4)')),
                '48f': (1, ('(x, 1/8, 1/8)', '(x, 5/8, 5/8)',
                            '(x+1/2, 1/8, 5/8)', '(x+1/2, 5/8, 1/8)',
                            '(-x+3/4, 1/8, 5/8)', '(-x+3/4, 5/8, 1/8)',
                            '(-x+1/4, 1/8, 1/8)', '(-x+1/4, 5/8, 5/8)',
                            '(1/8, x, 1/8)', '(1/8, x+1/2, 5/8)',
                            '(5/8, x, 5/8)', '(5/8, x+1/2, 1/8)',
                            '(5/8, -x+3/4, 1/8)', '(5/8, -x+1/4, 5/8)',
                            '(1/8, -x+3/4, 5/8)', '(1/8, -x+1/4, 1/8)',
                            '(1/8, 1/8, x)', '(1/8, 5/8, x+1/2)',
                            '(5/8, 1/8, x+1/2)', '(5/8, 5/8, x)',
                            '(1/8, 5/8, -x+3/4)', '(1/8, 1/8, -x+1/4)',
                            '(5/8, 5/8, -x+1/4)', '(5/8, 1/8, -x+3/4)',
                            '(7/8, x+1/4, 3/8)', '(7/8, x+3/4, 7/8)',
                            '(3/8, x+1/4, 7/8)', '(3/8, x+3/4, 3/8)',
                            '(7/8, -x, 7/8)', '(7/8, -x+1/2, 3/8)',
                            '(3/8, -x, 3/8)', '(3/8, -x+1/2, 7/8)',
                            '(x+3/4, 3/8, 3/8)', '(x+3/4, 7/8, 7/8)',
                            '(x+1/4, 3/8, 7/8)', '(x+1/4, 7/8, 3/8)',
                            '(-x+1/2, 7/8, 3/8)', '(-x+1/2, 3/8, 7/8)',
                            '(-x, 7/8, 7/8)', '(-x, 3/8, 3/8)',
                            '(7/8, 3/8, -x+1/2)', '(7/8, 7/8, -x)',
                            '(3/8, 3/8, -x)', '(3/8, 7/8, -x+1/2)',
                            '(3/8, 3/8, x+3/4)', '(3/8, 7/8, x+1/4)',
                            '(7/8, 3/8, x+1/4)', '(7/8, 7/8, x+3/4)')),
                '96g': (5, ('(x, x, z)', '(x, x+1/2, z+1/2)',
                            '(x+1/2, x, z+1/2)', '(x+1/2, x+1/2, z)',
                            '(-x+3/4, -x+1/4, z+1/2)', '(-x+3/4, -x+3/4, z)',
                            '(-x+1/4, -x+1/4, z)', '(-x+1/4, -x+3/4, z+1/2)',
                            '(-x+1/4, x+1/2, -z+3/4)', '(-x+1/4, x, -z+1/4)',
                            '(-x+3/4, x+1/2, -z+1/4)', '(-x+3/4, x, -z+3/4)',
                            '(x+1/2, -x+3/4, -z+1/4)',
                            '(x+1/2, -x+1/4, -z+3/4)', '(x, -x+3/4, -z+3/4)',
                            '(x, -x+1/4, -z+1/4)', '(z, x, x)',
                            '(z, x+1/2, x+1/2)', '(z+1/2, x, x+1/2)',
                            '(z+1/2, x+1/2, x)', '(z+1/2, -x+3/4, -x+1/4)',
                            '(z+1/2, -x+1/4, -x+3/4)', '(z, -x+3/4, -x+3/4)',
                            '(z, -x+1/4, -x+1/4)', '(-z+3/4, -x+1/4, x+1/2)',
                            '(-z+3/4, -x+3/4, x)', '(-z+1/4, -x+1/4, x)',
                            '(-z+1/4, -x+3/4, x+1/2)',
                            '(-z+1/4, x+1/2, -x+3/4)', '(-z+1/4, x, -x+1/4)',
                            '(-z+3/4, x+1/2, -x+1/4)', '(-z+3/4, x, -x+3/4)',
                            '(x, z, x)', '(x, z+1/2, x+1/2)',
                            '(x+1/2, z, x+1/2)', '(x+1/2, z+1/2, x)',
                            '(-x+1/4, z+1/2, -x+3/4)', '(-x+1/4, z, -x+1/4)',
                            '(-x+3/4, z+1/2, -x+1/4)', '(-x+3/4, z, -x+3/4)',
                            '(x+1/2, -z+3/4, -x+1/4)',
                            '(x+1/2, -z+1/4, -x+3/4)', '(x, -z+3/4, -x+3/4)',
                            '(x, -z+1/4, -x+1/4)', '(-x+3/4, -z+1/4, x+1/2)',
                            '(-x+3/4, -z+3/4, x)', '(-x+1/4, -z+1/4, x)',
                            '(-x+1/4, -z+3/4, x+1/2)',
                            '(x+3/4, x+1/4, -z+1/2)', '(x+3/4, x+3/4, -z)',
                            '(x+1/4, x+1/4, -z)', '(x+1/4, x+3/4, -z+1/2)',
                            '(-x, -x, -z)', '(-x, -x+1/2, -z+1/2)',
                            '(-x+1/2, -x, -z+1/2)', '(-x+1/2, -x+1/2, -z)',
                            '(x+1/4, -x+1/2, z+3/4)', '(x+1/4, -x, z+1/4)',
                            '(x+3/4, -x+1/2, z+1/4)', '(x+3/4, -x, z+3/4)',
                            '(-x+1/2, x+3/4, z+1/4)',
                            '(-x+1/2, x+1/4, z+3/4)', '(-x, x+3/4, z+3/4)',
                            '(-x, x+1/4, z+1/4)', '(x+3/4, z+1/4, -x+1/2)',
                            '(x+3/4, z+3/4, -x)', '(x+1/4, z+1/4, -x)',
                            '(x+1/4, z+3/4, -x+1/2)',
                            '(-x+1/2, z+3/4, x+1/4)',
                            '(-x+1/2, z+1/4, x+3/4)', '(-x, z+3/4, x+3/4)',
                            '(-x, z+1/4, x+1/4)', '(-x, -z, -x)',
                            '(-x, -z+1/2, -x+1/2)', '(-x+1/2, -z, -x+1/2)',
                            '(-x+1/2, -z+1/2, -x)', '(x+1/4, -z+1/2, x+3/4)',
                            '(x+1/4, -z, x+1/4)', '(x+3/4, -z+1/2, x+1/4)',
                            '(x+3/4, -z, x+3/4)', '(z+3/4, x+1/4, -x+1/2)',
                            '(z+3/4, x+3/4, -x)', '(z+1/4, x+1/4, -x)',
                            '(z+1/4, x+3/4, -x+1/2)',
                            '(z+1/4, -x+1/2, x+3/4)', '(z+1/4, -x, x+1/4)',
                            '(z+3/4, -x+1/2, x+1/4)', '(z+3/4, -x, x+3/4)',
                            '(-z+1/2, x+3/4, x+1/4)',
                            '(-z+1/2, x+1/4, x+3/4)', '(-z, x+3/4, x+3/4)',
                            '(-z, x+1/4, x+1/4)', '(-z, -x, -x)',
                            '(-z, -x+1/2, -x+1/2)', '(-z+1/2, -x, -x+1/2)',
                            '(-z+1/2, -x+1/2, -x)')),
                '96h': (2, ('(0, y, -y)', '(0, y+1/2, -y+1/2)',
                            '(1/2, y, -y+1/2)', '(1/2, y+1/2, -y)',
                            '(3/4, -y+1/4, -y+1/2)', '(3/4, -y+3/4, -y)',
                            '(1/4, -y+1/4, -y)', '(1/4, -y+3/4, -y+1/2)',
                            '(1/4, y+1/2, y+3/4)', '(1/4, y, y+1/4)',
                            '(3/4, y+1/2, y+1/4)', '(3/4, y, y+3/4)',
                            '(1/2, -y+3/4, y+1/4)', '(1/2, -y+1/4, y+3/4)',
                            '(0, -y+3/4, y+3/4)', '(0, -y+1/4, y+1/4)',
                            '(-y, 0, y)', '(-y, 1/2, y+1/2)',
                            '(-y+1/2, 0, y+1/2)', '(-y+1/2, 1/2, y)',
                            '(-y+1/2, 3/4, -y+1/4)', '(-y+1/2, 1/4, -y+3/4)',
                            '(-y, 3/4, -y+3/4)', '(-y, 1/4, -y+1/4)',
                            '(y+3/4, 1/4, y+1/2)', '(y+3/4, 3/4, y)',
                            '(y+1/4, 1/4, y)', '(y+1/4, 3/4, y+1/2)',
                            '(y+1/4, 1/2, -y+3/4)', '(y+1/4, 0, -y+1/4)',
                            '(y+3/4, 1/2, -y+1/4)', '(y+3/4, 0, -y+3/4)',
                            '(y, -y, 0)', '(y, -y+1/2, 1/2)',
                            '(y+1/2, -y, 1/2)', '(y+1/2, -y+1/2, 0)',
                            '(-y+1/4, -y+1/2, 3/4)', '(-y+1/4, -y, 1/4)',
                            '(-y+3/4, -y+1/2, 1/4)', '(-y+3/4, -y, 3/4)',
                            '(y+1/2, y+3/4, 1/4)', '(y+1/2, y+1/4, 3/4)',
                            '(y, y+3/4, 3/4)', '(y, y+1/4, 1/4)',
                            '(-y+3/4, y+1/4, 1/2)', '(-y+3/4, y+3/4, 0)',
                            '(-y+1/4, y+1/4, 0)', '(-y+1/4, y+3/4, 1/2)',
                            '(0, -y, y)', '(0, -y+1/2, y+1/2)',
                            '(1/2, -y, y+1/2)', '(1/2, -y+1/2, y)',
                            '(1/4, y+3/4, y+1/2)', '(1/4, y+1/4, y)',
                            '(3/4, y+3/4, y)', '(3/4, y+1/4, y+1/2)',
                            '(3/4, -y+1/2, -y+1/4)', '(3/4, -y, -y+3/4)',
                            '(1/4, -y+1/2, -y+3/4)', '(1/4, -y, -y+1/4)',
                            '(1/2, y+1/4, -y+3/4)', '(1/2, y+3/4, -y+1/4)',
                            '(0, y+1/4, -y+1/4)', '(0, y+3/4, -y+3/4)',
                            '(y, 0, -y)', '(y, 1/2, -y+1/2)',
                            '(y+1/2, 0, -y+1/2)', '(y+1/2, 1/2, -y)',
                            '(y+1/2, 1/4, y+3/4)', '(y+1/2, 3/4, y+1/4)',
                            '(y, 1/4, y+1/4)', '(y, 3/4, y+3/4)',
                            '(-y+1/4, 3/4, -y+1/2)', '(-y+1/4, 1/4, -y)',
                            '(-y+3/4, 3/4, -y)', '(-y+3/4, 1/4, -y+1/2)',
                            '(-y+3/4, 1/2, y+1/4)', '(-y+3/4, 0, y+3/4)',
                            '(-y+1/4, 1/2, y+3/4)', '(-y+1/4, 0, y+1/4)',
                            '(-y, y, 0)', '(-y, y+1/2, 1/2)',
                            '(-y+1/2, y, 1/2)', '(-y+1/2, y+1/2, 0)',
                            '(y+3/4, y+1/2, 1/4)', '(y+3/4, y, 3/4)',
                            '(y+1/4, y+1/2, 3/4)', '(y+1/4, y, 1/4)',
                            '(-y+1/2, -y+1/4, 3/4)', '(-y+1/2, -y+3/4, 1/4)',
                            '(-y, -y+1/4, 1/4)', '(-y, -y+3/4, 3/4)',
                            '(y+1/4, -y+3/4, 1/2)', '(y+1/4, -y+1/4, 0)',
                            '(y+3/4, -y+3/4, 0)', '(y+3/4, -y+1/4, 1/2)')),
                '192i': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                             '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                             '(-x+3/4, -y+1/4, z+1/2)', '(-x+3/4, -y+3/4, z)',
                             '(-x+1/4, -y+1/4, z)', '(-x+1/4, -y+3/4, z+1/2)',
                             '(-x+1/4, y+1/2, -z+3/4)', '(-x+1/4, y, -z+1/4)',
                             '(-x+3/4, y+1/2, -z+1/4)', '(-x+3/4, y, -z+3/4)',
                             '(x+1/2, -y+3/4, -z+1/4)',
                             '(x+1/2, -y+1/4, -z+3/4)', '(x, -y+3/4, -z+3/4)',
                             '(x, -y+1/4, -z+1/4)', '(z, x, y)',
                             '(z, x+1/2, y+1/2)', '(z+1/2, x, y+1/2)',
                             '(z+1/2, x+1/2, y)', '(z+1/2, -x+3/4, -y+1/4)',
                             '(z+1/2, -x+1/4, -y+3/4)', '(z, -x+3/4, -y+3/4)',
                             '(z, -x+1/4, -y+1/4)', '(-z+3/4, -x+1/4, y+1/2)',
                             '(-z+3/4, -x+3/4, y)', '(-z+1/4, -x+1/4, y)',
                             '(-z+1/4, -x+3/4, y+1/2)',
                             '(-z+1/4, x+1/2, -y+3/4)', '(-z+1/4, x, -y+1/4)',
                             '(-z+3/4, x+1/2, -y+1/4)', '(-z+3/4, x, -y+3/4)',
                             '(y, z, x)', '(y, z+1/2, x+1/2)',
                             '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                             '(-y+1/4, z+1/2, -x+3/4)', '(-y+1/4, z, -x+1/4)',
                             '(-y+3/4, z+1/2, -x+1/4)', '(-y+3/4, z, -x+3/4)',
                             '(y+1/2, -z+3/4, -x+1/4)',
                             '(y+1/2, -z+1/4, -x+3/4)', '(y, -z+3/4, -x+3/4)',
                             '(y, -z+1/4, -x+1/4)', '(-y+3/4, -z+1/4, x+1/2)',
                             '(-y+3/4, -z+3/4, x)', '(-y+1/4, -z+1/4, x)',
                             '(-y+1/4, -z+3/4, x+1/2)',
                             '(y+3/4, x+1/4, -z+1/2)', '(y+3/4, x+3/4, -z)',
                             '(y+1/4, x+1/4, -z)', '(y+1/4, x+3/4, -z+1/2)',
                             '(-y, -x, -z)', '(-y, -x+1/2, -z+1/2)',
                             '(-y+1/2, -x, -z+1/2)', '(-y+1/2, -x+1/2, -z)',
                             '(y+1/4, -x+1/2, z+3/4)', '(y+1/4, -x, z+1/4)',
                             '(y+3/4, -x+1/2, z+1/4)', '(y+3/4, -x, z+3/4)',
                             '(-y+1/2, x+3/4, z+1/4)',
                             '(-y+1/2, x+1/4, z+3/4)', '(-y, x+3/4, z+3/4)',
                             '(-y, x+1/4, z+1/4)', '(x+3/4, z+1/4, -y+1/2)',
                             '(x+3/4, z+3/4, -y)', '(x+1/4, z+1/4, -y)',
                             '(x+1/4, z+3/4, -y+1/2)',
                             '(-x+1/2, z+3/4, y+1/4)',
                             '(-x+1/2, z+1/4, y+3/4)', '(-x, z+3/4, y+3/4)',
                             '(-x, z+1/4, y+1/4)', '(-x, -z, -y)',
                             '(-x, -z+1/2, -y+1/2)', '(-x+1/2, -z, -y+1/2)',
                             '(-x+1/2, -z+1/2, -y)', '(x+1/4, -z+1/2, y+3/4)',
                             '(x+1/4, -z, y+1/4)', '(x+3/4, -z+1/2, y+1/4)',
                             '(x+3/4, -z, y+3/4)', '(z+3/4, y+1/4, -x+1/2)',
                             '(z+3/4, y+3/4, -x)', '(z+1/4, y+1/4, -x)',
                             '(z+1/4, y+3/4, -x+1/2)',
                             '(z+1/4, -y+1/2, x+3/4)', '(z+1/4, -y, x+1/4)',
                             '(z+3/4, -y+1/2, x+1/4)', '(z+3/4, -y, x+3/4)',
                             '(-z+1/2, y+3/4, x+1/4)',
                             '(-z+1/2, y+1/4, x+3/4)', '(-z, y+3/4, x+3/4)',
                             '(-z, y+1/4, x+1/4)', '(-z, -y, -x)',
                             '(-z, -y+1/2, -x+1/2)', '(-z+1/2, -y, -x+1/2)',
                             '(-z+1/2, -y+1/2, -x)', '(-x, -y, -z)',
                             '(-x, -y+1/2, -z+1/2)', '(-x+1/2, -y, -z+1/2)',
                             '(-x+1/2, -y+1/2, -z)', '(x+1/4, y+3/4, -z+1/2)',
                             '(x+1/4, y+1/4, -z)', '(x+3/4, y+3/4, -z)',
                             '(x+3/4, y+1/4, -z+1/2)',
                             '(x+3/4, -y+1/2, z+1/4)', '(x+3/4, -y, z+3/4)',
                             '(x+1/4, -y+1/2, z+3/4)', '(x+1/4, -y, z+1/4)',
                             '(-x+1/2, y+1/4, z+3/4)',
                             '(-x+1/2, y+3/4, z+1/4)', '(-x, y+1/4, z+1/4)',
                             '(-x, y+3/4, z+3/4)', '(-z, -x, -y)',
                             '(-z, -x+1/2, -y+1/2)', '(-z+1/2, -x, -y+1/2)',
                             '(-z+1/2, -x+1/2, -y)', '(-z+1/2, x+1/4, y+3/4)',
                             '(-z+1/2, x+3/4, y+1/4)', '(-z, x+1/4, y+1/4)',
                             '(-z, x+3/4, y+3/4)', '(z+1/4, x+3/4, -y+1/2)',
                             '(z+1/4, x+1/4, -y)', '(z+3/4, x+3/4, -y)',
                             '(z+3/4, x+1/4, -y+1/2)',
                             '(z+3/4, -x+1/2, y+1/4)', '(z+3/4, -x, y+3/4)',
                             '(z+1/4, -x+1/2, y+3/4)', '(z+1/4, -x, y+1/4)',
                             '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                             '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                             '(y+3/4, -z+1/2, x+1/4)', '(y+3/4, -z, x+3/4)',
                             '(y+1/4, -z+1/2, x+3/4)', '(y+1/4, -z, x+1/4)',
                             '(-y+1/2, z+1/4, x+3/4)',
                             '(-y+1/2, z+3/4, x+1/4)', '(-y, z+1/4, x+1/4)',
                             '(-y, z+3/4, x+3/4)', '(y+1/4, z+3/4, -x+1/2)',
                             '(y+1/4, z+1/4, -x)', '(y+3/4, z+3/4, -x)',
                             '(y+3/4, z+1/4, -x+1/2)',
                             '(-y+1/4, -x+3/4, z+1/2)', '(-y+1/4, -x+1/4, z)',
                             '(-y+3/4, -x+3/4, z)', '(-y+3/4, -x+1/4, z+1/2)',
                             '(y, x, z)', '(y, x+1/2, z+1/2)',
                             '(y+1/2, x, z+1/2)', '(y+1/2, x+1/2, z)',
                             '(-y+3/4, x+1/2, -z+1/4)', '(-y+3/4, x, -z+3/4)',
                             '(-y+1/4, x+1/2, -z+3/4)', '(-y+1/4, x, -z+1/4)',
                             '(y+1/2, -x+1/4, -z+3/4)',
                             '(y+1/2, -x+3/4, -z+1/4)', '(y, -x+1/4, -z+1/4)',
                             '(y, -x+3/4, -z+3/4)', '(-x+1/4, -z+3/4, y+1/2)',
                             '(-x+1/4, -z+1/4, y)', '(-x+3/4, -z+3/4, y)',
                             '(-x+3/4, -z+1/4, y+1/2)',
                             '(x+1/2, -z+1/4, -y+3/4)',
                             '(x+1/2, -z+3/4, -y+1/4)', '(x, -z+1/4, -y+1/4)',
                             '(x, -z+3/4, -y+3/4)', '(x, z, y)',
                             '(x, z+1/2, y+1/2)', '(x+1/2, z, y+1/2)',
                             '(x+1/2, z+1/2, y)', '(-x+3/4, z+1/2, -y+1/4)',
                             '(-x+3/4, z, -y+3/4)', '(-x+1/4, z+1/2, -y+3/4)',
                             '(-x+1/4, z, -y+1/4)', '(-z+1/4, -y+3/4, x+1/2)',
                             '(-z+1/4, -y+1/4, x)', '(-z+3/4, -y+3/4, x)',
                             '(-z+3/4, -y+1/4, x+1/2)',
                             '(-z+3/4, y+1/2, -x+1/4)', '(-z+3/4, y, -x+3/4)',
                             '(-z+1/4, y+1/2, -x+3/4)', '(-z+1/4, y, -x+1/4)',
                             '(z+1/2, -y+1/4, -x+3/4)',
                             '(z+1/2, -y+3/4, -x+1/4)', '(z, -y+1/4, -x+1/4)',
                             '(z, -y+3/4, -x+3/4)', '(z, y, x)',
                             '(z, y+1/2, x+1/2)', '(z+1/2, y, x+1/2)',
                             '(z+1/2, y+1/2, x)'))},
      '228:1': {'16a': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(1/2, 1/2, 0)', '(3/4, 1/4, 3/4)',
                            '(3/4, 3/4, 1/4)', '(1/4, 1/4, 1/4)',
                            '(1/4, 3/4, 3/4)', '(3/4, 3/4, 3/4)',
                            '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                            '(1/4, 1/4, 3/4)', '(0, 1/2, 0)', '(0, 0, 1/2)',
                            '(1/2, 1/2, 1/2)', '(1/2, 0, 0)')),
                '32b': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                            '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                            '(7/8, 3/8, 5/8)', '(7/8, 7/8, 1/8)',
                            '(3/8, 3/8, 1/8)', '(3/8, 7/8, 5/8)',
                            '(3/8, 5/8, 7/8)', '(3/8, 1/8, 3/8)',
                            '(7/8, 5/8, 3/8)', '(7/8, 1/8, 7/8)',
                            '(5/8, 7/8, 3/8)', '(5/8, 3/8, 7/8)',
                            '(1/8, 7/8, 7/8)', '(1/8, 3/8, 3/8)',
                            '(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)',
                            '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                            '(7/8, 3/8, 1/8)', '(7/8, 7/8, 5/8)',
                            '(3/8, 3/8, 5/8)', '(3/8, 7/8, 1/8)',
                            '(3/8, 1/8, 7/8)', '(3/8, 5/8, 3/8)',
                            '(7/8, 1/8, 3/8)', '(7/8, 5/8, 7/8)',
                            '(1/8, 7/8, 3/8)', '(1/8, 3/8, 7/8)',
                            '(5/8, 7/8, 7/8)', '(5/8, 3/8, 3/8)')),
                '32c': (0, ('(3/8, 3/8, 3/8)', '(3/8, 7/8, 7/8)',
                            '(7/8, 3/8, 7/8)', '(7/8, 7/8, 3/8)',
                            '(5/8, 1/8, 7/8)', '(5/8, 5/8, 3/8)',
                            '(1/8, 1/8, 3/8)', '(1/8, 5/8, 7/8)',
                            '(1/8, 7/8, 5/8)', '(1/8, 3/8, 1/8)',
                            '(5/8, 7/8, 1/8)', '(5/8, 3/8, 5/8)',
                            '(7/8, 5/8, 1/8)', '(7/8, 1/8, 5/8)',
                            '(3/8, 5/8, 5/8)', '(3/8, 1/8, 1/8)',
                            '(1/8, 5/8, 3/8)', '(1/8, 1/8, 7/8)',
                            '(5/8, 5/8, 7/8)', '(5/8, 1/8, 3/8)',
                            '(7/8, 7/8, 7/8)', '(7/8, 3/8, 3/8)',
                            '(3/8, 7/8, 3/8)', '(3/8, 3/8, 7/8)',
                            '(5/8, 3/8, 1/8)', '(5/8, 7/8, 5/8)',
                            '(1/8, 3/8, 5/8)', '(1/8, 7/8, 1/8)',
                            '(3/8, 1/8, 5/8)', '(3/8, 5/8, 1/8)',
                            '(7/8, 1/8, 1/8)', '(7/8, 5/8, 5/8)')),
                '48d': (0, ('(1/4, 0, 0)', '(1/4, 1/2, 1/2)', '(3/4, 0, 1/2)',
                            '(3/4, 1/2, 0)', '(3/4, 1/2, 1/2)', '(3/4, 0, 0)',
                            '(1/4, 1/2, 0)', '(1/4, 0, 1/2)', '(0, 1/4, 0)',
                            '(0, 3/4, 1/2)', '(1/2, 1/4, 1/2)',
                            '(1/2, 3/4, 0)', '(1/2, 3/4, 1/2)',
                            '(1/2, 1/4, 0)', '(0, 3/4, 0)', '(0, 1/4, 1/2)',
                            '(0, 0, 1/4)', '(0, 1/2, 3/4)', '(1/2, 0, 3/4)',
                            '(1/2, 1/2, 1/4)', '(1/2, 1/2, 3/4)',
                            '(1/2, 0, 1/4)', '(0, 1/2, 1/4)', '(0, 0, 3/4)',
                            '(3/4, 1/2, 3/4)', '(3/4, 0, 1/4)',
                            '(1/4, 1/2, 1/4)', '(1/4, 0, 3/4)',
                            '(1/4, 0, 1/4)', '(1/4, 1/2, 3/4)',
                            '(3/4, 0, 3/4)', '(3/4, 1/2, 1/4)',
                            '(0, 1/4, 3/4)', '(0, 3/4, 1/4)',
                            '(1/2, 1/4, 1/4)', '(1/2, 3/4, 3/4)',
                            '(1/2, 3/4, 1/4)', '(1/2, 1/4, 3/4)',
                            '(0, 3/4, 3/4)', '(0, 1/4, 1/4)',
                            '(3/4, 1/4, 1/2)', '(3/4, 3/4, 0)',
                            '(1/4, 1/4, 0)', '(1/4, 3/4, 1/2)',
                            '(1/4, 3/4, 0)', '(1/4, 1/4, 1/2)',
                            '(3/4, 3/4, 1/2)', '(3/4, 1/4, 0)')),
                '64e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x, -x+1/2, x+1/2)', '(-x, -x, x)',
                            '(-x+1/2, -x+1/2, x)', '(-x+1/2, -x, x+1/2)',
                            '(-x+1/2, x+1/2, -x)', '(-x+1/2, x, -x+1/2)',
                            '(-x, x+1/2, -x+1/2)', '(-x, x, -x)',
                            '(x+1/2, -x, -x+1/2)', '(x+1/2, -x+1/2, -x)',
                            '(x, -x, -x)', '(x, -x+1/2, -x+1/2)',
                            '(x+3/4, x+1/4, -x+3/4)',
                            '(x+3/4, x+3/4, -x+1/4)',
                            '(x+1/4, x+1/4, -x+1/4)',
                            '(x+1/4, x+3/4, -x+3/4)',
                            '(-x+1/4, -x+1/4, -x+1/4)',
                            '(-x+1/4, -x+3/4, -x+3/4)',
                            '(-x+3/4, -x+1/4, -x+3/4)',
                            '(-x+3/4, -x+3/4, -x+1/4)',
                            '(x+1/4, -x+3/4, x+3/4)',
                            '(x+1/4, -x+1/4, x+1/4)',
                            '(x+3/4, -x+3/4, x+1/4)',
                            '(x+3/4, -x+1/4, x+3/4)',
                            '(-x+3/4, x+3/4, x+1/4)',
                            '(-x+3/4, x+1/4, x+3/4)',
                            '(-x+1/4, x+3/4, x+3/4)',
                            '(-x+1/4, x+1/4, x+1/4)',
                            '(-x+3/4, -x+3/4, -x+3/4)',
                            '(-x+3/4, -x+1/4, -x+1/4)',
                            '(-x+1/4, -x+3/4, -x+1/4)',
                            '(-x+1/4, -x+1/4, -x+3/4)',
                            '(x+3/4, x+1/4, -x+1/4)',
                            '(x+3/4, x+3/4, -x+3/4)',
                            '(x+1/4, x+1/4, -x+3/4)',
                            '(x+1/4, x+3/4, -x+1/4)',
                            '(x+1/4, -x+1/4, x+3/4)',
                            '(x+1/4, -x+3/4, x+1/4)',
                            '(x+3/4, -x+1/4, x+1/4)',
                            '(x+3/4, -x+3/4, x+3/4)',
                            '(-x+1/4, x+3/4, x+1/4)',
                            '(-x+1/4, x+1/4, x+3/4)',
                            '(-x+3/4, x+3/4, x+3/4)',
                            '(-x+3/4, x+1/4, x+1/4)', '(-x, -x+1/2, x)',
                            '(-x, -x, x+1/2)', '(-x+1/2, -x+1/2, x+1/2)',
                            '(-x+1/2, -x, x)', '(x+1/2, x+1/2, x+1/2)',
                            '(x+1/2, x, x)', '(x, x+1/2, x)', '(x, x, x+1/2)',
                            '(-x+1/2, x, -x)', '(-x+1/2, x+1/2, -x+1/2)',
                            '(-x, x, -x+1/2)', '(-x, x+1/2, -x)',
                            '(x, -x, -x+1/2)', '(x, -x+1/2, -x)',
                            '(x+1/2, -x, -x)', '(x+1/2, -x+1/2, -x+1/2)')),
                '96f': (1, ('(x, 0, 0)', '(x, 1/2, 1/2)', '(x+1/2, 0, 1/2)',
                            '(x+1/2, 1/2, 0)', '(-x, 1/2, 1/2)', '(-x, 0, 0)',
                            '(-x+1/2, 1/2, 0)', '(-x+1/2, 0, 1/2)',
                            '(0, x, 0)', '(0, x+1/2, 1/2)', '(1/2, x, 1/2)',
                            '(1/2, x+1/2, 0)', '(1/2, -x, 1/2)',
                            '(1/2, -x+1/2, 0)', '(0, -x, 0)',
                            '(0, -x+1/2, 1/2)', '(0, 0, x)',
                            '(0, 1/2, x+1/2)', '(1/2, 0, x+1/2)',
                            '(1/2, 1/2, x)', '(1/2, 1/2, -x)',
                            '(1/2, 0, -x+1/2)', '(0, 1/2, -x+1/2)',
                            '(0, 0, -x)', '(3/4, x+1/4, 3/4)',
                            '(3/4, x+3/4, 1/4)', '(1/4, x+1/4, 1/4)',
                            '(1/4, x+3/4, 3/4)', '(1/4, -x+1/4, 1/4)',
                            '(1/4, -x+3/4, 3/4)', '(3/4, -x+1/4, 3/4)',
                            '(3/4, -x+3/4, 1/4)', '(x+3/4, 1/4, 3/4)',
                            '(x+3/4, 3/4, 1/4)', '(x+1/4, 1/4, 1/4)',
                            '(x+1/4, 3/4, 3/4)', '(-x+3/4, 3/4, 1/4)',
                            '(-x+3/4, 1/4, 3/4)', '(-x+1/4, 3/4, 3/4)',
                            '(-x+1/4, 1/4, 1/4)', '(3/4, 1/4, -x+3/4)',
                            '(3/4, 3/4, -x+1/4)', '(1/4, 1/4, -x+1/4)',
                            '(1/4, 3/4, -x+3/4)', '(1/4, 3/4, x+3/4)',
                            '(1/4, 1/4, x+1/4)', '(3/4, 3/4, x+1/4)',
                            '(3/4, 1/4, x+3/4)', '(-x+3/4, 3/4, 3/4)',
                            '(-x+3/4, 1/4, 1/4)', '(-x+1/4, 3/4, 1/4)',
                            '(-x+1/4, 1/4, 3/4)', '(x+3/4, 1/4, 1/4)',
                            '(x+3/4, 3/4, 3/4)', '(x+1/4, 1/4, 3/4)',
                            '(x+1/4, 3/4, 1/4)', '(3/4, -x+3/4, 3/4)',
                            '(3/4, -x+1/4, 1/4)', '(1/4, -x+3/4, 1/4)',
                            '(1/4, -x+1/4, 3/4)', '(1/4, x+3/4, 1/4)',
                            '(1/4, x+1/4, 3/4)', '(3/4, x+3/4, 3/4)',
                            '(3/4, x+1/4, 1/4)', '(3/4, 3/4, -x+3/4)',
                            '(3/4, 1/4, -x+1/4)', '(1/4, 3/4, -x+1/4)',
                            '(1/4, 1/4, -x+3/4)', '(1/4, 1/4, x+3/4)',
                            '(1/4, 3/4, x+1/4)', '(3/4, 1/4, x+1/4)',
                            '(3/4, 3/4, x+3/4)', '(0, -x+1/2, 0)',
                            '(0, -x, 1/2)', '(1/2, -x+1/2, 1/2)',
                            '(1/2, -x, 0)', '(1/2, x+1/2, 1/2)',
                            '(1/2, x, 0)', '(0, x+1/2, 0)', '(0, x, 1/2)',
                            '(-x, 1/2, 0)', '(-x, 0, 1/2)',
                            '(-x+1/2, 1/2, 1/2)', '(-x+1/2, 0, 0)',
                            '(x, 0, 1/2)', '(x, 1/2, 0)', '(x+1/2, 0, 0)',
                            '(x+1/2, 1/2, 1/2)', '(0, 1/2, x)',
                            '(0, 0, x+1/2)', '(1/2, 1/2, x+1/2)',
                            '(1/2, 0, x)', '(1/2, 0, -x)',
                            '(1/2, 1/2, -x+1/2)', '(0, 0, -x+1/2)',
                            '(0, 1/2, -x)')),
                '96g': (2, ('(1/8, y, -y+1/4)', '(1/8, y+1/2, -y+3/4)',
                            '(5/8, y, -y+3/4)', '(5/8, y+1/2, -y+1/4)',
                            '(7/8, -y+1/2, -y+3/4)', '(7/8, -y, -y+1/4)',
                            '(3/8, -y+1/2, -y+1/4)', '(3/8, -y, -y+3/4)',
                            '(3/8, y+1/2, y+3/4)', '(3/8, y, y+1/4)',
                            '(7/8, y+1/2, y+1/4)', '(7/8, y, y+3/4)',
                            '(5/8, -y, y+1/4)', '(5/8, -y+1/2, y+3/4)',
                            '(1/8, -y, y+3/4)', '(1/8, -y+1/2, y+1/4)',
                            '(-y+1/4, 1/8, y)', '(-y+1/4, 5/8, y+1/2)',
                            '(-y+3/4, 1/8, y+1/2)', '(-y+3/4, 5/8, y)',
                            '(-y+3/4, 7/8, -y+1/2)', '(-y+3/4, 3/8, -y)',
                            '(-y+1/4, 7/8, -y)', '(-y+1/4, 3/8, -y+1/2)',
                            '(y+3/4, 3/8, y+1/2)', '(y+3/4, 7/8, y)',
                            '(y+1/4, 3/8, y)', '(y+1/4, 7/8, y+1/2)',
                            '(y+1/4, 5/8, -y)', '(y+1/4, 1/8, -y+1/2)',
                            '(y+3/4, 5/8, -y+1/2)', '(y+3/4, 1/8, -y)',
                            '(y, -y+1/4, 1/8)', '(y, -y+3/4, 5/8)',
                            '(y+1/2, -y+1/4, 5/8)', '(y+1/2, -y+3/4, 1/8)',
                            '(-y+1/2, -y+3/4, 7/8)', '(-y+1/2, -y+1/4, 3/8)',
                            '(-y, -y+3/4, 3/8)', '(-y, -y+1/4, 7/8)',
                            '(y+1/2, y+3/4, 3/8)', '(y+1/2, y+1/4, 7/8)',
                            '(y, y+3/4, 7/8)', '(y, y+1/4, 3/8)',
                            '(-y, y+1/4, 5/8)', '(-y, y+3/4, 1/8)',
                            '(-y+1/2, y+1/4, 1/8)', '(-y+1/2, y+3/4, 5/8)',
                            '(5/8, -y+3/4, y+1/2)', '(5/8, -y+1/4, y)',
                            '(1/8, -y+3/4, y)', '(1/8, -y+1/4, y+1/2)',
                            '(7/8, y+1/4, y)', '(7/8, y+3/4, y+1/2)',
                            '(3/8, y+1/4, y+1/2)', '(3/8, y+3/4, y)',
                            '(3/8, -y+1/4, -y)', '(3/8, -y+3/4, -y+1/2)',
                            '(7/8, -y+1/4, -y+1/2)', '(7/8, -y+3/4, -y)',
                            '(1/8, y+3/4, -y+1/2)', '(1/8, y+1/4, -y)',
                            '(5/8, y+3/4, -y)', '(5/8, y+1/4, -y+1/2)',
                            '(y+1/2, 5/8, -y+3/4)', '(y+1/2, 1/8, -y+1/4)',
                            '(y, 5/8, -y+1/4)', '(y, 1/8, -y+3/4)',
                            '(y, 7/8, y+1/4)', '(y, 3/8, y+3/4)',
                            '(y+1/2, 7/8, y+3/4)', '(y+1/2, 3/8, y+1/4)',
                            '(-y, 3/8, -y+1/4)', '(-y, 7/8, -y+3/4)',
                            '(-y+1/2, 3/8, -y+3/4)', '(-y+1/2, 7/8, -y+1/4)',
                            '(-y+1/2, 1/8, y+3/4)', '(-y+1/2, 5/8, y+1/4)',
                            '(-y, 1/8, y+1/4)', '(-y, 5/8, y+3/4)',
                            '(-y+3/4, y+1/2, 5/8)', '(-y+3/4, y, 1/8)',
                            '(-y+1/4, y+1/2, 1/8)', '(-y+1/4, y, 5/8)',
                            '(y+1/4, y, 7/8)', '(y+1/4, y+1/2, 3/8)',
                            '(y+3/4, y, 3/8)', '(y+3/4, y+1/2, 7/8)',
                            '(-y+1/4, -y, 3/8)', '(-y+1/4, -y+1/2, 7/8)',
                            '(-y+3/4, -y, 7/8)', '(-y+3/4, -y+1/2, 3/8)',
                            '(y+3/4, -y+1/2, 1/8)', '(y+3/4, -y, 5/8)',
                            '(y+1/4, -y+1/2, 5/8)', '(y+1/4, -y, 1/8)')),
                '192h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                             '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                             '(-x, -y+1/2, z+1/2)', '(-x, -y, z)',
                             '(-x+1/2, -y+1/2, z)', '(-x+1/2, -y, z+1/2)',
                             '(-x+1/2, y+1/2, -z)', '(-x+1/2, y, -z+1/2)',
                             '(-x, y+1/2, -z+1/2)', '(-x, y, -z)',
                             '(x+1/2, -y, -z+1/2)', '(x+1/2, -y+1/2, -z)',
                             '(x, -y, -z)', '(x, -y+1/2, -z+1/2)',
                             '(z, x, y)', '(z, x+1/2, y+1/2)',
                             '(z+1/2, x, y+1/2)', '(z+1/2, x+1/2, y)',
                             '(z+1/2, -x, -y+1/2)', '(z+1/2, -x+1/2, -y)',
                             '(z, -x, -y)', '(z, -x+1/2, -y+1/2)',
                             '(-z, -x+1/2, y+1/2)', '(-z, -x, y)',
                             '(-z+1/2, -x+1/2, y)', '(-z+1/2, -x, y+1/2)',
                             '(-z+1/2, x+1/2, -y)', '(-z+1/2, x, -y+1/2)',
                             '(-z, x+1/2, -y+1/2)', '(-z, x, -y)',
                             '(y, z, x)', '(y, z+1/2, x+1/2)',
                             '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                             '(-y+1/2, z+1/2, -x)', '(-y+1/2, z, -x+1/2)',
                             '(-y, z+1/2, -x+1/2)', '(-y, z, -x)',
                             '(y+1/2, -z, -x+1/2)', '(y+1/2, -z+1/2, -x)',
                             '(y, -z, -x)', '(y, -z+1/2, -x+1/2)',
                             '(-y, -z+1/2, x+1/2)', '(-y, -z, x)',
                             '(-y+1/2, -z+1/2, x)', '(-y+1/2, -z, x+1/2)',
                             '(y+3/4, x+1/4, -z+3/4)',
                             '(y+3/4, x+3/4, -z+1/4)',
                             '(y+1/4, x+1/4, -z+1/4)',
                             '(y+1/4, x+3/4, -z+3/4)',
                             '(-y+1/4, -x+1/4, -z+1/4)',
                             '(-y+1/4, -x+3/4, -z+3/4)',
                             '(-y+3/4, -x+1/4, -z+3/4)',
                             '(-y+3/4, -x+3/4, -z+1/4)',
                             '(y+1/4, -x+3/4, z+3/4)',
                             '(y+1/4, -x+1/4, z+1/4)',
                             '(y+3/4, -x+3/4, z+1/4)',
                             '(y+3/4, -x+1/4, z+3/4)',
                             '(-y+3/4, x+3/4, z+1/4)',
                             '(-y+3/4, x+1/4, z+3/4)',
                             '(-y+1/4, x+3/4, z+3/4)',
                             '(-y+1/4, x+1/4, z+1/4)',
                             '(x+3/4, z+1/4, -y+3/4)',
                             '(x+3/4, z+3/4, -y+1/4)',
                             '(x+1/4, z+1/4, -y+1/4)',
                             '(x+1/4, z+3/4, -y+3/4)',
                             '(-x+3/4, z+3/4, y+1/4)',
                             '(-x+3/4, z+1/4, y+3/4)',
                             '(-x+1/4, z+3/4, y+3/4)',
                             '(-x+1/4, z+1/4, y+1/4)',
                             '(-x+1/4, -z+1/4, -y+1/4)',
                             '(-x+1/4, -z+3/4, -y+3/4)',
                             '(-x+3/4, -z+1/4, -y+3/4)',
                             '(-x+3/4, -z+3/4, -y+1/4)',
                             '(x+1/4, -z+3/4, y+3/4)',
                             '(x+1/4, -z+1/4, y+1/4)',
                             '(x+3/4, -z+3/4, y+1/4)',
                             '(x+3/4, -z+1/4, y+3/4)',
                             '(z+3/4, y+1/4, -x+3/4)',
                             '(z+3/4, y+3/4, -x+1/4)',
                             '(z+1/4, y+1/4, -x+1/4)',
                             '(z+1/4, y+3/4, -x+3/4)',
                             '(z+1/4, -y+3/4, x+3/4)',
                             '(z+1/4, -y+1/4, x+1/4)',
                             '(z+3/4, -y+3/4, x+1/4)',
                             '(z+3/4, -y+1/4, x+3/4)',
                             '(-z+3/4, y+3/4, x+1/4)',
                             '(-z+3/4, y+1/4, x+3/4)',
                             '(-z+1/4, y+3/4, x+3/4)',
                             '(-z+1/4, y+1/4, x+1/4)',
                             '(-z+1/4, -y+1/4, -x+1/4)',
                             '(-z+1/4, -y+3/4, -x+3/4)',
                             '(-z+3/4, -y+1/4, -x+3/4)',
                             '(-z+3/4, -y+3/4, -x+1/4)',
                             '(-x+3/4, -y+3/4, -z+3/4)',
                             '(-x+3/4, -y+1/4, -z+1/4)',
                             '(-x+1/4, -y+3/4, -z+1/4)',
                             '(-x+1/4, -y+1/4, -z+3/4)',
                             '(x+3/4, y+1/4, -z+1/4)',
                             '(x+3/4, y+3/4, -z+3/4)',
                             '(x+1/4, y+1/4, -z+3/4)',
                             '(x+1/4, y+3/4, -z+1/4)',
                             '(x+1/4, -y+1/4, z+3/4)',
                             '(x+1/4, -y+3/4, z+1/4)',
                             '(x+3/4, -y+1/4, z+1/4)',
                             '(x+3/4, -y+3/4, z+3/4)',
                             '(-x+1/4, y+3/4, z+1/4)',
                             '(-x+1/4, y+1/4, z+3/4)',
                             '(-x+3/4, y+3/4, z+3/4)',
                             '(-x+3/4, y+1/4, z+1/4)',
                             '(-z+3/4, -x+3/4, -y+3/4)',
                             '(-z+3/4, -x+1/4, -y+1/4)',
                             '(-z+1/4, -x+3/4, -y+1/4)',
                             '(-z+1/4, -x+1/4, -y+3/4)',
                             '(-z+1/4, x+3/4, y+1/4)',
                             '(-z+1/4, x+1/4, y+3/4)',
                             '(-z+3/4, x+3/4, y+3/4)',
                             '(-z+3/4, x+1/4, y+1/4)',
                             '(z+3/4, x+1/4, -y+1/4)',
                             '(z+3/4, x+3/4, -y+3/4)',
                             '(z+1/4, x+1/4, -y+3/4)',
                             '(z+1/4, x+3/4, -y+1/4)',
                             '(z+1/4, -x+1/4, y+3/4)',
                             '(z+1/4, -x+3/4, y+1/4)',
                             '(z+3/4, -x+1/4, y+1/4)',
                             '(z+3/4, -x+3/4, y+3/4)',
                             '(-y+3/4, -z+3/4, -x+3/4)',
                             '(-y+3/4, -z+1/4, -x+1/4)',
                             '(-y+1/4, -z+3/4, -x+1/4)',
                             '(-y+1/4, -z+1/4, -x+3/4)',
                             '(y+1/4, -z+1/4, x+3/4)',
                             '(y+1/4, -z+3/4, x+1/4)',
                             '(y+3/4, -z+1/4, x+1/4)',
                             '(y+3/4, -z+3/4, x+3/4)',
                             '(-y+1/4, z+3/4, x+1/4)',
                             '(-y+1/4, z+1/4, x+3/4)',
                             '(-y+3/4, z+3/4, x+3/4)',
                             '(-y+3/4, z+1/4, x+1/4)',
                             '(y+3/4, z+1/4, -x+1/4)',
                             '(y+3/4, z+3/4, -x+3/4)',
                             '(y+1/4, z+1/4, -x+3/4)',
                             '(y+1/4, z+3/4, -x+1/4)', '(-y, -x+1/2, z)',
                             '(-y, -x, z+1/2)', '(-y+1/2, -x+1/2, z+1/2)',
                             '(-y+1/2, -x, z)', '(y+1/2, x+1/2, z+1/2)',
                             '(y+1/2, x, z)', '(y, x+1/2, z)',
                             '(y, x, z+1/2)', '(-y+1/2, x, -z)',
                             '(-y+1/2, x+1/2, -z+1/2)', '(-y, x, -z+1/2)',
                             '(-y, x+1/2, -z)', '(y, -x, -z+1/2)',
                             '(y, -x+1/2, -z)', '(y+1/2, -x, -z)',
                             '(y+1/2, -x+1/2, -z+1/2)', '(-x, -z+1/2, y)',
                             '(-x, -z, y+1/2)', '(-x+1/2, -z+1/2, y+1/2)',
                             '(-x+1/2, -z, y)', '(x, -z, -y+1/2)',
                             '(x, -z+1/2, -y)', '(x+1/2, -z, -y)',
                             '(x+1/2, -z+1/2, -y+1/2)',
                             '(x+1/2, z+1/2, y+1/2)', '(x+1/2, z, y)',
                             '(x, z+1/2, y)', '(x, z, y+1/2)',
                             '(-x+1/2, z, -y)', '(-x+1/2, z+1/2, -y+1/2)',
                             '(-x, z, -y+1/2)', '(-x, z+1/2, -y)',
                             '(-z, -y+1/2, x)', '(-z, -y, x+1/2)',
                             '(-z+1/2, -y+1/2, x+1/2)', '(-z+1/2, -y, x)',
                             '(-z+1/2, y, -x)', '(-z+1/2, y+1/2, -x+1/2)',
                             '(-z, y, -x+1/2)', '(-z, y+1/2, -x)',
                             '(z, -y, -x+1/2)', '(z, -y+1/2, -x)',
                             '(z+1/2, -y, -x)', '(z+1/2, -y+1/2, -x+1/2)',
                             '(z+1/2, y+1/2, x+1/2)', '(z+1/2, y, x)',
                             '(z, y+1/2, x)', '(z, y, x+1/2)'))},
      '228:2': {'16a': (0, ('(1/8, 1/8, 1/8)', '(1/8, 5/8, 5/8)',
                            '(5/8, 1/8, 5/8)', '(5/8, 5/8, 1/8)',
                            '(7/8, 3/8, 7/8)', '(7/8, 7/8, 3/8)',
                            '(3/8, 3/8, 3/8)', '(3/8, 7/8, 7/8)',
                            '(7/8, 7/8, 7/8)', '(7/8, 3/8, 3/8)',
                            '(3/8, 7/8, 3/8)', '(3/8, 3/8, 7/8)',
                            '(1/8, 5/8, 1/8)', '(1/8, 1/8, 5/8)',
                            '(5/8, 5/8, 5/8)', '(5/8, 1/8, 1/8)')),
                '32b': (0, ('(1/4, 1/4, 1/4)', '(1/4, 3/4, 3/4)',
                            '(3/4, 1/4, 3/4)', '(3/4, 3/4, 1/4)',
                            '(0, 1/2, 3/4)', '(0, 0, 1/4)', '(1/2, 1/2, 1/4)',
                            '(1/2, 0, 3/4)', '(1/2, 3/4, 0)',
                            '(1/2, 1/4, 1/2)', '(0, 3/4, 1/2)', '(0, 1/4, 0)',
                            '(3/4, 0, 1/2)', '(3/4, 1/2, 0)', '(1/4, 0, 0)',
                            '(1/4, 1/2, 1/2)', '(3/4, 3/4, 3/4)',
                            '(3/4, 1/4, 1/4)', '(1/4, 3/4, 1/4)',
                            '(1/4, 1/4, 3/4)', '(0, 1/2, 1/4)', '(0, 0, 3/4)',
                            '(1/2, 1/2, 3/4)', '(1/2, 0, 1/4)',
                            '(1/2, 1/4, 0)', '(1/2, 3/4, 1/2)',
                            '(0, 1/4, 1/2)', '(0, 3/4, 0)', '(1/4, 0, 1/2)',
                            '(1/4, 1/2, 0)', '(3/4, 0, 0)', '(3/4, 1/2, 1/2)'
                            )),
                '32c': (0, ('(0, 0, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 1/2)',
                            '(1/2, 1/2, 0)', '(1/4, 3/4, 1/2)',
                            '(1/4, 1/4, 0)', '(3/4, 3/4, 0)',
                            '(3/4, 1/4, 1/2)', '(3/4, 1/2, 1/4)',
                            '(3/4, 0, 3/4)', '(1/4, 1/2, 3/4)',
                            '(1/4, 0, 1/4)', '(1/2, 1/4, 3/4)',
                            '(1/2, 3/4, 1/4)', '(0, 1/4, 1/4)',
                            '(0, 3/4, 3/4)', '(3/4, 1/4, 0)',
                            '(3/4, 3/4, 1/2)', '(1/4, 1/4, 1/2)',
                            '(1/4, 3/4, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 0)',
                            '(0, 1/2, 0)', '(0, 0, 1/2)', '(1/4, 0, 3/4)',
                            '(1/4, 1/2, 1/4)', '(3/4, 0, 1/4)',
                            '(3/4, 1/2, 3/4)', '(0, 3/4, 1/4)',
                            '(0, 1/4, 3/4)', '(1/2, 3/4, 3/4)',
                            '(1/2, 1/4, 1/4)')),
                '48d': (0, ('(7/8, 1/8, 1/8)', '(7/8, 5/8, 5/8)',
                            '(3/8, 1/8, 5/8)', '(3/8, 5/8, 1/8)',
                            '(3/8, 5/8, 5/8)', '(3/8, 1/8, 1/8)',
                            '(7/8, 5/8, 1/8)', '(7/8, 1/8, 5/8)',
                            '(1/8, 7/8, 1/8)', '(1/8, 3/8, 5/8)',
                            '(5/8, 7/8, 5/8)', '(5/8, 3/8, 1/8)',
                            '(5/8, 3/8, 5/8)', '(5/8, 7/8, 1/8)',
                            '(1/8, 3/8, 1/8)', '(1/8, 7/8, 5/8)',
                            '(1/8, 1/8, 7/8)', '(1/8, 5/8, 3/8)',
                            '(5/8, 1/8, 3/8)', '(5/8, 5/8, 7/8)',
                            '(5/8, 5/8, 3/8)', '(5/8, 1/8, 7/8)',
                            '(1/8, 5/8, 7/8)', '(1/8, 1/8, 3/8)',
                            '(7/8, 1/8, 7/8)', '(7/8, 5/8, 3/8)',
                            '(3/8, 1/8, 3/8)', '(3/8, 5/8, 7/8)',
                            '(3/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                            '(7/8, 5/8, 7/8)', '(7/8, 1/8, 3/8)',
                            '(5/8, 3/8, 7/8)', '(5/8, 7/8, 3/8)',
                            '(1/8, 3/8, 3/8)', '(1/8, 7/8, 7/8)',
                            '(1/8, 7/8, 3/8)', '(1/8, 3/8, 7/8)',
                            '(5/8, 7/8, 7/8)', '(5/8, 3/8, 3/8)',
                            '(7/8, 3/8, 1/8)', '(7/8, 7/8, 5/8)',
                            '(3/8, 3/8, 5/8)', '(3/8, 7/8, 1/8)',
                            '(3/8, 7/8, 5/8)', '(3/8, 3/8, 1/8)',
                            '(7/8, 7/8, 1/8)', '(7/8, 3/8, 5/8)')),
                '64e': (1, ('(x, x, x)', '(x, x+1/2, x+1/2)',
                            '(x+1/2, x, x+1/2)', '(x+1/2, x+1/2, x)',
                            '(-x+1/4, -x+3/4, x+1/2)', '(-x+1/4, -x+1/4, x)',
                            '(-x+3/4, -x+3/4, x)', '(-x+3/4, -x+1/4, x+1/2)',
                            '(-x+3/4, x+1/2, -x+1/4)', '(-x+3/4, x, -x+3/4)',
                            '(-x+1/4, x+1/2, -x+3/4)', '(-x+1/4, x, -x+1/4)',
                            '(x+1/2, -x+1/4, -x+3/4)',
                            '(x+1/2, -x+3/4, -x+1/4)', '(x, -x+1/4, -x+1/4)',
                            '(x, -x+3/4, -x+3/4)', '(x+3/4, x+1/4, -x)',
                            '(x+3/4, x+3/4, -x+1/2)',
                            '(x+1/4, x+1/4, -x+1/2)', '(x+1/4, x+3/4, -x)',
                            '(-x+1/2, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x)',
                            '(-x, -x+1/2, -x)', '(-x, -x, -x+1/2)',
                            '(x+1/4, -x, x+3/4)', '(x+1/4, -x+1/2, x+1/4)',
                            '(x+3/4, -x, x+1/4)', '(x+3/4, -x+1/2, x+3/4)',
                            '(-x, x+3/4, x+1/4)', '(-x, x+1/4, x+3/4)',
                            '(-x+1/2, x+3/4, x+3/4)',
                            '(-x+1/2, x+1/4, x+1/4)', '(-x, -x, -x)',
                            '(-x, -x+1/2, -x+1/2)', '(-x+1/2, -x, -x+1/2)',
                            '(-x+1/2, -x+1/2, -x)', '(x+3/4, x+1/4, -x+1/2)',
                            '(x+3/4, x+3/4, -x)', '(x+1/4, x+1/4, -x)',
                            '(x+1/4, x+3/4, -x+1/2)',
                            '(x+1/4, -x+1/2, x+3/4)', '(x+1/4, -x, x+1/4)',
                            '(x+3/4, -x+1/2, x+1/4)', '(x+3/4, -x, x+3/4)',
                            '(-x+1/2, x+3/4, x+1/4)',
                            '(-x+1/2, x+1/4, x+3/4)', '(-x, x+3/4, x+3/4)',
                            '(-x, x+1/4, x+1/4)', '(-x+1/4, -x+3/4, x)',
                            '(-x+1/4, -x+1/4, x+1/2)',
                            '(-x+3/4, -x+3/4, x+1/2)', '(-x+3/4, -x+1/4, x)',
                            '(x+1/2, x+1/2, x+1/2)', '(x+1/2, x, x)',
                            '(x, x+1/2, x)', '(x, x, x+1/2)',
                            '(-x+3/4, x, -x+1/4)', '(-x+3/4, x+1/2, -x+3/4)',
                            '(-x+1/4, x, -x+3/4)', '(-x+1/4, x+1/2, -x+1/4)',
                            '(x, -x+1/4, -x+3/4)', '(x, -x+3/4, -x+1/4)',
                            '(x+1/2, -x+1/4, -x+1/4)',
                            '(x+1/2, -x+3/4, -x+3/4)')),
                '96f': (1, ('(x, 1/8, 1/8)', '(x, 5/8, 5/8)',
                            '(x+1/2, 1/8, 5/8)', '(x+1/2, 5/8, 1/8)',
                            '(-x+1/4, 5/8, 5/8)', '(-x+1/4, 1/8, 1/8)',
                            '(-x+3/4, 5/8, 1/8)', '(-x+3/4, 1/8, 5/8)',
                            '(1/8, x, 1/8)', '(1/8, x+1/2, 5/8)',
                            '(5/8, x, 5/8)', '(5/8, x+1/2, 1/8)',
                            '(5/8, -x+1/4, 5/8)', '(5/8, -x+3/4, 1/8)',
                            '(1/8, -x+1/4, 1/8)', '(1/8, -x+3/4, 5/8)',
                            '(1/8, 1/8, x)', '(1/8, 5/8, x+1/2)',
                            '(5/8, 1/8, x+1/2)', '(5/8, 5/8, x)',
                            '(5/8, 5/8, -x+1/4)', '(5/8, 1/8, -x+3/4)',
                            '(1/8, 5/8, -x+3/4)', '(1/8, 1/8, -x+1/4)',
                            '(7/8, x+1/4, 7/8)', '(7/8, x+3/4, 3/8)',
                            '(3/8, x+1/4, 3/8)', '(3/8, x+3/4, 7/8)',
                            '(3/8, -x+1/2, 3/8)', '(3/8, -x, 7/8)',
                            '(7/8, -x+1/2, 7/8)', '(7/8, -x, 3/8)',
                            '(x+3/4, 3/8, 7/8)', '(x+3/4, 7/8, 3/8)',
                            '(x+1/4, 3/8, 3/8)', '(x+1/4, 7/8, 7/8)',
                            '(-x, 7/8, 3/8)', '(-x, 3/8, 7/8)',
                            '(-x+1/2, 7/8, 7/8)', '(-x+1/2, 3/8, 3/8)',
                            '(7/8, 3/8, -x)', '(7/8, 7/8, -x+1/2)',
                            '(3/8, 3/8, -x+1/2)', '(3/8, 7/8, -x)',
                            '(3/8, 7/8, x+3/4)', '(3/8, 3/8, x+1/4)',
                            '(7/8, 7/8, x+1/4)', '(7/8, 3/8, x+3/4)',
                            '(-x, 7/8, 7/8)', '(-x, 3/8, 3/8)',
                            '(-x+1/2, 7/8, 3/8)', '(-x+1/2, 3/8, 7/8)',
                            '(x+3/4, 3/8, 3/8)', '(x+3/4, 7/8, 7/8)',
                            '(x+1/4, 3/8, 7/8)', '(x+1/4, 7/8, 3/8)',
                            '(7/8, -x, 7/8)', '(7/8, -x+1/2, 3/8)',
                            '(3/8, -x, 3/8)', '(3/8, -x+1/2, 7/8)',
                            '(3/8, x+3/4, 3/8)', '(3/8, x+1/4, 7/8)',
                            '(7/8, x+3/4, 7/8)', '(7/8, x+1/4, 3/8)',
                            '(7/8, 7/8, -x)', '(7/8, 3/8, -x+1/2)',
                            '(3/8, 7/8, -x+1/2)', '(3/8, 3/8, -x)',
                            '(3/8, 3/8, x+3/4)', '(3/8, 7/8, x+1/4)',
                            '(7/8, 3/8, x+1/4)', '(7/8, 7/8, x+3/4)',
                            '(1/8, -x+3/4, 1/8)', '(1/8, -x+1/4, 5/8)',
                            '(5/8, -x+3/4, 5/8)', '(5/8, -x+1/4, 1/8)',
                            '(5/8, x+1/2, 5/8)', '(5/8, x, 1/8)',
                            '(1/8, x+1/2, 1/8)', '(1/8, x, 5/8)',
                            '(-x+1/4, 5/8, 1/8)', '(-x+1/4, 1/8, 5/8)',
                            '(-x+3/4, 5/8, 5/8)', '(-x+3/4, 1/8, 1/8)',
                            '(x, 1/8, 5/8)', '(x, 5/8, 1/8)',
                            '(x+1/2, 1/8, 1/8)', '(x+1/2, 5/8, 5/8)',
                            '(1/8, 5/8, x)', '(1/8, 1/8, x+1/2)',
                            '(5/8, 5/8, x+1/2)', '(5/8, 1/8, x)',
                            '(5/8, 1/8, -x+1/4)', '(5/8, 5/8, -x+3/4)',
                            '(1/8, 1/8, -x+3/4)', '(1/8, 5/8, -x+1/4)')),
                '96g': (2, ('(1/4, y, -y)', '(1/4, y+1/2, -y+1/2)',
                            '(3/4, y, -y+1/2)', '(3/4, y+1/2, -y)',
                            '(0, -y+3/4, -y+1/2)', '(0, -y+1/4, -y)',
                            '(1/2, -y+3/4, -y)', '(1/2, -y+1/4, -y+1/2)',
                            '(1/2, y+1/2, y+1/4)', '(1/2, y, y+3/4)',
                            '(0, y+1/2, y+3/4)', '(0, y, y+1/4)',
                            '(3/4, -y+1/4, y+3/4)', '(3/4, -y+3/4, y+1/4)',
                            '(1/4, -y+1/4, y+1/4)', '(1/4, -y+3/4, y+3/4)',
                            '(-y, 1/4, y)', '(-y, 3/4, y+1/2)',
                            '(-y+1/2, 1/4, y+1/2)', '(-y+1/2, 3/4, y)',
                            '(-y+1/2, 0, -y+3/4)', '(-y+1/2, 1/2, -y+1/4)',
                            '(-y, 0, -y+1/4)', '(-y, 1/2, -y+3/4)',
                            '(y+1/4, 1/2, y+1/2)', '(y+1/4, 0, y)',
                            '(y+3/4, 1/2, y)', '(y+3/4, 0, y+1/2)',
                            '(y+3/4, 3/4, -y+1/4)', '(y+3/4, 1/4, -y+3/4)',
                            '(y+1/4, 3/4, -y+3/4)', '(y+1/4, 1/4, -y+1/4)',
                            '(y, -y, 1/4)', '(y, -y+1/2, 3/4)',
                            '(y+1/2, -y, 3/4)', '(y+1/2, -y+1/2, 1/4)',
                            '(-y+3/4, -y+1/2, 0)', '(-y+3/4, -y, 1/2)',
                            '(-y+1/4, -y+1/2, 1/2)', '(-y+1/4, -y, 0)',
                            '(y+1/2, y+1/4, 1/2)', '(y+1/2, y+3/4, 0)',
                            '(y, y+1/4, 0)', '(y, y+3/4, 1/2)',
                            '(-y+1/4, y+3/4, 3/4)', '(-y+1/4, y+1/4, 1/4)',
                            '(-y+3/4, y+3/4, 1/4)', '(-y+3/4, y+1/4, 3/4)',
                            '(3/4, -y, y)', '(3/4, -y+1/2, y+1/2)',
                            '(1/4, -y, y+1/2)', '(1/4, -y+1/2, y)',
                            '(0, y+1/4, y+1/2)', '(0, y+3/4, y)',
                            '(1/2, y+1/4, y)', '(1/2, y+3/4, y+1/2)',
                            '(1/2, -y+1/2, -y+3/4)', '(1/2, -y, -y+1/4)',
                            '(0, -y+1/2, -y+1/4)', '(0, -y, -y+3/4)',
                            '(1/4, y+3/4, -y+1/4)', '(1/4, y+1/4, -y+3/4)',
                            '(3/4, y+3/4, -y+3/4)', '(3/4, y+1/4, -y+1/4)',
                            '(y, 3/4, -y)', '(y, 1/4, -y+1/2)',
                            '(y+1/2, 3/4, -y+1/2)', '(y+1/2, 1/4, -y)',
                            '(y+1/2, 0, y+1/4)', '(y+1/2, 1/2, y+3/4)',
                            '(y, 0, y+3/4)', '(y, 1/2, y+1/4)',
                            '(-y+3/4, 1/2, -y+1/2)', '(-y+3/4, 0, -y)',
                            '(-y+1/4, 1/2, -y)', '(-y+1/4, 0, -y+1/2)',
                            '(-y+1/4, 1/4, y+3/4)', '(-y+1/4, 3/4, y+1/4)',
                            '(-y+3/4, 1/4, y+1/4)', '(-y+3/4, 3/4, y+3/4)',
                            '(-y, y, 3/4)', '(-y, y+1/2, 1/4)',
                            '(-y+1/2, y, 1/4)', '(-y+1/2, y+1/2, 3/4)',
                            '(y+1/4, y+1/2, 0)', '(y+1/4, y, 1/2)',
                            '(y+3/4, y+1/2, 1/2)', '(y+3/4, y, 0)',
                            '(-y+1/2, -y+3/4, 1/2)', '(-y+1/2, -y+1/4, 0)',
                            '(-y, -y+3/4, 0)', '(-y, -y+1/4, 1/2)',
                            '(y+3/4, -y+1/4, 1/4)', '(y+3/4, -y+3/4, 3/4)',
                            '(y+1/4, -y+1/4, 3/4)', '(y+1/4, -y+3/4, 1/4)')),
                '192h': (7, ('(x, y, z)', '(x, y+1/2, z+1/2)',
                             '(x+1/2, y, z+1/2)', '(x+1/2, y+1/2, z)',
                             '(-x+1/4, -y+3/4, z+1/2)', '(-x+1/4, -y+1/4, z)',
                             '(-x+3/4, -y+3/4, z)', '(-x+3/4, -y+1/4, z+1/2)',
                             '(-x+3/4, y+1/2, -z+1/4)', '(-x+3/4, y, -z+3/4)',
                             '(-x+1/4, y+1/2, -z+3/4)', '(-x+1/4, y, -z+1/4)',
                             '(x+1/2, -y+1/4, -z+3/4)',
                             '(x+1/2, -y+3/4, -z+1/4)', '(x, -y+1/4, -z+1/4)',
                             '(x, -y+3/4, -z+3/4)', '(z, x, y)',
                             '(z, x+1/2, y+1/2)', '(z+1/2, x, y+1/2)',
                             '(z+1/2, x+1/2, y)', '(z+1/2, -x+1/4, -y+3/4)',
                             '(z+1/2, -x+3/4, -y+1/4)', '(z, -x+1/4, -y+1/4)',
                             '(z, -x+3/4, -y+3/4)', '(-z+1/4, -x+3/4, y+1/2)',
                             '(-z+1/4, -x+1/4, y)', '(-z+3/4, -x+3/4, y)',
                             '(-z+3/4, -x+1/4, y+1/2)',
                             '(-z+3/4, x+1/2, -y+1/4)', '(-z+3/4, x, -y+3/4)',
                             '(-z+1/4, x+1/2, -y+3/4)', '(-z+1/4, x, -y+1/4)',
                             '(y, z, x)', '(y, z+1/2, x+1/2)',
                             '(y+1/2, z, x+1/2)', '(y+1/2, z+1/2, x)',
                             '(-y+3/4, z+1/2, -x+1/4)', '(-y+3/4, z, -x+3/4)',
                             '(-y+1/4, z+1/2, -x+3/4)', '(-y+1/4, z, -x+1/4)',
                             '(y+1/2, -z+1/4, -x+3/4)',
                             '(y+1/2, -z+3/4, -x+1/4)', '(y, -z+1/4, -x+1/4)',
                             '(y, -z+3/4, -x+3/4)', '(-y+1/4, -z+3/4, x+1/2)',
                             '(-y+1/4, -z+1/4, x)', '(-y+3/4, -z+3/4, x)',
                             '(-y+3/4, -z+1/4, x+1/2)', '(y+3/4, x+1/4, -z)',
                             '(y+3/4, x+3/4, -z+1/2)',
                             '(y+1/4, x+1/4, -z+1/2)', '(y+1/4, x+3/4, -z)',
                             '(-y+1/2, -x+1/2, -z+1/2)', '(-y+1/2, -x, -z)',
                             '(-y, -x+1/2, -z)', '(-y, -x, -z+1/2)',
                             '(y+1/4, -x, z+3/4)', '(y+1/4, -x+1/2, z+1/4)',
                             '(y+3/4, -x, z+1/4)', '(y+3/4, -x+1/2, z+3/4)',
                             '(-y, x+3/4, z+1/4)', '(-y, x+1/4, z+3/4)',
                             '(-y+1/2, x+3/4, z+3/4)',
                             '(-y+1/2, x+1/4, z+1/4)', '(x+3/4, z+1/4, -y)',
                             '(x+3/4, z+3/4, -y+1/2)',
                             '(x+1/4, z+1/4, -y+1/2)', '(x+1/4, z+3/4, -y)',
                             '(-x, z+3/4, y+1/4)', '(-x, z+1/4, y+3/4)',
                             '(-x+1/2, z+3/4, y+3/4)',
                             '(-x+1/2, z+1/4, y+1/4)',
                             '(-x+1/2, -z+1/2, -y+1/2)', '(-x+1/2, -z, -y)',
                             '(-x, -z+1/2, -y)', '(-x, -z, -y+1/2)',
                             '(x+1/4, -z, y+3/4)', '(x+1/4, -z+1/2, y+1/4)',
                             '(x+3/4, -z, y+1/4)', '(x+3/4, -z+1/2, y+3/4)',
                             '(z+3/4, y+1/4, -x)', '(z+3/4, y+3/4, -x+1/2)',
                             '(z+1/4, y+1/4, -x+1/2)', '(z+1/4, y+3/4, -x)',
                             '(z+1/4, -y, x+3/4)', '(z+1/4, -y+1/2, x+1/4)',
                             '(z+3/4, -y, x+1/4)', '(z+3/4, -y+1/2, x+3/4)',
                             '(-z, y+3/4, x+1/4)', '(-z, y+1/4, x+3/4)',
                             '(-z+1/2, y+3/4, x+3/4)',
                             '(-z+1/2, y+1/4, x+1/4)',
                             '(-z+1/2, -y+1/2, -x+1/2)', '(-z+1/2, -y, -x)',
                             '(-z, -y+1/2, -x)', '(-z, -y, -x+1/2)',
                             '(-x, -y, -z)', '(-x, -y+1/2, -z+1/2)',
                             '(-x+1/2, -y, -z+1/2)', '(-x+1/2, -y+1/2, -z)',
                             '(x+3/4, y+1/4, -z+1/2)', '(x+3/4, y+3/4, -z)',
                             '(x+1/4, y+1/4, -z)', '(x+1/4, y+3/4, -z+1/2)',
                             '(x+1/4, -y+1/2, z+3/4)', '(x+1/4, -y, z+1/4)',
                             '(x+3/4, -y+1/2, z+1/4)', '(x+3/4, -y, z+3/4)',
                             '(-x+1/2, y+3/4, z+1/4)',
                             '(-x+1/2, y+1/4, z+3/4)', '(-x, y+3/4, z+3/4)',
                             '(-x, y+1/4, z+1/4)', '(-z, -x, -y)',
                             '(-z, -x+1/2, -y+1/2)', '(-z+1/2, -x, -y+1/2)',
                             '(-z+1/2, -x+1/2, -y)', '(-z+1/2, x+3/4, y+1/4)',
                             '(-z+1/2, x+1/4, y+3/4)', '(-z, x+3/4, y+3/4)',
                             '(-z, x+1/4, y+1/4)', '(z+3/4, x+1/4, -y+1/2)',
                             '(z+3/4, x+3/4, -y)', '(z+1/4, x+1/4, -y)',
                             '(z+1/4, x+3/4, -y+1/2)',
                             '(z+1/4, -x+1/2, y+3/4)', '(z+1/4, -x, y+1/4)',
                             '(z+3/4, -x+1/2, y+1/4)', '(z+3/4, -x, y+3/4)',
                             '(-y, -z, -x)', '(-y, -z+1/2, -x+1/2)',
                             '(-y+1/2, -z, -x+1/2)', '(-y+1/2, -z+1/2, -x)',
                             '(y+1/4, -z+1/2, x+3/4)', '(y+1/4, -z, x+1/4)',
                             '(y+3/4, -z+1/2, x+1/4)', '(y+3/4, -z, x+3/4)',
                             '(-y+1/2, z+3/4, x+1/4)',
                             '(-y+1/2, z+1/4, x+3/4)', '(-y, z+3/4, x+3/4)',
                             '(-y, z+1/4, x+1/4)', '(y+3/4, z+1/4, -x+1/2)',
                             '(y+3/4, z+3/4, -x)', '(y+1/4, z+1/4, -x)',
                             '(y+1/4, z+3/4, -x+1/2)', '(-y+1/4, -x+3/4, z)',
                             '(-y+1/4, -x+1/4, z+1/2)',
                             '(-y+3/4, -x+3/4, z+1/2)', '(-y+3/4, -x+1/4, z)',
                             '(y+1/2, x+1/2, z+1/2)', '(y+1/2, x, z)',
                             '(y, x+1/2, z)', '(y, x, z+1/2)',
                             '(-y+3/4, x, -z+1/4)', '(-y+3/4, x+1/2, -z+3/4)',
                             '(-y+1/4, x, -z+3/4)', '(-y+1/4, x+1/2, -z+1/4)',
                             '(y, -x+1/4, -z+3/4)', '(y, -x+3/4, -z+1/4)',
                             '(y+1/2, -x+1/4, -z+1/4)',
                             '(y+1/2, -x+3/4, -z+3/4)', '(-x+1/4, -z+3/4, y)',
                             '(-x+1/4, -z+1/4, y+1/2)',
                             '(-x+3/4, -z+3/4, y+1/2)', '(-x+3/4, -z+1/4, y)',
                             '(x, -z+1/4, -y+3/4)', '(x, -z+3/4, -y+1/4)',
                             '(x+1/2, -z+1/4, -y+1/4)',
                             '(x+1/2, -z+3/4, -y+3/4)',
                             '(x+1/2, z+1/2, y+1/2)', '(x+1/2, z, y)',
                             '(x, z+1/2, y)', '(x, z, y+1/2)',
                             '(-x+3/4, z, -y+1/4)', '(-x+3/4, z+1/2, -y+3/4)',
                             '(-x+1/4, z, -y+3/4)', '(-x+1/4, z+1/2, -y+1/4)',
                             '(-z+1/4, -y+3/4, x)', '(-z+1/4, -y+1/4, x+1/2)',
                             '(-z+3/4, -y+3/4, x+1/2)', '(-z+3/4, -y+1/4, x)',
                             '(-z+3/4, y, -x+1/4)', '(-z+3/4, y+1/2, -x+3/4)',
                             '(-z+1/4, y, -x+3/4)', '(-z+1/4, y+1/2, -x+1/4)',
                             '(z, -y+1/4, -x+3/4)', '(z, -y+3/4, -x+1/4)',
                             '(z+1/2, -y+1/4, -x+1/4)',
                             '(z+1/2, -y+3/4, -x+3/4)',
                             '(z+1/2, y+1/2, x+1/2)', '(z+1/2, y, x)',
                             '(z, y+1/2, x)', '(z, y, x+1/2)'))},
      '229': {'2a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)')),
              '6b': (0, ('(0, 1/2, 1/2)', '(1/2, 0, 0)', '(1/2, 0, 1/2)',
                         '(0, 1/2, 0)', '(1/2, 1/2, 0)', '(0, 0, 1/2)')),
              '8c': (0, ('(1/4, 1/4, 1/4)', '(3/4, 3/4, 3/4)',
                         '(3/4, 3/4, 1/4)', '(1/4, 1/4, 3/4)',
                         '(3/4, 1/4, 3/4)', '(1/4, 3/4, 1/4)',
                         '(1/4, 3/4, 3/4)', '(3/4, 1/4, 1/4)')),
              '12d': (0, ('(1/4, 0, 1/2)', '(3/4, 1/2, 0)', '(3/4, 0, 1/2)',
                          '(1/4, 1/2, 0)', '(1/2, 1/4, 0)', '(0, 3/4, 1/2)',
                          '(1/2, 3/4, 0)', '(0, 1/4, 1/2)', '(0, 1/2, 1/4)',
                          '(1/2, 0, 3/4)', '(0, 1/2, 3/4)', '(1/2, 0, 1/4)')),
              '12e': (1, ('(x, 0, 0)', '(x+1/2, 1/2, 1/2)', '(-x, 0, 0)',
                          '(-x+1/2, 1/2, 1/2)', '(0, x, 0)',
                          '(1/2, x+1/2, 1/2)', '(0, -x, 0)',
                          '(1/2, -x+1/2, 1/2)', '(0, 0, x)',
                          '(1/2, 1/2, x+1/2)', '(0, 0, -x)',
                          '(1/2, 1/2, -x+1/2)')),
              '16f': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)', '(-x, -x, x)',
                          '(-x+1/2, -x+1/2, x+1/2)', '(-x, x, -x)',
                          '(-x+1/2, x+1/2, -x+1/2)', '(x, -x, -x)',
                          '(x+1/2, -x+1/2, -x+1/2)', '(x, x, -x)',
                          '(x+1/2, x+1/2, -x+1/2)', '(-x, -x, -x)',
                          '(-x+1/2, -x+1/2, -x+1/2)', '(x, -x, x)',
                          '(x+1/2, -x+1/2, x+1/2)', '(-x, x, x)',
                          '(-x+1/2, x+1/2, x+1/2)')),
              '24g': (1, ('(x, 0, 1/2)', '(x+1/2, 1/2, 0)', '(-x, 0, 1/2)',
                          '(-x+1/2, 1/2, 0)', '(1/2, x, 0)',
                          '(0, x+1/2, 1/2)', '(1/2, -x, 0)',
                          '(0, -x+1/2, 1/2)', '(0, 1/2, x)',
                          '(1/2, 0, x+1/2)', '(0, 1/2, -x)',
                          '(1/2, 0, -x+1/2)', '(0, x, 1/2)',
                          '(1/2, x+1/2, 0)', '(0, -x, 1/2)',
                          '(1/2, -x+1/2, 0)', '(x, 1/2, 0)',
                          '(x+1/2, 0, 1/2)', '(-x, 1/2, 0)',
                          '(-x+1/2, 0, 1/2)', '(1/2, 0, -x)',
                          '(0, 1/2, -x+1/2)', '(1/2, 0, x)',
                          '(0, 1/2, x+1/2)')),
              '24h': (2, ('(0, y, y)', '(1/2, y+1/2, y+1/2)', '(0, -y, y)',
                          '(1/2, -y+1/2, y+1/2)', '(0, y, -y)',
                          '(1/2, y+1/2, -y+1/2)', '(0, -y, -y)',
                          '(1/2, -y+1/2, -y+1/2)', '(y, 0, y)',
                          '(y+1/2, 1/2, y+1/2)', '(y, 0, -y)',
                          '(y+1/2, 1/2, -y+1/2)', '(-y, 0, y)',
                          '(-y+1/2, 1/2, y+1/2)', '(-y, 0, -y)',
                          '(-y+1/2, 1/2, -y+1/2)', '(y, y, 0)',
                          '(y+1/2, y+1/2, 1/2)', '(-y, y, 0)',
                          '(-y+1/2, y+1/2, 1/2)', '(y, -y, 0)',
                          '(y+1/2, -y+1/2, 1/2)', '(-y, -y, 0)',
                          '(-y+1/2, -y+1/2, 1/2)')),
              '48i': (2, ('(1/4, y, -y+1/2)', '(3/4, y+1/2, -y)',
                          '(3/4, -y, -y+1/2)', '(1/4, -y+1/2, -y)',
                          '(3/4, y, y+1/2)', '(1/4, y+1/2, y)',
                          '(1/4, -y, y+1/2)', '(3/4, -y+1/2, y)',
                          '(-y+1/2, 1/4, y)', '(-y, 3/4, y+1/2)',
                          '(-y+1/2, 3/4, -y)', '(-y, 1/4, -y+1/2)',
                          '(y+1/2, 3/4, y)', '(y, 1/4, y+1/2)',
                          '(y+1/2, 1/4, -y)', '(y, 3/4, -y+1/2)',
                          '(y, -y+1/2, 1/4)', '(y+1/2, -y, 3/4)',
                          '(-y, -y+1/2, 3/4)', '(-y+1/2, -y, 1/4)',
                          '(y, y+1/2, 3/4)', '(y+1/2, y, 1/4)',
                          '(-y, y+1/2, 1/4)', '(-y+1/2, y, 3/4)',
                          '(3/4, -y, y+1/2)', '(1/4, -y+1/2, y)',
                          '(1/4, y, y+1/2)', '(3/4, y+1/2, y)',
                          '(1/4, -y, -y+1/2)', '(3/4, -y+1/2, -y)',
                          '(3/4, y, -y+1/2)', '(1/4, y+1/2, -y)',
                          '(y+1/2, 3/4, -y)', '(y, 1/4, -y+1/2)',
                          '(y+1/2, 1/4, y)', '(y, 3/4, y+1/2)',
                          '(-y+1/2, 1/4, -y)', '(-y, 3/4, -y+1/2)',
                          '(-y+1/2, 3/4, y)', '(-y, 1/4, y+1/2)',
                          '(-y, y+1/2, 3/4)', '(-y+1/2, y, 1/4)',
                          '(y, y+1/2, 1/4)', '(y+1/2, y, 3/4)',
                          '(-y, -y+1/2, 1/4)', '(-y+1/2, -y, 3/4)',
                          '(y, -y+1/2, 3/4)', '(y+1/2, -y, 1/4)')),
              '48j': (6, ('(0, y, z)', '(1/2, y+1/2, z+1/2)', '(0, -y, z)',
                          '(1/2, -y+1/2, z+1/2)', '(0, y, -z)',
                          '(1/2, y+1/2, -z+1/2)', '(0, -y, -z)',
                          '(1/2, -y+1/2, -z+1/2)', '(z, 0, y)',
                          '(z+1/2, 1/2, y+1/2)', '(z, 0, -y)',
                          '(z+1/2, 1/2, -y+1/2)', '(-z, 0, y)',
                          '(-z+1/2, 1/2, y+1/2)', '(-z, 0, -y)',
                          '(-z+1/2, 1/2, -y+1/2)', '(y, z, 0)',
                          '(y+1/2, z+1/2, 1/2)', '(-y, z, 0)',
                          '(-y+1/2, z+1/2, 1/2)', '(y, -z, 0)',
                          '(y+1/2, -z+1/2, 1/2)', '(-y, -z, 0)',
                          '(-y+1/2, -z+1/2, 1/2)', '(y, 0, -z)',
                          '(y+1/2, 1/2, -z+1/2)', '(-y, 0, -z)',
                          '(-y+1/2, 1/2, -z+1/2)', '(y, 0, z)',
                          '(y+1/2, 1/2, z+1/2)', '(-y, 0, z)',
                          '(-y+1/2, 1/2, z+1/2)', '(0, z, -y)',
                          '(1/2, z+1/2, -y+1/2)', '(0, z, y)',
                          '(1/2, z+1/2, y+1/2)', '(0, -z, -y)',
                          '(1/2, -z+1/2, -y+1/2)', '(0, -z, y)',
                          '(1/2, -z+1/2, y+1/2)', '(z, y, 0)',
                          '(z+1/2, y+1/2, 1/2)', '(z, -y, 0)',
                          '(z+1/2, -y+1/2, 1/2)', '(-z, y, 0)',
                          '(-z+1/2, y+1/2, 1/2)', '(-z, -y, 0)',
                          '(-z+1/2, -y+1/2, 1/2)')),
              '48k': (5, ('(x, x, z)', '(x+1/2, x+1/2, z+1/2)', '(-x, -x, z)',
                          '(-x+1/2, -x+1/2, z+1/2)', '(-x, x, -z)',
                          '(-x+1/2, x+1/2, -z+1/2)', '(x, -x, -z)',
                          '(x+1/2, -x+1/2, -z+1/2)', '(z, x, x)',
                          '(z+1/2, x+1/2, x+1/2)', '(z, -x, -x)',
                          '(z+1/2, -x+1/2, -x+1/2)', '(-z, -x, x)',
                          '(-z+1/2, -x+1/2, x+1/2)', '(-z, x, -x)',
                          '(-z+1/2, x+1/2, -x+1/2)', '(x, z, x)',
                          '(x+1/2, z+1/2, x+1/2)', '(-x, z, -x)',
                          '(-x+1/2, z+1/2, -x+1/2)', '(x, -z, -x)',
                          '(x+1/2, -z+1/2, -x+1/2)', '(-x, -z, x)',
                          '(-x+1/2, -z+1/2, x+1/2)', '(x, x, -z)',
                          '(x+1/2, x+1/2, -z+1/2)', '(-x, -x, -z)',
                          '(-x+1/2, -x+1/2, -z+1/2)', '(x, -x, z)',
                          '(x+1/2, -x+1/2, z+1/2)', '(-x, x, z)',
                          '(-x+1/2, x+1/2, z+1/2)', '(x, z, -x)',
                          '(x+1/2, z+1/2, -x+1/2)', '(-x, z, x)',
                          '(-x+1/2, z+1/2, x+1/2)', '(-x, -z, -x)',
                          '(-x+1/2, -z+1/2, -x+1/2)', '(x, -z, x)',
                          '(x+1/2, -z+1/2, x+1/2)', '(z, x, -x)',
                          '(z+1/2, x+1/2, -x+1/2)', '(z, -x, x)',
                          '(z+1/2, -x+1/2, x+1/2)', '(-z, x, x)',
                          '(-z+1/2, x+1/2, x+1/2)', '(-z, -x, -x)',
                          '(-z+1/2, -x+1/2, -x+1/2)')),
              '96l': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)', '(-x, -y, z)',
                          '(-x+1/2, -y+1/2, z+1/2)', '(-x, y, -z)',
                          '(-x+1/2, y+1/2, -z+1/2)', '(x, -y, -z)',
                          '(x+1/2, -y+1/2, -z+1/2)', '(z, x, y)',
                          '(z+1/2, x+1/2, y+1/2)', '(z, -x, -y)',
                          '(z+1/2, -x+1/2, -y+1/2)', '(-z, -x, y)',
                          '(-z+1/2, -x+1/2, y+1/2)', '(-z, x, -y)',
                          '(-z+1/2, x+1/2, -y+1/2)', '(y, z, x)',
                          '(y+1/2, z+1/2, x+1/2)', '(-y, z, -x)',
                          '(-y+1/2, z+1/2, -x+1/2)', '(y, -z, -x)',
                          '(y+1/2, -z+1/2, -x+1/2)', '(-y, -z, x)',
                          '(-y+1/2, -z+1/2, x+1/2)', '(y, x, -z)',
                          '(y+1/2, x+1/2, -z+1/2)', '(-y, -x, -z)',
                          '(-y+1/2, -x+1/2, -z+1/2)', '(y, -x, z)',
                          '(y+1/2, -x+1/2, z+1/2)', '(-y, x, z)',
                          '(-y+1/2, x+1/2, z+1/2)', '(x, z, -y)',
                          '(x+1/2, z+1/2, -y+1/2)', '(-x, z, y)',
                          '(-x+1/2, z+1/2, y+1/2)', '(-x, -z, -y)',
                          '(-x+1/2, -z+1/2, -y+1/2)', '(x, -z, y)',
                          '(x+1/2, -z+1/2, y+1/2)', '(z, y, -x)',
                          '(z+1/2, y+1/2, -x+1/2)', '(z, -y, x)',
                          '(z+1/2, -y+1/2, x+1/2)', '(-z, y, x)',
                          '(-z+1/2, y+1/2, x+1/2)', '(-z, -y, -x)',
                          '(-z+1/2, -y+1/2, -x+1/2)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x, y, -z)',
                          '(x+1/2, y+1/2, -z+1/2)', '(x, -y, z)',
                          '(x+1/2, -y+1/2, z+1/2)', '(-x, y, z)',
                          '(-x+1/2, y+1/2, z+1/2)', '(-z, -x, -y)',
                          '(-z+1/2, -x+1/2, -y+1/2)', '(-z, x, y)',
                          '(-z+1/2, x+1/2, y+1/2)', '(z, x, -y)',
                          '(z+1/2, x+1/2, -y+1/2)', '(z, -x, y)',
                          '(z+1/2, -x+1/2, y+1/2)', '(-y, -z, -x)',
                          '(-y+1/2, -z+1/2, -x+1/2)', '(y, -z, x)',
                          '(y+1/2, -z+1/2, x+1/2)', '(-y, z, x)',
                          '(-y+1/2, z+1/2, x+1/2)', '(y, z, -x)',
                          '(y+1/2, z+1/2, -x+1/2)', '(-y, -x, z)',
                          '(-y+1/2, -x+1/2, z+1/2)', '(y, x, z)',
                          '(y+1/2, x+1/2, z+1/2)', '(-y, x, -z)',
                          '(-y+1/2, x+1/2, -z+1/2)', '(y, -x, -z)',
                          '(y+1/2, -x+1/2, -z+1/2)', '(-x, -z, y)',
                          '(-x+1/2, -z+1/2, y+1/2)', '(x, -z, -y)',
                          '(x+1/2, -z+1/2, -y+1/2)', '(x, z, y)',
                          '(x+1/2, z+1/2, y+1/2)', '(-x, z, -y)',
                          '(-x+1/2, z+1/2, -y+1/2)', '(-z, -y, x)',
                          '(-z+1/2, -y+1/2, x+1/2)', '(-z, y, -x)',
                          '(-z+1/2, y+1/2, -x+1/2)', '(z, -y, -x)',
                          '(z+1/2, -y+1/2, -x+1/2)', '(z, y, x)',
                          '(z+1/2, y+1/2, x+1/2)'))},
      '230': {'16a': (0, ('(0, 0, 0)', '(1/2, 1/2, 1/2)', '(1/2, 0, 1/2)',
                          '(0, 1/2, 0)', '(0, 1/2, 1/2)', '(1/2, 0, 0)',
                          '(1/2, 1/2, 0)', '(0, 0, 1/2)', '(3/4, 1/4, 1/4)',
                          '(1/4, 3/4, 3/4)', '(3/4, 3/4, 3/4)',
                          '(1/4, 1/4, 1/4)', '(1/4, 1/4, 3/4)',
                          '(3/4, 3/4, 1/4)', '(1/4, 3/4, 1/4)',
                          '(3/4, 1/4, 3/4)')),
              '16b': (0, ('(1/8, 1/8, 1/8)', '(5/8, 5/8, 5/8)',
                          '(3/8, 7/8, 5/8)', '(7/8, 3/8, 1/8)',
                          '(7/8, 5/8, 3/8)', '(3/8, 1/8, 7/8)',
                          '(5/8, 3/8, 7/8)', '(1/8, 7/8, 3/8)',
                          '(7/8, 7/8, 7/8)', '(3/8, 3/8, 3/8)',
                          '(5/8, 1/8, 3/8)', '(1/8, 5/8, 7/8)',
                          '(1/8, 3/8, 5/8)', '(5/8, 7/8, 1/8)',
                          '(3/8, 5/8, 1/8)', '(7/8, 1/8, 5/8)')),
              '24c': (0, ('(1/8, 0, 1/4)', '(5/8, 1/2, 3/4)', '(3/8, 0, 3/4)',
                          '(7/8, 1/2, 1/4)', '(1/4, 1/8, 0)',
                          '(3/4, 5/8, 1/2)', '(3/4, 3/8, 0)',
                          '(1/4, 7/8, 1/2)', '(0, 1/4, 1/8)',
                          '(1/2, 3/4, 5/8)', '(0, 3/4, 3/8)',
                          '(1/2, 1/4, 7/8)', '(7/8, 0, 3/4)',
                          '(3/8, 1/2, 1/4)', '(5/8, 0, 1/4)',
                          '(1/8, 1/2, 3/4)', '(3/4, 7/8, 0)',
                          '(1/4, 3/8, 1/2)', '(1/4, 5/8, 0)',
                          '(3/4, 1/8, 1/2)', '(0, 3/4, 7/8)',
                          '(1/2, 1/4, 3/8)', '(0, 1/4, 5/8)',
                          '(1/2, 3/4, 1/8)')),
              '24d': (0, ('(3/8, 0, 1/4)', '(7/8, 1/2, 3/4)', '(1/8, 0, 3/4)',
                          '(5/8, 1/2, 1/4)', '(1/4, 3/8, 0)',
                          '(3/4, 7/8, 1/2)', '(3/4, 1/8, 0)',
                          '(1/4, 5/8, 1/2)', '(0, 1/4, 3/8)',
                          '(1/2, 3/4, 7/8)', '(0, 3/4, 1/8)',
                          '(1/2, 1/4, 5/8)', '(3/4, 5/8, 0)',
                          '(1/4, 1/8, 1/2)', '(3/4, 3/8, 1/2)',
                          '(1/4, 7/8, 0)', '(1/8, 1/2, 1/4)', '(5/8, 0, 3/4)',
                          '(7/8, 0, 1/4)', '(3/8, 1/2, 3/4)', '(0, 1/4, 7/8)',
                          '(1/2, 3/4, 3/8)', '(1/2, 1/4, 1/8)',
                          '(0, 3/4, 5/8)')),
              '32e': (1, ('(x, x, x)', '(x+1/2, x+1/2, x+1/2)',
                          '(-x+1/2, -x, x+1/2)', '(-x, -x+1/2, x)',
                          '(-x, x+1/2, -x+1/2)', '(-x+1/2, x, -x)',
                          '(x+1/2, -x+1/2, -x)', '(x, -x, -x+1/2)',
                          '(x+3/4, x+1/4, -x+1/4)', '(x+1/4, x+3/4, -x+3/4)',
                          '(-x+3/4, -x+3/4, -x+3/4)',
                          '(-x+1/4, -x+1/4, -x+1/4)',
                          '(x+1/4, -x+1/4, x+3/4)', '(x+3/4, -x+3/4, x+1/4)',
                          '(-x+1/4, x+3/4, x+1/4)', '(-x+3/4, x+1/4, x+3/4)',
                          '(-x, -x, -x)', '(-x+1/2, -x+1/2, -x+1/2)',
                          '(x+1/2, x, -x+1/2)', '(x, x+1/2, -x)',
                          '(x, -x+1/2, x+1/2)', '(x+1/2, -x, x)',
                          '(-x+1/2, x+1/2, x)', '(-x, x, x+1/2)',
                          '(-x+1/4, -x+3/4, x+3/4)',
                          '(-x+3/4, -x+1/4, x+1/4)', '(x+1/4, x+1/4, x+1/4)',
                          '(x+3/4, x+3/4, x+3/4)', '(-x+3/4, x+3/4, -x+1/4)',
                          '(-x+1/4, x+1/4, -x+3/4)',
                          '(x+3/4, -x+1/4, -x+3/4)',
                          '(x+1/4, -x+3/4, -x+1/4)')),
              '48f': (1, ('(x, 0, 1/4)', '(x+1/2, 1/2, 3/4)',
                          '(-x+1/2, 0, 3/4)', '(-x, 1/2, 1/4)', '(1/4, x, 0)',
                          '(3/4, x+1/2, 1/2)', '(3/4, -x+1/2, 0)',
                          '(1/4, -x, 1/2)', '(0, 1/4, x)',
                          '(1/2, 3/4, x+1/2)', '(0, 3/4, -x+1/2)',
                          '(1/2, 1/4, -x)', '(3/4, x+1/4, 0)',
                          '(1/4, x+3/4, 1/2)', '(3/4, -x+3/4, 1/2)',
                          '(1/4, -x+1/4, 0)', '(x+3/4, 1/2, 1/4)',
                          '(x+1/4, 0, 3/4)', '(-x+1/4, 0, 1/4)',
                          '(-x+3/4, 1/2, 3/4)', '(0, 1/4, -x+1/4)',
                          '(1/2, 3/4, -x+3/4)', '(1/2, 1/4, x+3/4)',
                          '(0, 3/4, x+1/4)', '(-x, 0, 3/4)',
                          '(-x+1/2, 1/2, 1/4)', '(x+1/2, 0, 1/4)',
                          '(x, 1/2, 3/4)', '(3/4, -x, 0)',
                          '(1/4, -x+1/2, 1/2)', '(1/4, x+1/2, 0)',
                          '(3/4, x, 1/2)', '(0, 3/4, -x)',
                          '(1/2, 1/4, -x+1/2)', '(0, 1/4, x+1/2)',
                          '(1/2, 3/4, x)', '(1/4, -x+3/4, 0)',
                          '(3/4, -x+1/4, 1/2)', '(1/4, x+1/4, 1/2)',
                          '(3/4, x+3/4, 0)', '(-x+1/4, 1/2, 3/4)',
                          '(-x+3/4, 0, 1/4)', '(x+3/4, 0, 3/4)',
                          '(x+1/4, 1/2, 1/4)', '(0, 3/4, x+3/4)',
                          '(1/2, 1/4, x+1/4)', '(1/2, 3/4, -x+1/4)',
                          '(0, 1/4, -x+3/4)')),
              '48g': (2, ('(1/8, y, -y+1/4)', '(5/8, y+1/2, -y+3/4)',
                          '(3/8, -y, -y+3/4)', '(7/8, -y+1/2, -y+1/4)',
                          '(7/8, y+1/2, y+1/4)', '(3/8, y, y+3/4)',
                          '(5/8, -y+1/2, y+3/4)', '(1/8, -y, y+1/4)',
                          '(-y+1/4, 1/8, y)', '(-y+3/4, 5/8, y+1/2)',
                          '(-y+3/4, 3/8, -y)', '(-y+1/4, 7/8, -y+1/2)',
                          '(y+1/4, 7/8, y+1/2)', '(y+3/4, 3/8, y)',
                          '(y+3/4, 5/8, -y+1/2)', '(y+1/4, 1/8, -y)',
                          '(y, -y+1/4, 1/8)', '(y+1/2, -y+3/4, 5/8)',
                          '(-y, -y+3/4, 3/8)', '(-y+1/2, -y+1/4, 7/8)',
                          '(y+1/2, y+1/4, 7/8)', '(y, y+3/4, 3/8)',
                          '(-y+1/2, y+3/4, 5/8)', '(-y, y+1/4, 1/8)',
                          '(7/8, -y, y+3/4)', '(3/8, -y+1/2, y+1/4)',
                          '(5/8, y, y+1/4)', '(1/8, y+1/2, y+3/4)',
                          '(1/8, -y+1/2, -y+3/4)', '(5/8, -y, -y+1/4)',
                          '(3/8, y+1/2, -y+1/4)', '(7/8, y, -y+3/4)',
                          '(y+3/4, 7/8, -y)', '(y+1/4, 3/8, -y+1/2)',
                          '(y+1/4, 5/8, y)', '(y+3/4, 1/8, y+1/2)',
                          '(-y+3/4, 1/8, -y+1/2)', '(-y+1/4, 5/8, -y)',
                          '(-y+1/4, 3/8, y+1/2)', '(-y+3/4, 7/8, y)',
                          '(-y, y+3/4, 7/8)', '(-y+1/2, y+1/4, 3/8)',
                          '(y, y+1/4, 5/8)', '(y+1/2, y+3/4, 1/8)',
                          '(-y+1/2, -y+3/4, 1/8)', '(-y, -y+1/4, 5/8)',
                          '(y+1/2, -y+1/4, 3/8)', '(y, -y+3/4, 7/8)')),
              '96h': (7, ('(x, y, z)', '(x+1/2, y+1/2, z+1/2)',
                          '(-x+1/2, -y, z+1/2)', '(-x, -y+1/2, z)',
                          '(-x, y+1/2, -z+1/2)', '(-x+1/2, y, -z)',
                          '(x+1/2, -y+1/2, -z)', '(x, -y, -z+1/2)',
                          '(z, x, y)', '(z+1/2, x+1/2, y+1/2)',
                          '(z+1/2, -x+1/2, -y)', '(z, -x, -y+1/2)',
                          '(-z+1/2, -x, y+1/2)', '(-z, -x+1/2, y)',
                          '(-z, x+1/2, -y+1/2)', '(-z+1/2, x, -y)',
                          '(y, z, x)', '(y+1/2, z+1/2, x+1/2)',
                          '(-y, z+1/2, -x+1/2)', '(-y+1/2, z, -x)',
                          '(y+1/2, -z+1/2, -x)', '(y, -z, -x+1/2)',
                          '(-y+1/2, -z, x+1/2)', '(-y, -z+1/2, x)',
                          '(y+3/4, x+1/4, -z+1/4)', '(y+1/4, x+3/4, -z+3/4)',
                          '(-y+3/4, -x+3/4, -z+3/4)',
                          '(-y+1/4, -x+1/4, -z+1/4)',
                          '(y+1/4, -x+1/4, z+3/4)', '(y+3/4, -x+3/4, z+1/4)',
                          '(-y+1/4, x+3/4, z+1/4)', '(-y+3/4, x+1/4, z+3/4)',
                          '(x+3/4, z+1/4, -y+1/4)', '(x+1/4, z+3/4, -y+3/4)',
                          '(-x+1/4, z+3/4, y+1/4)', '(-x+3/4, z+1/4, y+3/4)',
                          '(-x+3/4, -z+3/4, -y+3/4)',
                          '(-x+1/4, -z+1/4, -y+1/4)',
                          '(x+1/4, -z+1/4, y+3/4)', '(x+3/4, -z+3/4, y+1/4)',
                          '(z+3/4, y+1/4, -x+1/4)', '(z+1/4, y+3/4, -x+3/4)',
                          '(z+1/4, -y+1/4, x+3/4)', '(z+3/4, -y+3/4, x+1/4)',
                          '(-z+1/4, y+3/4, x+1/4)', '(-z+3/4, y+1/4, x+3/4)',
                          '(-z+3/4, -y+3/4, -x+3/4)',
                          '(-z+1/4, -y+1/4, -x+1/4)', '(-x, -y, -z)',
                          '(-x+1/2, -y+1/2, -z+1/2)', '(x+1/2, y, -z+1/2)',
                          '(x, y+1/2, -z)', '(x, -y+1/2, z+1/2)',
                          '(x+1/2, -y, z)', '(-x+1/2, y+1/2, z)',
                          '(-x, y, z+1/2)', '(-z, -x, -y)',
                          '(-z+1/2, -x+1/2, -y+1/2)', '(-z+1/2, x+1/2, y)',
                          '(-z, x, y+1/2)', '(z+1/2, x, -y+1/2)',
                          '(z, x+1/2, -y)', '(z, -x+1/2, y+1/2)',
                          '(z+1/2, -x, y)', '(-y, -z, -x)',
                          '(-y+1/2, -z+1/2, -x+1/2)', '(y, -z+1/2, x+1/2)',
                          '(y+1/2, -z, x)', '(-y+1/2, z+1/2, x)',
                          '(-y, z, x+1/2)', '(y+1/2, z, -x+1/2)',
                          '(y, z+1/2, -x)', '(-y+1/4, -x+3/4, z+3/4)',
                          '(-y+3/4, -x+1/4, z+1/4)', '(y+1/4, x+1/4, z+1/4)',
                          '(y+3/4, x+3/4, z+3/4)', '(-y+3/4, x+3/4, -z+1/4)',
                          '(-y+1/4, x+1/4, -z+3/4)',
                          '(y+3/4, -x+1/4, -z+3/4)',
                          '(y+1/4, -x+3/4, -z+1/4)',
                          '(-x+1/4, -z+3/4, y+3/4)',
                          '(-x+3/4, -z+1/4, y+1/4)',
                          '(x+3/4, -z+1/4, -y+3/4)',
                          '(x+1/4, -z+3/4, -y+1/4)', '(x+1/4, z+1/4, y+1/4)',
                          '(x+3/4, z+3/4, y+3/4)', '(-x+3/4, z+3/4, -y+1/4)',
                          '(-x+1/4, z+1/4, -y+3/4)',
                          '(-z+1/4, -y+3/4, x+3/4)',
                          '(-z+3/4, -y+1/4, x+1/4)',
                          '(-z+3/4, y+3/4, -x+1/4)',
                          '(-z+1/4, y+1/4, -x+3/4)',
                          '(z+3/4, -y+1/4, -x+3/4)',
                          '(z+1/4, -y+3/4, -x+1/4)', '(z+1/4, y+1/4, x+1/4)',
                          '(z+3/4, y+3/4, x+3/4)'))},
      }
