############################################################################
# Copyright (c) 2018, Martin Renou, Johan Mabille, Sylvain Corlay and      #
# Wolf Vollprecht, Mariana Meireles                                        #
#                                                                          #
# Distributed under the terms of the BSD 3-Clause License.                 #
#                                                                          #
# The full license is in the file LICENSE, distributed with this software. #
############################################################################

# xeus-sql cmake module
# This module sets the following variables in your project::
#
#   xeus-sql_FOUND - true if xeus-sql found on the system
#   xeus-sql_INCLUDE_DIRS - the directory containing xeus-sql headers
#   xeus-sql_LIBRARY - the library for dynamic linking
#   xeus-sql_STATIC_LIBRARY - the library for static linking


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was xeus-sqlConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR};${CMAKE_MODULE_PATH}")



include(CMakeFindDependencyMacro)
find_dependency(xeus 2.0.0)
find_dependency(xvega )
find_dependency(xvega-bindings )

find_dependency(Soci )
find_dependency(SQLite3)
find_dependency(mysql)
find_dependency(PostgreSQL)

find_dependency(Threads )
find_dependency(tabulate )

if (NOT TARGET xeus-sql)
    include("${CMAKE_CURRENT_LIST_DIR}/xeus-sqlTargets.cmake")

    get_target_property(xeus-sql_INCLUDE_DIR xeus-sql INTERFACE_INCLUDE_DIRECTORIES)
    get_target_property(xeus-sql_LIBRARY xeus-sql LOCATION)

    if (TARGET xeus-sql-static)
        get_target_property(xeus-sql_STATIC_LIBRARY xeus-sql-static LOCATION)
    endif ()
endif ()
