############################################################################
# Copyright (c) 2018, Martin Renou, Johan Mabille, Sylvain Corlay and      #
# Wolf Vollprecht                                                          #
#                                                                          #
# Distributed under the terms of the BSD 3-Clause License.                 #
#                                                                          #
# The full license is in the file LICENSE, distributed with this software. #
############################################################################

# xeus-lua cmake module
# This module sets the following variables in your project::
#
#   xeus-lua_FOUND - true if xeus-lua found on the system
#   xeus-lua_INCLUDE_DIRS - the directory containing xeus-lua headers
#   xeus-lua_LIBRARY - the library for dynamic linking
#   xeus-lua_STATIC_LIBRARY - the library for static linking


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was xeus-luaConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR};${CMAKE_MODULE_PATH}")



include(CMakeFindDependencyMacro)
find_dependency(xtl 0.7.0)
find_dependency(xeus 2.4.0)
find_dependency(cppzmq )
find_dependency(Lua 5.3.4)

if (NOT TARGET xeus-lua AND NOT TARGET xeus-lua-static)
    include("${CMAKE_CURRENT_LIST_DIR}/xeus-luaTargets.cmake")

    if (TARGET xeus-lua AND TARGET xeus-lua-static)
        get_target_property(xeus-lua_INCLUDE_DIR xeus-lua INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(xeus-lua_LIBRARY xeus-lua LOCATION)
        get_target_property(xeus-lua_STATIC_LIBRARY xeus-lua-static LOCATION)
    elseif (TARGET xeus-lua)
        get_target_property(xeus-lua_INCLUDE_DIR xeus-lua INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(xeus-lua_LIBRARY xeus-lua LOCATION)
    elseif (TARGET xeus-lua-static)
        get_target_property(xeus-lua_INCLUDE_DIR xeus-lua-static INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(xeus-lua_STATIC_LIBRARY xeus-lua-static LOCATION)
        set(xeus-lua_LIBRARY ${xeus-lua_STATIC_LIBRARY})
    endif ()
endif ()
