############################################################################
# Copyright (c) 2021, Martin Renou                                         #
#                                                                          #
# Distributed under the terms of the BSD 3-Clause License.                 #
#                                                                          #
# The full license is in the file LICENSE, distributed with this software. #
############################################################################

# xcanvas cmake module
# This module sets the following variables in your project::
#
#   xcanvas_FOUND - true if xcanvas found on the system
#   xcanvas_INCLUDE_DIRS - the directory containing xcanvas headers
#   xcanvas_LIBRARY - the library for dynamic linking


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was xcanvasConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
if(NOT TARGET xcanvas AND NOT TARGET xcanvas-static)
  include("${CMAKE_CURRENT_LIST_DIR}/xcanvasTargets.cmake")

  if (TARGET xcanvas AND TARGET xcanvas-static)
    get_target_property(xcanvas_INCLUDE_DIR xcanvas INTERFACE_INCLUDE_DIRECTORIES)
    get_target_property(xcanvas_LIBRARY xcanvas LOCATION)
    get_target_property(xcanvas_STATIC_LIBRARY xcanvas-static LOCATION)
  elseif (TARGET xcanvas)
    get_target_property(xcanvas_INCLUDE_DIR xcanvas INTERFACE_INCLUDE_DIRECTORIES)
    get_target_property(xcanvas_LIBRARY xcanvas LOCATION)
  elseif (TARGET xcanvas-static)
    get_target_property(xcanvas_INCLUDE_DIR xcanvas-static INTERFACE_INCLUDE_DIRECTORIES)
    get_target_property(xcanvas_STATIC_LIBRARY xcanvas-static LOCATION)
  endif()
endif()
