# encoding: latin-1
# Thomas Nagy, 2005-2018
#
"""
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
"""

import os, sys, inspect

VERSION="2.0.8"
REVISION="17cf8652793d3fa2620ff6eaccc998be"
GIT="x"
INSTALL=''
C1='#/'
C2='#,'
C3='#*'
cwd = os.getcwd()
join = os.path.join


WAF='waf'
def b(x):
	return x
if sys.hexversion>0x300000f:
	WAF='waf3'
	def b(x):
		return x.encode()

def err(m):
	print(('\033[91mError: %s\033[0m' % m))
	sys.exit(1)

def unpack_wafdir(dir, src):
	f = open(src,'rb')
	c = 'corrupt archive (%d)'
	while 1:
		line = f.readline()
		if not line: err('run waf-light from a folder containing waflib')
		if line == b('#==>\n'):
			txt = f.readline()
			if not txt: err(c % 1)
			if f.readline() != b('#<==\n'): err(c % 2)
			break
	if not txt: err(c % 3)
	txt = txt[1:-1].replace(b(C1), b('\n')).replace(b(C2), b('\r')).replace(b(C3), b('\x00'))

	import shutil, tarfile
	try: shutil.rmtree(dir)
	except OSError: pass
	try:
		for x in ('Tools', 'extras'):
			os.makedirs(join(dir, 'waflib', x))
	except OSError:
		err("Cannot unpack waf lib into %s\nMove waf in a writable directory" % dir)

	os.chdir(dir)
	tmp = 't.bz2'
	t = open(tmp,'wb')
	try: t.write(txt)
	finally: t.close()

	try:
		t = tarfile.open(tmp)
	except:
		try:
			os.system('bunzip2 t.bz2')
			t = tarfile.open('t')
			tmp = 't'
		except:
			os.chdir(cwd)
			try: shutil.rmtree(dir)
			except OSError: pass
			err("Waf cannot be unpacked, check that bzip2 support is present")

	try:
		for x in t: t.extract(x)
	finally:
		t.close()

	for x in ('Tools', 'extras'):
		os.chmod(join('waflib',x), 493)

	if sys.hexversion<0x300000f:
		sys.path = [join(dir, 'waflib')] + sys.path
		import fixpy2
		fixpy2.fixdir(dir)

	os.remove(tmp)
	os.chdir(cwd)

	try: dir = unicode(dir, 'mbcs')
	except: pass
	try:
		from ctypes import windll
		windll.kernel32.SetFileAttributesW(dir, 2)
	except:
		pass

def test(dir):
	try:
		os.stat(join(dir, 'waflib'))
		return os.path.abspath(dir)
	except OSError:
		pass

def find_lib():
	src = os.path.abspath(inspect.getfile(inspect.getmodule(err)))
	base, name = os.path.split(src)

	#devs use $WAFDIR
	w=test(os.environ.get('WAFDIR', ''))
	if w: return w

	#waf-light
	if name.endswith('waf-light'):
		w = test(base)
		if w: return w
		err('waf-light requires waflib -> export WAFDIR=/folder')

	dirname = '%s-%s-%s' % (WAF, VERSION, REVISION)
	for i in (INSTALL,'/usr','/usr/local','/opt'):
		w = test(i + '/lib/' + dirname)
		if w: return w

	#waf-local
	dir = join(base, (sys.platform != 'win32' and '.' or '') + dirname)
	w = test(dir)
	if w: return w

	#unpack
	unpack_wafdir(dir, src)
	return dir

wafdir = find_lib()
sys.path.insert(0, wafdir)

if __name__ == '__main__':

	from waflib import Scripting
	Scripting.waf_entry_point(cwd, VERSION, wafdir)

#==>
#BZh91AY&SY#*DŰ 0(b$~#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*};mbmJ8hjQR}0n";RmLvox>׽ݖCۮ^>g{vAGlۭ]#/[OK춺:ht㗎}>a]:zjN۽_^:ֹnk.YsY#*#*@4=#*#*'e}^Ы5sjucd#*;m˷4А2+CMр*T#*K#/)U#**NԪ#/#*@'j:>XmY孒芖XyN׵Vť6kU4+ݹuqs率7M<G=Ft:(#,L#*B֔Sm7wu4)[k.Z"S#,#/!P/cK(Cװt=6Grqv{K&=Z#*EV=X)aS#,gomåx9Oxja7#/wuݳ6N=}۫sg]ݥl{kSg7shm{;T٪V۴;Oastlu[r#,ɽ}w;>o'c;lmSֺx/wz^p#*^;{u^#*(6!$c#,UvM:[瞚h7cgךsu.yj{[ئ79#*r#*#*'Uُ%5훕)4.t}w#,X|v6A_n	ǧϋＳ[xh=P=W]n׮sGoq̸ᏼݼ5'ol]ψxۇ;{}ӷ8j-E#,K#[p;gjzv۴#*WUTU۝y;8ػg[es(Ϲ3{Uƾg_.95z({uCpwn:b8Ӟq@7}O]}#*(>5淯'};#*w`#/Т݃׻ݰ7R՚R{=svj2(nۇT;j]uypywԯ!Y<!>mm*דڳnn#,Vm`uԣ_kNzo];8i#*@#* #*M1bj=M#(ڀzhlM@!&Md4&ASS!dCeP#*#*#*#*#*#*H$DL2iO5M?	d#,yCOSh#*#*4#*#*#*$JH&I#*&L=M@#*#*#*#*#*I@#* 4d4O LLL5Hhh2i$D #*M#*#D14~=&jc#/f4$#*4#*#,#*~%5#$?A?ڠ?POֽ"d13jpmZjr5>QA,AN,ӧz3/r&cO3XݏenIku GwVmIp⠑@R(&]ĳ*/zz[tIwekY^UEw15XB3ީʗUe[LY]Kj̶&V-j5XQI[{Ԑ""H"d@D"#,Ab`-bAdD)A"6BEUJjڦdY(Lٲ)(D̨D	(Ҋmbf(	FJQlF-fɤB#DB%F)PHZX	,XE&Xڈ4kDbZCf2fcFQ&I(#,E-#JZ54KiUj&̓!(mkjJM5fL6"`JEEL6DB$Z6YE$XBIS5,b@dȌ6LF"Y&DH!4%3 FK#E,cؘjEdҔTIȣ(%FLH*#/4Ģ4	Y4h,EL"lk$3b$YL&#jK#*2JM5PRBXDA&#,0)%&ر%ԑ$"қ HDd $,)dMdlbJ6D2$R5Cd#,4Fd1R"I%D$@ѡ	%I,(1RfRE4D֠T$Iddf1dȚ	R%Ff&*#,0A! LH#feYm!1#,"3b,QIRF61djf#)231K#5L"2iLR,iE)BH2FLm!E1e,"()$Ēie&j4fDcfDh`!4F"ƙdI)S"#,&BjĳcVKId#,QTePI"AeƣL%F#,RP(D4$ɊfJaML)f2R%hт#/S4e"F&RLDVR,&%T٢-L1!lFRa%-uU	SlRH0fF1kԙL#,FlQjLRe0 L2ٚ2DadXб)iL&TlhV"T63ŋ"5iJe6VU)JiE))QbZC&U0Z2TEY5FEIFfTXDXX"dmQH%&4-4m1+A[U5*)hdbB%-"$mjmeQE),Q6mS"-Y2ԩeXILƅ5DCJLBADʍ$HX,XAH12!X4&1h3lVLFIcFȆl"+*A"%3%)E$"4-6F,!dLHcQņHj1b101$)Li,D5ـ0&$	JdZ2fjhJI(2)lDRQI,H,QD)bM6e4fRSfVfJɄi,jIj**6kFhRMb(dBfdbTL5&Pe4I&[%2PmSId%1J2VeM#,2hF&)X! Z-Qi0BhidlbAl	+,,eTk%,mchjERA#*TAB#/J&-,i0bّh*Km*tT","-J)KI*lJ"elVh6*R̨1f%cZb-hh$ATD H52D&")#, d#,*4̩DSmIY6ESI5F(mI[)cdcF`-EbIkF2mD6J6)R	LȘ٩-3dlĶ*-V)*Y%h5!FE)Fƶ1mIhYbkEb66iQsI@ѢIQřY#jJزmj4V3Hd&ѫmՒ3R0H4lP$bhƵZK&ښd-V&3#Y%&XT3e@De$ȌFB5[1`->\	`?E\mI'GtN"IVdy'V[LOhL1U-%Q_F\S̢0@$X0\:8RpФrI6?F3D俱?I(R(KąvچblwP86ԶVQ23ՋN؜<)HNHmcnٵIe#&Dr;KDَcDMՄmq#,&9dԋQ=59,˿g5r	BRL3Fe;q̠RRMLM6] cH ǝچorȦTSPZޥ+#,"K#,ܡ)#/Gv-y6<W)*Oe燮+Fe#/,#/EÖJ)+XH%Fٹr#(>;AF40Շq^}NT҅g*k״X#*D]RX.,Zi([t(ͺyhشO5m"ſ7u|}[S+lnvBȘcHox$BXxxft8^ZjteV,KUsIgu<sǞWy/\Ѩ8wb+2Q]HS]OJTjAТE)c.9b_|y?FV&2xoT_WVO﯂3¾@:+L*;Uo#bzMzALYDݗ<O)ZoQ<Kbrj0Ҙ^~\``AU_;`'nnT5,p)!PS2tj#/-le{$3pw10#/HRuiP;襈};E5K*}xVdYe#/;ˬ,j[vMVL4 ڔEcEN(vv>4!+|JDlHB4 X-'3{iX<Cz]M!QW&xڹ=Ɵc6Ȕ~<,ʌ]ץdLb%5pAq3S43xYEKi.km~2d{cQ_[wcu*$kwG\ţd~xƠ[#/,=-#,"jbNGΟצ$ֶ`b >5$D;*Za]7274krW.寝ú#,zTx(PKWZʮx;St)"AN#/(SfZjASX%G4wh-կ)MAvTW.Vؓі#݇ HDל"g{ӧӼ&X}w/Tc]9$ߺ)kG1Q+yj-IIQ3TċY(Rd즚=#,wa$|M2%184Һx(mjrs^k#/Iu8Mυٖ #,nR#,|5cup'D#,P˯ҍmGSCW(>Pz~ޗj3gF밵_,q\:fx8ğ/U)t#,d-XF{7Cg?gLy%a<*LRjI]{i<,<U2\A}>6/FFFpˆV֏]Q%dɹZx6GzVD&R3Vjp"Rߥrdgcڜ2(RQ.fܡ\4TKKE0Du5B_#/:3iW;6F!'en)!qBS&~)/D1x;)w$h<%Ӵ#,kvߜ	L:Mm#ZeCVn֫*#,M=@..5ѹq%6Hcm~\oI",QwҔu	 N>ܸI8$HSorj6V!ʫQQoJ#/uZhhomq!tғVrhVZ]aE.#/⦅u>Iva(j?CTC-(B\q	YTNJv(Krם7}/)Lcrl)E`L_]~/w50أ̠>TU*QH}]WݏQ>zfVsGո$>h˯7\`m 0 1,>nlg(a&/'ٖzCL#/X~7#,F1Ҋ꭮O;0z\lD*__#<%T#xl|DUY}jOQ́GE"߷7L>EbPbȲ4jSь:ۿ]=HaTxX|=XQ#GQ5s5[].Om8s̲#,	DַvLnWcLeɩ7H"7SCɫ¨ꀾ)۵?4dRٻ/s31EE¡RtDAzb<=wdl[7S;YmmTHh5Vmӳ_fAOky]|dzc:Ή֏.*#,;,)rPV&ʌ,q:^(F3,AMXR?ΊuwNb|m}ZTjTv~Z!Huc32"җ؋FǠ˅t\<}֔4:LܛF<\F{ꕳ*ue21/Y>zP*#,ʨ2,Q5+ibuMF#Ra.;h	]H[ܭt#/boH}.?l<=t~_d1(tLD?ddZW{*P5k9􁧯_5$S4v-_efeqG^{{PV`[ռSE38mE.wpDxy<B7Pb*^dUWQ/"Qj@mgsX/dNrmԎ*xBAW;Ȥ|jYWcҾ.x'0Ƶ#,okwsw.$Pό')BXOc*'u]*CrvNԙĠқbQv}T2%FSuXȘ8gi~L<>OۋVq+UQSGS8ȓ0Q%tU=ڥGn>rZi^GB/KO2*2B}ՃV#×:uT9TtO^85%1JZduGHluW.7-Jf;(=y9E^nA>#,&μbZ#/f/kF#/Pmw-JtG!~֬S>mʈpڧ6þdF`Ga-CZč Ң>qNQ"-a38l:Hk5(l'S4]W|h1S!0*ʧE8*th~t?V]6q3ݥRRE*QzY+j_Řk4Acu;>#/T}~K,9Ql6W<H!7XFkK,#/(EћS/)sZsqF/&ufQ~8LE3-#/F,V+?1*]ط@5F5=IL^pNn#/&#,uZ#,6ͪ'	,a[`'k1WεFz&4h3j!?jaE'F~1Mf"1;jX9Tv,	F=Nm|mg-0p55}T?`J?v1(f7@7q*j& <Q9k+lၦ&5$e\P**D7R듮V(Z1[}>8=@5~ߍ>Cۿ'$$P)x0OޯWWD@>NaӪB#*R}h ƹPfPFJ?@#/L49Fe<j>-K_Ty;$񇫧3b |vKBh9<mⲥ1lVgWT$3Yc0k;c#NMZ;mwj8ީѯӝwF2C8t˹yan#,;d8k"DQiF!D<Ŝ[𬨠-]QG!Duf1/#/+٥s-nh{Z4pWdmz%'\ٜ||tӉ"9b-MSnG>LdU\NBNC_u#,x#ՎI˸|Xv_7#,MuZ3Qx~"O-5t.!Rr3U#/H#,v,g97[]*.pZitK^5ߒHk!mFOs+4MRVYf.hSwS	]z4@Fkpߩu;>߬ECgYV:7'A{{dL'6?zZ=tJ1귝k,HPt~BSHxA(j9{b˵mD}􈀕`NYLP*1fik69w'))j#,F9+ZY~.7gKop`Ti.rʔPui6[J\jEy6n^I#*#*8ݯbO/UXE,#Ãj3<wp"uRrqlRVBب|HD(D#/  D`|룷ם;#AMt A3:	T/'ى*h4Iom3]Fx#*%@R8,Yx#,(eG-/o	CLξ/ Gr)^Ts 	כ틀r4s2n#,`z}#/0tKE'{J|VX7X@\i(]sX%\tgKY0-ٳڱ:ԨSMϷ.0<,D7r8L^(_rw'cWzkW\1p~XV蠳.^z~(YZ'0"v~:Rn#/vS ^e#,y9M&tU_[J6!C(#,|f5	ʕO+w(;N^ΰȃz>Zݟͨ}]t6(nv	#/X>:6!yW3_mD(&\$xp	C,&$;fz#/IK\AFPؾ(u^W<C#*_/O8ѢɁNᙴEwZ|G?P؈&P)DHF/U_^41hOd.p23~'<فV; #*@j+?/Ǹ[O;`wfCXpB#,f!3Kp5C~.u@Qaw`7f܈S*(LB?i92#*#/B:Ym_,>~}֒.n,[ސcN=gkM{<8Q*&R]B[7`f8РQV=tanHjO4@0Z郃#*й`^ٳ*+.H#/:rG08Mu6mO(O;q"#*V'6M[ύ#*cHꔹ!LZ:f8oh=w9,ambCmQ`H#<d#,;M5tNQ0nQ6y_SG/uqth:{h+6!Uy9z/7F#,Ȇ9c69mq6ZVgx,c;B$A%-g痏RVs2$+s̄p*K??˻PvuBbЌ11bڸ\_&o`p"K>Hӫ:;#,y4B~].y{͆.K	#*AUp?'(Hj?5Fop"lvy6N3#*Fa6t-{>مFs"ˏI-O)!m3+Di%#,w_~o2,v[};ZHהy>v?ܴ(7)ɚ{>Q+ja_%҇eաw,?F5̺hL3KfrUMj0=m{c_foRBH	奥M3<(TR<gh#/C<knc 9?DYOi{Ѥذ4`ktP@۩9WY#/FZB?TJKy7;iqp+ws~#,XO0\/p\"#,"±3@qڛ)7Zc#*Dw&k{<}!9pk00̢`߫Ӧʷ8ppnr+iOPO6:#,Ӂqblyi|o&k+Gy45OUbLS{VZ+N!⁤0G_<&զ7 C,g첽hDk݋=R &v&$0c˚Vu;ަCk}ˡHF֍1M}7&aaoq?<&xh:EO'buc<jOw~·ï`ygޕ~v9#)&#,NQAmPLASzcg$ARPSf~5뎎Nӏ1*X̉(P*0f9#,l:stiDG3oFm<Abƛ/ZxdJd#/{g90.1ae[EDDqD0D!c`Aƃ<?6#GH_ʘ%zWe\U;c*>¯-#,d'1MjJ1١@V)]<G!֢t+mM_kZfmޣ bFBf&g6ׯVUZ=/"kK[52	#,!RHve,#/Ŵ0Xi$N..FEH毊X0Ib.b_ł1Y#/@ʧĨ&GK3#//	X^ESPZ#,#/):b@I+QR@c3*((Frvhx2h`VJ)B&^vs݄R.@Dpމ7g:;T5?Dd}Je/Dnk&Fe'qtRJ5MFb-eseP<]WF]P3wArz=9KXݢ)HIP=tY^ /`B5p!	C+~5Knt͕uQe6Wz|z(,LyP#*}2Q`>vKUĆ5d>L;2346JB6<KأvѴc'~9نXg^HEeko;Dwk2qi3ޝh)hZqw[ʕ}{#,`e#*#/ac*YUJe0W#/cjhg,H+jkl5ϫ\ɪ8,X\j@6vƟ#/		Xgk\B <)^Gh`fhM[IBoNa,w2`{pn/;ܩ-;ךr:*2-¯)2uAOn.LF#/'4$>i銪DM:Ap#,{ T۫K1@fޠMAmdJ?	H#E]E$tob-\@ Ak'!ezRdDsKZm&Ahq)#<q	3+Vk1KbR4 ܺf#/Ѷ	T2LA\eZJ`@k$B%+J1+` eX4F>-({>]tۨXRACf(<k-zb+~rXF,Km3FL0Yj$Fu!S0*P2@5Zts6 u3XhK*dQ3Ll`Wa`-urr#/c/bv:@tVA#*x0TLz'#,\'e߷ƝӾ}{u@#/UJb{l-	C'/s٦:-v	C;h0"ۙϴ>H#,j4C0A83T[%+hRd-9.5Lt>^ߏumjrL#/]TƁiToF"tv$6|{som!пAxϪU_9#sN#,Bje4DF0:ťf,@O[Jf\py0o)KtQWMG#*A8kNNqW1j?Hp@p}VrIRTJ	,[SgICoX̎߼vQOgl||El{Ƥ#/~-=x{t@z?_TnvVJHMm֖f#/ryC)rmϵ//y9"yaFhm1#,2Ld:S51Ȱi5$f@uqIulZd!)V&Pʄ\A３Pb+J,FQj(#,TGB&4&hcu^F25#Q4H41ZiIva5LBoq|aE5!lח\oQ44wfxp\EVd:Q˚E#/E*x/E/&ȹG#<z`/S(漷txJƢBi*1(Up#W>k}a(8qhM6=DxosBK`vr[yvbOS%,,`SXzE!	},(BHc_l3I[G|rz|;KtҎ1=UmϏk&Vaz0a%CĜŔ`#t_/r:$M	#*POWpyִNO% ؈$	Nn	x]@1d]#Jzc?k|whm31FE%	Fꡋd6tMJtcƲ>NC4/XcyےwҤҝqݴHE[zV)FDɕi"1E#/T1E^_^[qS|2JDcz&µ9xQşC'.	Hp.CY~XO#,<G8q۫Ni奇su\;bt9I泙Rم"ۋA5cDڠsI+ԊZ0sVX\	"5h $5c#Uiك`aKo5'nE3kP&fwO#?=3#/X)Tr1rHPˤPO)A7yv+uyzY];#*_*:k/.4sCis~a#,@uMF~n(pNO]"rlmkt8,Q Թ_~iaz/rONgKenmJY^,"oz#/4v.r.ћdtqx3#*?1Fn[n資WSG%͛޻Ys9=9lσ/x}{gmn\;ͦ8"vjN!g`wISːv奴%w[#*sخyT@:FPAs7{4vJ.QV%ћFjEkJSވ t\?#*.|W9QINUׯm5H@%x{oF7=K~Gީ#,GT>.,5#/-3h"%D͕,J/14iW/Gmڍ:R!j?	O;}G^yv6za~NZ#d83'k2[QJd*1J@H'^ׯ_߳){U#/Cb0|_~U3UɃ(2)# ?`[!4K4@(@fD8IՄ=#/T&WzA^Mj{lESDP'?ͧJfuLnlDhv)M}#,4{TUB	^VL?&3{V|eb?XaIԽ>RpZٝeoVdK5|7?NP:8ӕ:-ϵn&㯜k_$A')01eUN09`_l?J*7msy?R>!(T(`ﴷF`g`$~Rz&#/R^y`ޒl~m!ûa!PjXL0R,Y$HAPӇi/(T=[~zO:#,a|~M<C#@||SzO4i4FV#}ފ&zyK2qc#O@>[×ѿFx~v(MErn)u]YϒŔZ((㫣bZ	,k+a˴r_ۜu~ykh䮆7v=#tȣH&rCcL==ש{7-)Vk7#*l9h7#*bzтC=7^cD(qߪGo8GFɬ7!U`1"rκIΩП>ݨݜ0EzVIOY(^9un A |3:Aә/t8= AF,"ma#*sΘPWvLΡtȢˑtOҩkR #,	#]%2Fc?}.zxt#/Pe?o=똶*ĄǴ$M#/ \{#9#?Q!>	<.ewYژOʏB"kLF4(H&nfT/".&+F*4gZA?u?t#*'/YbsU<n(*2FlTT{iOs=ݳvy?on Chf4p!	C,녓Ih	DDorW/Du#/T>aG9Ezfe}wvao|_O,~Qw?d>QA>I_vim`]<Ƃ=\Y")^Q7׍Ez]>)<<"Zjj%~3c}.#*~/Zokplfll7O?ۙMW!`y<|4_A-x=ϝ%K zw'Iz5/C~>{6H?D0aCme<{'hǪ#,{l!ԣֶWGOc}3z"Q;S;ik^5Hӛf0jC.CjGQnօZu@]X{#*dYfԅvLpP5zYe4r0d-.z	&7ݨKUDVOPs6`˜+o[FRGpiͮrf#Fn;ĉz;uz)=-PØŏ'w':S*cssjR$R*?#,}>^q>V[0.2vxW}no0&qs´0)f)nU}U߮yZe}ui1fԾAk_>m̟<mیu#׀iCэr%ɔ3#{Pj}I(Q"N\[>=Yv'3[/а1@]WT4Iet{z8Mo߷<j=2+|_7~b={u9}pl|!fO˟͌=QqW	#*SV#CߟB8_SANzlҶ}Vn9V??qos, N7GpmP?@EHY{6M./KS?~dY?#,]_HT/-}qlS#,1C#/ts凸~:0:>B'9k}~owvgEͯvߗSԯ#M<.\CkßjBЉz?O]ÓHwuӯkch/#/-=;#,@=?<7 ,Lk@ջoX56yӒn8bzcַx?|o&<U{Ĵ#,SW㷐xa%;XAÌB=U|~{fumA;3W<W!mhɣ+{g_^A~^#ˢ?!b{pv ]&KOG/߅#htQч}ZrtH~L0 LdW՞@s0ENqdOUUfݫKbYrPiڒ}!n2bCd_ec:)ډע57cϷFVc؎#*jP)R":HWt*ϟ!mȌXKE2):FZԛy'o'z?XXptx<n/4^d7:iDWO!ޫ͎t#,5xF6lc(䬾VSZļL{^n]_z:dzcqAC1Npkj	ib	xKF	?1bV5TI~`tϣ!vK#,uE\WGQGvs&CxI(tIj	#*B5`gJ6<8i"~I#/3e w#*AU޸}cv^-9ۤ=<PԶEw73XuN198:`ŁuQR=IG'fEڵfӢ-ٮ|2sTnmӻL[g&L,7/ٛ#,ǩs{nܩkoL8jmL<bq+Y*$wB<Iw>c!>uu+;솟eFPgAk|=$l>z.dSHXff ^IX>Hۂ:ie:]4w'-G)3%2F¶%ePr##/~<TcFJbpDx&(mAUZPqTEݩk=3֤On`a-AaFd<#/AM#,#,`S8ej#,+/q8,7NbmdI׮j`ll#atXjQ2')啠gmX7ޓ^KDZ]NNLA3AhBø01!$iub{LCnNgVь$tt#5hZM.bPJLݨ"4ӑ	IkI:Pnsy5#MYonY5~D~Osdo͍/C'F,,`'9ڭ]YqgxU8{+O%e[/?o4LHw;	Gy`DCN"o4VU&겷'9-2bQ$3?P{~>}=go@!A~ǗFe6{5W4=Ip\'_ssuvj^+dIjqsrNkC#,m?sa1ͿeV6ϒ<8mHO1l@L/|_h['uE#qbqP>Eāc-4V)թ"TuRr\Q< =hso<ٔ&AAR`1(¤B.9dQ&Q\hIn(-p#,zh8>Uj4clQ!l[ld :IaHƻrHsQ	X;BfM1mU⑝6FGEBxmh M3#*C.7:]0Q"E"]$"-*q=j#cd@xB34ƢrF(3*®eF8묔c'PΏ*[0mHVɢɐ0Wh92#*z]Y*s:;&TV/nu=1~:FD~\z4^_@z;->/Y"OT?"?]~Ѫ(&rryF	xlNbTw,Bw<3]A{XCh|##lDE)^뺼=yiwCy;~o'F~Bs_Dq.gz"fs#,(_-V68&.eҠIfUUk{}0H-	<B>#ļ!&Hzt[RtHDѾ"-_c=J%!gdGfmڇ$Ef-K<m½8q,\r0"2NcFV$b=qET$$ڤldq![#*DY&E# E,*/eY?oc><OCd	#*H`g\Xz$be_'639y	&`cKwSX.FaEe !=HcZajdkkOr0kCL2Ы1;^v"4p\2ӄ@8Q()9R3ՈOHn{`FȺ#DsVƪ+6:muDɩ:dLRb+G+C4&%L#*p5l N\	lNe`v\Q{LVҥL&Sᢜp#,zwyuо^z%>N|#xw#/Vno~ݏ#/p	oMx|\!>5Aoǋ1&^l̦0	Y<Ap#h7ӁV^٧ᘊy@AĲףO.^Sг=@C\Y6aiUSҪ6`ӌw=سP܏0W>:X*K*EuH2$U-r7K]#*ޥD0NzCFz;ŵ눣iXhDTtlRlDEGGn#,iWJT"9'n]5C#/\"C!t]Ww/>8Ӡ]6јG;aV0E<2+f_Gt~i4.+ATcP}xL	bAP8M&BbM`=0^VXW*-e(R	:8w1cʪ)m8rRaIY9G8֤aqh4&!QIrZaǅ+#*hhe Lꆋ/.l4f#,pKE٣$:txF]&Dd( ᦑ ,LKbV4iODD{qdaXSu±w9N-nج#,B#ȭmc2ѕ^x{4kO|LэØy@#,{/@p?a|Va^&;|H$@&aU$	C'D$Cئ6Ans;W0UHuFAb3Dz}Nk"y1Ͷ1D@xmɹ"+\cmV0Ld"mj's`1c[ѯrmEuxv$بԼd(1ٓbJHQm)XU{jܵuI>ll`XR	a1f;Ģ2lf3mBaIqNeF3P{XѾқ63\ѐwc:ӱ`D?qda[DQQ6vg#,+GAF7E#,ڏ)3G4* 	`ZİM'&/x</!*Fҵy05ݩu#,-͸|#Ŏ*Y2]IFj|>/#`0sapqчffmeFҔ[žqlֺW*#%ӆ!Dx#gaYs)j:;#/ѩd+		\Amn1fAX	Pk2mF=XX;B'F)j9LS(ijk1Ttى3NYsЩIBMfRklİ-,'PƎH84t$8M00>j9}㕍io;3l9㫂wtJ~+ؤg7XcBOj6=cF"2UF1Ji+DNDcLOۮ6~E0|Db%"wNqS[lI5QMOFFa&4Sn8-aixeVH6B8!e`s.gJE{fڨ"F	bgM2doZt巖po1˯i~;}XWw4C?0ibc#/quuZ[N	`=sV~5#_F#,biRʵb2&~Lsb:ͤL')k:Mh|aJM(|#	ǥ-a%[	tW#8~˥^u#,G>ompʈ.Lic=}NO3(XVP<1W¢0TXuxvדo˳vKyYָyXV٦ZUJ#/]OdRjَvmKREyWo9TnUfo{>9vN5MTGt(lA{ o>F\^t=~_O_M{}=#*SO6|@BiU_QrcI]忁*pWR6ܽx(򃇎<9&@/H#/J'5=m5-;w+[gvc>=л>戽jap$#`X2_ zq}s	d.8BXyN_	xF]x8wҀbBr!Asd	,	N￼haUd0kb*#/5\{P=w#/[h,IE%jËC#*Wz!㕽-iiQp;Ty.B̜pS#*9\m{NuAq;cVe`??s\KJ˲NS _5xK5٭8(B4&&6NzBYlRU%eːL?AihU#,t<mQA{qǋwèThx/0&#,bYNQ&wFV??yowlJB$*d2P6"*'ģfX>L߫ն,.$W#/9#,s/1iJ$D	Aj"Zx#,=yi;,G[:NivQDB$ ;$Y{CGmLjAfGfqam;;	џIη~n7I?oB7bWu9j<jif#Ym:j^iu\fxF5^xi>>W63_xZBLӰ1skBpKmݫM2q̖>~;XdPCp.|J#*KމyP	.Cs>3b8sM?-l()4cbxf-0%~Mh<N#2ǿn:؅zDXOnfeLcE7ģ<As4W=(aӭ0BıP1C[YE;"#,!Xakn:8>#,&#.SU"P.hwUO;:7Z|ט0=̡ɝΞ(}ko0LuGY>2<$	{6ަk[Ɗ^φ^i:dyWESd,Ff+:%0mry~oX(D1A``H=U9;'fٜg3*[Ӷ?N'LE9=~2/&|sYk*+}o<Sl^;z<%`b]ĺ9lA*q]/s,FͺV w]`A+%sp5WMZa2ӵ)*t+}fi*W5j&חΰ<NVfw(V$t]2V\fu!J{Fe̸Vt<":gPpiz%%(RS<p@Y#*ЉضթÝn=j߶#,y;O%1B:ϔ3V^!6wx}UOݠI!OϮ-!rrP3ݺ%Z.,ObhZEyZprF*%mNx>|SjGnwwAMIc<ּ6KtϋoqǙm&@׃;Z/QFwgo672a')KY>{TqKj#,V$ϞNkBӹj7wҏfNbO)׏j"<IowW;f+U9"Sws[^S[t8:1j-$xxO*F|ͱ%pQg@G"3]7wd>Ͽ0茶U#"N'<Pڌf|fNԭci#.͗PsxdyڽȡGd8L7F*B@=/#,4M(BZ##/(owk`nB	a+inK7h}* I9TD)D$&7DIܡb'q۰X#,("j)xga:UdY؂"t0S'	B*\Ιϼ|6x3Si0*{phO,qy2cKFaq-ʰ~HgGȹDh#*bGZpg#@j'~o#iKT򵯬#/A@^:NZkYNp9#,=$55f)N*崢}U}zM)齥f3fܥuqaD-{7F.XYlpWrEA֩v,#/W*"wZ.b_`Hsxd뛓cQF_\4Nx;Ⲃ&U>8sʹq6:vEw*3h?]hUe`u%?oR]UX8YcX|lw/FЪ[,ׇj0YH`*vs>߭V\k]a%Bz<?Qؐ@)yWn|z"m	H8/qX3hwk#K&,#/hvNAcUQ+]y8I^$Ų3zT<cw#/t蘗+q;ud_zxsa2sϜԬ.HyjXѥٳ*rtCxx}U˶cě#/ZWh_%6g]gGюgJQu|SMBRw}#4;{t2n\Ukס<XJ˦9u@~ϹQj?Suf,KJ5qnAW\e'/):b4~"bENkQh/2eu.l#,B!+ȹTDFD5j]''w{1aqpSd9s58.km;jh:5̼/\pKE);a?eK?%Qo'h1ǫGM#`|vs{(ׅ&MnYN"R8#,|{{gS⤵t@xG:tzFFݷ-rdE_mx<_>؇CO7Z;o #**s߂IPXJo#SX	NM`s9Kd]2.ѐN#/oRB`n{ͅ4֯h7..U	+圵X=lg,ü<tk~5ݥcJ>Mi`㧕:j_Wx;d?gmYQW@#/߅#,:d,¨Z3՛eb'lsA#q22t	]1$FPQFx-eH{dj`QGpF-f啃#*µcdi*w:揰;)څ"$xZ-˫f7dlwN_Qj^0\FSsi-A bg58	%Pmoj]vw-\)Et:f(>{V9Y#/SM1sgL(c_!r b9Ary<_HX]V>v[2dp/ѿCn5Lǁ"#,.߯d/3|wPRɱ,;,钿6p>8aVua:=%:U{x73L5}BVeQv;iX/vjszjPuyP92`bMYbS5!˃OJ`VVWE;z8h^C;-ߒ`/}~cOG/j>R9˒jUIj/Ш$R?Mijf<.|L_?ضHx$k4^Ae_+(G3"G(i˝zS(붭=˝Sqp%9/S3sGt?=Ҹߛ\\bU-{K5)c<yS}cRfp?g#/_L%Q?n2/K81)ɳ^6鈷#/Wk[oQ{h-nj25ԣWtK#/GLF<ja"SR齟]`6=\5RMJޝx(WǩV|K޼O=^v/#%F)l`56!; 4*F}WYsu[H~.9ynro":c.a[9[}ن/"rp[V(u7 ;'G#fT,Z^6SUXˈX[w)&R_V<X4~h.n`1RZ_5c6i+̓a[k}ʣHAǞBJ"#/B ܫFc#4L9lWd/&z#,$pPDhgv)j^%R+K3.tq_9YeĽ\*@.K3zzAohwcUTQ1Vu^2͆	s0A/",a6EL}g'BpDѨҗQ^tlaWMK^uaVڢX)-8rכfKS*X#,#/e:2;ʝ6w~<V_hDMؠS~6e-5(PaP#/_glT?v#*:k_=/5JfaVM3FtrVugXRLOf6^H!A_?m*Yttj]]KmL9;!(53ᵸ>3pK+,	cT۱'؉AB4ة~'90R8zϊ]>aej6<T~gA옲a#/z6ݧg5IJ+rg6̤J#sS}D5%s-~~=-&7a0k2t&Otx|i^pqv}ת,08dפl*;NŃ)Mskyx{^]V7دJRKMn\yjP<Q4Ԇْ"N!u4#:n3U-(/,"nP4ӡ$o9\:49+#/ 2실D;yꮋ<#/#/2Qu@o{9G8Uyn`GswA)#QTxޢ<EvB<(ДthX|V(p9JIlf)(`b6VQLmΗ#,9mxG؈$զdTZO;p|j惴=6IQxOMc+n92q|dv.s.K<Z᩟djUWr%׌Fho-HF]*<?#/%eGi}zURG8ؒ۷1)3mx\<oX#,<J	:Ä#/Pr%pNAwIg|HJcO8#/,c<NKkh$En3@]d!'ɨHL𕺟N1*o:gU>ampUvh"PRO@Lr@s7ǧh#/퉼GA/ly9#/.$RߌM~hK#QS!*7v lv<fS$#_O>y.ʆmՓJH}VGun3rYx6as|kGɄkXY	$	֢`GȨקL4dB.TCQpޒ,mαTQn9峐#ǈ$ht8>jlFɇxM;1YtܿJ'^o\\3&^WߜΞ;n 8y=:wrWR!ڒǛvvXAE* E֠#/qސA/KoF:#*|N q_n)ͯ^Z<f@;#*ADzpo#/6yҧa`V}ښ:$Є85KK_གྷNH>N2#*x¾SȩQ!&ϖȽ]XP6:<}g#,!qXrl=,A^E}]#/:#/;'=ëCfr'Ԏ7kS);hj,zSZ9-|rE~#/fly_|nTJ2wmK|ztGoʗg1)+5<ֹA$l\̚F%htg(f}P{	)E#,v+E@٣`A܅|Vs!u1徾P;aǧsнxpP8)z xIZn?T*5>ՙ_}5g/4Dr**yUR#,iP!MM%=jHdd$T(hlN&DKDBjZ_{i(,xb	ɦf8$"A``j@j/^gimJ̝2_*#,y`~f6&#/WT19}@}>NQA$	_aP~݌3 p$#+a6*?ʦ#/ɤ$*e{mgͪ&տiQt^_>{u;V{#/[L>N,*@*/oռjUu(7#9x02}8K6c6MR&oBSZi_388ʠ0	?>ÀHGg&DЩ*!#,K\QP1 S蝜j3Q0:z@UVei76r߳g%bīN#,шr#}Y{ӟ勌8#/?^<6hRGN1@p!xpyjܹG`'`<PzвH7#,z9w@/@P@sq|L|@b>*!5"u5* '](f2CGiNdS,Ұ͔u#r LtR#2QeUu[RX>h=4e#*fvP'qc!/qƌG:Uz0Eycd6y3],@{o_nAGZpvI\$u;P%޺7arٍEJ4G8:eHa>)]{Q4IY:'#*뀩=I{ߕ5^eAʸߌ=wXGhAm G dR#*vQp.qCXp`8n#Wdgӊz+ADc^Z3!zcNsc^O)dcU5/֗=n`nQDUp-Ed$ULc#/H{:c%Z꩓፷L nƃlӦb'wP6!jbu#,{@&#,%cY'^CxCCw0YShQv;uj.H(Pfyg!ZQVxgR"ѱ#/6;("@N.r^{CC,هW+P(#/ar)$g.7Ԝ(x{a}vxwCa3=.DS(	~_%#,&myH*]ˡ'4(쮚C? sOAan0a	ieYTGeW^}Mj\᭓8LIߧ1y*vN^ dE3)X\nǠ&ݑS!jx?ZM9$ۊ~y@xAٜ4M5!KoxN_{ɞܓ,O#*yr+(kyc7H2Dx=gg-FWݽ5yZNhh	n-\i6oY/0:!&[ն<!98>Lf#6HCTRAoN(O5zna137Oۯ)n(>5Xg䷷4y;j;hζ+t_qnxpj}f;DIϔ`GrH;PBz#/$YG]舉#,<fv3jroQ>jX݉t%.u'j6ǅ9;`$eݓ3@g:ISۧ۷h8v{`GT<EܮPءab7HbLf4ñֈ7 '$ 74PZl,nXP9n]lK\gkn%q֧#9$9>5ȂSp6p@e_vAuTtta#/^imʇr/Z|Yl:a+2^Ww,+Tq\u(T/>NaKPH,1 텛&YU?7Γ֗N X5B2/{;	jʹ?5UcRE>ԨFqu[:ǃ3P[ڿQo'%k|	HE9ı~q"(y QqN.Hv7P0tYz秆){C=#,A2kPpjZ߱ l໯Д98A=r3"zzj2YIÿrgo9h62%Ng8ݴ~>	\#c{	i=k{FrP`\MbG:RBpc={qq%~o(kup$Uj/'dLx|Yz<)=|g}UɈ7SWU7-gl֣3?\3ڗgY(uYp;*)O1s̜T8dަAM93g\ӯhפZT;2Kn=yηXEb#ca0#*Nw*`#i	 Pq2#x(^kp.Pz\,_Mi3#{ͺWsLuvȐm9]%bJŤc#/KN9#/gLa7^#,rgq}⢍[#*#/-A|Ҕ鬀D+->)Cg9#/GЈGt#,ЦrehIORTE%Ўg*Ճ8Iť+vߩ;v<KT"/kSL#*mˮ/T?i$c!	^>_e&~TT蠟'ȇWp}>Ax)ϳ,TURT-|QE9>cz#3~Tیp~6e\^j1I8FeSQ7#/rц!x/#,)Aw8!L@׎	$)DQ!)F&HyX;sD,9O8L읐O<#/f/!@+d>EQ4CǏHH5a$w?ul2Y7HzLafc'_g?]CA<rYϨq-8E#:<^&ha6Uۥ#*(:[?ɐ0ܡoWɉr)GJAΩGnNQ28h,=7EF_eg}?\8=e0'~Ag??_O~o_?m?=~o_Os??¯;?]w_PO_O?dP+ Mqk++6daO|rOLMpH~h9Ae9Bhd#/D܈Phw8}MP#}m҅Y@EuSt#,@X#/`5@GO+tRX̂pu\u(ݲ%\37X_01#,MRXwb,K%LfAjXQ%@}A$O3O͚IJ>MN^xelhp>3ruމt0b&W̆d#,U>ߥD*e7DD$DBn(s^ZBWz~&=Aͳdh9	7ߛ{`]<	)DCۼ}Û#K``1Ђm	DgJ)!N)ߌ]"}4{T2ʿ{O%a,LfǁW&<DUb12ĕFS4nmXԓ&߹v`{ayM#,)==2U.c?^`V.V3ud!3mCɞ/Z=E4>ofY/xwHC !˟U?ۯ{K")lZS%1cygEUT%ENY#,qr^ӝ=f #,lNl#,LY&!CIyչiZ/TUKRe&Two<uAHEy(&|mkع89.KG!U6As7uYw$@0!h1#/%hH(<$GZE͗ul=e"m}yw;U;wqټa'KDugpsH$<w#!d$"p"N#8+>*DX&#*'&w>r@bjTSnZͬ[Xmcm|fJ[kr06+#*,'왈6JMΊMU)(QĹ5wPǺ%#,:j^32tnE{,ߞ#E-FNO3=N\#*bz-k_K3pZ\x3||Y'D0UhhHS$yn!ȼ񒙫SƁcŸy'ȉ|ZAKftWlT4Y!*[5I6XBVz1QO}|3SģZ⨂Qmh&Sk{mkXU*J#*΅<}(idOTE*^;0VMy(v2X0񂋈2Nazvxsc=J2$u:SX~pۧ-3yN}VLYDתiCTZ&#*n9Όk8'ޓxĒAi#/y<XuOHWq9TZtt~~=t4uɢ$U)*|4A9̌y2`!x>:i _aY3?cEb},?22?FСJQ\kj]Kz\u٪I,At.c<bQo}S	V|kj=]&U9<|uZ[%F=)PP3hOSTb9ނ, )m43Q3DӡtY@(Cc@3K}µ0T&P'|1ٗd&BeeaaX#/m]>m(,&9l2TS#/̖#*hE}9f}TlX213J.ٹ#ʍGaSx=XӹtsDzu\2pitonlyL弢cJ(8ǆS0AB(NivWNwIdDjWYF)|ݮ)*u#/_6ylX^=xD48-ӈ u=5B6:C>CEFjCT(ן>圐 H#,)W6w[ͶGJ((ɌλBz;JzbvuJCzJι-\$1I %6c(>+ƶCr'Q[s՞1E)AA,#g\gItNÉ9}I>kXs/]zw혮Nr}^P:-u9.Cn#*`3˷berG͆uЪGgQ\pkW#e|>گ=M;%Mv`t-@(\CH#/=U#/~%ݔ1iAEN+u0QZZ sH&4s'7bݾ/<Ujtt$R#(L/K=ԪsMK=pF>[,#%#,}b|6M;>[-El1L`L.#,2LPU3SB^DfRyq?YN|UEg#*7p$~FŹ*^yN!]#,С5M1g#_Dfz#,kq~F	8#/9@T@a<R)'&_It#,4a9#,n!b-&u^-h=7jMZ> DHٚ7f}}~'[;J9mvxa;*ȽY6ó}jd>jj'lކӪJ;7C<AJ6yU~Cu7aCb#*pbJa,Pآ9y#,z4bJpZRc.#9%?MJ~Nˉy=l4zv6wlƊHe/EXl{UdafPlzoKR'j`#*=אn/uy&_5i{}TJ*<`cQ]þb膠Ty4BفpI붤ж^d;	(o	g˽1#,]su>2a)|9a'DiVzni8GUf9zfnDHlPNj	އ^oX3{PIɅ !ç?{pfNbq0)wB)w0V2[5uo_TrJvm(&>a3_Bxݘ2ye#G-"#?~w=Z/%d.Y91"tXeE{];`@WA ecdK(%@3/jpFYI}Zsx]2,7cJs	Gƪ#/R#,;3&pDe^(&1fq$h/*O'VK;64X9UE(#/@D"$P]Oͱ-%_sʟXs蟡RJ}$tԞ]Vy9uY{/@n&z#Q9}(!m]	L:M$/O5{~T;"#*;kupI*'9Ouzs3Bx"#*V%ā˷꛰:]06ai%b|V*E9QlG!.#,?ce>s=.M=Hl{As:{g=XæsRR,"iO_=Pwx<M+厫I#*9}/+3_iu4a4C~i)c=TPJ}p釕*Ձ"JH1:vjaY>98:>w6]ow%͙p@;zOŬ2x:BWj4t<?`a_|ӣ01:d]誵u[n#/eS:'Mf3Fۻ(Z"͹s3<3md#/SԀ}#*~:s[~9|ĀA$F_C<e-ȠW|>iW)ˏ'`Y9U\ʺ4:#*\u!)'Kn;G_#/`O-m1z<%Z#/{CTevFD wI(~wQ0DKDUt'Ƞ>7Wk%*Bu°W wҠmin#/g.oe{DAQi ~`ZQ}z$=͵Ft;wվ(AxIB(Nw+Dph6]@YfrZ#,#*1BZQF:'uTq=[. K<3O	a HV߇Mr4ŖgWs>hx01ݪ'?t၁O,+İ0)$ea~Q5Y!@X,E"b_ݰJ%2l{>ފF¯Lfv}mm^wfbptCq٭Zr7r"!Tcʉ#*?J#*1\C^|;9A;/bZ=k5?#,#/jl4%{vJRk`D	HAT𓝅GGMx#*Aפ//ƣtuӺrB @\t3g)۪٥۟lJhbY>"Cfr	]~([g\Y/Oi|#/DRsGpB09O[ǜ`k=2sB~?^rQ5g9'+	4̪]#F0LyV]JYC64جw&<$qx9!O#/EGwoq0DE<3UUDck]S*&[zc&[!%e.INW}Nk9~3*%	L8׀-5K^zlhuA_%Sw6q-B/LI-.}&E\ee:8@<Gr#,3佷Y.kwԆ6rzGuKKr[l־^I.b%9Ut* Fa+U0!$ߒ6V|Z5>4#/^Þ^ghq+t~BzV_L:L'19ecf{Lf8%wG/`o=&.R%]1#/XWQ{볖&V|MY|$pgk&j2)he6dvF4#6w47WVjpMB2f_ht<}Wܨʏ  9#1vC*;e1s?*}iw:3X'o1'87?S5SNQG^³:1PW(XKW`,#/s6{YD.fEC	D	I$37IKhjD{fA+*̠a;=uJZ6{#,*`ti,tcmACxmO4F)>:p9w>a͝#7_hMe'b;V(Q#/F9E=m/!G(>Inogc|':ee߫D\͈zwo!|kHE,A	O4+#,Y:LNc:Å	мuWk/ן:~9.Nyá#/->;i?_䣦l&8C4b:8׉NaaQ~f!|6fUur C1ԠANTd^s,zԷHǾ-#*×4Нk#*G;U=`E1kqd70]׾#,X*1#,cf2o(Y64k/sҾȺrN~~;{yM&X 8lNZ.yϻ	_Sd|pt|,'l7+\:v/O}͟:\w"-?[vw\#,шl,.vm7n0F1:8L^hM h#/b<"!A3RSkiqAfSZY̥,[Y8Zy1餶}Z]=2CuUjڦdZ߶0ŉ}3'bHߘS;1Abs:zD(z.dP:&De5.]\ǩ$6}'mGB7QBB[Y{yf.!ԅs;u7N_;@݁=~5eyrIIHh?DfD).-`5=糆!KxwY1˶#/#/3v8TGĪ{^?#b;3a/,	Z^%F^R꿣K{t$xs}DUtv3jO Axr[sI#/督o?<^ǟ]G}#/َQv	L)I!<ץI8G~n{zd@Q#,v-ĶJgʝ읰q+^}^~L*F1{+AK*ղ_֍aa}aJNIїv#Ώc9+|P3,a5d-%h1tRH[Ig"nrt2WFU,j(#/UÅܤ}X'366vSd0@ٴ; '##r46#*TXRnGWI4Ѝ3"_C@swPgoeQ=Pz|rߕQhR6]	P"\"1,W|+3Y3c36-PPс	橠ܾ<xAMy2ɍ΅#*A7ϣ9=<-Ԯp!b#pUp_!\)շ{[#/w#?x{|z`"{>?&ӐQW<wx'Me*ǡIH,Xt^RQ/XX#/uڴd~guRZXgMbj؎>Zj!9G'LoRB T?#/S)_e<1ΚGXٴ|NT~%Hyn\^|IGpqјh $ߤsiD^5VS#,xcOODA/Ở#,d,@b1#hʆ0oޅ8a"?R?W\vh#*K dFh/L	x>pYq,(IOo=Ybn|jP#/|#!(9ʌHd=<+l$ ~觟vF%r0&X`"qX+u7f (GBwיz-z#z|ʉ:bc	S	4h ?lP_ C#/@X˖Ĩ(v42=糂kNg.,ʐy^eZ)_Z>]XʆD;{1#TӋ̒l,tgg2jbO o&#/S-:J&]#,k߻+/u3Iݓ0ΨȲYp+{oK%k^Sgn]ߔ`᜛3.pXlkWŪn[mW3]Ԟ#g0v8<E?t>٤ǝZ4#,'tQ賙Uw0e2|66bVX|\h:jȀ&H#/)k(a.1#/Lo4JX-P;?L6҈xxuT4W-$=+ͣhP=(5etJ8_k/(;+)Uq_-U3:__C#Mzgѷpq䚔AV@Vy*M}ѺCv#,$@I8t^~O0ؿwQ%i91};OOEms?u#v:]5|(g=V5rw鵱e~9P*'d#/H1zzAxR n~ĕÝɹr~6;~dS8gKa4=S"Iuq+TGn{:N](1'2[u 0f.<8SG~e5鄎:_K@)tXfy0]U<aϯ½kvAq2K@jZf\#Z2~ȉ|	(.3|Az҃BD=jAע-ij}bUmavֳwۂ׉yKupΝ|(j'r?H#/<๬Pl=r2JuwB]J*^$i2JWD/s{ߊI^0beEnuѵqR]K-C|b^4cN%Q aK]LP|nbsq4nGިTjsM+xJ-~^#,ل6M8}ᳰtAJ*m?O/GY&wleXp,dC>8܉wҨ[,RHeJ0QWT|Rz9"ҹVXF}_~7/-^'o.;@>0oCoӳrOX;m̳Bn:se8[9#8q	RD?BmP4G?sQh#/iNqaRΘ!WMlLh̩.w+Qz5gM7O#/K[q@  yf$-#,6Sȱj{ON~n1P-E\= ^49LaѬPOJ%)Sk\VA)#/9+A0A<<7mT|4+guL,U_>@4=t;$.{/n~GGk^qsᰍtx i0@y;Q- 1Vj;+gqgb$<EF{fl`{l!8kR@Ñ6 g[4Ewi#/@^KCӓ#]E#8]EQc$PT.]}RQ[~y;:#,a=N;=ؿs2I͋U)|'NpDĲF=Q[QSdP<	f(h3Ґxie5xasIb0͈eW2JrvG`w=SprǍ"kݤ_ZY$lN֩q1ACkݹCJdb0)\ms#x a|'=$@_+䂶Y]66,	oZLxtܠa&tm=KBa6I|aG^/I'o#/bhc"[KV+QNp̂{EO{NoK5M(箈>smG-7dPy4@&4W(rKPTkx̗8CΫe4n#l	Gtƻ)U',/iqrǕ>|g+v#*&4zDW/흂{@f	2JF%L`Zjb#/#/ϟMGnŰUGG`j#*]TWtSprOJ7:Pѿ:slH$NαiǑJwjnJ+ĉ>wqvE7^#*d 59m((mD|G K]rf`@tFO2/R-uH7/S4!HOݛ(9[cA*d":[R xTNbܫp]p9s$Ki	=X(6mkbq91ot62n>?jk'#qYTM>u}͗dMG)iSkͳ.(._ptC83R(F]ۈ1\|Ncـp(卩Zmʶlȷ@N6jՍ5XJ0j}zῨYducxz:`s7E/#,Ƌ/NP".@0ǹ$Lw#*"#,/Fj1=Jp	N#*#/r	ql(3"ޥ))fu}c-bCW80/)'}&#*旸ots+(\\	M_o՜^G2],0!#,>*Hg=ϳ8<|OF]jX>T,(Q8djhk?Y3Z-À䭩sg#*>gٹxj09Ӛѣe:/?uN	:b2nOQYez#/?!@IeC#?}}vZs88žpPY*Bs(BOڇ}ㅾ>ߠP	6`մ4qUB?KeدgӸ^!d˒2#,iTS60;ugc?znwhXm}ַV#,#*GAe˭_WNxQ3CasnғyX*8*j2`l6PKStAy9@=&:FSо߸֢:C#֎-AERȾ"v	X#/GFsnhf062o>ؿwOXSو]A|G<'~:!P#,W]풮O/H^u^ib腻`@l/Y=Cd_Sɺ #*R	Q9G8G\>>>9묖ũ$hv/	MZ{_9	ZɒZH,ap ͧjn)|jZvv,/C`xk7Wv#,ڨf!f	Kx`fFA`?6k#/'$CxZ	41h	wI)?)#,zJw2~hyU͠z{>nGW{tm	h&ױTs:^#/60v*ANXAHga5wZRY {}d`E:KQf՜ȽGHW8qlFЫ;!ܓ`#/d<ҽج]?xT{#,Vxy=<#* m3#,	4Y}Sa$UGkS #,ˬdD()Sի|aςs]ȆjR@?lx'a%+ʯ}=#,o쭻(|>dl\G\;#,&)b~A#Le(@3DD6!dh<`D@GC=MYs><K#*Rⴙj4>#/?<TU0Pu\{&uL2͉4,zr]&2sG>)eH6,Y-#/%$IY%n{1p#/lGpeL=XCqul#/|ufNl#/,8C[!#O愝fx?wm;gx	K}aenob#5QZy8}x*Am8ϱ78_&6!ӳ΃ŉ?}`LYGikd$ %"/z)x&vw:}駌p` d%'ֶ#,*Jb!5\49s!T,!!Ɇ8)#&CAF@k|g=?__yE#,2+ӭMXD!#,KS}!C3To.	Y"~4lXR!L'Lge7薂\9fSM&ơLV18H娠50ǘ333R-6x܉;lf؇>MHJ`R!?Wv`aP#zff]L1h$G2s_}c,bwO+nOɞX"J~˥ZYtMIݲD%.b7;2Z]7=i=A cX#x,e",܎I$TiRb]jjKK[m<\Ֆf=2]C$TLX;dzuc@*mv/aѷ}_vc"UUpꇯ%($'^Vi?&GDbj|}ϋQx¯WqtсB(cvU@<Ƞm	#*o>}Zipa#*-?AFNږM`E	4{p0dԇ#QfAړD*1d$A$m4N7XM%q̫U#/H 5(QkĴAGgOک5_-2of\|癪)"~NM/YL'3XZś'='vd$X_;ݩMrKL(+TB_vvߋ>{`1o_}w4p3@$.f&٭|p\i-Wlv{JZQ&@o8C	(i`R@0bR!K:2??u;۝߬mc,}+rWX@O5%KFA;Fmf0/ p$j$C#*YX>0+2"9@8}|/?TWޠV#w@au:|gj׵%:ASV W6zKnE?x>/O;NrtH-hع7XQ|ړn t}ms9n|τ8B,cN@w~;!R@6x'ޡ<#*#ޣ@;$(?xyX"DNU<Ë#*N[BV<#*;J6!Ž8,Q;u@2(Dzq|~#,O4@^@uhj*W_QŗQD}IOyiYDOX~1=Zny~/GīAe5S5BC*`#*9 tehBh6,)'آvG`ycow_{wg1ݞ}i;[mb,Y{scކW4f!rxh'y}^6e0]'j#,3 N=W:1OwK{N@u,Oxk,Pv~㓙s qԼ%nDF9(ɹgA.*mUM(q*蘑)iQ9lkP|?{^W&m-R2pݺibQbX#m`s{	+fzgNNftR1`$PB-SL|>'e!~C1!,UIV`y<zðN'DEGk<? 2Q{>_vP3*گַ ~-4hrOB	(W6U48REYٰK$n3jUuR#,2~~^~z)#*5a~ܛ[_B'D|d#,L0QSD6{#/(rX`v>_IͨCj$#/ũS8`}"Cu5* (8vR'0]s=S[,;D#,y|@0)n㾡p|c\Xy#/E3%hl#*cm~G8ߕ^$!}#,#OރFV.oP7(ĸS9j#*#,ZP!DP|5k1Qd\$"^ʒyI#G(@溅3?.B(o ð>G#/4cc#Dfazb$N`@)$SPٱ<CN훍jhl#/>[,T""wWj6K`#kSܿ$H#ՕW~QumBֵST6B bS2+w_%ҹEZCeBb#/e]y\,Sh w#,=W_zqPe9ӸPPo_`_BZg7F݉#*4auM#*ҡ%($daD#*PBL!:@C0HBEo<UDO1';+ÓBJ<qΞ!o֋/147pNE$\ t#*a!Ke0JͥVs=	띶o܅v3am!P&GYGoBZ|aw\z\zmG咤u\DyDl=!|[XӌclTMp*#,2aioRR*$17L۫ZX .),&a(RPkԠ?YÑr@B=tt#9哐ϯW2 UٱH&T(X?@>ga*KHMٷZ<$"4%wv$?<2z|=?<gfz\)!WXx#,#,H1AIg=ha[@U0T饊dZCCSC17#,`KH~4@%̏L쇦S\ JEQ3)Ώ{VD~Bl}I*I>s-a-H H*jD\?1TOa#/|:/5JX,H~#,#,Ћ	y m\]9n6qq{Co2 ;>oq8M5+9dP::{8B!pVA¦ ku<bKT{C uET>F*n§ngoG9i/w?;	\?֡oO:g_'H}X*eYA@okVHT)bC|hPiĄDg=!C#/y	F쿪9eGhϞux.G5}Ա2aBg;pZZ0>Xo#,ӷ~qzsUZ>M܉(;A^mQMiu<	^;ziipD p[g+Lհ 5CJ:NfHąЦ8*oRzn'	C:;rK80H%VEU-{Ä:R0ik#,x#/O4W35,뿊:?624('	;P+\@_~&&C^l|upC(g#5F~1Z? =>cp`Vwzsv6<#/@T*[X(-cZ,kCe}#*j30l햇uqg#*8p0*}kg\k%c,#*=Sځ#/$I<( ]H+.jЀIa^Qf;}Xj`N"*ߙho6;&%` s#0U~6`ED`id ni2Ba@H5GnYGo7Ȫ>?i}x{W1jWEK̟崭A'u61zU7d	Gl`RB٦?ɡhe /T>ya`c#*"H^]o;uvW5PO~>8+ R9q	<.fq;FY2__rԘ:2KC!JJNl!)+>\-^監P$O+w]vC移mAf8'|C0i#*ɭ}ދ8@wC?GHTv;IFpI"ߑٸIҋmCQR2uݕ;wUZfF*8@@?V?F)^XX@4h]`m#,xy1u/]Jf-j$?9W/#/@aDGߙ4?|(Zb5n΀	s!0,pK0q>b#*L6#*^	bW{0uWCbea#/z-.>G)yʯuSYWj9:_i9u>~dt4>}Ņ#/_vQRxT=.*AXNʔQ:_gCظ"["G#*zݟg5]!vikkY}h	!7='usڻXr0 #,#*YT{plΙd<~0/CQԹ]|UHqnTn?$W[}^juu265wH\%\eR/04v#/1hD·XLGRf;[\T.#/:5q26]6K;vf|8"BَAЋF%DB[&4՜q3~˙j\`A$]D#/U-T@e\30Y/*)׶ra!#,l	iyF#/ pTqdJ6fsjr'Z0>Tcs#>2J%["#/Юﾗ/$2X>.v;oF	#*N#/޶`Vo:Mf3fG(D!~+OsYl"gw%@)C!`?#3,eXw|lXD2@Ơ"^z!Tj2Dy^"!yG-ÙfF[@nWfw'h9&WkƩt2Hw8y;0|E:o#*s[?17D$˗t{ב6ɾIwt(tGIg1kyѱ/6n;ś`}wb7#,k~T52&(s0X%xqPf|̊_+Ѷf.)dEĥTM0#*AcA!W6'"mUw_Oa.ځ;!뷨P4Bx"sށ #AF{p^pg^?{x&ix3>t3~u]*/T9U_ܸx>`<GJ<5^vd{hL#/q6_= [hݬ%s(UrGdƁQ!0Bn^>.77x*Ë.:C&y&76F6m/;Ma+4Y<EAI9:{ZyN&K*?[CD}zm<zԻ0x}6vݻC汗K6rK?z'WU!4td1K2_ƷX2؂kyLLHMQ8RN&7M/ABfT4+APkKÄ(Ŏ]Ԙ|;6S/glL[?en'-Jl^uL#M+{_xn	=q8P.{vH(ob;}>=wQnUT .gMq|ȡvr498qe^:s؇UD&AkjJki5wUlIL*|V*QaAw;Ҷoѵp rt@P _>^OGV~		21$={UC:MUlvB,jp|d"G[}W,;/*%&Uz.umsyspFz͙ZvKO.p 81NyaFqC	csxoztq\,	~ yJy#/%HAix.337Fǆ!GgQm#*uJΟW؝]<o~{V!x_xb2;<mb3/3P=e3Aσ~AsoИu7L]P>z&;P$6|/C8\r;}[lNV|,dAR3[ȶ=ssl-j_#,>K+_ƊL=Mkd0vE`/{mi3!l!!6VOO]{]<1pݷ[fh1.>;zdo}XE{}sq.ұH.g<#/qRRY0R!Oz+58U1hHTa#ÔF y*Cb֙&#1pp90 HDQ*?s,%\Oi)R9EFP#/Ckz+ )#/Л#/ܸM/kf"s?	ӤcI~B"~C w1a7mIVD#,AXكOgW>~΂+ԁ$KVs'hAc%t29f@vٹ9@wm#,8KO-f#"1ׂE$;#,lUM5vf#*#/3<zh#,̀5q.--*Zn*0{(;6foH +<W#,(IOZS"S@gY#,L@H T;PHݻUMnq3F~J[9aeL$D(9?jH;,ќtОe	\:U[~85$l8CYORDN,u~\Äz2bA8b&	AH#/Q3k@Eɲ;Fu3AfXWy'(Ԓp f#/.G@BUIajl8|JoByBP}:-4zI#/uN\[SB0or|訳6{;60F%C<e4.$8iEldmR2*H46<jwۥuҮ]q&ȼwk3Ah{ayXiuW?:C#/}P;F"ݷg6@9" =[@6#Xfǩ_@}:SUUEb"<nv\lO;pCEѱ525$fM↸WUR^G.Iwgd)wKqj@oGwvp`(Ѳ{hqO(F[wA'Ln-9$FpI-A"p`p ǟ>o6ߎuu}I<#*fk%0c`;wmYPZ_y.h+TzDq	2"XGRwˤ`g1?Sru!;mff!wq5NI$HW&ͅV0)Sə-DaIמ=!߲="} G((aMַ8	MMś,u	$r[,HmA6pȅ٢Sil5@[ݷ09jSw5#/a2&+{0G2n@Fy ީ[',!]#*O*6w}ڌK2YX:0Ѕ6>o;Ј>ᮇMsw+F#*og1JIQ#xO`7!	fLm۸&mGieQB b֦fٕ-2R@,76񎠍<'ACGP߬-dfqî<*r\c'Arr(UUtg.V6< #*	̿']˙c#,4/MHl5iAxOri=37Wٷ/f#=!w2C'94:bۑx$8dܷ\(1PUu:ÆFihWBI9h"*Nd"=fd'iÆQ2x])ALΐa:MǙB*XD>d%tx3SiMoIT2t0}w\6}P.ʰ7\.sJ$"(5d#,ux	c#/WKoTݥʀ7xĄ&Ō%2]R9ȔXͥ0eiшpo#/3|(yOF'G#2T))$5ĝ=Kk,9#*`1^f\y.ffeʳ,̒Uٞ(~~vmzohlAa!ѻj6Jo:"X5OI+͝؋Ass3*9t!	muQ>j(fwn&AdL!#,Ls;sZ00TN"zkfd44NWhc	TP ೮c#,]n{HԢ#Pb,%/m#ٶX.CHUMD5NI2FXJv?!d:QV'=HIʪu`~<θ?ޫ5!BPw[ÉUFDzM	p#/qïʵz\zxr{8h'];Aq"נ#(٭Ď閷ls{D[!0QmΆґ [S~SgZ[@\ᬋCDB׭m,r,aq6?ُ'&%QD^Ü	3'[U'܋8#*7p3qLǖMUhY ):(*Y8;!	`X_R:UI#v{%e@v69xpZ!('tЫMZgot󥢩hI DWB8gP՘(љKEԡ"iH0AjDrQ$cޏ`1Ι_LC4YTu;=K%ÂlE!#/D<R &qFPC(`cMbk8q[&ᨧCg>#/&*4&њLiZ\|q*0CK_^tc/T#,TAk);5^q-l#,˾b2"EQdHb3F'ip>1áъÛ<^l=JO뒺Fu=g^ǴΎ2.k&FcbVu;Hq)U4yFTaq~&C;zh_e-rUHDKzw!PlͽHX;OY<m+_L/9q`-K01@@ܕ1qeY$-n%A<OҍargŕH,$S䚄Ĩ.*8bƘP}G֙c(w=#ӯ(ϖ]k<Cޯ\/(Ci$~@Dtf3>wާޙ/KCӻx#,Y7﷿=h=i({|_k~>UVbQE#l	ڞ(Q5B|(j@p*B@#Vbவ'=t,_*}?ejMZ,D$	~{V.(f(e 4#*%!@eI>#*<g'#`*HZ̚Hno$F0 B#*ƛI(#*4htu}0@gQY.,#,fD.BBJZ#/IG*~#BШ(7'+yOfJ4OҪ&dO$I;#/""Z01P!V@HOƏ"z	?JHI0ʉmHR(!Ct3#*!j10A 6yئ@=Z3&,m"0ZYt`"#,}GyJʏkXr͐AsQ|΂+uT#/`Q^~6@"3:XQLO%3 5M7V{ nd	GV٥xr?Q[p#/1Qa6;"	#*:!@A!)"rpͶEj+ktD`oˋ@	'[oX"'RkD63em^)؝j0i1	IGTyL1xEJI#WZLJF5"r$mˮ\x.WLs\RDИHLkAm;DI#/ M#/u4#ndk~F[5t<UAc8#,y=~prU-m#/K,iàt/ӘxM;bGO?8UDO#,xymo;s&`t&{2ьk-Vh#T*A8.@c idr3"('gϨKd0_*U;يf?~\;?	p<Qx4#,[t#/25ܔ$T@&!(aCHZn{XR\l`"bD2끰v-60+У/ |@2EunxTrҒ݉?Ox#/>wl	%.v}˹#,n(/xo;݆C ?ÆW3OgYfчmix΄j<Ua9yfp삎aT|AC0Cj#I|zu-PJ: ArDz#/4#,hj"H1+RtHgb$Nc&/5#/66)R('41R$6b-oͫ#/Y%1*#-@M-X.)J~He>FƵJ[$-cI6hfbiji*&TiLV5j8'8'(qڢy	 dAPy@D#/zB9% Z7=VWAXh\QᡱUAdc/Cy'!#/)s &04#Sm!kVXU/j`oM:Wʦ憒#*0G,@W,02Lx{ꋼPz"r*;E<#*ۦ𗪢+!F&c=0 a~1<Pj&R0@JShh#/D^#*uCHEo5sXĕFsnV)#/Zff`TجsF?{TY)RgE#,2#/$ #ܢe_:pLowʑڪ̜7-ABzސyWE<|~xI(#* $t]_>w7U#*<9T!NH#*KdcS9mZM+~OmRϣ|՚le[{YCƐ:Y3x$s~c쯫" S>}<,-~7{(!/uw(!oIӜI'肮l@M͚8{D3~BT4Փ4.R^h|BfA%O'%1@|2mdX(&R]'Ŷ:w"HԠϬՊٔCQC;0ju=_~slQa:D0<q]G@y>;obFy4ǻkʼt⁦Ԡzьц=§<PRs7NA#/Q6لҐqBk97B8x6q֜i #/Rz 9훻5g`$2C?AKm.9؁P"2 0t|Y;j`#,Ԏ }2WvRZ#/VrӚ5)*׬Y(	yqʸw]QtkCoϼwH!!QIT!"H$"/O_hDP+4	;<St#{gl[!I]Zc𚾖@ T><,f(7:X=VpP́ .@Ә8I?2,e@#vrn۾0Gb1bQUa@d|+B6.bzqSxz~-)u{ce4םN8'#/1#{Ѭ=`[韛Mv̞qێߎ\s8ffM	WG;r랱'}K3puVi{:*Qaݺ_au\eKao)lҷ:j4j3/ljm>;QX).{T/>t;ONeBBZNLoݩ^|#/94{19yؙ#,1CT^ǮӜEYB{|aO/PQIWp7ZӢGqb|[#/k>{"gqdȞg{ٶbm4#/zo)a"Ϭf_ff9s'+9's,˩GFf\o'YB,5#*t=vt|w#*lݺA'5,IG5vК;л\+kHgdDcl3nlP:;69Ng$͠!pUM6DC}784OdFf+%M	b{P&r ac@5<+ئD%*8=丐"evd.xc[9z?{&)eQ<bj9sKUHGo#,{ZzM|eNJgGa=SR6ȏ6ׁ"N;IS4t&E=N[52#m6=wDdRv^jp$df=?W،nHtK;Zijm[Yk].X;rhD0D_*F)$L+#4QV8hd!,["8I3Ypِet#,#@&8L+Pc"$̻~|@s("	rGRQd=S_OAL)餛0#,Kb0	AB KT#/(g|2_`OOjw#* 	S)FI0MD?<=eCpXu[)pT(T3:1s g.XhVԎͷ|EZi @Z*	j%opXv#,4iOB}x:k̡#kw=j3ݮ#"ӑ@&D2#*(H%aI[E2#@TԶ3#/TEav	6U5"GbEdrʏ6{B&iddLn1]#*GWq5&ZZcœ^|1_ث@dHtg&_&y˹;gk-c˧dlHFBC	4/z<R`wnvL٘h+F|z5r(#*#/!R,UůRf`vqq*,PUue6b(:,zuL#+QwM,}_B$̚Fk6@}D%#,9?ؔsS]`h#,!]>|Sgvj;e)G*P}]˜#Ґlx\}eOپm$\2u)z!xp|yjQPM5EA	]e<BB1f&CҐ2a2mlXX)rAn@d#,uM	t°,hxD8+DCYHj	2w+s,؀Vbkh'Ѽb2t0#/!\L440H\YikDpq/\ܱؐxkBX!KD2+o[jaKK=-qr}ߝ(JӲ*z[(`#,]7#,RQ#T*	ksm2n8>雺+|g1`ybCMbyĒĖKf>8붎#/?6LrMBLoȄP;Hؐ#/k{=%Ϲh9Y1.Y1]VӗSbT=ǲH$Pi6(UJ$sh;2wh}eYOuoP=ꨤ6Td3Nyח4NO=-oz-WuI-u9ںs(H06*T40F0dF뻾DĐ>w	'7ގvqY$yĲ޳*BPP1Gŷ6*3!cE1ц<-11!%xaVYZMH)5BO{~$\& e!7u%q֩<q	:!c?}Q17Xr6k(ӌTN4}8FcEr$(/άѰrBU3vQǠ'9H^`0;;5{ܚ1N2Xɽ؍i*`a6ކ4ET&q4gtl APڟ֎QU$8~z-[#,@q`^#,mLGb!;Qh6b56Li#,AAxiM,l[#**J=WN5i<y{xl,W#/eT(S14!3O4%i#,o{mIb*$gH&,ڧ6vḵl$%N9E3j˖G-c+65;"x#,UE#,ko-bܕMl-]JᶯxofJG%ą*:~rCAՅin'ma6he]hiQQ#,h-MFf,t/x$3nHvg#,t2VpC$OPhdB%4x`hɣ@Qf[urQ[/n2J9zDmd½.Yk=sEdg0ά,Ot1HCgBQNyrDDPHl	.pH4C685&bS@,)7~eCф%!")P6KD$G\)l6fIj$r88p3owc7/6C#0&ڢYEr9t&]C&)ti$o>COM#/˘:i>g0c\5381ҡ̜֎iz7ڥ2ѩl;"iR('}+%{`!_.X50[oۜ%(7){`!-n<>Cb)#/2'<6ϻJHT@F&$5M`B#cfJ{[[t0鵚MJ)s, #,I0#*aU0_&#,栭y<,#W`$x͖c7weE	6εZM4~H3nTXL9"1x~WӸI\2Ǹfeeb{1<`(Oj	! xQj-rQbQ[QVQصej#/(2(A!CB>}vi0"=R &X+<QŬ?Ԗms$4"	L)jIE)4TZ~RfTM*PM2%#/+M2ZJ2[,̘dȣB*,M(GuE#/K05A2hZTQD)Qc+LSljBe%2)QiVF44wANij_V&f	z?K+UWf59"?1Af:V=&XhvC`bou?YlPՍ,?H`#jw`2e1(/۵&\9Zn\C:#croSSĄ7ǚ{'$V[\GA6cFTAJ鷿Z}cXJ26VJ"m"b#"{ykfbbGM~#,5q_IW4v֚R%i-?	DQ`\7^x! 1?!Hˉ'֟F$<=G2%ڡ<]?8=)?(i$y䡼@>Nz[y+}t#hE)U*DSE&+$Pȣ*#/tyx2UWLcn[qX5,CwQxSBLAٙf[ȤRKm6Nb3]l襫jpU84cg}Vl!5Pӊ#/o=\mL9B#,ē_bƍWɭb2%6te~K>tޘ[[4k.l%<Ts9o	)Z楳AW)Z'|^kc6E#,3=m hRetFBj2rs3/xe&}iցs(#/~Td9<n@-"umo׭']AcZ'vxZ)S\agZ^GEH_6~>g2'BH331h~~HY;K[8lͨ1#j16iCw8;;GFE#*3p$3(K9֙5i!:9=>M븇?~Q^HXD2"*Vy_R͙{)UX`}ё<kR1o1DAF+#,fci7y\f,nMVs2425r554gFE5(Ը"E,.[isɘQ[EK9kXoZRj_HF!C~Z&8jĹ fx^o%qU3t"!J)BfhI/*XhzF?8T-ō8?[/Rghђ5fɷXkZ%ơA"~j	Blk8vj4FL<$!eb}>Wg}3I~l |'m j`}g%#jsґ4A}Ѳ##/iR'9P	4s&kia''S0Jlxmn8u`B-p9϶ֵ<"'h{pZpqMą+*BmK.oyƨ+M/zNm3wy)Mwx'fTdGco&舁鳗<a̲Dﾬo|XgBӺ6Osa#M[Ή!?kI:Oxd٭Fs;^G#3ׇumZ#it7k;xV|stzVJ{v>1xXbP~*cg =*JBdia	B8ki5F1(|QA͚%)L݂RJAMqd#*֫$Kc\uQ"*9j}5+ffqY=u2RVn"u[Y2HB,bMdW*w$౨wbmiL5aB\9hNԶ#*p>$H(Lu&Dɷ !Edck&<ܢ]#o.p\5NKMzɵQ3SpPWzAgNN\8Z"dYf֢f\.B72#,)!Se)f,X&MwWǼ5)ՏzEk1)PI(B2lZgnYf,GmCˈW̬,]r<}Qoz7eӟKm7kRj~~0xָs757/r͒r繌4^#,VWZ$G=]L(x1L̡LNj_7B|þG0O.ZaR,n0<|7]\q3·p#ǌ+iQRU\Ad*#,-fqW$MGWZmXPqcnnf_C(WG12p8MMՃF9$:-<AX3rS[+wN3X:Ve1[<6\LRkT/|;YV#q@(MB桺$;uNlE9e<S3=ZqZInK#/+w:P[C|&!BM#,>sj^#,69#*ML`i44C*7e${mlJZ0ޘf鍞֟zY-ݪCõ:Zy pzD$xQ;6m#,N$ey?#,4MqvM.b*Yڙ=* #L;Am,{8FhMF-y16rD#,#tЫNu:>pAxE٫GS%al%T$Y̱Ji9K7ec05aL8`mU\l\3	&XlY2dFL14*ҍs#bo^opF=-ZMPȅsZf):Vsaig&.##,la0d5e3FX#tDQMjҳXBxS\}|v;)Zo8h\"g*aTlc8z̹v!(pCd16bm:&gX7e\vɇ	Ct8rmB\9گX٘9|Ζsc´dg4C#a@A'Ѵ=>vd+gA/&/GP!]!	WSM%#3F@K"h0$#,m.TۆlsC2]9Ft 8[Y4s8x%KgTF@#Ca4TF%A)pS1s4&މ#,juHM$S6ދeʱ4k#Tgh6&>R]ؚ`sQ\iK`v74h8(B#(!ы.fnbcBb$C-AVhfks l2u	TD;Ոe)Q7&~GbÓ&r8h9DÈlPF&#*CYFzd#Hf7tD337aoS:Bp@<0j̄ؠp81L͆HSs5m[CX2'RɅRR:*I^$	4!.beK:a(1l4A8i,7Ω`V0Q?A)UOմ)≠;x#,*mAJT#,v{j?_z7Wʿݮ!`}#L1`GS"#/*!!V(꥝3^޽ ʄu OvZ1tXD:yChUI>#,>Z7>Zl9'ϧ;S˴FZ7-&gR7-9||iuCXGnѺʛyR!C$3#/s'vy6ΈB5kPM9\YjR<t%W)$CY`#*vƎ-2͵dJ#*Ȼ7T!`:!~H	Хjd.˔aH(t'2Cn@gbbCJUUR5̹`͒MS	tP>Y DR~Q#*]#,p?6#*@9!P	qꡐ@*aGS{h+1.93.3j-w9?Cmpבn|=39-4D7R#K HmFrc?NKH7+ZXX5.	I"\o$|rքh>&`kA*Cb@"JJ>?[_}$űbUhL63LDHAFA)DvZ'̛2Z{-ا.IdBCsȧ*T`;jk2<^%z׍c\ܢ"Y(36Cdd<odZd<]Պ~QhpiaԠ#,4I*-"!r#,d-GJ8UƖ:ZyhHI$`L2aXLb/Ɩ̥V@l@EMS(`%5MqeDGq]CD~í-l)UU-10y'n왇KWU#*hha	,;H֩KD+])H&(cq,T|1	bOMD4\fV5!B$4B:f9x_0@<'0QIDYR!f!Q.5Iuq"$~]P3@DCCK1l?{T%3+i'El8RF#,h?_.E[7.Fd'#/##	qe[KԂ#/N#(6[[f-W%5tDhE7h7e;e#,l5554CT_ӸI8CWfuS1)cd5bCJZ+xb]N蜻#/8eoAQtRCp;v$wgFb 9E$P-/P6º4ki.o.6&kƍ`s%ݱl{!SfgjޘА.P@@aGD#/."cqd('a0ĨQ4IQ@DQBIBX8E0c=@jf``V#,ʄxk>O_Q +ٓ>rqHP0zVA@%}c ?D>#/fcD+{dQ_7۽10#!/1&w]ܻ^5VQ[%i_jVZ4l0~`=Rw{=K$\9kXSxzO֊_^++WqwEl-Euz[-*JPדxN+e2iZiJf-etiMn#/cRײEt6ZE)ypȮ) mI̹ɕi7Uܑ$SNO9F#,7"z ð&4ζRщPH3pq]&&'N]vöu848d;s&ݑ}#hha2W:=l3 qPAToYΕRdV[p2P)R9lS5i'сsa(05./8[neR۲HM$n}¦#ic"IHvaKhR#,yFܶӭT4cg\*AJv30:ĩ[D%JyN4`{fuk]eJm2ܙcNzwwuy<y/X,FBPr(0FDF<vn]$VoyW6&Å(ѳRTmF$eclmHZVk3Mifj[Tj-P`S(T@Y$`2DNп)؂}p,j&6eBr	A*&shR,*vA@db/#z`g!\~`Pf=|8NqP_@O,#fְjZ=5᥍](HhlfJ0J6ӖiQ.o2Se@b%EePHU+ F!`@fPFV$xAkl&E393ΠȂR	B̀mpKCC .$Z5C^=Xlw0 q#,LeݳaI{EAEjUZ7G+^F_;leN5',#,@h&Gk}އæ.+#99|m5.!bv!#/&&ZOY1f4*MAw~԰" "|WC}}FFO@U4`&eF_J"Zƭ;ڭKӲU?/R۵uU3$6YKr&+y[\m5Y6QM2̩LVP)D<WIمM#LIQZf(EDY]MF7ӴY\cELE5m(RjKXi*yLb׻$UIj$խ֕&U$yؕMf6edΫT1hEfyם*[S&jyCvͯ<um	&Vmd	!p]4T51Ọm`MXC}+B+WXEw4d4t{/ksKAtNh_Wmm	OtKM2kF)5ROwm0T*(	5mWJ#//7kR DY+}(`iIa{L5檢ɶٱMISIDjRjmfKZSIJ(a2VmhRQJ4ҒXm*6RDԙQX4eQM"Y6K&kRTTJ)1d1dRZ-fJ%&-JJIJjͱQdLmE,Lړ$-mK5&)&-ړjZuJZk$SY#,%b5g@"" gAKQ$P ֣UKj5Z(Wy=Ÿ~&+D%n{2ݛTyLkkR{)v5E<R`: N0vTDyD	@>?ӌ'T$1ga~]Vκų@f	Glt4RJA)]%})kv)~F/=C+H%`<3$ib_N=_#/Ap~/ת:Ma	ːRv#*W,()9G#r!/?O>߂bE1S!%Jw>}ԺVV6=.yg Сu6_es+ؓڛ]t?g͗?Bq1&p*/y\SRʷPZμћ0C&G#/m)>C[J:]Ա>G3}TS]!l+ĈU%B):bIJ,H yw#*l[cVW5w]W!8P+T#,dNt#/>,%Sת|`\$0j'0EC8HS"qvm*Lswٍm#,~f:fz@]7=v#,?kcκR22Ǹ5A#*2OAva&'`Ud邐bC(E>xԦC"d?ٖVu)ZR@F^bh֘"j0+A#,I5\X6i:#,0RX#,)F#3S(/d*Z)Lݡ""A+̴y#/[DEJt2`jH¦?UBkFU&#eРWTcP$~"r2T"CVлK8>{4 r49{FRV9NOsH0H%zl)WӡTy¹@#,T94nk;Ʊ#/y#,IZwG.6+h"C@'Y]b68|Vup1^5.#,3w}S0%miuoB_-I:3Cta9kM)#/M6`V͑P2B0V~7y7Ƈz7`#2V>xk~OzQ!#bv 1!?:02t؍~c2u]u5	؂	`,?QrM[}.@N~ڔ6BХ0c!DEe&hj%Y#,#,IPrdʂ4|&pp}p}o!8Mvj[	%!Ì%gxQȷcӉ0e#/NG1YvӉ4e>z=f$|AQA=5*TYB	@mF^5X+򇸰"#*@i b:`t{UrM:LQZ*iTAV|*w{U#9f\Grǚpu.i%DGW#Q8,-Po2#n;fɃmDN #*lrա;+a!4AwP@2cIg!GfAC^T4k#,ufCܜ]{d뢕xFCchO3}59ݞBO1=td8v"sdd)ZbT%)E!VkЫ&v"!Dl#*g#/4*˅?2i"Z;5@6< )H64B PKoу뾹Քoq֜2݌{Tid$hzӺt8t\  W{^*-ﺓ{%Zf`ERYýww\\alK4h<gM@nH #,g#,kቲEƼocԋF`E"xq8a#/zYݫ]KQt!`][8~Zv#*#,HYX(#/RRl#,J;}iޚ(8mg%T	 ^sdzC+ڨ'_HCX=Dmq]E$b'ck,0YiHMH#/SY|<O5h>>TeJ4omZܼw6&bBw+ի֮Uc^-^UwxݸJ##McM4#/%XT	_Ul."_iu7wvh󙏧tC#*1	 /|`_K5N滺I)+~y7#/Hf&M|^~캳T#,3H#/RD65[Xh&Pm*i4Ԯ.jrcIdX-F򪹌lF[_QUz^#/EH1TH@!	Q*1F	~82ώ4fq!#/)R$[c:mO9/p.$,3AcPL	C#^~zvX #%`7ݗ)%#,J/r֭)C\EEKDJa)	:q*ªzU@I0ːŃCڃc׾},Y*6j4ƢXnn:FH 8^nrZ+C][z#/TZA2 c>\_hono+EDVt"ȷ, H]KY᳈&q4X66C[CNی(4dEU(VeAtRg$#`!Ȅ"HW ! a#,$nMj^ϣJK|v9b[G.p3rW0\Z:~!B>z"HCϼO{!Bc^=X*[A×#*Ȅ#	#*l,QIrg7kPR!ܹ v\#/yQI$A#PjJErXڈYسF,ȌA-f_3ةaH`n0fE]u-lZZe#/-ԙL:~h!tHH16=GPqx#o@ngyH-R(ZJEp*Hv}fxQϒ`&ri8=E۴|6"|봯_=a,ru'LP;2$az*vWK\=%$Q	O憚?k#,1ocцj,TU#/LEۊhe/%S!L)`	,wd0#*0B`A(G{UJB##/l!$YTTںQyV!CTг(ɐ#/ΒfȖ0D`S!&Gz#*EjUb#eEVX2ÆF1JFJQZe) I)T#/ڤ),X9%̔<щYM@ZcFZov޺Ғh&5KIh	K-M켕\0P*TlP9l]r[cciQӻrعwFF7-sbq[|I+Qm-M$ƭ:ı0&tgR.aXH|8QA{Ac፠ې5cMD@Ck+(v(j9Zg#/<ZgӴhu$ddʹ>@|} `I	=~FYA[v1V"sc2AX(NM6pJK%CO?eľٕ޿<tt#*D;0?7%	!-*z֝hܼKsvʮF)QIna(jc[jniXJ$#*"ԉ "~qC`Sa#/B"B#,[',#*"2:VSc/h١`#/JJ9,T+MW`lR"Se#,G뚢DDex>A#؝G"@D ōdhIɢ( Ɣhy&멕,6nV[m6^EmXʐcbEoM^wK[b-WdI4/o~@miTQ#tZ˺`h&Q^X-V@	L!jHʢC$>Pa#*q	,EP1,AB!#	U^G#/	P/B"79=zz79-H޿	 3< yj}ŊmUCd#/9FI1!ʣi3#,"!t$L5t"o`M;j#/|+lC>qjCؠCg{v!ވzF~Ikή۸)iJUcjH׼՚m++) γq6|,*D%\#,`z?76u:ͨiɔ;25uq6"`hXLY4i^,%r;9,,`P#,n$F	)T2`1wPA#dbE4P \hr#/SG!O^DOKwVa$IjQP.aȵ;l~5rB-c8U@xT(1fA	l̄{ՙ@/C<0gQ=)]9#PfmWk8I#H~<ph#[k4b&'e#*lQ#,цHdA`s(ʢJFƤPh#,~Sw#Ip0nHk!BGX2?E7Q?:o$`rą#/1źk(iRoǨO="!}θ3E`8$n>}.h"؍YAmIFK#3jjٵ%FR1#/kJM2j2((ShJ*5Sk6eh#/DTT֐jMShm`#-FV{|{"-'-#,Ԑ#\NȇٮVmu9-u6ڹoaQiOI=xpd-ʹչDd_Yom}	]aII"ȯmd#&PcM0HO\8'ϑ3WHOyX.#/;7mHQE<0)OtP$)P#*{4+ܜPs#*n{ 8Q#h @"	{R #*A{9h0n8mDCP$d=;)5ZR_P^ ͝!PIQɒ|jXfk#,3R*BO/ <HP3z2d;FQ+q{ZssRp6x rgb;WiHPyՐYsV'CZ#/R#,#6OtWd#/UE`!6&_QUQf\FϜBk@?//ի*&Иb[qN%z0]뮐_ϫ I@~r+~kѧH2m8ɵgO7:$'߲)&#/Y"1RT-/>5k8^YXPdXxݧ&i'fo4gf)rR$-#,FM5XFE#/ $m|'~z$)y01Z#,])#f4e`6i	Awc&i𸷓0&E[8H_#*Twz[C8TYMjF!	It򀓆eDXљ"D/(`sPG^u#<F=uϞNzKҒĸ*xo4I`aM=9Fɐu: J( \i_!^3aLxFar+B!IAb)BX0@$Zx*Q#*AN<)yb#*L:{Hʪ(4B޳U=k#*7rs9fV`Uv)>#*ff٦Q9hWmqN|/	--#Ra#Y6M\"+m:|tT'VBXSeİ$Y+/3{Х&33mdhDXcWrVa0M&>lȡ5ĈR#/TMKܱ7#]0"`[3`DqM7DTLƸȖs#,#*==ޠihȭ˹E}eOBrW3$Ler("[-i#/;2Ό?gfBaf#uS&%[C!$q Zpjc#/et\XI\ˑqcM;aG潨wC6˙"Aڷ(#/#/)Fl#,2TNҾ)bD0MAN-`Y+[RħΝThASrpiJᲘkTfc3#*(:`tTjؘ\ly|ɍdJ.Y؆+"#*`#*T#,[,A7%#,RN·A窙=#*΀uxz_րx7x&-ۏv'Qo`Q( !GD:"#ۻhUİh¢5(&VTh#*D Q9W*RQA)]<XPc$dKi2kyLε׎	lɫTtZvHTB"?WgX	 mUQrs`%},EcCb`}eJ`5C+%mecwE3	\WeE6ں`p$q1ZԓP17^,ly4{H^1^\#,10l҄^FCE# s"y	nG7QmDN06dp(h@#,Ú^1`)drZ^e3lb*1}PWiLBV-kUBgS~׷ p~zX8.Gޡ*`C+}LLJwu>aX~f2IeFVFŤROբ%uک|yQ%D!$;`?älyܰ\ڦ DUXz{mfC5TxSQ眸,r#*Ia^3H3#,0j,*}8kמf+big-#,kKQ,,5#c-lkOmԎ96Tad^)&x_ni'j!z#,r[u	Iiq#,prDY!ns>tc3YIb0L;f3#`G1h ,/mG#*b)#*)|eVط>F	{np9ܖ.G#*c<<|0LqkDgs2R-#,%y΃`R	hxtހ%V'>ujc +qn{yDa AM#,,!M#fcOpe_I96Y$q:ֆm<Oɋ"_k[;0ILa=9?ok#,~;2A^@)Gݡ	h$73s8od}NM9f<')nc| \Gy熱[mH_<V*J}~VJnBܺ_	bREQ4#,h ^Q$ 'bHT!A0(  ^>vP"7!lV#,,#,/]'gg3]G98TAP(+-'S*b/k;UN{<	#*n՗C|QG.w%LKZmS[G!	﮳gS;a߁kh:ӄny	-V_=Z9`5;CFew͵$DI1PFwBql1PJrs*(Dm7F75۬4ӷja[ljץz嵾yelU$'+0lTQ@>)J^Ƴ7I89kBc|xΧ}lA)tUW	BcNak~b]<`	K]Nh_ꨭ>9X-j$hg	5фh՜!R5}܁m c9n[r21s7u|#,2D8]c⪱I\/c"x@.5Qٗ.n#,Ҭ/H+MUHPrT(gMu(JtL1SX6oOR\9$0?/hD#/85m$:^+q/~16DKA-m k+hU:3#,k]Z䍼#,5 'oNL7 Ö$P-BLUHE}Kvt;IDljutqO:U$]̰scLmžW97͚#-PiBM>	U/+6l^?FwHPI"nt&#IF|CI"jUVf#,ߤ^(2E`cv.f0WQ!8fO[5hޥt,~ݍ!6%nA1xͧDUv+aܡa3q.aPs"0qzppVt=fm}!g.h_Ǽ?%ϣf~AH0"B!aN!*|5p	c.\w֨mjVh[[6ɍRkF,jܹZVBQ5[5}s.E:`pܢE5$>=[#,kmo݆pCi,X.oiPRkF}4]``?|{}>1#*םv#/ڛ#,	  cLi12`ǚLgW~'~jFamg{P(n6#/R;#,D.PvBvѫtv"vk&hr5*r #*~){!}+6kh$ *Wmq4sAd\a6tt}-MP#,ZI6p>C76X2#/	X%UIG<d^vPRkjE-[X]#,((u96P#h(NPC?_=VƚY :F>1"-TM]#*ג}&Sۊ]5AWSw]շƘYE%&оlOY%jyv*Z37;Z:7xص"9el 6hgj+nQ.wV J]`=@i5F9P3yMj4<}F0	D@wB~ކ!D}{Kv:h|14zlT*FYMRJ*6Ņ6i1F!	cx0V"Qb봤kLfR4V5(u`\GxtTf-ULdZ"1"Fb817e-*JѭSƑ#/ 	$DR%8UH$6SDx씌vHijCŅP"2j̷t깾yfɶ$o7]SRv0ҙ#,MDMD @fEhM44fYZ@ƩFkhSU)icc#/͉,ѴLMKv4\n4״5Qt$c^jN3ZGF2+#/م,YP6fcE`3w2@d2Tmq"r0֢v&CQ_*XEƓI4Mp&h*uZeaQhU{0dĀ)VCZRZoAG=S#*#,uQGI$VFfiW`FC0f!HV&w-1n%BбdH#6m,d3-$z g{{#ly۴K;h1oݗ87!2.48j+)Z(LMb0s~;[Z֙f:<=\>67fޖZg2h}zw=[ڙhœʄ}1XH<5T6puh8`p[f7&׎st06m#,S24Å#*k!<wWqȵVBmiVisKTފSjoZnL:EhɆzm00&b06.,Yz	M$4$îr-6ҫE*Jjh}q8&[cB6Q&#,04Q'(PfU[1!7#,J>y#,!M D9DT-(EDE$B%)#*0c(Bcd"bJ!$9*=o_dm@ߖ%|}oT5t#/|>sLh5bc_kJ2l֕"Sm,ՠ]eT~Ny7W=bj6yr\zzNÇ2p=pzǫn<ztd+U/M{x&:ch#/3	$9nffu7WLmL#8f#,*q2>TFdIUnQԳpv;{A=EAvק:("иTw&5Ostg^H8r!^\0\jQPꡪ74DmA!5Glpj776GTe*-]Mpߝ6Ϝc͹P|0#,PddAd#*jx+0FFЗ@YH"CP,	AAG!$"m!::X6fp6-]5yӻt4vDxfb-#*U;ZT!#*-"%rبȪ(H-#/%-}naq/|0ȶ$6Tad#*THL#*#,#*ODB#/B#/.܉#/R#/Ti$*fC( @B羙CX\ڲ׳ZZ25Hݛ`*LLҕƨ٘QlAF,Rl2`U,Q+ f[f:Ѿ,XC嬐?1=AFЕ!Hgͽ8&ǡȡH`7 9uw|aetvB	"E#$Nʴw8F~9jmmٗuu)gb6ӻK\rrڬRU5j۳Y"֥"4Y\i	><	q-I$@Hl\I!%(@l1N`n;zqkJT⺦!рU(!cy1N$'=OO}Z̀yy౮L3]TBHe՚l!!(}'#,uf`ӦLc1`cdj+I\$2ښn$a#ɷ5xy`*q|{spYtd6#Ҟ#/e#/d]*o0< 1d6^D@g|ԓ<&ۘo2GV6zLTza#,2#,"ocwh񓺅c,dRuwnVCv;ڀMgyPec@XfYNZUI#,44>4վoY5lmFV(QdD+"z@mU%cVJ`|+gei7㿝	f |c{Ww-R*mVkۋ#DDKAxLAC(S"$j\0zF)1V#B"+B22*0$#/Sl TB@"#*S'~)U.@0'#/sZ83VFeBl	mkVPc*D=XU@JchbaBPJFAAEFɤvU@"2hIaҢrb) 1OPWwXgb*@RG$0mfsG+κ#'&\Iϟ7dQf5mۧ~{@s;\]}r+m}`%#H~\ORgj2?^~*m\r>WaB /as"U)BL߷cd)-OOnWZϣ~#/9*[~;j5Th-.$b9rwDpoD/)C"1*MbX!U70ږe=#/x82r+D(TR<JV"mIDT3JS	Ͱ`z?@dUL@?Ed#/<{~=.UЪa>aTF̧#*f#!xdDEh t5Wv]_^UK\Q{(BJqw|=WJl&VvB~d'Sődnu˛W#,(6%(fȔ	xvd)60x4rW6yq]\"[9K-[rٖ4;wRډuVNm[RŷXl7tnݙܑKNrsV4rnP$F+Gٲ#/[@'pم6D%#*b;DB<8#*X0!A,'k,-#/SEN	*)|D,8Gnyd'ZgzPNӬaE܀Ȍc$P$c!a1PT#J(l(?*,b򰂘1IjХʛ3@ ڒbJ8뻩ehPަBб^lQ`<t$F4/S$#H-৮鯄Č{wL#IBBQ#*6RZC<Ӫƒ"BxnP	RF1#*.U[ґk*mpuܹR2*Vu?he~6)LaRa?o욏m`5t#,i]YU*CR4֥U4Hoۏ#5MGY#*sQV BjmLQkPHYFXCi+[rֆHQfS;岗h#FpSe[GA6PI%(suu#*L|;+gD0O2S+_n]kT@15JNB#/%$3rbv h5cdmFE	;;-94dhlq.\{$|9=(b{8lHƆ5$Aq,uwcv#/4$hX2O5[I{UTmVHJB#*c1%0Wn2P	*r/{+mx[y5L#/?V[sW%OĞ{રr$#*6h06<.OL$_+dd`2fq`,S#/AhĒE#/H*#pDjS ~lTAm3f	l)7l?wYQ$k{cHz#/y_KPb}#/oM#/F@7KXӯNH#,,<H `= QWuTiWN]}]6Ub4f׫N"$"P3EX؛4'[(H(%kHŴBҗI~h5}mm>,׫RW2V<Q6BY2LpP4ºx2<jf6ݒRA±4Uj>jVSVa^0FÒwզ#,}aMo*	o/rGi*PB$S|BґX#*c<xWS4Id1>D	#*Na#/x@wMK94(}cK훃Yu}?ôҔF#,!`i4U[Y+TF}ūf(T/ÜV]R6\ǰ{tԠ2TEQ{8fK+.ދ	3XCC:.~o9wIxlpD#ʃo#,QouȘKSgGp~;e"r-&͛fɻ"dLUŠ*J7 3&Z4fDY;Ӽ76({!k(FIyϺgk/K<wso|Zrتu0;#U9̤K͉#}o_$;G,jۄ{cCԿؚx5ލAeUF#/4d,]Z6GcLdp8KD.7)|q	M!42,ɭϣcwFP(#o6`Lh1ӵ)旷zy0y+u+ߦwHcLgLe}>lF4t5WR#,a7iyWygCUc RHR3o$tW\b_lp:?LrGzd>Etr"8nԨbFzJ#T@쎺p\n"s<G$8P٦qG$=}}>/.3!36CPCGo"1)d9/q3jf'^v#/#/4yA{5ǒZE`;X|cATa*Hf#,}E+:qF=;hݟw֝nWؖ&5ﴲ́5ʪ*kZLh}%$blR\ɛ}+.j5w+r<hoݾ9M-㬯= [߇TtEw;|<8}o+3&qXVt`QChYv2a20;}*zG.gɥ>=ԤУR?;53r&#šOQI$#,L'C%ܙėe8֑*-5<X&_§$ۯV#m&.HݣȘOb|5ot:{blJÃ1 /EoDCO+($ADB@VDۋ6`>jff/M10!;1D70-<bd[2t=GW!q>>5%̜Ā1[V8M̚ 2Eda#*i(xHTUB\#/zvwwNu D,L#*Ts	e`TV؍G!Knp7d#,DR1MÑMi<U3I[@w !2cM)	.1k_o?XɅ?00)#*5c6PiR@t-H,<P7o>&gTCbrf͖ł#%3?U#,3ͷqFJ'lhj%N 1|;ƬKvn'\D?#*O:IZB+_6N	.TmmEVvlrEbH$Z$եU#/}8JMpDH!_wtO!(6Vų٣8YȿLr.DOvtޱ*Q~lGT,GgoPAo6~tL֝Dؚ|Brx%QHJkֵ16~ܺpݗhT,Γuq!kwݛ;VsnUæFmTmJ!"g.6[ZH	#*Ɔ;E8s'/e(d:C*jY#*,U߿ש?{yQ$EASXI1QE1Dвi*lͅ	m|"}1j	I#*/#,T|n}JI6n[Ra2`$aIK7tzh%C}\xp֬y3#/P!#/6Xm!!:aٝ?HnA	O~=70ɑ(Jِ11ޗ`-MUNB7TRznOf;dr2ca']Qf]8ʾj	m|xĳ0KwW\[hp?;v;I"]ԗ*-Xƙ)HENă@ؓbE5fȓG.Z뒑r9.kt"md5o%1r!Xٌbm`h_@qRDiBJ5$WSI66m[L#/A(1$|:bˆ"Zb/#/a"i1ca*qH܉u5rBz3ML+?yz,\@L20%G#â=*KlAa*h,Tj⨤G٭&4\*-#"4&+M5 i#N!;mQuů]i$҄a#B	pk%CHJTTJ$]],G`c5QeYP؞*T"uʫN*vaeu3l"-		GT7"B\+-!J*&atn6HǦ6#,,K,7ǀ=.%"hҤ&ٗO'3lc0\)ZEiYBH22j5ՂVTRV;4c&Sf\f,tՊؓ9\#,SL+F4mDx8B"&%!J6ŤуN4Q%F+^df|,	jq042$Ң#/EPtP3cJjF(♜B0A#^~#qYxq=ZcI#,)\A2$²(aiH*$#/IIB#/Й ZDM'"1Aƍ;h^w**3oDJ\M f!KBDؚXrm1Atͣ9@ã*.hMH}cJLb)i4R(!SQXi7: O9RW0g*16KB/֛K5wĔ3+_L.1cQR(TӾFnԣ#/H5`#,DM1-RpqqT ҄lM34DDIh6(@0BQ!bJ"4T#*RD0iMI[oD;xp'y]12j]]-G];-_fPVUESf6Y2j5٬!h\.AR26E(<7b	>(LC?%'Ib4UIRm%ji͵Ɗ"%kNDԠ#½Ρ5'Wm~9J\(|Iub$K4Aav*#/JD2F$Zm҇wo)V׺0B, 0ʵhuM:FFuE!%*#/cn+FFm%oN,#,>MREy4˳5\Nrkf1NyZy8B ,j0c	@7LA^T1|#*03W+h#,_O>\Ń?y*\<7rt$GLGٹUx!	&U(_}״"7@_eʏu(7S#*e]_Ɍ>VLb}N	>Xfbۙc/'G|	`j%F('`955|hj'KjDUYMq]n,TP@BZqgiAזrX	;3%A&V(0XDUO$CIiJU(go,)u&^˭	C7'3#,Y@$4W4ntBtjEWIEsk&5ܭ1-ի5Xsskm-]6+&sZlh&F^*uJ@?erc(ȭ8i30k0&Py!{#c:FH@hx#*ށ?dDH`ݛr|#,T]L@>Qy#*Š_#* ZW>#/dHŀ,)LqvL)IQ$A*T(6#Z` b[Iknbmԋ$EvEB!.#hֶ֩eMdH#*  >q#"'D<Pu[F-PK2ABDOEiAսIK&eDdASmJr9!_EH(z́#*E#*A2,#/"	$,cEHFb#,()IRMBj66ڕ5J4ZeLB)"# ,	x1+FdE"񠍕ȑ<^o^]r'^w T݁ƣ! ZDIG1°XI1&%$ABl 8-D(b(RD!#*-uFe#*Ad#/`s;ReWMMӻ1ph/TA#/ZOh,*`K:j4?i6V|eV}u=RxI Cձ#N.0?Su44M-$6GGRXh #,Sx]c>#,"A#/S`Zw#*fo_Wᵾ!D󻴚;vYu*S2ֵsQVNUpV^H{6K;c]s$VozKM@T)(?vVs;q[3J[PJQqG%N]*R518bcj51P$vbǏ^g$uK|ѝ8}oi쳅gz	<_i>:#?I\J;>2]KYn1j$#,}>bEسZ3>gMIA~zhS͢ktX]罌`=oLTqR6\mZp]ў}4̧8%KhO8gc - j$q8rDWL'\p#m_W<krj$ !=%PD	=7AKjW1&:CC#/`zyxzU=v$0Hu91KBj*5#,E#*A$p+w#*E)(q8݁Kp+^t+]ԵBwme@kMvZ#/P^K͇5M[YDj^_)ixɠP65K?GHq=n9<$xYHg=$aCiUyR/}e*r:8BkMlLh(nyo6pnMb^gsmm9)jW=mf	 虘n jㆼ=59۰Jdgfup%&fk5jU&ͼ.r#8 79F%S˓n#,j,2hƱN68.NYfmCq]Ŵb+2#*j30#/8bu(#H#,t`˗x(34sDi/I_l|bCwԇ,u^ylH\߸E*{kXĢotXWy+NfW*j#/*a2TMι%-x{ZWzU0G|10/(Ǧ#,c[ƻ/uVӌ]$ZIϚUvmf%7۳ʪz'Y\ѹ/HwS	7{}{<Sz.aW"lGb,Z.59CV~1;xL"9+tc!,cnqGc8LKŋԙax`^#ɰT	^&<zx-US;CŋƷ/~$̖eީtrF{P̄us֧$i k7.ukYѳAqI(ntb4U#,L u]҅Z#,w͡<=1Q;@6k\#*^4$[}#/1(C@۷.t~y~Ӭ.7D$xI'Vtf[aʩ176tpadLC D^WYh0EKR<!C\Wf̲ۥGo2#Y@iV<Qy%N%uP#*31c~++D30&˘sx_(uVEwJAMaᤜz0nqpI$ٱ\%4hkR/@LrF`9EOg$}"VsR]IqtQr{O	[ɝu>pC:TP*҈r8p[Y̫aŝxD7-kJ{L~#,XvTSU%DC;Gʾ9,Sa31#,l$Qcg"l@<yjzjծpiwu%54db(Y>^'Uf}rl2Ġ\nVkQ$~%[xvd&ak6	(lFZ(}\_XD5].$P>"v]<|`n6.붰ʗ$غim(t7تW}G:7M$h<svT<aq}3WJ|K}A[S9dw۾	/)xћ㍰iIA5MۃB#,̠N!zf3Bv@p%,uSUG^3@lg#/" 1PBI7,h"!ՑyFqY9[Yϕ|\Bbp|牰5=5מ/aD1aUbw#/(R8{G#,z@Уۍߵ,,И1MQD1޶U#Uu#/(-!"*m8Q(m#OM.@y,<fpIң"::F.s. Lu-D5_!nmZ>5/[X+3&?D#xn1*:0%ņ?SA:A'^9mbSlIp{Ϫ|TTЬhQǇNxp5Swl*QCcbl1!#/dw,"4J\ĢX+#/L U]ԔC	d#/#/AY(HjhDP: , mj5m[f6k:)D@#,`302*"#/Jۛi$gPHL!vǈMlK(#/fO]=zWUrlUk5mj媍Vri6Zfo]@M[C5c-AKU1K+tPd,Mms3p5!FZ$WaF&Ax*vl8шUxet6J^|-y4"FBBb)JFƞwa%dH̡LZLZn9Q0&icRE,R4!W-hd%:wLt`lL#7NB&d2ɴ`:BkO/23d&c#.jSL8k,fa*=6S ܘ\y'K#,j9j[mLlffhh8r"b@CjKV(S3b+(auA[l2L-~;Z9ٻZh7[bjT"$:\e	C*#/4Ftq-I4CiHnl4S6˙_na3Ui{E|&]J&0ghnotӅk;wE-זi<:bMR7Q.`=릞AuBд4dq%fѸj#/d748i#,&ƭyd6rC :6EJWCW	Wki5ajsc.ۺ#/~/J1$8*mhp#i:ecEr7FެHdi	6&*,^IBKkUrH8Q6cZ'#1N&g63s0th4c)Ӿ*7=!ҳm4@.Qt[%AbB$r-HvS4cՁ3Ye4<h"pŅ)L8 4֬fwMh#/B1#!ϲYMBA#,R`P'łX[fEF"##/N43`C hdj5 ]f!u:par>aHRd]'v='i8?6S#AHv6$^1ݜ	&ɺ_G}v+`|Ie [JQ^%< \U<*n6#,JaiUQI {e*SiCoeeb˧8?&PҼ@)#*!U}l8)&oz{9ǂQǑ7xUc\ۅ BK8?oc44-g<&o	cD"R'vٻVK=kǈ9G'c#*6A7U+8(K)8P'<~cxQj5$!A6<oCr6۲ukXe" &+I!R#*#*!#*u<TyӶW!#U5BlcHc$b&eQ46fضMֱIF%dfE4)6IES(* Ĵ,YM1J-$l(l&$E}]/m`z`2WNTtvs@}_HHbHomߡ"+hy*ڄhjp 1!#,9A1-nfJAHl3F'ɡC?Zg2@Ha5޽AT;O~p16$E>#/`zDQk7]zSk5 [u7YCdzY#*#*#,ڋTIɴU"QՊ>ծVE&F5b3.Ֆխw#K	`]w^"T$RHnX\̺2@/GISd4VKUj:TQMEFH6l-M)rH+@mdh4ŀ.xM	;9^vkҼDeo矖,I @+p`vs!AXRDL1E#uѷ,D=T엃"d9[-&!pu̅`Lm{5#/LĮZED#,?,M[wR1JbT2"')&!h=#*۫ H	UH!l#/D\H`!15#/a9/"I$tb7ɀy	R`#JWۨzVz)6#`>s9SEbZ'V\3!lPӥ['@,e;Bo!=)%-% ƺV֦i!!M"Qh^mvv1|QF5T]~#ͺ#/{'X`*hXGAtm[v#*zHɭ{˿NxFc#Ճ839ލ6Chl[``@B@G#*-˚$yrZ}`Wz.#,Ni%(%,	Oi>.r=1#,ޕ20>)RIUCqiŉ愿KQH	#/#,|#*#jjQ7ҘBJ!+]Prdp{Ǩq3ׅsݗ~V[]z8uz2"" dy1/wPaBvcss	">wVa8&'CN?dl=*Y#/,0!ccI:Hjtk?DƦV:v1<9wn )n**A/U\ze8wƳz$9xҕIK4!ĝ5'[H'PeH8wb<][EWFRU'.]M0kQN(P(P,;3"`P@UX_ R;dI~:]ě>ݮ{`p+»mAa\ZCȑ9C"O)Mb&4@Z(ӝ39F>fCemH#*k7 ڙ`sv]	~F9	؂Za7k^,21Πa$#,()a5_\T^D(.K`hHȖ5qH86h+KG8XCr6qn-QI4`cI#/"bk:6^1a"Šgm,ks^:mNSN5(dGhhcvƇbߎbam -8LcltoK0q}3ܻqfKMBdXkGSf%	0,틳p[mKgw#/ͨ6:]<˂R炓<8ܖBmxWD7f%+*00-nAQDj)b#cHH"ij)"+zWY[!kV̥lgY7un{GL׃y`ٕpH(: 5evA[P,'Jb>xD^PMLkA	\Ki̘N>,}&tKi1DkMxyHîK1rT)SF#2-)tf\>[`ё8#c/i#,&Í@V6* oiw)f̄KnIĖDȲo#vnW׮SnbټAxM{Qd$6&}''8$\,&UDn#ɝ]>=Xqpf"zM"ֳJ0kS-Bs.)4VoxBiT:h5e	αڨ,B:$dQŐ__:հZfƉ=-PHt]ˁڮdr*rkFvbF3`8msoL#,*\\ζpәeȱր{Ctc,DW1"B3|3*Cה~S bmR	+Tde;;P#/0vf5P:aXK#Iϟیv5h#,7cx3KfB~P40ykp\ΣjUxAPR3Cf;[d\Kl#/!Ѵ&*.m#jۏ4NihR%kl2~^[w:T$tfNxKt Ơr}]6kmjnMwff/wFIdճmw$BHYÔ	#/4Xeq:gHރl߻].0#,Q	I#/`nPNhPτfκNg0@̷UjXP])8Ѭme`db'H7#dc2ψۇ}6śZ*l#,C[|d#/]ΫeSsSts%>XMJjrs5^0	ҨS#׷ƻtm坙Y'	 e.cTX%u(]_lr(SBkRc60d4l]+Tɕ.G#,2HQB$}3$pc}`C$\U(jɯ#,u#/|Yea8uv7mC.2dT2BH!-\#,pgƐցɬ@)X6)M]!4ddr7#,XK^]7u*ZeI1lL\vL$AJAlFn3rF­a٘m4Ȃa1(oubdj\ɠd4AoH12)a6U@SP#,FFHWDLGC8i3@SD]^v0D#,@&%s$*,]S2ab]/.uE$	g}F}ͬtEAQQ@c^^|!k4yϏOloǬ	"B@N"* z[u>źKvҳS%f}#,𶕼Fܖr̲7z-#/A?]-Gm"</Mę8l\$	rK5vMT-D_̢{U8TBkAE#4dPv߮`ϒ.g@8vA\K,YLHw?,%{!MJ/Lvp<֕D90f-I#,wU6_MUZHFsK{󳵚ZcM$SL>#*_exGԢ	m\8?C[L3lp6}mݐe钜(JC@RFN]2#,PQ(JP'2sp^&S"6xyD^&y5J.J]wG$P#,4b#,H#/baWcCTy=ld8[nI$5l-E.#,FfhP&h⨐|uN~^#/BC#*fO7&RS3{.XHAI;[`pU$Ɇ2H͡hN"Po(O@rޒ#*cڼ{n 7qLc6ԑEE/z}P}a+Xb	n*r^rflYC6}yJeVCpjj~,67rp9$H{cOAMpxԐÍ8f>}9@?.i4ذ{-#,TV"{)xgʌʸ40!vb*۫Q%[ZR52l[IwP#*Er`iC""ZTGl4EpEr`!H('\Qw($z)RsJ#*aUO=g_ﯱ.a]_a*},={/Y_Oܾicclhߖ\|Ԣo3`#*$d_F-1SƎ_H6lEѢ5|z:Ҹ=]+?5X:!(p0dQ4h"*VKy<]p͝ے*yyzyW)zƲmfna!,#/9ߪ噝h#/3#*t"ܒ9`ж?DItklL^`ITaNT&5PX7vgF;]D!BF&ݼ^QYTY$8iu$"Q֡HJ1Pk}{n^(v|guu,7a_X翭ZC_GbvzDy`nn8g%qpgO$K[7n,P[Jt@!#,2xzA5lENe-445%!rKl|'y+aD6iLMI*Yimk0&QR%DiݶCEfԻo76,Ur#,}QIjsSA==}J2vA$Y{>siN/#*xTÚ|{& B6	$gĢk9UQ9jZ^((~TE{jrlN*tcIPn<2uFYJܖ6Pje:$ՖRX0|q#Ј[g*Zn8َ@li1MV-Ӧ.Go4XVƨ[޶\004Fe6%X2КZ[7#/1=p!"!'p^dPD(7J5V舀|k)74K2?{71@Gs,Bp:`f'#*/yoօ#*6@+K!"20Z<2Mr&#/ "!0#*tTuHXn߈#waw$YQQfq	9tQqC)R}}{}_oq;iJi݊Ho0PONs6)ZA)Lfpgg_FтD,ܾQ{DNVw)qmN&#*xedm#,fc}AoQPB?O@nX 6vE{)}mʼhFLfO:61IwWA`ǥ\W	IW*YFJ)5(^Mjs\Cby]i9moE#*ҴRHC@~E6#*M{r~'|_?Ǡ{3i꾐SW`t#*B+Dc #.#Ӽ{NIQ!XH6̚~hWժ,Qb+IZ+)Ly#,ADA2K!)k`z&Eą"6G#/[韲ZnȦŰbcfF5֙EA-Y-ShJ뺁bx R-@uS]I<a'=eL}5\~YAd;{Hǵ5`8 g9#/9 ߩ3!"N3@O#6OGBP퀡 m*@ޛN{=#/[Plzu#/RNZ #/S1D"ݍQ)^ǝN>sƼT F#,#/.)e/YV>>U|87V7LNi,q1=@-ٹiH~4"8A~4=J-e2Qqo2^>']CsCR.ΈCA(<!#)iRl[Mnoj# "$O_e̔eHQ#	SB#`1}($aJ>4]˙Gek#*zGNmwրE#/mm^ZƭփjPVQ"6ڌB}Dqo[J)y_G 1#1AEL2]F5<"ĺ|?"iKi<<v̱#,8,,Ny`p(#*E;WM-i54ReBiݕ+ƻֺdn4ݙ]svU2ZT2%65P`Ea"J	#/DA&VE^#,Ib`cA+3LZntHb%(D)R`gT2B#H:B6˂yUVh]b>!lU##*dO<#,)m~I2 /|1됄M}ZtK#]4<&C拘3?-=LE2$6LMC57r-|#cԉSvrF"F)	e402Eq\⑜^cx4$41GP5^w~%_#4+_CJ˺Rzk{[ޛ@q L<RcUbٛ`|uKF#/C$a|U>Su8)#/c(~x8;J9$2/~OFu@yPOT>DU7(4i:lDuƜ#,iN6+#/#*u:D v P<CY,ϗ#/C1_]%FnRu5uu{mNTHxJQ,*(/T`؇Nz#*G>2~k7O&mQmG#o}wU=Cx<c(Cc3kzS]J(k_	sE#FgIrDVgNܯZmATYѢ0dP-[\*c8pwP88+iKc_Fɼ57¡\T!#,"M8+@p0nЖ5NFAV7q[j?!G<RqHHCq!E0|ag3hd@B,ub:ښ=l##9Ϩ9֨EDnKG#,%k>m2"9%7dx~,o;\Vs]	/f	57#*p#*GE#*2iց6C)cG	ȆAWW@Sy#/#,=	N^s@#/$=m#,Bz0#,EH^=1y82CTd6g! ԄfD5ǑʅLp qX;{d~}Cꇨ[txq)@=~33du0u,N@nBVjs/9Eu["vyWcR,`sLS#,_#,̴tI2@T#/$nG_a:X!{tB[50#,J!~qn8+ :)\цࡄFE5U<-=`CΰR3U5&0B`Ť7;VG,{j͸*xn`c$ضC$8=ͅH!j^}^#/i"4A#,hwHBAyCAƵ:ßҝb߉,{̻1ZMφ/!`c.?Cmr)Bxx3:Bk)#,M.[<g[t{OC@je!=;vIf	؊00naCgۆ׉I5E.?׻ĺ=53PEAVO^)I~;c߷YA2	k\69P)`2H<OiKaC) #*H$Hg2Jj g	<L]/`铸˝$Eb1VL(rH&Cao'FK[MŅ^7DJA5ͫ̬fT$)(R#/f|eD>5M6Ø("œPjPV*ǧn#, ݬ$r"4CUu+fBBoCturM#/uS<2	Ay>8d/fz#9cv`N֦y@\tIk#*^4ڗ5].oq%'Ttg<`b8@m	Qf/C`!+t^_޿#z5^+wX)6I9E#,iZJɶlcxޔjm[ZE#,F4HevtV#,Ú1!Ce \dC7XXkbt(%Y^:y߄ŏΤPxOW!lEԼ(5@$fR/;Q:#O\T="V,#*6Qw)BT#%)#/22ɧ >B(,"*Y+3%/GO_l ^TQaݼ0Aش?$b؟)b~0d}eq@swH<I\$XȈ<mǢU'Q0QDY@%A|O7{ao&gDDz;3RGr#>mNQ |e<1Gt~xQ!c B-h8YWW6OGg2ו.*?#e?赬⨊gMYwfӧm38E!bG8e)㗄lN*%KxAwH<MpLc}:RYO<(xKg_&%	j!z%5#/n$EC9}uO1$(A=#*l>a׈)-
#<==
