# encoding: latin-1
# Thomas Nagy, 2005-2018
#
"""
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
"""

import os, sys, inspect

VERSION="2.0.18"
REVISION="414d9e9b0387ca6ea365c6ab8ea5de72"
GIT="x"
INSTALL=''
C1='#+'
C2='#*'
C3='#)'
cwd = os.getcwd()
join = os.path.join


WAF='waf'
def b(x):
	return x
if sys.hexversion>0x300000f:
	WAF='waf3'
	def b(x):
		return x.encode()

def err(m):
	print(('\033[91mError: %s\033[0m' % m))
	sys.exit(1)

def unpack_wafdir(dir, src):
	f = open(src,'rb')
	c = 'corrupt archive (%d)'
	while 1:
		line = f.readline()
		if not line: err('run waf-light from a folder containing waflib')
		if line == b('#==>\n'):
			txt = f.readline()
			if not txt: err(c % 1)
			if f.readline() != b('#<==\n'): err(c % 2)
			break
	if not txt: err(c % 3)
	txt = txt[1:-1].replace(b(C1), b('\n')).replace(b(C2), b('\r')).replace(b(C3), b('\x00'))

	import shutil, tarfile
	try: shutil.rmtree(dir)
	except OSError: pass
	try:
		for x in ('Tools', 'extras'):
			os.makedirs(join(dir, 'waflib', x))
	except OSError:
		err("Cannot unpack waf lib into %s\nMove waf in a writable directory" % dir)

	os.chdir(dir)
	tmp = 't.bz2'
	t = open(tmp,'wb')
	try: t.write(txt)
	finally: t.close()

	try:
		t = tarfile.open(tmp)
	except:
		try:
			os.system('bunzip2 t.bz2')
			t = tarfile.open('t')
			tmp = 't'
		except:
			os.chdir(cwd)
			try: shutil.rmtree(dir)
			except OSError: pass
			err("Waf cannot be unpacked, check that bzip2 support is present")

	try:
		for x in t: t.extract(x)
	finally:
		t.close()

	for x in ('Tools', 'extras'):
		os.chmod(join('waflib',x), 493)

	if sys.hexversion<0x300000f:
		sys.path = [join(dir, 'waflib')] + sys.path
		import fixpy2
		fixpy2.fixdir(dir)

	os.remove(tmp)
	os.chdir(cwd)

	try: dir = unicode(dir, 'mbcs')
	except: pass
	try:
		from ctypes import windll
		windll.kernel32.SetFileAttributesW(dir, 2)
	except:
		pass

def test(dir):
	try:
		os.stat(join(dir, 'waflib'))
		return os.path.abspath(dir)
	except OSError:
		pass

def find_lib():
	src = os.path.abspath(inspect.getfile(inspect.getmodule(err)))
	base, name = os.path.split(src)

	#devs use $WAFDIR
	w=test(os.environ.get('WAFDIR', ''))
	if w: return w

	#waf-light
	if name.endswith('waf-light'):
		w = test(base)
		if w: return w
		for dir in sys.path:
			if test(dir):
				return dir
		err('waf-light requires waflib -> export WAFDIR=/folder')

	dirname = '%s-%s-%s' % (WAF, VERSION, REVISION)
	for i in (INSTALL,'/usr','/usr/local','/opt'):
		w = test(i + '/lib/' + dirname)
		if w: return w

	#waf-local
	dir = join(base, (sys.platform != 'win32' and '.' or '') + dirname)
	w = test(dir)
	if w: return w

	#unpack
	unpack_wafdir(dir, src)
	return dir

wafdir = find_lib()
sys.path.insert(0, wafdir)

if __name__ == '__main__':

	from waflib import Scripting
	Scripting.waf_entry_point(cwd, VERSION, wafdir)

#==>
#BZh91AY&SYrs#)e(¬#)0Z0#)b,܈#)#)#)#)#)#)#)#)#)#)#)#)#)#)#)#)#)#)#)#)#)9Tki#+QFܺvnkt׶({c{W]ˮjݻVʴ{˹ݶ6M_-)@4IݜvVsC5F^;\8뽡&	4W{>>nk{Ytt#)#)#)#)p#*@	AG(lwN;w=;V奲Ӻ#*@=d+ #)Em#+RR*P#+E#+E! T(#)JU]#)}u#*>XΥ݁g\:Ȗzӻ9U`vڵw/m=l}{ϻwۥ}{r\O>]`#)^P5*HAlFww;<KD#)hĔS`#)#+#+Dz^:B_vm5fw2_x㣠NϮq^wzhrO{w;nwF>ط6}{=ٺgWঀ}[s\;==ϛ[˷O{=9ݞ7x]hj6팅T>_`m񏽽[zln^wgRΕs7{um7il1WKz_Zso:<z׹}}}u:w}×]ᡠ#)#)** Vw@u*]l}Wz=A@yӫ%}mëWTzi4!vkN#)#)	_^}3qzUj^Tݎ^nwCS\tݯz=Lͅ뻌',^oKٶ#+|Ӛ:7GOGݵ_}:;ۮyv_m׾wn]gXz>l3|6Fjތ+A>,lk}g#) )X*ןm;@0>x=}p3㹒n͆rW͖h4*츅s7k{r\PAݣ>{4| f{w#)<9RM#)Ny<uͷvMr{WmU-ˁӶvwvͫb;s޲3^¼{__:ޛ(1%l$|YBf]Oamy#+|򌾐 #)@4#)i)SiFC@#)̧Fڄ #)CA1FM?Jy2M4M@#)#)#*#)#)#)DA4jzOd&GmM=5=Gb#)#)#)#)z$B2M=LLdF*~#+4P4z=COHC@#)#)#)#)#)B#) #)Ljh#*i=hLzC#)4h#*#)#)I@#)h*~ISڞSCꞧOH~Қ#*#)#)_VH?gj⪋NQ?ڠraA(	H͖ծ`LhlUlAJ X'63>Sy2x&Bnᛑf[tqgE/%A7ru3y"j7Wq5,55tH;/#)`#KjҭY*Սj[djk{P1BF@K$lAOT#)QPIQj3&FH4͛(	A"Q3*,dTQM#+&hd54ѳId!Z!#*F)MELYR)6JE	Z c4$3ԑmFIlBjcI@h)iShdKil3X2Y6me%2ԶٛI3b(*Y14Y#+(4ȣdHF#hKX؉*aDA)DX؄!,@2#$!fDPdhH,k&61cDR,e!#E4TIȣ(%LH*#+4Ģ4+ E))&ƲC6"Le͂ab6	,!0#$QAITBHh"DD!%(S)%&ر$T$BZSd	,eE"̒fF$J3dL*bHE))`٨$iJfccB&E4KHL6i64hBIRK(mmM,Q5,YY)2&iQ0YCI`LČ1	&jfZQR؆"fCS4͍#+,QLTb*YňLͦXDjd2#+CM,ԩLRF2)HQQI&$K)61i%#B6̈	i"$F3Y	14̅"	M(&i,صdY#!*HaH!bAeHMRP("d3%d"hҘBi31Uִh!BjfHҊIjSl#+YRiBYeM"ale(F!U	SlRH0fF#F6ԙJSQJ1*$F5Ybd)$k134fU1)Q4Z2iek1cBƤK2di5Q֑[3,SIS#+Tf,YLT)RJSLl)IHڋlIiZTQ5d*[&6EHkFhIEbŵZ6EɅQH&&2&ƍ&HVUC!2k&6F$"R6,[Sk*)MRjeµ2"J2&Uk,XQ3YYdHD4$LDb4 Hȅ`ИJmTJKAY&6JK6Fl"+*A"Bf fD	i1d#*0Y1!F,RFf##*"I(ƒ4CXM3#)dXbJP$&ѐ2cFRIF@ѐYMJI%@-BQHf$ѣfSFe%6ef+&YF1%٭,CF4#*1fQj4	Ȅ4ĨRjLEJiB5j+ٕ4MmIfQ6F4402!iC#T6(٤%15$$E1V36-#*&HM#*6LR#b5fC2*5K)*dF-ƨډ4Pe*	i5LbUQ5%Qh4d(I̒Ub2-UcX0DY4E3(ZRTؔDh6*R,Y0,djLRVST6RJdDBjMbLERRe&`d#**4̩DSmIY6ESI5EM6[)cdQ42KjDhXmhFRkdA#+lQb ̌H1i&f%XeY+BV1lj b#USKTFbe4BYlƱ5fQJVf*i#+#*,M,VœlѣX1F M6Ւ31%#T@#*MiCmlZfZJke,jjmV&3#Y%&XT3e@De$ȌFB-Z)Kx{bY4hD? rO>*ei#*M<owE?0AKIT}wˋ.CVZ	Z#+dA	cHX.I<V<e?ؑ]7m2c<3ĎO74⦍jwIh(y|7̛j[amja,FXwfZva8cCdۛGv͚eҍ.f96?F8Ɔm63.1cDYιec?g5r	6¡H(4y3Fe;q̠RR(bi]-v,w#8#+;PnY뷍#+2fHHzo+jC%P`;)L7avITF |?Qn^Ly=sY(m#+,#+p"%^?ԑf4^a"nDQ7>ˑFF}FQC)bjɴ"ÕL!7ŉ-jՑM,M.t#*Em$O5m"Oʯ{oLr-tvZ5Bd<>6L#+k~:{ۚM;Sx׌"0ޥXF4]v7(\F2>kykůWu_Z{vש\鼶]2sjł)GړOэ+n{s!"%MX#+*چ>JiA@VyW݈@W|ǡ#tE]P}+{?o/8tه<s|kG?,>ժͼMFw|3lg#*.0W|2fVkB6R#+sj)Og~=o;ktP航8HsTL]FxX&k	3;fiI#+NƕX[ڮYD,ITR2/	YJT"lrk&M/V1PNTTn,cAbҷĭ$FĎ#+*NPQU9h1Rm++_}Wh(rɨ6mOy1Mer%"dH+zklDݹ] bs=V8g{4-E߇zY4aw,Z+v?_1(|{=o:65&37j#*%J,R:b6#)zTBʏ>ݯLIl5C@GԒ#+"2(vUдoe$X4krW.oP']eJEzUХƲ}REDP5դ$U1(ݢ1mMZR݅mO#+Qc;z2Dyitu4(z>ԿJ#+gm`Jl&5ˏṵCafφw/Uw17XM-hwyj-IIQJoW{O4vLIo3	#iJ'#*)}Ggp=,_#*pG#*je{izB]D#$4,X|ݐa7ʸ1K8-Jd#4	F>6qUN:UyPͣJU<c˭U$&t>p>w#+Y:ħ4ꅙws'?-8d?`bՄg!=t6|#z#+#+xdfo٪֑Ü8ΘqH%$/0Yw:Ŧ4J"ITxs'ةcno#*`oP=+Ru]BL8vv~MrdgcڜKJeu1Kv#*2^v^J)1j)zu{+[^\шp?X7d1⌭$#ٔY Ǥez%.ǍkH"osr#+\R)TmZhէ#+AɅ,8X{*R;'o^ѽ-mK#7&!{]\kn]͞%$ֶmIwI",Qg0ʔƣi34n7|A,^=l͕g-+!8cnsR4yy6`Iw94Xsf3?x]aT53hAA"~϶/-;g[9#Ylibo	5"	VT_6)uϝuyMcr)E`L]~ζGxkj+a%G@|hEAERC=~JV'չS#*~yn*"g֍^6nUz5#*Q#+CU5#+vGk6S!T<f~p#4:lQQ>ucfKE`K	~x	 63Y yM3&E_߷7L.EbX1dYNwr.%>[1wWTDh=CESbHM|m~58S柭q:ie׼Js þ*e+Lb)vqwxtðifDMk?CZ`_HFD~>|Տe(^!YP}ݗ31EE¡#+05DAz1LF6-˩hcm]THh5Vmg4QIB^#*Kl"#JE=Xγr@SAa,bnά鮽z}q DiqV=8#).=?*1ՄvrHre׿ty&OU2kU*Hՙt^rBdZRhiPrMꞼy뙺i#+YF53{iT2)+g1U0db_|9U#*_+ű<Q1R"BV*DcTLIC5"p^0K0*zG/І]bZh:?$~D`rtژ{SZV$Tp#+)!)&EWro0_֚)jѸGkTn8>]#/>'={`tJ\ltayAt}6sđ5#T0jnR!f,Q{aJ!}tFJ|Wc,d,Xs#*SEQ)SfDULtUe!Ã)2Ս7htho\ݟNZܭv.jP^X>b	*;܃q߇:#*'&v{<g@N_=evRh6hˤrwzXS7	&'!!%G*`aje8T!_)nrtc;nP?c&اZcόi|$z{=^1b|ٮ{QRyߛjry2M\5wc4QrEo(jP|"ӕ'{">0\or[ .!;(cKƯ~8[μ܂0|MxŒߏG֌!Lr-%+Ph:JZ:՘gfeD8mS˾fX2|*ܬM&L/NT|.Os9G Ƶl'Y΍2  D#5wW9}2v) 0*ʧE8*5kEݵFs0mgp{$lIE*QzY+j_Řk`V#*fǽ>xaf!zد/}txi&Bʸ9}}n\.O<j7볳:0O[Խ'ۛ1xy4}Nb0Ͷ;wH~o#)f0C-#+F,V+?1*]ط`i|_F]akMsLWֵO&mAͪ'	,ak`'Wj"z*B#+w@Ɏ|C6Qtg.3k1yUΰrX-CT>:uTFɢjk#*r|shuhZVRQs҉ctw#+<M`dwPj'5$8iS-]=Ze"35%w[yzUvR7R듮UX	jK)ov`#+Uӫ'zrJxBIyӤX짓97v~C̫Vf`;?7Zhu)"{]j?YY4v_&i}q	Y_Ga#*Wa]Np^nGf	CM36Hoԛutl-b+{#,LlauuBC5<3oӶ24իm-G z5#*9Z!w|R:,roN&mgosr{ZQuNal0{j_e2*}|MN,0تX;Q=?W;{>WUO)R-o#U=3Y+z\c]r㘴ڦ?:,I4(j0+'ل42?[D#NaC^ucAr-CU@WSq]sVTBHM};9 \ #{)_~b^F0kc8ɺ tQoƐ],22#-$|4@tޯ-6h]_]$1=u>NqLIMRUq9Ѥ20U׭M#)`ҏSMWbP)\g6ӷv㋒K=H$}CߦWHuzrjbqO+O4f?[~,3.6:xU;lVaFTu]m D+,&L<+~qF1Gk񪂑I2(;Pj(/'HeW<{5g,&Yτkβ7`;WnC^%xi<9вMRוRWKrVmqza03Xu@&3htQ	ijA;?|A%\"EO^]|&AM#_;mRF0_wϖe#+q""0>	(eNCe!̐cC#*I<cima^-^v}?ű,k>jֺ͇N^bʬƾ\;Ԉuz5 zW7juTl)yX%޽n'b	JJ1^[3ssK	[Ӎ]:Fݴ)/ٮݻay#[+0N4zlȗf:]K6jCY)Uk㮶v`C#Ql7$U<;,FFR33H19]M%/2H/.5H*tvF"D~	?Ak||?,euS᳍a|o=ov5?9e%^6& L%L#&A!-c{25$zoȹ;G]4ɗٝqǵZf76BL,KHa4ZKKo/j|~o#Tr#+eσ_)NvJߝ᥿'q~7vKdn};Gs0鞻jTGYqNզ8HQa[K\͙ؠր`@@j+?x6l叞6;UU%՛6N\ȄײF^GK,.(n#)s?R{h? ժ0c*(LB?aѹ#)4ԇ@>#*|?cqt/ß_%}Տ6>Iq#+c+zW[Nmtr݉aq!R܌#ÿ1ƅ%ZAne&*F /xf*cjX,}),4#+EnǗ_e_M_٢Y`Gd#)/ޣʷJ208Mu6mO_/!P/`1y5#+E+dП\WֳwY#*Ue(ӎMǜ4X6JNW['6,iem%a7O}oW>\?2~6WloN鵌g,kCV%7|}uQuVl9E#*~%VAr_xoj9#*Ȇ9c6|8r-b	Qb}˳AKH=QgS:ofe^RL#-?(\eT=U@X8&FxMޏ`?HϪ*̝A?GE2LFif4RMLwa/*G"<uwIUd&gN&FB#)4&a6t-|OFs"ˏ<弿-ehm$/Pݶ|+)IEh#*DcE_ҙ=Yv?-#+!rf쏻YJ<|mL@tܱwA'_<Oϥ+\ʛ]Éqhf"MdVBEG^o4V[,k@0toaIXIgbb}jR]GHgvQ`,d>)<bO4tΐu':!AHGꞩIao"^q>7m.w9!kC&ky]oO܋UR25d__Y@![]R?Mj@k/~24]b|g5bY<VSad<KJɣYV`Ψr:YV]E$(x5\fZF_9kݪOIL4{7CP_lUbLS|Z+N!b0G_G<]O) @h%,khDkً=pIyl)WԄ_nsiW9q9*/=Q{_۽LB}^_WFD\6K˩0:w߻2~uO7#*l:~udy';Ac'KÊLj2#+e!I#+8RjZemKc#*Bbm\RzWbл6%Q\wّ2LL׫ZtnxaӛL`v{5qB;16^[n)#hr`]c!Q2˵vڬ#cǐE"zTǐ6\:`h9?Aq{~j?00zkc&)5Xo"b*>!xpǖsqb4aN?f00knaBX}[j=?+GL'1vm}jwƐ00JF$#+4[oER}}%W9l5Ue0d&o&_*mpn=XoōgUsZu#+[9-[&eMu6k\NiZ;UjX7YיnPޑ{B:3>c/o.[~qUڢrOD6{E\!<6NZQئɇurMۛzt]#+X皊2y>jkgm	2\75ÃRI,܇F]EfXݙoEOggwtK|{,t[n$zPq<74cY$2FӢrP.+ۑѺқ}YFد}ՙd̝$fgf5 7bV"|얫ۉk>L;cZш񷞘x=r#ۣvC~_va<ǅ(PiXA"KS"$C`#G7zt^6墄JD>:ŖFio+~W5K:~+PʪU,/DVPU߆`֡de"#+`A\f. rB>}97|I)"SSHFõظ^Y!7ۋ1UDzW8lZ;e+Dae١AyP|l"cɂ|zo&<FN#*ڗTQ,0sS"q*!WT"d`հy<ng]@4(eL$0OOǯhLNsDIHdth\7ٌ-(\+\yGqϟ'he)F+ϔgMՋ'~{/X1ҩ9?_4l	ʤN=[":RѦdgf:SGTyb+g%΋V74HHorc%օh#\x3Q\e$`])'@pZ\1b1q	Cf%s,d@t#*bHJo^d(ŎZ+*O^}#+߶܀R(ŉc6k{ѱLb1p#L!@#)#*x:x=0Wճu>~}(N#*~y=cX{Jg/ӣ~lέ5.R͹ `0Uj6_{sǝyWwz,.F&p1)e)Oz|ѳ࿿"jmIeM8~O~>?I7#@A |SCXlm*luVFƔ#*%Ʒ_[#+V֧.D>UިN6ZTh9s}b1H,	3^,buf+4.m͘DzuJ_k9qt"iС8[mA7,ƙ#*Y<&"h cGS^3'/V+#:n	s鿫01k32[KqW1j?Hp@l~=RO;مQR%KAx<q	kuh[K?xb9gqVG)B}W$%#@sbs^~2BǹSDg#*Ti<{F>?~L@X,D4F"t٩5d#+1iҙETFPI(dY#\hpdlKVL2m̑lM0pԂlEiQHlm P0HMZFRv4iPY#+072Ңn#*!،djAzf$M-40_q;38CBnb*mHM#*/^6T6xS#4xfxp\Gݷ'8̟?dts#kg$(t'Uecjei}?\m)#*u[b#YukAVK5,\Lk'I7ǟhf8\QɬHFQwRbK@$冷;<<8JXX-7E,<cQ|{cv)LlPr۾9MB}{?*tQ:-sM-J8Tm>]&7\=4qL,|$*C+iUCД9!_Mw$Mq{>5&Ly`؈$	Nn3x]@1d]ƔǸ~[16f%!(v憋:bsnDԫL<><<)sߵtD?ɳLt7'}*M)D\{>ݯîiR`QL#*ћn\V#PCPUه>OU{p_INpqgtQآpA5Pj#*B[_M<#Qh8N9iuC:oJE^z]/QGs:`٘0[yh&Q)&ȹW+Ԁ&Kh-Zb-r"$#)( $4c#V#+m"0P5f/f{6Ǝ%#*+Ny~]u[UL@뇐դPOݥMovUW7_Qěg_^pLϵg$pyq\=mr\GGݷl990C{::CysZVGN^vs&/#v'8K*ҬQpLd@QDSUhɯ8F~\fbo-qR,}E3>3x;W،5<OՇ9lAJ%^_/5Z]َ]f6^O$_NV~h}:~_r4cп_92o+CzRKcQ}#+%&z!i9yn6R?coͬpX>*ۤГNt4:MAByaV<Oݻ{>g#++,{rǓ8znƤ)Z?qPO&?%}zJ*W]`1a!#)B^y9oW9_1W~aQlkAͩ,$lbQ~7M^IP#)%ZR#+Ij?6co,'fUkBCS^iM'lbA䈍oe^4sns)rHa!ĵ"a~}v3<!hǆ醄2Csi;iF=WdcYD#)mJa}@K4@(@fD8I־QX5M]zAH,AC&ESDP'zGNumbraæ;;r)YVq90hZsDY`ʟ-X}_OՋQ\&̔x=yg"(OʹP;kOW09A9S:eGn&㯤k_چ0ŉIa*	ozFG/J#+5Aι_\OЏJ#+(.M7(DLrfpX`K\4xYjc;7~Ć	ևih&ɬʊ/\$X,'-vg#*_CY_G8~_~GOW~o_?]]1$ރuloz}&u|_b7Y~Xh?O3̞w-#*w7y&Жq}]}`v)Imʙ+dى(W}H?:')~0xMW`tɯO7ڹYCn:;5[Gm|$$}o&vC5#)2<J_īKz5pp</ɠyĐB".伶bVߌ׺]imdx-nRsbzuʈt0Hcۚ˫.u ()\Q|4u?ξ$<'/1qwJkuyK"d: `"58o0:ot 6+=OiCac#+;oh!s2tn$\pC-cow,-spq)`n$gg\O4L2o!cӜ<t7؆H$rԸZHF6bڥ'To?CkGgw#蔒?*<.%>?]C82rǚ\%/扦]*0PƤtF!\7ԊI.z$$#ϢIM#ec I 0CI;CHIGL!~X.xYOqC?[:i^^yQ/3)-6"+XAa}I)x_M6m1H5{IԼ#+Q_=:l>OG~/eORco߷[_~|0܏-cn7{m7&Û,y(=<e78y9{+Lfh8ԏRy]6KηIp	gglk>kxs[~jwG۳ر3%շûꢎu{0;Tӻvw{rpZ7lio[Wb޼k۳T>tj`:aa=Q)͗kw%Wm#9)xKxgR]wLǗ>-ŻxV|qfpynw.mpݣf'Һ'XDKOwv+*Ƃ#*.Yym:8qꛙaL=:aqowLm'G;XڳˁgqFIT+QofKݿgz[:=,.Y:2ߖ~;5SlS.-˧ӟ#|^&蟣:Ա5t(7oxNZ0Ǉmm#*wwe}+w6aR]م[O7*ӓ;o}1}՞٫~xo¹/ծ7?A.Z]P6~L=߇Vk5ty#+{-ݯ.s\1{vsֿv8>-.}/QÒܵV/</~:b_?֬)egG#*O7kyK!}{YOsWӨ{ϙuʟm.ųQU\]o=y}Qm)mivq+n>;ylF_؏_G6&Ѷ.ja?ޜFvѸ\wmߣ&q[TdOLyȅt7TR~19PiS?)@~毻ϯrw-1y:p\\w~ ,|l}Ǘw^幛Bo?ǧyy|n9~?1<~]?!wje/808ƶ~}6oiw~;=$n9:bɟہrl\w;z~y_3,n w_;nKط:N7xsO8 <<?h'k|[j%ȗ66c|g2.͵'-B}ry+/E굜=_a[9W}Nri_YgoO[W|pDn;l+d#)8u7~,W"ǾkjPyڒ}&Awŏ8,ȿ#Y^%Rqso\wVY4~ŒIݯ;z:*y"|殚g\Rn޼(c3֍g%!īkMxq#+[ۏnftO}:ʕǢ^L]Rvj[!oŘ;}gY?.87~}3Ermż9+/kֱ1/1B+SכxWޢ>zuNc싡8Tm6UU5Ê!	#*0Kܒ_[MYrkn_ev`ݬ˘s3mU}_噻.G=x田Y5RK5rf5,#+ЌeSƷ׿&jJK+:.	zϢ]B}oFJ~'_7121Zn&ޚto|*z0iSKem]BK!3|_ic90ӎ;z1VpYjkIe5}ZvJȉ"4^IRDquZ/8A]RNOW:~N^.{E/\;eϾvqKZIٯ1եw58|כ&=!UHزIDl6r_Ú솽mP;>4Oݏ_g}l~Z8⦫5<;v[&Q#a,nVX5 0F4j#*U##5(Dn؀7#+҃,tM`\'5"{pcv)lv5Ec#*2K q0)25Ef8cCO#*Ӥ؛A0Du를]5ɡ%"#Lyeeũ3;sMp8e4kA,r -[{v9	؅qar(efS~v#+wc<DhҶdҠbi7x2EA*26Bv&NF%%$veRR[gՓڋov}߲6w,vtjkBm}>޼8_Ç|=g쪡5.wvq'vݤه߫b")Q|j=re//pxaH4sM#+Y^~?/.'zzc)g_glAhz"/}hu>ݫȯL{|^U-JRNO+%bA~3-;z9^hįOu˭+s7F?EgL=a 9$UN߫W;cFmxUթ"TuRr\+CXCc(U޴w9us^wb&ȠTJ0!ˏNEi"euƈAD 6Z+)YlU#*\mJ5D-1FpmdI7)nB)0R2N`4`A4hWS@:MJR3ZCӸYKk$-B#+%25.e]{LHi2%.JDv?,TUQ9ADaWZducd+:\Cg>Ua E@WQKeb3f5[Z2_Of˿ejW<㇌L_؟o9bWu%kU]F\kuֻs<D^ZͿXw&5go#*̶&t2Y~ww4TQ実}!Nw?[5*]ww.89}<Q2oOv;&h#)#+M>Є{WM9˝T=XNnLpޥJ!1Վm6QoOa_RZ}ms[I{9BINkx_t<#IBa79qܛ胄"	p*Vߐzw5X#{Y*6T^I_ieIbXY5r\u٪Ob/.Ҧ][!whV~eTWmRTSPҨPj%,V'Lo6/6qdR2#*Ð,=-k0<|F^TzŇ3#zOJL&~fg/9"C#irn8TsSX.F`0!yk*0) ֞ajfa]YȌE_6I^v"4t#1p(Z2ALm=BA|DC%#*Hn{`!#"\TZېfVݵ8Y&2H#*&i.U#*ƛF ÖP6ٱh^7@Xڑjneɶ5K<AAw5B1Xaųe6#*@ncJ|2W&F8$q!PbyCdGk2ebx>suβ)+ԣ;,LcR1?]̔yA${)<)v-c!ޥ-Ogk{͈/۳#*#*%;:N@>&c22ȑ(ŋJ*f#*8}xc݋>ZEFxE|H\N|4UdNT$dH&GMhwU+Ӵ[$:r\eBڈz(oO٠ap#Cv=Exރ`Ke.4APN644(XqWJT"ghC>uRIDt~meEo#f>_/ξ~R7mٿl>:xoE!>OJ}G&Eѥh27tv>=Ar,RP9>	4Hy#CY}]mʨNЮLR7x268Ce*j#*+qB$#*ud8t3*4pCjJ'EeDY7#+K`<iXEFh)-dWT4X*VSF`P]2Cw	nRv.I-bf[Zj#*'q""vACn0iZՊH:X; rlVJV̶fk}27k)jMًRǺǴ(?~?e-^xDWk<-ŵgԚr=yj7`nƁ),<P`Jj2MaD$|wcsU10l\n#)^LTTjmKxJsU=Hgwe/*Qi!]gdszfnM)_L2cjImoc lzrN>7ru4kƋ5@IQ&XFRB0Lf)R$TjP;XMaH x&Mś/2m(IRYFFJlsFB#5B<`_̂%amy2ӭVGTb͝l织&#*M)4nx!G{D-޷)׮^whXַSL΃v#uvb*tVTAy.#*ǋ22;c+M~N4g4h_w7w.<m5ݵʈI(5#+#;sVF%+tB)j:;#+ѩdw#+F/dBk8ypwEٸV~Ň#)LBaяu+VЉъnں8d͕2F0ǜRf'8Y8cdVf	LkBÑ䓝BMhnى`ZXNnp:4y'	agV3/r-y*#+e497zEtJ9昤g<FbN$P]pۼN`m͔'#t|Ddb5[mWk86(L5\m4b-(*&v)S3gqcKm&J-"o{KO0A#*)KF2$U!Nb}7|J\#*^rW	NY[b[7EۧGtJLL k8!Lm?oçw/+#+ǈh~a7ia\}Z괶<=vߍHdуyDCTŭ#+~m,٪AnveyV(I,RΠŻ$К*I7rHx&#iu/FoH(Fp*˥^ѡEO!t)\%2i<~#)uy:άLfiԡiW9#+Qb;^mrwGKyY\a p+T6PPϯ'HdZkَtu9lvht	еtvGWB<}]Z 7."gLc!M([7g%0$DBV;>ķ|j3~;e+&lw+*	{I[?@e(On:v0)+ķ8&ANْﲽk#*mf]o딺^#)y7e(N\ig['s8l^"tmLXO|ʸ_c蒳ZhdIYVW0ophSp^1KV]ҌG}v44kz.5{1lMiKjMa#*/#*ȭKǣ@[#+b~.Ƒ}n0kL{c	1H럊j,ב~yx)1]I*l	9lew*-x+J'WBQr!tX=$.NS#+I`v&d)Jc?)3?<݊yuvϰ\{>@>Aہ	1JSCylRU%eːL?`1l<Z#+&%ӏ8{ǓwBDK}s#)?"mV%g}'$jc;A;uJB$*dۭ:%89oޢ|;nfeZ'#g,]QRUL+Z2L莓¥e̢6ٽIkP|ޅս4ۣ9$Î]AQ/iP &oG^|(|}}钒zm^,ݨ,-á!aM*wfMtIz6#v(|_ec(igQ[rtԽl0^:283˶8t\"֥Г-(||c5r!;`b#*3&ґR(\Z}٘SZb8ۣ:І%4JY@'#*̟3b8sM?MͰ,$,l/mفᚐaD%z<z0bg*Z"!4ͱѕ34S}#+0#QiW3ʲC<ͫ#*tLދW"S9NEEu:0'r M2ost&EЖ	mY~lۉ_YVmvc]C7ٔ93E5Cʴ1dR˰$JyZ[z%24]W'L<#a$U<#+N.Z<f8qNtL\語mA#+="#h,P1g04.3|uP|@:piAL=20^snfN3c+YQ_EFNarx:acꊦۨ<rvICx9zF{weIŶ]F	>^d<c:hb	V>QET	<ωՒ&6;,UVo謽u&ta>y65NQpNHe>D?R];>9Iq[otΠHtI,KS;J}}uo~D	2&=YZe[x`צs>#+㧚qb:Ϝ3V^!6wx}OݠI!O׮-!rrP3ݺ%Z.,Ot6<[Ͽn1;uöϟzUDwϒzC^sVGpŗ8ljO'ndL{=[l2ڋ%ű2XNҼ]Em}"wE!	;3^<qN$-r,oҌe6 7glشSjrnoB+3y*ag_MRoVέ	P[~pl%>5iJVFD^nn=ubNm_ѫhlYSlVǍY.ljlR9)yKͱ	}milJ|&y%ݍ؋{^ńp;94oNDZGןx6Xfg҂гL6^\犙LޞEaEyyۗm4<99iw/*WLoKIʥndiksk|m^Xև]e`"xշ,AM@uۡ%sѶyc(PU)M#+FL"vwYsBSZg{S=Փ7Zl`֧HaSC@B}13y/)2cKFa1?eVi@:;T=EıѫiGywz|2"_T\*:F%;AqqsJ>:.LaeӚU_iwm);'3;0#+pz,YZ[r<9\sY >FRz㕴yvo7)i{]"vOmLKs9޺e9-+QH,c-&iy3+ӟ{uooN?L;Ofkod[鳘K]v)U=_n}Uw{_-6W-/류lB[NRuZ:5K'p"_g߯LZղ͊res%!ͱ}*Y^iߝN͖29zͥ5kg^#+,u:7?ǥG5r|`:ߜ;Q7δG=m+1ȶZ9w8k[i&t^m>@RS*;SʧrW߇W8W|x<nL=93jݘ4k[y+:э#*oǠLrr\kyW|F/ѫ镖{,pRNɖyVYO#+Mp,nXn9ߧu碫^uЎ,Oul(CyO)l]?2	'۶ͻIʏn{z3s}-%E/*sZnFXu>P~p`g&Q~:.J̱挝ʧÂ#$pecuN!o~߃=-LgM£ks3J<1}u^a.ji<~ǟˮMnr<ŷ/M6w{xm,~gx*Y*g[yxA}_62PljՀjS?Ej~i4ǹSdswK%s;Ij:'t6"59y|'1rHr}fdj	[~)dmQȡ*}=nKO'?m	8d7(YPg657]Sy{oZuҩpM׾ַ'T*L5Rߟ7?#4o;9|̾Ql㎼ۮyS~fG;d?g펯Y(nn賲LpY|(.m7KzZ<yvl|Rl-c;x|ͥP?	<+oM]YʓLթV\q [^3gxtTx[o]B6#*!\5Ylp8gb#*|qmc.ܪpK]ZɪXsY<e~$ǱY(<q+ztWRs6R}\mՋR(vX|y*ׄl4ˆYm(Z(xHuZQ9ӬՐ>Gq3}cf+=TܸAW׭Ĳa21A6lS(UY\͉dߥc\QaLn=㍼sNXשeNUVsώSlۤ"Ne%#+ۅms/2KO[Gؼ5:zQ^F..DlGn?#+ȹfƱκ[-痙M7*FGstT笋haΗm]j@oH6vxM=*J2a*Fuuu˩EOlDWQnV!cO4G/ju>7^[N[nr.ٽ&qiA9YujԖ%}G8W켡!rdYxniB:#\$GO\ҙDU2N붭=KSXA8}c/z=ivOJ%}K+Y1ȅotC4Z׼R)ڦ<mXq3R38nQ?~2Ó/Kqo>_b;ts泎-6T3矪;oulksH>.nGLF<a"SRݍu׬Y_5Jj˿;úR4N;_lz}'ƵuL8+fnd%Ժ:C|Q4Jk+71Ͼ5MURK8ڜy|s'\AsFr#*QN1pg+ /e鮍q(r4SHi{bGMV}o>5/gONUI_7`*UdE,fLEy)lo-Qe8䫷T>\4Fd}׬gL+"#+srwjm;6a!BmewrPo"~O7vz݉:P2Q$/	GGavvێKLtVP~WYM|wyC){u9ؼ>]6J#*1ިNm%8.5hUs*Czrvuqvm/lKiO4sWEe'!7p|S^x3s5GBcܹRKrnHECґS*<MG޻.gSǴ|'2Mm?hγgӘ443<LSՎs^!#+[1b#MV/6xܖ~X[e"#q<Y)<u[U\'"V&Dй""Y7HKyn֟b#+ӉA5Mu^ȱjjp9qiպk<o*O}&:0XvN_OqMWcbjՋ52][)>d}Mt-:;$|˻|-/]K\TQy:̚AaCw/O"Qυ.V$d\W,ޯI^x;m#+6)U1 4Dk!Ջu#*ZfR}.wOXT!%I3[yT.[[wJzsij^KtczD'd}n\ 1nK6߳胖g!BM'tᎪm}ԮV#*zd1zc)}9g3#i^?-Ӎ{3yƢC49Fo__r~^qh.Mlp|%N@k2Om~wA)#QTQ佗ֱf_znk.}_xپ/yFhқrF#hcؾ327]nᴺ~1nG̋%=(.w#`LwMb7sTفң鯧o(^Sw9ɕhNO`[##+Z=OhΑ.V|W媁wUW)[[ی}[jtl#Qg{o.©g#lImۘ6\<mo.} ZoXPHaeQ҃ֆFc}9ͿԒ.n!)= *}1r\rVj;"xcoOę)f<'4W1:o':gU/v)Wu|OF>AH5nTntRa10UߤĩdN8Ȏ<.7!V^Ċ[	3|eϬct#Ԇlv~x͞NՅAZ&V=ӗl3nkk's5)"[=~!^|f8:;z#i\G!jJCOK66Of#ǃR9?w}w2MN]l\#)hYl^Cn뜆<ا;x+8;>Ӄ:Oկ$y"Q[WR$K|9]=v$e,^YȮؿL '"X{oEp1KLjJ/M۷kc	-U/B.#)T	|nY齡m55aMa#*ʺi75.v$m0춆4x@3'h^G=ef9˚/k%#)3ŏ'xgn8ֲʵP΢Q8}^SGɈJN-Ƽm`$txEfusȍWOE5Mɩ\τ|Wz_"#*3m'tl5;ˋKw,V:yQ5L⵼?D:#:xwG^JGtü͝T/#*r7V<Jn{:V,J3>؁_M{#.tձ;ct'M I6GOut֟g!2ǈ;WeR=/:SUtYy>vw7uUSw?	}#7鵞T3;'Ay[Kn⊦%zX{!yTT򫼥yZ!MI"G[+)ɱT(٠v19-#+ }zPe2tDB0:몄s^+6kwHvRFE$05f lp8UǖIZOOIdmp׬G'4?0ٰ}$]C(g{$lf!>`Ō7ٝ4#+_/v,+<$xxv ri *}SNG?RO"vy`\Β"tN(jKdo}a^%AàP]1>}-Ù82oG	Ray3߻j0Eɬq~QaM?#+룩$ջ|Evo@H4Ǽr`q$O#+֢Ժv01G@(G=AҸs5͢<;C7ƺGvd\oܓ,xߨص,0m	~3~5VJcb]Jsxj[CLQrY^E:-')3bŘ#l蝝Q:2#*)BkSV?s!0SuX鱲AΗQ=)@=!#)#*:@)*`/Lдl#*˩&6L$	΃rDzbRYX3%h#{j]c~6psa?#*C#cB^6#*vXL{{qa<ծ$K(3֤I \$qZ$KoYᲕiҎ0:eHa>)ˮ(R[QXAicx:/HӪrlIU,;%;Wf2+<2WR|qג892<m]+3P\>)#d59 ]u{q.ۉ_<2EDn˵n"IE/*0)PI=r,p*烼f4E{OFݣX1/tXv|@1$	sŝQ1uTpPgpA3ֵ-?#+IGQ	KZF0v49fMQA	jcUkWf{bї2˼<8\ϭIT}x<(Q<sݪPN0=]R?w["s! rWΓ	POB'#)ݚ;c&#+,=^Io\G~J`U3\6Qp$&8$o], 6<>c!H*ɮeЂk tVU}3ϖ]ښPcwv#*d%p;ki#*Wq`ƵX%հq+#hhlhALT<Jn$♀>"C?έMO{d6tm_xտR]Xd&ibkHLko!;j,P=:Pe[#)(vAPyy3#Ò6͐Ru~>f6%&${a>O#5oYl-#*obW~L~M<HtuNB[S7z}?fyixb Zi#*M\U<98>Lf#6HC="jH-te}߲Z3c##+ڗ+YYxpm|!]L8I!o4y[j;hζ+_5qG5`[.M,xH$]׋@&2^	篎7J-Sl-7>jX݉t%/Ӧ|g~[\uYqKl.32@#FR+ie!o9MWi0&v6q<PBjNFPu#}N{#*BUyY(<7bY6\VF-Q#+OF\uvgqv+Ajhg,%Am+fILޮ#+}ylZIFF*Y*S}v)_<\tVea.HXVJs#)Lu#*]ݡ!2LjL`IK'B!(M7#*4B&,앒NnsӇ.?.xGTW-$yp}Xu/f2<#)kb{ļ!ҏcMTjs	1szΘ.ɫG2M*Ň(=;<V7zCFsLY#+qR}D=qy,5z:[ɶO/>MF>éIZ%˦ zf'c;zN@:meZ<xpAEtxOẂ&_@J]w$GfVBs,uzEe.zeNHt![ǛTL+	72Ǳd-jLԚ}ѶNcΓ5{<\"7S=𯶪n[S٭Gg;7?珞?nDԶ=Ӧ&\kp>Noa8#*"NCYl3d:LS?d$dOukF#)Vۆb+SE#)kzvЮ׻mdcb`!zc.֞E&.3#*ڜI.X3.Q4ݑ><f:dH6%bJŤc#+KN<NYM׃\Ec/TQkcq]9Q9ZiÎ͇Hg|8\nJġa?q#hhF;ʗmNvrI,ٵ$˃2;ivՂC1iJݻNݫ<3fI$?=kxlwNXMVQPC9+}_5G_mAۚ`cShǜFޭ,npCs~R0z[;q	j7T?/ɺ3c/yc|P6XiVovf0暾>mH7:Blɍ'omP5L8۴hB_uL S͔,^qCK?|h磘>1>WT?'~Xs3vA??\*ɘ$hd:C(XFT?E6t,?<pF%+,Fl6Kz#* #d 1qX7E@D3n͒:^цLKQۥ#)(:[?u[^AtW%xsʇ,Y5hrwu8}zٔ	%FTn>o{{}?g?rv.RpCS#+o2a~?ӟF߫o/~?f?w/t7?}_wN:tYl)?13guMy0?CR\9Bd#+DHsY5lP#)!\@셁t#*P 0D XDE62"\.R:(ݲe%\PLfC@ղj,i]cc0GtXÄdSrRZ(ȃA.P$(JQ$ˇa5t^RMN蚂ͻ(V_:ζ\!acN4I,;5%#*3sξ#:i?**7a|]+{!7!mtQ=lٽp>{g5M!+E?jx{Σ:kr?9	6_.Ul疢C"F	2Hc/\!H)[O46#+QTdAb3٥F0éE#K]xl~$)\eqɊpD=rWbYG&͊(XSb4S7{Vc#$q6?`]r@f4#u]SLSQ솃`<<L6UEWGTz-Ȑ<=hйb3sA\YnnAĽ󐐆Aiϫqcİeh)6S4eJb/gws94QI?6nwΐlnG6pk`s`mb1#*%,/4#+1CtghE{K":)2N8ۻ}EOaw!3Cm3̰r7j-	M1I#*)ϸ\N`6GlↃ@YUNA]Gq'bN$&/[{rB0Mr:VOᙰѰNiuX٥s#>nC0~[TXkDH֫gJ<*ѓL#hΠ#)S;K#+J9 x1C* m͋[ٵsW+mjYVJ-kRh@AF	왈\WΖ#+MΊM*b(tb\ٚd^"ih^7卩j49<;wp"Š6>XD(_Uw%ǍO3<O$F#+#*	#+d18Mpd92S5p{x2m<['!i{k"%ioI.]z\IJ-N`esTkŊwL;:)A"#rƘ`AjCXBZ5;ּk|my(eV:ƺ鑛ih I	tUUɵO%Kf0Qfpߖvu~aŐ=j2*!8 Ms]jӿw	-^e.lg$:zQuX%8QI z> ;lLhX(;5hs"#+`,%	@CG\"AVHU#?+a#+z >KN(gJHvnцb_G[כSI@eSUW.~((d2#m<WwJIb-`:xMEyO'89]ND5 $6Nu92ؙl=niʧ*J#+tm	=*jS#)YP:\P2*	#+SnG`&qaе*PH0t;'C{t	fV!>R〭#+C#0B,#?|]-Kr$rݝU	J@Z߮S7C@a.dclf]={4䏗{ccl8+kk+;x(ru\pit o76\v\et{N\IX(%LfJqᷔFm`sHta% T#@.SתvWNwI#$l3=ܞoںb1M,qIgTX].1tرhÇnq;ͷ;jCC8y"ɽal'Ͳ5N<^uktW\wԤѩDF3<Qi#)֢Bo*#+5rcBz;J9ZjK,:jrs'+#*Mj$UЃmZ;fvQf;C􉌎'*(J#+Q`Y%*μ#*W/Nnx:cRga5{EV>+W<|ꫪ٭fUXzLO?_cs0t6;`Rbm>bE,A]P{+>l)TbMҐs<vZ<elzN럺spKg#+MC6X >(f,F!itGRd}Blwed=4,f\L91,ji-7B</l5ͶݻÌsU\HD_M	=Ľ,;}t%${٩i*@,k''~奎ZPjȜf)Mr4{-W&Zbl0{1˜V"Jt8l?LՄZO(h<:mVuAycþ;3/[lbܕ#)/<3Ho>{t(gLl/;vv=lBgؼ'lK`#*%D^2E:1#AΓZᲸ4a9#*n!b-&A&U@M'Qc)pZGiYc$lݏZGB(J@9>L`ç^-j15=So]i?[@簜2xA'VAft§8=iF*uΣ&(UNq'AfAdK.&O>|_y1&nFAӑ#)؃~-4bJpZR}W"1$HkU7XVgEpLr@$5BrtRXB怉tPN^`}藩Aɐ˨#)(m>G`b5i{]}TUgA<g5]+>Xi2WNW,}manbv4PH	#*>/+͋n'nV(ZJI)R>fBmnw+N:!j?LpoO]Xu(&5R[2Z#+l5H*2AHk.0ʿ}<9Gobڲ۝RNu)#**+OPMB!e7ek,#G/͙/	k,-߳_O?PMPC3HZAT_7ߟ<Zoʲ͚n|&#;oվjxJgw*ĈPOA)WA"Uuٲ*m5^hgOٽN;cA-;j殞?,:I%UH:PfA8g%cw	!%0@qg?6;9\mw]x$	@d"$RނPP!C8R]b&_O	I4'&khɔd~m9b|t:|[W۝F"T.&W~G_˄\8Cmշ}~'^Q:O>mE>lWo=1w<(-NAxMv۠kd7#)	!hMHv)ll량^*Q>X4HiFP{Ϊ174|;>4PYT|}M?_{ʂ"LL8Vߣېn/[?5s˳:㷾Q_栞4xz2k;~O!Úh$lRyԡ"œVuﵪF8%q#+:yA}o2Y{:if͍uv!݋{|At+H]tnz{tw[o#QX(NJo-JjwZFr+]IWk__o`bfTҼf7m(#+?DMGD9M`]o #yت&N)b3gxﰓ6Oa		!A{7մ$?lf|ǟOI3I<N3;]KڛOQa[aMǼcPU9o#|t_SU]w{WܗyT{,1}^ kH61QgÙި?w=N#tDQ_JK(~oXiyj=k^"v߿Ǐ<.;9̈831O|X}7$pWɕʗX瀫+唬Q0J#*XPPOlOC-7in۴saLtӗ뿲z':Kc #*]&-n4qZ_~s橗Pl#zൟIi׷Mbx,pFؿm~*.TkJ#hf87x6y|DMb#)#)_rPS<MtQwWWw)FAQ߸^޵S	V#+RLg9w];~Z곊A#+d{';|{s*IknyF@~3MWېk9q.iQ՟{00YETz`eu{SNDSYkJ#wZ:/D#e]ikW)ug?Q`#)zax^ܥL4ffmp3A;Ѷt;}n6jYϳB'o_Ig<#*6@a8Ͳ0-l!d?xA)7о5;/;kLe(pPldE<φgК|#,[XD'-r%:['i)$uLll,cg>ko1W#w#*{nmR\􋗇w7Cx""UUO?y(&W4f97^褑˭WT]oj_yʾń;tiwZ-5K_$=L6s: |CEx)oL;_6	t#Lgem[)oJ"l&qt9som:oD,]$w$M୳'3:mժ2mY O:)CLa3ô<}ku+]ggWO(׈t+zH/O$cX&%n?>Q88B/KJ^b7^`!4ZԤK9Pb Uu9isenOT՗ʺH53[ۥxr8ȇYo+.^7OtX;ұl,j>EJge2]fVaoOo[%UN>xxjsNvٷ%[{o|+cBW֛Ӹtf=2|+> \XW&'w=|1(\xΩwPs敐}o;"4d#dp3.V{mUeϓ!-3̎6pIQi"O-lx̝Dn=9R-I,9#*6弙rZ^|)B,-u76ع[]H[P!ᯖ'kuv#*2u:cN^Qg.\LP8szuf)E9BK;k\9=5t؈펺9E=m/!G6UN_DO*}WY'Mۼ͌ڬD+lv CC:t!Rc߆:-'B]_߇^nnutsV8`zNKiMwqy>	$BgGbvs𒋗E[12@C1ATd:^sZGV^ݵuz\>NטOoƚMqVoan\Q`#+iGhGXE2h1"eě7FZ$GV/yU3^W\ZR/y	&LJz,_CWs$;1V|xͻOGMZiKY9QYEx#+2w^9sv;O;/9|Z1,uguӻQ]70F1:8ܗ#oա۸A*ya\Qsq]`S-sE]#*Wf (	s$/PGMw7Ѻban8@pɖ,MtC;HQ"۽#Kz>ШǄ$9'bTū"\}#Ђn]tQP̍aH¯dYm5!	#\cO}A7Cǲr:Aj	)ỈɝS#+W|3V;:=OQ*5̻{ZT"A;lvpXKs99gkV~#+l8#DDl+]י$JdSKA(Wv1:KF}gA䷜j;G).b(0WC1'8ad0celUo!K쇎T0E|<x}x<4CS׭](Ή;;|;D>kza<wJ[fՒy97}#*!McJl#Fd_&֘~z>r4Q;l(MyGp9BigљgՐŔRbektCUkCG;Bn1JI#|\^ƒXlK!#)?d茍S #W1TXREnG]j1#*$d0ꇏhuE|>"oKS8UHOUB=oo.4όCY*SCF-S$'[orPAke;/:QO|=cޗ)h\$Mف)Ju0f&hfEgǨD<d`HDZAxu:, Xl>~?S{S73Gy5R#*ߡw&?$A`8 8X%,vHR}g#+U#)&vUOˠ>OCnB=̊'A4`^i]V$hz7cv1ﮗ>;?M)Q=<G<GMctuw>#*ƗS{?^kX_iNp6㏱=+0fg#0b#+&.:V$NDo߿wnAjWĹ/J~w|.~hjP\oL?M_s,?}ck}ɾ$VâTbE'fuƷOI4(,B_:wE#CO,tjOQ,@t&kMGY*<-n#*#{.OIRr$욶׍}}#/˴<kKRMڋ]x֑F>ݿ#+YÃh)`k.[R`eܛݛ1ɅN5?*sSAtƯ"Fead^:hsa֠i&yP$*a̒l,tgg2jbON@q7&=#+S-JJ&#*k+/u3IݓA\6|t^O|mxtc6N#*n	UrWórџpXlkWŪn[mW3^Cg0v8;~&~)H}܎tcχ1"'GB9#*Qa2f2ͅr3WPG#*/tZ%[uk4mӱ	<	U6.wϷΰ	ۘ3={&J"u$uxs%#*7mfhΕO}gb-[ucڶv#*		w/ƢjLz1v~psEG3<v1UCv|)uß}g;XI2?)kvi3F==,~_{/G<%?Cb	OT#+ЉޣndA'SW'~[WسDhߞm(liΓoOʚ;0恵HJѱ׌y>j㴿V:s&4lU/tJׅ#++2ht׆klfj5yvhS燎,P]]m.<ٰf^me){S	t'>(8F 5=_+FU\O5x; Ѹۙ%ǠM0V+31=EoRAN#++~͝!,υq3aX>oErhğ+8*":վ箢]QQm]k},ymZjF&IkGك#YfnTW^qMI+N|td%V+o9,}/yyA$1tGmwMcxq?nD,wz7Pwxh~hw68ݭ5ɴ YP{F~*EFW4"4p!LDM{xd2HpVMo6O9cs?!zϠ=+m1R#)F-ϣCs:/N`85/\Gڭ+>rܵ|~s#  |o탏گC_sDҹrjrPvۙĸ[hi:D;ۜy:fzNGs8a	~gݜi$#_-LrXT=l[&/<\3m9"l;&Oxj仞Ya,u0R4c#ߑu$[~gzhgg,*}_gɻ^w]L6:'ϞQcԞݛhZiV_ۍ#6mbMќěf{#*/qtϪq|x&	6|N.޺[Ve̠jvHII.2jCO-埸T.{StnOlevqe'7L@vT444bWrDu#*y/#)ZHeZ7u9]%axSNuuiǟfaWsܡNS5JPK=vx?7>|3/=4tQxQ[zg&(vtg&|8݋Ʃsf͚垚,an+j:q},6nVzE2͍K g9YZ.#sUWvȳbeqۮ[hptsf_:xiQd#*ʧv.5Xi=r'*1خ0J'=ҿiϽs}onƷqԑCtlCLrlܑTM9DэyZZfYd3[kn[&-λXOf}PY55NnӅJ6?ܠa&t6L1!hػODPH[W;N-Oz/I'vuu5(чDh2N}1XQrqΛzVˣֻs{pl+Wն6iSqDǻkDb֓̓k47un#*xk#*$Nz_4)¼:n}:,'E~ƽ"\a"[#)He_yӅ<l0&<^yYvigb`6j߅;-Q&*Je^{03p[ӥIZYnƪmr%ȺٷAqc&evؐI#*ol=ZQö6bf#*T]h+{MrbaHD]Fͅ0W՝xqU5`#+Է\o5a{49kw']dN]~Wj}$'͔kd'go^|C:Pxz)Tm2j5Cw۔ÖfLKn~cMAԜ	Jkbq91o9ϳ.yKkǲ/,a>)Lo֓}0k6_E7>-Z3YG<%o*m3dmģڊe|,Kת\l*	y55bޖ~-]cFf\]e+	ϣ=p"[xX#*wdu&:`su#|}#*2j4)Ƥjm&:#+c9ˡã=#+v|RҖ>=-ӥj3]e<;ClMeRD#+wsenRz3r8]WjÏPM|>i;XxraBC,w5/n\ӗ:h˭_^j#BBt\v*G#**󯫮Lfc<9	/R#*.tohFտf&KYm"{yKgOD/Kzf^@˜Q~~bч+6i6.0f&ц(4EI+/!ūNZ#*Iޱ?>/qm@{P#+Ae/Se/Aقks0_AE$eO%ԲW?e;L,\ ؜#)5aDњ_xADG?eFIڸcAcWP<ptFׯ*j(Kx.BTF95zk'%#+gCilwP3{GMOxvuFo32=h~*p&`)^].(5XY\Gg~Q2s{agk搻mԡps4{Gb1@zj<˺JXpF}̈́U+|f.)bx]Ttڤ290eNDI4w#*,ZP|0>tB2a&stdpǢV8u'Na Y2KUi>.H3qtȭovv,/C`y065Qh,B7q͔ޢD#)"JCip{NBD9xLwQv!?xR6zRC`_~nuojv@r^'WsnM@gEN9B]3(Y7~wXZ#*K^~i|h֋YaX9@ZRY {}d`E:îBt^fd*-aXFuyZcXK<$*)>^ShW.L?|(n#*@]"!(=:o낋XX_0jD;4hZ{0Inu@mS.-4L!1nJ[ٲj֕^[#)I)*3*JV=M^| {MD[ѦSs!k&Qޅi5^ьLk萾3=j\n}<b" #牡'(62}#)N#*IZJZY>C`A8`fmT*	*D	t:|#*w=i zVh4#*oN$ˤU%4B_*i)x59K.:D	f7/0ΒhWuN$I,eؕݚmwydC0v7]O6e{l#*[q2C!M[-fdGQb*ӰJ	3Nko^s!#+O脝x?v?.$mA?cA1״AF-k~DU6$ΓQFC#+AJM&?zvQ@ߺ̂HV(Z#YHjBG</<m~m6CH d38+5{#*4($D(9esC>QikAJ B!s`)#ģB!Bl|(3wgE#*2+ئz~~Y,bvw	eKS}!C3T>)Y"~mY#*uX?ZR|Yi8Pd-ȋ7Bh!65#+b$!#=`I_F<q=#+٨"s8Us󄝡XG)@f']85!y%`!p*$D{oz`/`o]v[?ɞX"%?ًXaOJ맯]RoFJLv$QK51-.Xf]dmffT!>FjGM܍ev#*jG^I$f4)1S.5%fj^7V`ax˨d0tx52=:audݥf}?vc"PA~zRLY?SWl~΍Ӿ6KoKiQ¯WytQB(cvUAyA-=^Ϧ'cGlFGM16(&HHa?s:&TmF6"Cl#'}Ucl6ɒH1/MInX4h龻ln;箺̫UYIMgnĢ|V"utmo+31)7כKhVG.~%7Xct龔X!#*v5"R+"*%gw<FCxxd֙|>%cŜa9s#+RpWULQx	>g5F0"C`45MgUJ*JRDSHhC0>.i#)A7#)ٱ,#+^(JD>	gZLxKQAM#!`Qqؕ9+@<k׌	#*%Fnf0/05$C#)iX>xWJdDs >#*%ǯ.lBi;"|gj׵%;;SVW7"zlt0},=P}_/w@sHM6.B#*jdD"u$>փ9c~9Eik696#+H?$=ݾ)8(tO($js()Q@yHW]w<8rw`Q=#+*05.ZГ@BխodD	dB2Oq&~_:2(Dr|F 4@:$e8q퀿#)zm%yL7r=bw7rWy{8܃夛-7zGWyZr@k #+|2U~P[ZUAd>7H_h)gPB30pRȹtA<D+z#20GΓ͂lZf\(!k })Z<xuXCs8郋9'/ss2(%F/PzRi^DiQ~%؅M66`'FFܾN" L~/ʽL[jY;4LJ0ZmR\`zL_ZmgJ@*I?|cdIY$ZhYxQpHA>'XT%l=SDۃ{11,.0#)	Kh)Y*<}7cݔʢF7"ȿR?֐?DEPr#*WqA*͂_#qRawvK3<n`&5S 8D_M!΢[|$#*L0Qɟ^*{c<XnmfD!FF5RDEJb>jy'3/$\(po#+u&?5)6MAW#)	d`Spơp|ǼB@Pp`|ZD<0͊Qf7jgɯu#*:F5]˕0ޠoZ~,9ĩµ#)D#+P!b,`0{(B.d3bMzZ{-U Ds]E7?PA6#*Z3>P1f}/UTX,U#)vE:#*S?LJwlSChQ%].AowzUHm=]͏:K""FĦeͯsU\7Hծ6T& [uמei[k&,hWU/01ڐJ(8/Os0dH!-zOyj@2#*#)1n~@4ly	*Da!@C!W&SI4<$$VS[[DMSy^<@Q9^vOP[cB;35z~Sr0Yf:z@#)qHp4RaAAmQ~om'NsОo\UmssdFͅ@#*{e,DQ\=Hp)K((H@yHOlno#cқfCޯ#*ґ->h*oLf/|#*fdG݀fp٭}-pVA{r%$(٪Ί_nՒGRNB_>^#)۵H&T('ad{qN)_m	27s#*7(gNΨQBړ!Hpda]hLAY%+ btla%ƠڦI [bK0TM&&>˼f	 JEQ3G~ȏBR{A=2V"≘T&@>l([a-Z#+Kݥ @`*p}n40ǯKs	:mP)	qp1#+jCx\,xǨ<~hXl\.yqF#)ς7#+F/p8M5WCsN;;Cw:$d]D(?ep^A/]uT{C uEX``17ruKנ-	gZ;i/gل|~-C13#ܭ_:'_Lֆ3x9#)m7<K@&b%nB]]['s4ҳqwѱ^[@X&#0]֕OqKڡ lE2IE\6qbLxۼ42ӧlyztUq؟6dȥlZ!֗SP#+J^#ٗ\9D{"RӲ	Pawz ?9jL#)jPhf͕~LhA5CJ;NHąЦ8*oRz#	CÙ:гlc2MBCP45C6v-ovӭ5F`n ##)8g7dq#*+<׏5Ot>`ʆ#+Ԑz{Iட4kd#+)r~#*y#)|{|Ob)u,xGl1%\zXg{8I|aST{/9m`эhIIz\;f`9/d|H離4;7c8C~5~x6`٪^C~ʗ5A*Y&7@h#*3#*z$G#*!`#*!h4r5@C`]L}nAcd(,`#jtNC%zNI.`X;@H6ÛGp>F]jyNQ}:U.VS2~د6;	ؐ$(N.f8`.7X=\N#*Q@{kcΥ %%"J컮v+Ƣ	F6j18F#YI>&CxrMkC?8ΌhR{CpqvՑ4Elk%51a(\rUJnQE,s$M,/@!+U|{}as12%==G4q#* CM<Nf?M|w		:D*#+W8{)1$Rk?~S¿.	a&D$0⛰9ZXL#*Q5W758!4c-n(%3JT|msQ?7%4dHO0O;PϭNT-1|\#+-#)u7;֢X{Miy>HjW&Ӛ*!_TRf/MW(ǺR;g;6_0"2/9S{#+k02*#*NnѳM{R`bM=E٢#&c<J*NPB,pY*(>Xp#*bX߶($${]ٳd"Ȁ[33D[D I=tH2ÔAd8+@>0)v[k_1|O/;,:쟮NWrh#)ti-sS7eyJwb"EWT2v#+1hD·XLGRf;[\T.#+:5q26] S8ݤ03?'HS[1׈04"*?רm*k-C[j;l|0T0 BGA.ɢiժd hgـF#+kR#+!'AۛW}tTDv_+>?^sGB"<l<%`JS}=ſ"Q7:4Uy=zU}֒a8Є6TwwvuE,qx΃;k#?9KDIGCWZoZ#ezR1DsD!ze;_sp)D˧-T37a}REKk_˸)k.c|q'҃""!@Ё7I!%!ːnl%1X)rDj{ee#*\Ă~e\%(&w$ePqF?uZ-'6SȰk00|:o#)"~FnI.銽5[6#+C\l2.fF0]0&rvxlj|j1OxfZߕ4Er[a#*9혰Js(.#2)~ĬF٘s<d-I`8P1B}=)BIN'.^'/Mpl+-<4-;eC/|n(~ۧ6_sWaOoȷeKCWOfղv`!nDtpha}.FkBw;#*x>`q|A?SQE;OZf7b?}f~@ǁˈuP㼟F{j9tLGlM+t>Wy''a_C"FNΙl9N~}}PÞhzRߧ><P[&alےv1i1:{k{q'ڴ魪K4*^e4SjɗfSuO?<fD`fRVUvWk4~mGh}CbVt˵w-k)nvYgyݬ@Bq|.hy)q~c4ٞyJ.V{[f#+f[/kd_Bv\8:g<vb9۩&%<E 5&͔<g8gٜ4-<	e#)<4{b:a-{?Il_WmvY\[e7q#T>tFK6im4,ݮUZ~eHMflo8~!(>M)*QhX₆HDm=m0m`[mE)~N|AѻIP6**c`&"'zR{>MնMw?-Z^dJ)V9粘+8XȯUҺe'Sύ6j#(wJ#*y**=뇧*3l=Ci/o5\@q>JLSExEQrPq237-U?Tѥ5	MLסQfofńBsYTLL9=|Ǘ;?3~O5.Ǔg:yTՙoݚ~>YgB5^-v_c,PT}CNu3Ҍs\H馲0MqT2O^$#D3.5Cn8v^&8sc"^ܔQ1K]߆acY.β9&Z52};F"0zzfc6׶	erN-z=Y-zd	wMz%f3差NۅW;mr䈷jhvkG;ogXުRo;n#6|kXsvv;ܑFPey#*^µ߷θXi-Q;RH /:٫Z!&fq!6߂N~R4ĲAH~Q\e#M2v_'k߯ B];&i_獘~QTNON{55:9qEx"@f}m{~#*X?H`]w1_bHlVF_:S+0d36SK	UClvg`ŞC6z(Qqc 04E=\=i7<Jj^uW7`aٛH08d^ֺ&iަ#*ݺCP8l\ɸ\uߘTa:h(ѯl9#)`6{jXbӄ1ܝ#G2Hbz#*=jelϰ8147j]+Ï!ݛ!؎XsG#)H'gM6-ͭzk?;y<Xp{jʘI&fQsbA2vYr8<KyB#*˃)UP\Гg͇	68*MTgW8G ha֘l5#)a B4"@\)Fͭ'pp9;FMA E`J3,+'RÃʉzm-K[7=PH'؉a92d9{GG-"C;<q>+9Ro+e^an^ao #*ړICv; URZ&Fqim6ɖTA@a+Pg	QMI1BM.ۓ"k3AXkgyAFջ#+W؇(GE7/{BDDcvpb15I*D(:yw1,?|GyQX;=AlKcAlpdjhXlmw5긄(z׳^NK<2H#*8C";.ʜU$Us;l\u#1Քro0ёxՃ}C#*1j#*?gk#*x ǟ>o9׼x#)J`6&vvq(#)*6Ґm$!&Acg̕e#)5{\q,*~XTޝh)46[B]MzGl#*dܚywf6z0^r)ηv04w.m6$٧xwOi_n-Jcu;v̸eZdlq!#v8n#+2nl8גA\hSu#+|͙y0Oz@ǋ'V3-Gy+Mț#^4^NoA.CSĸ=t7w@M|=L7<2#*$uD-ndnUeǞsȈ>H宇Msw+F#)ow1JIQ%֪֯06>Sy9qxDAE|.R&.3֝/&oBd]ܣF> sojD&ap+JՌpC:#+g!;"qu^ʹ4zbUj&aAh0WP2PRaL$ @m+#*FPz,A=)-OLMk\Äp2ul5#+k4:bۑw#v0Hp<F	/(L̠g^t+zl By*.\*v(am׮EôX[E7,KKWSɹ-[h\!$@â]<4zFRYF,s٠9"ξ'<N'hӫX**#)`0#*P_#+C5tM]<é1!0I#*4AdT.#+Dpm&"i9yeEbJBvo.S7^97BDbx`r3(%4#IͅZQi4ZC2 lךQ#+fbTLfX12%Xfz]}=vnsMPV0@CEe]٧ufٳ2y@nnpfwwQe((*oaMsymYJe8T:ppknfz\рv"L8ڍ]+\QNCs#ZTXJ=۳2Po~[f4cKo;Ag]&s4BڨLMZE&F,YKb_NF5C>8m_uT؊L]]x==arHv4R-m:"g6߽hߩ^sETp8\UX#*z8FB<b2&PVNCd#+v͈`.`Lueڤq'F|GZOy'ΛDav86SFe[^xS,Y`']Lgj[lLmt6_7%6x5lhvb	׭m,r,aLl5NxQG&%QD^Ø\	3'[U'hm拡8#)7q:2\s H9MLh`շ>W8\jXMQQ,B*"2yb:UI#v{%o#cHB2y6!vr[)#|lZX2'O:Z*Vi4ܠhRq"9:F]"+J&TJ7%F;#*{ #r5!f$iȳh(={3=K%˒mE!#+D<R &qx(x!ELt@Y #*v08aɸj(pq`*:G,02#C#+JG3-Z֯P37TaQ]^hRw|j#aO%Ե`[Fch6ZMoEEF+3'rCcvQv[qs86#aae+eq'hp= ؇2\˕$MIAdX]0ՂG4L"bđ;M.l!Yҍ3Gz+&HuKٛz&wo8CGǚ7R$ۙ>,;x[m $YVI6-n%A<ӆ#*=FaE:5(&Ǆ6.QA5)0L͛NM|#+;S2LUJx4n˲&Y;/v,YK̈h.<cU)DQ۟ZV6ً2æ	&`WQ\\!Ʒ0=BRe('.6m7KRb!<=*_ND xʢISAb,R4zOW:7#K/{A?VХy}oM&%/	mn?.TR[3dgZU:~!xa,#*C.?{N/ޫ~44չddD{1jkF@i-$C_bm/D~;Eg#CwA~έ$U]BBJZW#+IG?O? @5GnD#*Dy,#0h#)5TfdO&$$#+"D@-ZBȫ $b?]CDt>.S_|E[Tv:<S)#*`DR!#*ᴁ O!ΗN6#)%-)Վ0go<o1(]73la救Y|,}s6ϱE:#+ü|P+(!u"EfvE4S3#)ABn؆NR>+#+dxhvHn9}Vƹ8(X":n=#)@7dP$HAD!\yA(""H#+4G"#)Nr~aI^5'MR[Dțem^)؝j0dD LLD8 lXYn?'45E^fa"0#+`h@mN]Fn?<rcݮnۦs&t#+h%	v)$6#%;ܛ &5շ鯽Ot)fX;I$I#9#*y=~sUgLtCur+H<4Ń-$t0:\/ڭɐ\zV۸6ɘ<Mʹ|G};l^J#)kۛV4XŒ!4ds3b('oϬKd05"S\Kph8%jd#+:	6d2k)&H#)DJ%@ۥ#+iaIq#)g#+nAx#*!m!mkL0PVYjo6;5	X!eR7>	,66$8|-U`8^K/]goI	g{k>q_i|hg*'q&J#I#+ٺ>I~kp[JL!m	gmP(Q*{O"~ΉDa*T4ݧ:'ɢ	GP=Ttw!" 6(jVEFQ}"<bWꍋI$xQ/5wJE1#}S\ESA/V寿$,2hTC)	!O1mFmE`kID+--kMdkڳ&TiL`Eȩ?%N%]pzdH2 (=>Pl	A>{"vcR:"#+'E̅0q5QF5RaC,	6,\	XFZ5~Q+D~R*F50٢mDӥ|nhi(pp}BY3$WT޷T^](@-w#+"z#)ݧ񗪢+!F&c=0!YP|5b*)Gf5נs)5Q46[}$͹[ܦl)i-R[civIF$~w#4 Sה	XDETCpܧqtZTR@=BPyפؤPaJ`I&n7l0kx_OwzO\9q}B@ǚ^(SbcI&c$T'j0#(#+*$C!v;(ze)dq6#)1jCF(^ mIR#+.Pɽq)~!:j"Z+Dr@j#*=faf#Gi?dw3boaf }C"AN݄)2(medjT-RrYc<t@Td!ѤuF*d׬:%u>ëGrw(#*J8[^Å3,٣{8Qj b$=c s<;E(]&uIoW\sz(0a^43xwNǕ_AIc144ʋ>Ăˍy/$Hapqw:x#*;3mJm)!KL(gƞc'vх(a1;LjAX9pqC}]4RVQ&mvAQ%S]#+@Ml*+ȇa#@C	YdT=7g"I3,ñ[]]J)h,iZ0t|}TH͆#ΓD2#+:jtEA+9OX<HvHi6)#Q32Dlؾ~;dp11#+z0`}W?<FYFZA>AMRug#)1Nd]xKWƿz]hMlW+<+B&E(KNlR\^v\FGfLFy~m){ce4ץWO'#+1\^(:*^#&J7/SցFHe#SQZi6QI׆qs8ffM	WG;r랱'}K3pufi{:*QaeMp[5D2d0)3zy6Pipq>[98~-Mj18%jb>/eg;FBB=5aDF߶^|#+94|{saצ#)+,L2bCNOyuȯ#+cɝBե8Cw{'ãá2#)5t^<=廎\YYTv'8{rp[,LyvvmM[#+XwcaY`ͶꉘHgguv!yHz۴m?+CbP799d$#*Mj[Ocw#)m3ljTR91#8.l!t5dkBMsGstqZ6agT9a&7q#*1YRdA&\b#$M6 B"`9}fQP_&cC|6RGdP&r a1#)#+NzּS&,,D	,	%du#*SEt	Z7p#*y36avuO?|MN}R$"028g`M!;;%A)=fPu񚚑?o"=]vPnJGN&=d0J>ﾙ;L`M /v[nպA}}ZJ@?wD<#)^ܐBD!@J41#C6KkGuu6r.Kin컮nA#+Cc E7,}ȎC1\<7d]. yb!:7d0oI3	2kFyd7Nmc2)Rjb=%żNOFx-Q#"#+i/ɬ?zU%Au)~>v?#bfvmh%1a#*қ[#êLcBT#]e]!F<(#k|~b#`:#)A=PTD*㦚y	hO	H٥#+eacD L#+"DRiU%K@BY4US0#* @SVvRJ.0I@D;.Hb(Iij漸#*䐘yXZ"æP2twLnm$H#)h:rtnDiK6;{~9qտ]`hg컓;YMcnf(##+`x\ǆ)vpt/	q՛k5RDm,#+;$AÏn`vуzm;$NbZ"" ;B$Y:3g]%m.f׊qa#*g	%_a#+Eǖ(.:B|l'P?mk!n) "wRS</nMJ˹sp:R#*7Љm JFeOݾm$k`k:N}UU8>-<5(ãEA	]e<BBkRЂ6#)@lCd+mlXX)rAn@d#*uM	t°,hyD'8+ύ#*fwp.eWxYG#)	!hOi&eHĈu0#+!k#]L440H\Y48O80frHR_Y 43z^ku#IhSemDX"F,Qcv`kHZBpaϋђHp3x%@o@Iҏvlswךy2wus>>#)Ћ9ju@甑ND}0L	Ltgq-`Uا.H`4 Qqtҵa6ť15!hc]v134Svc9#*F-B	$PCj@dD#5TFG۵}ɓC-yYv9U|Bz	 π)81e1^DO#+@;, <#+M-AmEӅXH06*XddJ2TFu%xZK,ld!uBJ;mH"Hz=Nv9`uqVhI,i#+4iGŷ6*3!cE1ц<-1!.WSF8\eVYZME8Rk	<KW*А2&ev\RwRWj෣ODJ?f>NlzW9[sL`bzg:5F>#1TmS(N8øs̕nCn%Z;\iae2G%C1zObhǹ:˲iюmdi*b4`4 xUF(}x>n=B]PkpQP4P^CVh)٥	u)m<O<שKEFX٢bkYޕ=+bFSŇ#*cH[+h90kuQ\L:4,j0!A1@#*<gxQ:˩`W^zr쏛YkK=+Lхmf/TIq>ΐL<YNl흵qk38HJwoD:Q۸ِna(HK%"UH0HjQPj[/n*噒rZ*b:6vhdO2*#*I3#+5ѣGXf3ͺ6N	_%xܷ*B.],0wxvÍnHvg#*t2VpC$OT8!LU)hnGMB;{ܶ]ss&L暑ޤj$/a^CJ9z3xhѨ=F:W:б= a [~䣬.VMpi6i6J!5y̨TH rhv	)H//>a#*ER;"i_]fANwf o3&s{Gof;y6zdIV1X%wst&]&)ti$o>COM#+˘:>g0p|<f:T<a>OfT6ѩjwpD-0~MPN:V0IȨs`!@Mr38(ωJVZ3#* 2hgO:|5q=#H),#*}!dNx-m1onf{".ƑC:d9FLI#*#+](2Sbà B"_~2hBH0@ S#+sn8O`Rj"40wз@;6bښ	N7AАLg]]:-=1&XL9!	}IǾMzH桔=K3.++57c Ig_}OKZ$7j-QsŮP,Cj-omUh"^*QkZE$(h]w=	r*SE)c~ q#)|ol@	F>r:)ē!L&HЈ%2dijf%ҊMQh230m!J2SLBƽrKQIFS+e4̑hEQB҉QE#+K05A2hZTQD)Q1)-!2IMAX4i&hm4wI%naX&A,U_cBݘY"?P@۽BY+vf,i4@yn`bou?S6(ja;]mF?#+=,K7nIv,nD9YQvyN[Z-_K#$5іA!'Y2_'3urIƬUۆ2:#*0222#+Ti``,(.dlJƣa4(Zxxf?Ӽ/++>c=Is͖ٟhm(/>-#+#jQ<vn_zC=s!2bGBxm@{x#fblCvGb=vmB;*gUD#*3c\Roop2gU^V):D"/UynDcn[qX5,C+7#+7o#+{8Ky1L3;)%veFg#BZi\{ޙ߆X"k˙r57i{tsT9l$V4jo%e#+>:mە˖H:p+(vFѡd%ap& EJz>/;f*ÿJoW,'w$Bd흆tRbs+aaLüƍ;#aLiHI`2؀_Cv w\kdlypn`ʹ=Q;#+^ L$X7~?k"|ےl,ٚU@7v9~}oV(#ifb(+!Y,4-LٻGzPJ*N'2J-)Ñ˙9 mT_=3z$m-#+c#*gpzYu5J!ۧDW Ȍ#*b*V|7OwI!#kuMM&4GFFqHF-l5k#+TAp']87qXܚäs24cZklZќM5TԣR"E,.[is0ں563s}7LZRq5'`2BSLlC&8jĹ eOİ*n=AQHВ(^uQvs-T,{P#t!^Ѵd|c]R⁜s e<!C|8q!&m٨}ZQ;I"b`XC3sLn0H	|,ꚫ.mY~Hr#+oά:U,pthhSHɱbdRe*hMnp@upB9϶ֵ<"'h{pZpqMą+*B#*K.oyƨ(iqrf878R2|#-4Q[_C7y6DD'M˼a̲DﾬhocS+bg@:wCCilxX \pXnUmt)0Fs1AIS~+ڴF酼ow1mbt_<0U*thl1zzX(|1QEN%#)LƈHyǇn5(|QYl͙ $f%@uҐk\FkU +\4#+(0qL,}"i'MR#+bQRVn"u[Y2SY#cf9RwYL[ٔL5aB\'`[Li9CAFc`C؋MYzB#)&h-m4[rYwQ;:)pt9,n%5&G8NA8Bb2$%Ƀ!#-Wb]\q-	khifZ.C-.PN6szHfg(4FyM6lS-THb8hÕӳ#+hM֊@q:RIFȡb<Pu.8X'faK"3}iq1N!\20	c|jn_t	Q"qL|DC~NQö#*5[?ILcs/{zVʒ2"9N[i#*[uofnlYHqas|>oY]ᙘg}CNwk\"݄yN2|qT-$)آG͔#*kprk33#+޲f2;:-K&&1s=GJ2]V&)}uFwH7.),-ʃ{YDc,Tf^I8$ɝŶV(>5cnnf_C(WG12p8MMՃF9$:-<AX3rS[+ǖ<ՙLb1ܷxlΏZdmxicX6ព	6}f&&INɡsPi:c>Xvv,Ur`gbvgN+X0Mrxa]yj0m0e#+niR`hE8(jf+HaQzWw	5+jXM"#+aJ.U!#媖aKvwj_N9Vg95Ž4Cr@T-޸	&dKe?w~c #)VBO	.,L[eS6ew|Jdp@i-'KDm̡	2YpKL<OCE^<yxI)恾NVg,Tmt	Fb97ec05Bpm֫4nɮh6ay(!3VLh-Y#LM(%S6R.|+׭m8PhpIJ2!l'\֙JHac+d:$S#*[3&.#J&&<3	CV[*#4`eN*ni+v$]'JΕbxGAYm<unfQA#*06eq=Fzf\H8!Lc#*6Q`=16:-<H㍛n#+#*zƟqtCM 6FsD26[AqpcFӄ9K;JaΠ|5vad~,CpxCjt3p&"7sG"gΌ 2%xܖE'iA$Pkltj63dwcFYa39Ft 8[	fc-;ȁЛ#*24I10b0VK)I"LNkUDUTi'^H[.UY"ma5"ԁsa#*+uh"dt5#*:,Jؘp(j[#)#=r=d!Y#*F+435D6Gיb	\HvIEC&R3qr`(p7v,92si^hG!TuN')P!1C#)@Ùp+q%C1:!ќd͡D#*DTTufabpJ8M hfakr@Zy'(*\v:.܄pdf&HWL;1&VU`E(il0D 30 *@1Y&	#*j@@JaPXdXA)#H@TM;iSp@#JT#*߃?g/5|#+V0-MZ7u3(,Dq;a:7Hn˛xD[Uuddn),Aݖܵ{]6dg:-y;RaϲCuOǵ֛sjt:s#*%h2n[.rqB8w$+0'j]|#L6쁥7p&!!50F+ |yo9xXHxlPTэ{Nw#)l8<ҐJG#)đqB(#*4N4-oլԤҁ#)BƊCd^>x&u@̐|ؑrЩ	4XKXP'5B%&.P!@7o?Cu_  ~;TT**T1.nn5sd_n~ga dR~Lv/#)Gz#)8@9	r(`Ñ#)QD{~=;Լnq?V3.[r~"܋u,s9-'3'=cP:HH0iQ6Y8vM.BYB{}kmD%Mt%!.m#üzrs<ZJL?`p3w0`!@&¶h;MDAQ#$YlXmkDbdleQ|# ;m=yP{T-ڧ+xIdKMx'd;F16#b6@QRPgmـy5,`z35a%#PihBay'A9FʖCqMJZ 4BɅ#ΥuN(#&@qtRGJ$ZLI#+#*0&0!-!z-J؁7V#*fF,hx)61Wr9C8@``k"V@I#)o~#*HsI.#*f2o}QwhLUitHd#nsesgRp&(cq,#+DvQXh#Jj#)贸H!" 8B;$f^tŲ|yq)E$-,])Kx,|Y.&' TDUX#*3DCCK1?D9K&fV}32Owq#k$`ѱF"`o\*'*##	q>ϴ4a :u}N_ilkي9ڋ#HPފI0ﮡH-Yޭ-+Vsa228"VܘDjR6mm-V$1DEk%N@"r+tﵖ+EeG҈H?-[bEadlag(|UdQ$#+P6º4k,ڗnZ-tG,aIwl[&DiYYڷ4$Qф-1#+h7A#)-n##+aT"#+`Rpv ZH$bt`muPJ5f``V`#*x=Ȑdϵ\R(=Pa>@PqIETAֶ!X{t'|,LB{)#+w鉠/1	L']ܻ+^5m[Kmb-VҲѤ_\ 8>}4m_y#*-hq\oVG6ЉZCZ#)[Uȡ&5VeҵS0:ҕ.;'(Z6m"n#+cRײEt)R4]R@ts7+&31d27Si7\Q{nHV)'Qii8DMȤ IM#*dFz01+WIa	qA֝1s\6v.gn"11,;s&ݑ}#hha2W:=l3 qPATvx53sUXc,V2J{"B_G-bڇ4yсPa,#"jnzwV5ml[vbFe#*9B,EU))Ќ)pnP0{Msm[iȮ#*gDTfa]XĨVRn33XAVdcb4IJ s˳rfŎI92S$n3cBCQy#)TJEͧi]+yKxb]FR8Rm5 ajDdT2$,f6ҤTu-t556>m|T,T+[BTUM)*goD`XԚe;j$LQ7;@DdQC 7}1Cx<OauiR÷BK|+{#*q-B@#)Gb,tY ;3#+,[t"F#o말ŤG*I4S	ω#*iS`b%EeRHU$4iE0#) r8:Q\YqߞzىsNYY*~hn$B#+ٛaDu-je3*8 Eh8iG{kyp8gY]zvONOn2r "%nW:8A-ۦWB2 +6ah!9Av}G%XƎ7Ҵ#)Ѭȣx)B?JV[i2*͐i&;>D"E"#+|?8#+rΛqcC~т m[җdڊIEֺ]yۊ2MmE%[tv4V2dFƤE422iZb-@Xx՛ӳ#+JcLIQZU4NqEdTIjtj}Ku4TPdfҌڔRZMUU־g"c&Ȣ&U"IMV7ZV4TS[yxSbVm6PM*٬ZX-6o:%M2hkRW7l]cYБk%f#*>Y>RVՏ-?,Րg_]ͪ#+-F1XU`G3PɼF|]TYs%%:'d֌Xhs@#) P奦M5)5RYG&#)lEE0a#&jҶž.fmsoהtձWMbk#+h*iAaLj( *X,S*b[I(JMR٦md4J+r-EeQ-%#+J)FRB#*FSH66f2PX4eQM$FId֍jSZ#+Se2V,Ԇ,(h՛M!BJL[	I&L,՛c-ȘڊX&ImɓFRl{ֵݶE-H$ @BXҫ` $08PRdZSTmZDPUI:%kzCnXݣc}V%"nHT­~|]u:n`38&d5)D@Ԅ^7>D#͘5?tv48C0ި'OL8Gl$T7~Fκnų@f^VyN(ݤR${s;[}GuT7M#I^h2tF	6C	#*4$wfpUR13c\De*sU*[	p~*/٭uM	ϘRvWXQ<m!ɚ3Gу$~#+EM&#(BC}ĸɯ"Z)Xe,	B4f('9=1ntYM#*]&;E5KVIg#pfY$gL!B=MEY*#)Álz.XRD#5YffZ:#+F &!8=mN6I#).#)-lj`0*\+:B@+!ԣt IE˾ ζ[_O}h*0nyQ9&\T<ӛ)8>Vcm#*~/:Onx"@]8yv־al*TCOAvI&'֋`UAgLPFJB)G72dA,Jµbm5(d#l#+h{CRMn#*m'XA"X&!ilG&*5yj8q46;KBE͉D6&hnbqJ#+[K#+@X dRաIL~u#+a)RD#)8[.9ލfJ#ݡQ&ڭօT7;B-ĭI5Q1bYNiSZhMt{+a5ڍ#XO		 *ʅIÓNލKsc3	^4$dj#+ڭjd ~Ϡ]+lQnˤâL&>nWL0VH$jXiks\a_-qWxގ3bb!b5˰;1CBc&%!%eL>yl/y6n29TPz+8T~Jc-(V(I#*H(,#)dd.%J}\-|ސ0qL#Ĩ25֓ȏU-tazgآ4_j4(Hcd˃B41BiDMzVCCji+F2eAL<+fm7R'FBdZgxQȷcӉ02ps'G΋!59sT8LMۭdm+IǍ' z?/U"HߓQ0dx?#*)SY/+ôq5¬S"hqiDV&a"'o#*׭YIiCm#iҙԻa#+ߴ|#)`ԑe+LReHKc9R͓[D#)ϧ/MZ<^!3KDzNMc9#+;0Ǻen*.A`n2л7I$a$Tltb%dO|G{jkX̩GfW|(lD$tdd)ZbT%)E!VѳVZ˔dIai2=NY08,'f2߸C^#)6()ʑiU9@k˖*fۮyKy9qӆ^{#mY	&&47ƹv_ԌEk-a$iB+ᯇ]/;ҼkL"8\yĳKyփxXdclp 7$QJI3hRTuUFiU4ÃAMD%/`sLJ!*{WaäA!`e;q={͕=L׎RQ+|#QE?LEOW8ҎN}bU@==J{7	ɧvRn8cHvAc#İ˘_@U&j*drwK=Bx\0%*xު$yU*H"B!˼nnȑ2	2A`MD&+zFZדIwxݸ&\ŗcΙXjʢUH@M0`>},!(]nI~܇D90"Cߨq}Sk<.4<Ԋw5@("7_dlmKtFg41'809Gri_x+^MDZW0fMJ殇&4Fb[j܌lFm#)0L$-?ա)6ekҭwN	~82ώ4fp,%JPi28FF#G7pR#)5#*,3al! h|}3]l4#)}Y(rO4T5Q2ح)C\EEKDME/#+HN8?:QUgWJ#)m8rb(yvp:xhvkgv6\QcQV5Tvٵk.M	O&@l,Z5GnX\rޣP;	eaޛCs\,Z"a	E` (bB΅8f^#) ritMt0Ŵ0$FaA!@*Gj-n.9+GˇRΡu)3j!̄"H"HW@Dm	'Y#*dzSeW8+7&lF̈Dy)7O)+{7ۨbg->ue1DH<1ߪqO8ZUflE#+I:vz#*!7$max5+jK|:*zm}rŭ}nVkj\ֹV6YسF,ȌA[@f_3Tp0cT0~73"#+ź`6--#+r2[w23ZuuSSB!&(OAyX0V?I H #)6U}ۓm^-zqݶ4n;D$ȓϳ/@ sX{M'.ݠ3=&<MFORM gjS27ncaFHbPZmx%$Q	KZhXc?j3U QT*)v(`RHS#+XK"-2С>hF#+:^e]jdVv؊U^9gvr#)i%v3##*fQ"#+ΒfݥI!HpɆޤ&Qd8H60VfFCLl8dDL*J@eaZ2#*W6\|mrcTEnIi%1Ad4;ץ*ŷ#+56J׈,0ZRRfںMB`HT9Q&KKX-Ba2X<0"p´XCP.J5.#)(Ƽ;5\V65bn_1^%,fED3gI1Na&8	ԋ0,$iKbcG|y#*"A!&"a @pYGCT8(B:c4oI m(e>`>t'bqvFb~Gm}6(lBTMsb.-vwoO*)LD袢bkI&KUCO?v}Tܭ}M壠WD#)zv	|OPl!v<3E`tZ7/+cRݤYQ*)0^-kQآ媺lQ%{kjj27#)KR$$K'-2Å#*H),sp@Z#)LE#*=~NzB7}Ev#*EB#+:,#))B#)(D6N@";\};5Lt<li?W뛘7*!"#)|SJPjBFy۩JYnV6כ2"dڱJc,WUQ[W쨮jKmxDi)&U֤ZK߭WHaU@r<(96f^If%S#*o 5!jHʢC4>P#+He0ld BĜYm̄*Wɺjаw;e:)Dn!z@y^^#8,9H޿	 3<=tZ3lߣ&frbzq!<鷻)qBdI^딄d'"T 8#+nr,,$XND@Ȩh0d=	T6q۽j|ow㖼\HҖPZFvƖl]E`LѬ+L|.;#*#)wrb+tjwG/+0p4~1~چO+]aW<icwa>zb1#*F׆Avh+|jVE#*R#*$F	YСdkYZӃ4w ёM$geah}U#*|S<{O*UnwI$'!3C>]"۩W\Ne/њf@$a)HtQid̃8I6tt9KOJWFi6D4-#I6k8IK<~8E5mCyl [B TϜhB"i(H1aB،S;J2Q= c674f!Nv33wQ#)>ɐRge<y6J[#7m2ve0v?WK֋Y-F=Lu0v7xx+[yV|d[BD$[(0(dfb5lڒZ)5tA&ʙigsV5iTm#*)XJ*5Zi)2SU4ll**kHblڳDT5UFZjy~-~t'M[d[ "#)ArD"DrըձkZ5-̨d!a?9r	OBy]t⪻J5F@8T;d$ ?ĝWݛo19yu)'.dq3#:ep9#Gn#+4C$Ni#)NPBE#+"#)|#)ЯrrCh~f @q!#)/\JP[DnHƀ}O0^wlgcq=7Nx8a]YI#*$|Qg6KJSK-#30g5-9RAjXXк\W叇DBӓ$x#+:o:W!85N&;:3C7y#) WqZش'x`BIE1ɇ$8A;oZ9g^'#+UEhHhh8F$kGW!Y6*y_yD(!Qpi8l֐Cjo8'ϡMYl& Η\a#)8Wh_V*AD/i#)sN2mo,#+sdd*pJ!*\	adFJ`Ƞ`M0v8%ҘDQV!&+}N|$Z3wBs\29M|FImQM{amD§`H0 }_/B#*X11 B9h*##$i	&Ѐ/Zę]	Z{-{.q5&rl!|GwX22)3!)<ve$34fe4H1K숆(Nj	M`EOQMsmt礽),Dsto\q4$PhDԌɁvnTQ"QBǞÚ}=:PTs)L*@!Euy+&+TmK*Q q{a#)#*'/^ڨ;#)?7!oZw=Q{7Эyhc+ɀ--.l8Zh,]js`3ctCB(k%N|qhj	ɲj湊B6q<r(PY#+Qis~[͊5y^gR玓yrB#*QF~Nܐl#)z׭Y=q"!ȇYc.`WҖyhٟdGCtdN4i9&]LK@.En]Е/}k%z0#1"OTʖW"%qb֓]i D	>o/Tsʓ|cam[t?GV]#)b,fd-*Eqc$ҝr˒OTdR&j41.Q<QnP#*t'aZtTfJϹCqzlɷĖ)gN4^um	kq4x,!PL7UMWUqm>YtTji]Lӆh6t A@AU;bd@H`Ae&a@c#)Vt(< z;~DʗEM0N[chn;F1RKxA , ryhQ'gR/@nYGC$%5h,CLaИ_n,ʊA"gٶizU2NjSdM5uZmv*6ڤeӶ.^fJ,WӬ7P[# ă(mTOFI ~7V"`0BV̶RaciF&֤ѓ=mecwE3kb`bcM^5kyx]*/QwXVǦkRM@MƆXE"PPi/{&؄^=(MoxihUa,.6B[aMcfa$7#+0kõhsAXUa0KmG%XٹF7#+>9)1HJ`$&a룫eSg\w{fI<O<9z/Pn"l:ɦfbWc#)}%)#)ĐU5myK*5&Z6-%mRn+OǛ湮Zxc0ꍏ=	Em`[#)!֣Ȳm5y֬'#))2Sw;F3#*0j,*}8k׷O~W'bc1qoNkjۘŭi&j!L.]V5H˨ɡWջ(z4wLz#*sT[vg	IqqqrDY!v_F1`X=UĖ#	û&a26#*dqv72"<ŴS-A̥{}[bH$/uDnvo]Nv8COn|̣T7]eWTlix=A[QzO2>@V4IhLD20EEkKYS	cA12ybqD,CQuu8YȚ:SIU'B;;$tɆϥ#+PR6դ+Z;{P,#+j(4A	D=!9X&!ǥ|s#wbiTփ`7-cAͪ;<5Eޖ&dQ-aPB_(5Qw)lmBX`?0UԕU(K!khP"Lu	(DTX	#*֘;#+G#+i	DOaq2!bi`\p0iz8;#*葲NkUCnf~&_LwmZH><#)yfl2Z4Ngm\Y|E8Q:n&)ΙQHtݲl#P|	8*#+Ln(p\!%؋dפ;3\׽<l|-""Me҆ol7{gF`"Fut	'2I&#v5ݹfS[NݪM[lZcGsuxޮ+y,aJBb恠N|R()C7NVg5"A#u$`e&u?50u?H2BZ/r#*6BMRP+J^ܶWcʃa-sRX@4j͇!RFhv+_=`@E#+iǝne+tp#*ݜ_z>#)'qq`(r}AG7c0}y<󤷭}C_O;6)T"#*@uҍcb'۞zh]/!ɵnds6"9 ٯY/?O1?ɰnhȔoDHtkd5dw~]#+SpkWVhXl#*klL/H~&XvX>3#*k.Hy4#)jPV5\9NE|p0YG: 8J3((A54$q,	Dd";b͐P8>stU^7#*$u:q#˟I-J\	魚#-Pi^0ᇨ)GՀ>4TC&#*ň#(i]	R`Q{RHZ*]YknxB#)N.OYuF/Afh	yp!4٫G+`!3İ=z:O9􈊮r{#*#*,0a+`Z4|dI'T1d3ӧ%Xt'T;|Ci%)e8gٽm?a;`WC'G@j&U1vBqFIb#+UJՋTV6ml%U%[@B($-ZQQ6F_#)ae#) İ'f#**XI`!RAp:o3 7,,Stqv(،9c7i`n߾#+_T R`#*3潬AhOej.2$1u$PiQǽ>j	|хu|Ro7R#+R;#*H\CqvnD®\u5ɬ6Q80;qxdAN㘼{lZRamFZF&t&dRaUֶD)Nzjg&zGFj3(>TJuIURQ>oy~PRqAI7@TܖZkIuB]v\ ҢWW2F#)C`Jl#+ԁۉcHF"R:ċlR!4UhB8g']s^4l$}vmQIj#*k~%FQ85A6qj*"a,$22r<)~K8%Nwmg"Šb.վ	#+91>9n+~PhPkL AϱehqvHc	3:c?;Q9)LU#+Z6`me$)H6HS|rPGM(8)0Omǿuv#ԮR֞u̮g[mn봤kLfR4V5Kz`.n, $Ie#p`24K& `dq3)hʀtkFT`$IM"RA v#*5q	dLHik!b#+(QKwN曙ljJdfue5!J-+oCJd260M6LQ4Y"EfXYYBF0AQl+H(-bMM8MA1RHifĖhf&ESRݼkN\f[sNݽٯ7H7AJ@V Rq:1XV)ef0*(2J[6gi1xN#*Z@d2Tmq"ItkQ;cq0UkH[y{>^Y{Z8ɴQ7nF-1RU#L{YZ׭(5m|[S!cـ,m[)-I$VFfYk˱ pѐ(#)R*hじոfWȊ1r2DVV=Ejw$mݤ^;h1oٗ8݆R7ce3 NqC67vI]yJԲAX߳N֤2E5ekLaB#*#)MٵM9#*ikɠu!@j	<5>SyP]8+уδV4.#)clB(%%PNQ.'7C`3,?с)uerqH?_l؎I,O<_k>tڃ+mXWLgF*1+EL3Ш-a"Y&Qn&%77ГVB-6ҡQb4qfTcb{O7klmbӎ/H)+ l" LD[̪lc~Bn}B@r2-(P"d)"DQbA0#)at!`0.,f(El70jq:[nGXqI;HZ#+^hX?o6OKl~N~.4KMW<qP(&O}<ޱ\#*h'j6xjf\WprN=[qfk!]_%6M+ĬѸ1CfmQyUtF$18BFbh,^8Q`T1aLDr3Bft;tOf"~Awc@Q'DHLyy&ٮ+>cJ@qpYǃqa6cܵ8&:A!l|Glpj#*y<_<S0PZ[iLU8gMs &<ʃC`%k-*|jlaDl-	t%~	VʐRB3*wFK7[M⫬[n6ckݺ[U\ۻs"rxE<2ɱYHJRPP-HFmמo(ƴUz(pwŴ,G4M4ʫv]+b(#+*#*2]UvV٭皩L`.!,4H'-חש%ګְ\.|{5#+D([j"ѵJdjG6MUQThڋbeѣe6MC0Q*(i3QBU!"ԉ	"&־=}EF"V	IAK/>5=co^ ޗ o 9Ƽ#+xCF	* H0-@TH2>xHB`$VA"!'1^Ff_`DUݝuvMՊJvsYSmiez٬Qkv[_fYȌIbB)<J	ȁMHT!ظU݀VI#)HhFAU8amJW\5#)7SHNgkxl[O@{~q>//cߒ'f?z]h",'4By"Cd?k62cWs$PcH%qHښn$a#ɷ5/f;7	H\<v!&<&6C2؏Zxs<d*uX rIҪ}FSKa0ȟܛZvS??#+<֍̥薊RY0`RɆ714*,+d'.r_XO|Ж!!4fr1'V<pT6*ž2uJҪH(pt'y.3}*ߴdIZڍQB	D!E,-ɤlFbPH"0P]h;a9a/0(ϝ H;7]|H`E#)#0YZ"%Xb#*2%%	2J!eUL'0"*DwHEc1[jbRUyklZADP,)U.@0'#+sZ9kdfQ!QjJq%X#+	QmL(QV#EmPnwi""@R^#+\6#*[<'}QI`D"xx|8cgb+X#+Ims~xgmSC;k[rM.Tv0l%ݻOwuZEU:TD-!$;@ gf_Y f9Xrg:%S8Ԁ'^f'J$RHBN' 6F(XqO_ݾO?9#lu7PQWFeQo8l5$TY˟<>*]ߝ_tSlD{Dh;ePL5z',<eCRa͒14YE#)غP)X0dUi a뵑iJd.M\ETm^ˇ)wqP7szm9;T[leb-?Q=:蠝٧VuZDj]b k!wIB.grV&sT6Jh#+*JEd`2	Ld?^F66<ureͫuefȚISj<jMh&h1&\U͍w]発]v9й]ݺEsxɪ9yܶem7-sZ-R6b2ɲxn93"U.uƎVmM(e,#)p@,7D+ۻJ#)`vy8#)@8-@@K*	KbSuy2R8 p}% H"hw{Ca,TmT#+߽?_qn;jڱ?7\QաqPU"TcJ(l#+EEQ4vS!#)@V6աKC6ʛ7ںK_]76΋SVE#*ݭmxed	eKۦꀴZCRh^U(O]_	tɒedQKdD#)@Q\TBC%ӶzXDHQoFE(iH0hi"@0P\5;'\)OVu?he~V)TLaRa?Om`5z$#*^#+Y#)JզԪZ\wcf@tU#KLj+m~bmW$af"JYE55		rጏHQPk3mK_\8#+h.xΒJFqo\>3120O2S|+ߝг pȴ0d"Hf$g@jZ.F"wvw[shZ<?έ}JC-嬟(qZ#)#*Ic+$ak9z]FݶM7	$#yM\⨷#+R+X0`̖މPF#+#*\*RH=6In^kmxhM4LmKa٭*~.$રrBIl%#)#*:A%[Ka2S0L\ҲubX#(S#+Ah%%@ZU˥+$ l7d368`6h"I6X==cGy/(ȰeCABvbA"~q@F}_#+2F0&o4T#)A`ĀQ*@u" BDHI)b-@[0lAjB);X M[{bpLН0#!*Q!ik'nmP9JV&-&ԺN3Ata#d1k+S\c.w[I#L+ǃQS1쐊Ў\+rf3w|5)ʫmvWz%輠HzD<BhSIy8C>#+~ގH<ZRH@"%G ZcmJEbF$#)c<wS(4Il0P>D	 N#+@wVt.iM7X)`WGS`r3#+0$уHX2Ze> 0	A>-%=izDȟpE](cz)opV]V`ϊ("o6gMa#KdTwء[r,昵t3F؜,Ե1*FL"mQBqљ^^SD#t]#*)"e4M\⭨\ZL{Pc0eFdKHXx'o8olPCoVW8d_aUHAD:m97scN[[N}L#ò9US9lɛs'}nc?l["!,jۄ{cCԿښ?ݝ1,)4s<ޕd,]Z6GcLc$ i"1Eن8/.!0Ua"bcvC" ϶_LIۂ1#+bMZl	 v<֓ͳ`WWḾ"LgL9}})ikˬ<oݥE>۬m=AbD`KSxDx'J]1/6c8Cg=2ًWÜޙ=x1\H,+GH#)IR}ʔhINu!7iy2mBw_}▾ͣ2gw#*Aͻv,	CkBfk$CLACFDRiL#'srf'fv#+#+4y =`MB4>|y(IilQ`l_3-FF27TPv:{oO#**3+ WsDBGҩYdfP?s8j2dk2?wb#*B_֛#66[x󾮻6Õ5vŕ|HOd\{ۤMS,a譞!nJw [kj]ȶS@2NRczǥC"`u*5`BCA3³ti	F$eM˴#*}܌Hѝp3ɞ1-3Xk"9E>Tۦ0]#+9#}Ay$M@GBy#+I jf=b/"dėe9֑*-5<Ee,*qIZ,ygЧ{K0lf!:ZH)J#h-߷;H#*aO,	;'$O@0()`_GX7|)"$@;炤{kWC37xn8@|=Y"Ý1B6ԌaknzlQ\xD 5t-0@|jK39*cq-#F,SDP(= #*%@EET)5W+qϻtz7<=M}}9ەW3t9ZW/m@w(8O-'4@!#+B!HtfgX<+Pz+4jmLś&h!`ia 8-k5ZC#+c#+H %#h/X`UjI"MG	M#)xGWIcoE4k3>Vg\6өCqE9lB0Ƭ'y!]iws/+|oZ-ԗOM⓽]{"$#* ;|aNQKD˜`قDJ%P<=>[h&jz%̄EQT"@/.)^:x#*sq&x@/Yux,8GAgov(I h]EmY]2c;vI3Yxa<QtHmJІΘ~HX˨ܝk9s+U%-PRɌ>'s=P=t"@64ŦJUjY+TmbHP"*xav=I ؇jtӏ'2q<FX@#**U@>?+[ȥRDQ4%5D%DYHbhY46fd}˻lnq>-A;I$xE7s~ğ)I&jPrcl4&L4aK7tzh%`nDxOa,GL2ӬW]bذ:aٝ4EoNv^r~>y3(oi1ЌL_#*i5U9|QI?D[16#*vU.hzЊf]#md*'PM#IPRT)&SeNRT&Љ?v|HTQ@k-TJR9;Uf-]lY՚BZ&Ȇ#is]]k;󼁐$3b#1AxBc"PhBa#)3@R(cIC1A&DCB8FU#*V5Wrrt֪3W0e#)tB($&Blg4E4o	#r'*pees4~/S##.,#+Tr0szU%\mr5뇮/u#*L2$bzG33֬pi˦ނ4cq"<yYEotzHtڣ`3RIhUT#*1țc 2mM6M34iM1#*H2lOCnDV).T6x!fE\ZDn@Jpc8uPRJT-1\Iv]HPȠMwhهOq*A)V(SuQhkF#*QcSOyl2-)m]*"`)b)JVV,!Y$vS >FH.Ǣ|rsid=ֳD`]i3#+z oP4ºY`[Q,7i62HɭIA1R1i`ӄ}2#***0R;iC#0c81`KVQW*cB,2"*/0#*b%Aw,fMm#emVBCv8HRRE\Pɑ&UC-M3a W噯^uƲyHiA(4,h#ʹ-BCC$4&H"&coUJ&zcl:: CQtN0fi闤LXih!SQXi7(y؍^ϡd"{aB=%!KoXETDp6z$!(cbV#+؀%BіP@RslJZ%Y0Rac% t PKi!Ch(%EQR`Fp#*cxDdRD0#+hTCw#+~%uӹ-}IAZU-QbASl{@?up<2D2RAѕerP*ߤC ;Pv˖-ު 8։ꢍI*..#*RkTIZemuHr4H>ڔxס4'G]>9@J\(t@:eDri`AڣVHRR'#*,H!ȊW[m.;yJꐣCPl2؝ 1ȱFlRYLAa'(Y!Đ/cn+Fn3#+h>)`*XlLҲ3.X	sIܾٱ~Xxl=1NԘ#*/=IfU" e7LA^T1|#)0CDXV_ЀcP'92T;L/#+g	;F7rt$GLG{|@H&0VD~5t܇27@gmٗgg&kN$)-#*+t2aiwma`A_}AN1CRR@J+蝠di!S`xH\݊֎Vrtʰ+) w+Ŋ|#+TQ80xV[6+=9MeĪvm1BXfug1MjֽglEUEs84(41&e!C7'3#*I9x"+2 	RBDd))1-pͱXsrK[tH[rmVMr[x{5ȱM1F^*wV2#,PVIrt(ȭ9i30k0Xy̐E#u$B(o4@#)#+oJ&DDvݿW?ѓkAT~B.gT?ihoX>#*!7ΊDTEhZ#$A`O#)xdl#)LDEI+[i6T*RlDp"IowPD[oڥi54UT,|T,#)?ܠԠ?U]b#+}S$M$L*T^֔|:DEP#);f_AOA$;&䬇)GVe}u uP͡#)E#) }WҴlJPlcEHFb#*()IRMBDmQ[QԬ֙jQb*mZ$ 0pVEKaH0n<h#er$O+A\ӝ#NJ;`݈Q@BI<t!QXI1%$ABl 8-D(b(U !QDB"aaFX	*@,>p}-jx諳Swtnz`R^#*#h!A`![EXکCt	u0y(|I{ϓ}W>@Bн}C6is^ߜ44aDEE#*("(bJE)1j}ef=G)p20Pb_[`#)a_نt;!BwT+VձJyeԩLOU6jsU[x0^YaVYFƳ$sŷfe *>՜vpn+fqk%o?QZD˰eJF?+8]M}o֯wt3ΒT:vhΜ~vo癭2DC$mYު<o-Wkώ?-c!J t;?LǇgKw6C8[[&>W^0_Fr<<v,'KnOcV4уD&Jײ8M(`.zsl0sm&ZY|m.6N˹4g]*{(.x'\a-589v"+L'\p#m_Wo*\(ډ*fOIT/-BdﴐF?ګKtn`BCNtpZt0zdK~A8;Y9 `!ڝjYvBąO=7H"W|-rr<3sҋɹ<tWK~/ik³khj8j悖$ϊyס1R}#+|3ۗVrAMc;lqMxtڊnK8%KG=aq,2:z/*End[=b/ӯNs.!$&rNBf!'O,&Pk39Wv6lMb[<k<KkiȁMsRﶞl[5IDmqW5O1sޥG^<٭Uԩ$wE	<*5^FFp@ns,. Ϥu7b#*~^lh|YyYcXjH`VXJ˗E',zB:}!O(<xEf^`#*S)cE+uIݶ8s<_SpvE<Nh9m>%+\t:ζt]<m	JnѵW7(C7qK	DߵLmϽ6蹟S{RSD<Sۙ7wړ:_3#z"}c)UPR=聦uk~x׋۬gXmwDo>^#+ZoU\d+;=a~0cwwdIeX@#+iym#*<U18J,ʼ'٬/l"9+tc!,cnqFX Ʃ"X?yoy0Pڌ/iysdn7:ySwxjGPPnc~$̕t%˽S$9m*$,	z3.{TD6C0;*wܻB#iװobC,6nƲnrϖ|b3x0rQ;_-B4sb݄6Q׭tRsJQS]3H}3LNxih3T:]	" PJ-̡W`z$#`D#*`tScAnladLC @;3#+`F$!PRԏ>j!kwnYn#Y@iV$sc#wSDb#+0!a.yf0VD²M.\«xna#*(*8I)4ac9%Fw.O")[{/+Y|&xA2rLWJ%g?B2<ˬk6l%~\Vghz:癎?pC:TP*҈r8,,~,.#z +mi284acl#3~0gdOD3}UӴNXLKC	b_ȅ>.y0 ޚk6Zi>CMkE#*'VC1~e/]a?*j(+e@#֢I0K0!O^`EoC`;2ѝ#*XyUٸv鉻qmA۸mH^mw7EOvin=NhY o1T}G:7M$h;G15S 5!=i6JS_wG`Ƒ	lvu$R!ǉb6fF=tmZ1Ƣ)netŉi(}fu`p%`^:t)tI#ۋp#*8,P$D*I50-qZ#sЙjȰsҬ̖^	LBSOVSj0!޾rȹ`aY˞'"6g=0lpn#)rX,d7hv9BTyzH]B<igHuPZM7g14AF!raf!aè3`4KLĄ3mNU؇00st#*O-6[[dtCf}!nZ>5/|JLzsiBnsU鬍ad0#+\+:#sRd3FLq'9K镺ҹi`#)fD0WjJ:wI'evmy[l&ր`{S''#)lͺ>洦17plm2?1{u[Jdml&APm3CDe(APl20i MYF94	Q	"#+cBHjoMXbޑ	B	)!PJ8RȂ6`5#)FPTҊaQFR0 ^#*=g2qBm]7L[[B^GdTE7=t^6W1ɱVj[W-TmW^2#3l:ZCkǎ[-NU1K+tPd/io#*hHiѳQ+^3J݁ΚӍ%Yxk)K^MQCR"0Qq.aD`3(Y\ 5F"ȱd*E,R4!W-S(S:ŻR:I#+^|{Sx#7NB&d2[hqዤ 6.S6JabnF;24ӎvFjh)!bckZ2#*cYq,5C\歕0mfÈoz7"(([	iT9VoL#N2ag#+agIkN4,*Qm֭RU 3ytnМɯO9x-B@had!";mZr˙_37er^h9#7	R tZґ'`N7N8W*L9HQGgE#+Bd֩U2BgyQZT!Ipt+dca	Yn#+*ѐhJhpM6ţo7LY]9fn]>tdZȩQZcA*W(kDh0(݌[\0:7%"&n%CEㄭe<,*Feǳn<ћ¦km3d)w2%+jBd"+M1֌c4-h91O=3j:wkśıqɦ3N/*BhS[FZy2e@F"%Z0#+=iǫ5,1̦ ANxe)$Ռ鶖\d#2͝jȘm,CB̜:#+ebkw9*h̐t#kS(k+df`CP625oY^F:&'"ː9bi`nM>Kɪ20DJ;c${P@Wg@	Y7OZFJkK)>#YjD;!oRP3S¬f`XnFUR=?FVV,sq3+ziO8꯭`g% -	#*\R=	ÿƫ{f)5X03iq<#+S*pyr寇:㉵F6L"% :rwn͛7K=5չz/Q:Am2:x<0 ^`}MnFvjIWZtm(#)#):<y/ٺU#*T#*3VQ(ɌbdƑ5M5bmd-kkVJ4(Fь3hSJdm2TF4Ĵ eK))Tm#*D҄($$)Æ%31AT2}.{{:j~";nhy'$@+[f¥s;D?`VA m'0/Z*HqNPa9"H	*Y4VƴP"7#)H:4ӡIx󁉰`I$4b(axUS󋿣|=]"giZY,+֜M.S{0I#*Q%TEP&#TmZfƥ#+MF23HTbDJ}a,˿ "HD!~:mFV7>7.=I*b\C2jr]J82V)#hTPABVh Z@#*0Dy2%1bMubywn׷^fe5ٷ)7%fVoQ m;9PM+B*ADȬcTR<݇e$LA*x2!>Z#*ch:ȯ)W!Fn17-q&Ď#*cc\Bkg6#<]mH+T7:`v`9$!1$}Q<#)Epf%[WyS5֚TrvII$#){xp#)]SYQ$P#+wS|nǎGy#+}s9ߵ-U.dHH?nqvFr@|>4g #)DPMb@|JZ%!g]vO>WaA0	hAxX=NS	<6BB1IYZp#_qR:&!iaB8DG@fVX&jIi38BAf-LQfDFh.t]G0wZٷ;53`Ƹ|)olHHd_#aĞ6&&{PxVc7%*U#+ai?3b#*1$dAů%pQ8X˨*wFȣswʌ\a(TDZ>9::fL(Q<#1bP9¡.q/t5R_"PTR߮<VQXGqkl Gc	L-Hg:q??l=*Y#+,0!cSx5zG;qAbyP}8g֓}ߔD~ȿԪA/U\{ge8wƳz$919+6Ѥ9$j-^Hr85T#v#EUtp"D=<jg/Fċjhe2v`v(jR,7]/z`JZSB*KA/Rh$ÿ.M^=82{D'W?"D<қK1GO9PqC9پs a0, ax0;QƐnSGFy~AO8^/QPr'9Av Pͤ#SpC&9 *PT:8QxchCVbLFҦB9@7)d#*MAKxR>h@gKI-7 ci#՝#+#)xH*pT`劑2XV17ߍ]3MltX]ӫۡJfH95q*OkW#)Hn]%SS!2,5	3EDx]vmlۡRGZkYpJ^v)3>^`&zĥe@9e!\AQDj)`	b X e	X#+ɀȊ	HZ`mx-mT<i4J]EDSPEU$ɑvtGlʸI?"G9;+#+ @Cǣnb>xD^PMLkA	\as&!I&ʂY|$qQcQLěI ݶi`.G*:UΦFd%%oZS̹|i}"qi&#F7״J{ƃ +UbdZPv߱ۍΔ9P5"j,.k.7|BiYs(qtE޺/	;Ƨ\G 1ù+_+`h4PdC=: qV@|K'̶h9MHҌ!Zx{P\˻q47bض\@r2hM"zN*{\tHX+Vn-vD8Nxԁ$3%,t֭kl\&#mC!׊뜣WC]&$XE#+56ɛ!dhm^]04qs:Nd]̜h7Nf2ᾜPnA\ĄgG#k-^MvLؓjL2ʂF@<A1@!Q#&˳5A>Ę&ІY:tִynqka^(	lA#)ƝO//عe9{Ju;4԰ژbq-B\^(sFp LtQ63Grc#*4)sO隶hU$2iScyu5yScPCY>[Ll9tfd]:1L}.B5pI/ɫgLVHѐ)<ia5XN; gC*#*oAoݮ쨄7(4S&z-h}Cm`~{g0@̷wnՠa8JP-#qĆgj`db'TDhD1fgȊÃDU>#)m6TٲhTsV)ع):xݓdP=<3#3GowkYٜA=xi6I0{vM4ߎKq;5VX wkؖuA|;b7(SBkRc6	捜k#)eAU.3>#$Pm=3$pc}h(IWJkq<n\rLfGT!Vݰ@Ɠkp6-ACp7r83Y"@3 1oY#*'4R"\1,Mm(@GfX@&#+XU76#V	B4!JmYUD3f)U.vA(t#+,ASfb{"#+@ġՊ#*Zl$v#,ȧaUZm#+20m@,5/BHp:# 4:CJ*s$*,]S2ab]/.uET$g}}ͬtFQQ@c^^|cd'.p!pr#*@!r@Y>ն:vV-Es[ib_Xt7Y:(4p7XSro-[<IhGuЮmG#*$͡#H;\ZYwR 6ӂUS('g.+J)8d#G	6 6x8=UɱsED-Fh<K"r`eȔsdOJ12_Ew9)CZc8D90f-Jq	.,y׌6sk9j&-l#+W}Heǋ>ju"eY/`g.LD(BS|V1n9L#`	Oa]-@TR`F42 *D&y-%wsdsҹ$˪#*#*čSfD)-#*^E5R!Lx	#*nb&RI<Ff#34uP&h⨐vv|aSfk}*tNAɖT[MQW#*VK)6#sl.#+4XD"b0¼=#*@.$%'C{ㄍ^x=7z)G!USYI=HBDg&#+1ZŜKvXaSS4ԌVmʭK1#+&#[3>q.5#):Ba:P"X#+ۻIQ{phm9RᦱQ23ϢfhYw~6+F+{Rqtkʌʸ@)@f-ݭD[eVҐ%jf@\2Pȃ#),#)TD$U!ɀH"dqEޠݑ2KײP2#)7p½h	hI i3	), Ȳ H=2˧}duQ7݇~0`2#~LTrpvthgĮ/_UgLl2rb#+5D0\bFh\!²\ZITy滲ٛ;%UjRd^en( 35YA jVEm# <7RPA#*0\?@wr[zb|z+00U#*zF8H/e:Poø;'" \v:	zjBGgQf9#*@HuR"thA=4wBqkXXrr2ǟ]}Bp֗=y!,#+akjMlmD9NL_Sݘ8Icw:rbF#*Œ~BZ?-V|qB=i@SaTXb#@AMZ1Cf^$?R}ݽ[#+'Z4[hm&ʖZcDUm	"Kf6&Ěuvچs]#*͑vw#*<Ŋyj6#+!<W54<M#)qbcw)v;`,͟Q	#)<n-*k=={}R( hԕnBINΌ&n$Gr;VF\2DxMW!iF0$j`AOpS:n(20jW.>tDA`MYhe E$R&B9RՀ;qp`@2WqEMniYyhZ+}oz)pö(#*U AGɉASW*p|@|ANɵ|S+"77"Z#*Jj֔Xpm.~(3|c |\0pn}pfp:`f'@=Q|x(^?@FB.$>]'z֏ak)7_pT 0"!1#)tPvBTz],|-S=$J8^$ZI #)J1zp.oՔ1dCPA*xtG,vb3tY(U8aي3DH>C>_G~Q=,W.ϟP?6G2Se9"[>8m,.^'ѓo5Ŏ~rJzvyfbBB6ō$5#L}[G9n^	#+%Q/&k^Echx-6+yvdvۮт"s)HeO?_WǠ{3$i꾐SԠt6*l1fԵ&=ǩ<m$DdXRc`,ɪlF_NȳEbh%h0;D%L0jJ1pau<7A	za|%zu6E6-lՊ-3X-U.. Daa!^^XP,A/@Źyc>x.I<U́(OAeMnBٶ1>pLõWD{\1G39 dy{h,,a!L(>VA<=1@B1HqWO	p!x#*#*X@4S=D@P^[kn|WFIݻZYFԧio)0j_a#-c'ft#)%#+xʔב`BEeی#+[vo7Cʣ&HaiEW4%>&8BsL*5XT5&X8وf|0Մ+NelgbCvz/~z?j(%]T @iI*)lb66RѺmaXaI#)FAVEO󧯲c%h#THzAЫB1)@	iajrQ,bQ|8#*סwb#)k#[j-hƴRКm		GC;Ye0Q#+"h:F"JK(ƧQOGU)m?c,fD6(రRNy`NCE!-,yںooYJ#+vV3ZE[ҮJyvfUuQW;PIl6.imwuwu*eLM#+#+D9)V8t7-M֘E^TjLJ[yמuj񱴣4l:wn,elkZjYΩdFu	Vmf'кB!}eFC`lT|cYפ[FhL*&^1(ߣ8dA2Qr{v3]S#)`=p!GSzt(o6r`j8p`TkM縗׎y>_K#+M#*UJ]/αo#*1=#+v}y"8qHEpoa1\t׍#+-)4qdEٔ:3@俁:}V]J[E'#)@aw9I8&MFCd-R&3򜽋YHPDSyT8ǁ&5ّ{z0!/Z޲gSȞؔN,pSr`\hkV.b؄i!#*N6#+#)uv0@߆`!gz˘."R+ABj³Jg/RL+)͎Gruv]8P?W/64r867WpiU^4=`F,Aѭu/ظ(ouYsE#Fgdj"+3A'tWҭKz6*P#+ah҈/+n]|,g\hfZ+iKc/d35J*%%jډmb(d7YE#*dZO>wC1EUm>&ڟ!G<rHH,C=C <谠&Jd>0ˋ񱟙]y;Ze;u@R}@m4 M	".#)n^R"9l##)̡l^#!VԎcTxR.Ec#)~g #)o$4#*߰Q#)p#+v2ڸz"TEiCYS2Wk)#+$=m#*Bz0#*EB)/A	[y߽O;D 3>qv+#)w#+3	;/EPa5EȔc>&aMf #lxY	?W!q{u[u<}#)zZ(:۸`fŏp R31)*Ga"y&33D'/Txoj<lz|({F]"W/GFࠢtI2B:wVt3x7*χ~yɫK,ؔ7^d+;YsvSRD75Ԏ1٠%dC*`ƌ6#*"4B)hKw0#B;;tЯk.$%S0B`ɤ7;Pj۴pc+#+6[ẰuyȚ$l[U!G	fw$$0CqϳV-9R6ws!C2y{5<h4VXsXy<BwYabhwŮ^{f2@:~xCouԦ^EKN4lƊzb)\}2Ҹt>jNA=y^~%)Xo]pl\xlL|bODURC`xR=>p1wfMqKSA?×}ẹa~y$ҒBqcaA2	s\6P)b2H<q%vٰ#)$H$3Hsx#*EYP3 	bfpϖ핓>VܗEb1VL(sH&Cio/կssIki蚉Ch6Ƶ4VeI%M	M(PBH*# ?1X<jhm0X$ HZ2.ɠ1.ԡUWjoA"3z#*k$uJ~iNury2`u`/$mVUr*uK(xti#*|golg,r.[I߻rTfj2Lc2S?0ttE#R Z1*!j8,'ʋ#*Dps\Au](WMCGoZtT -[|c^5[W1Q|nV+ŶWjަԚ-jkxu@]ut,\9ȣS#$P?@Q3v;.x@2eX[տy%&߄ŏTu#+`A,z"#*E	sk(hHGWs|+_bQU#)#*wD	Qb#)iV-_;Q6m&Z(7A&ΉIc h<aml=h&aZNy)FB>e^/嫫dO/^\U}%tH9~0z9"Hq$eڒwG)n_|sc6Oq~?)n֥nׇ}*\|=ݾtC<{T6gJ]6dÏ(MD&B;6iI0֛	7@	/mJi)^op	u$KܣUһxULڸ\e|!m:v:>sR!Yƛ)O#bqQ-z[R/0t+!	[kT*Xpzx4\os?+Y$&l]JAuΖL	[oXL>BOF`aܑN$#)
#<==
